#
# Copyright 2009 Canonical Ltd.
#
# Written by:
#     Gustavo Niemeyer <gustavo.niemeyer@canonical.com>
#     Sidnei da Silva <sidnei.da.silva@canonical.com>
#
# This file is part of the Image Store Proxy.
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
from imagestore.lib.jsonobject import JSONObject, MissingValueError
from imagestore.lib.tests import TestCase

from imagestore.model import (
    Image, ImageFile, ImagePart, ImageRegistration,
    ImageState, ImageSection, ImageStoreResponse)
from imagestore.tests.helpers import (
    createImage, createImagePart, createRegistration)


class ImageTest(TestCase):

    def testIsJSONObject(self):
        self.assertEquals(Image.__bases__, (JSONObject,))

    def testRequiredFields(self):
        self.assertEquals(Image.required,
                          ["uri", "title", "summary"])

    def testSubTypes(self):
        self.assertEquals(Image.subtypes,
                          {"files": ImageFile})


class ImageStateTest(TestCase):

    def testIsJSONObject(self):
        self.assertEquals(ImageState.__bases__, (JSONObject,))

    def testRequiredFields(self):
        self.assertEquals(ImageState.required, ["image-uri", "status"])


class ImageSectionTest(TestCase):

    def testIsJSONObject(self):
        self.assertEquals(ImageSection.__bases__, (JSONObject,))

    def testRequiredFields(self):
        self.assertEquals(ImageSection.required, ["title"])


class ImageStoreResponseTest(TestCase):

    def testIsJSONObject(self):
        self.assertEquals(ImageStoreResponse.__bases__, (JSONObject,))

    def testSubTypes(self):
        self.assertEquals(ImageStoreResponse.subtypes,
                          {"images": Image,
                           "states": ImageState,
                           "sections": ImageSection})


class ImagePartTest(TestCase):

    def testEquality(self):
        part1a = createImagePart(1)
        part1b = createImagePart(1)
        part2 = createImagePart(2)

        self.assertNotIdentical(part1a, part1b)
        self.assertEquals(part1a, part1b)
        self.assertEquals(part1b, part1a)

        self.assertNotEquals(part1a, part2)
        self.assertNotEquals(part2, part1a)

        self.assertNotEquals(part1b, part2)
        self.assertNotEquals(part2, part1b)


class ImageRegistrationTest(TestCase):

    def testEquality(self):
        registration1a = createRegistration(1)
        registration1b = createRegistration(1)
        registration2 = createRegistration(2)

        self.assertNotIdentical(registration1a, registration1b)
        self.assertEquals(registration1a, registration1b)
        self.assertEquals(registration1b, registration1a)

        self.assertNotEquals(registration1a, registration2)
        self.assertNotEquals(registration2, registration1a)

        self.assertNotEquals(registration1b, registration2)
        self.assertNotEquals(registration2, registration1b)

    def testEqualityConsidersImage(self):
        registration1a = createRegistration(1)
        registration1b = createRegistration(1)
        
        registration1a.image["foo"] = True

        self.assertNotEquals(registration1a, registration1b)

