#
# Copyright 2009 Canonical Ltd.
#
# Written by:
#     Gustavo Niemeyer <gustavo.niemeyer@canonical.com>
#     Sidnei da Silva <sidnei.da.silva@canonical.com>
#
# This file is part of the Image Store Proxy.
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
from imagestore.lib.jsonobject import JSONObject, MissingValueError


class ImageFile(JSONObject):
    required = ["url", "size-in-bytes", "sha256", "kind"]


class Image(JSONObject):
    required = ["uri", "title", "summary"]
    subtypes = {"files": ImageFile}


class ImageState(JSONObject):
    required = ["image-uri", "status"]


class ImageSection(JSONObject):
    required = ["title"]


class ImageStoreResponse(JSONObject):
    subtypes = {"images": Image,
                "states": ImageState,
                "sections": ImageSection}


class ImageRegistration(object):

    def __init__(self, image):
        self.image = image
        self.eki = ImagePart()
        self.eri = ImagePart()
        self.emi = ImagePart()

    def __eq__(self, other):
        if type(self) is not type(other):
            return False
        return (self.image == other.image and
                self.eki == other.eki and
                self.eri == other.eri and
                self.emi == other.emi)

    def __ne__(self, other):
        return not self.__eq__(other)


class ImagePart(object):

    eid = None
    size = None
    kind = None
    sha256 = None
    path = None

    def __eq__(self, other):
        if type(self) is not type(other):
            return False
        return (self.eid == other.eid and
                self.size == other.size and
                self.kind == other.kind and
                self.sha256 == other.sha256 and
                self.path == other.path)

