#
# Copyright 2009 Canonical Ltd.
#
# Written by:
#     Gustavo Niemeyer <gustavo.niemeyer@canonical.com>
#     Sidnei da Silva <sidnei.da.silva@canonical.com>
#
# This file is part of the Image Store Proxy.
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
import gc

from imagestore.lib.event import EventBus, Event
from imagestore.lib.tests import TestCase


class EventBusTest(TestCase):

    def setUp(self):
        self.bus = EventBus()

    def testRegisterHandlerAndFire(self):
        called = []
        def handler(event, a, b):
            called.append((event, a, b))
        class MyEvent(Event):
            pass
        self.bus.addHandler(MyEvent, handler, 1, b=2)
        event = MyEvent()
        self.bus.fire(event)
        self.assertEquals(called, [(event, 1, 2)])

    def testWhiteBoxWeakRefedHandlers(self):
        called = []
        def handler(event, a, b):
            called.append((event, a, b))
        class MyEvent(Event):
            pass
        self.bus.addHandler(MyEvent, handler, 1, b=2)
        self.assertEquals(len(self.bus._handlers[MyEvent]), 1)
        del handler
        gc.collect()
        event = MyEvent()
        self.bus.fire(event)
        self.assertEquals(called, [])
        self.assertEquals(len(self.bus._handlers[MyEvent]), 0)

