/* streams.c generated by valac 0.16.0, the Vala compiler
 * generated from streams.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "gwibber.h"
#include <dee.h>
#include <gee.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>


#define TYPE_STREAMS_INTERFACE (streams_interface_get_type ())
#define STREAMS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STREAMS_INTERFACE, StreamsInterface))
#define IS_STREAMS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STREAMS_INTERFACE))
#define STREAMS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_STREAMS_INTERFACE, StreamsInterfaceIface))

typedef struct _StreamsInterface StreamsInterface;
typedef struct _StreamsInterfaceIface StreamsInterfaceIface;

#define TYPE_STREAMS_INTERFACE_PROXY (streams_interface_proxy_get_type ())
typedef GDBusProxy StreamsInterfaceProxy;
typedef GDBusProxyClass StreamsInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _GwibberStreamsRefreshModelAsyncData GwibberStreamsRefreshModelAsyncData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _GwibberStreamsRefreshTransientModelAsyncData GwibberStreamsRefreshTransientModelAsyncData;
#define __vala_JsonArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonArray_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

struct _StreamsInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*Messages) (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error);
	gchar* (*Get) (StreamsInterface* self, const gchar* id, GError** error);
	gchar* (*List) (StreamsInterface* self, GError** error);
	gchar* (*Create) (StreamsInterface* self, const gchar* query, GError** error);
	void (*Delete) (StreamsInterface* self, const gchar* id, GError** error);
};

struct _GwibberStreamsPrivate {
	StreamsInterface* streams_service;
	GwibberService* service;
	GwibberUtils* utils;
	GwibberMessages* messages_service;
	GwibberSearches* searches_service;
	DeeModel* _stream_model;
	DeeModel* _transient_model;
	DeeResourceManager* resources;
	GeeHashMap* seen;
};

struct _Block1Data {
	int _ref_count_;
	GwibberStreams * self;
	GList* streams;
	gpointer _async_data_;
};

struct _GwibberStreamsRefreshModelAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberStreams* self;
	Block1Data* _data1_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
};

struct _GwibberStreamsRefreshTransientModelAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberStreams* self;
};


static gpointer gwibber_streams_parent_class = NULL;

GType streams_interface_proxy_get_type (void) G_GNUC_CONST;
guint streams_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType streams_interface_get_type (void) G_GNUC_CONST;
gchar* streams_interface_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error);
gchar* streams_interface_Get (StreamsInterface* self, const gchar* id, GError** error);
gchar* streams_interface_List (StreamsInterface* self, GError** error);
gchar* streams_interface_Create (StreamsInterface* self, const gchar* query, GError** error);
void streams_interface_Delete (StreamsInterface* self, const gchar* id, GError** error);
static void streams_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_streams_interface_updated (StreamsInterface* self, GVariant* parameters);
static void _dbus_handle_streams_interface_created (StreamsInterface* self, GVariant* parameters);
static void _dbus_handle_streams_interface_deleted (StreamsInterface* self, GVariant* parameters);
static gchar* streams_interface_proxy_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error);
static gchar* streams_interface_proxy_Get (StreamsInterface* self, const gchar* id, GError** error);
static gchar* streams_interface_proxy_List (StreamsInterface* self, GError** error);
static gchar* streams_interface_proxy_Create (StreamsInterface* self, const gchar* query, GError** error);
static void streams_interface_proxy_Delete (StreamsInterface* self, const gchar* id, GError** error);
static void streams_interface_proxy_streams_interface_interface_init (StreamsInterfaceIface* iface);
static void _dbus_streams_interface_Messages (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_streams_interface_Get (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_streams_interface_List (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_streams_interface_Create (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_streams_interface_Delete (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void streams_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* streams_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean streams_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_streams_interface_updated (GObject* _sender, const gchar* id, gpointer* _data);
static void _dbus_streams_interface_created (GObject* _sender, const gchar* id, gpointer* _data);
static void _dbus_streams_interface_deleted (GObject* _sender, const gchar* id, gpointer* _data);
static void _streams_interface_unregister_object (gpointer user_data);
#define GWIBBER_STREAMS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_STREAMS, GwibberStreamsPrivate))
enum  {
	GWIBBER_STREAMS_DUMMY_PROPERTY,
	GWIBBER_STREAMS_STREAM_MODEL,
	GWIBBER_STREAMS_TRANSIENT_MODEL
};
#define GWIBBER_STREAMS_streams_name "com.Gwibber.Streams"
#define GWIBBER_STREAMS_streams_path "/com/gwibber/Streams"
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_streams_streams_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void ___lambda10_ (GwibberStreams* self, const gchar* source);
static void ____lambda10__streams_interface_updated (StreamsInterface* _sender, const gchar* id, gpointer self);
static void ___lambda11_ (GwibberStreams* self, const gchar* source);
static void ____lambda11__streams_interface_created (StreamsInterface* _sender, const gchar* id, gpointer self);
static void ___lambda12_ (GwibberStreams* self, const gchar* source);
static void ____lambda12__streams_interface_deleted (StreamsInterface* _sender, const gchar* id, gpointer self);
static DeeSequenceModel* gwibber_streams_create_model (GwibberStreams* self);
static void ___lambda13_ (GwibberStreams* self, DeeModel* _m, DeeModelIter* _i);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void ____lambda13__dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static gboolean ___lambda14_ (GwibberStreams* self);
static void gwibber_streams_refresh_model_async (GwibberStreams* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gwibber_streams_refresh_model_finish (GwibberStreams* self, GAsyncResult* _res_);
static gboolean ____lambda14__gsource_func (gpointer self);
static void ___lambda16_ (GwibberStreams* self, const gchar* change, const gchar* data);
static void gwibber_streams_on_refresh (GwibberStreams* self, const gchar* change, const gchar* data);
static void ____lambda16__gwibber_messages_message (GwibberMessages* _sender, const gchar* change, const gchar* data, gpointer self);
static gboolean ___lambda17_ (GwibberStreams* self);
static void gwibber_streams_refresh_transient_model_async (GwibberStreams* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gwibber_streams_refresh_transient_model_finish (GwibberStreams* self, GAsyncResult* _res_);
static gboolean ____lambda17__gsource_func (gpointer self);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static void gwibber_streams_parse_message (GwibberStreams* self, JsonObject* obj, const gchar* change);
static void _vala_JsonObject_free (JsonObject* self);
static void gwibber_streams_refresh_model_async_data_free (gpointer _data);
static gboolean gwibber_streams_refresh_model_async_co (GwibberStreamsRefreshModelAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda15_ (Block1Data* _data1_);
static void gwibber_streams_parse_messages (GwibberStreams* self, const gchar* data);
static gboolean ___lambda15__gsource_func (gpointer self);
static void gwibber_streams_refresh_transient_model_async_data_free (gpointer _data);
static gboolean gwibber_streams_refresh_transient_model_async_co (GwibberStreamsRefreshTransientModelAsyncData* _data_);
static gboolean __lambda18_ (GwibberStreams* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean ___lambda18__gsource_func (gpointer self);
static JsonArray* _vala_JsonArray_copy (JsonArray* self);
static void _vala_JsonArray_free (JsonArray* self);
static gchar* gwibber_streams_gen_text_id (GwibberStreams* self, const gchar* t);
static void _vala_JsonNode_free (JsonNode* self);
static gchar* gwibber_streams_scrub (GwibberStreams* self, const gchar* content);
static gchar** _variant_get1 (GVariant* value, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GVariant* _variant_new4 (const gchar* value);
static GVariant* _variant_new5 (gdouble value);
static GVariant* _variant_new6 (gboolean value);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static void gwibber_streams_real_updated (GwibberStreams* self, const gchar* id);
static void gwibber_streams_finalize (GObject* obj);
static void _vala_gwibber_streams_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_streams_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_stream = {-1, "stream", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_account = {-1, "account", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_time = {-1, "time", "i"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_transient = {-1, "transient", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_recipient = {-1, "recipient", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_orderby = {-1, "orderby", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_order = {-1, "order", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_limit = {-1, "limit", "i"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_result = {-1, "result", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Messages_in[] = {&_streams_interface_dbus_arg_info_Messages_stream, &_streams_interface_dbus_arg_info_Messages_account, &_streams_interface_dbus_arg_info_Messages_time, &_streams_interface_dbus_arg_info_Messages_transient, &_streams_interface_dbus_arg_info_Messages_recipient, &_streams_interface_dbus_arg_info_Messages_orderby, &_streams_interface_dbus_arg_info_Messages_order, &_streams_interface_dbus_arg_info_Messages_limit, NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Messages_out[] = {&_streams_interface_dbus_arg_info_Messages_result, NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_Messages = {-1, "Messages", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Messages_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Messages_out)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Get_id = {-1, "id", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Get_result = {-1, "result", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Get_in[] = {&_streams_interface_dbus_arg_info_Get_id, NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Get_out[] = {&_streams_interface_dbus_arg_info_Get_result, NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_Get = {-1, "Get", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Get_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Get_out)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_List_result = {-1, "result", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_List_in[] = {NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_List_out[] = {&_streams_interface_dbus_arg_info_List_result, NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_List = {-1, "List", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_List_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_List_out)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Create_query = {-1, "query", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Create_result = {-1, "result", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Create_in[] = {&_streams_interface_dbus_arg_info_Create_query, NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Create_out[] = {&_streams_interface_dbus_arg_info_Create_result, NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_Create = {-1, "Create", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Create_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Create_out)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Delete_id = {-1, "id", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Delete_in[] = {&_streams_interface_dbus_arg_info_Delete_id, NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Delete_out[] = {NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_Delete = {-1, "Delete", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Delete_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Delete_out)};
static const GDBusMethodInfo * const _streams_interface_dbus_method_info[] = {&_streams_interface_dbus_method_info_Messages, &_streams_interface_dbus_method_info_Get, &_streams_interface_dbus_method_info_List, &_streams_interface_dbus_method_info_Create, &_streams_interface_dbus_method_info_Delete, NULL};
static const GDBusArgInfo _streams_interface_dbus_arg_info_updated_id = {-1, "id", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_updated[] = {&_streams_interface_dbus_arg_info_updated_id, NULL};
static const GDBusSignalInfo _streams_interface_dbus_signal_info_updated = {-1, "Updated", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_updated)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_created_id = {-1, "id", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_created[] = {&_streams_interface_dbus_arg_info_created_id, NULL};
static const GDBusSignalInfo _streams_interface_dbus_signal_info_created = {-1, "Created", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_created)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_deleted_id = {-1, "id", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_deleted[] = {&_streams_interface_dbus_arg_info_deleted_id, NULL};
static const GDBusSignalInfo _streams_interface_dbus_signal_info_deleted = {-1, "Deleted", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_deleted)};
static const GDBusSignalInfo * const _streams_interface_dbus_signal_info[] = {&_streams_interface_dbus_signal_info_updated, &_streams_interface_dbus_signal_info_created, &_streams_interface_dbus_signal_info_deleted, NULL};
static const GDBusPropertyInfo * const _streams_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _streams_interface_dbus_interface_info = {-1, "com.Gwibber.Streams", (GDBusMethodInfo **) (&_streams_interface_dbus_method_info), (GDBusSignalInfo **) (&_streams_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_streams_interface_dbus_property_info)};
static const GDBusInterfaceVTable _streams_interface_dbus_interface_vtable = {streams_interface_dbus_interface_method_call, streams_interface_dbus_interface_get_property, streams_interface_dbus_interface_set_property};

gchar* streams_interface_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return STREAMS_INTERFACE_GET_INTERFACE (self)->Messages (self, stream, account, time, transient, recipient, orderby, order, limit, error);
}


gchar* streams_interface_Get (StreamsInterface* self, const gchar* id, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return STREAMS_INTERFACE_GET_INTERFACE (self)->Get (self, id, error);
}


gchar* streams_interface_List (StreamsInterface* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return STREAMS_INTERFACE_GET_INTERFACE (self)->List (self, error);
}


gchar* streams_interface_Create (StreamsInterface* self, const gchar* query, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return STREAMS_INTERFACE_GET_INTERFACE (self)->Create (self, query, error);
}


void streams_interface_Delete (StreamsInterface* self, const gchar* id, GError** error) {
	g_return_if_fail (self != NULL);
	STREAMS_INTERFACE_GET_INTERFACE (self)->Delete (self, id, error);
}


static void streams_interface_base_init (StreamsInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("updated", TYPE_STREAMS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("created", TYPE_STREAMS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("deleted", TYPE_STREAMS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


GType streams_interface_get_type (void) {
	static volatile gsize streams_interface_type_id__volatile = 0;
	if (g_once_init_enter (&streams_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StreamsInterfaceIface), (GBaseInitFunc) streams_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType streams_interface_type_id;
		streams_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "StreamsInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (streams_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (streams_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) streams_interface_proxy_get_type);
		g_type_set_qdata (streams_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.Gwibber.Streams");
		g_type_set_qdata (streams_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) streams_interface_register_object);
		g_once_init_leave (&streams_interface_type_id__volatile, streams_interface_type_id);
	}
	return streams_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (StreamsInterfaceProxy, streams_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_STREAMS_INTERFACE, streams_interface_proxy_streams_interface_interface_init) )
static void streams_interface_proxy_class_init (StreamsInterfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = streams_interface_proxy_g_signal;
}


static void _dbus_handle_streams_interface_updated (StreamsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp33_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	g_signal_emit_by_name (self, "updated", id);
	_g_free0 (id);
}


static void _dbus_handle_streams_interface_created (StreamsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp34_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp34_, NULL);
	g_variant_unref (_tmp34_);
	g_signal_emit_by_name (self, "created", id);
	_g_free0 (id);
}


static void _dbus_handle_streams_interface_deleted (StreamsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp35_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp35_, NULL);
	g_variant_unref (_tmp35_);
	g_signal_emit_by_name (self, "deleted", id);
	_g_free0 (id);
}


static void streams_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Updated") == 0) {
		_dbus_handle_streams_interface_updated ((StreamsInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Created") == 0) {
		_dbus_handle_streams_interface_created ((StreamsInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Deleted") == 0) {
		_dbus_handle_streams_interface_deleted ((StreamsInterface*) proxy, parameters);
	}
}


static void streams_interface_proxy_init (StreamsInterfaceProxy* self) {
}


static gchar* streams_interface_proxy_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp36_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "Messages");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (stream));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (time));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (transient));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (recipient));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (orderby));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (order));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (limit));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp36_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp36_, NULL);
	g_variant_unref (_tmp36_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* streams_interface_proxy_Get (StreamsInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp37_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp37_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp37_, NULL);
	g_variant_unref (_tmp37_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* streams_interface_proxy_List (StreamsInterface* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp38_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "List");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp38_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp38_, NULL);
	g_variant_unref (_tmp38_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* streams_interface_proxy_Create (StreamsInterface* self, const gchar* query, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp39_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "Create");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp39_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp39_, NULL);
	g_variant_unref (_tmp39_);
	g_object_unref (_reply_message);
	return _result;
}


static void streams_interface_proxy_Delete (StreamsInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "Delete");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void streams_interface_proxy_streams_interface_interface_init (StreamsInterfaceIface* iface) {
	iface->Messages = streams_interface_proxy_Messages;
	iface->Get = streams_interface_proxy_Get;
	iface->List = streams_interface_proxy_List;
	iface->Create = streams_interface_proxy_Create;
	iface->Delete = streams_interface_proxy_Delete;
}


static void _dbus_streams_interface_Messages (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* stream = NULL;
	GVariant* _tmp40_;
	gchar* account = NULL;
	GVariant* _tmp41_;
	gint time = 0;
	GVariant* _tmp42_;
	gchar* transient = NULL;
	GVariant* _tmp43_;
	gchar* recipient = NULL;
	GVariant* _tmp44_;
	gchar* orderby = NULL;
	GVariant* _tmp45_;
	gchar* order = NULL;
	GVariant* _tmp46_;
	gint limit = 0;
	GVariant* _tmp47_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	stream = g_variant_dup_string (_tmp40_, NULL);
	g_variant_unref (_tmp40_);
	_tmp41_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp41_, NULL);
	g_variant_unref (_tmp41_);
	_tmp42_ = g_variant_iter_next_value (&_arguments_iter);
	time = g_variant_get_int32 (_tmp42_);
	g_variant_unref (_tmp42_);
	_tmp43_ = g_variant_iter_next_value (&_arguments_iter);
	transient = g_variant_dup_string (_tmp43_, NULL);
	g_variant_unref (_tmp43_);
	_tmp44_ = g_variant_iter_next_value (&_arguments_iter);
	recipient = g_variant_dup_string (_tmp44_, NULL);
	g_variant_unref (_tmp44_);
	_tmp45_ = g_variant_iter_next_value (&_arguments_iter);
	orderby = g_variant_dup_string (_tmp45_, NULL);
	g_variant_unref (_tmp45_);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	order = g_variant_dup_string (_tmp46_, NULL);
	g_variant_unref (_tmp46_);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	limit = g_variant_get_int32 (_tmp47_);
	g_variant_unref (_tmp47_);
	result = streams_interface_Messages (self, stream, account, time, transient, recipient, orderby, order, limit, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (stream);
	_g_free0 (account);
	_g_free0 (transient);
	_g_free0 (recipient);
	_g_free0 (orderby);
	_g_free0 (order);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_streams_interface_Get (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp48_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp48_, NULL);
	g_variant_unref (_tmp48_);
	result = streams_interface_Get (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_streams_interface_List (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = streams_interface_List (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_streams_interface_Create (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp49_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp49_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp49_, NULL);
	g_variant_unref (_tmp49_);
	result = streams_interface_Create (self, query, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (query);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_streams_interface_Delete (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp50_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp50_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp50_, NULL);
	g_variant_unref (_tmp50_);
	streams_interface_Delete (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void streams_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Messages") == 0) {
		_dbus_streams_interface_Messages (object, parameters, invocation);
	} else if (strcmp (method_name, "Get") == 0) {
		_dbus_streams_interface_Get (object, parameters, invocation);
	} else if (strcmp (method_name, "List") == 0) {
		_dbus_streams_interface_List (object, parameters, invocation);
	} else if (strcmp (method_name, "Create") == 0) {
		_dbus_streams_interface_Create (object, parameters, invocation);
	} else if (strcmp (method_name, "Delete") == 0) {
		_dbus_streams_interface_Delete (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* streams_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean streams_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_streams_interface_updated (GObject* _sender, const gchar* id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Streams", "Updated", _arguments, NULL);
}


static void _dbus_streams_interface_created (GObject* _sender, const gchar* id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Streams", "Created", _arguments, NULL);
}


static void _dbus_streams_interface_deleted (GObject* _sender, const gchar* id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Streams", "Deleted", _arguments, NULL);
}


guint streams_interface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_streams_interface_dbus_interface_info), &_streams_interface_dbus_interface_vtable, data, _streams_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_streams_interface_updated, data);
	g_signal_connect (object, "created", (GCallback) _dbus_streams_interface_created, data);
	g_signal_connect (object, "deleted", (GCallback) _dbus_streams_interface_deleted, data);
	return result;
}


static void _streams_interface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_streams_interface_updated, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_streams_interface_created, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_streams_interface_deleted, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _gwibber_streams_streams_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_streams_streams_available (self, up);
}


static void ___lambda10_ (GwibberStreams* self, const gchar* source) {
	const gchar* _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	gwibber_streams_stream_updated (self, _tmp0_);
}


static void ____lambda10__streams_interface_updated (StreamsInterface* _sender, const gchar* id, gpointer self) {
	___lambda10_ (self, id);
}


static void ___lambda11_ (GwibberStreams* self, const gchar* source) {
	const gchar* _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	gwibber_streams_stream_created (self, _tmp0_);
}


static void ____lambda11__streams_interface_created (StreamsInterface* _sender, const gchar* id, gpointer self) {
	___lambda11_ (self, id);
}


static void ___lambda12_ (GwibberStreams* self, const gchar* source) {
	const gchar* _tmp0_;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	gwibber_streams_stream_deleted (self, _tmp0_);
}


static void ____lambda12__streams_interface_deleted (StreamsInterface* _sender, const gchar* id, gpointer self) {
	___lambda12_ (self, id);
}


GwibberStreams* gwibber_streams_construct (GType object_type) {
	GwibberStreams * self = NULL;
	DeeResourceManager* _tmp15_ = NULL;
	GeeHashMap* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (GwibberStreams*) g_object_new (object_type, NULL);
	{
		StreamsInterface* _tmp0_ = NULL;
		StreamsInterface* _tmp1_;
		GwibberUtils* _tmp2_;
		GwibberUtils* _tmp3_;
		GwibberUtils* _tmp4_;
		GwibberMessages* _tmp5_;
		GwibberSearches* _tmp6_;
		GwibberService* _tmp7_;
		StreamsInterface* _tmp8_;
		StreamsInterface* _tmp9_;
		StreamsInterface* _tmp10_;
		_tmp0_ = g_initable_new (TYPE_STREAMS_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", GWIBBER_STREAMS_streams_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GWIBBER_STREAMS_streams_path, "g-interface-name", "com.Gwibber.Streams", NULL);
		_tmp1_ = (StreamsInterface*) _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch40_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->priv->streams_service);
		self->priv->streams_service = _tmp1_;
		_tmp2_ = gwibber_utils_new ();
		_g_object_unref0 (self->priv->utils);
		self->priv->utils = _tmp2_;
		_tmp3_ = self->priv->utils;
		gwibber_utils_setup (_tmp3_, GWIBBER_STREAMS_streams_name, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch40_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = self->priv->utils;
		g_signal_connect_object (_tmp4_, "available", (GCallback) _gwibber_streams_streams_available_gwibber_utils_available, self, 0);
		_tmp5_ = gwibber_messages_new ();
		_g_object_unref0 (self->priv->messages_service);
		self->priv->messages_service = _tmp5_;
		_tmp6_ = gwibber_searches_new ();
		_g_object_unref0 (self->priv->searches_service);
		self->priv->searches_service = _tmp6_;
		_tmp7_ = gwibber_service_new ();
		_g_object_unref0 (self->priv->service);
		self->priv->service = _tmp7_;
		_tmp8_ = self->priv->streams_service;
		g_signal_connect_object (_tmp8_, "updated", (GCallback) ____lambda10__streams_interface_updated, self, 0);
		_tmp9_ = self->priv->streams_service;
		g_signal_connect_object (_tmp9_, "created", (GCallback) ____lambda11__streams_interface_created, self, 0);
		_tmp10_ = self->priv->streams_service;
		g_signal_connect_object (_tmp10_, "deleted", (GCallback) ____lambda12__streams_interface_deleted, self, 0);
	}
	goto __finally40;
	__catch40_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strconcat ("Unable to get Gwibber Streams: ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		g_warning ("streams.vala:124: %s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_error_free0 (e);
	}
	__finally40:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp15_ = dee_resource_manager_get_default ();
	self->priv->resources = _tmp15_;
	_tmp16_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->seen);
	self->priv->seen = _tmp16_;
	return self;
}


GwibberStreams* gwibber_streams_new (void) {
	return gwibber_streams_construct (GWIBBER_TYPE_STREAMS);
}


/**
         * com.Gwibber.Streams
         **/
gchar* gwibber_streams_messages (GwibberStreams* self, const gchar* stream, const gchar* account, gint time, const gchar* transient) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = transient;
	if (_tmp0_ == NULL) {
		transient = "0";
	}
	{
		GTimer* _tmp1_;
		GTimer* timer;
		StreamsInterface* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* msgs;
		const gchar* _tmp8_;
		gdouble _tmp9_ = 0.0;
		_tmp1_ = g_timer_new ();
		timer = _tmp1_;
		_tmp2_ = self->priv->streams_service;
		_tmp3_ = stream;
		_tmp4_ = account;
		_tmp5_ = time;
		_tmp6_ = transient;
		_tmp7_ = streams_interface_Messages (_tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_, "0", "time", "DESC", 1000, &_inner_error_);
		msgs = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_timer_destroy0 (timer);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch41_g_io_error;
			}
			_g_timer_destroy0 (timer);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = stream;
		_tmp9_ = g_timer_elapsed (timer, NULL);
		g_debug ("streams.vala:143: Retrieved messages from stream '%s' in %fms", _tmp8_, _tmp9_ * 1000);
		result = msgs;
		_g_timer_destroy0 (timer);
		return result;
	}
	goto __finally41;
	__catch41_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("streams.vala:148: %s", _tmp11_);
		_tmp12_ = g_strdup ("");
		result = _tmp12_;
		_g_error_free0 (e);
		return result;
	}
	__finally41:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DeeModel* gwibber_streams_stream_filter_model (GwibberStreams* self, DeeModel* model, const gchar* stream) {
	DeeModel* result = NULL;
	DeeFilter stream_filter = {0};
	const gchar* _tmp0_;
	DeeModel* _tmp5_;
	DeeFilter _tmp6_;
	DeeFilterModel* _tmp7_;
	DeeFilterModel* filtered_model;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	_tmp0_ = stream;
	if (g_strcmp0 (_tmp0_, "home") == 0) {
		DeeModel* _tmp1_;
		DeeModel* _tmp2_;
		_tmp1_ = model;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		DeeFilter _tmp4_ = {0};
		_tmp3_ = stream;
		dee_filter_new_for_key_column ((guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM, _tmp3_, &_tmp4_);
		stream_filter = _tmp4_;
	}
	_tmp5_ = model;
	_tmp6_ = stream_filter;
	_tmp7_ = (DeeFilterModel*) dee_filter_model_new (_tmp5_, &_tmp6_);
	filtered_model = _tmp7_;
	result = (DeeModel*) filtered_model;
	return result;
}


DeeModel* gwibber_streams_transient_filter_model (GwibberStreams* self, DeeModel* model, const gchar* transient) {
	DeeModel* result = NULL;
	DeeFilter transient_filter = {0};
	const gchar* _tmp0_;
	DeeFilter _tmp1_ = {0};
	DeeModel* _tmp2_;
	DeeFilter _tmp3_;
	DeeFilterModel* _tmp4_;
	DeeFilterModel* filtered_model;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (transient != NULL, NULL);
	_tmp0_ = transient;
	dee_filter_new_for_key_column ((guint) GWIBBER_STREAM_MODEL_COLUMN_TRANSIENT, _tmp0_, &_tmp1_);
	transient_filter = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = transient_filter;
	_tmp4_ = (DeeFilterModel*) dee_filter_model_new (_tmp2_, &_tmp3_);
	filtered_model = _tmp4_;
	result = (DeeModel*) filtered_model;
	return result;
}


static DeeSequenceModel* gwibber_streams_create_model (GwibberStreams* self) {
	DeeSequenceModel* result = NULL;
	DeeSequenceModel* _tmp0_;
	DeeSequenceModel* m;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (DeeSequenceModel*) dee_sequence_model_new ();
	m = _tmp0_;
	dee_model_set_schema ((DeeModel*) m, "as", "s", "s", "s", "s", "b", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "d", "b", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", NULL);
	_tmp1_ = dee_model_get_n_columns ((DeeModel*) m);
	g_debug ("streams.vala:179: SCHEMA has %u rows", _tmp1_);
	result = m;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void ___lambda13_ (GwibberStreams* self, DeeModel* _m, DeeModelIter* _i) {
	GList* to_remove;
	GList* _tmp18_;
	g_return_if_fail (_m != NULL);
	g_return_if_fail (_i != NULL);
	to_remove = NULL;
	{
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _v_it;
		_tmp0_ = self->priv->seen;
		_tmp1_ = gee_abstract_map_get_entries ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_v_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GeeMapEntry* v;
			GeeMapEntry* _tmp10_;
			gconstpointer _tmp11_;
			DeeModelIter* _tmp12_;
			DeeModelIter* _tmp13_;
			_tmp6_ = _v_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _v_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			v = (GeeMapEntry*) _tmp9_;
			_tmp10_ = v;
			_tmp11_ = gee_map_entry_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _i;
			if (((DeeModelIter*) _tmp12_) == _tmp13_) {
				GeeMapEntry* _tmp14_;
				gconstpointer _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp14_ = v;
				_tmp15_ = gee_map_entry_get_key (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strdup ((const gchar*) _tmp16_);
				to_remove = g_list_prepend (to_remove, _tmp17_);
			}
			_g_object_unref0 (v);
		}
		_g_object_unref0 (_v_it);
	}
	_tmp18_ = to_remove;
	{
		GList* v_collection = NULL;
		GList* v_it = NULL;
		v_collection = _tmp18_;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			gchar* _tmp19_;
			gchar* v = NULL;
			_tmp19_ = g_strdup ((const gchar*) v_it->data);
			v = _tmp19_;
			{
				GeeHashMap* _tmp20_;
				const gchar* _tmp21_;
				_tmp20_ = self->priv->seen;
				_tmp21_ = v;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp20_, _tmp21_, NULL);
				_g_free0 (v);
			}
		}
	}
	__g_list_free__g_free0_0 (to_remove);
}


static void ____lambda13__dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	___lambda13_ (self, _sender, iter);
}


static gboolean ___lambda14_ (GwibberStreams* self) {
	gboolean result = FALSE;
	gwibber_streams_refresh_model_async (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ____lambda14__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda14_ (self);
	return result;
}


static void ___lambda16_ (GwibberStreams* self, const gchar* change, const gchar* data) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (change != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = change;
	_tmp1_ = data;
	gwibber_streams_on_refresh (self, _tmp0_, _tmp1_);
}


static void ____lambda16__gwibber_messages_message (GwibberMessages* _sender, const gchar* change, const gchar* data, gpointer self) {
	___lambda16_ (self, change, data);
}


static gboolean ___lambda17_ (GwibberStreams* self) {
	gboolean result = FALSE;
	gwibber_streams_refresh_transient_model_async (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ____lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda17_ (self);
	return result;
}


DeeModel* gwibber_streams_streams_model (GwibberStreams* self, gboolean transients) {
	DeeModel* result = NULL;
	guint schema_length;
	DeeResourceManager* _tmp0_ = NULL;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	schema_length = (guint) 39;
	_tmp0_ = dee_resource_manager_get_default ();
	self->priv->resources = _tmp0_;
	_tmp1_ = transients;
	if (!_tmp1_) {
		DeeSequenceModel* model;
		DeeSequenceModel* _tmp5_;
		DeeSequenceModel* _tmp8_;
		DeeSequenceModel* _tmp10_;
		guint _tmp11_ = 0U;
		guint _tmp12_;
		DeeSequenceModel* _tmp14_;
		GwibberMessages* _tmp15_;
		g_debug ("streams.vala:191: Getting non-transient model");
		model = NULL;
		{
			DeeResourceManager* _tmp2_;
			GObject* _tmp3_ = NULL;
			GObject* _tmp4_;
			_tmp2_ = self->priv->resources;
			_tmp3_ = dee_resource_manager_load (_tmp2_, "gwibber.stream_model", &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch42_g_error;
			}
			_g_object_unref0 (model);
			model = DEE_IS_SEQUENCE_MODEL (_tmp4_) ? ((DeeSequenceModel*) _tmp4_) : NULL;
		}
		goto __finally42;
		__catch42_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally42:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = model;
		if (DEE_IS_MODEL (_tmp5_)) {
			DeeSequenceModel* _tmp6_;
			guint _tmp7_ = 0U;
			_tmp6_ = model;
			_tmp7_ = dee_model_get_n_rows ((DeeModel*) _tmp6_);
			g_debug ("streams.vala:201: stream_model from resources has %u rows", _tmp7_);
		} else {
			g_debug ("streams.vala:203: stream_model from resources isn't valid");
		}
		_tmp8_ = model;
		if (!DEE_IS_SEQUENCE_MODEL (_tmp8_)) {
			DeeSequenceModel* _tmp9_ = NULL;
			g_debug ("streams.vala:206: Didn't get model from resource manager, creating a n" \
"ew one");
			_tmp9_ = gwibber_streams_create_model (self);
			_g_object_unref0 (model);
			model = _tmp9_;
		}
		_tmp10_ = model;
		_tmp11_ = dee_model_get_n_columns ((DeeModel*) _tmp10_);
		_tmp12_ = schema_length;
		if (_tmp11_ != _tmp12_) {
			DeeSequenceModel* _tmp13_ = NULL;
			g_debug ("streams.vala:211: SCHEMA isn't current, recreating");
			_g_object_unref0 (model);
			model = NULL;
			_tmp13_ = gwibber_streams_create_model (self);
			_g_object_unref0 (model);
			model = _tmp13_;
		}
		_tmp14_ = model;
		g_signal_connect_object ((DeeModel*) _tmp14_, "row-removed", (GCallback) ____lambda13__dee_model_row_removed, self, 0);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda14__gsource_func, g_object_ref (self), g_object_unref);
		_tmp15_ = self->priv->messages_service;
		g_signal_connect_object (_tmp15_, "message", (GCallback) ____lambda16__gwibber_messages_message, self, 0);
		result = (DeeModel*) model;
		return result;
	} else {
		DeeSequenceModel* model;
		DeeSequenceModel* _tmp19_;
		guint _tmp20_ = 0U;
		DeeSequenceModel* _tmp21_;
		DeeSequenceModel* _tmp23_;
		guint _tmp24_ = 0U;
		guint _tmp25_;
		g_debug ("streams.vala:242: Getting transient model");
		model = NULL;
		{
			DeeResourceManager* _tmp16_;
			GObject* _tmp17_ = NULL;
			GObject* _tmp18_;
			_tmp16_ = self->priv->resources;
			_tmp17_ = dee_resource_manager_load (_tmp16_, "gwibber.transient_model", &_inner_error_);
			_tmp18_ = _tmp17_;
			if (_inner_error_ != NULL) {
				goto __catch43_g_error;
			}
			_g_object_unref0 (model);
			model = DEE_IS_SEQUENCE_MODEL (_tmp18_) ? ((DeeSequenceModel*) _tmp18_) : NULL;
		}
		goto __finally43;
		__catch43_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally43:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp19_ = model;
		_tmp20_ = dee_model_get_n_rows ((DeeModel*) _tmp19_);
		g_debug ("streams.vala:251: transient_model from resources has %u rows", _tmp20_);
		_tmp21_ = model;
		if (!DEE_IS_SEQUENCE_MODEL (_tmp21_)) {
			DeeSequenceModel* _tmp22_ = NULL;
			g_debug ("streams.vala:254: Didn't get the transient model from resource manager" \
", creating a new one");
			_tmp22_ = gwibber_streams_create_model (self);
			_g_object_unref0 (model);
			model = _tmp22_;
		}
		_tmp23_ = model;
		_tmp24_ = dee_model_get_n_columns ((DeeModel*) _tmp23_);
		_tmp25_ = schema_length;
		if (_tmp24_ != _tmp25_) {
			DeeSequenceModel* _tmp26_ = NULL;
			g_debug ("streams.vala:259: SCHEMA isn't current, recreating");
			_g_object_unref0 (model);
			model = NULL;
			_tmp26_ = gwibber_streams_create_model (self);
			_g_object_unref0 (model);
			model = _tmp26_;
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda17__gsource_func, g_object_ref (self), g_object_unref);
		result = (DeeModel*) model;
		return result;
	}
}


static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
	return g_boxed_copy (json_object_get_type (), self);
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
	return self ? _vala_JsonObject_copy (self) : NULL;
}


static void _vala_JsonObject_free (JsonObject* self) {
	g_boxed_free (json_object_get_type (), self);
}


static void gwibber_streams_on_refresh (GwibberStreams* self, const gchar* change, const gchar* data) {
	JsonParser* _tmp0_;
	JsonParser* parser;
	JsonNode* _tmp2_ = NULL;
	JsonNode* node;
	JsonNode* _tmp3_;
	JsonObject* _tmp4_ = NULL;
	JsonObject* _tmp5_;
	JsonObject* obj;
	JsonObject* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (change != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	{
		const gchar* _tmp1_;
		_tmp1_ = data;
		json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch44_g_error;
		}
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally44:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = json_parser_get_root (parser);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = json_node_get_object (_tmp3_);
	_tmp5_ = __vala_JsonObject_copy0 (_tmp4_);
	obj = _tmp5_;
	_tmp6_ = obj;
	if (_tmp6_ != NULL) {
		JsonObject* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = obj;
		_tmp8_ = change;
		gwibber_streams_parse_message (self, _tmp7_, _tmp8_);
	}
	__vala_JsonObject_free0 (obj);
	_g_object_unref0 (parser);
}


static void gwibber_streams_refresh_model_async_data_free (gpointer _data) {
	GwibberStreamsRefreshModelAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GwibberStreamsRefreshModelAsyncData, _data_);
}


static void gwibber_streams_refresh_model_async (GwibberStreams* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberStreamsRefreshModelAsyncData* _data_;
	GwibberStreams* _tmp0_;
	_data_ = g_slice_new0 (GwibberStreamsRefreshModelAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_streams_refresh_model_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_streams_refresh_model_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gwibber_streams_refresh_model_async_co (_data_);
}


static void gwibber_streams_refresh_model_finish (GwibberStreams* self, GAsyncResult* _res_) {
	GwibberStreamsRefreshModelAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GwibberStreams * self;
		self = _data1_->self;
		__g_list_free__g_free0_0 (_data1_->streams);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda15_ (Block1Data* _data1_) {
	GwibberStreams * self;
	gboolean result = FALSE;
	GTimer* _tmp0_;
	GTimer* timer;
	DeeModel* _tmp1_;
	DeeModel* _tmp2_;
	guint _tmp7_ = 0U;
	GTimer* _tmp8_;
	gdouble _tmp9_ = 0.0;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	g_debug ("streams.vala:302: Refreshing model - fetching streams");
	_tmp1_ = gwibber_streams_get_stream_model (self);
	_tmp2_ = _tmp1_;
	dee_model_clear (_tmp2_);
	{
		GList* stream_collection = NULL;
		GList* stream_it = NULL;
		stream_collection = _data1_->streams;
		for (stream_it = stream_collection; stream_it != NULL; stream_it = stream_it->next) {
			gchar* _tmp3_;
			gchar* stream = NULL;
			_tmp3_ = g_strdup ((const gchar*) stream_it->data);
			stream = _tmp3_;
			{
				const gchar* _tmp4_;
				gchar* _tmp5_ = NULL;
				gchar* msgs;
				const gchar* _tmp6_;
				_tmp4_ = stream;
				_tmp5_ = gwibber_streams_messages (self, _tmp4_, "all", 0, NULL);
				msgs = _tmp5_;
				_tmp6_ = msgs;
				gwibber_streams_parse_messages (self, _tmp6_);
				_g_free0 (msgs);
				_g_free0 (stream);
			}
		}
	}
	_tmp7_ = g_list_length (_data1_->streams);
	_tmp8_ = timer;
	_tmp9_ = g_timer_elapsed (_tmp8_, NULL);
	g_debug ("streams.vala:309: Fetched and parsed %u streams in %fms", _tmp7_, _tmp9_ * 1000);
	g_debug ("streams.vala:311: Storing gwibber.stream_model");
	{
		DeeResourceManager* _tmp10_;
		DeeModel* _tmp11_;
		DeeModel* _tmp12_;
		_tmp10_ = self->priv->resources;
		_tmp11_ = gwibber_streams_get_stream_model (self);
		_tmp12_ = _tmp11_;
		dee_resource_manager_store (_tmp10_, (DeeSerializable*) DEE_SEQUENCE_MODEL (_tmp12_), "gwibber.stream_model", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch45_g_error;
		}
	}
	goto __finally45;
	__catch45_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally45:
	if (_inner_error_ != NULL) {
		_g_timer_destroy0 (timer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_timer_destroy0 (timer);
	return result;
}


static gboolean ___lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda15_ (self);
	return result;
}


static gboolean gwibber_streams_refresh_model_async_co (GwibberStreamsRefreshModelAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	g_debug ("streams.vala:290: refresh_model_async");
	_data_->_data1_->streams = NULL;
	_data_->_tmp0_ = g_strdup ("replies");
	_data_->_data1_->streams = g_list_append (_data_->_data1_->streams, _data_->_tmp0_);
	_data_->_tmp1_ = g_strdup ("private");
	_data_->_data1_->streams = g_list_append (_data_->_data1_->streams, _data_->_tmp1_);
	_data_->_tmp2_ = g_strdup ("public");
	_data_->_data1_->streams = g_list_append (_data_->_data1_->streams, _data_->_tmp2_);
	_data_->_tmp3_ = g_strdup ("images");
	_data_->_data1_->streams = g_list_append (_data_->_data1_->streams, _data_->_tmp3_);
	_data_->_tmp4_ = g_strdup ("links");
	_data_->_data1_->streams = g_list_append (_data_->_data1_->streams, _data_->_tmp4_);
	_data_->_tmp5_ = g_strdup ("videos");
	_data_->_data1_->streams = g_list_append (_data_->_data1_->streams, _data_->_tmp5_);
	_data_->_tmp6_ = g_strdup ("messages");
	_data_->_data1_->streams = g_list_append (_data_->_data1_->streams, _data_->_tmp6_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda15__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gwibber_streams_refresh_transient_model_async_data_free (gpointer _data) {
	GwibberStreamsRefreshTransientModelAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GwibberStreamsRefreshTransientModelAsyncData, _data_);
}


static void gwibber_streams_refresh_transient_model_async (GwibberStreams* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberStreamsRefreshTransientModelAsyncData* _data_;
	GwibberStreams* _tmp0_;
	_data_ = g_slice_new0 (GwibberStreamsRefreshTransientModelAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_streams_refresh_transient_model_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_streams_refresh_transient_model_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gwibber_streams_refresh_transient_model_async_co (_data_);
}


static void gwibber_streams_refresh_transient_model_finish (GwibberStreams* self, GAsyncResult* _res_) {
	GwibberStreamsRefreshTransientModelAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean __lambda18_ (GwibberStreams* self) {
	gboolean result = FALSE;
	GTimer* _tmp0_;
	GTimer* timer;
	gchar* msgs = NULL;
	DeeModel* _tmp1_;
	DeeModel* _tmp2_;
	GwibberSearches* _tmp3_;
	GList* _tmp4_ = NULL;
	GList* searches;
	GList* _tmp5_;
	GList* _tmp12_;
	guint _tmp13_ = 0U;
	GTimer* _tmp14_;
	gdouble _tmp15_ = 0.0;
	GTimer* _tmp16_;
	GList* _tmp17_ = NULL;
	GList* streams_list;
	GList* _tmp18_;
	GList* _tmp28_;
	guint _tmp29_ = 0U;
	GTimer* _tmp30_;
	gdouble _tmp31_ = 0.0;
	DeeModel* _tmp35_;
	DeeModel* _tmp36_;
	guint _tmp37_ = 0U;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	_tmp1_ = gwibber_streams_get_transient_model (self);
	_tmp2_ = _tmp1_;
	dee_model_clear (_tmp2_);
	_tmp3_ = self->priv->searches_service;
	_tmp4_ = gwibber_searches_list (_tmp3_);
	searches = _tmp4_;
	_tmp5_ = searches;
	{
		GList* x_collection = NULL;
		GList* x_it = NULL;
		x_collection = _tmp5_;
		for (x_it = x_collection; x_it != NULL; x_it = x_it->next) {
			GeeHashMap* _tmp6_;
			GeeHashMap* x = NULL;
			_tmp6_ = _g_object_ref0 ((GeeHashMap*) x_it->data);
			x = _tmp6_;
			{
				GeeHashMap* _tmp7_;
				gpointer _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				const gchar* _tmp11_;
				_tmp7_ = x;
				_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, "id");
				_tmp9_ = (gchar*) _tmp8_;
				_tmp10_ = gwibber_streams_messages (self, "all", "all", 0, _tmp9_);
				_g_free0 (msgs);
				msgs = _tmp10_;
				_g_free0 (_tmp9_);
				_tmp11_ = msgs;
				gwibber_streams_parse_messages (self, _tmp11_);
				_g_object_unref0 (x);
			}
		}
	}
	_tmp12_ = searches;
	_tmp13_ = g_list_length (_tmp12_);
	_tmp14_ = timer;
	_tmp15_ = g_timer_elapsed (_tmp14_, NULL);
	g_debug ("streams.vala:336: Fetched and parsed %u searches in %fms", _tmp13_, _tmp15_ * 1000);
	_tmp16_ = timer;
	g_timer_reset (_tmp16_);
	_tmp17_ = gwibber_streams_list (self);
	streams_list = _tmp17_;
	_tmp18_ = streams_list;
	{
		GList* y_collection = NULL;
		GList* y_it = NULL;
		y_collection = _tmp18_;
		for (y_it = y_collection; y_it != NULL; y_it = y_it->next) {
			GeeHashMap* _tmp19_;
			GeeHashMap* y = NULL;
			_tmp19_ = _g_object_ref0 ((GeeHashMap*) y_it->data);
			y = _tmp19_;
			{
				GeeHashMap* _tmp20_;
				gpointer _tmp21_ = NULL;
				gchar* _tmp22_;
				GeeHashMap* _tmp23_;
				gpointer _tmp24_ = NULL;
				gchar* _tmp25_;
				gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				_tmp20_ = y;
				_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, "account");
				_tmp22_ = (gchar*) _tmp21_;
				_tmp23_ = y;
				_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, "id");
				_tmp25_ = (gchar*) _tmp24_;
				_tmp26_ = gwibber_streams_messages (self, "all", _tmp22_, 0, _tmp25_);
				_g_free0 (msgs);
				msgs = _tmp26_;
				_g_free0 (_tmp25_);
				_g_free0 (_tmp22_);
				_tmp27_ = msgs;
				gwibber_streams_parse_messages (self, _tmp27_);
				_g_object_unref0 (y);
			}
		}
	}
	_tmp28_ = streams_list;
	_tmp29_ = g_list_length (_tmp28_);
	_tmp30_ = timer;
	_tmp31_ = g_timer_elapsed (_tmp30_, NULL);
	g_debug ("streams.vala:344: Fetched and parsed %u transient streams in %fms", _tmp29_, _tmp31_ * 1000);
	g_debug ("streams.vala:345: Storing gwibber.transient_model");
	{
		DeeResourceManager* _tmp32_;
		DeeModel* _tmp33_;
		DeeModel* _tmp34_;
		_tmp32_ = self->priv->resources;
		_tmp33_ = gwibber_streams_get_transient_model (self);
		_tmp34_ = _tmp33_;
		dee_resource_manager_store (_tmp32_, (DeeSerializable*) DEE_SEQUENCE_MODEL (_tmp34_), "gwibber.transient_model", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch46_g_error;
		}
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally46:
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (streams_list);
		__g_list_free__g_object_unref0_0 (searches);
		_g_free0 (msgs);
		_g_timer_destroy0 (timer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp35_ = gwibber_streams_get_transient_model (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = dee_model_get_n_rows (_tmp36_);
	g_debug ("streams.vala:353: transient_model has %u rows", _tmp37_);
	result = FALSE;
	__g_list_free__g_object_unref0_0 (streams_list);
	__g_list_free__g_object_unref0_0 (searches);
	_g_free0 (msgs);
	_g_timer_destroy0 (timer);
	return result;
}


static gboolean ___lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda18_ (self);
	return result;
}


static gboolean gwibber_streams_refresh_transient_model_async_co (GwibberStreamsRefreshTransientModelAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("streams.vala:325: refresh_transient_model_async");
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda18__gsource_func, g_object_ref (_data_->self), g_object_unref);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static JsonArray* _vala_JsonArray_copy (JsonArray* self) {
	return g_boxed_copy (json_array_get_type (), self);
}


static gpointer __vala_JsonArray_copy0 (gpointer self) {
	return self ? _vala_JsonArray_copy (self) : NULL;
}


static void _vala_JsonArray_free (JsonArray* self) {
	g_boxed_free (json_array_get_type (), self);
}


static void gwibber_streams_parse_messages (GwibberStreams* self, const gchar* data) {
	GTimer* _tmp0_;
	GTimer* timer;
	JsonParser* _tmp1_;
	JsonParser* parser;
	JsonNode* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	JsonArray* _tmp5_;
	JsonArray* nodeArray;
	JsonArray* _tmp19_;
	guint _tmp20_ = 0U;
	gdouble _tmp21_ = 0.0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	_tmp1_ = json_parser_new ();
	parser = _tmp1_;
	{
		const gchar* _tmp2_;
		_tmp2_ = data;
		json_parser_load_from_data (parser, _tmp2_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch47_g_error;
		}
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally47:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		_g_timer_destroy0 (timer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = json_parser_get_root (parser);
	_tmp4_ = json_node_get_array (_tmp3_);
	_tmp5_ = __vala_JsonArray_copy0 (_tmp4_);
	nodeArray = _tmp5_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gint _tmp9_;
				JsonArray* _tmp10_;
				guint _tmp11_ = 0U;
				JsonArray* _tmp12_;
				gint _tmp13_;
				JsonNode* _tmp14_ = NULL;
				JsonObject* _tmp15_ = NULL;
				JsonObject* _tmp16_;
				JsonObject* obj;
				JsonObject* _tmp17_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = nodeArray;
				_tmp11_ = json_array_get_length (_tmp10_);
				if (!(((guint) _tmp9_) < _tmp11_)) {
					break;
				}
				_tmp12_ = nodeArray;
				_tmp13_ = i;
				_tmp14_ = json_array_get_element (_tmp12_, (guint) _tmp13_);
				_tmp15_ = json_node_get_object (_tmp14_);
				_tmp16_ = __vala_JsonObject_copy0 (_tmp15_);
				obj = _tmp16_;
				_tmp17_ = obj;
				if (_tmp17_ != NULL) {
					JsonObject* _tmp18_;
					_tmp18_ = obj;
					gwibber_streams_parse_message (self, _tmp18_, "new");
				}
				__vala_JsonObject_free0 (obj);
			}
		}
	}
	_tmp19_ = nodeArray;
	_tmp20_ = json_array_get_length (_tmp19_);
	_tmp21_ = g_timer_elapsed (timer, NULL);
	g_debug ("streams.vala:376: Parsed %u messages in %fms", _tmp20_, _tmp21_ * 1000);
	__vala_JsonArray_free0 (nodeArray);
	_g_object_unref0 (parser);
	_g_timer_destroy0 (timer);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch48_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch48_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally48;
	__catch48_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally48:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar** _variant_get1 (GVariant* value, int* result_length1) {
	gchar** _tmp461_;
	int _tmp461__length;
	int _tmp461__size;
	int _tmp461__length1;
	GVariantIter _tmp462_;
	GVariant* _tmp463_;
	_tmp461_ = g_new (gchar*, 5);
	_tmp461__length = 0;
	_tmp461__size = 4;
	_tmp461__length1 = 0;
	g_variant_iter_init (&_tmp462_, value);
	for (; (_tmp463_ = g_variant_iter_next_value (&_tmp462_)) != NULL; _tmp461__length1++) {
		if (_tmp461__size == _tmp461__length) {
			_tmp461__size = 2 * _tmp461__size;
			_tmp461_ = g_renew (gchar*, _tmp461_, _tmp461__size + 1);
		}
		_tmp461_[_tmp461__length++] = g_variant_dup_string (_tmp463_, NULL);
		g_variant_unref (_tmp463_);
	}
	*result_length1 = _tmp461__length1;
	_tmp461_[_tmp461__length] = NULL;
	return _tmp461_;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static GVariant* _variant_new2 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new3 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new4 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new5 (gdouble value) {
	return g_variant_ref_sink (g_variant_new_double (value));
}


static GVariant* _variant_new6 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void gwibber_streams_parse_message (GwibberStreams* self, JsonObject* obj, const gchar* change) {
	gchar* _account;
	gchar* _stream;
	gchar* _service;
	gchar* _operation;
	gchar* _mid;
	gchar* _source;
	gchar* _reply_nick;
	gchar* _reply_name;
	gchar* _reply_url;
	gdouble _likes;
	gboolean _liked;
	gchar* _retweeted_by_nick;
	gchar* _retweeted_by_name;
	gchar* _retweeted_by_id;
	gchar* _link_picture;
	gchar* _link_name;
	gchar* _link_url;
	gchar* _link_description;
	gchar* _link_caption;
	gchar* _link_icon;
	gchar* _image_url;
	gchar* _image_src;
	gchar* _image_thumb;
	gchar* _image_name;
	gchar* _video_picture;
	gchar* _video_src;
	gchar* _video_url;
	gchar* _video_name;
	gboolean _from_me;
	guint _time;
	gchar* _html;
	gchar* _text;
	gchar* _icon;
	gchar* _url;
	gchar* _comments;
	gchar* transient;
	DeeModelIter* iter;
	JsonObject* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* members;
	JsonObject* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp7_;
	DeeModel* _tmp9_;
	DeeModel* _tmp10_;
	DeeModel* _tmp11_;
	DeeModel* _model;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	DeeModel* _tmp18_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp25_;
	JsonObject* _tmp26_;
	gboolean _tmp27_ = FALSE;
	JsonObject* _tmp31_;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp36_;
	const gchar* _tmp38_;
	JsonObject* _tmp40_;
	gboolean _tmp41_ = FALSE;
	JsonObject* _tmp45_;
	gboolean _tmp46_ = FALSE;
	JsonObject* _tmp50_;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _acct;
	GVariantType* _tmp66_;
	GVariantType* _tmp67_;
	GVariantBuilder* _tmp68_;
	GVariantBuilder* _tmp69_;
	GVariantBuilder* builder;
	GVariantBuilder* _tmp70_;
	const gchar* _tmp71_;
	JsonObject* _sender_obj;
	gchar* _tmp72_;
	gchar* _sender;
	gchar* _tmp73_;
	gchar* _sender_nick;
	JsonObject* _recipient_obj;
	gchar* _tmp74_;
	gchar* _recipient;
	gchar* _tmp75_;
	gchar* _recipient_nick;
	gchar* _tmp76_;
	gchar* _recipient_icon;
	JsonObject* _tmp77_;
	gboolean _tmp78_ = FALSE;
	JsonObject* _tmp98_;
	gboolean _tmp99_ = FALSE;
	JsonObject* _tmp114_;
	gboolean _tmp115_ = FALSE;
	JsonObject* _tmp118_;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp122_ = FALSE;
	guint _tmp123_;
	gboolean _tmp126_;
	JsonObject* _tmp129_;
	gboolean _tmp130_ = FALSE;
	JsonObject* _tmp134_;
	gboolean _tmp135_ = FALSE;
	const gchar* _tmp139_;
	gchar* _tmp140_ = NULL;
	gchar* _textid;
	JsonObject* _tmp141_;
	gboolean _tmp142_ = FALSE;
	JsonObject* _tmp146_;
	gboolean _tmp147_ = FALSE;
	GList* _tmp151_;
	const gchar* _tmp370_;
	const gchar* _tmp373_;
	const gchar* _tmp376_;
	const gchar* _tmp379_;
	const gchar* _tmp382_;
	gboolean _tmp385_ = FALSE;
	const gchar* _tmp386_;
	gint _tmp387_;
	gint _tmp388_;
	gboolean _tmp390_;
	gboolean _tmp393_ = FALSE;
	const gchar* _tmp394_;
	gint _tmp395_;
	gint _tmp396_;
	gboolean _tmp398_;
	gboolean _tmp401_ = FALSE;
	const gchar* _tmp402_;
	gint _tmp403_;
	gint _tmp404_;
	gboolean _tmp406_;
	gboolean _tmp409_ = FALSE;
	const gchar* _tmp410_;
	gint _tmp411_;
	gint _tmp412_;
	gboolean _tmp414_;
	gboolean _tmp417_ = FALSE;
	const gchar* _tmp418_;
	gint _tmp419_;
	gint _tmp420_;
	gboolean _tmp422_;
	gboolean _tmp425_ = FALSE;
	const gchar* _tmp426_;
	gint _tmp427_;
	gint _tmp428_;
	gboolean _tmp430_;
	gboolean _tmp433_ = FALSE;
	const gchar* _tmp434_;
	gint _tmp435_;
	gint _tmp436_;
	gboolean _tmp438_;
	GwibberUtils* _tmp441_;
	guint _tmp442_;
	gchar* _tmp443_ = NULL;
	gchar* _t;
	gboolean _tmp444_ = FALSE;
	GeeHashMap* _tmp445_;
	const gchar* _tmp446_;
	gboolean _tmp447_ = FALSE;
	gboolean _tmp449_;
	GVariantBuilder* _tmp497_;
	GVariant* _tmp498_;
	GVariant* _tmp499_;
	GVariant* _accounts;
	DeeModel* _tmp500_;
	GVariant* _tmp501_;
	const gchar* _tmp502_;
	const gchar* _tmp503_;
	const gchar* _tmp504_;
	const gchar* _tmp505_;
	gboolean _tmp506_;
	guint _tmp507_;
	gchar* _tmp508_ = NULL;
	gchar* _tmp509_;
	const gchar* _tmp510_;
	const gchar* _tmp511_;
	const gchar* _tmp512_;
	const gchar* _tmp513_;
	const gchar* _tmp514_;
	const gchar* _tmp515_;
	const gchar* _tmp516_;
	const gchar* _tmp517_;
	const gchar* _tmp518_;
	gdouble _tmp519_;
	gboolean _tmp520_;
	const gchar* _tmp521_;
	const gchar* _tmp522_;
	const gchar* _tmp523_;
	const gchar* _tmp524_;
	const gchar* _tmp525_;
	const gchar* _tmp526_;
	const gchar* _tmp527_;
	const gchar* _tmp528_;
	const gchar* _tmp529_;
	const gchar* _tmp530_;
	const gchar* _tmp531_;
	const gchar* _tmp532_;
	const gchar* _tmp533_;
	const gchar* _tmp534_;
	const gchar* _tmp535_;
	const gchar* _tmp536_;
	const gchar* _tmp537_;
	const gchar* _tmp538_;
	const gchar* _tmp539_;
	const gchar* _tmp540_;
	const gchar* _tmp541_;
	DeeModelIter* _tmp542_ = NULL;
	gboolean _tmp543_ = FALSE;
	const gchar* _tmp544_;
	gint _tmp545_;
	gint _tmp546_;
	gboolean _tmp548_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (change != NULL);
	_account = NULL;
	_stream = NULL;
	_service = NULL;
	_operation = NULL;
	_mid = NULL;
	_source = NULL;
	_reply_nick = NULL;
	_reply_name = NULL;
	_reply_url = NULL;
	_likes = (gdouble) 0;
	_liked = FALSE;
	_retweeted_by_nick = NULL;
	_retweeted_by_name = NULL;
	_retweeted_by_id = NULL;
	_link_picture = NULL;
	_link_name = NULL;
	_link_url = NULL;
	_link_description = NULL;
	_link_caption = NULL;
	_link_icon = NULL;
	_image_url = NULL;
	_image_src = NULL;
	_image_thumb = NULL;
	_image_name = NULL;
	_video_picture = NULL;
	_video_src = NULL;
	_video_url = NULL;
	_video_name = NULL;
	_from_me = FALSE;
	_time = (guint) 0;
	_html = NULL;
	_text = NULL;
	_icon = NULL;
	_url = NULL;
	_comments = NULL;
	transient = NULL;
	iter = NULL;
	_tmp0_ = obj;
	_tmp1_ = json_object_get_members (_tmp0_);
	members = _tmp1_;
	_tmp2_ = obj;
	_tmp3_ = json_object_has_member (_tmp2_, "transient");
	if (_tmp3_) {
		JsonObject* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp4_ = obj;
		_tmp5_ = json_object_get_string_member (_tmp4_, "transient");
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (transient);
		transient = _tmp6_;
	}
	_tmp7_ = transient;
	if (_tmp7_ == NULL) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("0");
		_g_free0 (transient);
		transient = _tmp8_;
	}
	_tmp9_ = gwibber_streams_get_stream_model (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_model = _tmp11_;
	_tmp12_ = transient;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ > 1) {
		DeeModel* _tmp15_;
		DeeModel* _tmp16_;
		DeeModel* _tmp17_;
		_tmp15_ = gwibber_streams_get_transient_model (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_g_object_unref0 (_model);
		_model = _tmp17_;
	}
	_tmp18_ = _model;
	if (!DEE_IS_MODEL (_tmp18_)) {
		const gchar* _tmp19_;
		_tmp19_ = transient;
		g_debug ("streams.vala:431: ERROR: Not a valid model, transient is %s", _tmp19_);
		_g_object_unref0 (_model);
		_g_list_free0 (members);
		_g_free0 (transient);
		_g_free0 (_comments);
		_g_free0 (_url);
		_g_free0 (_icon);
		_g_free0 (_text);
		_g_free0 (_html);
		_g_free0 (_video_name);
		_g_free0 (_video_url);
		_g_free0 (_video_src);
		_g_free0 (_video_picture);
		_g_free0 (_image_name);
		_g_free0 (_image_thumb);
		_g_free0 (_image_src);
		_g_free0 (_image_url);
		_g_free0 (_link_icon);
		_g_free0 (_link_caption);
		_g_free0 (_link_description);
		_g_free0 (_link_url);
		_g_free0 (_link_name);
		_g_free0 (_link_picture);
		_g_free0 (_retweeted_by_id);
		_g_free0 (_retweeted_by_name);
		_g_free0 (_retweeted_by_nick);
		_g_free0 (_reply_url);
		_g_free0 (_reply_name);
		_g_free0 (_reply_nick);
		_g_free0 (_source);
		_g_free0 (_mid);
		_g_free0 (_operation);
		_g_free0 (_service);
		_g_free0 (_stream);
		_g_free0 (_account);
		return;
	}
	_tmp21_ = transient;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ > 1) {
		const gchar* _tmp24_;
		_tmp24_ = change;
		_tmp20_ = g_strcmp0 (_tmp24_, "new") != 0;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp25_ = _tmp20_;
	if (_tmp25_) {
		_g_object_unref0 (_model);
		_g_list_free0 (members);
		_g_free0 (transient);
		_g_free0 (_comments);
		_g_free0 (_url);
		_g_free0 (_icon);
		_g_free0 (_text);
		_g_free0 (_html);
		_g_free0 (_video_name);
		_g_free0 (_video_url);
		_g_free0 (_video_src);
		_g_free0 (_video_picture);
		_g_free0 (_image_name);
		_g_free0 (_image_thumb);
		_g_free0 (_image_src);
		_g_free0 (_image_url);
		_g_free0 (_link_icon);
		_g_free0 (_link_caption);
		_g_free0 (_link_description);
		_g_free0 (_link_url);
		_g_free0 (_link_name);
		_g_free0 (_link_picture);
		_g_free0 (_retweeted_by_id);
		_g_free0 (_retweeted_by_name);
		_g_free0 (_retweeted_by_nick);
		_g_free0 (_reply_url);
		_g_free0 (_reply_name);
		_g_free0 (_reply_nick);
		_g_free0 (_source);
		_g_free0 (_mid);
		_g_free0 (_operation);
		_g_free0 (_service);
		_g_free0 (_stream);
		_g_free0 (_account);
		return;
	}
	_tmp26_ = obj;
	_tmp27_ = json_object_has_member (_tmp26_, "account");
	if (_tmp27_) {
		JsonObject* _tmp28_;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		_tmp28_ = obj;
		_tmp29_ = json_object_get_string_member (_tmp28_, "account");
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (_account);
		_account = _tmp30_;
	}
	_tmp31_ = obj;
	_tmp32_ = json_object_has_member (_tmp31_, "stream");
	if (_tmp32_) {
		JsonObject* _tmp33_;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		_tmp33_ = obj;
		_tmp34_ = json_object_get_string_member (_tmp33_, "stream");
		_tmp35_ = g_strdup (_tmp34_);
		_g_free0 (_stream);
		_stream = _tmp35_;
	}
	_tmp36_ = _stream;
	if (g_strcmp0 (_tmp36_, "send_private") == 0) {
		gchar* _tmp37_;
		_tmp37_ = g_strdup ("private");
		_g_free0 (_stream);
		_stream = _tmp37_;
	}
	_tmp38_ = _stream;
	if (g_strcmp0 (_tmp38_, "send_thread") == 0) {
		gchar* _tmp39_;
		_tmp39_ = g_strdup ("replies");
		_g_free0 (_stream);
		_stream = _tmp39_;
	}
	_tmp40_ = obj;
	_tmp41_ = json_object_has_member (_tmp40_, "service");
	if (_tmp41_) {
		JsonObject* _tmp42_;
		const gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		_tmp42_ = obj;
		_tmp43_ = json_object_get_string_member (_tmp42_, "service");
		_tmp44_ = g_strdup (_tmp43_);
		_g_free0 (_service);
		_service = _tmp44_;
	}
	_tmp45_ = obj;
	_tmp46_ = json_object_has_member (_tmp45_, "operation");
	if (_tmp46_) {
		JsonObject* _tmp47_;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_;
		_tmp47_ = obj;
		_tmp48_ = json_object_get_string_member (_tmp47_, "operation");
		_tmp49_ = g_strdup (_tmp48_);
		_g_free0 (_operation);
		_operation = _tmp49_;
	}
	_tmp50_ = obj;
	_tmp51_ = json_object_has_member (_tmp50_, "mid");
	if (_tmp51_) {
		JsonObject* _tmp52_;
		const gchar* _tmp53_ = NULL;
		gchar* _tmp54_;
		_tmp52_ = obj;
		_tmp53_ = json_object_get_string_member (_tmp52_, "id");
		_tmp54_ = g_strdup (_tmp53_);
		_g_free0 (_mid);
		_mid = _tmp54_;
	}
	_tmp55_ = _account;
	_tmp56_ = g_strconcat (_tmp55_, ":", NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = _service;
	_tmp59_ = g_strconcat (_tmp57_, _tmp58_, NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = g_strconcat (_tmp60_, ":", NULL);
	_tmp62_ = _tmp61_;
	_tmp63_ = _mid;
	_tmp64_ = g_strconcat (_tmp62_, _tmp63_, NULL);
	_tmp65_ = _tmp64_;
	_g_free0 (_tmp62_);
	_g_free0 (_tmp60_);
	_g_free0 (_tmp57_);
	_acct = _tmp65_;
	_tmp66_ = g_variant_type_new ("as");
	_tmp67_ = _tmp66_;
	_tmp68_ = g_variant_builder_new (_tmp67_);
	_tmp69_ = _tmp68_;
	_g_variant_type_free0 (_tmp67_);
	builder = _tmp69_;
	_tmp70_ = builder;
	_tmp71_ = _acct;
	g_variant_builder_add (_tmp70_, "s", _tmp71_, NULL);
	_sender_obj = NULL;
	_tmp72_ = g_strdup ("");
	_sender = _tmp72_;
	_tmp73_ = g_strdup ("");
	_sender_nick = _tmp73_;
	_recipient_obj = NULL;
	_tmp74_ = g_strdup ("");
	_recipient = _tmp74_;
	_tmp75_ = g_strdup ("");
	_recipient_nick = _tmp75_;
	_tmp76_ = g_strdup ("");
	_recipient_icon = _tmp76_;
	_tmp77_ = obj;
	_tmp78_ = json_object_has_member (_tmp77_, "recipient");
	if (_tmp78_) {
		JsonObject* _tmp79_;
		JsonObject* _tmp80_ = NULL;
		JsonObject* _tmp81_;
		JsonObject* _tmp82_;
		_tmp79_ = obj;
		_tmp80_ = json_object_get_object_member (_tmp79_, "recipient");
		_tmp81_ = __vala_JsonObject_copy0 (_tmp80_);
		__vala_JsonObject_free0 (_recipient_obj);
		_recipient_obj = _tmp81_;
		_tmp82_ = _recipient_obj;
		if (_tmp82_ != NULL) {
			JsonObject* _tmp83_;
			gboolean _tmp84_ = FALSE;
			JsonObject* _tmp88_;
			gboolean _tmp89_ = FALSE;
			JsonObject* _tmp93_;
			gboolean _tmp94_ = FALSE;
			_tmp83_ = _recipient_obj;
			_tmp84_ = json_object_has_member (_tmp83_, "name");
			if (_tmp84_) {
				JsonObject* _tmp85_;
				const gchar* _tmp86_ = NULL;
				gchar* _tmp87_;
				_tmp85_ = _recipient_obj;
				_tmp86_ = json_object_get_string_member (_tmp85_, "name");
				_tmp87_ = g_strdup (_tmp86_);
				_g_free0 (_recipient);
				_recipient = _tmp87_;
			}
			_tmp88_ = _recipient_obj;
			_tmp89_ = json_object_has_member (_tmp88_, "nick");
			if (_tmp89_) {
				JsonObject* _tmp90_;
				const gchar* _tmp91_ = NULL;
				gchar* _tmp92_;
				_tmp90_ = _recipient_obj;
				_tmp91_ = json_object_get_string_member (_tmp90_, "nick");
				_tmp92_ = g_strdup (_tmp91_);
				_g_free0 (_recipient_nick);
				_recipient_nick = _tmp92_;
			}
			_tmp93_ = _recipient_obj;
			_tmp94_ = json_object_has_member (_tmp93_, "image");
			if (_tmp94_) {
				JsonObject* _tmp95_;
				const gchar* _tmp96_ = NULL;
				gchar* _tmp97_;
				_tmp95_ = _recipient_obj;
				_tmp96_ = json_object_get_string_member (_tmp95_, "image");
				_tmp97_ = g_strdup (_tmp96_);
				_g_free0 (_recipient_icon);
				_recipient_icon = _tmp97_;
			}
		}
	}
	_tmp98_ = obj;
	_tmp99_ = json_object_has_member (_tmp98_, "sender");
	if (_tmp99_) {
		JsonObject* _tmp100_;
		JsonObject* _tmp101_ = NULL;
		JsonObject* _tmp102_;
		JsonObject* _tmp103_;
		_tmp100_ = obj;
		_tmp101_ = json_object_get_object_member (_tmp100_, "sender");
		_tmp102_ = __vala_JsonObject_copy0 (_tmp101_);
		__vala_JsonObject_free0 (_sender_obj);
		_sender_obj = _tmp102_;
		_tmp103_ = _sender_obj;
		if (_tmp103_ != NULL) {
			JsonObject* _tmp104_;
			gboolean _tmp105_ = FALSE;
			JsonObject* _tmp109_;
			gboolean _tmp110_ = FALSE;
			_tmp104_ = _sender_obj;
			_tmp105_ = json_object_has_member (_tmp104_, "name");
			if (_tmp105_) {
				JsonObject* _tmp106_;
				const gchar* _tmp107_ = NULL;
				gchar* _tmp108_;
				_tmp106_ = _sender_obj;
				_tmp107_ = json_object_get_string_member (_tmp106_, "name");
				_tmp108_ = g_strdup (_tmp107_);
				_g_free0 (_sender);
				_sender = _tmp108_;
			}
			_tmp109_ = _sender_obj;
			_tmp110_ = json_object_has_member (_tmp109_, "nick");
			if (_tmp110_) {
				JsonObject* _tmp111_;
				const gchar* _tmp112_ = NULL;
				gchar* _tmp113_;
				_tmp111_ = _sender_obj;
				_tmp112_ = json_object_get_string_member (_tmp111_, "nick");
				_tmp113_ = g_strdup (_tmp112_);
				_g_free0 (_sender_nick);
				_sender_nick = _tmp113_;
			}
		}
	}
	_tmp114_ = _sender_obj;
	_tmp115_ = json_object_has_member (_tmp114_, "is_me");
	if (_tmp115_) {
		JsonObject* _tmp116_;
		gboolean _tmp117_ = FALSE;
		_tmp116_ = _sender_obj;
		_tmp117_ = json_object_get_boolean_member (_tmp116_, "is_me");
		_from_me = _tmp117_;
	}
	_tmp118_ = obj;
	_tmp119_ = json_object_has_member (_tmp118_, "time");
	if (_tmp119_) {
		JsonObject* _tmp120_;
		gdouble _tmp121_ = 0.0;
		_tmp120_ = obj;
		_tmp121_ = json_object_get_double_member (_tmp120_, "time");
		_time = (guint) _tmp121_;
	}
	_tmp123_ = _time;
	if (_tmp123_ < ((guint) 1)) {
		JsonObject* _tmp124_;
		gboolean _tmp125_ = FALSE;
		_tmp124_ = obj;
		_tmp125_ = json_object_has_member (_tmp124_, "time");
		_tmp122_ = _tmp125_;
	} else {
		_tmp122_ = FALSE;
	}
	_tmp126_ = _tmp122_;
	if (_tmp126_) {
		JsonObject* _tmp127_;
		gint64 _tmp128_ = 0LL;
		_tmp127_ = obj;
		_tmp128_ = json_object_get_int_member (_tmp127_, "time");
		_time = (guint) _tmp128_;
	}
	_tmp129_ = obj;
	_tmp130_ = json_object_has_member (_tmp129_, "content");
	if (_tmp130_) {
		JsonObject* _tmp131_;
		const gchar* _tmp132_ = NULL;
		gchar* _tmp133_;
		_tmp131_ = obj;
		_tmp132_ = json_object_get_string_member (_tmp131_, "content");
		_tmp133_ = g_strdup (_tmp132_);
		_g_free0 (_html);
		_html = _tmp133_;
	}
	_tmp134_ = obj;
	_tmp135_ = json_object_has_member (_tmp134_, "text");
	if (_tmp135_) {
		JsonObject* _tmp136_;
		const gchar* _tmp137_ = NULL;
		gchar* _tmp138_;
		_tmp136_ = obj;
		_tmp137_ = json_object_get_string_member (_tmp136_, "text");
		_tmp138_ = g_strdup (_tmp137_);
		_g_free0 (_text);
		_text = _tmp138_;
	}
	_tmp139_ = _text;
	_tmp140_ = gwibber_streams_gen_text_id (self, _tmp139_);
	_textid = _tmp140_;
	_tmp141_ = _sender_obj;
	_tmp142_ = json_object_has_member (_tmp141_, "image");
	if (_tmp142_) {
		JsonObject* _tmp143_;
		const gchar* _tmp144_ = NULL;
		gchar* _tmp145_;
		_tmp143_ = _sender_obj;
		_tmp144_ = json_object_get_string_member (_tmp143_, "image");
		_tmp145_ = g_strdup (_tmp144_);
		_g_free0 (_icon);
		_icon = _tmp145_;
	}
	_tmp146_ = obj;
	_tmp147_ = json_object_has_member (_tmp146_, "url");
	if (_tmp147_) {
		JsonObject* _tmp148_;
		const gchar* _tmp149_ = NULL;
		gchar* _tmp150_;
		_tmp148_ = obj;
		_tmp149_ = json_object_get_string_member (_tmp148_, "url");
		_tmp150_ = g_strdup (_tmp149_);
		_g_free0 (_url);
		_url = _tmp150_;
	}
	_tmp151_ = members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp151_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			gchar* _tmp152_;
			gchar* member = NULL;
			_tmp152_ = g_strdup ((const gchar*) member_it->data);
			member = _tmp152_;
			{
				const gchar* _tmp153_;
				const gchar* _tmp174_;
				const gchar* _tmp181_;
				const gchar* _tmp204_;
				const gchar* _tmp217_;
				const gchar* _tmp220_;
				const gchar* _tmp259_;
				const gchar* _tmp283_;
				const gchar* _tmp312_;
				const gchar* _tmp352_;
				_tmp153_ = member;
				if (g_strcmp0 (_tmp153_, "retweeted_by") == 0) {
					JsonObject* _tmp154_;
					const gchar* _tmp155_;
					JsonObject* _tmp156_ = NULL;
					JsonObject* _tmp157_;
					JsonObject* _retweet_obj;
					JsonObject* _tmp158_;
					_tmp154_ = obj;
					_tmp155_ = member;
					_tmp156_ = json_object_get_object_member (_tmp154_, _tmp155_);
					_tmp157_ = __vala_JsonObject_copy0 (_tmp156_);
					_retweet_obj = _tmp157_;
					_tmp158_ = _retweet_obj;
					if (_tmp158_ != NULL) {
						JsonObject* _tmp159_;
						gboolean _tmp160_ = FALSE;
						JsonObject* _tmp164_;
						gboolean _tmp165_ = FALSE;
						JsonObject* _tmp169_;
						gboolean _tmp170_ = FALSE;
						_tmp159_ = _retweet_obj;
						_tmp160_ = json_object_has_member (_tmp159_, "nick");
						if (_tmp160_) {
							JsonObject* _tmp161_;
							const gchar* _tmp162_ = NULL;
							gchar* _tmp163_;
							_tmp161_ = _retweet_obj;
							_tmp162_ = json_object_get_string_member (_tmp161_, "nick");
							_tmp163_ = g_strdup (_tmp162_);
							_g_free0 (_retweeted_by_nick);
							_retweeted_by_nick = _tmp163_;
						}
						_tmp164_ = _retweet_obj;
						_tmp165_ = json_object_has_member (_tmp164_, "name");
						if (_tmp165_) {
							JsonObject* _tmp166_;
							const gchar* _tmp167_ = NULL;
							gchar* _tmp168_;
							_tmp166_ = _retweet_obj;
							_tmp167_ = json_object_get_string_member (_tmp166_, "name");
							_tmp168_ = g_strdup (_tmp167_);
							_g_free0 (_retweeted_by_name);
							_retweeted_by_name = _tmp168_;
						}
						_tmp169_ = _retweet_obj;
						_tmp170_ = json_object_has_member (_tmp169_, "id");
						if (_tmp170_) {
							JsonObject* _tmp171_;
							gint64 _tmp172_ = 0LL;
							gchar* _tmp173_ = NULL;
							_tmp171_ = _retweet_obj;
							_tmp172_ = json_object_get_int_member (_tmp171_, "id");
							_tmp173_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp172_);
							_g_free0 (_retweeted_by_id);
							_retweeted_by_id = _tmp173_;
						}
					}
					__vala_JsonObject_free0 (_retweet_obj);
				}
				_tmp174_ = member;
				if (g_strcmp0 (_tmp174_, "source") == 0) {
					JsonObject* _tmp175_;
					const gchar* _tmp176_ = NULL;
					gchar* _tmp177_;
					const gchar* _tmp178_;
					_tmp175_ = obj;
					_tmp176_ = json_object_get_string_member (_tmp175_, "source");
					_tmp177_ = g_strdup (_tmp176_);
					_g_free0 (_source);
					_source = _tmp177_;
					_tmp178_ = _source;
					if (_tmp178_ != NULL) {
						const gchar* _tmp179_;
						gchar* _tmp180_ = NULL;
						_tmp179_ = _source;
						_tmp180_ = string_replace (_tmp179_, "rel=\"nofollow\"", "");
						_g_free0 (_source);
						_source = _tmp180_;
					}
				}
				_tmp181_ = member;
				if (g_strcmp0 (_tmp181_, "reply") == 0) {
					JsonObject* _tmp182_;
					JsonObject* _tmp183_ = NULL;
					JsonObject* _tmp184_;
					JsonObject* _reply_obj;
					JsonObject* _tmp185_;
					_tmp182_ = obj;
					_tmp183_ = json_object_get_object_member (_tmp182_, "reply");
					_tmp184_ = __vala_JsonObject_copy0 (_tmp183_);
					_reply_obj = _tmp184_;
					_tmp185_ = _reply_obj;
					if (_tmp185_ != NULL) {
						JsonObject* _tmp186_;
						gboolean _tmp187_ = FALSE;
						JsonObject* _tmp191_;
						gboolean _tmp192_ = FALSE;
						JsonObject* _tmp196_;
						gboolean _tmp197_ = FALSE;
						_tmp186_ = _reply_obj;
						_tmp187_ = json_object_has_member (_tmp186_, "nick");
						if (_tmp187_) {
							JsonObject* _tmp188_;
							const gchar* _tmp189_ = NULL;
							gchar* _tmp190_;
							_tmp188_ = _reply_obj;
							_tmp189_ = json_object_get_string_member (_tmp188_, "nick");
							_tmp190_ = g_strdup (_tmp189_);
							_g_free0 (_reply_nick);
							_reply_nick = _tmp190_;
						}
						_tmp191_ = _reply_obj;
						_tmp192_ = json_object_has_member (_tmp191_, "name");
						if (_tmp192_) {
							JsonObject* _tmp193_;
							const gchar* _tmp194_ = NULL;
							gchar* _tmp195_;
							_tmp193_ = _reply_obj;
							_tmp194_ = json_object_get_string_member (_tmp193_, "name");
							_tmp195_ = g_strdup (_tmp194_);
							_g_free0 (_reply_name);
							_reply_name = _tmp195_;
						}
						_tmp196_ = _reply_obj;
						_tmp197_ = json_object_has_member (_tmp196_, "url");
						if (_tmp197_) {
							JsonObject* _tmp198_;
							const gchar* _tmp199_ = NULL;
							gchar* _tmp200_;
							const gchar* _tmp201_;
							_tmp198_ = _reply_obj;
							_tmp199_ = json_object_get_string_member (_tmp198_, "url");
							_tmp200_ = g_strdup (_tmp199_);
							_g_free0 (_reply_url);
							_reply_url = _tmp200_;
							_tmp201_ = _reply_url;
							if (_tmp201_ != NULL) {
								const gchar* _tmp202_;
								gchar* _tmp203_ = NULL;
								_tmp202_ = _reply_url;
								_tmp203_ = g_markup_escape_text (_tmp202_, (gssize) (-1));
								_g_free0 (_reply_url);
								_reply_url = _tmp203_;
							}
						}
					}
					__vala_JsonObject_free0 (_reply_obj);
				}
				_tmp204_ = member;
				if (g_strcmp0 (_tmp204_, "likes") == 0) {
					JsonObject* _tmp205_;
					JsonObject* _tmp206_ = NULL;
					JsonObject* _tmp207_;
					JsonObject* _likes_obj;
					JsonObject* _tmp208_;
					_tmp205_ = obj;
					_tmp206_ = json_object_get_object_member (_tmp205_, "likes");
					_tmp207_ = __vala_JsonObject_copy0 (_tmp206_);
					_likes_obj = _tmp207_;
					_tmp208_ = _likes_obj;
					if (_tmp208_ != NULL) {
						JsonObject* _tmp209_;
						gboolean _tmp210_ = FALSE;
						JsonObject* _tmp213_;
						gboolean _tmp214_ = FALSE;
						_tmp209_ = _likes_obj;
						_tmp210_ = json_object_has_member (_tmp209_, "count");
						if (_tmp210_) {
							JsonObject* _tmp211_;
							gint64 _tmp212_ = 0LL;
							_tmp211_ = _likes_obj;
							_tmp212_ = json_object_get_int_member (_tmp211_, "count");
							_likes = (gdouble) _tmp212_;
						}
						_tmp213_ = _likes_obj;
						_tmp214_ = json_object_has_member (_tmp213_, "liked");
						if (_tmp214_) {
							JsonObject* _tmp215_;
							gboolean _tmp216_ = FALSE;
							_tmp215_ = _likes_obj;
							_tmp216_ = json_object_get_boolean_member (_tmp215_, "liked");
							_liked = _tmp216_;
						}
					}
					__vala_JsonObject_free0 (_likes_obj);
				}
				_tmp217_ = member;
				if (g_strcmp0 (_tmp217_, "favorited") == 0) {
					JsonObject* _tmp218_;
					gboolean _tmp219_ = FALSE;
					_tmp218_ = obj;
					_tmp219_ = json_object_get_boolean_member (_tmp218_, "favorited");
					if (_tmp219_) {
						_likes = (gdouble) (-1);
					}
				}
				_tmp220_ = member;
				if (g_strcmp0 (_tmp220_, "link") == 0) {
					JsonObject* _tmp221_;
					const gchar* _tmp222_;
					JsonObject* _tmp223_ = NULL;
					JsonObject* _tmp224_;
					JsonObject* _link_obj;
					JsonObject* _tmp225_;
					_tmp221_ = obj;
					_tmp222_ = member;
					_tmp223_ = json_object_get_object_member (_tmp221_, _tmp222_);
					_tmp224_ = __vala_JsonObject_copy0 (_tmp223_);
					_link_obj = _tmp224_;
					_tmp225_ = _link_obj;
					if (_tmp225_ != NULL) {
						JsonObject* _tmp226_;
						gboolean _tmp227_ = FALSE;
						JsonObject* _tmp231_;
						gboolean _tmp232_ = FALSE;
						JsonObject* _tmp236_;
						gboolean _tmp237_ = FALSE;
						JsonObject* _tmp244_;
						gboolean _tmp245_ = FALSE;
						JsonObject* _tmp249_;
						gboolean _tmp250_ = FALSE;
						JsonObject* _tmp254_;
						gboolean _tmp255_ = FALSE;
						_tmp226_ = _link_obj;
						_tmp227_ = json_object_has_member (_tmp226_, "picture");
						if (_tmp227_) {
							JsonObject* _tmp228_;
							const gchar* _tmp229_ = NULL;
							gchar* _tmp230_;
							_tmp228_ = _link_obj;
							_tmp229_ = json_object_get_string_member (_tmp228_, "picture");
							_tmp230_ = g_strdup (_tmp229_);
							_g_free0 (_link_picture);
							_link_picture = _tmp230_;
						}
						_tmp231_ = _link_obj;
						_tmp232_ = json_object_has_member (_tmp231_, "name");
						if (_tmp232_) {
							JsonObject* _tmp233_;
							const gchar* _tmp234_ = NULL;
							gchar* _tmp235_;
							_tmp233_ = _link_obj;
							_tmp234_ = json_object_get_string_member (_tmp233_, "name");
							_tmp235_ = g_strdup (_tmp234_);
							_g_free0 (_link_name);
							_link_name = _tmp235_;
						}
						_tmp236_ = _link_obj;
						_tmp237_ = json_object_has_member (_tmp236_, "url");
						if (_tmp237_) {
							JsonObject* _tmp238_;
							const gchar* _tmp239_ = NULL;
							gchar* _tmp240_;
							const gchar* _tmp241_;
							_tmp238_ = _link_obj;
							_tmp239_ = json_object_get_string_member (_tmp238_, "url");
							_tmp240_ = g_strdup (_tmp239_);
							_g_free0 (_link_url);
							_link_url = _tmp240_;
							_tmp241_ = _link_url;
							if (_tmp241_ != NULL) {
								const gchar* _tmp242_;
								gchar* _tmp243_ = NULL;
								_tmp242_ = _link_url;
								_tmp243_ = g_markup_escape_text (_tmp242_, (gssize) (-1));
								_g_free0 (_link_url);
								_link_url = _tmp243_;
							}
						}
						_tmp244_ = _link_obj;
						_tmp245_ = json_object_has_member (_tmp244_, "description");
						if (_tmp245_) {
							JsonObject* _tmp246_;
							const gchar* _tmp247_ = NULL;
							gchar* _tmp248_;
							_tmp246_ = _link_obj;
							_tmp247_ = json_object_get_string_member (_tmp246_, "description");
							_tmp248_ = g_strdup (_tmp247_);
							_g_free0 (_link_description);
							_link_description = _tmp248_;
						}
						_tmp249_ = _link_obj;
						_tmp250_ = json_object_has_member (_tmp249_, "caption");
						if (_tmp250_) {
							JsonObject* _tmp251_;
							const gchar* _tmp252_ = NULL;
							gchar* _tmp253_;
							_tmp251_ = _link_obj;
							_tmp252_ = json_object_get_string_member (_tmp251_, "caption");
							_tmp253_ = g_strdup (_tmp252_);
							_g_free0 (_link_caption);
							_link_caption = _tmp253_;
						}
						_tmp254_ = _link_obj;
						_tmp255_ = json_object_has_member (_tmp254_, "icon");
						if (_tmp255_) {
							JsonObject* _tmp256_;
							const gchar* _tmp257_ = NULL;
							gchar* _tmp258_;
							_tmp256_ = _link_obj;
							_tmp257_ = json_object_get_string_member (_tmp256_, "icon");
							_tmp258_ = g_strdup (_tmp257_);
							_g_free0 (_link_icon);
							_link_icon = _tmp258_;
						}
					}
					__vala_JsonObject_free0 (_link_obj);
				}
				_tmp259_ = member;
				if (g_strcmp0 (_tmp259_, "photo") == 0) {
					JsonObject* _tmp260_;
					const gchar* _tmp261_;
					JsonObject* _tmp262_ = NULL;
					JsonObject* _tmp263_;
					JsonObject* _photo_obj;
					JsonObject* _tmp264_;
					_tmp260_ = obj;
					_tmp261_ = member;
					_tmp262_ = json_object_get_object_member (_tmp260_, _tmp261_);
					_tmp263_ = __vala_JsonObject_copy0 (_tmp262_);
					_photo_obj = _tmp263_;
					_tmp264_ = _photo_obj;
					if (_tmp264_ != NULL) {
						JsonObject* _tmp265_;
						gboolean _tmp266_ = FALSE;
						JsonObject* _tmp273_;
						gboolean _tmp274_ = FALSE;
						JsonObject* _tmp278_;
						gboolean _tmp279_ = FALSE;
						_tmp265_ = _photo_obj;
						_tmp266_ = json_object_has_member (_tmp265_, "url");
						if (_tmp266_) {
							JsonObject* _tmp267_;
							const gchar* _tmp268_ = NULL;
							gchar* _tmp269_;
							const gchar* _tmp270_;
							_tmp267_ = _photo_obj;
							_tmp268_ = json_object_get_string_member (_tmp267_, "url");
							_tmp269_ = g_strdup (_tmp268_);
							_g_free0 (_image_url);
							_image_url = _tmp269_;
							_tmp270_ = _image_url;
							if (_tmp270_ != NULL) {
								const gchar* _tmp271_;
								gchar* _tmp272_ = NULL;
								_tmp271_ = _image_url;
								_tmp272_ = g_markup_escape_text (_tmp271_, (gssize) (-1));
								_g_free0 (_image_url);
								_image_url = _tmp272_;
							}
						}
						_tmp273_ = _photo_obj;
						_tmp274_ = json_object_has_member (_tmp273_, "picture");
						if (_tmp274_) {
							JsonObject* _tmp275_;
							const gchar* _tmp276_ = NULL;
							gchar* _tmp277_;
							_tmp275_ = _photo_obj;
							_tmp276_ = json_object_get_string_member (_tmp275_, "picture");
							_tmp277_ = g_strdup (_tmp276_);
							_g_free0 (_image_src);
							_image_src = _tmp277_;
						}
						_tmp278_ = _photo_obj;
						_tmp279_ = json_object_has_member (_tmp278_, "name");
						if (_tmp279_) {
							JsonObject* _tmp280_;
							const gchar* _tmp281_ = NULL;
							gchar* _tmp282_;
							_tmp280_ = _photo_obj;
							_tmp281_ = json_object_get_string_member (_tmp280_, "name");
							_tmp282_ = g_strdup (_tmp281_);
							_g_free0 (_image_name);
							_image_name = _tmp282_;
						}
					}
					__vala_JsonObject_free0 (_photo_obj);
				}
				_tmp283_ = member;
				if (g_strcmp0 (_tmp283_, "video") == 0) {
					JsonObject* _tmp284_;
					const gchar* _tmp285_;
					JsonObject* _tmp286_ = NULL;
					JsonObject* _tmp287_;
					JsonObject* _video_obj;
					JsonObject* _tmp288_;
					_tmp284_ = obj;
					_tmp285_ = member;
					_tmp286_ = json_object_get_object_member (_tmp284_, _tmp285_);
					_tmp287_ = __vala_JsonObject_copy0 (_tmp286_);
					_video_obj = _tmp287_;
					_tmp288_ = _video_obj;
					if (_tmp288_ != NULL) {
						JsonObject* _tmp289_;
						gboolean _tmp290_ = FALSE;
						JsonObject* _tmp294_;
						gboolean _tmp295_ = FALSE;
						JsonObject* _tmp299_;
						gboolean _tmp300_ = FALSE;
						JsonObject* _tmp307_;
						gboolean _tmp308_ = FALSE;
						_tmp289_ = _video_obj;
						_tmp290_ = json_object_has_member (_tmp289_, "name");
						if (_tmp290_) {
							JsonObject* _tmp291_;
							const gchar* _tmp292_ = NULL;
							gchar* _tmp293_;
							_tmp291_ = _video_obj;
							_tmp292_ = json_object_get_string_member (_tmp291_, "name");
							_tmp293_ = g_strdup (_tmp292_);
							_g_free0 (_video_name);
							_video_name = _tmp293_;
						}
						_tmp294_ = _video_obj;
						_tmp295_ = json_object_has_member (_tmp294_, "picture");
						if (_tmp295_) {
							JsonObject* _tmp296_;
							const gchar* _tmp297_ = NULL;
							gchar* _tmp298_;
							_tmp296_ = _video_obj;
							_tmp297_ = json_object_get_string_member (_tmp296_, "picture");
							_tmp298_ = g_strdup (_tmp297_);
							_g_free0 (_video_picture);
							_video_picture = _tmp298_;
						}
						_tmp299_ = _video_obj;
						_tmp300_ = json_object_has_member (_tmp299_, "url");
						if (_tmp300_) {
							JsonObject* _tmp301_;
							const gchar* _tmp302_ = NULL;
							gchar* _tmp303_;
							const gchar* _tmp304_;
							_tmp301_ = _video_obj;
							_tmp302_ = json_object_get_string_member (_tmp301_, "url");
							_tmp303_ = g_strdup (_tmp302_);
							_g_free0 (_video_url);
							_video_url = _tmp303_;
							_tmp304_ = _video_url;
							if (_tmp304_ != NULL) {
								const gchar* _tmp305_;
								gchar* _tmp306_ = NULL;
								_tmp305_ = _video_url;
								_tmp306_ = g_markup_escape_text (_tmp305_, (gssize) (-1));
								_g_free0 (_video_url);
								_video_url = _tmp306_;
							}
						}
						_tmp307_ = _video_obj;
						_tmp308_ = json_object_has_member (_tmp307_, "source");
						if (_tmp308_) {
							JsonObject* _tmp309_;
							const gchar* _tmp310_ = NULL;
							gchar* _tmp311_;
							_tmp309_ = _video_obj;
							_tmp310_ = json_object_get_string_member (_tmp309_, "source");
							_tmp311_ = g_strdup (_tmp310_);
							_g_free0 (_video_src);
							_video_src = _tmp311_;
						}
					}
					__vala_JsonObject_free0 (_video_obj);
				}
				_tmp312_ = member;
				if (g_strcmp0 (_tmp312_, "images") == 0) {
					JsonObject* _tmp313_;
					const gchar* _tmp314_;
					JsonArray* _tmp315_ = NULL;
					JsonArray* _tmp316_;
					JsonArray* _images_array;
					JsonArray* _tmp317_;
					_tmp313_ = obj;
					_tmp314_ = member;
					_tmp315_ = json_object_get_array_member (_tmp313_, _tmp314_);
					_tmp316_ = __vala_JsonArray_copy0 (_tmp315_);
					_images_array = _tmp316_;
					_tmp317_ = _images_array;
					if (_tmp317_ != NULL) {
						JsonArray* _tmp318_;
						JsonNode* _tmp319_ = NULL;
						JsonObject* _tmp320_ = NULL;
						JsonObject* _tmp321_;
						JsonObject* _image_obj;
						JsonObject* _tmp322_;
						_tmp318_ = _images_array;
						_tmp319_ = json_array_get_element (_tmp318_, (guint) 0);
						_tmp320_ = json_node_get_object (_tmp319_);
						_tmp321_ = __vala_JsonObject_copy0 (_tmp320_);
						_image_obj = _tmp321_;
						_tmp322_ = _image_obj;
						if (_tmp322_ != NULL) {
							JsonObject* _tmp323_;
							gboolean _tmp324_ = FALSE;
							JsonObject* _tmp331_;
							gboolean _tmp332_ = FALSE;
							JsonObject* _tmp339_;
							gboolean _tmp340_ = FALSE;
							JsonObject* _tmp347_;
							gboolean _tmp348_ = FALSE;
							_tmp323_ = _image_obj;
							_tmp324_ = json_object_has_member (_tmp323_, "url");
							if (_tmp324_) {
								JsonObject* _tmp325_;
								const gchar* _tmp326_ = NULL;
								gchar* _tmp327_;
								const gchar* _tmp328_;
								_tmp325_ = _image_obj;
								_tmp326_ = json_object_get_string_member (_tmp325_, "url");
								_tmp327_ = g_strdup (_tmp326_);
								_g_free0 (_image_url);
								_image_url = _tmp327_;
								_tmp328_ = _image_url;
								if (_tmp328_ != NULL) {
									const gchar* _tmp329_;
									gchar* _tmp330_ = NULL;
									_tmp329_ = _image_url;
									_tmp330_ = g_markup_escape_text (_tmp329_, (gssize) (-1));
									_g_free0 (_image_url);
									_image_url = _tmp330_;
								}
							}
							_tmp331_ = _image_obj;
							_tmp332_ = json_object_has_member (_tmp331_, "src");
							if (_tmp332_) {
								JsonObject* _tmp333_;
								const gchar* _tmp334_ = NULL;
								gchar* _tmp335_;
								const gchar* _tmp336_;
								_tmp333_ = _image_obj;
								_tmp334_ = json_object_get_string_member (_tmp333_, "src");
								_tmp335_ = g_strdup (_tmp334_);
								_g_free0 (_image_src);
								_image_src = _tmp335_;
								_tmp336_ = _image_src;
								if (_tmp336_ != NULL) {
									const gchar* _tmp337_;
									gchar* _tmp338_ = NULL;
									_tmp337_ = _image_src;
									_tmp338_ = g_markup_escape_text (_tmp337_, (gssize) (-1));
									_g_free0 (_image_src);
									_image_src = _tmp338_;
								}
							}
							_tmp339_ = _image_obj;
							_tmp340_ = json_object_has_member (_tmp339_, "thumb");
							if (_tmp340_) {
								JsonObject* _tmp341_;
								const gchar* _tmp342_ = NULL;
								gchar* _tmp343_;
								const gchar* _tmp344_;
								_tmp341_ = _image_obj;
								_tmp342_ = json_object_get_string_member (_tmp341_, "thumb");
								_tmp343_ = g_strdup (_tmp342_);
								_g_free0 (_image_thumb);
								_image_thumb = _tmp343_;
								_tmp344_ = _image_thumb;
								if (_tmp344_ != NULL) {
									const gchar* _tmp345_;
									gchar* _tmp346_ = NULL;
									_tmp345_ = _image_thumb;
									_tmp346_ = g_markup_escape_text (_tmp345_, (gssize) (-1));
									_g_free0 (_image_thumb);
									_image_thumb = _tmp346_;
								}
							}
							_tmp347_ = _image_obj;
							_tmp348_ = json_object_has_member (_tmp347_, "name");
							if (_tmp348_) {
								JsonObject* _tmp349_;
								const gchar* _tmp350_ = NULL;
								gchar* _tmp351_;
								_tmp349_ = _image_obj;
								_tmp350_ = json_object_get_string_member (_tmp349_, "name");
								_tmp351_ = g_strdup (_tmp350_);
								_g_free0 (_image_name);
								_image_name = _tmp351_;
							}
						}
						__vala_JsonObject_free0 (_image_obj);
					}
					__vala_JsonArray_free0 (_images_array);
				}
				_tmp352_ = member;
				if (g_strcmp0 (_tmp352_, "comments") == 0) {
					gsize length = 0UL;
					JsonObject* _tmp353_;
					const gchar* _tmp354_;
					JsonArray* _tmp355_ = NULL;
					JsonArray* _tmp356_;
					JsonArray* _comments_array;
					JsonGenerator* _tmp357_;
					JsonGenerator* comment_gen;
					JsonNode* _tmp358_;
					JsonNode* root;
					JsonObject* _tmp359_;
					JsonObject* object;
					JsonNode* _tmp360_;
					JsonObject* _tmp361_;
					JsonObject* _tmp362_;
					JsonArray* _tmp363_;
					JsonArray* _tmp364_;
					JsonGenerator* _tmp365_;
					JsonNode* _tmp366_;
					JsonGenerator* _tmp367_;
					gsize _tmp368_ = 0UL;
					gchar* _tmp369_ = NULL;
					_tmp353_ = obj;
					_tmp354_ = member;
					_tmp355_ = json_object_get_array_member (_tmp353_, _tmp354_);
					_tmp356_ = __vala_JsonArray_copy0 (_tmp355_);
					_comments_array = _tmp356_;
					_tmp357_ = json_generator_new ();
					comment_gen = _tmp357_;
					_tmp358_ = json_node_new (JSON_NODE_OBJECT);
					root = _tmp358_;
					_tmp359_ = json_object_new ();
					object = _tmp359_;
					_tmp360_ = root;
					_tmp361_ = object;
					json_node_set_object (_tmp360_, _tmp361_);
					_tmp362_ = object;
					_tmp363_ = _comments_array;
					_tmp364_ = __vala_JsonArray_copy0 (_tmp363_);
					json_object_set_array_member (_tmp362_, "comments", _tmp364_);
					_tmp365_ = comment_gen;
					_tmp366_ = root;
					json_generator_set_root (_tmp365_, _tmp366_);
					_tmp367_ = comment_gen;
					_tmp369_ = json_generator_to_data (_tmp367_, &_tmp368_);
					length = _tmp368_;
					_g_free0 (_comments);
					_comments = _tmp369_;
					__vala_JsonObject_free0 (object);
					__vala_JsonNode_free0 (root);
					_g_object_unref0 (comment_gen);
					__vala_JsonArray_free0 (_comments_array);
				}
				_g_free0 (member);
			}
		}
	}
	_tmp370_ = _link_name;
	if (_tmp370_ != NULL) {
		const gchar* _tmp371_;
		gchar* _tmp372_ = NULL;
		_tmp371_ = _link_name;
		_tmp372_ = g_markup_escape_text (_tmp371_, (gssize) (-1));
		_g_free0 (_link_name);
		_link_name = _tmp372_;
	}
	_tmp373_ = _image_name;
	if (_tmp373_ != NULL) {
		const gchar* _tmp374_;
		gchar* _tmp375_ = NULL;
		_tmp374_ = _image_name;
		_tmp375_ = g_markup_escape_text (_tmp374_, (gssize) (-1));
		_g_free0 (_image_name);
		_image_name = _tmp375_;
	}
	_tmp376_ = _video_name;
	if (_tmp376_ != NULL) {
		const gchar* _tmp377_;
		gchar* _tmp378_ = NULL;
		_tmp377_ = _video_name;
		_tmp378_ = g_markup_escape_text (_tmp377_, (gssize) (-1));
		_g_free0 (_video_name);
		_video_name = _tmp378_;
	}
	_tmp379_ = _html;
	if (_tmp379_ != NULL) {
		const gchar* _tmp380_;
		gchar* _tmp381_ = NULL;
		_tmp380_ = _html;
		_tmp381_ = gwibber_streams_scrub (self, _tmp380_);
		_g_free0 (_html);
		_html = _tmp381_;
	}
	_tmp382_ = _link_description;
	if (_tmp382_ != NULL) {
		const gchar* _tmp383_;
		gchar* _tmp384_ = NULL;
		_tmp383_ = _link_description;
		_tmp384_ = gwibber_streams_scrub (self, _tmp383_);
		_g_free0 (_link_description);
		_link_description = _tmp384_;
	}
	_tmp386_ = _textid;
	_tmp387_ = strlen (_tmp386_);
	_tmp388_ = _tmp387_;
	if (_tmp388_ < 1) {
		const gchar* _tmp389_;
		_tmp389_ = _html;
		_tmp385_ = _tmp389_ != NULL;
	} else {
		_tmp385_ = FALSE;
	}
	_tmp390_ = _tmp385_;
	if (_tmp390_) {
		const gchar* _tmp391_;
		gchar* _tmp392_ = NULL;
		_tmp391_ = _html;
		_tmp392_ = gwibber_streams_gen_text_id (self, _tmp391_);
		_g_free0 (_textid);
		_textid = _tmp392_;
	}
	_tmp394_ = _textid;
	_tmp395_ = strlen (_tmp394_);
	_tmp396_ = _tmp395_;
	if (_tmp396_ < 1) {
		const gchar* _tmp397_;
		_tmp397_ = _link_description;
		_tmp393_ = _tmp397_ != NULL;
	} else {
		_tmp393_ = FALSE;
	}
	_tmp398_ = _tmp393_;
	if (_tmp398_) {
		const gchar* _tmp399_;
		gchar* _tmp400_ = NULL;
		_tmp399_ = _link_description;
		_tmp400_ = gwibber_streams_gen_text_id (self, _tmp399_);
		_g_free0 (_textid);
		_textid = _tmp400_;
	}
	_tmp402_ = _textid;
	_tmp403_ = strlen (_tmp402_);
	_tmp404_ = _tmp403_;
	if (_tmp404_ < 1) {
		const gchar* _tmp405_;
		_tmp405_ = _link_name;
		_tmp401_ = _tmp405_ != NULL;
	} else {
		_tmp401_ = FALSE;
	}
	_tmp406_ = _tmp401_;
	if (_tmp406_) {
		const gchar* _tmp407_;
		gchar* _tmp408_ = NULL;
		_tmp407_ = _link_name;
		_tmp408_ = gwibber_streams_gen_text_id (self, _tmp407_);
		_g_free0 (_textid);
		_textid = _tmp408_;
	}
	_tmp410_ = _textid;
	_tmp411_ = strlen (_tmp410_);
	_tmp412_ = _tmp411_;
	if (_tmp412_ < 1) {
		const gchar* _tmp413_;
		_tmp413_ = _image_url;
		_tmp409_ = _tmp413_ != NULL;
	} else {
		_tmp409_ = FALSE;
	}
	_tmp414_ = _tmp409_;
	if (_tmp414_) {
		const gchar* _tmp415_;
		gchar* _tmp416_ = NULL;
		_tmp415_ = _image_url;
		_tmp416_ = string_strip (_tmp415_);
		_g_free0 (_textid);
		_textid = _tmp416_;
	}
	_tmp418_ = _textid;
	_tmp419_ = strlen (_tmp418_);
	_tmp420_ = _tmp419_;
	if (_tmp420_ < 1) {
		const gchar* _tmp421_;
		_tmp421_ = _image_name;
		_tmp417_ = _tmp421_ != NULL;
	} else {
		_tmp417_ = FALSE;
	}
	_tmp422_ = _tmp417_;
	if (_tmp422_) {
		const gchar* _tmp423_;
		gchar* _tmp424_ = NULL;
		_tmp423_ = _image_name;
		_tmp424_ = gwibber_streams_gen_text_id (self, _tmp423_);
		_g_free0 (_textid);
		_textid = _tmp424_;
	}
	_tmp426_ = _textid;
	_tmp427_ = strlen (_tmp426_);
	_tmp428_ = _tmp427_;
	if (_tmp428_ < 1) {
		const gchar* _tmp429_;
		_tmp429_ = _video_url;
		_tmp425_ = _tmp429_ != NULL;
	} else {
		_tmp425_ = FALSE;
	}
	_tmp430_ = _tmp425_;
	if (_tmp430_) {
		const gchar* _tmp431_;
		gchar* _tmp432_ = NULL;
		_tmp431_ = _video_url;
		_tmp432_ = string_strip (_tmp431_);
		_g_free0 (_textid);
		_textid = _tmp432_;
	}
	_tmp434_ = _textid;
	_tmp435_ = strlen (_tmp434_);
	_tmp436_ = _tmp435_;
	if (_tmp436_ < 1) {
		const gchar* _tmp437_;
		_tmp437_ = _video_name;
		_tmp433_ = _tmp437_ != NULL;
	} else {
		_tmp433_ = FALSE;
	}
	_tmp438_ = _tmp433_;
	if (_tmp438_) {
		const gchar* _tmp439_;
		gchar* _tmp440_ = NULL;
		_tmp439_ = _video_name;
		_tmp440_ = gwibber_streams_gen_text_id (self, _tmp439_);
		_g_free0 (_textid);
		_textid = _tmp440_;
	}
	_tmp441_ = self->priv->utils;
	_tmp442_ = _time;
	_tmp443_ = gwibber_utils_generate_time_string (_tmp441_, _tmp442_);
	_t = _tmp443_;
	_tmp445_ = self->priv->seen;
	_tmp446_ = _textid;
	_tmp447_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp445_, _tmp446_);
	if (_tmp447_) {
		const gchar* _tmp448_;
		_tmp448_ = transient;
		_tmp444_ = g_strcmp0 (_tmp448_, "0") == 0;
	} else {
		_tmp444_ = FALSE;
	}
	_tmp449_ = _tmp444_;
	if (_tmp449_) {
		GeeHashMap* _tmp450_;
		const gchar* _tmp451_;
		gpointer _tmp452_ = NULL;
		DeeModelIter* _tmp453_;
		_tmp450_ = self->priv->seen;
		_tmp451_ = _textid;
		_tmp452_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp450_, _tmp451_);
		iter = (DeeModelIter*) _tmp452_;
		_tmp453_ = iter;
		if (_tmp453_ == NULL) {
			GeeHashMap* _tmp454_;
			const gchar* _tmp455_;
			_tmp454_ = self->priv->seen;
			_tmp455_ = _textid;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp454_, _tmp455_, NULL);
		} else {
			DeeModel* _tmp456_;
			DeeModelIter* _tmp457_;
			GVariant* _tmp458_ = NULL;
			GVariant* _tmp459_;
			gchar** _tmp460_;
			gint _tmp460__length1;
			gchar** _tmp464_;
			gint _tmp464__length1;
			gchar** _accounts_array;
			gint _accounts_array_length1;
			gint __accounts_array_size_;
			const gchar* _tmp465_;
			gchar** _tmp466_;
			gint _tmp466__length1;
			DeeModel* _tmp477_;
			DeeModelIter* _tmp478_;
			const gchar* _tmp479_;
			GVariant* _tmp480_;
			DeeModel* _tmp481_;
			DeeModelIter* _tmp482_;
			const gchar* _tmp483_;
			GVariant* _tmp484_;
			DeeModel* _tmp485_;
			DeeModelIter* _tmp486_;
			const gchar* _tmp487_;
			GVariant* _tmp488_;
			DeeModel* _tmp489_;
			DeeModelIter* _tmp490_;
			gdouble _tmp491_;
			GVariant* _tmp492_;
			DeeModel* _tmp493_;
			DeeModelIter* _tmp494_;
			gboolean _tmp495_;
			GVariant* _tmp496_;
			_tmp456_ = _model;
			_tmp457_ = iter;
			_tmp458_ = dee_model_get_value (_tmp456_, _tmp457_, (guint) GWIBBER_STREAM_MODEL_COLUMN_ACCOUNTS);
			_tmp459_ = _tmp458_;
			_tmp460_ = _variant_get1 (_tmp459_, &_tmp460__length1);
			_tmp464_ = _tmp460_;
			_tmp464__length1 = _tmp460__length1;
			_g_variant_unref0 (_tmp459_);
			_accounts_array = _tmp464_;
			_accounts_array_length1 = _tmp464__length1;
			__accounts_array_size_ = _accounts_array_length1;
			_tmp465_ = _acct;
			_tmp466_ = _accounts_array;
			_tmp466__length1 = _accounts_array_length1;
			if (!_vala_string_array_contains (_tmp466_, _tmp466__length1, _tmp465_)) {
				gchar** _tmp467_;
				gint _tmp467__length1;
				GVariantBuilder* _tmp471_;
				GVariant* _tmp472_;
				GVariant* _tmp473_;
				GVariant* _accounts;
				DeeModel* _tmp474_;
				DeeModelIter* _tmp475_;
				GVariant* _tmp476_;
				_tmp467_ = _accounts_array;
				_tmp467__length1 = _accounts_array_length1;
				{
					gchar** a_collection = NULL;
					gint a_collection_length1 = 0;
					gint _a_collection_size_ = 0;
					gint a_it = 0;
					a_collection = _tmp467_;
					a_collection_length1 = _tmp467__length1;
					for (a_it = 0; a_it < _tmp467__length1; a_it = a_it + 1) {
						gchar* _tmp468_;
						gchar* a = NULL;
						_tmp468_ = g_strdup (a_collection[a_it]);
						a = _tmp468_;
						{
							GVariantBuilder* _tmp469_;
							const gchar* _tmp470_;
							_tmp469_ = builder;
							_tmp470_ = a;
							g_variant_builder_add (_tmp469_, "s", _tmp470_, NULL);
							_g_free0 (a);
						}
					}
				}
				_tmp471_ = builder;
				_tmp472_ = g_variant_new ("as", _tmp471_, NULL);
				_tmp473_ = g_variant_ref_sink (_tmp472_);
				_accounts = _tmp473_;
				_tmp474_ = _model;
				_tmp475_ = iter;
				_tmp476_ = _accounts;
				dee_model_set_value (_tmp474_, _tmp475_, (guint) GWIBBER_STREAM_MODEL_COLUMN_ACCOUNTS, _tmp476_);
				_g_variant_unref0 (_accounts);
			}
			_tmp477_ = _model;
			_tmp478_ = iter;
			_tmp479_ = _text;
			_tmp480_ = _variant_new2 (_tmp479_);
			dee_model_set_value (_tmp477_, _tmp478_, (guint) GWIBBER_STREAM_MODEL_COLUMN_MESSAGE, _tmp480_);
			_tmp481_ = _model;
			_tmp482_ = iter;
			_tmp483_ = _html;
			_tmp484_ = _variant_new3 (_tmp483_);
			dee_model_set_value (_tmp481_, _tmp482_, (guint) GWIBBER_STREAM_MODEL_COLUMN_HTML, _tmp484_);
			_tmp485_ = _model;
			_tmp486_ = iter;
			_tmp487_ = _t;
			_tmp488_ = _variant_new4 (_tmp487_);
			dee_model_set_value (_tmp485_, _tmp486_, (guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTRING, _tmp488_);
			_tmp489_ = _model;
			_tmp490_ = iter;
			_tmp491_ = _likes;
			_tmp492_ = _variant_new5 (_tmp491_);
			dee_model_set_value (_tmp489_, _tmp490_, (guint) GWIBBER_STREAM_MODEL_COLUMN_LIKES, _tmp492_);
			_tmp493_ = _model;
			_tmp494_ = iter;
			_tmp495_ = _liked;
			_tmp496_ = _variant_new6 (_tmp495_);
			dee_model_set_value (_tmp493_, _tmp494_, (guint) GWIBBER_STREAM_MODEL_COLUMN_LIKED, _tmp496_);
			iter = NULL;
			_accounts_array = (_vala_array_free (_accounts_array, _accounts_array_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_t);
			_g_free0 (_textid);
			_g_free0 (_recipient_icon);
			_g_free0 (_recipient_nick);
			_g_free0 (_recipient);
			__vala_JsonObject_free0 (_recipient_obj);
			_g_free0 (_sender_nick);
			_g_free0 (_sender);
			__vala_JsonObject_free0 (_sender_obj);
			_g_variant_builder_unref0 (builder);
			_g_free0 (_acct);
			_g_object_unref0 (_model);
			_g_list_free0 (members);
			_g_free0 (transient);
			_g_free0 (_comments);
			_g_free0 (_url);
			_g_free0 (_icon);
			_g_free0 (_text);
			_g_free0 (_html);
			_g_free0 (_video_name);
			_g_free0 (_video_url);
			_g_free0 (_video_src);
			_g_free0 (_video_picture);
			_g_free0 (_image_name);
			_g_free0 (_image_thumb);
			_g_free0 (_image_src);
			_g_free0 (_image_url);
			_g_free0 (_link_icon);
			_g_free0 (_link_caption);
			_g_free0 (_link_description);
			_g_free0 (_link_url);
			_g_free0 (_link_name);
			_g_free0 (_link_picture);
			_g_free0 (_retweeted_by_id);
			_g_free0 (_retweeted_by_name);
			_g_free0 (_retweeted_by_nick);
			_g_free0 (_reply_url);
			_g_free0 (_reply_name);
			_g_free0 (_reply_nick);
			_g_free0 (_source);
			_g_free0 (_mid);
			_g_free0 (_operation);
			_g_free0 (_service);
			_g_free0 (_stream);
			_g_free0 (_account);
			return;
		}
	}
	_tmp497_ = builder;
	_tmp498_ = g_variant_new ("as", _tmp497_, NULL);
	_tmp499_ = g_variant_ref_sink (_tmp498_);
	_accounts = _tmp499_;
	_tmp500_ = _model;
	_tmp501_ = _accounts;
	_tmp502_ = _stream;
	_tmp503_ = transient;
	_tmp504_ = _sender;
	_tmp505_ = _sender_nick;
	_tmp506_ = _from_me;
	_tmp507_ = _time;
	_tmp508_ = g_strdup_printf ("%u", _tmp507_);
	_tmp509_ = _tmp508_;
	_tmp510_ = _text;
	_tmp511_ = _html;
	_tmp512_ = _icon;
	_tmp513_ = _url;
	_tmp514_ = _source;
	_tmp515_ = _t;
	_tmp516_ = _reply_nick;
	_tmp517_ = _reply_name;
	_tmp518_ = _reply_url;
	_tmp519_ = _likes;
	_tmp520_ = _liked;
	_tmp521_ = _retweeted_by_nick;
	_tmp522_ = _retweeted_by_name;
	_tmp523_ = _retweeted_by_id;
	_tmp524_ = _link_picture;
	_tmp525_ = _link_name;
	_tmp526_ = _link_url;
	_tmp527_ = _link_description;
	_tmp528_ = _link_caption;
	_tmp529_ = _link_icon;
	_tmp530_ = _image_url;
	_tmp531_ = _image_src;
	_tmp532_ = _image_thumb;
	_tmp533_ = _image_name;
	_tmp534_ = _video_picture;
	_tmp535_ = _video_src;
	_tmp536_ = _video_url;
	_tmp537_ = _video_name;
	_tmp538_ = _comments;
	_tmp539_ = _recipient;
	_tmp540_ = _recipient_nick;
	_tmp541_ = _recipient_icon;
	_tmp542_ = dee_model_append (_tmp500_, _tmp501_, _tmp502_, _tmp503_, _tmp504_, _tmp505_, _tmp506_, _tmp509_, _tmp510_, _tmp511_, _tmp512_, _tmp513_, _tmp514_, _tmp515_, _tmp516_, _tmp517_, _tmp518_, _tmp519_, _tmp520_, _tmp521_, _tmp522_, _tmp523_, _tmp524_, _tmp525_, _tmp526_, _tmp527_, _tmp528_, _tmp529_, _tmp530_, _tmp531_, _tmp532_, _tmp533_, _tmp534_, _tmp535_, _tmp536_, _tmp537_, _tmp538_, _tmp539_, _tmp540_, _tmp541_, NULL);
	iter = _tmp542_;
	_g_free0 (_tmp509_);
	_tmp544_ = _textid;
	_tmp545_ = strlen (_tmp544_);
	_tmp546_ = _tmp545_;
	if (_tmp546_ > 1) {
		DeeModelIter* _tmp547_;
		_tmp547_ = iter;
		_tmp543_ = _tmp547_ != NULL;
	} else {
		_tmp543_ = FALSE;
	}
	_tmp548_ = _tmp543_;
	if (_tmp548_) {
		GeeHashMap* _tmp549_;
		const gchar* _tmp550_;
		DeeModelIter* _tmp551_;
		_tmp549_ = self->priv->seen;
		_tmp550_ = _textid;
		_tmp551_ = iter;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp549_, _tmp550_, _tmp551_);
	}
	iter = NULL;
	_g_variant_unref0 (_accounts);
	_g_free0 (_t);
	_g_free0 (_textid);
	_g_free0 (_recipient_icon);
	_g_free0 (_recipient_nick);
	_g_free0 (_recipient);
	__vala_JsonObject_free0 (_recipient_obj);
	_g_free0 (_sender_nick);
	_g_free0 (_sender);
	__vala_JsonObject_free0 (_sender_obj);
	_g_variant_builder_unref0 (builder);
	_g_free0 (_acct);
	_g_object_unref0 (_model);
	_g_list_free0 (members);
	_g_free0 (transient);
	_g_free0 (_comments);
	_g_free0 (_url);
	_g_free0 (_icon);
	_g_free0 (_text);
	_g_free0 (_html);
	_g_free0 (_video_name);
	_g_free0 (_video_url);
	_g_free0 (_video_src);
	_g_free0 (_video_picture);
	_g_free0 (_image_name);
	_g_free0 (_image_thumb);
	_g_free0 (_image_src);
	_g_free0 (_image_url);
	_g_free0 (_link_icon);
	_g_free0 (_link_caption);
	_g_free0 (_link_description);
	_g_free0 (_link_url);
	_g_free0 (_link_name);
	_g_free0 (_link_picture);
	_g_free0 (_retweeted_by_id);
	_g_free0 (_retweeted_by_name);
	_g_free0 (_retweeted_by_nick);
	_g_free0 (_reply_url);
	_g_free0 (_reply_name);
	_g_free0 (_reply_nick);
	_g_free0 (_source);
	_g_free0 (_mid);
	_g_free0 (_operation);
	_g_free0 (_service);
	_g_free0 (_stream);
	_g_free0 (_account);
}


static gchar* gwibber_streams_scrub (GwibberStreams* self, const gchar* content) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* res;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	_tmp0_ = content;
	_tmp1_ = g_strdup (_tmp0_);
	res = _tmp1_;
	_tmp2_ = res;
	_tmp3_ = string_replace (_tmp2_, "&query", "&amp;query");
	_g_free0 (res);
	res = _tmp3_;
	_tmp4_ = res;
	_tmp5_ = string_replace (_tmp4_, "&name", "&amp;name");
	_g_free0 (res);
	res = _tmp5_;
	_tmp6_ = res;
	_tmp7_ = string_replace (_tmp6_, "class=\"nick\"", "");
	_g_free0 (res);
	res = _tmp7_;
	_tmp8_ = res;
	_tmp9_ = string_replace (_tmp8_, "class=\"hash\"", "");
	_g_free0 (res);
	res = _tmp9_;
	_tmp10_ = res;
	_tmp11_ = string_replace (_tmp10_, "<p>", "");
	_g_free0 (res);
	res = _tmp11_;
	_tmp12_ = res;
	_tmp13_ = string_replace (_tmp12_, "</p>", "");
	_g_free0 (res);
	res = _tmp13_;
	_tmp14_ = res;
	_tmp15_ = string_replace (_tmp14_, "<b>", "");
	_g_free0 (res);
	res = _tmp15_;
	_tmp16_ = res;
	_tmp17_ = string_replace (_tmp16_, "</b>", "");
	_g_free0 (res);
	res = _tmp17_;
	_tmp18_ = res;
	_tmp19_ = string_replace (_tmp18_, " & ", " &amp; ");
	_g_free0 (res);
	res = _tmp19_;
	result = res;
	return result;
}


static gchar* gwibber_streams_gen_text_id (GwibberStreams* self, const gchar* t) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* id;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	_tmp0_ = g_strdup ("");
	id = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_ = NULL;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp34_;
		gchar* _tmp35_ = NULL;
		_tmp4_ = t;
		_tmp5_ = string_replace (_tmp4_, ".", "");
		_tmp6_ = _tmp5_;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _vala_array_length (_tmp7_);
		_g_free0 (_tmp6_);
		{
			gchar** x_collection = NULL;
			gint x_collection_length1 = 0;
			gint _x_collection_size_ = 0;
			gint x_it = 0;
			x_collection = _tmp9_;
			x_collection_length1 = _tmp9__length1;
			for (x_it = 0; x_it < _tmp9__length1; x_it = x_it + 1) {
				gchar* _tmp10_;
				gchar* x = NULL;
				_tmp10_ = g_strdup (x_collection[x_it]);
				x = _tmp10_;
				{
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
					const gchar* _tmp15_;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp19_;
					gboolean _tmp22_;
					gboolean _tmp25_;
					gboolean _tmp28_;
					_tmp15_ = x;
					_tmp16_ = g_str_has_prefix (_tmp15_, "http://");
					if (!_tmp16_) {
						const gchar* _tmp17_;
						gboolean _tmp18_ = FALSE;
						_tmp17_ = x;
						_tmp18_ = g_str_has_prefix (_tmp17_, "https://");
						_tmp14_ = !_tmp18_;
					} else {
						_tmp14_ = FALSE;
					}
					_tmp19_ = _tmp14_;
					if (_tmp19_) {
						const gchar* _tmp20_;
						gboolean _tmp21_ = FALSE;
						_tmp20_ = x;
						_tmp21_ = g_str_has_prefix (_tmp20_, "gwibber:/");
						_tmp13_ = !_tmp21_;
					} else {
						_tmp13_ = FALSE;
					}
					_tmp22_ = _tmp13_;
					if (_tmp22_) {
						const gchar* _tmp23_;
						gboolean _tmp24_ = FALSE;
						_tmp23_ = x;
						_tmp24_ = g_str_has_prefix (_tmp23_, "#");
						_tmp12_ = !_tmp24_;
					} else {
						_tmp12_ = FALSE;
					}
					_tmp25_ = _tmp12_;
					if (_tmp25_) {
						const gchar* _tmp26_;
						gboolean _tmp27_ = FALSE;
						_tmp26_ = x;
						_tmp27_ = g_str_has_prefix (_tmp26_, "!");
						_tmp11_ = !_tmp27_;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp28_ = _tmp11_;
					if (_tmp28_) {
						const gchar* _tmp29_;
						const gchar* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						_tmp29_ = id;
						_tmp30_ = x;
						_tmp31_ = g_strconcat (_tmp30_, " ", NULL);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
						_g_free0 (id);
						id = _tmp33_;
						_g_free0 (_tmp32_);
					}
					_g_free0 (x);
				}
			}
			x_collection = (_vala_array_free (x_collection, x_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp34_ = id;
		_tmp35_ = string_strip (_tmp34_);
		_g_free0 (id);
		id = _tmp35_;
	}
	result = id;
	return result;
}


/**
         * com.Gwibber.Streams
         **/
GeeHashMap* gwibber_streams_lookup (GwibberStreams* self, const gchar* id) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* stream_map;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	stream_map = _tmp0_;
	{
		StreamsInterface* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _result_;
		JsonParser* _tmp4_;
		JsonParser* parser;
		JsonNode* _tmp6_ = NULL;
		JsonObject* _tmp7_ = NULL;
		JsonObject* _tmp8_;
		JsonObject* obj;
		JsonObject* _tmp9_;
		GList* _tmp10_ = NULL;
		GList* members;
		GList* _tmp11_;
		_tmp1_ = self->priv->streams_service;
		_tmp2_ = id;
		_tmp3_ = streams_interface_Get (_tmp1_, _tmp2_, &_inner_error_);
		_result_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch49_g_io_error;
			}
			_g_object_unref0 (stream_map);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = json_parser_new ();
		parser = _tmp4_;
		{
			const gchar* _tmp5_;
			_tmp5_ = _result_;
			json_parser_load_from_data (parser, _tmp5_, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch50_g_error;
			}
		}
		goto __finally50;
		__catch50_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally50:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (_result_);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch49_g_io_error;
			}
			_g_object_unref0 (parser);
			_g_free0 (_result_);
			_g_object_unref0 (stream_map);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = json_parser_get_root (parser);
		_tmp7_ = json_node_get_object (_tmp6_);
		_tmp8_ = __vala_JsonObject_copy0 (_tmp7_);
		obj = _tmp8_;
		_tmp9_ = obj;
		_tmp10_ = json_object_get_members (_tmp9_);
		members = _tmp10_;
		_tmp11_ = members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp11_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				gchar* _tmp12_;
				gchar* member = NULL;
				_tmp12_ = g_strdup ((const gchar*) member_it->data);
				member = _tmp12_;
				{
					GeeHashMap* _tmp13_;
					const gchar* _tmp14_;
					JsonObject* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_ = NULL;
					_tmp13_ = stream_map;
					_tmp14_ = member;
					_tmp15_ = obj;
					_tmp16_ = member;
					_tmp17_ = json_object_get_string_member (_tmp15_, _tmp16_);
					gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, _tmp17_);
					_g_free0 (member);
				}
			}
		}
		_g_list_free0 (members);
		__vala_JsonObject_free0 (obj);
		_g_object_unref0 (parser);
		_g_free0 (_result_);
	}
	goto __finally49;
	__catch49_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("streams.vala:854: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (stream_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = stream_map;
	return result;
}


/**
         * com.Gwibber.Streams
         **/
void gwibber_streams_delete (GwibberStreams* self, const gchar* id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	{
		StreamsInterface* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->streams_service;
		_tmp1_ = id;
		streams_interface_Delete (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch51_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally51;
	__catch51_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("streams.vala:871: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally51:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	return;
}


/**
         * com.Gwibber.Streams
         **/
gchar* gwibber_streams_create (GwibberStreams* self, const gchar* account, const gchar* name, const gchar* operation) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* parameters;
	GList* _tmp1_ = NULL;
	GList* streams_list;
	GList* _tmp2_;
	const gchar* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (operation != NULL, NULL);
	_tmp0_ = g_strdup ("");
	parameters = _tmp0_;
	_tmp1_ = gwibber_streams_list (self);
	streams_list = _tmp1_;
	_tmp2_ = streams_list;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp2_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			GeeHashMap* _tmp3_;
			GeeHashMap* s = NULL;
			_tmp3_ = _g_object_ref0 ((GeeHashMap*) s_it->data);
			s = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				GeeHashMap* _tmp6_;
				gpointer _tmp7_ = NULL;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp15_;
				gboolean _tmp20_;
				_tmp6_ = s;
				_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, "name");
				_tmp8_ = (gchar*) _tmp7_;
				_tmp9_ = name;
				_tmp10_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
				_g_free0 (_tmp8_);
				if (_tmp10_) {
					GeeHashMap* _tmp11_;
					gpointer _tmp12_ = NULL;
					gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp11_ = s;
					_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, "operation");
					_tmp13_ = (gchar*) _tmp12_;
					_tmp14_ = operation;
					_tmp5_ = g_strcmp0 (_tmp13_, _tmp14_) == 0;
					_g_free0 (_tmp13_);
				} else {
					_tmp5_ = FALSE;
				}
				_tmp15_ = _tmp5_;
				if (_tmp15_) {
					GeeHashMap* _tmp16_;
					gpointer _tmp17_ = NULL;
					gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp16_ = s;
					_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, "account");
					_tmp18_ = (gchar*) _tmp17_;
					_tmp19_ = account;
					_tmp4_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
					_g_free0 (_tmp18_);
				} else {
					_tmp4_ = FALSE;
				}
				_tmp20_ = _tmp4_;
				if (_tmp20_) {
					GeeHashMap* _tmp21_;
					gpointer _tmp22_ = NULL;
					gchar* _tmp23_;
					GeeHashMap* _tmp24_;
					gpointer _tmp25_ = NULL;
					g_debug ("streams.vala:890: user stream exists, updating");
					_tmp21_ = s;
					_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, "id");
					_tmp23_ = (gchar*) _tmp22_;
					g_signal_emit_by_name (self, "updated", _tmp23_);
					_g_free0 (_tmp23_);
					_tmp24_ = s;
					_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, "id");
					result = (gchar*) _tmp25_;
					_g_object_unref0 (s);
					__g_list_free__g_object_unref0_0 (streams_list);
					_g_free0 (parameters);
					return result;
				}
				_g_object_unref0 (s);
			}
		}
	}
	_tmp26_ = operation;
	if (g_strcmp0 (_tmp26_, "user_messages") == 0) {
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp27_ = name;
		_tmp28_ = g_strconcat ("{\"count\": 50, \"id\": \"", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "\"}", NULL);
		_g_free0 (parameters);
		parameters = _tmp30_;
		_g_free0 (_tmp29_);
	}
	{
		StreamsInterface* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp31_ = self->priv->streams_service;
		_tmp32_ = account;
		_tmp33_ = g_strconcat ("{\"account\": \"", _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp34_, "\", \"parameters\": ", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = parameters;
		_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp39_, ", \"name\": \"", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = name;
		_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp44_, "\", \"operation\": \"", NULL);
		_tmp46_ = _tmp45_;
		_tmp47_ = operation;
		_tmp48_ = g_strconcat (_tmp46_, _tmp47_, NULL);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strconcat (_tmp49_, "\"}", NULL);
		_tmp51_ = _tmp50_;
		_tmp52_ = streams_interface_Create (_tmp31_, _tmp51_, &_inner_error_);
		_tmp53_ = _tmp52_;
		_g_free0 (_tmp51_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
		_tmp54_ = _tmp53_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch52_g_io_error;
			}
			__g_list_free__g_object_unref0_0 (streams_list);
			_g_free0 (parameters);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp54_;
		__g_list_free__g_object_unref0_0 (streams_list);
		_g_free0 (parameters);
		return result;
	}
	goto __finally52;
	__catch52_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		g_warning ("streams.vala:905: %s", _tmp56_);
		_tmp57_ = g_strdup ("");
		result = _tmp57_;
		_g_error_free0 (e);
		__g_list_free__g_object_unref0_0 (streams_list);
		_g_free0 (parameters);
		return result;
	}
	__finally52:
	__g_list_free__g_object_unref0_0 (streams_list);
	_g_free0 (parameters);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * com.Gwibber.Streams
         **/
GList* gwibber_streams_list (GwibberStreams* self) {
	GList* result = NULL;
	GList* streams_list;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	streams_list = NULL;
	{
		StreamsInterface* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _result_;
		JsonParser* _tmp2_;
		JsonParser* parser;
		JsonParser* _tmp3_;
		const gchar* _tmp4_;
		JsonParser* _tmp5_;
		JsonNode* _tmp6_ = NULL;
		JsonArray* _tmp7_ = NULL;
		JsonArray* _tmp8_;
		JsonArray* nodeArray;
		_tmp0_ = self->priv->streams_service;
		_tmp1_ = streams_interface_List (_tmp0_, &_inner_error_);
		_result_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch53_g_error;
		}
		_tmp2_ = json_parser_new ();
		parser = _tmp2_;
		_tmp3_ = parser;
		_tmp4_ = _result_;
		json_parser_load_from_data (_tmp3_, _tmp4_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (_result_);
			goto __catch53_g_error;
		}
		_tmp5_ = parser;
		_tmp6_ = json_parser_get_root (_tmp5_);
		_tmp7_ = json_node_get_array (_tmp6_);
		_tmp8_ = __vala_JsonArray_copy0 (_tmp7_);
		nodeArray = _tmp8_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					gboolean _tmp10_;
					gint _tmp12_;
					JsonArray* _tmp13_;
					guint _tmp14_ = 0U;
					GeeHashMap* _tmp15_;
					GeeHashMap* stream_map;
					JsonArray* _tmp16_;
					gint _tmp17_;
					JsonNode* _tmp18_ = NULL;
					JsonObject* _tmp19_ = NULL;
					JsonObject* _tmp20_;
					JsonObject* obj;
					JsonObject* _tmp21_;
					GeeHashMap* _tmp32_;
					GeeHashMap* _tmp33_;
					_tmp10_ = _tmp9_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = nodeArray;
					_tmp14_ = json_array_get_length (_tmp13_);
					if (!(((guint) _tmp12_) < _tmp14_)) {
						break;
					}
					_tmp15_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
					stream_map = _tmp15_;
					_tmp16_ = nodeArray;
					_tmp17_ = i;
					_tmp18_ = json_array_get_element (_tmp16_, (guint) _tmp17_);
					_tmp19_ = json_node_get_object (_tmp18_);
					_tmp20_ = __vala_JsonObject_copy0 (_tmp19_);
					obj = _tmp20_;
					_tmp21_ = obj;
					if (_tmp21_ != NULL) {
						JsonObject* _tmp22_;
						GList* _tmp23_ = NULL;
						GList* members;
						GList* _tmp24_;
						_tmp22_ = obj;
						_tmp23_ = json_object_get_members (_tmp22_);
						members = _tmp23_;
						_tmp24_ = members;
						{
							GList* member_collection = NULL;
							GList* member_it = NULL;
							member_collection = _tmp24_;
							for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
								gchar* _tmp25_;
								gchar* member = NULL;
								_tmp25_ = g_strdup ((const gchar*) member_it->data);
								member = _tmp25_;
								{
									const gchar* _tmp26_;
									_tmp26_ = member;
									if (g_strcmp0 (_tmp26_, "parameters") != 0) {
										GeeHashMap* _tmp27_;
										const gchar* _tmp28_;
										JsonObject* _tmp29_;
										const gchar* _tmp30_;
										const gchar* _tmp31_ = NULL;
										_tmp27_ = stream_map;
										_tmp28_ = member;
										_tmp29_ = obj;
										_tmp30_ = member;
										_tmp31_ = json_object_get_string_member (_tmp29_, _tmp30_);
										gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, _tmp31_);
									}
									_g_free0 (member);
								}
							}
						}
						_g_list_free0 (members);
					}
					_tmp32_ = stream_map;
					_tmp33_ = _g_object_ref0 (_tmp32_);
					streams_list = g_list_append (streams_list, _tmp33_);
					__vala_JsonObject_free0 (obj);
					_g_object_unref0 (stream_map);
				}
			}
		}
		__vala_JsonArray_free0 (nodeArray);
		_g_object_unref0 (parser);
		_g_free0 (_result_);
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		g_warning ("streams.vala:940: %s", _tmp35_);
		_g_error_free0 (e);
	}
	__finally53:
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (streams_list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = streams_list;
	return result;
}


void gwibber_streams_stream_deleted (GwibberStreams* self, const gchar* data) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	{
		JsonParser* _tmp0_;
		JsonParser* parser;
		const gchar* _tmp1_;
		JsonNode* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_;
		JsonObject* root_object;
		JsonObject* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* id;
		const gchar* _tmp8_;
		_tmp0_ = json_parser_new ();
		parser = _tmp0_;
		_tmp1_ = data;
		json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			goto __catch54_g_error;
		}
		_tmp2_ = json_parser_get_root (parser);
		_tmp3_ = json_node_get_object (_tmp2_);
		_tmp4_ = __vala_JsonObject_copy0 (_tmp3_);
		root_object = _tmp4_;
		_tmp5_ = root_object;
		_tmp6_ = json_object_get_string_member (_tmp5_, "id");
		_tmp7_ = g_strdup (_tmp6_);
		id = _tmp7_;
		_tmp8_ = id;
		g_signal_emit_by_name (self, "deleted", _tmp8_);
		_g_free0 (id);
		__vala_JsonObject_free0 (root_object);
		_g_object_unref0 (parser);
	}
	goto __finally54;
	__catch54_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("streams.vala:955: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally54:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_streams_stream_created (GwibberStreams* self, const gchar* data) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	{
		JsonParser* _tmp0_;
		JsonParser* parser;
		const gchar* _tmp1_;
		JsonNode* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_;
		JsonObject* root_object;
		JsonObject* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* id;
		const gchar* _tmp8_;
		_tmp0_ = json_parser_new ();
		parser = _tmp0_;
		_tmp1_ = data;
		json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			goto __catch55_g_error;
		}
		_tmp2_ = json_parser_get_root (parser);
		_tmp3_ = json_node_get_object (_tmp2_);
		_tmp4_ = __vala_JsonObject_copy0 (_tmp3_);
		root_object = _tmp4_;
		_tmp5_ = root_object;
		_tmp6_ = json_object_get_string_member (_tmp5_, "id");
		_tmp7_ = g_strdup (_tmp6_);
		id = _tmp7_;
		_tmp8_ = id;
		g_signal_emit_by_name (self, "created", _tmp8_);
		_g_free0 (id);
		__vala_JsonObject_free0 (root_object);
		_g_object_unref0 (parser);
	}
	goto __finally55;
	__catch55_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("streams.vala:968: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally55:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_streams_stream_updated (GwibberStreams* self, const gchar* data) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	g_debug ("streams.vala:974: stream_updated");
	{
		JsonParser* _tmp0_;
		JsonParser* parser;
		const gchar* _tmp1_;
		JsonNode* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_;
		JsonObject* root_object;
		JsonObject* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* id;
		const gchar* _tmp8_;
		_tmp0_ = json_parser_new ();
		parser = _tmp0_;
		_tmp1_ = data;
		json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			goto __catch56_g_error;
		}
		_tmp2_ = json_parser_get_root (parser);
		_tmp3_ = json_node_get_object (_tmp2_);
		_tmp4_ = __vala_JsonObject_copy0 (_tmp3_);
		root_object = _tmp4_;
		_tmp5_ = root_object;
		_tmp6_ = json_object_get_string_member (_tmp5_, "id");
		_tmp7_ = g_strdup (_tmp6_);
		id = _tmp7_;
		_tmp8_ = id;
		g_signal_emit_by_name (self, "updated", _tmp8_);
		_g_free0 (id);
		__vala_JsonObject_free0 (root_object);
		_g_object_unref0 (parser);
	}
	goto __finally56;
	__catch56_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("streams.vala:982: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally56:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


GeeHashMap* gwibber_streams_user_profile (GwibberStreams* self, const gchar* id) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* profile;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, _vala_GValue_free, NULL, NULL, NULL);
	profile = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* name;
		gchar* _tmp2_;
		gchar* nick;
		gchar* _tmp3_;
		gchar* account;
		gchar* _tmp4_;
		gchar* service;
		gchar* _tmp5_;
		gchar* description;
		gchar* _tmp6_;
		gchar* image;
		gchar* _tmp7_;
		gchar* url;
		gint followers;
		gint friends;
		gint statuses;
		gboolean following;
		gboolean protected;
		StreamsInterface* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _result_;
		JsonParser* _tmp11_;
		JsonParser* parser;
		JsonNode* _tmp13_ = NULL;
		JsonArray* _tmp14_ = NULL;
		JsonArray* _tmp15_;
		JsonArray* nodeArray;
		JsonArray* _tmp16_;
		JsonNode* _tmp17_ = NULL;
		JsonObject* _tmp18_ = NULL;
		JsonObject* _tmp19_;
		JsonObject* obj;
		JsonObject* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		JsonObject* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		JsonObject* _tmp26_;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		JsonObject* _tmp29_;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		JsonObject* _tmp32_;
		gboolean _tmp33_ = FALSE;
		JsonObject* _tmp37_;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		JsonObject* _tmp40_;
		gboolean _tmp41_ = FALSE;
		JsonObject* _tmp45_;
		gint64 _tmp46_ = 0LL;
		JsonObject* _tmp47_;
		gint64 _tmp48_ = 0LL;
		JsonObject* _tmp49_;
		gint64 _tmp50_ = 0LL;
		JsonObject* _tmp51_;
		gboolean _tmp52_ = FALSE;
		JsonObject* _tmp53_;
		gboolean _tmp54_ = FALSE;
		GeeHashMap* _tmp55_;
		const gchar* _tmp56_;
		GValue* _tmp57_ = NULL;
		GeeHashMap* _tmp58_;
		const gchar* _tmp59_;
		GValue* _tmp60_ = NULL;
		GeeHashMap* _tmp61_;
		const gchar* _tmp62_;
		GValue* _tmp63_ = NULL;
		GeeHashMap* _tmp64_;
		const gchar* _tmp65_;
		GValue* _tmp66_ = NULL;
		GeeHashMap* _tmp67_;
		const gchar* _tmp68_;
		GValue* _tmp69_ = NULL;
		GeeHashMap* _tmp70_;
		const gchar* _tmp71_;
		GValue* _tmp72_ = NULL;
		GeeHashMap* _tmp73_;
		const gchar* _tmp74_;
		GValue* _tmp75_ = NULL;
		GeeHashMap* _tmp76_;
		const gchar* _tmp77_;
		GValue* _tmp78_ = NULL;
		GeeHashMap* _tmp79_;
		gint _tmp80_;
		GValue* _tmp81_ = NULL;
		GeeHashMap* _tmp82_;
		gint _tmp83_;
		GValue* _tmp84_ = NULL;
		GeeHashMap* _tmp85_;
		gint _tmp86_;
		GValue* _tmp87_ = NULL;
		GeeHashMap* _tmp88_;
		gboolean _tmp89_;
		GValue* _tmp90_ = NULL;
		GeeHashMap* _tmp91_;
		gboolean _tmp92_;
		GValue* _tmp93_ = NULL;
		_tmp1_ = g_strdup ("");
		name = _tmp1_;
		_tmp2_ = g_strdup ("");
		nick = _tmp2_;
		_tmp3_ = g_strdup ("");
		account = _tmp3_;
		_tmp4_ = g_strdup ("");
		service = _tmp4_;
		_tmp5_ = g_strdup ("");
		description = _tmp5_;
		_tmp6_ = g_strdup ("");
		image = _tmp6_;
		_tmp7_ = g_strdup ("");
		url = _tmp7_;
		followers = 0;
		friends = 0;
		statuses = 0;
		following = FALSE;
		protected = FALSE;
		_tmp8_ = self->priv->streams_service;
		_tmp9_ = id;
		_tmp10_ = streams_interface_Messages (_tmp8_, "profile", "all", 0, _tmp9_, "0", "time", "DESC", 1, &_inner_error_);
		_result_ = _tmp10_;
		if (_inner_error_ != NULL) {
			_g_free0 (url);
			_g_free0 (image);
			_g_free0 (description);
			_g_free0 (service);
			_g_free0 (account);
			_g_free0 (nick);
			_g_free0 (name);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch57_g_io_error;
			}
			_g_free0 (url);
			_g_free0 (image);
			_g_free0 (description);
			_g_free0 (service);
			_g_free0 (account);
			_g_free0 (nick);
			_g_free0 (name);
			_g_object_unref0 (profile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = json_parser_new ();
		parser = _tmp11_;
		{
			const gchar* _tmp12_;
			_tmp12_ = _result_;
			json_parser_load_from_data (parser, _tmp12_, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch58_g_error;
			}
		}
		goto __finally58;
		__catch58_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally58:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (_result_);
			_g_free0 (url);
			_g_free0 (image);
			_g_free0 (description);
			_g_free0 (service);
			_g_free0 (account);
			_g_free0 (nick);
			_g_free0 (name);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch57_g_io_error;
			}
			_g_object_unref0 (parser);
			_g_free0 (_result_);
			_g_free0 (url);
			_g_free0 (image);
			_g_free0 (description);
			_g_free0 (service);
			_g_free0 (account);
			_g_free0 (nick);
			_g_free0 (name);
			_g_object_unref0 (profile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp13_ = json_parser_get_root (parser);
		_tmp14_ = json_node_get_array (_tmp13_);
		_tmp15_ = __vala_JsonArray_copy0 (_tmp14_);
		nodeArray = _tmp15_;
		_tmp16_ = nodeArray;
		_tmp17_ = json_array_get_element (_tmp16_, (guint) 0);
		_tmp18_ = json_node_get_object (_tmp17_);
		_tmp19_ = __vala_JsonObject_copy0 (_tmp18_);
		obj = _tmp19_;
		_tmp20_ = obj;
		_tmp21_ = json_object_get_string_member (_tmp20_, "name");
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (name);
		name = _tmp22_;
		_tmp23_ = obj;
		_tmp24_ = json_object_get_string_member (_tmp23_, "nick");
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (nick);
		nick = _tmp25_;
		_tmp26_ = obj;
		_tmp27_ = json_object_get_string_member (_tmp26_, "account");
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (account);
		account = _tmp28_;
		_tmp29_ = obj;
		_tmp30_ = json_object_get_string_member (_tmp29_, "service");
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (service);
		service = _tmp31_;
		_tmp32_ = obj;
		_tmp33_ = json_object_has_member (_tmp32_, "text");
		if (_tmp33_) {
			JsonObject* _tmp34_;
			const gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp34_ = obj;
			_tmp35_ = json_object_get_string_member (_tmp34_, "text");
			_tmp36_ = g_strdup (_tmp35_);
			_g_free0 (description);
			description = _tmp36_;
		}
		_tmp37_ = obj;
		_tmp38_ = json_object_get_string_member (_tmp37_, "image");
		_tmp39_ = g_strdup (_tmp38_);
		_g_free0 (image);
		image = _tmp39_;
		_tmp40_ = obj;
		_tmp41_ = json_object_has_member (_tmp40_, "url");
		if (_tmp41_) {
			JsonObject* _tmp42_;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_;
			_tmp42_ = obj;
			_tmp43_ = json_object_get_string_member (_tmp42_, "url");
			_tmp44_ = g_strdup (_tmp43_);
			_g_free0 (url);
			url = _tmp44_;
		}
		_tmp45_ = obj;
		_tmp46_ = json_object_get_int_member (_tmp45_, "followers");
		followers = (gint) _tmp46_;
		_tmp47_ = obj;
		_tmp48_ = json_object_get_int_member (_tmp47_, "friends");
		friends = (gint) _tmp48_;
		_tmp49_ = obj;
		_tmp50_ = json_object_get_int_member (_tmp49_, "statuses");
		statuses = (gint) _tmp50_;
		_tmp51_ = obj;
		_tmp52_ = json_object_get_boolean_member (_tmp51_, "following");
		following = _tmp52_;
		_tmp53_ = obj;
		_tmp54_ = json_object_get_boolean_member (_tmp53_, "protected");
		protected = _tmp54_;
		_tmp55_ = profile;
		_tmp56_ = name;
		_tmp57_ = g_new0 (GValue, 1);
		g_value_init (_tmp57_, G_TYPE_STRING);
		g_value_set_string (_tmp57_, _tmp56_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp55_, "name", _tmp57_);
		__vala_GValue_free0 (_tmp57_);
		_tmp58_ = profile;
		_tmp59_ = nick;
		_tmp60_ = g_new0 (GValue, 1);
		g_value_init (_tmp60_, G_TYPE_STRING);
		g_value_set_string (_tmp60_, _tmp59_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp58_, "nick", _tmp60_);
		__vala_GValue_free0 (_tmp60_);
		_tmp61_ = profile;
		_tmp62_ = account;
		_tmp63_ = g_new0 (GValue, 1);
		g_value_init (_tmp63_, G_TYPE_STRING);
		g_value_set_string (_tmp63_, _tmp62_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp61_, "account", _tmp63_);
		__vala_GValue_free0 (_tmp63_);
		_tmp64_ = profile;
		_tmp65_ = service;
		_tmp66_ = g_new0 (GValue, 1);
		g_value_init (_tmp66_, G_TYPE_STRING);
		g_value_set_string (_tmp66_, _tmp65_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp64_, "service", _tmp66_);
		__vala_GValue_free0 (_tmp66_);
		_tmp67_ = profile;
		_tmp68_ = id;
		_tmp69_ = g_new0 (GValue, 1);
		g_value_init (_tmp69_, G_TYPE_STRING);
		g_value_set_string (_tmp69_, _tmp68_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp67_, "id", _tmp69_);
		__vala_GValue_free0 (_tmp69_);
		_tmp70_ = profile;
		_tmp71_ = description;
		_tmp72_ = g_new0 (GValue, 1);
		g_value_init (_tmp72_, G_TYPE_STRING);
		g_value_set_string (_tmp72_, _tmp71_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp70_, "description", _tmp72_);
		__vala_GValue_free0 (_tmp72_);
		_tmp73_ = profile;
		_tmp74_ = image;
		_tmp75_ = g_new0 (GValue, 1);
		g_value_init (_tmp75_, G_TYPE_STRING);
		g_value_set_string (_tmp75_, _tmp74_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp73_, "image", _tmp75_);
		__vala_GValue_free0 (_tmp75_);
		_tmp76_ = profile;
		_tmp77_ = url;
		_tmp78_ = g_new0 (GValue, 1);
		g_value_init (_tmp78_, G_TYPE_STRING);
		g_value_set_string (_tmp78_, _tmp77_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp76_, "url", _tmp78_);
		__vala_GValue_free0 (_tmp78_);
		_tmp79_ = profile;
		_tmp80_ = followers;
		_tmp81_ = g_new0 (GValue, 1);
		g_value_init (_tmp81_, G_TYPE_INT);
		g_value_set_int (_tmp81_, _tmp80_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp79_, "followers", _tmp81_);
		__vala_GValue_free0 (_tmp81_);
		_tmp82_ = profile;
		_tmp83_ = friends;
		_tmp84_ = g_new0 (GValue, 1);
		g_value_init (_tmp84_, G_TYPE_INT);
		g_value_set_int (_tmp84_, _tmp83_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp82_, "friends", _tmp84_);
		__vala_GValue_free0 (_tmp84_);
		_tmp85_ = profile;
		_tmp86_ = statuses;
		_tmp87_ = g_new0 (GValue, 1);
		g_value_init (_tmp87_, G_TYPE_INT);
		g_value_set_int (_tmp87_, _tmp86_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp85_, "statuses", _tmp87_);
		__vala_GValue_free0 (_tmp87_);
		_tmp88_ = profile;
		_tmp89_ = following;
		_tmp90_ = g_new0 (GValue, 1);
		g_value_init (_tmp90_, G_TYPE_BOOLEAN);
		g_value_set_boolean (_tmp90_, _tmp89_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp88_, "following", _tmp90_);
		__vala_GValue_free0 (_tmp90_);
		_tmp91_ = profile;
		_tmp92_ = protected;
		_tmp93_ = g_new0 (GValue, 1);
		g_value_init (_tmp93_, G_TYPE_BOOLEAN);
		g_value_set_boolean (_tmp93_, _tmp92_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp91_, "protected", _tmp93_);
		__vala_GValue_free0 (_tmp93_);
		__vala_JsonObject_free0 (obj);
		__vala_JsonArray_free0 (nodeArray);
		_g_object_unref0 (parser);
		_g_free0 (_result_);
		_g_free0 (url);
		_g_free0 (image);
		_g_free0 (description);
		_g_free0 (service);
		_g_free0 (account);
		_g_free0 (nick);
		_g_free0 (name);
	}
	goto __finally57;
	__catch57_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp94_;
		const gchar* _tmp95_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp94_ = e;
		_tmp95_ = _tmp94_->message;
		g_warning ("streams.vala:1047: %s", _tmp95_);
		_g_error_free0 (e);
	}
	__finally57:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (profile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = profile;
	return result;
}


void gwibber_streams_streams_available (GwibberStreams* self, gboolean is_up) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_up;
	g_signal_emit_by_name (self, "is-available", _tmp0_);
}


DeeModel* gwibber_streams_get_stream_model (GwibberStreams* self) {
	DeeModel* result;
	DeeModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stream_model;
	if (_tmp0_ != NULL) {
		DeeModel* _tmp1_;
		_tmp1_ = self->priv->_stream_model;
		result = _tmp1_;
		return result;
	} else {
		DeeModel* _tmp2_ = NULL;
		DeeModel* _tmp3_;
		_tmp2_ = gwibber_streams_streams_model (self, FALSE);
		_g_object_unref0 (self->priv->_stream_model);
		self->priv->_stream_model = _tmp2_;
		_tmp3_ = self->priv->_stream_model;
		result = _tmp3_;
		return result;
	}
}


void gwibber_streams_set_stream_model (GwibberStreams* self, DeeModel* value) {
	DeeModel* _tmp0_;
	DeeModel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_stream_model;
	_tmp1_ = value;
	if (_tmp0_ != _tmp1_) {
		DeeModel* _tmp2_;
		DeeModel* _tmp3_;
		_tmp2_ = value;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->_stream_model);
		self->priv->_stream_model = _tmp3_;
	}
	g_object_notify ((GObject *) self, "stream-model");
}


DeeModel* gwibber_streams_get_transient_model (GwibberStreams* self) {
	DeeModel* result;
	DeeModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_transient_model;
	if (_tmp0_ != NULL) {
		DeeModel* _tmp1_;
		_tmp1_ = self->priv->_transient_model;
		result = _tmp1_;
		return result;
	} else {
		DeeModel* _tmp2_ = NULL;
		DeeModel* _tmp3_;
		_tmp2_ = gwibber_streams_streams_model (self, TRUE);
		_g_object_unref0 (self->priv->_transient_model);
		self->priv->_transient_model = _tmp2_;
		_tmp3_ = self->priv->_transient_model;
		result = _tmp3_;
		return result;
	}
}


void gwibber_streams_set_transient_model (GwibberStreams* self, DeeModel* value) {
	DeeModel* _tmp0_;
	DeeModel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_transient_model;
	_tmp1_ = value;
	if (_tmp0_ != _tmp1_) {
		DeeModel* _tmp2_;
		DeeModel* _tmp3_;
		_tmp2_ = value;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->_transient_model);
		self->priv->_transient_model = _tmp3_;
	}
	g_object_notify ((GObject *) self, "transient-model");
}


static void gwibber_streams_real_updated (GwibberStreams* self, const gchar* id) {
	g_return_if_fail (id != NULL);
}


static void gwibber_streams_class_init (GwibberStreamsClass * klass) {
	gwibber_streams_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberStreamsPrivate));
	GWIBBER_STREAMS_CLASS (klass)->updated = gwibber_streams_real_updated;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_streams_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_streams_set_property;
	G_OBJECT_CLASS (klass)->finalize = gwibber_streams_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_STREAMS_STREAM_MODEL, g_param_spec_object ("stream-model", "stream-model", "stream-model", dee_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_STREAMS_TRANSIENT_MODEL, g_param_spec_object ("transient-model", "transient-model", "transient-model", dee_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** 
	            Streams::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Streams availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	g_signal_new ("updated", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberStreamsClass, updated), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("deleted", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("created", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void gwibber_streams_instance_init (GwibberStreams * self) {
	self->priv = GWIBBER_STREAMS_GET_PRIVATE (self);
	self->priv->_stream_model = NULL;
	self->priv->_transient_model = NULL;
}


static void gwibber_streams_finalize (GObject* obj) {
	GwibberStreams * self;
	self = GWIBBER_STREAMS (obj);
	_g_object_unref0 (self->priv->streams_service);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->utils);
	_g_object_unref0 (self->priv->messages_service);
	_g_object_unref0 (self->priv->searches_service);
	_g_object_unref0 (self->priv->_stream_model);
	_g_object_unref0 (self->priv->_transient_model);
	_g_object_unref0 (self->priv->seen);
	G_OBJECT_CLASS (gwibber_streams_parent_class)->finalize (obj);
}


GType gwibber_streams_get_type (void) {
	static volatile gsize gwibber_streams_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_streams_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberStreamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_streams_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberStreams), 0, (GInstanceInitFunc) gwibber_streams_instance_init, NULL };
		GType gwibber_streams_type_id;
		gwibber_streams_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberStreams", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_streams_type_id__volatile, gwibber_streams_type_id);
	}
	return gwibber_streams_type_id__volatile;
}


static void _vala_gwibber_streams_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberStreams * self;
	self = GWIBBER_STREAMS (object);
	switch (property_id) {
		case GWIBBER_STREAMS_STREAM_MODEL:
		g_value_set_object (value, gwibber_streams_get_stream_model (self));
		break;
		case GWIBBER_STREAMS_TRANSIENT_MODEL:
		g_value_set_object (value, gwibber_streams_get_transient_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_streams_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberStreams * self;
	self = GWIBBER_STREAMS (object);
	switch (property_id) {
		case GWIBBER_STREAMS_STREAM_MODEL:
		gwibber_streams_set_stream_model (self, g_value_get_object (value));
		break;
		case GWIBBER_STREAMS_TRANSIENT_MODEL:
		gwibber_streams_set_transient_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



