/* utils.c generated by valac 0.12.1, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "gwibber.h"
#include <time.h>
#include <glib/gi18n-lib.h>


#define GWIBBER_TYPE_DBUS_IFACE (gwibber_dbus_iface_get_type ())
#define GWIBBER_DBUS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_DBUS_IFACE, GwibberDBusIface))
#define GWIBBER_IS_DBUS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_DBUS_IFACE))
#define GWIBBER_DBUS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GWIBBER_TYPE_DBUS_IFACE, GwibberDBusIfaceIface))

typedef struct _GwibberDBusIface GwibberDBusIface;
typedef struct _GwibberDBusIfaceIface GwibberDBusIfaceIface;

#define GWIBBER_TYPE_DBUS_IFACE_PROXY (gwibber_dbus_iface_proxy_get_type ())
typedef GDBusProxy GwibberDBusIfaceProxy;
typedef GDBusProxyClass GwibberDBusIfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GwibberUtilsCheckNamesData GwibberUtilsCheckNamesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GwibberUtilsOnReadyData GwibberUtilsOnReadyData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _GwibberUtilsDoSetupData GwibberUtilsDoSetupData;

struct _GwibberDBusIfaceIface {
	GTypeInterface parent_iface;
	void (*list_names) (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _GwibberUtilsPrivate {
	GwibberDBusIface* bus;
	gchar* interface_name;
};

struct _GwibberUtilsCheckNamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberUtils* self;
	gchar** names;
	gint names_length1;
	gchar** name_collection;
	int name_collection_length1;
	int name_it;
	gchar* _tmp0_;
	gchar* name;
};

struct _GwibberUtilsOnReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberUtils* self;
	gboolean result;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** n;
	gint n_length1;
	gint _n_size_;
	GError * e;
	GError * _inner_error_;
};

struct _GwibberUtilsDoSetupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberUtils* self;
	gchar* name;
	GwibberDBusIface* _tmp0_;
	GwibberDBusIface* _tmp1_;
	GError * _inner_error_;
};


static gpointer gwibber_utils_parent_class = NULL;

GType gwibber_dbus_iface_proxy_get_type (void) G_GNUC_CONST;
guint gwibber_dbus_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gwibber_dbus_iface_get_type (void) G_GNUC_CONST;
void gwibber_dbus_iface_list_names (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** gwibber_dbus_iface_list_names_finish (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gwibber_dbus_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_gwibber_dbus_iface_name_owner_changed (GwibberDBusIface* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void gwibber_dbus_iface_proxy_list_names_async (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** gwibber_dbus_iface_proxy_list_names_finish (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void gwibber_dbus_iface_proxy_gwibber_dbus_iface_interface_init (GwibberDBusIfaceIface* iface);
static void _dbus_gwibber_dbus_iface_list_names (GwibberDBusIface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_gwibber_dbus_iface_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void gwibber_dbus_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gwibber_dbus_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gwibber_dbus_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_gwibber_dbus_iface_name_owner_changed (GObject* _sender, const gchar* name, const gchar* oldowner, const gchar* newowner, gpointer* _data);
static void _gwibber_dbus_iface_unregister_object (gpointer user_data);
#define GWIBBER_UTILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_UTILS, GwibberUtilsPrivate))
enum  {
	GWIBBER_UTILS_DUMMY_PROPERTY
};
static void gwibber_utils_on_name_owner_changed (GwibberUtils* self, const gchar* name, const gchar* old_owner, const gchar* new_owner);
static void gwibber_utils_check_names_data_free (gpointer _data);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void gwibber_utils_check_names (GwibberUtils* self, gchar** names, int names_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gwibber_utils_check_names_finish (GwibberUtils* self, GAsyncResult* _res_);
static gboolean gwibber_utils_check_names_co (GwibberUtilsCheckNamesData* data);
static void gwibber_utils_on_ready_data_free (gpointer _data);
static void gwibber_utils_on_ready (GwibberUtils* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean gwibber_utils_on_ready_finish (GwibberUtils* self, GAsyncResult* _res_);
static gboolean gwibber_utils_on_ready_co (GwibberUtilsOnReadyData* data);
static void gwibber_utils_on_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gwibber_utils_do_setup_data_free (gpointer _data);
static void gwibber_utils_do_setup (GwibberUtils* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gwibber_utils_do_setup_finish (GwibberUtils* self, GAsyncResult* _res_, GError** error);
static gboolean gwibber_utils_do_setup_co (GwibberUtilsDoSetupData* data);
static void gwibber_utils_do_setup_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _gwibber_utils_on_name_owner_changed_gwibber_dbus_iface_name_owner_changed (GwibberDBusIface* _sender, const gchar* name, const gchar* oldowner, const gchar* newowner, gpointer self);
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void gwibber_utils_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _gwibber_dbus_iface_dbus_arg_info_list_names_result = {-1, "result", "as"};
static const GDBusArgInfo * const _gwibber_dbus_iface_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _gwibber_dbus_iface_dbus_arg_info_list_names_out[] = {&_gwibber_dbus_iface_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _gwibber_dbus_iface_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_gwibber_dbus_iface_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_gwibber_dbus_iface_dbus_arg_info_list_names_out)};
static const GDBusMethodInfo * const _gwibber_dbus_iface_dbus_method_info[] = {&_gwibber_dbus_iface_dbus_method_info_list_names, NULL};
static const GDBusArgInfo _gwibber_dbus_iface_dbus_arg_info_name_owner_changed_name = {-1, "name", "s"};
static const GDBusArgInfo _gwibber_dbus_iface_dbus_arg_info_name_owner_changed_oldowner = {-1, "oldowner", "s"};
static const GDBusArgInfo _gwibber_dbus_iface_dbus_arg_info_name_owner_changed_newowner = {-1, "newowner", "s"};
static const GDBusArgInfo * const _gwibber_dbus_iface_dbus_arg_info_name_owner_changed[] = {&_gwibber_dbus_iface_dbus_arg_info_name_owner_changed_name, &_gwibber_dbus_iface_dbus_arg_info_name_owner_changed_oldowner, &_gwibber_dbus_iface_dbus_arg_info_name_owner_changed_newowner, NULL};
static const GDBusSignalInfo _gwibber_dbus_iface_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_gwibber_dbus_iface_dbus_arg_info_name_owner_changed)};
static const GDBusSignalInfo * const _gwibber_dbus_iface_dbus_signal_info[] = {&_gwibber_dbus_iface_dbus_signal_info_name_owner_changed, NULL};
static const GDBusPropertyInfo * const _gwibber_dbus_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gwibber_dbus_iface_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_gwibber_dbus_iface_dbus_method_info), (GDBusSignalInfo **) (&_gwibber_dbus_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_gwibber_dbus_iface_dbus_property_info)};
static const GDBusInterfaceVTable _gwibber_dbus_iface_dbus_interface_vtable = {gwibber_dbus_iface_dbus_interface_method_call, gwibber_dbus_iface_dbus_interface_get_property, gwibber_dbus_iface_dbus_interface_set_property};

void gwibber_dbus_iface_list_names (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GWIBBER_DBUS_IFACE_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
}


gchar** gwibber_dbus_iface_list_names_finish (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return GWIBBER_DBUS_IFACE_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void gwibber_dbus_iface_base_init (GwibberDBusIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("name_owner_changed", GWIBBER_TYPE_DBUS_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	}
}


GType gwibber_dbus_iface_get_type (void) {
	static volatile gsize gwibber_dbus_iface_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_dbus_iface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberDBusIfaceIface), (GBaseInitFunc) gwibber_dbus_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gwibber_dbus_iface_type_id;
		gwibber_dbus_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "GwibberDBusIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gwibber_dbus_iface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (gwibber_dbus_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gwibber_dbus_iface_proxy_get_type);
		g_type_set_qdata (gwibber_dbus_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (gwibber_dbus_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gwibber_dbus_iface_register_object);
		g_once_init_leave (&gwibber_dbus_iface_type_id__volatile, gwibber_dbus_iface_type_id);
	}
	return gwibber_dbus_iface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GwibberDBusIfaceProxy, gwibber_dbus_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GWIBBER_TYPE_DBUS_IFACE, gwibber_dbus_iface_proxy_gwibber_dbus_iface_interface_init) )
static void gwibber_dbus_iface_proxy_class_init (GwibberDBusIfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gwibber_dbus_iface_proxy_g_signal;
}


static void _dbus_handle_gwibber_dbus_iface_name_owner_changed (GwibberDBusIface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp55_;
	gchar* oldowner = NULL;
	GVariant* _tmp56_;
	gchar* newowner = NULL;
	GVariant* _tmp57_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp55_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp55_, NULL);
	g_variant_unref (_tmp55_);
	_tmp56_ = g_variant_iter_next_value (&_arguments_iter);
	oldowner = g_variant_dup_string (_tmp56_, NULL);
	g_variant_unref (_tmp56_);
	_tmp57_ = g_variant_iter_next_value (&_arguments_iter);
	newowner = g_variant_dup_string (_tmp57_, NULL);
	g_variant_unref (_tmp57_);
	g_signal_emit_by_name (self, "name-owner-changed", name, oldowner, newowner);
	_g_free0 (name);
	_g_free0 (oldowner);
	_g_free0 (newowner);
}


static void gwibber_dbus_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
		_dbus_handle_gwibber_dbus_iface_name_owner_changed ((GwibberDBusIface*) proxy, parameters);
	}
}


static void gwibber_dbus_iface_proxy_init (GwibberDBusIfaceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void gwibber_dbus_iface_proxy_list_names_async (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static gchar** gwibber_dbus_iface_proxy_list_names_finish (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp58_;
	gchar** _tmp59_;
	int _tmp59__length;
	int _tmp59__size;
	int _tmp59__length1;
	GVariantIter _tmp60_;
	GVariant* _tmp61_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp58_ = g_variant_iter_next_value (&_reply_iter);
	_tmp59_ = g_new (gchar*, 5);
	_tmp59__length = 0;
	_tmp59__size = 4;
	_tmp59__length1 = 0;
	g_variant_iter_init (&_tmp60_, _tmp58_);
	for (; (_tmp61_ = g_variant_iter_next_value (&_tmp60_)) != NULL; _tmp59__length1++) {
		if (_tmp59__size == _tmp59__length) {
			_tmp59__size = 2 * _tmp59__size;
			_tmp59_ = g_renew (gchar*, _tmp59_, _tmp59__size + 1);
		}
		_tmp59_[_tmp59__length++] = g_variant_dup_string (_tmp61_, NULL);
		g_variant_unref (_tmp61_);
	}
	_result_length1 = _tmp59__length1;
	_tmp59_[_tmp59__length] = NULL;
	_result = _tmp59_;
	g_variant_unref (_tmp58_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void gwibber_dbus_iface_proxy_gwibber_dbus_iface_interface_init (GwibberDBusIfaceIface* iface) {
	iface->list_names = gwibber_dbus_iface_proxy_list_names_async;
	iface->list_names_finish = gwibber_dbus_iface_proxy_list_names_finish;
}


static void _dbus_gwibber_dbus_iface_list_names (GwibberDBusIface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	gwibber_dbus_iface_list_names (self, (GAsyncReadyCallback) _dbus_gwibber_dbus_iface_list_names_ready, invocation);
}


static void _dbus_gwibber_dbus_iface_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp62_;
	GVariantBuilder _tmp63_;
	int _tmp64_;
	invocation = _user_data_;
	result = gwibber_dbus_iface_list_names_finish ((GwibberDBusIface*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp62_ = result;
	g_variant_builder_init (&_tmp63_, G_VARIANT_TYPE ("as"));
	for (_tmp64_ = 0; _tmp64_ < result_length1; _tmp64_++) {
		g_variant_builder_add_value (&_tmp63_, g_variant_new_string (*_tmp62_));
		_tmp62_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp63_));
	 result = (_vala_array_free ( result,  result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void gwibber_dbus_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListNames") == 0) {
		_dbus_gwibber_dbus_iface_list_names (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* gwibber_dbus_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gwibber_dbus_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_gwibber_dbus_iface_name_owner_changed (GObject* _sender, const gchar* name, const gchar* oldowner, const gchar* newowner, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (oldowner));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (newowner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
}


guint gwibber_dbus_iface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gwibber_dbus_iface_dbus_interface_info), &_gwibber_dbus_iface_dbus_interface_vtable, data, _gwibber_dbus_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_gwibber_dbus_iface_name_owner_changed, data);
	return result;
}


static void _gwibber_dbus_iface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void gwibber_utils_on_name_owner_changed (GwibberUtils* self, const gchar* name, const gchar* old_owner, const gchar* new_owner) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (old_owner != NULL);
	g_return_if_fail (new_owner != NULL);
	if (g_strcmp0 (name, self->priv->interface_name) == 0) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (g_strcmp0 (new_owner, "") != 0) {
			_tmp0_ = g_strcmp0 (old_owner, "") == 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			g_message ("utils.vala:48: %s is available", name);
			g_signal_emit_by_name (self, "available", TRUE);
		}
		if (g_strcmp0 (old_owner, "") != 0) {
			_tmp1_ = g_strcmp0 (new_owner, "") == 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			g_signal_emit_by_name (self, "available", FALSE);
			g_message ("utils.vala:54: %s is no longer available", name);
		}
	}
}


static void gwibber_utils_check_names_data_free (gpointer _data) {
	GwibberUtilsCheckNamesData* data;
	data = _data;
	data->names = (_vala_array_free (data->names, data->names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->self);
	g_slice_free (GwibberUtilsCheckNamesData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void gwibber_utils_check_names (GwibberUtils* self, gchar** names, int names_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberUtilsCheckNamesData* _data_;
	gchar** _tmp0_;
	_data_ = g_slice_new0 (GwibberUtilsCheckNamesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_utils_check_names);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_utils_check_names_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->names = (_tmp0_ = names, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, names_length1));
	_data_->names_length1 = names_length1;
	gwibber_utils_check_names_co (_data_);
}


static void gwibber_utils_check_names_finish (GwibberUtils* self, GAsyncResult* _res_) {
	GwibberUtilsCheckNamesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean gwibber_utils_check_names_co (GwibberUtilsCheckNamesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->name_collection = data->names;
		data->name_collection_length1 = data->names_length1;
		for (data->name_it = 0; data->name_it < data->names_length1; data->name_it = data->name_it + 1) {
			data->_tmp0_ = g_strdup (data->name_collection[data->name_it]);
			data->name = data->_tmp0_;
			{
				if (g_strcmp0 (data->name, data->self->priv->interface_name) == 0) {
					g_signal_emit_by_name (data->self, "available", TRUE);
					_g_free0 (data->name);
					break;
				}
				_g_free0 (data->name);
			}
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void gwibber_utils_on_ready_data_free (gpointer _data) {
	GwibberUtilsOnReadyData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (GwibberUtilsOnReadyData, data);
}


static void gwibber_utils_on_ready (GwibberUtils* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberUtilsOnReadyData* _data_;
	_data_ = g_slice_new0 (GwibberUtilsOnReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_utils_on_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_utils_on_ready_data_free);
	_data_->self = _g_object_ref0 (self);
	gwibber_utils_on_ready_co (_data_);
}


static gboolean gwibber_utils_on_ready_finish (GwibberUtils* self, GAsyncResult* _res_) {
	gboolean result;
	GwibberUtilsOnReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void gwibber_utils_on_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GwibberUtilsOnReadyData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gwibber_utils_on_ready_co (data);
}


static gboolean gwibber_utils_on_ready_co (GwibberUtilsOnReadyData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	gwibber_dbus_iface_list_names (data->self->priv->bus, gwibber_utils_on_ready_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = gwibber_dbus_iface_list_names_finish (data->self->priv->bus, data->_res_, &data->_tmp0_, &data->_inner_error_);
	data->n = data->_tmp1_;
	data->n_length1 = data->_tmp0_;
	data->_n_size_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch56_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	gwibber_utils_check_names (data->self, data->n, data->n_length1, NULL, NULL);
	data->n = (_vala_array_free (data->n, data->n_length1, (GDestroyNotify) g_free), NULL);
	goto __finally56;
	__catch56_g_io_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("utils.vala:75: Can't list: %s", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally56:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->result = FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


gchar* gwibber_utils_generate_time_string (GwibberUtils* self, guint t) {
	gchar* result = NULL;
	time_t _tmp0_;
	struct tm _tmp1_ = {0};
	struct tm _tmp2_ = {0};
	time_t _tmp3_;
	gint now;
	gint d;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = time (NULL);
	g_time_gm (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = mktime (&_tmp2_);
	now = ((gint) _tmp3_) - 3600;
	d = (gint) (now - t);
	if (d < 30) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = _ ("a few seconds ago");
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	if (d < 120) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = _ ("1 minute ago");
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		return result;
	}
	if (d < 3600) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = _ ("%i minutes ago");
		_tmp9_ = g_strdup_printf (_tmp8_, d / 60);
		result = _tmp9_;
		return result;
	}
	if (d < 7200) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp10_ = _ ("1 hour ago");
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	if (d < 86400) {
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp12_ = _ ("%i hours ago");
		_tmp13_ = g_strdup_printf (_tmp12_, d / 3600);
		result = _tmp13_;
		return result;
	}
	if (d >= 86400) {
		_tmp14_ = d < 172800;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp15_ = _ ("%i day ago");
		_tmp16_ = g_strdup_printf (_tmp15_, d / 86400);
		result = _tmp16_;
		return result;
	}
	_tmp17_ = _ ("%i days ago");
	_tmp18_ = g_strdup_printf (_tmp17_, d / 86400);
	result = _tmp18_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch57_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch57_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally57;
	__catch57_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally57:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* gwibber_utils_avatar_path (GwibberUtils* self, const gchar* url) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _avatar_cache_image;
	GFile* _tmp5_ = NULL;
	GFile* file;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = string_replace (url, "/", "");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, "gwibber/avatars", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_avatar_cache_image = _tmp4_;
	_tmp5_ = g_file_new_for_path (_avatar_cache_image);
	file = _tmp5_;
	_tmp6_ = g_file_query_exists (file, NULL);
	if (_tmp6_) {
		result = _avatar_cache_image;
		_g_object_unref0 (file);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (file);
		_g_free0 (_avatar_cache_image);
		return result;
	}
	_g_object_unref0 (file);
	_g_free0 (_avatar_cache_image);
}


static void gwibber_utils_do_setup_data_free (gpointer _data) {
	GwibberUtilsDoSetupData* data;
	data = _data;
	_g_free0 (data->name);
	_g_object_unref0 (data->self);
	g_slice_free (GwibberUtilsDoSetupData, data);
}


static void gwibber_utils_do_setup (GwibberUtils* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberUtilsDoSetupData* _data_;
	_data_ = g_slice_new0 (GwibberUtilsDoSetupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_utils_do_setup);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_utils_do_setup_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->name = g_strdup (name);
	gwibber_utils_do_setup_co (_data_);
}


static void gwibber_utils_do_setup_finish (GwibberUtils* self, GAsyncResult* _res_, GError** error) {
	GwibberUtilsDoSetupData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gwibber_utils_do_setup_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GwibberUtilsDoSetupData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gwibber_utils_do_setup_co (data);
}


static void _gwibber_utils_on_name_owner_changed_gwibber_dbus_iface_name_owner_changed (GwibberDBusIface* _sender, const gchar* name, const gchar* oldowner, const gchar* newowner, gpointer self) {
	gwibber_utils_on_name_owner_changed (self, name, oldowner, newowner);
}


static gboolean gwibber_utils_do_setup_co (GwibberUtilsDoSetupData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	g_async_initable_new_async (GWIBBER_TYPE_DBUS_IFACE_PROXY, 0, NULL, gwibber_utils_do_setup_ready, data, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_async_initable_new_finish (data->_source_object_, data->_res_, &data->_inner_error_);
	data->_tmp1_ = (GwibberDBusIface*) data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (data->self->priv->bus);
	data->self->priv->bus = data->_tmp1_;
	g_signal_connect_object (data->self->priv->bus, "name-owner-changed", (GCallback) _gwibber_utils_on_name_owner_changed_gwibber_dbus_iface_name_owner_changed, data->self, 0);
	data->_state_ = 2;
	gwibber_utils_on_ready (data->self, gwibber_utils_do_setup_ready, data);
	return FALSE;
	_state_2:
	gwibber_utils_on_ready_finish (data->self, data->_res_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error) {
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->interface_name);
	self->priv->interface_name = _tmp0_;
	gwibber_utils_do_setup (self, name, NULL, NULL);
	goto __finally58;
	__catch58_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("utils.vala:127: %s", e->message);
		_g_error_free0 (e);
	}
	__finally58:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


GwibberUtils* gwibber_utils_construct (GType object_type) {
	GwibberUtils * self = NULL;
	self = (GwibberUtils*) g_object_new (object_type, NULL);
	return self;
}


GwibberUtils* gwibber_utils_new (void) {
	return gwibber_utils_construct (GWIBBER_TYPE_UTILS);
}


static void gwibber_utils_class_init (GwibberUtilsClass * klass) {
	gwibber_utils_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberUtilsPrivate));
	G_OBJECT_CLASS (klass)->finalize = gwibber_utils_finalize;
	/** 
	            Utils::available:
	    @arg0: bool
	            Emitted when the DBus service becomes available
	        */
	g_signal_new ("available", GWIBBER_TYPE_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gwibber_utils_instance_init (GwibberUtils * self) {
	self->priv = GWIBBER_UTILS_GET_PRIVATE (self);
}


static void gwibber_utils_finalize (GObject* obj) {
	GwibberUtils * self;
	self = GWIBBER_UTILS (obj);
	_g_object_unref0 (self->priv->bus);
	_g_free0 (self->priv->interface_name);
	G_OBJECT_CLASS (gwibber_utils_parent_class)->finalize (obj);
}


GType gwibber_utils_get_type (void) {
	static volatile gsize gwibber_utils_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberUtils), 0, (GInstanceInitFunc) gwibber_utils_instance_init, NULL };
		GType gwibber_utils_type_id;
		gwibber_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberUtils", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_utils_type_id__volatile, gwibber_utils_type_id);
	}
	return gwibber_utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



