/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

namespace GwibberGtk
{
public class ActionBox : Gtk.HBox
{
  /*
  private ActionBoxItem? _item = null;

  public ActionBoxItem item {
    get { return _item; }
    set {
      if (_item != value)
        {
          if (_item != null)
          {
            foreach (var _w in _item.get_children ())
              _item.remove (_w);
            _item.menu = null;
            _item.image = null;
          }
          _item = value;
        }
    }
  }
  */

  public ActionBox ()
  {
    Object ();
  }

  construct
  {
  }
}

public class ActionBoxItem : Gtk.EventBox
{
  public string service  { get; construct set; }
  public string stream  { get; construct set; }
  public string account { get; construct set; }
  public string mid { get; construct set; }
  public string sender { get; construct set; }
  public string action { get; construct set; }
  public string tooltip { get; construct set; }

  private Gtk.Image _image;
  private string _icon;
  private string _scalable_icon;
  private Gtk.Menu? menu;
  private Gtk.MenuItem? amenu;

  public ActionBoxItem (string service, string stream, string account, string mid, string sender, string tooltip = "")
  {
    Object (service:service, stream:stream, account:account, mid:mid, sender:sender, tooltip:tooltip);
  }

  ~ActionBoxItem ()
  {
    _image.destroy ();
    _image = null;
    foreach (var _w in menu.get_children ())
    {
      menu.remove (_w);
      _w.destroy ();
      _w = null;
    }
    menu.destroy ();
    menu = null;
  }

  construct
  {
    if (tooltip.length < 1)
      tooltip = service;

    _image = new Gtk.Image ();
    _icon = GLib.Path.build_filename (Config.PKGDATADIR, "ui/icons/breakdance/16x16/" + service + ".png");
    _scalable_icon = GLib.Path.build_filename (Config.PKGDATADIR, "ui/icons/breakdance/scalable/" + service + ".svg");
    if (!(GLib.FileUtils.test (_icon, GLib.FileTest.EXISTS)))
    {
      _icon = GLib.Path.build_filename (Config.PKGDATADIR + "/plugins/" + service + "/ui/icons/16x16/" + service + ".png");
      _scalable_icon = GLib.Path.build_filename (Config.PKGDATADIR + "/plugins/" + service + "/ui/icons/scalable/" + service + ".svg");
    }
    _image.set_from_file(_icon);
    _image.set_no_show_all (false);
    _image.tooltip_text = tooltip;
    add (_image);
    menu = build_menu ();
    if (get_parent() is Gtk.Widget)
      reparent (menu);
    else
      menu.attach_to_widget (this, null);

    button_press_event.connect((event) => {
      if (menu.get_children ().length () > 0)
        menu.popup (null, null, null, event.button, event.time);
      return true;
    });

  }

  [Signal (action=true)]
  public virtual signal void reply (string mid, string account, string sender)
  {
  }


  private void user_stream (string account, string sender)
  {
    var streams = new Gwibber.Streams ();
    streams.create (account, sender.replace ("@", ""), "user_messages");
  }

  public bool share (string mid, string account)
  {
    var service = new Gwibber.Service ();
    return service.retweet(mid, account);
  }

  public bool like (string mid, string account)
  {
    var service = new Gwibber.Service ();
    return service.like(mid, account);
  }

  private Gtk.Menu build_menu ()
  {
    menu = new Gtk.Menu ();

    if (service != "flicker" && service != "pingfm" && service != "foursquare" && service != "digg")
    {
      amenu = new Gtk.MenuItem.with_mnemonic (_("_Reply"));
      amenu.activate.connect(() => {
        string nick = "";
        Json.Object obj = null;
        Json.Object sender_obj = null;

        try
        {
          var messages = new Gwibber.Messages ();
          var msg = messages.get_message (mid);

          var parser = new Json.Parser();
          parser.load_from_data(msg);
  
          obj = parser.get_root().get_object();
          if (obj != null)
          {
            if (obj.has_member ("sender"))
            {
              sender_obj = obj.get_object_member ("sender");
              if (sender_obj != null)
              {
                if (sender_obj.has_member ("nick"))
                  nick = sender_obj.get_string_member ("nick");
              }
            }
          }
        } catch (GLib.IOError e) {
          warning (e.message);
        }
        if (nick.length > 0)
          nick = "@" + nick;
        reply (mid, account, nick);
      });
      menu.append(amenu);
    }

    if (service != "flicker" && service != "pingfm" && service != "foursquare" && service != "digg" && service != "qaiku" && service != "buzz" && stream != "private")
    {
      amenu = new Gtk.MenuItem.with_mnemonic (_("_Like"));
      amenu.activate.connect(() => {
        var ret = like (mid, account);
        if (ret) {
          string name = "";
          string nick = "";
          Json.Object obj = null;
          Json.Object sender_obj = null;

          try
          {
            var messages = new Gwibber.Messages ();
            var msg = messages.get_message (mid);

            var parser = new Json.Parser();
            parser.load_from_data(msg);
  
            obj = parser.get_root().get_object();
            if (obj != null)
            {
              if (obj.has_member ("sender"))
              {
                sender_obj = obj.get_object_member ("sender");
                if (sender_obj != null)
                {
                  if (sender_obj.has_member ("nick"))
                    nick = sender_obj.get_string_member ("nick");
                  if (sender_obj.has_member ("name"))
                    name = sender_obj.get_string_member ("name");
                }
              }
            }
          } catch (GLib.IOError e) {
            warning (e.message);
          }
          if (name.length > 0)
            nick = name;

          var notification = new Notify.Notification (_("Liked"), _("Liked post from ") + nick, _scalable_icon);
          notification.show ();
        }
      });
      menu.append(amenu);
    }

    if ((service == "twitter" || service == "identica" || service == "statusnet" || service == "sina" || service == "sohu") && stream != "private")
    {
      amenu = new Gtk.MenuItem ();
      if (service == "twitter")
      {
        amenu = new Gtk.MenuItem.with_mnemonic (_("Re_tweet"));
      }
      if (service == "identica" || service == "statusnet")
      {
        amenu = new Gtk.MenuItem.with_mnemonic (_("Re_peat"));
      }
      amenu.activate.connect(() => {
        var ret = share (mid, account);
        if (ret) {
          var notification = new Notify.Notification (_("Shared"), _("Shared post from ") + sender, _scalable_icon);
          notification.show ();
        }
      });
      menu.append(amenu);
    }

    if ((service == "twitter" || service == "identica" || service == "statusnet") && stream != "user")
    {
      amenu = new Gtk.MenuItem.with_mnemonic (_("View User _Profile"));
      amenu.activate.connect(() => {
        user_stream (account, sender);
      });
      menu.append(amenu);
    }

    menu.show_all ();
    return menu;
  }
}
}
