/* gwibber-client.c generated by valac 0.12.1, the Vala compiler
 * generated from gwibber-client.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include <gwibber-gtk.h>
#include <gwibber.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gdk/gdk.h>


#define TYPE_CLIENT (client_get_type ())
#define CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLIENT, Client))
#define CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLIENT, ClientClass))
#define IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLIENT))
#define IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLIENT))
#define CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLIENT, ClientClass))

typedef struct _Client Client;
typedef struct _ClientClass ClientClass;
typedef struct _ClientPrivate ClientPrivate;

#define TYPE_TAB_BAR_ITEM (tab_bar_item_get_type ())
#define TAB_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR_ITEM, TabBarItem))
#define TAB_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR_ITEM, TabBarItemClass))
#define IS_TAB_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR_ITEM))
#define IS_TAB_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR_ITEM))
#define TAB_BAR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR_ITEM, TabBarItemClass))

typedef struct _TabBarItem TabBarItem;
typedef struct _TabBarItemClass TabBarItemClass;

#define TYPE_TAB_BAR (tab_bar_get_type ())
#define TAB_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR, TabBar))
#define TAB_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR, TabBarClass))
#define IS_TAB_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR))
#define IS_TAB_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR))
#define TAB_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR, TabBarClass))

typedef struct _TabBar TabBar;
typedef struct _TabBarClass TabBarClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SEARCHES_ITEM (searches_item_get_type ())
#define SEARCHES_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCHES_ITEM, SearchesItem))
#define SEARCHES_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCHES_ITEM, SearchesItemClass))
#define IS_SEARCHES_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCHES_ITEM))
#define IS_SEARCHES_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCHES_ITEM))
#define SEARCHES_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCHES_ITEM, SearchesItemClass))

typedef struct _SearchesItem SearchesItem;
typedef struct _SearchesItemClass SearchesItemClass;

#define TYPE_USERS_ITEM (users_item_get_type ())
#define USERS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USERS_ITEM, UsersItem))
#define USERS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USERS_ITEM, UsersItemClass))
#define IS_USERS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USERS_ITEM))
#define IS_USERS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USERS_ITEM))
#define USERS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USERS_ITEM, UsersItemClass))

typedef struct _UsersItem UsersItem;
typedef struct _UsersItemClass UsersItemClass;
typedef struct _Block1Data Block1Data;

#define TYPE_TAB_BAR_STREAM_ITEM (tab_bar_stream_item_get_type ())
#define TAB_BAR_STREAM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR_STREAM_ITEM, TabBarStreamItem))
#define TAB_BAR_STREAM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR_STREAM_ITEM, TabBarStreamItemClass))
#define IS_TAB_BAR_STREAM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR_STREAM_ITEM))
#define IS_TAB_BAR_STREAM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR_STREAM_ITEM))
#define TAB_BAR_STREAM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR_STREAM_ITEM, TabBarStreamItemClass))

typedef struct _TabBarStreamItem TabBarStreamItem;
typedef struct _TabBarStreamItemClass TabBarStreamItemClass;

#define TYPE_HOME_ITEM (home_item_get_type ())
#define HOME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_ITEM, HomeItem))
#define HOME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_ITEM, HomeItemClass))
#define IS_HOME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_ITEM))
#define IS_HOME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_ITEM))
#define HOME_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_ITEM, HomeItemClass))

typedef struct _HomeItem HomeItem;
typedef struct _HomeItemClass HomeItemClass;

#define TYPE_MESSAGES_ITEM (messages_item_get_type ())
#define MESSAGES_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MESSAGES_ITEM, MessagesItem))
#define MESSAGES_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MESSAGES_ITEM, MessagesItemClass))
#define IS_MESSAGES_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MESSAGES_ITEM))
#define IS_MESSAGES_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MESSAGES_ITEM))
#define MESSAGES_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MESSAGES_ITEM, MessagesItemClass))

typedef struct _MessagesItem MessagesItem;
typedef struct _MessagesItemClass MessagesItemClass;

#define TYPE_REPLIES_ITEM (replies_item_get_type ())
#define REPLIES_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPLIES_ITEM, RepliesItem))
#define REPLIES_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPLIES_ITEM, RepliesItemClass))
#define IS_REPLIES_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPLIES_ITEM))
#define IS_REPLIES_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPLIES_ITEM))
#define REPLIES_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPLIES_ITEM, RepliesItemClass))

typedef struct _RepliesItem RepliesItem;
typedef struct _RepliesItemClass RepliesItemClass;

#define TYPE_PRIVATE_ITEM (private_item_get_type ())
#define PRIVATE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRIVATE_ITEM, PrivateItem))
#define PRIVATE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRIVATE_ITEM, PrivateItemClass))
#define IS_PRIVATE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRIVATE_ITEM))
#define IS_PRIVATE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRIVATE_ITEM))
#define PRIVATE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRIVATE_ITEM, PrivateItemClass))

typedef struct _PrivateItem PrivateItem;
typedef struct _PrivateItemClass PrivateItemClass;

#define TYPE_PUBLIC_ITEM (public_item_get_type ())
#define PUBLIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUBLIC_ITEM, PublicItem))
#define PUBLIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUBLIC_ITEM, PublicItemClass))
#define IS_PUBLIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUBLIC_ITEM))
#define IS_PUBLIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUBLIC_ITEM))
#define PUBLIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUBLIC_ITEM, PublicItemClass))

typedef struct _PublicItem PublicItem;
typedef struct _PublicItemClass PublicItemClass;

#define TYPE_ATTACHMENTS_ITEM (attachments_item_get_type ())
#define ATTACHMENTS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ATTACHMENTS_ITEM, AttachmentsItem))
#define ATTACHMENTS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ATTACHMENTS_ITEM, AttachmentsItemClass))
#define IS_ATTACHMENTS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ATTACHMENTS_ITEM))
#define IS_ATTACHMENTS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ATTACHMENTS_ITEM))
#define ATTACHMENTS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ATTACHMENTS_ITEM, AttachmentsItemClass))

typedef struct _AttachmentsItem AttachmentsItem;
typedef struct _AttachmentsItemClass AttachmentsItemClass;

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Client {
	GtkWindow parent_instance;
	ClientPrivate * priv;
	GeeHashMap* streams_map;
	GeeHashMap* items_map;
	TabBar* tabbar;
	GwibberGtkStreamView* view;
	GtkUIManager* manager;
};

struct _ClientClass {
	GtkWindowClass parent_class;
};

struct _ClientPrivate {
	GwibberStreams* streams_service;
	GtkSpinner* spinner;
	GtkAlignment* spinner_align;
	GSettings* state_settings;
	gint _sort_order;
};

struct _Block1Data {
	int _ref_count_;
	Client * self;
	GtkVBox* main_box;
	SearchesItem* searches_item;
	UsersItem* users_item;
};

struct _Main {
	GtkApplication parent_instance;
	MainPrivate * priv;
};

struct _MainClass {
	GtkApplicationClass parent_class;
};


static gpointer client_parent_class = NULL;
static gpointer main_parent_class = NULL;
static gchar* main_stream;
static gchar* main_stream = NULL;
static Client* main_main_window;
static Client* main_main_window = NULL;

GType client_get_type (void) G_GNUC_CONST;
GType tab_bar_item_get_type (void) G_GNUC_CONST;
GType tab_bar_get_type (void) G_GNUC_CONST;
#define CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CLIENT, ClientPrivate))
enum  {
	CLIENT_DUMMY_PROPERTY,
	CLIENT_SORT_ORDER
};
Client* client_new (void);
Client* client_construct (GType object_type);
GtkMenuBar* client_create_menus (Client* self);
static void _vala_array_add1 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _vala_array_add2 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _vala_array_add3 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _vala_array_add4 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void client_on_refresh (void);
static void _client_on_refresh_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add5 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void client_on_quit (void);
static void _client_on_quit_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add6 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _vala_array_add7 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void client_on_accounts (void);
static void _client_on_accounts_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add8 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void client_on_preferences (void);
static void _client_on_preferences_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add9 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void client_on_about (void);
static void _client_on_about_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add10 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _vala_array_add11 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
static void _vala_array_add12 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
gint client_get_sort_order (Client* self);
static void _lambda15_ (GtkAction* a, GtkAction* c, Client* self);
static void __lambda15__gtk_radio_action_callback (GtkAction* action, GtkAction* current, gpointer self);
static void client_on_close_stream (void);
static void client_on_window_close (void);
static gboolean client_on_configure_event (Client* self, GdkEventConfigure* event);
void client_set_sort_order (Client* self, gint value);
GtkWidget* tab_bar_item_get_view (TabBarItem* self);
static GObject * client_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GType searches_item_get_type (void) G_GNUC_CONST;
GType users_item_get_type (void) G_GNUC_CONST;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _client_on_configure_event_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static void _client_on_window_close_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
TabBar* tab_bar_new (void);
TabBar* tab_bar_construct (GType object_type);
HomeItem* home_item_new (GeeHashMap* streams);
HomeItem* home_item_construct (GType object_type, GeeHashMap* streams);
GType tab_bar_stream_item_get_type (void) G_GNUC_CONST;
GType home_item_get_type (void) G_GNUC_CONST;
void tab_bar_add_item (TabBar* self, TabBarItem* item);
MessagesItem* messages_item_new (GeeHashMap* streams);
MessagesItem* messages_item_construct (GType object_type, GeeHashMap* streams);
GType messages_item_get_type (void) G_GNUC_CONST;
RepliesItem* replies_item_new (GeeHashMap* streams);
RepliesItem* replies_item_construct (GType object_type, GeeHashMap* streams);
GType replies_item_get_type (void) G_GNUC_CONST;
PrivateItem* private_item_new (GeeHashMap* streams);
PrivateItem* private_item_construct (GType object_type, GeeHashMap* streams);
GType private_item_get_type (void) G_GNUC_CONST;
PublicItem* public_item_new (GeeHashMap* streams);
PublicItem* public_item_construct (GType object_type, GeeHashMap* streams);
GType public_item_get_type (void) G_GNUC_CONST;
AttachmentsItem* attachments_item_new (GeeHashMap* streams);
AttachmentsItem* attachments_item_construct (GType object_type, GeeHashMap* streams);
GType attachments_item_get_type (void) G_GNUC_CONST;
SearchesItem* searches_item_new (GwibberStreams* streams);
SearchesItem* searches_item_construct (GType object_type, GwibberStreams* streams);
static void _lambda33_ (TabBarItem* item, Block1Data* _data1_);
static void __lambda33__searches_item_raise (SearchesItem* _sender, TabBarItem* item, gpointer self);
UsersItem* users_item_new (GwibberStreams* streams);
UsersItem* users_item_construct (GType object_type, GwibberStreams* streams);
static void _lambda54_ (TabBarItem* item, Block1Data* _data1_);
static void __lambda54__users_item_raise (UsersItem* _sender, TabBarItem* item, gpointer self);
static void _lambda55_ (Client* self);
static void __lambda55__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda56_ (const gchar* key, Client* self);
static void __lambda56__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static gboolean _lambda57_ (Block1Data* _data1_);
static gboolean __lambda57__gsource_func (gpointer self);
static void client_finalize (GObject* obj);
static void _vala_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType main_get_type (void) G_GNUC_CONST;
enum  {
	MAIN_DUMMY_PROPERTY
};
Main* main_new (const gchar* app_id, GApplicationFlags flags);
Main* main_construct (GType object_type, const gchar* app_id, GApplicationFlags flags);
void main_on_activate (Main* self);
static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gint main_on_command_line (Main* self, GApplicationCommandLine* command_line);
void tab_bar_on_tab_clicked (TabBar* self, GtkButton* gtk_item);
static void main_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _main_on_activate_g_application_activate (GApplication* _sender, gpointer self);
static gint _main_on_command_line_g_application_command_line (GApplication* _sender, GApplicationCommandLine* command_line, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry MAIN_options[2] = {{"stream", 's', 0, G_OPTION_ARG_STRING, &main_stream, "Stream", "STREAM"}, {NULL}};

Client* client_construct (GType object_type) {
	Client * self = NULL;
	self = (Client*) g_object_new (object_type, NULL);
	return self;
}


Client* client_new (void) {
	return client_construct (TYPE_CLIENT);
}


static void _vala_array_add1 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add2 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add3 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add4 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _client_on_refresh_gtk_action_callback (GtkAction* action, gpointer self) {
	client_on_refresh ();
}


static void _vala_array_add5 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _client_on_quit_gtk_action_callback (GtkAction* action, gpointer self) {
	client_on_quit ();
}


static void _vala_array_add6 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add7 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _client_on_accounts_gtk_action_callback (GtkAction* action, gpointer self) {
	client_on_accounts ();
}


static void _vala_array_add8 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _client_on_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
	client_on_preferences ();
}


static void _vala_array_add9 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _client_on_about_gtk_action_callback (GtkAction* action, gpointer self) {
	client_on_about ();
}


static void _vala_array_add10 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add11 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkRadioActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add12 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkRadioActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda15_ (GtkAction* a, GtkAction* c, Client* self) {
	GtkRadioAction* _tmp0_;
	GtkRadioAction* current;
	gint _tmp1_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = _g_object_ref0 (GTK_RADIO_ACTION (c));
	current = _tmp0_;
	_tmp1_ = gtk_radio_action_get_current_value (current);
	g_settings_set_int (self->priv->state_settings, "stream-sort-order", _tmp1_);
	_g_object_unref0 (current);
}


static void __lambda15__gtk_radio_action_callback (GtkAction* action, GtkAction* current, gpointer self) {
	_lambda15_ (action, current, self);
}


GtkMenuBar* client_create_menus (Client* self) {
	GtkMenuBar* result = NULL;
	GtkActionEntry* _tmp0_ = NULL;
	GtkActionEntry* entries;
	gint entries_length1;
	gint _entries_size_;
	const gchar* _tmp1_ = NULL;
	GtkActionEntry _tmp2_ = {0};
	GtkActionEntry menu;
	const gchar* _tmp3_ = NULL;
	GtkActionEntry _tmp4_ = {0};
	const gchar* _tmp5_ = NULL;
	GtkActionEntry _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	GtkActionEntry _tmp8_ = {0};
	const gchar* _tmp9_ = NULL;
	GtkActionEntry _tmp10_ = {0};
	const gchar* _tmp11_ = NULL;
	GtkActionEntry _tmp12_ = {0};
	const gchar* _tmp13_ = NULL;
	GtkActionEntry _tmp14_ = {0};
	const gchar* _tmp15_ = NULL;
	GtkActionEntry _tmp16_ = {0};
	const gchar* _tmp17_ = NULL;
	GtkActionEntry _tmp18_ = {0};
	const gchar* _tmp19_ = NULL;
	GtkActionEntry _tmp20_ = {0};
	GtkRadioActionEntry* _tmp21_ = NULL;
	GtkRadioActionEntry* sort_entries;
	gint sort_entries_length1;
	gint _sort_entries_size_;
	const gchar* _tmp22_ = NULL;
	GtkRadioActionEntry _tmp23_ = {0};
	GtkRadioActionEntry radio;
	const gchar* _tmp24_ = NULL;
	GtkRadioActionEntry _tmp25_ = {0};
	gchar* _tmp26_;
	gchar* ui;
	GtkActionGroup* _tmp27_ = NULL;
	GtkActionGroup* main_group;
	gint _tmp28_;
	GtkUIManager* _tmp29_ = NULL;
	GtkUIManager* manager;
	GtkWidget* _tmp30_ = NULL;
	GtkWidget* _tmp31_;
	GtkMenuBar* _tmp32_;
	GtkMenuBar* menubar;
	GtkAccelGroup* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GtkActionEntry, 0);
	entries = _tmp0_;
	entries_length1 = 0;
	_entries_size_ = 0;
	_tmp1_ = _ ("_Gwibber");
	_tmp2_.name = "Gwibber";
	_tmp2_.stock_id = NULL;
	_tmp2_.label = _tmp1_;
	_tmp2_.accelerator = NULL;
	_tmp2_.tooltip = NULL;
	_tmp2_.callback = (GCallback) NULL;
	menu = _tmp2_;
	_vala_array_add1 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp3_ = _ ("_View");
	_tmp4_.name = "View";
	_tmp4_.stock_id = NULL;
	_tmp4_.label = _tmp3_;
	_tmp4_.accelerator = NULL;
	_tmp4_.tooltip = NULL;
	_tmp4_.callback = (GCallback) NULL;
	menu = _tmp4_;
	_vala_array_add2 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp5_ = _ ("_Edit");
	_tmp6_.name = "Edit";
	_tmp6_.stock_id = NULL;
	_tmp6_.label = _tmp5_;
	_tmp6_.accelerator = NULL;
	_tmp6_.tooltip = NULL;
	_tmp6_.callback = (GCallback) NULL;
	menu = _tmp6_;
	_vala_array_add3 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp7_ = _ ("_Help");
	_tmp8_.name = "Help";
	_tmp8_.stock_id = NULL;
	_tmp8_.label = _tmp7_;
	_tmp8_.accelerator = NULL;
	_tmp8_.tooltip = NULL;
	_tmp8_.callback = (GCallback) NULL;
	menu = _tmp8_;
	_vala_array_add4 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp9_ = _ ("_Refresh");
	_tmp10_.name = "refresh";
	_tmp10_.stock_id = GTK_STOCK_REFRESH;
	_tmp10_.label = _tmp9_;
	_tmp10_.accelerator = "F5";
	_tmp10_.tooltip = NULL;
	_tmp10_.callback = (GCallback) _client_on_refresh_gtk_action_callback;
	menu = _tmp10_;
	_vala_array_add5 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp11_ = _ ("_Quit");
	_tmp12_.name = "quit";
	_tmp12_.stock_id = GTK_STOCK_QUIT;
	_tmp12_.label = _tmp11_;
	_tmp12_.accelerator = "<ctrl>Q";
	_tmp12_.tooltip = NULL;
	_tmp12_.callback = (GCallback) _client_on_quit_gtk_action_callback;
	menu = _tmp12_;
	_vala_array_add6 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp13_ = _ ("_Sort");
	_tmp14_.name = "sort";
	_tmp14_.stock_id = NULL;
	_tmp14_.label = _tmp13_;
	_tmp14_.accelerator = NULL;
	_tmp14_.tooltip = NULL;
	_tmp14_.callback = (GCallback) NULL;
	menu = _tmp14_;
	_vala_array_add7 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp15_ = _ ("_Accounts");
	_tmp16_.name = "accounts";
	_tmp16_.stock_id = NULL;
	_tmp16_.label = _tmp15_;
	_tmp16_.accelerator = "<ctrl><shift>A";
	_tmp16_.tooltip = NULL;
	_tmp16_.callback = (GCallback) _client_on_accounts_gtk_action_callback;
	menu = _tmp16_;
	_vala_array_add8 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp17_ = _ ("_Preferences");
	_tmp18_.name = "preferences";
	_tmp18_.stock_id = GTK_STOCK_PREFERENCES;
	_tmp18_.label = _tmp17_;
	_tmp18_.accelerator = "<ctrl>P";
	_tmp18_.tooltip = NULL;
	_tmp18_.callback = (GCallback) _client_on_preferences_gtk_action_callback;
	menu = _tmp18_;
	_vala_array_add9 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp19_ = _ ("_About");
	_tmp20_.name = "about";
	_tmp20_.stock_id = GTK_STOCK_ABOUT;
	_tmp20_.label = _tmp19_;
	_tmp20_.accelerator = NULL;
	_tmp20_.tooltip = NULL;
	_tmp20_.callback = (GCallback) _client_on_about_gtk_action_callback;
	menu = _tmp20_;
	_vala_array_add10 (&entries, &entries_length1, &_entries_size_, &menu);
	_tmp21_ = g_new0 (GtkRadioActionEntry, 0);
	sort_entries = _tmp21_;
	sort_entries_length1 = 0;
	_sort_entries_size_ = 0;
	_tmp22_ = _ ("_Ascending");
	_tmp23_.name = "ascending";
	_tmp23_.stock_id = GTK_STOCK_SORT_ASCENDING;
	_tmp23_.label = _tmp22_;
	_tmp23_.accelerator = NULL;
	_tmp23_.tooltip = NULL;
	_tmp23_.value = 0;
	radio = _tmp23_;
	_vala_array_add11 (&sort_entries, &sort_entries_length1, &_sort_entries_size_, &radio);
	_tmp24_ = _ ("_Descending");
	_tmp25_.name = "descending";
	_tmp25_.stock_id = GTK_STOCK_SORT_DESCENDING;
	_tmp25_.label = _tmp24_;
	_tmp25_.accelerator = NULL;
	_tmp25_.tooltip = NULL;
	_tmp25_.value = 1;
	radio = _tmp25_;
	_vala_array_add12 (&sort_entries, &sort_entries_length1, &_sort_entries_size_, &radio);
	_tmp26_ = g_strdup ("\n" \
"    <ui>\n" \
"      <menubar name=\"MenuBar\">\n" \
"        <menu action=\"Gwibber\">\n" \
"          <menuitem action=\"refresh\" />\n" \
"          <separator/>\n" \
"          <menuitem action=\"quit\" />\n" \
"        </menu>\n" \
"\n" \
"        <menu action=\"View\">\n" \
"          <menu action=\"sort\">\n" \
"            <menuitem action=\"ascending\" />\n" \
"            <menuitem action=\"descending\" />\n" \
"          </menu>\n" \
"        </menu>\n" \
"\n" \
"        <menu action=\"Edit\">\n" \
"          <menuitem action=\"accounts\" />\n" \
"          <menuitem name=\"preferences\" action=\"preferences\" />\n" \
"        </menu>\n" \
"\n" \
"        <menu action=\"Help\">\n" \
"          <menuitem action=\"about\" />\n" \
"        </menu>\n" \
"      </menubar>\n" \
"    </ui>\n" \
"    ");
	ui = _tmp26_;
	_tmp27_ = gtk_action_group_new ("client");
	main_group = _tmp27_;
	gtk_action_group_add_actions (main_group, entries, entries_length1, self);
	_tmp28_ = client_get_sort_order (self);
	gtk_action_group_add_radio_actions (main_group, sort_entries, sort_entries_length1, _tmp28_, (GCallback) __lambda15__gtk_radio_action_callback, self);
	_tmp29_ = gtk_ui_manager_new ();
	manager = _tmp29_;
	gtk_ui_manager_add_ui_from_string (manager, ui, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("gwibber-client.vala:247: %s", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (manager);
		_g_object_unref0 (main_group);
		_g_free0 (ui);
		sort_entries = (g_free (sort_entries), NULL);
		entries = (g_free (entries), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gtk_ui_manager_insert_action_group (manager, main_group, 0);
	_tmp30_ = gtk_ui_manager_get_widget (manager, "/MenuBar");
	_tmp31_ = _tmp30_;
	_tmp32_ = _g_object_ref0 (GTK_IS_MENU_BAR (_tmp31_) ? ((GtkMenuBar*) _tmp31_) : NULL);
	menubar = _tmp32_;
	_tmp33_ = gtk_ui_manager_get_accel_group (manager);
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp33_);
	result = menubar;
	_g_object_unref0 (manager);
	_g_object_unref0 (main_group);
	_g_free0 (ui);
	sort_entries = (g_free (sort_entries), NULL);
	entries = (g_free (entries), NULL);
	return result;
}


static void client_on_refresh (void) {
	GwibberService* _tmp0_ = NULL;
	GwibberService* service;
	_tmp0_ = gwibber_service_new ();
	service = _tmp0_;
	gwibber_service_refresh (service);
	_g_object_unref0 (service);
}


static void client_on_preferences (void) {
	GPid pid = 0;
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GPid _tmp3_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup ("gwibber-preferences");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	g_spawn_async (NULL, _tmp2_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp3_, &_inner_error_);
	pid = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void client_on_accounts (void) {
	GPid pid = 0;
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GPid _tmp3_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup ("gwibber-accounts");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	g_spawn_async (NULL, _tmp2_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp3_, &_inner_error_);
	pid = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	goto __finally2;
	__catch2_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void client_on_close_stream (void) {
}


static void client_on_about (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* license;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	GtkAboutDialog* _tmp5_ = NULL;
	GtkAboutDialog* about_dialog;
	_tmp0_ = _ ("Gwibber is free software; you can redistribute it and/or modify it und" \
"er the terms of the GNU General Public License as published by the Fre" \
"e Software Foundation; either version 2 of the License, or (at your op" \
"tion) any later version.\n" \
"\n" \
"Gwibber is distributed in the hope that it will be useful, but WITHOUT" \
" ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or" \
" FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License" \
" for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License alon" \
"g with Gwibber; if not, write to the Free Software Foundation, Inc., 5" \
"1 Franklin Street, Fifth Floor, Boston, MA 02110-130159 USA");
	_tmp1_ = g_strdup (_tmp0_);
	license = _tmp1_;
	_tmp2_ = g_strdup ("Ken VanDine <ken@vandine.org>");
	_tmp3_ = g_strdup ("Neil Jagdish Patel <njpatel@gmail.com>");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	authors = _tmp4_;
	authors_length1 = 2;
	_authors_size_ = 2;
	_tmp5_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	about_dialog = g_object_ref_sink (_tmp5_);
	gtk_about_dialog_set_program_name (about_dialog, "Gwibber");
	gtk_about_dialog_set_logo_icon_name (about_dialog, "gwibber");
	gtk_about_dialog_set_version (about_dialog, VERSION);
	gtk_about_dialog_set_website (about_dialog, "http://www.gwibber.com");
	gtk_about_dialog_set_license (about_dialog, license);
	gtk_about_dialog_set_wrap_license (about_dialog, TRUE);
	gtk_about_dialog_set_authors (about_dialog, authors);
	gtk_dialog_run ((GtkDialog*) about_dialog);
	gtk_widget_destroy ((GtkWidget*) about_dialog);
	_g_object_unref0 (about_dialog);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (license);
}


static void client_on_quit (void) {
	gtk_main_quit ();
}


static void client_on_window_close (void) {
	gtk_main_quit ();
}


static gboolean client_on_configure_event (Client* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gint width = 0;
	gint height = 0;
	gint x = 0;
	gint y = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	gtk_window_get_position ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	x = _tmp2_;
	y = _tmp3_;
	g_settings_set_int (self->priv->state_settings, "width", width);
	g_settings_set_int (self->priv->state_settings, "height", height);
	g_settings_set_int (self->priv->state_settings, "position-x", x);
	g_settings_set_int (self->priv->state_settings, "position-y", y);
	result = FALSE;
	return result;
}


gint client_get_sort_order (Client* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sort_order;
	return result;
}


void client_set_sort_order (Client* self, gint value) {
	g_return_if_fail (self != NULL);
	if (value != self->priv->_sort_order) {
		self->priv->_sort_order = value;
		{
			GeeCollection* _tmp0_ = NULL;
			GeeCollection* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _v_it;
			_tmp0_ = gee_map_get_values ((GeeMap*) self->items_map);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_);
			_v_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				TabBarItem* v;
				GtkWidget* _tmp6_ = NULL;
				GtkWidget* _tmp7_;
				GwibberGtkStreamView* _view;
				gint _tmp8_;
				_tmp4_ = gee_iterator_next (_v_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_v_it);
				v = (TabBarItem*) _tmp5_;
				_tmp6_ = tab_bar_item_get_view (v);
				_tmp7_ = _tmp6_;
				_view = GWIBBER_GTK_IS_STREAM_VIEW (_tmp7_) ? ((GwibberGtkStreamView*) _tmp7_) : NULL;
				_tmp8_ = gwibber_gtk_stream_view_get_sort_order (_view);
				if (_tmp8_ != self->priv->_sort_order) {
					gwibber_gtk_stream_view_set_sort_order (_view, self->priv->_sort_order);
				}
				_g_object_unref0 (_view);
				_g_object_unref0 (v);
			}
			_g_object_unref0 (_v_it);
		}
	}
	g_object_notify ((GObject *) self, "sort-order");
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->users_item);
		_g_object_unref0 (_data1_->searches_item);
		_g_object_unref0 (_data1_->main_box);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _client_on_configure_event_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = client_on_configure_event (self, event);
	return result;
}


static void _client_on_window_close_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	client_on_window_close ();
}


static void _lambda33_ (TabBarItem* item, Block1Data* _data1_) {
	Client * self;
	self = _data1_->self;
	g_return_if_fail (item != NULL);
	gtk_button_clicked ((GtkButton*) _data1_->searches_item);
}


static void __lambda33__searches_item_raise (SearchesItem* _sender, TabBarItem* item, gpointer self) {
	_lambda33_ (item, self);
}


static void _lambda54_ (TabBarItem* item, Block1Data* _data1_) {
	Client * self;
	self = _data1_->self;
	g_return_if_fail (item != NULL);
	gtk_button_clicked ((GtkButton*) _data1_->users_item);
}


static void __lambda54__users_item_raise (UsersItem* _sender, TabBarItem* item, gpointer self) {
	_lambda54_ (item, self);
}


static void _lambda55_ (Client* self) {
	gint _tmp0_;
	_tmp0_ = g_settings_get_int (self->priv->state_settings, "stream-sort-order");
	client_set_sort_order (self, _tmp0_);
}


static void __lambda55__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda55_ (self);
}


static void _lambda56_ (const gchar* key, Client* self) {
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "stream-sort-order") == 0) {
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = client_get_sort_order (self);
		_tmp1_ = g_settings_get_int (self->priv->state_settings, "stream-sort-order");
		if (_tmp0_ != _tmp1_) {
			gint _tmp2_;
			_tmp2_ = g_settings_get_int (self->priv->state_settings, "stream-sort-order");
			client_set_sort_order (self, _tmp2_);
		}
	}
}


static void __lambda56__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda56_ (key, self);
}


static gboolean _lambda57_ (Block1Data* _data1_) {
	Client * self;
	gboolean result = FALSE;
	GtkMenuBar* _tmp0_ = NULL;
	GtkMenuBar* menubar;
	self = _data1_->self;
	_tmp0_ = client_create_menus (self);
	menubar = _tmp0_;
	gtk_box_pack_start ((GtkBox*) _data1_->main_box, (GtkWidget*) menubar, FALSE, TRUE, (guint) 0);
	result = FALSE;
	_g_object_unref0 (menubar);
	return result;
}


static gboolean __lambda57__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda57_ (self);
	return result;
}


static GObject * client_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Client * self;
	Block1Data* _data1_;
	GSettings* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GtkSpinner* _tmp3_ = NULL;
	gulong _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	TabBar* _tmp9_ = NULL;
	GtkVBox* _tmp10_ = NULL;
	GwibberStreams* _tmp11_ = NULL;
	DeeModel* _tmp12_ = NULL;
	DeeModel* _tmp13_ = NULL;
	DeeModel* _tmp14_;
	HomeItem* _tmp15_ = NULL;
	HomeItem* home_item;
	GtkWidget* _tmp16_ = NULL;
	DeeModel* _tmp17_ = NULL;
	DeeModel* _tmp18_ = NULL;
	DeeModel* _tmp19_;
	DeeModel* _tmp20_ = NULL;
	DeeModel* _tmp21_ = NULL;
	DeeModel* _tmp22_;
	DeeModel* _tmp23_ = NULL;
	DeeModel* _tmp24_ = NULL;
	DeeModel* _tmp25_;
	DeeModel* _tmp26_ = NULL;
	DeeModel* _tmp27_ = NULL;
	DeeModel* _tmp28_;
	DeeModel* _tmp29_ = NULL;
	DeeModel* _tmp30_ = NULL;
	DeeModel* _tmp31_;
	DeeModel* _tmp32_ = NULL;
	DeeModel* _tmp33_ = NULL;
	DeeModel* _tmp34_;
	DeeModel* _tmp35_ = NULL;
	DeeModel* _tmp36_ = NULL;
	DeeModel* _tmp37_;
	MessagesItem* _tmp38_ = NULL;
	MessagesItem* messages_item;
	RepliesItem* _tmp39_ = NULL;
	RepliesItem* replies_item;
	PrivateItem* _tmp40_ = NULL;
	PrivateItem* private_item;
	PublicItem* _tmp41_ = NULL;
	PublicItem* public_item;
	AttachmentsItem* _tmp42_ = NULL;
	AttachmentsItem* attach_item;
	SearchesItem* _tmp43_ = NULL;
	SearchesItem* _tmp44_;
	UsersItem* _tmp45_ = NULL;
	UsersItem* _tmp46_;
	parent_class = G_OBJECT_CLASS (client_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CLIENT (obj);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("org.gwibber.state");
	_g_object_unref0 (self->priv->state_settings);
	self->priv->state_settings = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, DEE_TYPE_MODEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->streams_map);
	self->streams_map = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_TAB_BAR_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->items_map);
	self->items_map = _tmp2_;
	_tmp3_ = (GtkSpinner*) gtk_spinner_new ();
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = g_object_ref_sink (_tmp3_);
	_tmp4_ = g_signal_connect_object ((GtkWidget*) self, "configure-event", (GCallback) _client_on_configure_event_gtk_widget_configure_event, self, 0);
	gtk_buildable_set_name ((GtkBuildable*) self, PACKAGE);
	gtk_window_set_icon_name ((GtkWindow*) self, "gwibber");
	gtk_window_set_title ((GtkWindow*) self, "Gwibber");
	gtk_window_set_wmclass ((GtkWindow*) self, "gwibber", "Gwibber");
	g_signal_connect ((GtkWidget*) self, "destroy", (GCallback) _client_on_window_close_gtk_widget_destroy, NULL);
	gtk_window_set_default_size ((GtkWindow*) self, 400, 800);
	_tmp5_ = g_settings_get_int (self->priv->state_settings, "position-x");
	_tmp6_ = g_settings_get_int (self->priv->state_settings, "position-y");
	gtk_window_move ((GtkWindow*) self, _tmp5_, _tmp6_);
	_tmp7_ = g_settings_get_int (self->priv->state_settings, "width");
	_tmp8_ = g_settings_get_int (self->priv->state_settings, "height");
	gtk_window_resize ((GtkWindow*) self, _tmp7_, _tmp8_);
	_tmp9_ = tab_bar_new ();
	_g_object_unref0 (self->tabbar);
	self->tabbar = g_object_ref_sink (_tmp9_);
	_tmp10_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_data1_->main_box = g_object_ref_sink (_tmp10_);
	gtk_box_pack_end ((GtkBox*) _data1_->main_box, (GtkWidget*) self->tabbar, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _data1_->main_box);
	_tmp11_ = gwibber_streams_new ();
	_g_object_unref0 (self->priv->streams_service);
	self->priv->streams_service = _tmp11_;
	_tmp12_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp13_ = gwibber_streams_stream_filter_model (self->priv->streams_service, _tmp12_, "home");
	_tmp14_ = _tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) self->streams_map, "home", _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = home_item_new (self->streams_map);
	home_item = g_object_ref_sink (_tmp15_);
	_tmp16_ = tab_bar_item_get_view ((TabBarItem*) home_item);
	_g_object_unref0 (self->view);
	self->view = GWIBBER_GTK_STREAM_VIEW (_tmp16_);
	tab_bar_add_item (self->tabbar, (TabBarItem*) home_item);
	gee_abstract_map_set ((GeeAbstractMap*) self->items_map, "home", (TabBarItem*) home_item);
	_tmp17_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp18_ = gwibber_streams_stream_filter_model (self->priv->streams_service, _tmp17_, "messages");
	_tmp19_ = _tmp18_;
	gee_abstract_map_set ((GeeAbstractMap*) self->streams_map, "messages", _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp21_ = gwibber_streams_stream_filter_model (self->priv->streams_service, _tmp20_, "replies");
	_tmp22_ = _tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) self->streams_map, "replies", _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp24_ = gwibber_streams_stream_filter_model (self->priv->streams_service, _tmp23_, "private");
	_tmp25_ = _tmp24_;
	gee_abstract_map_set ((GeeAbstractMap*) self->streams_map, "private", _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp27_ = gwibber_streams_stream_filter_model (self->priv->streams_service, _tmp26_, "images");
	_tmp28_ = _tmp27_;
	gee_abstract_map_set ((GeeAbstractMap*) self->streams_map, "images", _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp30_ = gwibber_streams_stream_filter_model (self->priv->streams_service, _tmp29_, "videos");
	_tmp31_ = _tmp30_;
	gee_abstract_map_set ((GeeAbstractMap*) self->streams_map, "videos", _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp33_ = gwibber_streams_stream_filter_model (self->priv->streams_service, _tmp32_, "links");
	_tmp34_ = _tmp33_;
	gee_abstract_map_set ((GeeAbstractMap*) self->streams_map, "links", _tmp34_);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp36_ = gwibber_streams_stream_filter_model (self->priv->streams_service, _tmp35_, "public");
	_tmp37_ = _tmp36_;
	gee_abstract_map_set ((GeeAbstractMap*) self->streams_map, "public", _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = messages_item_new (self->streams_map);
	messages_item = g_object_ref_sink (_tmp38_);
	tab_bar_add_item (self->tabbar, (TabBarItem*) messages_item);
	gee_abstract_map_set ((GeeAbstractMap*) self->items_map, "messages", (TabBarItem*) messages_item);
	_tmp39_ = replies_item_new (self->streams_map);
	replies_item = g_object_ref_sink (_tmp39_);
	tab_bar_add_item (self->tabbar, (TabBarItem*) replies_item);
	gee_abstract_map_set ((GeeAbstractMap*) self->items_map, "replies", (TabBarItem*) replies_item);
	_tmp40_ = private_item_new (self->streams_map);
	private_item = g_object_ref_sink (_tmp40_);
	tab_bar_add_item (self->tabbar, (TabBarItem*) private_item);
	gee_abstract_map_set ((GeeAbstractMap*) self->items_map, "private", (TabBarItem*) private_item);
	_tmp41_ = public_item_new (self->streams_map);
	public_item = g_object_ref_sink (_tmp41_);
	tab_bar_add_item (self->tabbar, (TabBarItem*) public_item);
	gee_abstract_map_set ((GeeAbstractMap*) self->items_map, "public", (TabBarItem*) public_item);
	_tmp42_ = attachments_item_new (self->streams_map);
	attach_item = g_object_ref_sink (_tmp42_);
	tab_bar_add_item (self->tabbar, (TabBarItem*) attach_item);
	gee_abstract_map_set ((GeeAbstractMap*) self->items_map, "attach", (TabBarItem*) attach_item);
	_tmp43_ = searches_item_new (self->priv->streams_service);
	_data1_->searches_item = g_object_ref_sink (_tmp43_);
	_tmp44_ = _data1_->searches_item;
	tab_bar_add_item (self->tabbar, IS_TAB_BAR_ITEM (_tmp44_) ? ((TabBarItem*) _tmp44_) : NULL);
	gee_abstract_map_set ((GeeAbstractMap*) self->items_map, "searches", (TabBarItem*) _data1_->searches_item);
	g_signal_connect_data (_data1_->searches_item, "raise", (GCallback) __lambda33__searches_item_raise, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp45_ = users_item_new (self->priv->streams_service);
	_data1_->users_item = g_object_ref_sink (_tmp45_);
	_tmp46_ = _data1_->users_item;
	tab_bar_add_item (self->tabbar, IS_TAB_BAR_ITEM (_tmp46_) ? ((TabBarItem*) _tmp46_) : NULL);
	gee_abstract_map_set ((GeeAbstractMap*) self->items_map, "users", (TabBarItem*) _data1_->users_item);
	g_signal_connect_data (_data1_->users_item, "raise", (GCallback) __lambda54__users_item_raise, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_object ((GObject*) self->view, "notify::prepared", (GCallback) __lambda55__g_object_notify, self, 0);
	g_signal_connect_object (self->priv->state_settings, "changed", (GCallback) __lambda56__g_settings_changed, self, 0);
	gtk_button_clicked ((GtkButton*) home_item);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda57__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_g_object_unref0 (attach_item);
	_g_object_unref0 (public_item);
	_g_object_unref0 (private_item);
	_g_object_unref0 (replies_item);
	_g_object_unref0 (messages_item);
	_g_object_unref0 (home_item);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}


static void client_class_init (ClientClass * klass) {
	client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_client_set_property;
	G_OBJECT_CLASS (klass)->constructor = client_constructor;
	G_OBJECT_CLASS (klass)->finalize = client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLIENT_SORT_ORDER, g_param_spec_int ("sort-order", "sort-order", "sort-order", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void client_instance_init (Client * self) {
	self->priv = CLIENT_GET_PRIVATE (self);
	self->priv->_sort_order = 1;
}


static void client_finalize (GObject* obj) {
	Client * self;
	self = CLIENT (obj);
	_g_object_unref0 (self->priv->streams_service);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->spinner_align);
	_g_object_unref0 (self->priv->state_settings);
	_g_object_unref0 (self->streams_map);
	_g_object_unref0 (self->items_map);
	_g_object_unref0 (self->tabbar);
	_g_object_unref0 (self->view);
	_g_object_unref0 (self->manager);
	G_OBJECT_CLASS (client_parent_class)->finalize (obj);
}


GType client_get_type (void) {
	static volatile gsize client_type_id__volatile = 0;
	if (g_once_init_enter (&client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Client), 0, (GInstanceInitFunc) client_instance_init, NULL };
		GType client_type_id;
		client_type_id = g_type_register_static (GTK_TYPE_WINDOW, "Client", &g_define_type_info, 0);
		g_once_init_leave (&client_type_id__volatile, client_type_id);
	}
	return client_type_id__volatile;
}


static void _vala_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Client * self;
	self = CLIENT (object);
	switch (property_id) {
		case CLIENT_SORT_ORDER:
		g_value_set_int (value, client_get_sort_order (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Client * self;
	self = CLIENT (object);
	switch (property_id) {
		case CLIENT_SORT_ORDER:
		client_set_sort_order (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Main* main_construct (GType object_type, const gchar* app_id, GApplicationFlags flags) {
	Main * self = NULL;
	g_return_val_if_fail (app_id != NULL, NULL);
	self = (Main*) g_object_new (object_type, "application-id", app_id, "flags", flags, NULL);
	return self;
}


Main* main_new (const gchar* app_id, GApplicationFlags flags) {
	return main_construct (TYPE_MAIN, app_id, flags);
}


static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	gtk_main_quit ();
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void main_on_activate (Main* self) {
	GList* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (_tmp0_ != NULL) {
		gtk_window_present ((GtkWindow*) main_main_window);
	} else {
		Client* _tmp1_ = NULL;
		GtkIconTheme* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GwibberAccounts* _tmp5_ = NULL;
		GwibberAccounts* accounts_service;
		GList* _tmp6_ = NULL;
		GList* accounts_list;
		guint _tmp7_;
		_tmp1_ = client_new ();
		_g_object_unref0 (main_main_window);
		main_main_window = g_object_ref_sink (_tmp1_);
		g_set_application_name (PACKAGE);
		_tmp2_ = gtk_icon_theme_get_default ();
		_tmp3_ = g_build_filename (PKGDATADIR, "ui/icons", NULL);
		_tmp4_ = _tmp3_;
		gtk_icon_theme_append_search_path (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		gtk_window_set_application ((GtkWindow*) main_main_window, (GtkApplication*) self);
		gtk_widget_show_all ((GtkWidget*) main_main_window);
		g_signal_connect ((GtkWidget*) main_main_window, "destroy", (GCallback) _gtk_main_quit_gtk_widget_destroy, NULL);
		_tmp5_ = gwibber_accounts_new ();
		accounts_service = _tmp5_;
		_tmp6_ = gwibber_accounts_list (accounts_service);
		accounts_list = _tmp6_;
		_tmp7_ = g_list_length (accounts_list);
		if (_tmp7_ == 0) {
			GPid pid = 0;
			gchar* _tmp8_;
			gchar** _tmp9_ = NULL;
			gchar** _tmp10_;
			gint _tmp10__length1;
			GPid _tmp11_;
			_tmp8_ = g_strdup ("gwibber-accounts");
			_tmp9_ = g_new0 (gchar*, 1 + 1);
			_tmp9_[0] = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp10__length1 = 1;
			g_spawn_async (NULL, _tmp10_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp11_, &_inner_error_);
			pid = _tmp11_;
			_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			goto __finally3;
			__catch3_g_error:
			{
				g_clear_error (&_inner_error_);
				_inner_error_ = NULL;
			}
			__finally3:
			if (_inner_error_ != NULL) {
				__g_list_free__g_object_unref0_0 (accounts_list);
				_g_object_unref0 (accounts_service);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		__g_list_free__g_object_unref0_0 (accounts_list);
		_g_object_unref0 (accounts_service);
	}
}


gint main_on_command_line (Main* self, GApplicationCommandLine* command_line) {
	gint result = 0;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar** arguments;
	gint arguments_length1;
	gint _arguments_size_;
	const gchar* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionContext* context;
	GeeHashMap* _tmp4_;
	GeeHashMap* items_map;
	gint _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp1_ = g_application_command_line_get_arguments (command_line, &_tmp0_);
	args = _tmp1_;
	args_length1 = _tmp0_;
	_args_size_ = _tmp0_;
	arguments = args;
	arguments_length1 = args_length1;
	_arguments_size_ = args_length1;
	_tmp2_ = _ ("— Gwibber Client");
	_tmp3_ = g_option_context_new (_tmp2_);
	context = _tmp3_;
	g_option_context_set_help_enabled (context, FALSE);
	g_option_context_add_main_entries (context, MAIN_options, GETTEXT_PACKAGE);
	g_option_context_parse (context, &arguments_length1, &arguments, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch4_g_option_error;
		}
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_g_option_context_free0 (context);
	goto __finally4;
	__catch4_g_option_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_application_command_line_set_exit_status (command_line, 1);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_application_activate ((GApplication*) self);
	_tmp4_ = _g_object_ref0 (main_main_window->items_map);
	items_map = _tmp4_;
	if (main_stream != NULL) {
		gboolean _tmp5_ = FALSE;
		if (IS_TAB_BAR (main_main_window->tabbar)) {
			gpointer _tmp6_ = NULL;
			TabBarItem* _tmp7_;
			_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) items_map, main_stream);
			_tmp7_ = (TabBarItem*) _tmp6_;
			_tmp5_ = IS_TAB_BAR_ITEM (_tmp7_);
			_g_object_unref0 (_tmp7_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gpointer _tmp8_ = NULL;
			TabBarItem* _tmp9_;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) items_map, main_stream);
			_tmp9_ = (TabBarItem*) _tmp8_;
			tab_bar_on_tab_clicked (main_main_window->tabbar, (GtkButton*) _tmp9_);
			_g_object_unref0 (_tmp9_);
		}
	}
	g_application_command_line_set_exit_status (command_line, 0);
	_tmp10_ = g_application_command_line_get_exit_status (command_line);
	result = _tmp10_;
	_g_object_unref0 (items_map);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void main_class_init (MainClass * klass) {
	main_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = main_finalize;
}


static void main_instance_init (Main * self) {
}


static void main_finalize (GObject* obj) {
	Main * self;
	self = MAIN (obj);
	G_OBJECT_CLASS (main_parent_class)->finalize (obj);
}


GType main_get_type (void) {
	static volatile gsize main_type_id__volatile = 0;
	if (g_once_init_enter (&main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Main), 0, (GInstanceInitFunc) main_instance_init, NULL };
		GType main_type_id;
		main_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Main", &g_define_type_info, 0);
		g_once_init_leave (&main_type_id__volatile, main_type_id);
	}
	return main_type_id__volatile;
}


static void _main_on_activate_g_application_activate (GApplication* _sender, gpointer self) {
	main_on_activate (self);
}


static gint _main_on_command_line_g_application_command_line (GApplication* _sender, GApplicationCommandLine* command_line, gpointer self) {
	gint result;
	result = main_on_command_line (self, command_line);
	return result;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Main* _tmp0_ = NULL;
	Main* app;
	gint _tmp1_;
	gint _result_;
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = main_new ("org.gwibber.client", G_APPLICATION_HANDLES_COMMAND_LINE);
	app = _tmp0_;
	g_signal_connect_object ((GApplication*) app, "activate", (GCallback) _main_on_activate_g_application_activate, app, 0);
	g_signal_connect_object ((GApplication*) app, "command-line", (GCallback) _main_on_command_line_g_application_command_line, app, 0);
	_tmp1_ = g_application_run ((GApplication*) app, args_length1, args);
	_result_ = _tmp1_;
	result = _result_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



