import log
import os, subprocess

class GwibberError(Exception):
    """Base class for exceptions in gwibber."""
    pass

class GwibberProtocolError(GwibberError):
    """Exception raised for errors from protocols.

    Attributes:
        protocol
        username
        message
        type
    """
    def __init__(self, type="UNKNOWN", protocol="UNKNOWN", username="UNKNOWN", message="UNKNOWN"):
        if type == "keyring":
            log.logger.error("Failed to find credentials in the keyring")
        else:
            log.logger.error("%s failure: %s:%s - %s", type, protocol, username, message)
        display_message = "There was an %s failure from %s for account %s, error was %s" % (type, protocol, username, message)
        title = "Gwibber"
        level = "info"
        if type == "auth":
            display_message = "Authentication error from %s for account %s" % (protocol, username)
            title = "Gwibber Authentication Error"
            level = "error"
        if type == "network":
            display_message = "There was a network error communicating with %s" % message
            title = "Gwibber Network Error"
            level = "error"

        if os.path.exists(os.path.join("bin", "gwibber-error")):
            cmd = os.path.join("bin", "gwibber-error")
        else:
            cmd = "gwibber-error"
        ret = subprocess.Popen([cmd, '-m', display_message, '-t', title, '-c', level, '-p', protocol, '-u', username, '-e', type], shell=False)
