#include <glib-object.h>

#include "common.h"

#include <gmyth/gmyth_uri.h>
#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_file.h>
#include <gmyth/gmyth_file_transfer.h>
#include <gmyth/gmyth_file_local.h>
#include <gmyth/gmyth_common.h>

#define URI_FILE_TRANSFER_DEFAULT	"myth://192.168.3.165:6543/"

static          gboolean
test_file_download_setup(gchar * uri)
{
    GMythFile      *file = NULL;
    GMythFileReadResult result;
    gint64          num_bytes;
    GByteArray     *file_buffer = g_byte_array_new();
    gboolean        ret = TRUE;
    gboolean        is_local = FALSE;

    if (NULL == uri)
        uri = g_strdup(URI_FILE_TRANSFER_DEFAULT);

    GMythURI       *gmyth_uri = gmyth_uri_new_with_value(uri);

    GMythBackendInfo *backend_info = gmyth_backend_info_new_with_uri(uri);

    /*
     * Check if the file is local to this specific client renderer, and
     * tries to open a local connection 
     */
    if (gmyth_uri_is_local_file(gmyth_uri)) {
        g_debug("Opening local file connection to download...");
        file = GMYTH_FILE(gmyth_file_local_new(backend_info));
        ret = gmyth_file_local_open(GMYTH_FILE_LOCAL(file));
    } else {
        g_debug("Opening remote file connection to download...");
        file = GMYTH_FILE(gmyth_file_transfer_new(backend_info));
        ret = gmyth_file_transfer_open(GMYTH_FILE_TRANSFER(file), uri);
    }

    if (NULL == file) {
        g_debug("FileTransfer is NULL");
        ret = FALSE;
        goto init_failed;
    }

    g_debug("uri = %s", uri);

    if (ret == FALSE) {
        g_debug
            ("MythTV FileTransfer request failed when setting up socket connection!");
        goto init_failed;
    }

    g_debug("MythTV FileTransfer filesize = %lld",
            num_bytes = gmyth_file_get_filesize(file));

    is_local = gmyth_uri_is_local_file(gmyth_uri);

    do {

        if (is_local)
            result = gmyth_file_local_read(GMYTH_FILE_LOCAL(file),
                                           file_buffer, num_bytes, FALSE);
        else
            result = gmyth_file_transfer_read(GMYTH_FILE_TRANSFER(file),
                                              file_buffer, num_bytes,
                                              FALSE);

    }
    while (result == GMYTH_FILE_READ_OK);

  init_failed:

    if (file != NULL)
        g_object_unref(file);

    if (gmyth_uri != NULL)
        g_object_unref(gmyth_uri);

    if (backend_info != NULL)
        g_object_unref(backend_info);

    return ret;

}

gint
main(gint args, const gchar ** argv)
{
    gboolean        ret = FALSE;

    g_type_init();

    g_thread_init(NULL);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    if (args > 1)
        ret = test_file_download_setup(argv[1]);

    if (!ret)
        g_debug("Error when running LiveTV setup test script!");
    else
        g_debug("LiveTV setup test script finished with success.");

    return (0);
}
