/**
 * GMyth Library
 *
 * @file gmyth/gmyth_remote_util.h
 * 
 * @brief <p> This component provides utility functions for accessing remote data.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Hallyson Luiz de Morais Melo <hallyson.melo@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __REMOTE_UTIL_H__
#define __REMOTE_UTIL_H__

#include <glib.h>
#include "gmyth_recorder.h"
#include "gmyth_socket.h"

G_BEGIN_DECLS
    GMythRecorder * remote_request_next_free_recorder(GMythSocket * socket,
                                                      gint curr);
gint            gmyth_remote_util_get_free_recorder_count(GMythSocket *
                                                          socket);

G_END_DECLS
#endif
