/**
 * GMyth Library
 *
 * @file gmyth/gmyth_jobqueue.h
 *
 * @brief <p> Library to use JobQueue from mythbackend
 *
 * Copyright (C) 2007 INdT - Instituto Nokia de Tecnologia.
 * @author Artur Duque de Souza <artur.souza@indt.org.br>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_JOBQUEUE_H__
#define __GMYTH_JOBQUEUE_H__

#include <glib-object.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <glib.h>
#include <glib/gprintf.h>

#include "gmyth_stringlist.h"
#include "gmyth_backendinfo.h"
#include "gmyth_transcoder.h"
#include "gmyth_socket.h"
#include "gmyth_util.h"

G_BEGIN_DECLS
    gboolean gmyth_jobqueue_add_job(GMythTranscoder * transcoder,
                                    gchar * job);
gboolean        gmyth_jobqueue_change_cmd(GMythTranscoder * transcoder,
                                          gchar * action, gchar * job);

G_END_DECLS
#endif                          /* __GMYTH_JOBQUEUE_H__ */
