# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core import common
from pgm.timing import implicit

plugin_registry = common.application.plugin_registry
PigmentTransition = plugin_registry.get_component_class('pigment:pigment_transition')

class PlayerOutTransition(PigmentTransition):

    def apply(self, view, end_callback=None):
        PigmentTransition.apply(self, view, end_callback=end_callback)
        canvas = view.frontend.context.viewport_handle.get_canvas()

        params = {"duration": 500,
                  "transformation": implicit.DECELERATE,
                  "end_callback": lambda x: self.stop()}
        self.implicit.setup_next_animations(**params)
        
        position = (canvas.width *0.7, canvas.height * 0.7, 20)
        size = (canvas.width * 0.2, canvas.height * 0.2)
        
        self.implicit.opacity = 30
        self.implicit.position = position
        self.implicit.size = size

class PlayerInTransition(PigmentTransition):
    
    def apply(self, view, end_callback=None):
        PigmentTransition.apply(self, view, end_callback=end_callback)
        canvas = view.frontend.context.viewport_handle.get_canvas()

        params = {"duration": 500,
                  "transformation": implicit.DECELERATE,
                  "end_callback": lambda x: self.stop()}
        self.implicit.setup_next_animations(**params)

        self.implicit.opacity = 255
        self.implicit.position = (0, 0, 0)
        self.implicit.size = (canvas.width, canvas.height)


class UnfocusTransition(PigmentTransition):

    def apply(self, view, end_callback=None):
        PigmentTransition.apply(self, view, end_callback)

        params = {"duration": 500,
                  "transformation": implicit.DECELERATE,
                  "end_callback": lambda x: self.stop()}
        self.implicit.setup_next_animations(**params)

        self.implicit.opacity = 50

class FocusTransition(PigmentTransition):

    def apply(self, view, end_callback=None):
        PigmentTransition.apply(self, view, end_callback)

        params = {"duration": 500,
                  "transformation": implicit.DECELERATE,
                  "end_callback": lambda x: self.stop()}
        self.implicit.setup_next_animations(**params)

        self.implicit.opacity = 255
