%define _missing_doc_files_terminate_build 0

%{!?_rel:%{expand:%%global _rel 0.r%(svnversion | sed 's/[^0-9].*$//' || echo 0000)}}

Summary: Complex Graphical Design/Layout Engine
Name: edje
Version: 0.9.99.49898
Release: %{_rel}
License: BSD
Group: System Environment/Libraries
URL: http://www.enlightenment.org/
Source: ftp://ftp.enlightenment.org/pub/evoak/%{name}-%{version}.tar.gz
Packager: %{?_packager:%{_packager}}%{!?_packager:Michael Jennings <mej@eterm.org>}
Vendor: %{?_vendorinfo:%{_vendorinfo}}%{!?_vendorinfo:The Enlightenment Project (http://www.enlightenment.org/)}
Distribution: %{?_distribution:%{_distribution}}%{!?_distribution:%{_vendor}}
#BuildSuggests: xorg-x11-devel, vim-enhanced
BuildRequires: eet-devel, embryo-devel, evas-devel, ecore-devel
Requires:  evas-module_loader_eet
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
Edje is a complex graphical design and layout engine. It provides a
mechanism for allowing configuration data to define visual elements in
terms of layout, behavior, and appearance.  Edje allows for multiple
collections of layouts in one file, allowing a complete set of images,
animations, and controls to exist as a unified whole.

Edje separates the arrangement, appearance, and behavior logic into
distinct independent entities.  This allows visual objects to share
image data and configuration information without requiring them to do
so.  This separation and simplistic event driven style of programming
can produce almost any look and feel one could want for basic visual
elements. Anything more complex is likely the domain of an application
or widget set that may use Edje as a conveneient way of being able to
configure parts of the display.

%package devel
Summary: Edje headers, static libraries, documentation and test programs
Group: System Environment/Libraries
Requires: %{name} = %{version}, %{name}-bin = %{version}
Requires: eet-devel embryo-devel evas-devel ecore-devel

%description devel
Headers, static libraries, test programs and documentation for Edje

%package bin
Summary: Edje file compiler/decompiler suite
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: embryo-bin
Requires: evas-module_saver_eet, evas-module_loader_png, evas-module_saver_png
Requires: evas-module_loader_jpeg, evas-module_saver_jpeg, evas-module_engine_buffer

%description bin
Edje file compiler/decompiler suite

%prep
%setup -q

%build
%{configure} --prefix=%{_prefix}
%{__make} %{?_smp_mflags} %{?mflags}

%install
%{__make} %{?mflags_install} DESTDIR=$RPM_BUILD_ROOT install
test -x `which doxygen` && sh gendoc || :

%post
/sbin/ldconfig || :

%postun
/sbin/ldconfig || :

%clean
test "x$RPM_BUILD_ROOT" != "x/" && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING README
%{_libdir}/libedje*.so.*

%files devel
%defattr(-, root, root)
%doc doc/html
%{_libdir}/*.so
%{_libdir}/*.la
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/*.h

%files bin
%defattr(-, root, root)
%{_bindir}/edje_cc
%{_bindir}/edje_decc
%{_bindir}/edje_recc
%{_bindir}/edje_player
%{_bindir}/inkscape2edc
%{_datadir}/edje/include/edje.inc
%{_datadir}/mime/packages/edje.xml

%changelog
