# Apport integration for Desktop CouchDB
#
# Copyright 2009-2010 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Stub for Apport"""
# pylint: disable=F0401,C0103
# shut up about apport. We know. We aren't going to backport it for pqm
import apport
from apport.hookutils import attach_file_if_exists, packaging
import os.path
from xdg.BaseDirectory import xdg_cache_home, xdg_config_home

# Paths where things we might want live
dc_log_path = os.path.join(xdg_cache_home, "desktop-couch", "log")
dc_user_config_path = os.path.join(xdg_config_home, "desktop-couch")
# things we may want to collect for the report
dc_replication_log = os.path.join(dc_log_path, \
                                "desktop-couch-replication.log")
dc_user_conf = os.path.join(dc_user_config_path, "desktop-couchdb.ini")


def add_info(report):
    """add report info"""
    attach_file_if_exists(report, dc_replication_log)
    attach_file_if_exists(report, dc_user_conf)

    if not apport.packaging.is_distro_package(report['Package'].split()[0]):
        report['ThirdParty'] = 'True'
        report['CrashDB'] = 'desktopcouch'

    packages = ['desktopcouch']

    versions = ''
    for package in packages:
        try:
            version = packaging.get_version(package)
        except ValueError:
            version = 'N/A'
        if version is None:
            version = 'N/A'
        versions += '%s %s\n' % (package, version)
    report['DesktopCouchPackages'] = versions
