#include "scorewizard.h"
#include "utils.h"
#include <glib.h>
#include <string.h>
#include "parseinstruments.h"
#include "staffops.h"
#include <gtk/gtk.h>

/* 	TODO
 *
 * staff creation should provide the correct staff type
 * refresh gtk display after wizard is done.
 * make backbutton shadded when on first page. 
 * do same for next button on last page 
 * clean up code 
 */

instsdata icbdata;
gint num_clicks = 1;
papersetupcb psetup;
static int staffnumber = 0;
headersetupcb hsetup;
//nasty global for test purposes
GtkListStore *score_store;
wizarddata wdata;
GtkWidget *score_list;
GtkWidget *instrument_list;

/**
 * Lilyponds supported font sizes
 */
static gchar *fontsizes[8] =
{
  "11", "13", "14", "16", "18", "20", "23","26"
};

/**
 * Lilyponds supported paper sizes
 */
static gchar *papersizes[6] =
{
  "a4", "a6", "a5", "legal", "letter", "tabloid"
};

/**
 * Textual representation of instrument types
 */
static gchar *instrumenttypes[8] =
{
	"Woodwinds" ,"Brass","Strings","Vocals", "Pitched Percussion","Plucked Strings","Keyboards", "None"
};


/**
 * create a staff with that instrument name
 *
 */

static void create_staff_instruments(gpointer data)
{
  //struct wizarddata *cbdata = (wizarddata *) user_data;
  staff *curstaffstruct = (staff *) wdata.si->currentstaff->data; 
  gchar *instrument = (gchar *)data; 
  
  	strcpy(curstaffstruct->denemo_name->str, instrument);
	set_lily_name (curstaffstruct->denemo_name,curstaffstruct->lily_name);
  	strcpy(curstaffstruct->midi_instrument->str, instrument);
	gtk_widget_draw (wdata.si->scorearea, NULL);
  if (staffnumber-- != 1){	
	wdata.si->currentstaffnum++;
	newstaff (wdata.si, ADDFROMLOAD, DENEMO_NONE);
	wdata.si->currentstaff = g_list_last (wdata.si->thescore);		
  	
	gtk_widget_draw (wdata.si->scorearea, NULL);
  	
  }
  g_free(instrument);
}



/**
 * Add instrument to score view
 *
 *
 */
static void addinstrument(GtkButton *button, wizarddata *data)
{
	
	wdata.sdata->selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(instrument_list));
	GtkTreeIter iter;
	gtk_tree_selection_get_selected(GTK_TREE_SELECTION(data->sdata->selection), (GtkTreeModel **)&data->sdata->list_store, &iter);
	gchar *name;

  	gtk_tree_model_get(GTK_TREE_MODEL(data->sdata->list_store), &iter, 0, &name, -1);
#ifdef DEBUG  
	g_print("Instrument %s \n", name);
#endif
	gtk_list_store_append (data->sdata->score_list, &iter);
	gtk_list_store_set (data->sdata->score_list, &iter,  0, _(name), -1);
}


static void lookup_instrument_properties(gchar *name){
	/*need to have a sting comparison here*/
	GList *instruments = icbdata.instruments;
/* unfortunately this only seems to parse over first instrument category "Woodwinds"*/
 	GList *tmp = instruments;
         
	while(tmp) {
	
		GList *inst = ((InstrumentList *) (tmp)->data)->instruments;
		while (inst) {
			if (!strcmp(((InstrumentConfig *)inst->data)->name->str, name)) {
				//g_print("string comparison returns %i\n", (!strcmp(((InstrumentConfig *)inst->data)->name->str,"Flute")));
				g_print("instrument name inst->data)->name->str = %s\n", ((InstrumentConfig *)inst->data)->name->str);
				g_print("instrument staff inst->data)->sclef = %i\n", (int *) ((InstrumentConfig *)inst->data)->sclef);	
				break;
			}
			inst = g_list_next(inst);
		}
			tmp = g_list_next(tmp);
	}
	
}

static gboolean
  foreach_func (GtkTreeModel *model,
                  GtkTreePath  *path,
                  GtkTreeIter  *iter,
                  gpointer      user_data)
{
	gchar *name;
	gchar *tree_path_str = gtk_tree_path_to_string(path);
	gtk_tree_model_get (model, iter, 0, &name,-1);
	//g_print ("Row %s: %s staff #= %i\n", tree_path_str,name,staffnumber);
	/*call function to lookup instrument by $name and find instruments properties (clef, transposition, etc)
	 * assign value to wdata.scoreinstruments or send directly to create_staff_instruments?
	 * pass values to create_staff_instruments?
	 */

	lookup_instrument_properties(name);
	create_staff_instruments(name);
	return FALSE;
}
/**
 * Remove instrument from score view
 *
 *
 */
static void removeinstrument(GtkButton *button, wizarddata *data)
{
  //scoredata *scored = (scoredata *) data;
	wdata.sdata->selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(score_list));
	GtkTreeIter iter;
	gtk_tree_selection_get_selected(GTK_TREE_SELECTION(data->sdata->selection), (GtkTreeModel **)&data->sdata->score_list, &iter);
	gchar *name;
	gtk_tree_model_get(GTK_TREE_MODEL(data->sdata->score_list), &iter, 0, &name, -1);
#ifdef DEBUG  
	        g_print("Instrument %s \n", name);
#endif
	gtk_list_store_remove((GtkListStore *) data->sdata->score_list, &iter);
}
/**
 * Callback to add the specific instruments to the tree view 
 *
 */
static gboolean
cell_clicked(GtkTreeSelection *selection,
             GtkTreeModel     *model,
             GtkTreePath      *path,
             gboolean          path_currently_selected,
             gpointer          user_data)
{
	
  	gboolean ret = FALSE;
	g_print("\nIn cell_clicked callback\n");
	instsdata *cbdata = (instsdata *)user_data;
        GList *instruments = icbdata.instruments;	
	GtkTreeIter iter;
	
  
  //get the current selected path  
  if (gtk_tree_model_get_iter(model, &iter, path))
    {
      gchar *name;

      gtk_tree_model_get(model, &iter, 0, &name, -1);
			
      if (!path_currently_selected)
      {	
        gtk_list_store_clear(cbdata->list_store); //clear list store
        //add instruments to the tree views second column
      	InstrumentType type = lookuptype(name);
      	g_print("Name %s,  Type %d\n", name, type);
      	
	//g_print("Entire Instruments List length %d\t", g_list_length((data->instruments)->data)->instruments);
	GList *tmp = instruments;
      
	//g_print("Entire Instruments List length %d\t", g_list_length(instruments));
	
	while (tmp)
        {
		//g_print("Individual List type %i \t ", ((InstrumentList *) tmp->data)->type);
		if (type == ((InstrumentList *) (tmp)->data)->type)
        	{
			GList *inst = ((InstrumentList *) (tmp)->data)->instruments;
			while (inst)
				{  
					gtk_list_store_append (cbdata->list_store, &iter);
					/* get instrument name from InstrumentConfig structure */
					gtk_list_store_set (cbdata->list_store, &iter,  0, _(((InstrumentConfig *)inst->data)->name->str), -1);
				//	g_print("instrument name inst->data)->name->str = %s\n", _(((InstrumentConfig *)inst->data)->name->str) );
				//	g_print("instrument staff inst->data)->sclef = %i\n", (int *) ((InstrumentConfig *)inst->data)->sclef );
					inst = g_list_next(inst);
	  			}
					break;
        	}
        	tmp = g_list_next(tmp);
        }
      }
      g_free(name);
    }
  return ret;
}

/**
 * Debug function to print the elements of the instruments 
 * to the screen
 */
static void printInstruments(GList *instruments)
{
	GList *tmp;
	for(tmp=instruments; tmp; tmp=tmp->next)
	{
		GList *insts;
		//g_print("List type %s \n ", (  ((InstrumentList *) tmp->data)->instruments   )->name->str);
		for(insts = ((InstrumentList *) tmp->data)->instruments; insts; insts=insts->next)
		{
			
			g_print("(printInstrument) Name %s \n ",  ((InstrumentConfig *) insts->data)->name->str);
		}
	}
}

/**
 * Adds page to the notebook for selecting the instruments
 * that will be in the score.
 */
void
instrumentsetup(wizarddata *data)
{
  GtkWidget *list;
  GtkListStore *list_store;
  GtkTreeIter iter;
  GList *tmp;
  static instsdata cbdata;
  //data->instruments = parseInstruments(data->instruments);
  wdata.instruments = parseInstruments(wdata.instruments);
	//printInstruments(icbdata.instruments);
	
	GtkWidget *hbox = gtk_hbox_new(TRUE, 5);
	
		
  list_store = gtk_list_store_new (1, G_TYPE_STRING);	/* label */
  list = gtk_tree_view_new_with_model (GTK_TREE_MODEL (list_store));
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (list),
					       0, "Instrument Type",
					       gtk_cell_renderer_text_new (),
					       "text", 0, NULL);

  /* this populates the first column */
  for(tmp=data->instruments; tmp; tmp=tmp->next)
	{
	  gtk_list_store_append (list_store, &iter);
		gtk_list_store_set (list_store, &iter,
		0, _(instrumenttypes[((InstrumentList *)tmp->data)->type]), -1);
	}		
	gtk_box_pack_start (GTK_BOX (hbox), list, TRUE, TRUE, 0);
		  								    
   
  //Instruments view 
  GtkListStore *instrument_store = gtk_list_store_new (1, G_TYPE_STRING);	/* label */
  //GtkWidget *instrument_list = gtk_tree_view_new_with_model (GTK_TREE_MODEL (instrument_store));
  instrument_list = gtk_tree_view_new_with_model (GTK_TREE_MODEL (instrument_store));
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (instrument_list),
	 0, "Instrument", gtk_cell_renderer_text_new (), "text", 0, NULL);
		
  gtk_box_pack_start (GTK_BOX (hbox), instrument_list, TRUE, TRUE, 0);
  
  cbdata.list_store = instrument_store;
  cbdata.instruments = data->instruments;

  GtkWidget *vbox = gtk_vbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE,0);
  
  GtkWidget *addbutton = gtk_button_new_with_label(">");
  gtk_box_pack_start(GTK_BOX(vbox), addbutton, FALSE, TRUE,0); 
 
  GtkWidget *removebutton = gtk_button_new_with_label("<");
  gtk_box_pack_start(GTK_BOX(vbox), removebutton, FALSE, TRUE,0);
 
  
  score_store =  gtk_list_store_new (1, G_TYPE_STRING);
  //GtkWidget *score_list =  gtk_tree_view_new_with_model (GTK_TREE_MODEL (score_store));
  score_list =  gtk_tree_view_new_with_model (GTK_TREE_MODEL (score_store));
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (score_list),
	 0, "Score", gtk_cell_renderer_text_new (), "text", 0, NULL);
  
  gtk_box_pack_start (GTK_BOX (hbox), score_list, TRUE, TRUE, 0);
  

  wdata.sdata = (scoredata *)g_malloc0(sizeof(scoredata));
  wdata.sdata->selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(instrument_list));
  wdata.sdata->list_store = &instrument_store;
  wdata.sdata->score_list = score_store;
   
  g_signal_connect(G_OBJECT(addbutton), "clicked", G_CALLBACK(addinstrument), (gpointer) &wdata); //add button callback
  g_signal_connect(G_OBJECT(removebutton), "clicked", G_CALLBACK(removeinstrument), (gpointer) &wdata); //remove button callback
  GtkTreeSelection  *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(list));
  gtk_tree_selection_set_select_function(selection, cell_clicked, (gpointer) &cbdata, NULL);
	gtk_notebook_append_page (GTK_NOTEBOOK (data->notebook), hbox, NULL);
	gtk_notebook_set_tab_label_text (GTK_NOTEBOOK (data->notebook), hbox,  _("Instrument Setup"));
}

/**
 * Creates a page to setup the printed scores properties
 * @param notebook widget to attach the table to either GtkNotebook or Dialog->vbox
 * @param si pointer to the scoreinfo structure to get current information
 * @param isnotebook specifies if the widget passed is a notebook. Default is TRUE
 * @return the new paper setup 
 */
papersetupcb *
papersetup(GtkWidget *notebook, scoreinfo *si, gboolean isnotebook)
{
	gint i;
	
  	papersetupcb *setup = (papersetupcb *) g_malloc0(sizeof(papersetupcb));
	GtkWidget *table = gtk_table_new(3, 3 , FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 12);
  	gtk_table_set_row_spacings (GTK_TABLE (table), 8);
  	gtk_table_set_col_spacings (GTK_TABLE (table), 8);
  
	GtkWidget *label = gtk_label_new(_("Paper Size"));
	gtk_table_attach(GTK_TABLE(table), label, 0, 1,0 ,1,
									 (GtkAttachOptions) (GTK_FILL),
		    					 (GtkAttachOptions) (0), 0, 0);
	GtkWidget *papersize = gtk_combo_box_entry_new_text();
	for(i=0; i < 6; i++)
	{
		gtk_combo_box_append_text(GTK_COMBO_BOX(papersize), papersizes[i]);
	}
  
	gtk_entry_set_text(GTK_ENTRY(GTK_BIN(papersize)->child), papersizes[0]);
	gtk_table_attach(GTK_TABLE(table), papersize,1,2,0,1,
									(GtkAttachOptions) (GTK_FILL),
		    					 (GtkAttachOptions) (0), 0, 0);

  
	label = gtk_label_new(_("Font Size"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,1,2,
									(GtkAttachOptions) (GTK_FILL),
		    					(GtkAttachOptions) (0), 0, 0);
	GtkWidget *fontsize = gtk_combo_box_entry_new_text();
	for(i=0; i < 8; i++) 
	{
	 	gtk_combo_box_append_text(GTK_COMBO_BOX(fontsize), fontsizes[i]);
	}
	gtk_entry_set_text (GTK_ENTRY (GTK_BIN(fontsize)->child), fontsizes[0]);
	gtk_table_attach(GTK_TABLE(table), fontsize, 1,2,1,2,
									(GtkAttachOptions) (GTK_FILL),
		    					(GtkAttachOptions) (0), 0, 0);
	
		
	label = gtk_label_new(_("Lilypond Version"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,2,3,
									(GtkAttachOptions) (GTK_FILL),
		    					 (GtkAttachOptions) (0), 0, 0);
	
	GtkWidget *lilyversion = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), lilyversion, 1,2,2,3,
									(GtkAttachOptions) (GTK_FILL),
		    					 (GtkAttachOptions) (0), 0, 0);
	
	

	GtkWidget *vbox = gtk_vbox_new(FALSE,0);
  	GtkWidget *portraitradio = gtk_radio_button_new_with_label(NULL, _("Portrait"));
  	gtk_box_pack_start(GTK_BOX(vbox), portraitradio, TRUE, TRUE,0);
  
  	GtkWidget *landscaperadio = gtk_radio_button_new_with_label(
  	gtk_radio_button_group (GTK_RADIO_BUTTON (portraitradio)),_("Landscape"));
	gtk_box_pack_start(GTK_BOX(vbox), landscaperadio, TRUE, TRUE,0);
	
	gtk_table_attach(GTK_TABLE(table), vbox, 2,3,0,1,
				 (GtkAttachOptions) (GTK_FILL),
   					 (GtkAttachOptions) (0), 0, 0);
	
	 if(isnotebook)
	 {
	 	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), table, NULL);
	 	gtk_notebook_set_tab_label_text (GTK_NOTEBOOK (notebook), table,
							   _("Paper Setup"));
	 }
	 else
	 {
	 	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(notebook)->vbox), table, TRUE, TRUE,0);
	 }
																   
   	setup->papersize = papersize;
   	setup->fontsize = fontsize;																   
	setup->portrait = portraitradio;
	setup->lilyversion = lilyversion;
	 
	return setup;	
}

void
new_papersetup(GtkWidget *notebook, scoreinfo *si, gboolean isnotebook)
{
	gint i;
 	GtkWidget *table, *label, *papersize,*fontsize,*lilyversion, *vbox, *portraitradio, *landscaperadio;
	
	table = gtk_table_new(3, 3 , FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 12);
  	
	gtk_table_set_row_spacings (GTK_TABLE (table), 8);
  	gtk_table_set_col_spacings (GTK_TABLE (table), 8);
  
	label = gtk_label_new(_("Paper Size"));
	gtk_table_attach(GTK_TABLE(table), label, 0, 1,0 ,1,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	papersize = gtk_combo_box_entry_new_text();
	for(i=0; i < 6; i++)
	{
		gtk_combo_box_append_text(GTK_COMBO_BOX(papersize), papersizes[i]);
	}
  
	gtk_entry_set_text(GTK_ENTRY(GTK_BIN(papersize)->child), papersizes[0]);
	gtk_table_attach(GTK_TABLE(table), papersize,1,2,0,1,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	label = gtk_label_new(_("Font Size"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,1,2,
			(GtkAttachOptions) (GTK_FILL),
			(GtkAttachOptions) (0), 0, 0);
	fontsize = gtk_combo_box_entry_new_text();
	for(i=0; i < 8; i++) 
	{
	 	gtk_combo_box_append_text(GTK_COMBO_BOX(fontsize), fontsizes[i]);
	}
	gtk_entry_set_text (GTK_ENTRY (GTK_BIN(fontsize)->child), fontsizes[0]);
	gtk_table_attach(GTK_TABLE(table), fontsize, 1,2,1,2,
			(GtkAttachOptions) (GTK_FILL),
			(GtkAttachOptions) (0), 0, 0);
			
	label = gtk_label_new(_("Lilypond Version"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,2,3,
			(GtkAttachOptions) (GTK_FILL),
  			 (GtkAttachOptions) (0), 0, 0);
	
	lilyversion = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), lilyversion, 1,2,2,3,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	
	vbox = gtk_vbox_new(FALSE,0);
  	portraitradio = gtk_radio_button_new_with_label(NULL, _("Portrait"));
  	gtk_box_pack_start(GTK_BOX(vbox), portraitradio, TRUE, TRUE,0);
  
  	landscaperadio = gtk_radio_button_new_with_label(
  	gtk_radio_button_group (GTK_RADIO_BUTTON (portraitradio)),_("Landscape"));
	gtk_box_pack_start(GTK_BOX(vbox), landscaperadio, TRUE, TRUE,0);
	
	gtk_table_attach(GTK_TABLE(table), vbox, 2,3,0,1,
				 (GtkAttachOptions) (GTK_FILL),
   				 (GtkAttachOptions) (0), 0, 0);
	 if(isnotebook)
	 {
	 	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), table, NULL);
	 	gtk_notebook_set_tab_label_text (GTK_NOTEBOOK (notebook), table,
							   _("Paper Setup"));
	 }
	 else
	 {
	 	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(notebook)->vbox), table, TRUE, TRUE,0);
	 }															   
   	psetup.papersize = papersize;
   	psetup.fontsize = fontsize;								
	psetup.portrait = portraitradio;
	psetup.lilyversion = lilyversion;	 	

}

void 
applyheader_settings(scoreinfo *si){

	g_string_assign(si->headerinfo->title, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.title)));	
	g_string_assign(si->headerinfo->subtitle, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.subtitle)));	
	g_string_assign(si->headerinfo->poet, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.poet)));	
	g_string_assign(si->headerinfo->composer, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.composer)));	
	g_string_assign(si->headerinfo->meter, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.meter)));	
	g_string_assign(si->headerinfo->opus, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.opus)));	
	g_string_assign(si->headerinfo->arranger, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.arranger)));	
	g_string_assign(si->headerinfo->instrument, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.instrument)));
	g_string_assign(si->headerinfo->dedication, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.dedication)));
	g_string_assign(si->headerinfo->piece, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.piece)));	
	g_string_assign(si->headerinfo->head, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.head)));	
	g_string_assign(si->headerinfo->copyright, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.copyright)));	
	g_string_assign(si->headerinfo->footer, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.footer)));	
	g_string_assign(si->headerinfo->tagline, (gchar *) gtk_entry_get_text (GTK_ENTRY (hsetup.tagline)));	
	
}

void * 
headersetup(GtkWidget *notebook, scoreinfo *si, gboolean isnotebook)
{
	
	GtkWidget *label,*table, *title,*subtitle,*poet,*composer,*meter, *opus, *arranger,*instrument, *dedication, *piece, *head, *copyright, *footer, *tagline;
  	
	table = gtk_table_new(3, 3 , FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 12);
  	
	gtk_table_set_row_spacings (GTK_TABLE (table), 0);
  	gtk_table_set_col_spacings (GTK_TABLE (table), 8);
	
	/** title **/ 
  	label = gtk_label_new(_("Title"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,1,2,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	title = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), title, 1,2,1,2,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	/** subtitle **/
	label = gtk_label_new(_("Subtitle"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,2,3,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	subtitle = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), subtitle, 1,2,2,3,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	
	/** Poet **/
	label = gtk_label_new(_("Poet"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,3,4,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	poet = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), poet, 1,2,3,4,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	/** Composer **/
	label = gtk_label_new(_("Composer"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,4,5,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	composer = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), composer, 1,2,4,5,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	/** Meter **/
	label = gtk_label_new(_("Meter"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,5,6,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	meter = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), meter, 1,2,5,6,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	/** Opus **/
	label = gtk_label_new(_("Opus"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,6,7,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	opus = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), opus, 1,2,6,7,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	/** Arranger **/
	label = gtk_label_new(_("Arranger"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,7,8,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	arranger = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), arranger, 1,2,7,8,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	/** Instrument **/
	label = gtk_label_new(_("Instrument"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,8,9,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	instrument = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), instrument, 1,2,8,9,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	/** Dedication **/
	label = gtk_label_new(_("Dedication"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,9,10,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	dedication = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), dedication, 1,2,9,10,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	
	/** Piece **/
	label = gtk_label_new(_("Piece"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,10,11,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	piece = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), piece, 1,2,10,11,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	/** Head **/
	label = gtk_label_new(_("Head"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,11,12,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	head = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), head, 1,2,11,12,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	/** Copyright **/
	label = gtk_label_new(_("Copyright"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,12,13,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	copyright = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), copyright, 1,2,12,13,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	/** Footer **/
	label = gtk_label_new(_("Footer"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,13,14,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	footer = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), footer, 1,2,13,14,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	/** Tagline **/
	label = gtk_label_new(_("Tagline"));
	gtk_table_attach(GTK_TABLE(table), label, 0,1,14,15,
				(GtkAttachOptions) (GTK_FILL),
				 (GtkAttachOptions) (0), 0, 0);
	
	tagline = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), tagline, 1,2,14,15,
			(GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);

	

	 if(isnotebook)
	 {
	 	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), table, NULL);
	 	gtk_notebook_set_tab_label_text (GTK_NOTEBOOK (notebook), table,
						  _("Score Header"));
	 }
	 else
	 {
	 	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(notebook)->vbox), table, TRUE, TRUE,0);
	 }	
	 hsetup.title = title;
	 hsetup.subtitle = subtitle;
	 hsetup.poet = poet;
	 hsetup.composer = composer;
	 hsetup.meter = meter;
	 hsetup.opus = opus;
	 hsetup.arranger = arranger;
         hsetup.instrument = instrument;
	 hsetup.dedication = dedication;
	 hsetup.piece = piece;
	 hsetup.head = head;
	 hsetup.copyright = copyright;
	 hsetup.footer = footer;
	 hsetup.tagline = tagline; 
}

/**
 * Function to set the printed score parameters
 *
 */
void setpaperconfig(papersetupcb *cbdata, scoreinfo *si)
{
	g_string_assign(si->sconfig->papersize, (gchar *) gtk_entry_get_text (GTK_ENTRY (GTK_BIN (cbdata->papersize)->child)));
	g_string_assign(si->sconfig->lilyversion, (gchar *)gtk_entry_get_text (GTK_ENTRY (cbdata->lilyversion)));
	si->sconfig->fontsize = atoi((gchar *) gtk_entry_get_text (GTK_ENTRY (GTK_BIN (cbdata->fontsize)->child)));
	if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cbdata->portrait)))
	{
		si->sconfig->orientation = TRUE;
	}
else
		si->sconfig->orientation = FALSE;
		
  //g_print(" %s %s %d %d \n", si->sconfig->papersize->str, si->sconfig->lilyversion->str, si->sconfig->fontsize, si->sconfig->orientation);

}

void new_setpaperconfig(scoreinfo *si)
{
	g_string_assign(si->sconfig->papersize, (gchar *) gtk_entry_get_text (GTK_ENTRY (GTK_BIN (psetup.papersize)->child)));
	g_string_assign(si->sconfig->lilyversion, (gchar *)gtk_entry_get_text (GTK_ENTRY (psetup.lilyversion)));
	si->sconfig->fontsize = atoi((gchar *) gtk_entry_get_text (GTK_ENTRY (GTK_BIN (psetup.fontsize)->child)));
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(psetup.portrait)))
	{
		si->sconfig->orientation = TRUE;
	}
	else
		si->sconfig->orientation = FALSE;
		
  //g_print(" %s %s %d %d \n", si->sconfig->papersize->str, si->sconfig->lilyversion->str, si->sconfig->fontsize, si->sconfig->orientation);

}

/*
 * Create new staff's and label them with instrument names. 
 * 
 */
void setstaffconfig(wizarddata *cbdata, scoreinfo *si)
{
 	staffnumber = gtk_tree_model_iter_n_children (GTK_TREE_MODEL(wdata.sdata->score_list), NULL);	
	gtk_tree_model_foreach(GTK_TREE_MODEL(wdata.sdata->score_list), foreach_func, NULL);
}

/**
 * Set up the score based upon the configuration given
 * @param button the button that was pressed
 * @param data   the score wizard data
 */

static void setupscore(GtkButton *button, wizarddata *data)
{
   	new_setpaperconfig(data->si);
   	applyheader_settings(data->si);	
	setstaffconfig(data, data->si);

 	g_free(data->sdata);
}


/**
 * Top-level function for score creation 
 *
 */
void scorewizard(GtkAction *action, scoreinfo *si)
{
  deletescore (NULL, si);
  //wizarddata wdata;
  wdata.si = si;
  wdata.instruments = NULL;
  icbdata.instruments = parseInstruments(wdata.instruments); 
  
  GtkWidget *dialog = gtk_dialog_new(); 
  gtk_window_set_title (GTK_WINDOW (dialog), _("Score Configuration Wizard"));
  wdata.notebook = gtk_notebook_new(); 
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), wdata.notebook, TRUE,
  							TRUE, 0);

  /* create pages of notebook */
  new_papersetup(wdata.notebook, si, TRUE);
  headersetup(wdata.notebook, si, TRUE); 
  instrumentsetup(&wdata);

  /* create buttons underneath*/
  //create_buttons(dialog, &wdata);
  GtkWidget *backbutton = gtk_button_new_from_stock ("gtk-go-back");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), backbutton, FALSE, FALSE,0);
  g_signal_connect_swapped(G_OBJECT(backbutton), "clicked", G_CALLBACK (gtk_notebook_prev_page), G_OBJECT(wdata.notebook) );
  
  GtkWidget *nextbutton = gtk_button_new_from_stock ("gtk-go-forward");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), nextbutton, FALSE, FALSE,0);
  g_signal_connect_swapped(G_OBJECT(nextbutton), "clicked", G_CALLBACK (gtk_notebook_next_page), G_OBJECT(wdata.notebook) );
  
  GtkWidget *finishbutton = gtk_button_new_from_stock ("gtk-apply");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), finishbutton, FALSE, FALSE,0);
  g_signal_connect(G_OBJECT(finishbutton), "clicked", G_CALLBACK (setupscore),  (gpointer)&wdata);
  g_signal_connect_swapped(G_OBJECT(finishbutton), "clicked", G_CALLBACK (gtk_widget_destroy), G_OBJECT(dialog));
  
  GtkWidget *cancelbutton = gtk_button_new_from_stock ("gtk-cancel");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), cancelbutton, FALSE, FALSE,0);
  g_signal_connect_swapped(G_OBJECT(cancelbutton), "clicked", G_CALLBACK (gtk_widget_destroy), G_OBJECT(dialog));

  
	
  gtk_widget_draw (si->scorearea, NULL);	
  gtk_widget_show_all(dialog);
  g_list_free(wdata.instruments); 
}


