# Copyright (C) 2008-2011  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Test calculation of terminal sizes."""

from __future__ import absolute_import, unicode_literals

__metaclass__ = type
__all__ = [
    'test_suite',
    ]


import os
import unittest

from computerjanitorapp import terminalsize


class TestTerminalSize(unittest.TestCase):
    """Test calculation of terminal sizes."""

    def test_returns_unknown_when_querying_dev_null(self):
        fd = os.open("/dev/null", os.O_RDONLY)
        rows, cols = terminalsize.get_terminal_size(fd)
        os.close(fd)
        self.assertEqual(rows, None)
        self.assertEqual(cols, None)

    def test_returns_two_integers_when_stdout_is_a_terminal(self):
        # We only run this check if stdout is a terminal.
        # Unfortunately, there is no sensible way of checking the values.
        # But that's OK, they're lumberjacks.
        if os.isatty(1):
            rows, cols = terminalsize.get_terminal_size(1)
            self.assertEqual(type(rows), int)
            self.assertEqual(type(cols), int)


def test_suite():
    suite = unittest.TestSuite()
    suite.addTests(unittest.makeSuite(TestTerminalSize))
    return suite
