/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "splash_options.h"

static int SplashOptionsDisplayPrivateIndex;

static CompMetadata splashOptionsMetadata;

static CompPluginVTable *splashPluginVTable = NULL;
CompPluginVTable splashOptionsVTable;

#define SPLASH_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, SplashOptions, o)
#define SPLASH_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, SplashOptions, o)

typedef struct _SplashOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[SplashDisplayOptionNum];
    splashDisplayOptionChangeNotifyProc notify[SplashDisplayOptionNum];
} SplashOptionsDisplay;

typedef struct _SplashOptionsScreen
{
} SplashOptionsScreen;

CompAction * splashGetInitiateKey (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionInitiateKey].value.action;
}

void splashSetInitiateKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->opt[SplashDisplayOptionInitiateKey].value.action.initiate = init;
}

void splashSetInitiateKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->opt[SplashDisplayOptionInitiateKey].value.action.terminate = term;
}

CompOption * splashGetInitiateKeyOption (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionInitiateKey];
}

void splashSetInitiateKeyNotify (CompDisplay *d, splashDisplayOptionChangeNotifyProc notify)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->notify[SplashDisplayOptionInitiateKey] = notify;
}

Bool splashGetFirststart (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return od->opt[SplashDisplayOptionFirststart].value.b;
}

CompOption * splashGetFirststartOption (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionFirststart];
}

void splashSetFirststartNotify (CompDisplay *d, splashDisplayOptionChangeNotifyProc notify)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->notify[SplashDisplayOptionFirststart] = notify;
}

char * splashGetBackground (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return od->opt[SplashDisplayOptionBackground].value.s;
}

CompOption * splashGetBackgroundOption (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionBackground];
}

void splashSetBackgroundNotify (CompDisplay *d, splashDisplayOptionChangeNotifyProc notify)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->notify[SplashDisplayOptionBackground] = notify;
}

char * splashGetLogo (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return od->opt[SplashDisplayOptionLogo].value.s;
}

CompOption * splashGetLogoOption (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionLogo];
}

void splashSetLogoNotify (CompDisplay *d, splashDisplayOptionChangeNotifyProc notify)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->notify[SplashDisplayOptionLogo] = notify;
}

float splashGetFadeTime (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return od->opt[SplashDisplayOptionFadeTime].value.f;
}

CompOption * splashGetFadeTimeOption (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionFadeTime];
}

void splashSetFadeTimeNotify (CompDisplay *d, splashDisplayOptionChangeNotifyProc notify)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->notify[SplashDisplayOptionFadeTime] = notify;
}

float splashGetDisplayTime (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return od->opt[SplashDisplayOptionDisplayTime].value.f;
}

CompOption * splashGetDisplayTimeOption (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionDisplayTime];
}

void splashSetDisplayTimeNotify (CompDisplay *d, splashDisplayOptionChangeNotifyProc notify)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->notify[SplashDisplayOptionDisplayTime] = notify;
}

float splashGetSaturation (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return od->opt[SplashDisplayOptionSaturation].value.f;
}

CompOption * splashGetSaturationOption (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionSaturation];
}

void splashSetSaturationNotify (CompDisplay *d, splashDisplayOptionChangeNotifyProc notify)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->notify[SplashDisplayOptionSaturation] = notify;
}

float splashGetBrightness (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return od->opt[SplashDisplayOptionBrightness].value.f;
}

CompOption * splashGetBrightnessOption (CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[SplashDisplayOptionBrightness];
}

void splashSetBrightnessNotify (CompDisplay *d, splashDisplayOptionChangeNotifyProc notify)
{
    SPLASH_OPTIONS_DISPLAY(d);
    od->notify[SplashDisplayOptionBrightness] = notify;
}

CompOption * splashGetDisplayOption (CompDisplay *d, SplashDisplayOptions num)
{
    SPLASH_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo splashOptionsDisplayOptionInfo[] = {
    { "initiate_key", "key", 0, 0, 0 },
    { "firststart", "bool", 0, 0, 0 },
    { "background", "string", 0, 0, 0 },
    { "logo", "string", 0, 0, 0 },
    { "fade_time", "float", "<min>0.0</min><max>100.0</max>", 0, 0 },
    { "display_time", "float", "<min>0.0</min><max>100.0</max>", 0, 0 },
    { "saturation", "float", "<min>0.0</min><max>100.0</max>", 0, 0 },
    { "brightness", "float", "<min>0.0</min><max>100.0</max>", 0, 0 },
};

static Bool splashOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    SPLASH_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, SplashDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case SplashDisplayOptionInitiateKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SplashDisplayOptionInitiateKey])
                (*od->notify[SplashDisplayOptionInitiateKey]) (d, o, SplashDisplayOptionInitiateKey);
            return TRUE;
        }
        break;
     case SplashDisplayOptionFirststart:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SplashDisplayOptionFirststart])
                (*od->notify[SplashDisplayOptionFirststart]) (d, o, SplashDisplayOptionFirststart);
            return TRUE;
        }
        break;
     case SplashDisplayOptionBackground:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SplashDisplayOptionBackground])
                (*od->notify[SplashDisplayOptionBackground]) (d, o, SplashDisplayOptionBackground);
            return TRUE;
        }
        break;
     case SplashDisplayOptionLogo:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SplashDisplayOptionLogo])
                (*od->notify[SplashDisplayOptionLogo]) (d, o, SplashDisplayOptionLogo);
            return TRUE;
        }
        break;
     case SplashDisplayOptionFadeTime:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SplashDisplayOptionFadeTime])
                (*od->notify[SplashDisplayOptionFadeTime]) (d, o, SplashDisplayOptionFadeTime);
            return TRUE;
        }
        break;
     case SplashDisplayOptionDisplayTime:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SplashDisplayOptionDisplayTime])
                (*od->notify[SplashDisplayOptionDisplayTime]) (d, o, SplashDisplayOptionDisplayTime);
            return TRUE;
        }
        break;
     case SplashDisplayOptionSaturation:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SplashDisplayOptionSaturation])
                (*od->notify[SplashDisplayOptionSaturation]) (d, o, SplashDisplayOptionSaturation);
            return TRUE;
        }
        break;
     case SplashDisplayOptionBrightness:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SplashDisplayOptionBrightness])
                (*od->notify[SplashDisplayOptionBrightness]) (d, o, SplashDisplayOptionBrightness);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * splashOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    SPLASH_OPTIONS_DISPLAY(d);
    *count = SplashDisplayOptionNum;
    return od->opt;
}

static Bool splashOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    SplashOptionsScreen *os;
    
    SPLASH_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(SplashOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void splashOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    SPLASH_OPTIONS_SCREEN (s);

    free (os);
}

static Bool splashOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    SplashOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(SplashOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[SplashOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &splashOptionsMetadata, splashOptionsDisplayOptionInfo, od->opt, SplashDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void splashOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    SPLASH_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, SplashDisplayOptionNum);

    free (od);
}

static Bool splashOptionsInit (CompPlugin *p)
{
    SplashOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (SplashOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&splashOptionsMetadata, "splash",splashOptionsDisplayOptionInfo, SplashDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&splashOptionsMetadata, "splash");
    if (splashPluginVTable && splashPluginVTable->init)
        return splashPluginVTable->init (p);
    return TRUE;
}

static void splashOptionsFini (CompPlugin *p)
{
    if (splashPluginVTable && splashPluginVTable->fini)
        splashPluginVTable->fini (p);

    if (SplashOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (SplashOptionsDisplayPrivateIndex);

    compFiniMetadata (&splashOptionsMetadata);
}

static CompBool splashOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) splashOptionsInitDisplay,
        (InitPluginObjectProc) splashOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void splashOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) splashOptionsFiniDisplay,
        (FiniPluginObjectProc) splashOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool splashOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = splashOptionsInitObject (p, o);
    if (splashPluginVTable->initObject)
        rv &= splashPluginVTable->initObject (p, o);
    return rv;
}

static void splashOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (splashPluginVTable->finiObject)
        splashPluginVTable->finiObject (p, o);
    splashOptionsFiniObject (p, o);
}

static CompOption * splashOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) splashOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool splashOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) splashOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
splashOptionsGetMetadata (CompPlugin *plugin)
{
    return &splashOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!splashPluginVTable)
    {
        splashPluginVTable = getCompPluginInfo ();
        memcpy(&splashOptionsVTable, splashPluginVTable, sizeof(CompPluginVTable));
        splashOptionsVTable.getMetadata = splashOptionsGetMetadata;
        splashOptionsVTable.init = splashOptionsInit;
        splashOptionsVTable.fini = splashOptionsFini;
        splashOptionsVTable.initObject = splashOptionsInitObjectWrapper;
        splashOptionsVTable.finiObject = splashOptionsFiniObjectWrapper;
        splashOptionsVTable.getObjectOptions = splashOptionsGetObjectOptions;
	splashOptionsVTable.setObjectOption = splashOptionsSetObjectOption;
	
    }
    return &splashOptionsVTable;
}

