#include "stl_util.h"
#include <iostream>
#include <tut.h>

namespace tut {
    
    using namespace std;
    using namespace capture;

    struct stl_util_shar {
    };
    
    typedef test_group<stl_util_shar> tg;
    typedef tg::object to;
    tg stl_util_tg ("stl_util");

    template<> template<>
    void to::test<1> ()
    {
        argmap test;
        test["test1"] = "test2";
        test["fjioj @,,ping"] = "jfdiosqj @@,,";
        test[",,"] = "#@@@";
        string out = argmap2string( test );
        argmap test2 = string2argmap( out );
        ensure( test2.size() == 3 );
        ensure( test2["test1"] == "test2" );
        ensure( test2["fjioj @,,ping"] == "jfdiosqj @@,," );
        ensure( test2[",,"] == "#@@@" );
    }
    template<> template<>
    void to::test<2> ()
    {
        list <string> test;
        test . push_back (string ("test, #1"));
        test . push_back (string ("test, #2"));
        string joinedf2 = join( test, "," );
        test . push_back ( joinedf2 );
        list<string> testret = explode (join (test, ","), ",");
        ensure( test.size() == testret.size() );
        list<string>::iterator i, j;
        i = test.begin();
        j = testret.begin();
        for ( ; i != test.end(); ++i, ++j )
          ensure( *i == *j );

        string joinedf3 = join( test, "," );
        test.push_back( joinedf3 );
        string str = join (test, "::");
        testret = explode (str, "::");
        i = test.begin();
        j = testret.begin();
        for ( ; i != test.end(); ++i, ++j )
          ensure( *i == *j );
    }
}
