/** -*- C++ -*-
    @file adept/utils.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <qthread.h>
#include <qstring.h>
#include <kapplication.h>
#include <string>
#include <queue>
#include <kdebug.h>

#ifndef EPT_UTILS_H
#define EPT_UTILS_H

namespace adept {

inline QString u8( std::string s ) {
    return QString::fromUtf8( s.c_str() );
}

inline std::string u8( QString s ) {
    return std::string( s.utf8() );
}

inline QString u8( const char *s ) {
    return QString::fromUtf8( s );
}

struct Threads {
    static QMutex serialize;
    typedef std::deque< std::pair< QThread *, QMutex * > > Queue;
    static Queue threads;
    static void enqueue( QThread *t, QMutex *m );
    static void wait();
};

template< typename F, typename P >
struct AsyncCall : public QThread
{
    AsyncCall( F f, P p ) : func( f ), param( p ) {}
    virtual void run()
    {
        // kdDebug() << "Thread waiting for mutex..." << endl;
        Threads::serialize.lock();
        // kdDebug() << "starting thread (mutex acquired)" << endl;
        func( param );
        // kdDebug() << "finishing thread (releasing mutex)" << endl;
        Threads::serialize.unlock();
    }
    virtual ~AsyncCall() {}
protected:
    F func;
    P param;
};


template< typename F, typename P > AsyncCall< F, P > *asyncCall( F f, P p ) {
    return new AsyncCall< F, P >( f, p );
}

inline static void adjustFontSize( QWidget *w, int off ) {
    QFont f = w->font();
    f.setPointSize( f.pointSize() + off ); // a bit smaller font...
    w->setFont( f );
    w->updateGeometry();
}

}

#endif
