/* Extended Module Player
 * Copyright (C) 1996-1999 Claudio Matsuoka and Hipolito Carraro Jr
 *
 * This file is part of the Extended Module Player and is distributed
 * under the terms of the GNU General Public License. See doc/COPYING
 * for more information.
 */

/* AMF loader written based on the format specs by Miodrag Vallat.
 *
 * The AMF format is the internal format used by DSMI, the DOS Sound and Music
 * Interface, which is the engine of DMP. As DMP was able to play more and more
 * module formats, the format evolved to support more features. There were 5
 * official formats, numbered from 10 (AMF 1.0) to 14 (AMF 1.4).
 */

struct amf_header {
    uint8 magic[3];			/* signature "AMF" */
    uint8 version;			/* 0A for 1.0, 0B for 1.1, etc */
    char title[20];			/* song title (ASCIIZ) */
    uint8 ins;				/* number of samples */
    uint8 len;				/* number of orders */
    uint16 trk;				/* number of tracks */
    uint8 chn;				/* number of channels */
/* AMF 1.0 = 10B channel remap table
 * AMF 1.1/1.2 = 10B panning table
 * AMF 1.3/1.4 = 20B panning table
 */
    uint8 table[20];
/* AMF >= 1.3 only */
    uint8 bpm;				/* initial tempo */
    uint8 tpo;				/* initial speed */
} PACKED;


struct amf_instr {
    uint8 type;				/* sample type: 1 = PCM sample */
    char name[20];			/* sample name (ASCIIZ) */
    char filename[13];			/* sample filename (ASCIIZ) */
    uint32 ptr;				/* sample index in the file */
    uint32 len;				/* sample length in bytes */
    uint16 c4spd;			/* rounded to nearest multiple of 8 */
    uint8 vol;				/* sample volume in range 0-0x40 */
/* uint16 for AMF 1.0 */
    uint32 lps;				/* sample loop start in bytes */
    uint32 lpe;				/* sample loop end in bytes */
} PACKED;


