/* Generated by wayland-scanner 1.23.1 */

#ifndef DPMS_CLIENT_PROTOCOL_H
#define DPMS_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_dpms The dpms protocol
 * @section page_ifaces_dpms Interfaces
 * - @subpage page_iface_org_kde_kwin_dpms_manager - Output dpms manager
 * - @subpage page_iface_org_kde_kwin_dpms - Dpms for a wl_output
 * @section page_copyright_dpms Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2015 Martin Gräßlin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_dpms;
struct org_kde_kwin_dpms_manager;
struct wl_output;

#ifndef ORG_KDE_KWIN_DPMS_MANAGER_INTERFACE
#define ORG_KDE_KWIN_DPMS_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_dpms_manager org_kde_kwin_dpms_manager
 * @section page_iface_org_kde_kwin_dpms_manager_desc Description
 *
 * The Dpms manager allows to get a org_kde_kwin_dpms for a given wl_output.
 * The org_kde_kwin_dpms provides the currently used VESA Display Power Management
 * Signaling state (see https://en.wikipedia.org/wiki/VESA_Display_Power_Management_Signaling ).
 * In addition it allows to request a state change. A compositor is not obliged to honor it
 * and will normally automatically switch back to on state.
 * @section page_iface_org_kde_kwin_dpms_manager_api API
 * See @ref iface_org_kde_kwin_dpms_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_dpms_manager The org_kde_kwin_dpms_manager interface
 *
 * The Dpms manager allows to get a org_kde_kwin_dpms for a given wl_output.
 * The org_kde_kwin_dpms provides the currently used VESA Display Power Management
 * Signaling state (see https://en.wikipedia.org/wiki/VESA_Display_Power_Management_Signaling ).
 * In addition it allows to request a state change. A compositor is not obliged to honor it
 * and will normally automatically switch back to on state.
 */
extern const struct wl_interface org_kde_kwin_dpms_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_DPMS_INTERFACE
#define ORG_KDE_KWIN_DPMS_INTERFACE
/**
 * @page page_iface_org_kde_kwin_dpms org_kde_kwin_dpms
 * @section page_iface_org_kde_kwin_dpms_desc Description
 *
 * This interface provides information about the VESA DPMS state for a wl_output.
 * It gets created through the request get on the org_kde_kwin_dpms_manager interface.
 *
 * On creating the resource the server will push whether DPSM is supported for the output,
 * the currently used DPMS state and notifies the client through the done event once all
 * states are pushed. Whenever a state changes the set of changes is committed with the
 * done event.
 * @section page_iface_org_kde_kwin_dpms_api API
 * See @ref iface_org_kde_kwin_dpms.
 */
/**
 * @defgroup iface_org_kde_kwin_dpms The org_kde_kwin_dpms interface
 *
 * This interface provides information about the VESA DPMS state for a wl_output.
 * It gets created through the request get on the org_kde_kwin_dpms_manager interface.
 *
 * On creating the resource the server will push whether DPSM is supported for the output,
 * the currently used DPMS state and notifies the client through the done event once all
 * states are pushed. Whenever a state changes the set of changes is committed with the
 * done event.
 */
extern const struct wl_interface org_kde_kwin_dpms_interface;
#endif

#define ORG_KDE_KWIN_DPMS_MANAGER_GET 0


/**
 * @ingroup iface_org_kde_kwin_dpms_manager
 */
#define ORG_KDE_KWIN_DPMS_MANAGER_GET_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_dpms_manager */
static inline void
org_kde_kwin_dpms_manager_set_user_data(struct org_kde_kwin_dpms_manager *org_kde_kwin_dpms_manager, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_dpms_manager, user_data);
}

/** @ingroup iface_org_kde_kwin_dpms_manager */
static inline void *
org_kde_kwin_dpms_manager_get_user_data(struct org_kde_kwin_dpms_manager *org_kde_kwin_dpms_manager)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_dpms_manager);
}

static inline uint32_t
org_kde_kwin_dpms_manager_get_version(struct org_kde_kwin_dpms_manager *org_kde_kwin_dpms_manager)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_dpms_manager);
}

/** @ingroup iface_org_kde_kwin_dpms_manager */
static inline void
org_kde_kwin_dpms_manager_destroy(struct org_kde_kwin_dpms_manager *org_kde_kwin_dpms_manager)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_dpms_manager);
}

/**
 * @ingroup iface_org_kde_kwin_dpms_manager
 *
 * Factory request to get the org_kde_kwin_dpms for a given wl_output.
 */
static inline struct org_kde_kwin_dpms *
org_kde_kwin_dpms_manager_get(struct org_kde_kwin_dpms_manager *org_kde_kwin_dpms_manager, struct wl_output *output)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_dpms_manager,
			 ORG_KDE_KWIN_DPMS_MANAGER_GET, &org_kde_kwin_dpms_interface, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_dpms_manager), 0, NULL, output);

	return (struct org_kde_kwin_dpms *) id;
}

#ifndef ORG_KDE_KWIN_DPMS_MODE_ENUM
#define ORG_KDE_KWIN_DPMS_MODE_ENUM
enum org_kde_kwin_dpms_mode {
	ORG_KDE_KWIN_DPMS_MODE_ON = 0,
	ORG_KDE_KWIN_DPMS_MODE_STANDBY = 1,
	ORG_KDE_KWIN_DPMS_MODE_SUSPEND = 2,
	ORG_KDE_KWIN_DPMS_MODE_OFF = 3,
};
#endif /* ORG_KDE_KWIN_DPMS_MODE_ENUM */

/**
 * @ingroup iface_org_kde_kwin_dpms
 * @struct org_kde_kwin_dpms_listener
 */
struct org_kde_kwin_dpms_listener {
	/**
	 * Event indicating whether DPMS is supported on the wl_output
	 *
	 * This event gets pushed on binding the resource and indicates
	 * whether the wl_output supports DPMS. There are operation modes
	 * of a Wayland server where DPMS might not make sense (e.g. nested
	 * compositors).
	 * @param supported Boolean value whether DPMS is supported (1) for the wl_output or not (0)
	 */
	void (*supported)(void *data,
			  struct org_kde_kwin_dpms *org_kde_kwin_dpms,
			  uint32_t supported);
	/**
	 * Event indicating used DPMS mode
	 *
	 * This mode gets pushed on binding the resource and provides the
	 * currently used DPMS mode. It also gets pushed if DPMS is not
	 * supported for the wl_output, in that case the value will be On.
	 *
	 * The event is also pushed whenever the state changes.
	 * @param mode The new currently used mode
	 */
	void (*mode)(void *data,
		     struct org_kde_kwin_dpms *org_kde_kwin_dpms,
		     uint32_t mode);
	/**
	 * All changes are pushed
	 *
	 * This event gets pushed on binding the resource once all other
	 * states are pushed.
	 *
	 * In addition it gets pushed whenever a state changes to tell the
	 * client that all state changes have been pushed.
	 */
	void (*done)(void *data,
		     struct org_kde_kwin_dpms *org_kde_kwin_dpms);
};

/**
 * @ingroup iface_org_kde_kwin_dpms
 */
static inline int
org_kde_kwin_dpms_add_listener(struct org_kde_kwin_dpms *org_kde_kwin_dpms,
			       const struct org_kde_kwin_dpms_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_kwin_dpms,
				     (void (**)(void)) listener, data);
}

#define ORG_KDE_KWIN_DPMS_SET 0
#define ORG_KDE_KWIN_DPMS_RELEASE 1

/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_SUPPORTED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_SET_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_RELEASE_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_dpms */
static inline void
org_kde_kwin_dpms_set_user_data(struct org_kde_kwin_dpms *org_kde_kwin_dpms, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_dpms, user_data);
}

/** @ingroup iface_org_kde_kwin_dpms */
static inline void *
org_kde_kwin_dpms_get_user_data(struct org_kde_kwin_dpms *org_kde_kwin_dpms)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_dpms);
}

static inline uint32_t
org_kde_kwin_dpms_get_version(struct org_kde_kwin_dpms *org_kde_kwin_dpms)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_dpms);
}

/** @ingroup iface_org_kde_kwin_dpms */
static inline void
org_kde_kwin_dpms_destroy(struct org_kde_kwin_dpms *org_kde_kwin_dpms)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_dpms);
}

/**
 * @ingroup iface_org_kde_kwin_dpms
 *
 * Requests that the compositor puts the wl_output into the passed mode. The compositor
 * is not obliged to change the state. In addition the compositor might leave the mode
 * whenever it seems suitable. E.g. the compositor might return to On state on user input.
 *
 * The client should not assume that the mode changed after requesting a new mode.
 * Instead the client should listen for the mode event.
 */
static inline void
org_kde_kwin_dpms_set(struct org_kde_kwin_dpms *org_kde_kwin_dpms, uint32_t mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_dpms,
			 ORG_KDE_KWIN_DPMS_SET, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_dpms), 0, mode);
}

/**
 * @ingroup iface_org_kde_kwin_dpms
 */
static inline void
org_kde_kwin_dpms_release(struct org_kde_kwin_dpms *org_kde_kwin_dpms)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_dpms,
			 ORG_KDE_KWIN_DPMS_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_dpms), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
