/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPQuery;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class HTTPGraphQuery
extends HTTPQuery
implements GraphQuery {
    public HTTPGraphQuery(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super(con, ql, queryString, baseURI);
    }

    public GraphQueryResult evaluate() throws HTTPQueryEvaluationException {
        HTTPClient client = this.httpCon.getRepository().getHTTPClient();
        try {
            return client.sendGraphQuery(this.queryLanguage, this.queryString, this.dataset, this.includeInferred, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }

    public void evaluate(RDFHandler handler) throws HTTPQueryEvaluationException, RDFHandlerException {
        HTTPClient client = this.httpCon.getRepository().getHTTPClient();
        try {
            client.sendGraphQuery(this.queryLanguage, this.queryString, this.dataset, this.includeInferred, handler, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }
}

