/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

const url = "data:text/html,<body>hi";

add_task(function*() {
  yield* testURL(url, urlEnter);
  yield* testURL(url, urlClick);
});

function urlEnter(url) {
  gURLBar.value = url;
  gURLBar.focus();
  EventUtils.synthesizeKey("VK_RETURN", {});
}

function urlClick(url) {
  gURLBar.value = url;
  gURLBar.focus();
  let goButton = document.getElementById("urlbar-go-button");
  EventUtils.synthesizeMouseAtCenter(goButton, {});
}

function promiseNewTabSwitched() {
  return new Promise(resolve => {
    gBrowser.addEventListener("TabSwitchDone", function onSwitch() {
      gBrowser.removeEventListener("TabSwitchDone", onSwitch);
      executeSoon(resolve);
    });
  });
}

function testURL(url, loadFunc, endFunc) {
  let tabSwitchedPromise = promiseNewTabSwitched();
  let tab = gBrowser.selectedTab = gBrowser.addTab();
  let browser = gBrowser.selectedBrowser;

  let pageshowPromise = promiseWaitForEvent(browser, "pageshow");

  yield tabSwitchedPromise;
  yield pageshowPromise;

  let pagePrincipal = gBrowser.contentPrincipal;
  loadFunc(url);

  yield promiseWaitForEvent(browser, "pageshow");

  let focused = yield ContentTask.spawn(browser, { isRemote: gMultiProcessBrowser },
    function* (arg) {
      const fm = Components.classes["@mozilla.org/focus-manager;1"].
                            getService(Components.interfaces.nsIFocusManager);
      if (fm.focusedElement != null) {
        return "FAIL - focusedElement not null";
      }

      if (arg.isRemote) {
        return fm.activeWindow == content ? "PASS" :
                                            "FAIL - activeWindow not correct";
      }

      return "PASS";
  });

  is(focused, "PASS", "should be no focused element");
  is(document.activeElement, browser, "content window should be focused");

  ok(!gBrowser.contentPrincipal.equals(pagePrincipal),
     "load of " + url + " by " + loadFunc.name + " should produce a page with a different principal");

  gBrowser.removeTab(tab);
}
