/*
** Copyright (c) 2018-2023 Valve Corporation
** Copyright (c) 2018-2025 LunarG, Inc.
** Copyright (c) 2023 Advanced Micro Devices, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos OpenXR XML API Registry.
**
*/

#if ENABLE_OPENXR_SUPPORT

#include "generated_openxr_enum_to_string.h"

GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(util)
template <> std::string ToString<XrActionType>(const XrActionType& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_ACTION_TYPE_BOOLEAN_INPUT: return "XR_ACTION_TYPE_BOOLEAN_INPUT";
    case XR_ACTION_TYPE_FLOAT_INPUT: return "XR_ACTION_TYPE_FLOAT_INPUT";
    case XR_ACTION_TYPE_VECTOR2F_INPUT: return "XR_ACTION_TYPE_VECTOR2F_INPUT";
    case XR_ACTION_TYPE_POSE_INPUT: return "XR_ACTION_TYPE_POSE_INPUT";
    case XR_ACTION_TYPE_VIBRATION_OUTPUT: return "XR_ACTION_TYPE_VIBRATION_OUTPUT";
    default: break;
    }
    return "Unhandled XrActionType";
}

std::string XrAndroidSurfaceSwapchainFlagBitsFBToString(const XrAndroidSurfaceSwapchainFlagsFB value)
{
    switch (value) {
    case XR_ANDROID_SURFACE_SWAPCHAIN_SYNCHRONOUS_BIT_FB: return "XR_ANDROID_SURFACE_SWAPCHAIN_SYNCHRONOUS_BIT_FB";
    case XR_ANDROID_SURFACE_SWAPCHAIN_USE_TIMESTAMPS_BIT_FB: return "XR_ANDROID_SURFACE_SWAPCHAIN_USE_TIMESTAMPS_BIT_FB";
    default: break;
    }
    return "Unhandled XrAndroidSurfaceSwapchainFlagBitsFB";
}

std::string XrAndroidSurfaceSwapchainFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrAndroidSurfaceSwapchainFlagsFB>(xrFlags, XrAndroidSurfaceSwapchainFlagBitsFBToString);
}

template <> std::string ToString<XrAndroidThreadTypeKHR>(const XrAndroidThreadTypeKHR& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_ANDROID_THREAD_TYPE_APPLICATION_MAIN_KHR: return "XR_ANDROID_THREAD_TYPE_APPLICATION_MAIN_KHR";
    case XR_ANDROID_THREAD_TYPE_APPLICATION_WORKER_KHR: return "XR_ANDROID_THREAD_TYPE_APPLICATION_WORKER_KHR";
    case XR_ANDROID_THREAD_TYPE_RENDERER_MAIN_KHR: return "XR_ANDROID_THREAD_TYPE_RENDERER_MAIN_KHR";
    case XR_ANDROID_THREAD_TYPE_RENDERER_WORKER_KHR: return "XR_ANDROID_THREAD_TYPE_RENDERER_WORKER_KHR";
    default: break;
    }
    return "Unhandled XrAndroidThreadTypeKHR";
}

template <> std::string ToString<XrBlendFactorFB>(const XrBlendFactorFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_BLEND_FACTOR_ZERO_FB: return "XR_BLEND_FACTOR_ZERO_FB";
    case XR_BLEND_FACTOR_ONE_FB: return "XR_BLEND_FACTOR_ONE_FB";
    case XR_BLEND_FACTOR_SRC_ALPHA_FB: return "XR_BLEND_FACTOR_SRC_ALPHA_FB";
    case XR_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA_FB: return "XR_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA_FB";
    case XR_BLEND_FACTOR_DST_ALPHA_FB: return "XR_BLEND_FACTOR_DST_ALPHA_FB";
    case XR_BLEND_FACTOR_ONE_MINUS_DST_ALPHA_FB: return "XR_BLEND_FACTOR_ONE_MINUS_DST_ALPHA_FB";
    default: break;
    }
    return "Unhandled XrBlendFactorFB";
}

template <> std::string ToString<XrBodyJointFB>(const XrBodyJointFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_BODY_JOINT_ROOT_FB: return "XR_BODY_JOINT_ROOT_FB";
    case XR_BODY_JOINT_HIPS_FB: return "XR_BODY_JOINT_HIPS_FB";
    case XR_BODY_JOINT_SPINE_LOWER_FB: return "XR_BODY_JOINT_SPINE_LOWER_FB";
    case XR_BODY_JOINT_SPINE_MIDDLE_FB: return "XR_BODY_JOINT_SPINE_MIDDLE_FB";
    case XR_BODY_JOINT_SPINE_UPPER_FB: return "XR_BODY_JOINT_SPINE_UPPER_FB";
    case XR_BODY_JOINT_CHEST_FB: return "XR_BODY_JOINT_CHEST_FB";
    case XR_BODY_JOINT_NECK_FB: return "XR_BODY_JOINT_NECK_FB";
    case XR_BODY_JOINT_HEAD_FB: return "XR_BODY_JOINT_HEAD_FB";
    case XR_BODY_JOINT_LEFT_SHOULDER_FB: return "XR_BODY_JOINT_LEFT_SHOULDER_FB";
    case XR_BODY_JOINT_LEFT_SCAPULA_FB: return "XR_BODY_JOINT_LEFT_SCAPULA_FB";
    case XR_BODY_JOINT_LEFT_ARM_UPPER_FB: return "XR_BODY_JOINT_LEFT_ARM_UPPER_FB";
    case XR_BODY_JOINT_LEFT_ARM_LOWER_FB: return "XR_BODY_JOINT_LEFT_ARM_LOWER_FB";
    case XR_BODY_JOINT_LEFT_HAND_WRIST_TWIST_FB: return "XR_BODY_JOINT_LEFT_HAND_WRIST_TWIST_FB";
    case XR_BODY_JOINT_RIGHT_SHOULDER_FB: return "XR_BODY_JOINT_RIGHT_SHOULDER_FB";
    case XR_BODY_JOINT_RIGHT_SCAPULA_FB: return "XR_BODY_JOINT_RIGHT_SCAPULA_FB";
    case XR_BODY_JOINT_RIGHT_ARM_UPPER_FB: return "XR_BODY_JOINT_RIGHT_ARM_UPPER_FB";
    case XR_BODY_JOINT_RIGHT_ARM_LOWER_FB: return "XR_BODY_JOINT_RIGHT_ARM_LOWER_FB";
    case XR_BODY_JOINT_RIGHT_HAND_WRIST_TWIST_FB: return "XR_BODY_JOINT_RIGHT_HAND_WRIST_TWIST_FB";
    case XR_BODY_JOINT_LEFT_HAND_PALM_FB: return "XR_BODY_JOINT_LEFT_HAND_PALM_FB";
    case XR_BODY_JOINT_LEFT_HAND_WRIST_FB: return "XR_BODY_JOINT_LEFT_HAND_WRIST_FB";
    case XR_BODY_JOINT_LEFT_HAND_THUMB_METACARPAL_FB: return "XR_BODY_JOINT_LEFT_HAND_THUMB_METACARPAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_THUMB_PROXIMAL_FB: return "XR_BODY_JOINT_LEFT_HAND_THUMB_PROXIMAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_THUMB_DISTAL_FB: return "XR_BODY_JOINT_LEFT_HAND_THUMB_DISTAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_THUMB_TIP_FB: return "XR_BODY_JOINT_LEFT_HAND_THUMB_TIP_FB";
    case XR_BODY_JOINT_LEFT_HAND_INDEX_METACARPAL_FB: return "XR_BODY_JOINT_LEFT_HAND_INDEX_METACARPAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_INDEX_PROXIMAL_FB: return "XR_BODY_JOINT_LEFT_HAND_INDEX_PROXIMAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_INDEX_INTERMEDIATE_FB: return "XR_BODY_JOINT_LEFT_HAND_INDEX_INTERMEDIATE_FB";
    case XR_BODY_JOINT_LEFT_HAND_INDEX_DISTAL_FB: return "XR_BODY_JOINT_LEFT_HAND_INDEX_DISTAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_INDEX_TIP_FB: return "XR_BODY_JOINT_LEFT_HAND_INDEX_TIP_FB";
    case XR_BODY_JOINT_LEFT_HAND_MIDDLE_METACARPAL_FB: return "XR_BODY_JOINT_LEFT_HAND_MIDDLE_METACARPAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_MIDDLE_PROXIMAL_FB: return "XR_BODY_JOINT_LEFT_HAND_MIDDLE_PROXIMAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_MIDDLE_INTERMEDIATE_FB: return "XR_BODY_JOINT_LEFT_HAND_MIDDLE_INTERMEDIATE_FB";
    case XR_BODY_JOINT_LEFT_HAND_MIDDLE_DISTAL_FB: return "XR_BODY_JOINT_LEFT_HAND_MIDDLE_DISTAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_MIDDLE_TIP_FB: return "XR_BODY_JOINT_LEFT_HAND_MIDDLE_TIP_FB";
    case XR_BODY_JOINT_LEFT_HAND_RING_METACARPAL_FB: return "XR_BODY_JOINT_LEFT_HAND_RING_METACARPAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_RING_PROXIMAL_FB: return "XR_BODY_JOINT_LEFT_HAND_RING_PROXIMAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_RING_INTERMEDIATE_FB: return "XR_BODY_JOINT_LEFT_HAND_RING_INTERMEDIATE_FB";
    case XR_BODY_JOINT_LEFT_HAND_RING_DISTAL_FB: return "XR_BODY_JOINT_LEFT_HAND_RING_DISTAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_RING_TIP_FB: return "XR_BODY_JOINT_LEFT_HAND_RING_TIP_FB";
    case XR_BODY_JOINT_LEFT_HAND_LITTLE_METACARPAL_FB: return "XR_BODY_JOINT_LEFT_HAND_LITTLE_METACARPAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_LITTLE_PROXIMAL_FB: return "XR_BODY_JOINT_LEFT_HAND_LITTLE_PROXIMAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_LITTLE_INTERMEDIATE_FB: return "XR_BODY_JOINT_LEFT_HAND_LITTLE_INTERMEDIATE_FB";
    case XR_BODY_JOINT_LEFT_HAND_LITTLE_DISTAL_FB: return "XR_BODY_JOINT_LEFT_HAND_LITTLE_DISTAL_FB";
    case XR_BODY_JOINT_LEFT_HAND_LITTLE_TIP_FB: return "XR_BODY_JOINT_LEFT_HAND_LITTLE_TIP_FB";
    case XR_BODY_JOINT_RIGHT_HAND_PALM_FB: return "XR_BODY_JOINT_RIGHT_HAND_PALM_FB";
    case XR_BODY_JOINT_RIGHT_HAND_WRIST_FB: return "XR_BODY_JOINT_RIGHT_HAND_WRIST_FB";
    case XR_BODY_JOINT_RIGHT_HAND_THUMB_METACARPAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_THUMB_METACARPAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_THUMB_PROXIMAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_THUMB_PROXIMAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_THUMB_DISTAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_THUMB_DISTAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_THUMB_TIP_FB: return "XR_BODY_JOINT_RIGHT_HAND_THUMB_TIP_FB";
    case XR_BODY_JOINT_RIGHT_HAND_INDEX_METACARPAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_INDEX_METACARPAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_INDEX_PROXIMAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_INDEX_PROXIMAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_INDEX_INTERMEDIATE_FB: return "XR_BODY_JOINT_RIGHT_HAND_INDEX_INTERMEDIATE_FB";
    case XR_BODY_JOINT_RIGHT_HAND_INDEX_DISTAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_INDEX_DISTAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_INDEX_TIP_FB: return "XR_BODY_JOINT_RIGHT_HAND_INDEX_TIP_FB";
    case XR_BODY_JOINT_RIGHT_HAND_MIDDLE_METACARPAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_MIDDLE_METACARPAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_MIDDLE_PROXIMAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_MIDDLE_PROXIMAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_MIDDLE_INTERMEDIATE_FB: return "XR_BODY_JOINT_RIGHT_HAND_MIDDLE_INTERMEDIATE_FB";
    case XR_BODY_JOINT_RIGHT_HAND_MIDDLE_DISTAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_MIDDLE_DISTAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_MIDDLE_TIP_FB: return "XR_BODY_JOINT_RIGHT_HAND_MIDDLE_TIP_FB";
    case XR_BODY_JOINT_RIGHT_HAND_RING_METACARPAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_RING_METACARPAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_RING_PROXIMAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_RING_PROXIMAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_RING_INTERMEDIATE_FB: return "XR_BODY_JOINT_RIGHT_HAND_RING_INTERMEDIATE_FB";
    case XR_BODY_JOINT_RIGHT_HAND_RING_DISTAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_RING_DISTAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_RING_TIP_FB: return "XR_BODY_JOINT_RIGHT_HAND_RING_TIP_FB";
    case XR_BODY_JOINT_RIGHT_HAND_LITTLE_METACARPAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_LITTLE_METACARPAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_LITTLE_PROXIMAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_LITTLE_PROXIMAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_LITTLE_INTERMEDIATE_FB: return "XR_BODY_JOINT_RIGHT_HAND_LITTLE_INTERMEDIATE_FB";
    case XR_BODY_JOINT_RIGHT_HAND_LITTLE_DISTAL_FB: return "XR_BODY_JOINT_RIGHT_HAND_LITTLE_DISTAL_FB";
    case XR_BODY_JOINT_RIGHT_HAND_LITTLE_TIP_FB: return "XR_BODY_JOINT_RIGHT_HAND_LITTLE_TIP_FB";
    case XR_BODY_JOINT_COUNT_FB: return "XR_BODY_JOINT_COUNT_FB";
    case XR_BODY_JOINT_NONE_FB: return "XR_BODY_JOINT_NONE_FB";
    default: break;
    }
    return "Unhandled XrBodyJointFB";
}

template <> std::string ToString<XrBodyJointSetFB>(const XrBodyJointSetFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_BODY_JOINT_SET_DEFAULT_FB: return "XR_BODY_JOINT_SET_DEFAULT_FB";
    default: break;
    }
    return "Unhandled XrBodyJointSetFB";
}

template <> std::string ToString<XrColorSpaceFB>(const XrColorSpaceFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_COLOR_SPACE_UNMANAGED_FB: return "XR_COLOR_SPACE_UNMANAGED_FB";
    case XR_COLOR_SPACE_REC2020_FB: return "XR_COLOR_SPACE_REC2020_FB";
    case XR_COLOR_SPACE_REC709_FB: return "XR_COLOR_SPACE_REC709_FB";
    case XR_COLOR_SPACE_RIFT_CV1_FB: return "XR_COLOR_SPACE_RIFT_CV1_FB";
    case XR_COLOR_SPACE_RIFT_S_FB: return "XR_COLOR_SPACE_RIFT_S_FB";
    case XR_COLOR_SPACE_QUEST_FB: return "XR_COLOR_SPACE_QUEST_FB";
    case XR_COLOR_SPACE_P3_FB: return "XR_COLOR_SPACE_P3_FB";
    case XR_COLOR_SPACE_ADOBE_RGB_FB: return "XR_COLOR_SPACE_ADOBE_RGB_FB";
    default: break;
    }
    return "Unhandled XrColorSpaceFB";
}

template <> std::string ToString<XrCompareOpFB>(const XrCompareOpFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_COMPARE_OP_NEVER_FB: return "XR_COMPARE_OP_NEVER_FB";
    case XR_COMPARE_OP_LESS_FB: return "XR_COMPARE_OP_LESS_FB";
    case XR_COMPARE_OP_EQUAL_FB: return "XR_COMPARE_OP_EQUAL_FB";
    case XR_COMPARE_OP_LESS_OR_EQUAL_FB: return "XR_COMPARE_OP_LESS_OR_EQUAL_FB";
    case XR_COMPARE_OP_GREATER_FB: return "XR_COMPARE_OP_GREATER_FB";
    case XR_COMPARE_OP_NOT_EQUAL_FB: return "XR_COMPARE_OP_NOT_EQUAL_FB";
    case XR_COMPARE_OP_GREATER_OR_EQUAL_FB: return "XR_COMPARE_OP_GREATER_OR_EQUAL_FB";
    case XR_COMPARE_OP_ALWAYS_FB: return "XR_COMPARE_OP_ALWAYS_FB";
    default: break;
    }
    return "Unhandled XrCompareOpFB";
}

std::string XrCompositionLayerFlagBitsToString(const XrCompositionLayerFlags value)
{
    switch (value) {
    case XR_COMPOSITION_LAYER_CORRECT_CHROMATIC_ABERRATION_BIT: return "XR_COMPOSITION_LAYER_CORRECT_CHROMATIC_ABERRATION_BIT";
    case XR_COMPOSITION_LAYER_BLEND_TEXTURE_SOURCE_ALPHA_BIT: return "XR_COMPOSITION_LAYER_BLEND_TEXTURE_SOURCE_ALPHA_BIT";
    case XR_COMPOSITION_LAYER_UNPREMULTIPLIED_ALPHA_BIT: return "XR_COMPOSITION_LAYER_UNPREMULTIPLIED_ALPHA_BIT";
    case XR_COMPOSITION_LAYER_INVERTED_ALPHA_BIT_EXT: return "XR_COMPOSITION_LAYER_INVERTED_ALPHA_BIT_EXT";
    default: break;
    }
    return "Unhandled XrCompositionLayerFlagBits";
}

std::string XrCompositionLayerFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrCompositionLayerFlags>(xrFlags, XrCompositionLayerFlagBitsToString);
}

std::string XrCompositionLayerImageLayoutFlagBitsFBToString(const XrCompositionLayerImageLayoutFlagsFB value)
{
    switch (value) {
    case XR_COMPOSITION_LAYER_IMAGE_LAYOUT_VERTICAL_FLIP_BIT_FB: return "XR_COMPOSITION_LAYER_IMAGE_LAYOUT_VERTICAL_FLIP_BIT_FB";
    default: break;
    }
    return "Unhandled XrCompositionLayerImageLayoutFlagBitsFB";
}

std::string XrCompositionLayerImageLayoutFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrCompositionLayerImageLayoutFlagsFB>(xrFlags, XrCompositionLayerImageLayoutFlagBitsFBToString);
}

std::string XrCompositionLayerSecureContentFlagBitsFBToString(const XrCompositionLayerSecureContentFlagsFB value)
{
    switch (value) {
    case XR_COMPOSITION_LAYER_SECURE_CONTENT_EXCLUDE_LAYER_BIT_FB: return "XR_COMPOSITION_LAYER_SECURE_CONTENT_EXCLUDE_LAYER_BIT_FB";
    case XR_COMPOSITION_LAYER_SECURE_CONTENT_REPLACE_LAYER_BIT_FB: return "XR_COMPOSITION_LAYER_SECURE_CONTENT_REPLACE_LAYER_BIT_FB";
    default: break;
    }
    return "Unhandled XrCompositionLayerSecureContentFlagBitsFB";
}

std::string XrCompositionLayerSecureContentFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrCompositionLayerSecureContentFlagsFB>(xrFlags, XrCompositionLayerSecureContentFlagBitsFBToString);
}

std::string XrCompositionLayerSettingsFlagBitsFBToString(const XrCompositionLayerSettingsFlagsFB value)
{
    switch (value) {
    case XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SUPER_SAMPLING_BIT_FB: return "XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SUPER_SAMPLING_BIT_FB";
    case XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SUPER_SAMPLING_BIT_FB: return "XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SUPER_SAMPLING_BIT_FB";
    case XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SHARPENING_BIT_FB: return "XR_COMPOSITION_LAYER_SETTINGS_NORMAL_SHARPENING_BIT_FB";
    case XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SHARPENING_BIT_FB: return "XR_COMPOSITION_LAYER_SETTINGS_QUALITY_SHARPENING_BIT_FB";
    case XR_COMPOSITION_LAYER_SETTINGS_AUTO_LAYER_FILTER_BIT_META: return "XR_COMPOSITION_LAYER_SETTINGS_AUTO_LAYER_FILTER_BIT_META";
    default: break;
    }
    return "Unhandled XrCompositionLayerSettingsFlagBitsFB";
}

std::string XrCompositionLayerSettingsFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrCompositionLayerSettingsFlagsFB>(xrFlags, XrCompositionLayerSettingsFlagBitsFBToString);
}

std::string XrCompositionLayerSpaceWarpInfoFlagBitsFBToString(const XrCompositionLayerSpaceWarpInfoFlagsFB value)
{
    switch (value) {
    case XR_COMPOSITION_LAYER_SPACE_WARP_INFO_FRAME_SKIP_BIT_FB: return "XR_COMPOSITION_LAYER_SPACE_WARP_INFO_FRAME_SKIP_BIT_FB";
    default: break;
    }
    return "Unhandled XrCompositionLayerSpaceWarpInfoFlagBitsFB";
}

std::string XrCompositionLayerSpaceWarpInfoFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrCompositionLayerSpaceWarpInfoFlagsFB>(xrFlags, XrCompositionLayerSpaceWarpInfoFlagBitsFBToString);
}

std::string XrDebugUtilsMessageSeverityFlagBitsEXTToString(const XrDebugUtilsMessageSeverityFlagsEXT value)
{
    switch (value) {
    case XR_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT: return "XR_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT";
    case XR_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT: return "XR_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT";
    case XR_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT: return "XR_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT";
    case XR_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT: return "XR_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT";
    default: break;
    }
    return "Unhandled XrDebugUtilsMessageSeverityFlagBitsEXT";
}

std::string XrDebugUtilsMessageSeverityFlagsEXTToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrDebugUtilsMessageSeverityFlagsEXT>(xrFlags, XrDebugUtilsMessageSeverityFlagBitsEXTToString);
}

std::string XrDebugUtilsMessageTypeFlagBitsEXTToString(const XrDebugUtilsMessageTypeFlagsEXT value)
{
    switch (value) {
    case XR_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT: return "XR_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT";
    case XR_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT: return "XR_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT";
    case XR_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT: return "XR_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT";
    case XR_DEBUG_UTILS_MESSAGE_TYPE_CONFORMANCE_BIT_EXT: return "XR_DEBUG_UTILS_MESSAGE_TYPE_CONFORMANCE_BIT_EXT";
    default: break;
    }
    return "Unhandled XrDebugUtilsMessageTypeFlagBitsEXT";
}

std::string XrDebugUtilsMessageTypeFlagsEXTToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrDebugUtilsMessageTypeFlagsEXT>(xrFlags, XrDebugUtilsMessageTypeFlagBitsEXTToString);
}

std::string XrDigitalLensControlFlagBitsALMALENCEToString(const XrDigitalLensControlFlagsALMALENCE value)
{
    switch (value) {
    case XR_DIGITAL_LENS_CONTROL_PROCESSING_DISABLE_BIT_ALMALENCE: return "XR_DIGITAL_LENS_CONTROL_PROCESSING_DISABLE_BIT_ALMALENCE";
    default: break;
    }
    return "Unhandled XrDigitalLensControlFlagBitsALMALENCE";
}

std::string XrDigitalLensControlFlagsALMALENCEToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrDigitalLensControlFlagsALMALENCE>(xrFlags, XrDigitalLensControlFlagBitsALMALENCEToString);
}

template <> std::string ToString<XrEnvironmentBlendMode>(const XrEnvironmentBlendMode& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_ENVIRONMENT_BLEND_MODE_OPAQUE: return "XR_ENVIRONMENT_BLEND_MODE_OPAQUE";
    case XR_ENVIRONMENT_BLEND_MODE_ADDITIVE: return "XR_ENVIRONMENT_BLEND_MODE_ADDITIVE";
    case XR_ENVIRONMENT_BLEND_MODE_ALPHA_BLEND: return "XR_ENVIRONMENT_BLEND_MODE_ALPHA_BLEND";
    default: break;
    }
    return "Unhandled XrEnvironmentBlendMode";
}

std::string XrEnvironmentDepthProviderCreateFlagBitsMETAToString(const XrEnvironmentDepthProviderCreateFlagsMETA value)
{
    return "Unhandled XrEnvironmentDepthProviderCreateFlagBitsMETA";
}

std::string XrEnvironmentDepthProviderCreateFlagsMETAToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrEnvironmentDepthProviderCreateFlagsMETA>(xrFlags, XrEnvironmentDepthProviderCreateFlagBitsMETAToString);
}

std::string XrEnvironmentDepthSwapchainCreateFlagBitsMETAToString(const XrEnvironmentDepthSwapchainCreateFlagsMETA value)
{
    return "Unhandled XrEnvironmentDepthSwapchainCreateFlagBitsMETA";
}

std::string XrEnvironmentDepthSwapchainCreateFlagsMETAToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrEnvironmentDepthSwapchainCreateFlagsMETA>(xrFlags, XrEnvironmentDepthSwapchainCreateFlagBitsMETAToString);
}

template <> std::string ToString<XrExternalCameraAttachedToDeviceOCULUS>(const XrExternalCameraAttachedToDeviceOCULUS& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_EXTERNAL_CAMERA_ATTACHED_TO_DEVICE_NONE_OCULUS: return "XR_EXTERNAL_CAMERA_ATTACHED_TO_DEVICE_NONE_OCULUS";
    case XR_EXTERNAL_CAMERA_ATTACHED_TO_DEVICE_HMD_OCULUS: return "XR_EXTERNAL_CAMERA_ATTACHED_TO_DEVICE_HMD_OCULUS";
    case XR_EXTERNAL_CAMERA_ATTACHED_TO_DEVICE_LTOUCH_OCULUS: return "XR_EXTERNAL_CAMERA_ATTACHED_TO_DEVICE_LTOUCH_OCULUS";
    case XR_EXTERNAL_CAMERA_ATTACHED_TO_DEVICE_RTOUCH_OCULUS: return "XR_EXTERNAL_CAMERA_ATTACHED_TO_DEVICE_RTOUCH_OCULUS";
    default: break;
    }
    return "Unhandled XrExternalCameraAttachedToDeviceOCULUS";
}

std::string XrExternalCameraStatusFlagBitsOCULUSToString(const XrExternalCameraStatusFlagsOCULUS value)
{
    switch (value) {
    case XR_EXTERNAL_CAMERA_STATUS_CONNECTED_BIT_OCULUS: return "XR_EXTERNAL_CAMERA_STATUS_CONNECTED_BIT_OCULUS";
    case XR_EXTERNAL_CAMERA_STATUS_CALIBRATING_BIT_OCULUS: return "XR_EXTERNAL_CAMERA_STATUS_CALIBRATING_BIT_OCULUS";
    case XR_EXTERNAL_CAMERA_STATUS_CALIBRATION_FAILED_BIT_OCULUS: return "XR_EXTERNAL_CAMERA_STATUS_CALIBRATION_FAILED_BIT_OCULUS";
    case XR_EXTERNAL_CAMERA_STATUS_CALIBRATED_BIT_OCULUS: return "XR_EXTERNAL_CAMERA_STATUS_CALIBRATED_BIT_OCULUS";
    case XR_EXTERNAL_CAMERA_STATUS_CAPTURING_BIT_OCULUS: return "XR_EXTERNAL_CAMERA_STATUS_CAPTURING_BIT_OCULUS";
    default: break;
    }
    return "Unhandled XrExternalCameraStatusFlagBitsOCULUS";
}

std::string XrExternalCameraStatusFlagsOCULUSToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrExternalCameraStatusFlagsOCULUS>(xrFlags, XrExternalCameraStatusFlagBitsOCULUSToString);
}

template <> std::string ToString<XrEyeCalibrationStatusML>(const XrEyeCalibrationStatusML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_EYE_CALIBRATION_STATUS_UNKNOWN_ML: return "XR_EYE_CALIBRATION_STATUS_UNKNOWN_ML";
    case XR_EYE_CALIBRATION_STATUS_NONE_ML: return "XR_EYE_CALIBRATION_STATUS_NONE_ML";
    case XR_EYE_CALIBRATION_STATUS_COARSE_ML: return "XR_EYE_CALIBRATION_STATUS_COARSE_ML";
    case XR_EYE_CALIBRATION_STATUS_FINE_ML: return "XR_EYE_CALIBRATION_STATUS_FINE_ML";
    default: break;
    }
    return "Unhandled XrEyeCalibrationStatusML";
}

template <> std::string ToString<XrEyeExpressionHTC>(const XrEyeExpressionHTC& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_EYE_EXPRESSION_LEFT_BLINK_HTC: return "XR_EYE_EXPRESSION_LEFT_BLINK_HTC";
    case XR_EYE_EXPRESSION_LEFT_WIDE_HTC: return "XR_EYE_EXPRESSION_LEFT_WIDE_HTC";
    case XR_EYE_EXPRESSION_RIGHT_BLINK_HTC: return "XR_EYE_EXPRESSION_RIGHT_BLINK_HTC";
    case XR_EYE_EXPRESSION_RIGHT_WIDE_HTC: return "XR_EYE_EXPRESSION_RIGHT_WIDE_HTC";
    case XR_EYE_EXPRESSION_LEFT_SQUEEZE_HTC: return "XR_EYE_EXPRESSION_LEFT_SQUEEZE_HTC";
    case XR_EYE_EXPRESSION_RIGHT_SQUEEZE_HTC: return "XR_EYE_EXPRESSION_RIGHT_SQUEEZE_HTC";
    case XR_EYE_EXPRESSION_LEFT_DOWN_HTC: return "XR_EYE_EXPRESSION_LEFT_DOWN_HTC";
    case XR_EYE_EXPRESSION_RIGHT_DOWN_HTC: return "XR_EYE_EXPRESSION_RIGHT_DOWN_HTC";
    case XR_EYE_EXPRESSION_LEFT_OUT_HTC: return "XR_EYE_EXPRESSION_LEFT_OUT_HTC";
    case XR_EYE_EXPRESSION_RIGHT_IN_HTC: return "XR_EYE_EXPRESSION_RIGHT_IN_HTC";
    case XR_EYE_EXPRESSION_LEFT_IN_HTC: return "XR_EYE_EXPRESSION_LEFT_IN_HTC";
    case XR_EYE_EXPRESSION_RIGHT_OUT_HTC: return "XR_EYE_EXPRESSION_RIGHT_OUT_HTC";
    case XR_EYE_EXPRESSION_LEFT_UP_HTC: return "XR_EYE_EXPRESSION_LEFT_UP_HTC";
    case XR_EYE_EXPRESSION_RIGHT_UP_HTC: return "XR_EYE_EXPRESSION_RIGHT_UP_HTC";
    default: break;
    }
    return "Unhandled XrEyeExpressionHTC";
}

template <> std::string ToString<XrEyePositionFB>(const XrEyePositionFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_EYE_POSITION_LEFT_FB: return "XR_EYE_POSITION_LEFT_FB";
    case XR_EYE_POSITION_RIGHT_FB: return "XR_EYE_POSITION_RIGHT_FB";
    case XR_EYE_POSITION_COUNT_FB: return "XR_EYE_POSITION_COUNT_FB";
    default: break;
    }
    return "Unhandled XrEyePositionFB";
}

template <> std::string ToString<XrEyeVisibility>(const XrEyeVisibility& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_EYE_VISIBILITY_BOTH: return "XR_EYE_VISIBILITY_BOTH";
    case XR_EYE_VISIBILITY_LEFT: return "XR_EYE_VISIBILITY_LEFT";
    case XR_EYE_VISIBILITY_RIGHT: return "XR_EYE_VISIBILITY_RIGHT";
    default: break;
    }
    return "Unhandled XrEyeVisibility";
}

template <> std::string ToString<XrFaceConfidence2FB>(const XrFaceConfidence2FB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FACE_CONFIDENCE2_LOWER_FACE_FB: return "XR_FACE_CONFIDENCE2_LOWER_FACE_FB";
    case XR_FACE_CONFIDENCE2_UPPER_FACE_FB: return "XR_FACE_CONFIDENCE2_UPPER_FACE_FB";
    case XR_FACE_CONFIDENCE2_COUNT_FB: return "XR_FACE_CONFIDENCE2_COUNT_FB";
    default: break;
    }
    return "Unhandled XrFaceConfidence2FB";
}

template <> std::string ToString<XrFaceConfidenceFB>(const XrFaceConfidenceFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FACE_CONFIDENCE_LOWER_FACE_FB: return "XR_FACE_CONFIDENCE_LOWER_FACE_FB";
    case XR_FACE_CONFIDENCE_UPPER_FACE_FB: return "XR_FACE_CONFIDENCE_UPPER_FACE_FB";
    case XR_FACE_CONFIDENCE_COUNT_FB: return "XR_FACE_CONFIDENCE_COUNT_FB";
    default: break;
    }
    return "Unhandled XrFaceConfidenceFB";
}

template <> std::string ToString<XrFaceExpression2FB>(const XrFaceExpression2FB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FACE_EXPRESSION2_BROW_LOWERER_L_FB: return "XR_FACE_EXPRESSION2_BROW_LOWERER_L_FB";
    case XR_FACE_EXPRESSION2_BROW_LOWERER_R_FB: return "XR_FACE_EXPRESSION2_BROW_LOWERER_R_FB";
    case XR_FACE_EXPRESSION2_CHEEK_PUFF_L_FB: return "XR_FACE_EXPRESSION2_CHEEK_PUFF_L_FB";
    case XR_FACE_EXPRESSION2_CHEEK_PUFF_R_FB: return "XR_FACE_EXPRESSION2_CHEEK_PUFF_R_FB";
    case XR_FACE_EXPRESSION2_CHEEK_RAISER_L_FB: return "XR_FACE_EXPRESSION2_CHEEK_RAISER_L_FB";
    case XR_FACE_EXPRESSION2_CHEEK_RAISER_R_FB: return "XR_FACE_EXPRESSION2_CHEEK_RAISER_R_FB";
    case XR_FACE_EXPRESSION2_CHEEK_SUCK_L_FB: return "XR_FACE_EXPRESSION2_CHEEK_SUCK_L_FB";
    case XR_FACE_EXPRESSION2_CHEEK_SUCK_R_FB: return "XR_FACE_EXPRESSION2_CHEEK_SUCK_R_FB";
    case XR_FACE_EXPRESSION2_CHIN_RAISER_B_FB: return "XR_FACE_EXPRESSION2_CHIN_RAISER_B_FB";
    case XR_FACE_EXPRESSION2_CHIN_RAISER_T_FB: return "XR_FACE_EXPRESSION2_CHIN_RAISER_T_FB";
    case XR_FACE_EXPRESSION2_DIMPLER_L_FB: return "XR_FACE_EXPRESSION2_DIMPLER_L_FB";
    case XR_FACE_EXPRESSION2_DIMPLER_R_FB: return "XR_FACE_EXPRESSION2_DIMPLER_R_FB";
    case XR_FACE_EXPRESSION2_EYES_CLOSED_L_FB: return "XR_FACE_EXPRESSION2_EYES_CLOSED_L_FB";
    case XR_FACE_EXPRESSION2_EYES_CLOSED_R_FB: return "XR_FACE_EXPRESSION2_EYES_CLOSED_R_FB";
    case XR_FACE_EXPRESSION2_EYES_LOOK_DOWN_L_FB: return "XR_FACE_EXPRESSION2_EYES_LOOK_DOWN_L_FB";
    case XR_FACE_EXPRESSION2_EYES_LOOK_DOWN_R_FB: return "XR_FACE_EXPRESSION2_EYES_LOOK_DOWN_R_FB";
    case XR_FACE_EXPRESSION2_EYES_LOOK_LEFT_L_FB: return "XR_FACE_EXPRESSION2_EYES_LOOK_LEFT_L_FB";
    case XR_FACE_EXPRESSION2_EYES_LOOK_LEFT_R_FB: return "XR_FACE_EXPRESSION2_EYES_LOOK_LEFT_R_FB";
    case XR_FACE_EXPRESSION2_EYES_LOOK_RIGHT_L_FB: return "XR_FACE_EXPRESSION2_EYES_LOOK_RIGHT_L_FB";
    case XR_FACE_EXPRESSION2_EYES_LOOK_RIGHT_R_FB: return "XR_FACE_EXPRESSION2_EYES_LOOK_RIGHT_R_FB";
    case XR_FACE_EXPRESSION2_EYES_LOOK_UP_L_FB: return "XR_FACE_EXPRESSION2_EYES_LOOK_UP_L_FB";
    case XR_FACE_EXPRESSION2_EYES_LOOK_UP_R_FB: return "XR_FACE_EXPRESSION2_EYES_LOOK_UP_R_FB";
    case XR_FACE_EXPRESSION2_INNER_BROW_RAISER_L_FB: return "XR_FACE_EXPRESSION2_INNER_BROW_RAISER_L_FB";
    case XR_FACE_EXPRESSION2_INNER_BROW_RAISER_R_FB: return "XR_FACE_EXPRESSION2_INNER_BROW_RAISER_R_FB";
    case XR_FACE_EXPRESSION2_JAW_DROP_FB: return "XR_FACE_EXPRESSION2_JAW_DROP_FB";
    case XR_FACE_EXPRESSION2_JAW_SIDEWAYS_LEFT_FB: return "XR_FACE_EXPRESSION2_JAW_SIDEWAYS_LEFT_FB";
    case XR_FACE_EXPRESSION2_JAW_SIDEWAYS_RIGHT_FB: return "XR_FACE_EXPRESSION2_JAW_SIDEWAYS_RIGHT_FB";
    case XR_FACE_EXPRESSION2_JAW_THRUST_FB: return "XR_FACE_EXPRESSION2_JAW_THRUST_FB";
    case XR_FACE_EXPRESSION2_LID_TIGHTENER_L_FB: return "XR_FACE_EXPRESSION2_LID_TIGHTENER_L_FB";
    case XR_FACE_EXPRESSION2_LID_TIGHTENER_R_FB: return "XR_FACE_EXPRESSION2_LID_TIGHTENER_R_FB";
    case XR_FACE_EXPRESSION2_LIP_CORNER_DEPRESSOR_L_FB: return "XR_FACE_EXPRESSION2_LIP_CORNER_DEPRESSOR_L_FB";
    case XR_FACE_EXPRESSION2_LIP_CORNER_DEPRESSOR_R_FB: return "XR_FACE_EXPRESSION2_LIP_CORNER_DEPRESSOR_R_FB";
    case XR_FACE_EXPRESSION2_LIP_CORNER_PULLER_L_FB: return "XR_FACE_EXPRESSION2_LIP_CORNER_PULLER_L_FB";
    case XR_FACE_EXPRESSION2_LIP_CORNER_PULLER_R_FB: return "XR_FACE_EXPRESSION2_LIP_CORNER_PULLER_R_FB";
    case XR_FACE_EXPRESSION2_LIP_FUNNELER_LB_FB: return "XR_FACE_EXPRESSION2_LIP_FUNNELER_LB_FB";
    case XR_FACE_EXPRESSION2_LIP_FUNNELER_LT_FB: return "XR_FACE_EXPRESSION2_LIP_FUNNELER_LT_FB";
    case XR_FACE_EXPRESSION2_LIP_FUNNELER_RB_FB: return "XR_FACE_EXPRESSION2_LIP_FUNNELER_RB_FB";
    case XR_FACE_EXPRESSION2_LIP_FUNNELER_RT_FB: return "XR_FACE_EXPRESSION2_LIP_FUNNELER_RT_FB";
    case XR_FACE_EXPRESSION2_LIP_PRESSOR_L_FB: return "XR_FACE_EXPRESSION2_LIP_PRESSOR_L_FB";
    case XR_FACE_EXPRESSION2_LIP_PRESSOR_R_FB: return "XR_FACE_EXPRESSION2_LIP_PRESSOR_R_FB";
    case XR_FACE_EXPRESSION2_LIP_PUCKER_L_FB: return "XR_FACE_EXPRESSION2_LIP_PUCKER_L_FB";
    case XR_FACE_EXPRESSION2_LIP_PUCKER_R_FB: return "XR_FACE_EXPRESSION2_LIP_PUCKER_R_FB";
    case XR_FACE_EXPRESSION2_LIP_STRETCHER_L_FB: return "XR_FACE_EXPRESSION2_LIP_STRETCHER_L_FB";
    case XR_FACE_EXPRESSION2_LIP_STRETCHER_R_FB: return "XR_FACE_EXPRESSION2_LIP_STRETCHER_R_FB";
    case XR_FACE_EXPRESSION2_LIP_SUCK_LB_FB: return "XR_FACE_EXPRESSION2_LIP_SUCK_LB_FB";
    case XR_FACE_EXPRESSION2_LIP_SUCK_LT_FB: return "XR_FACE_EXPRESSION2_LIP_SUCK_LT_FB";
    case XR_FACE_EXPRESSION2_LIP_SUCK_RB_FB: return "XR_FACE_EXPRESSION2_LIP_SUCK_RB_FB";
    case XR_FACE_EXPRESSION2_LIP_SUCK_RT_FB: return "XR_FACE_EXPRESSION2_LIP_SUCK_RT_FB";
    case XR_FACE_EXPRESSION2_LIP_TIGHTENER_L_FB: return "XR_FACE_EXPRESSION2_LIP_TIGHTENER_L_FB";
    case XR_FACE_EXPRESSION2_LIP_TIGHTENER_R_FB: return "XR_FACE_EXPRESSION2_LIP_TIGHTENER_R_FB";
    case XR_FACE_EXPRESSION2_LIPS_TOWARD_FB: return "XR_FACE_EXPRESSION2_LIPS_TOWARD_FB";
    case XR_FACE_EXPRESSION2_LOWER_LIP_DEPRESSOR_L_FB: return "XR_FACE_EXPRESSION2_LOWER_LIP_DEPRESSOR_L_FB";
    case XR_FACE_EXPRESSION2_LOWER_LIP_DEPRESSOR_R_FB: return "XR_FACE_EXPRESSION2_LOWER_LIP_DEPRESSOR_R_FB";
    case XR_FACE_EXPRESSION2_MOUTH_LEFT_FB: return "XR_FACE_EXPRESSION2_MOUTH_LEFT_FB";
    case XR_FACE_EXPRESSION2_MOUTH_RIGHT_FB: return "XR_FACE_EXPRESSION2_MOUTH_RIGHT_FB";
    case XR_FACE_EXPRESSION2_NOSE_WRINKLER_L_FB: return "XR_FACE_EXPRESSION2_NOSE_WRINKLER_L_FB";
    case XR_FACE_EXPRESSION2_NOSE_WRINKLER_R_FB: return "XR_FACE_EXPRESSION2_NOSE_WRINKLER_R_FB";
    case XR_FACE_EXPRESSION2_OUTER_BROW_RAISER_L_FB: return "XR_FACE_EXPRESSION2_OUTER_BROW_RAISER_L_FB";
    case XR_FACE_EXPRESSION2_OUTER_BROW_RAISER_R_FB: return "XR_FACE_EXPRESSION2_OUTER_BROW_RAISER_R_FB";
    case XR_FACE_EXPRESSION2_UPPER_LID_RAISER_L_FB: return "XR_FACE_EXPRESSION2_UPPER_LID_RAISER_L_FB";
    case XR_FACE_EXPRESSION2_UPPER_LID_RAISER_R_FB: return "XR_FACE_EXPRESSION2_UPPER_LID_RAISER_R_FB";
    case XR_FACE_EXPRESSION2_UPPER_LIP_RAISER_L_FB: return "XR_FACE_EXPRESSION2_UPPER_LIP_RAISER_L_FB";
    case XR_FACE_EXPRESSION2_UPPER_LIP_RAISER_R_FB: return "XR_FACE_EXPRESSION2_UPPER_LIP_RAISER_R_FB";
    case XR_FACE_EXPRESSION2_TONGUE_TIP_INTERDENTAL_FB: return "XR_FACE_EXPRESSION2_TONGUE_TIP_INTERDENTAL_FB";
    case XR_FACE_EXPRESSION2_TONGUE_TIP_ALVEOLAR_FB: return "XR_FACE_EXPRESSION2_TONGUE_TIP_ALVEOLAR_FB";
    case XR_FACE_EXPRESSION2_TONGUE_FRONT_DORSAL_PALATE_FB: return "XR_FACE_EXPRESSION2_TONGUE_FRONT_DORSAL_PALATE_FB";
    case XR_FACE_EXPRESSION2_TONGUE_MID_DORSAL_PALATE_FB: return "XR_FACE_EXPRESSION2_TONGUE_MID_DORSAL_PALATE_FB";
    case XR_FACE_EXPRESSION2_TONGUE_BACK_DORSAL_VELAR_FB: return "XR_FACE_EXPRESSION2_TONGUE_BACK_DORSAL_VELAR_FB";
    case XR_FACE_EXPRESSION2_TONGUE_OUT_FB: return "XR_FACE_EXPRESSION2_TONGUE_OUT_FB";
    case XR_FACE_EXPRESSION2_TONGUE_RETREAT_FB: return "XR_FACE_EXPRESSION2_TONGUE_RETREAT_FB";
    case XR_FACE_EXPRESSION2_COUNT_FB: return "XR_FACE_EXPRESSION2_COUNT_FB";
    default: break;
    }
    return "Unhandled XrFaceExpression2FB";
}

template <> std::string ToString<XrFaceExpressionFB>(const XrFaceExpressionFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FACE_EXPRESSION_BROW_LOWERER_L_FB: return "XR_FACE_EXPRESSION_BROW_LOWERER_L_FB";
    case XR_FACE_EXPRESSION_BROW_LOWERER_R_FB: return "XR_FACE_EXPRESSION_BROW_LOWERER_R_FB";
    case XR_FACE_EXPRESSION_CHEEK_PUFF_L_FB: return "XR_FACE_EXPRESSION_CHEEK_PUFF_L_FB";
    case XR_FACE_EXPRESSION_CHEEK_PUFF_R_FB: return "XR_FACE_EXPRESSION_CHEEK_PUFF_R_FB";
    case XR_FACE_EXPRESSION_CHEEK_RAISER_L_FB: return "XR_FACE_EXPRESSION_CHEEK_RAISER_L_FB";
    case XR_FACE_EXPRESSION_CHEEK_RAISER_R_FB: return "XR_FACE_EXPRESSION_CHEEK_RAISER_R_FB";
    case XR_FACE_EXPRESSION_CHEEK_SUCK_L_FB: return "XR_FACE_EXPRESSION_CHEEK_SUCK_L_FB";
    case XR_FACE_EXPRESSION_CHEEK_SUCK_R_FB: return "XR_FACE_EXPRESSION_CHEEK_SUCK_R_FB";
    case XR_FACE_EXPRESSION_CHIN_RAISER_B_FB: return "XR_FACE_EXPRESSION_CHIN_RAISER_B_FB";
    case XR_FACE_EXPRESSION_CHIN_RAISER_T_FB: return "XR_FACE_EXPRESSION_CHIN_RAISER_T_FB";
    case XR_FACE_EXPRESSION_DIMPLER_L_FB: return "XR_FACE_EXPRESSION_DIMPLER_L_FB";
    case XR_FACE_EXPRESSION_DIMPLER_R_FB: return "XR_FACE_EXPRESSION_DIMPLER_R_FB";
    case XR_FACE_EXPRESSION_EYES_CLOSED_L_FB: return "XR_FACE_EXPRESSION_EYES_CLOSED_L_FB";
    case XR_FACE_EXPRESSION_EYES_CLOSED_R_FB: return "XR_FACE_EXPRESSION_EYES_CLOSED_R_FB";
    case XR_FACE_EXPRESSION_EYES_LOOK_DOWN_L_FB: return "XR_FACE_EXPRESSION_EYES_LOOK_DOWN_L_FB";
    case XR_FACE_EXPRESSION_EYES_LOOK_DOWN_R_FB: return "XR_FACE_EXPRESSION_EYES_LOOK_DOWN_R_FB";
    case XR_FACE_EXPRESSION_EYES_LOOK_LEFT_L_FB: return "XR_FACE_EXPRESSION_EYES_LOOK_LEFT_L_FB";
    case XR_FACE_EXPRESSION_EYES_LOOK_LEFT_R_FB: return "XR_FACE_EXPRESSION_EYES_LOOK_LEFT_R_FB";
    case XR_FACE_EXPRESSION_EYES_LOOK_RIGHT_L_FB: return "XR_FACE_EXPRESSION_EYES_LOOK_RIGHT_L_FB";
    case XR_FACE_EXPRESSION_EYES_LOOK_RIGHT_R_FB: return "XR_FACE_EXPRESSION_EYES_LOOK_RIGHT_R_FB";
    case XR_FACE_EXPRESSION_EYES_LOOK_UP_L_FB: return "XR_FACE_EXPRESSION_EYES_LOOK_UP_L_FB";
    case XR_FACE_EXPRESSION_EYES_LOOK_UP_R_FB: return "XR_FACE_EXPRESSION_EYES_LOOK_UP_R_FB";
    case XR_FACE_EXPRESSION_INNER_BROW_RAISER_L_FB: return "XR_FACE_EXPRESSION_INNER_BROW_RAISER_L_FB";
    case XR_FACE_EXPRESSION_INNER_BROW_RAISER_R_FB: return "XR_FACE_EXPRESSION_INNER_BROW_RAISER_R_FB";
    case XR_FACE_EXPRESSION_JAW_DROP_FB: return "XR_FACE_EXPRESSION_JAW_DROP_FB";
    case XR_FACE_EXPRESSION_JAW_SIDEWAYS_LEFT_FB: return "XR_FACE_EXPRESSION_JAW_SIDEWAYS_LEFT_FB";
    case XR_FACE_EXPRESSION_JAW_SIDEWAYS_RIGHT_FB: return "XR_FACE_EXPRESSION_JAW_SIDEWAYS_RIGHT_FB";
    case XR_FACE_EXPRESSION_JAW_THRUST_FB: return "XR_FACE_EXPRESSION_JAW_THRUST_FB";
    case XR_FACE_EXPRESSION_LID_TIGHTENER_L_FB: return "XR_FACE_EXPRESSION_LID_TIGHTENER_L_FB";
    case XR_FACE_EXPRESSION_LID_TIGHTENER_R_FB: return "XR_FACE_EXPRESSION_LID_TIGHTENER_R_FB";
    case XR_FACE_EXPRESSION_LIP_CORNER_DEPRESSOR_L_FB: return "XR_FACE_EXPRESSION_LIP_CORNER_DEPRESSOR_L_FB";
    case XR_FACE_EXPRESSION_LIP_CORNER_DEPRESSOR_R_FB: return "XR_FACE_EXPRESSION_LIP_CORNER_DEPRESSOR_R_FB";
    case XR_FACE_EXPRESSION_LIP_CORNER_PULLER_L_FB: return "XR_FACE_EXPRESSION_LIP_CORNER_PULLER_L_FB";
    case XR_FACE_EXPRESSION_LIP_CORNER_PULLER_R_FB: return "XR_FACE_EXPRESSION_LIP_CORNER_PULLER_R_FB";
    case XR_FACE_EXPRESSION_LIP_FUNNELER_LB_FB: return "XR_FACE_EXPRESSION_LIP_FUNNELER_LB_FB";
    case XR_FACE_EXPRESSION_LIP_FUNNELER_LT_FB: return "XR_FACE_EXPRESSION_LIP_FUNNELER_LT_FB";
    case XR_FACE_EXPRESSION_LIP_FUNNELER_RB_FB: return "XR_FACE_EXPRESSION_LIP_FUNNELER_RB_FB";
    case XR_FACE_EXPRESSION_LIP_FUNNELER_RT_FB: return "XR_FACE_EXPRESSION_LIP_FUNNELER_RT_FB";
    case XR_FACE_EXPRESSION_LIP_PRESSOR_L_FB: return "XR_FACE_EXPRESSION_LIP_PRESSOR_L_FB";
    case XR_FACE_EXPRESSION_LIP_PRESSOR_R_FB: return "XR_FACE_EXPRESSION_LIP_PRESSOR_R_FB";
    case XR_FACE_EXPRESSION_LIP_PUCKER_L_FB: return "XR_FACE_EXPRESSION_LIP_PUCKER_L_FB";
    case XR_FACE_EXPRESSION_LIP_PUCKER_R_FB: return "XR_FACE_EXPRESSION_LIP_PUCKER_R_FB";
    case XR_FACE_EXPRESSION_LIP_STRETCHER_L_FB: return "XR_FACE_EXPRESSION_LIP_STRETCHER_L_FB";
    case XR_FACE_EXPRESSION_LIP_STRETCHER_R_FB: return "XR_FACE_EXPRESSION_LIP_STRETCHER_R_FB";
    case XR_FACE_EXPRESSION_LIP_SUCK_LB_FB: return "XR_FACE_EXPRESSION_LIP_SUCK_LB_FB";
    case XR_FACE_EXPRESSION_LIP_SUCK_LT_FB: return "XR_FACE_EXPRESSION_LIP_SUCK_LT_FB";
    case XR_FACE_EXPRESSION_LIP_SUCK_RB_FB: return "XR_FACE_EXPRESSION_LIP_SUCK_RB_FB";
    case XR_FACE_EXPRESSION_LIP_SUCK_RT_FB: return "XR_FACE_EXPRESSION_LIP_SUCK_RT_FB";
    case XR_FACE_EXPRESSION_LIP_TIGHTENER_L_FB: return "XR_FACE_EXPRESSION_LIP_TIGHTENER_L_FB";
    case XR_FACE_EXPRESSION_LIP_TIGHTENER_R_FB: return "XR_FACE_EXPRESSION_LIP_TIGHTENER_R_FB";
    case XR_FACE_EXPRESSION_LIPS_TOWARD_FB: return "XR_FACE_EXPRESSION_LIPS_TOWARD_FB";
    case XR_FACE_EXPRESSION_LOWER_LIP_DEPRESSOR_L_FB: return "XR_FACE_EXPRESSION_LOWER_LIP_DEPRESSOR_L_FB";
    case XR_FACE_EXPRESSION_LOWER_LIP_DEPRESSOR_R_FB: return "XR_FACE_EXPRESSION_LOWER_LIP_DEPRESSOR_R_FB";
    case XR_FACE_EXPRESSION_MOUTH_LEFT_FB: return "XR_FACE_EXPRESSION_MOUTH_LEFT_FB";
    case XR_FACE_EXPRESSION_MOUTH_RIGHT_FB: return "XR_FACE_EXPRESSION_MOUTH_RIGHT_FB";
    case XR_FACE_EXPRESSION_NOSE_WRINKLER_L_FB: return "XR_FACE_EXPRESSION_NOSE_WRINKLER_L_FB";
    case XR_FACE_EXPRESSION_NOSE_WRINKLER_R_FB: return "XR_FACE_EXPRESSION_NOSE_WRINKLER_R_FB";
    case XR_FACE_EXPRESSION_OUTER_BROW_RAISER_L_FB: return "XR_FACE_EXPRESSION_OUTER_BROW_RAISER_L_FB";
    case XR_FACE_EXPRESSION_OUTER_BROW_RAISER_R_FB: return "XR_FACE_EXPRESSION_OUTER_BROW_RAISER_R_FB";
    case XR_FACE_EXPRESSION_UPPER_LID_RAISER_L_FB: return "XR_FACE_EXPRESSION_UPPER_LID_RAISER_L_FB";
    case XR_FACE_EXPRESSION_UPPER_LID_RAISER_R_FB: return "XR_FACE_EXPRESSION_UPPER_LID_RAISER_R_FB";
    case XR_FACE_EXPRESSION_UPPER_LIP_RAISER_L_FB: return "XR_FACE_EXPRESSION_UPPER_LIP_RAISER_L_FB";
    case XR_FACE_EXPRESSION_UPPER_LIP_RAISER_R_FB: return "XR_FACE_EXPRESSION_UPPER_LIP_RAISER_R_FB";
    case XR_FACE_EXPRESSION_COUNT_FB: return "XR_FACE_EXPRESSION_COUNT_FB";
    default: break;
    }
    return "Unhandled XrFaceExpressionFB";
}

template <> std::string ToString<XrFaceExpressionSet2FB>(const XrFaceExpressionSet2FB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FACE_EXPRESSION_SET2_DEFAULT_FB: return "XR_FACE_EXPRESSION_SET2_DEFAULT_FB";
    default: break;
    }
    return "Unhandled XrFaceExpressionSet2FB";
}

template <> std::string ToString<XrFaceExpressionSetFB>(const XrFaceExpressionSetFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FACE_EXPRESSION_SET_DEFAULT_FB: return "XR_FACE_EXPRESSION_SET_DEFAULT_FB";
    default: break;
    }
    return "Unhandled XrFaceExpressionSetFB";
}

template <> std::string ToString<XrFaceTrackingDataSource2FB>(const XrFaceTrackingDataSource2FB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FACE_TRACKING_DATA_SOURCE2_VISUAL_FB: return "XR_FACE_TRACKING_DATA_SOURCE2_VISUAL_FB";
    case XR_FACE_TRACKING_DATA_SOURCE2_AUDIO_FB: return "XR_FACE_TRACKING_DATA_SOURCE2_AUDIO_FB";
    default: break;
    }
    return "Unhandled XrFaceTrackingDataSource2FB";
}

template <> std::string ToString<XrFacialTrackingTypeHTC>(const XrFacialTrackingTypeHTC& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FACIAL_TRACKING_TYPE_EYE_DEFAULT_HTC: return "XR_FACIAL_TRACKING_TYPE_EYE_DEFAULT_HTC";
    case XR_FACIAL_TRACKING_TYPE_LIP_DEFAULT_HTC: return "XR_FACIAL_TRACKING_TYPE_LIP_DEFAULT_HTC";
    default: break;
    }
    return "Unhandled XrFacialTrackingTypeHTC";
}

template <> std::string ToString<XrForceFeedbackCurlLocationMNDX>(const XrForceFeedbackCurlLocationMNDX& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FORCE_FEEDBACK_CURL_LOCATION_THUMB_CURL_MNDX: return "XR_FORCE_FEEDBACK_CURL_LOCATION_THUMB_CURL_MNDX";
    case XR_FORCE_FEEDBACK_CURL_LOCATION_INDEX_CURL_MNDX: return "XR_FORCE_FEEDBACK_CURL_LOCATION_INDEX_CURL_MNDX";
    case XR_FORCE_FEEDBACK_CURL_LOCATION_MIDDLE_CURL_MNDX: return "XR_FORCE_FEEDBACK_CURL_LOCATION_MIDDLE_CURL_MNDX";
    case XR_FORCE_FEEDBACK_CURL_LOCATION_RING_CURL_MNDX: return "XR_FORCE_FEEDBACK_CURL_LOCATION_RING_CURL_MNDX";
    case XR_FORCE_FEEDBACK_CURL_LOCATION_LITTLE_CURL_MNDX: return "XR_FORCE_FEEDBACK_CURL_LOCATION_LITTLE_CURL_MNDX";
    default: break;
    }
    return "Unhandled XrForceFeedbackCurlLocationMNDX";
}

template <> std::string ToString<XrFormFactor>(const XrFormFactor& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FORM_FACTOR_HEAD_MOUNTED_DISPLAY: return "XR_FORM_FACTOR_HEAD_MOUNTED_DISPLAY";
    case XR_FORM_FACTOR_HANDHELD_DISPLAY: return "XR_FORM_FACTOR_HANDHELD_DISPLAY";
    default: break;
    }
    return "Unhandled XrFormFactor";
}

template <> std::string ToString<XrFoveationDynamicFB>(const XrFoveationDynamicFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FOVEATION_DYNAMIC_DISABLED_FB: return "XR_FOVEATION_DYNAMIC_DISABLED_FB";
    case XR_FOVEATION_DYNAMIC_LEVEL_ENABLED_FB: return "XR_FOVEATION_DYNAMIC_LEVEL_ENABLED_FB";
    default: break;
    }
    return "Unhandled XrFoveationDynamicFB";
}

std::string XrFoveationDynamicFlagBitsHTCToString(const XrFoveationDynamicFlagsHTC value)
{
    switch (value) {
    case XR_FOVEATION_DYNAMIC_LEVEL_ENABLED_BIT_HTC: return "XR_FOVEATION_DYNAMIC_LEVEL_ENABLED_BIT_HTC";
    case XR_FOVEATION_DYNAMIC_CLEAR_FOV_ENABLED_BIT_HTC: return "XR_FOVEATION_DYNAMIC_CLEAR_FOV_ENABLED_BIT_HTC";
    case XR_FOVEATION_DYNAMIC_FOCAL_CENTER_OFFSET_ENABLED_BIT_HTC: return "XR_FOVEATION_DYNAMIC_FOCAL_CENTER_OFFSET_ENABLED_BIT_HTC";
    default: break;
    }
    return "Unhandled XrFoveationDynamicFlagBitsHTC";
}

std::string XrFoveationDynamicFlagsHTCToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrFoveationDynamicFlagsHTC>(xrFlags, XrFoveationDynamicFlagBitsHTCToString);
}

std::string XrFoveationEyeTrackedProfileCreateFlagBitsMETAToString(const XrFoveationEyeTrackedProfileCreateFlagsMETA value)
{
    return "Unhandled XrFoveationEyeTrackedProfileCreateFlagBitsMETA";
}

std::string XrFoveationEyeTrackedProfileCreateFlagsMETAToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrFoveationEyeTrackedProfileCreateFlagsMETA>(xrFlags, XrFoveationEyeTrackedProfileCreateFlagBitsMETAToString);
}

std::string XrFoveationEyeTrackedStateFlagBitsMETAToString(const XrFoveationEyeTrackedStateFlagsMETA value)
{
    switch (value) {
    case XR_FOVEATION_EYE_TRACKED_STATE_VALID_BIT_META: return "XR_FOVEATION_EYE_TRACKED_STATE_VALID_BIT_META";
    default: break;
    }
    return "Unhandled XrFoveationEyeTrackedStateFlagBitsMETA";
}

std::string XrFoveationEyeTrackedStateFlagsMETAToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrFoveationEyeTrackedStateFlagsMETA>(xrFlags, XrFoveationEyeTrackedStateFlagBitsMETAToString);
}

template <> std::string ToString<XrFoveationLevelFB>(const XrFoveationLevelFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FOVEATION_LEVEL_NONE_FB: return "XR_FOVEATION_LEVEL_NONE_FB";
    case XR_FOVEATION_LEVEL_LOW_FB: return "XR_FOVEATION_LEVEL_LOW_FB";
    case XR_FOVEATION_LEVEL_MEDIUM_FB: return "XR_FOVEATION_LEVEL_MEDIUM_FB";
    case XR_FOVEATION_LEVEL_HIGH_FB: return "XR_FOVEATION_LEVEL_HIGH_FB";
    default: break;
    }
    return "Unhandled XrFoveationLevelFB";
}

template <> std::string ToString<XrFoveationLevelHTC>(const XrFoveationLevelHTC& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FOVEATION_LEVEL_NONE_HTC: return "XR_FOVEATION_LEVEL_NONE_HTC";
    case XR_FOVEATION_LEVEL_LOW_HTC: return "XR_FOVEATION_LEVEL_LOW_HTC";
    case XR_FOVEATION_LEVEL_MEDIUM_HTC: return "XR_FOVEATION_LEVEL_MEDIUM_HTC";
    case XR_FOVEATION_LEVEL_HIGH_HTC: return "XR_FOVEATION_LEVEL_HIGH_HTC";
    default: break;
    }
    return "Unhandled XrFoveationLevelHTC";
}

template <> std::string ToString<XrFoveationModeHTC>(const XrFoveationModeHTC& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FOVEATION_MODE_DISABLE_HTC: return "XR_FOVEATION_MODE_DISABLE_HTC";
    case XR_FOVEATION_MODE_FIXED_HTC: return "XR_FOVEATION_MODE_FIXED_HTC";
    case XR_FOVEATION_MODE_DYNAMIC_HTC: return "XR_FOVEATION_MODE_DYNAMIC_HTC";
    case XR_FOVEATION_MODE_CUSTOM_HTC: return "XR_FOVEATION_MODE_CUSTOM_HTC";
    default: break;
    }
    return "Unhandled XrFoveationModeHTC";
}

std::string XrFrameEndInfoFlagBitsMLToString(const XrFrameEndInfoFlagsML value)
{
    switch (value) {
    case XR_FRAME_END_INFO_PROTECTED_BIT_ML: return "XR_FRAME_END_INFO_PROTECTED_BIT_ML";
    case XR_FRAME_END_INFO_VIGNETTE_BIT_ML: return "XR_FRAME_END_INFO_VIGNETTE_BIT_ML";
    default: break;
    }
    return "Unhandled XrFrameEndInfoFlagBitsML";
}

std::string XrFrameEndInfoFlagsMLToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrFrameEndInfoFlagsML>(xrFlags, XrFrameEndInfoFlagBitsMLToString);
}

template <> std::string ToString<XrFutureStateEXT>(const XrFutureStateEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_FUTURE_STATE_PENDING_EXT: return "XR_FUTURE_STATE_PENDING_EXT";
    case XR_FUTURE_STATE_READY_EXT: return "XR_FUTURE_STATE_READY_EXT";
    default: break;
    }
    return "Unhandled XrFutureStateEXT";
}

std::string XrGlobalDimmerFrameEndInfoFlagBitsMLToString(const XrGlobalDimmerFrameEndInfoFlagsML value)
{
    switch (value) {
    case XR_GLOBAL_DIMMER_FRAME_END_INFO_ENABLED_BIT_ML: return "XR_GLOBAL_DIMMER_FRAME_END_INFO_ENABLED_BIT_ML";
    default: break;
    }
    return "Unhandled XrGlobalDimmerFrameEndInfoFlagBitsML";
}

std::string XrGlobalDimmerFrameEndInfoFlagsMLToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrGlobalDimmerFrameEndInfoFlagsML>(xrFlags, XrGlobalDimmerFrameEndInfoFlagBitsMLToString);
}

template <> std::string ToString<XrHandEXT>(const XrHandEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_HAND_LEFT_EXT: return "XR_HAND_LEFT_EXT";
    case XR_HAND_RIGHT_EXT: return "XR_HAND_RIGHT_EXT";
    default: break;
    }
    return "Unhandled XrHandEXT";
}

template <> std::string ToString<XrHandForearmJointULTRALEAP>(const XrHandForearmJointULTRALEAP& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_HAND_FOREARM_JOINT_PALM_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_PALM_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_WRIST_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_WRIST_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_THUMB_METACARPAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_THUMB_METACARPAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_THUMB_PROXIMAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_THUMB_PROXIMAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_THUMB_DISTAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_THUMB_DISTAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_THUMB_TIP_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_THUMB_TIP_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_INDEX_METACARPAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_INDEX_METACARPAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_INDEX_PROXIMAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_INDEX_PROXIMAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_INDEX_INTERMEDIATE_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_INDEX_INTERMEDIATE_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_INDEX_DISTAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_INDEX_DISTAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_INDEX_TIP_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_INDEX_TIP_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_MIDDLE_METACARPAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_MIDDLE_METACARPAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_MIDDLE_PROXIMAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_MIDDLE_PROXIMAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_MIDDLE_INTERMEDIATE_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_MIDDLE_INTERMEDIATE_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_MIDDLE_DISTAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_MIDDLE_DISTAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_MIDDLE_TIP_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_MIDDLE_TIP_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_RING_METACARPAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_RING_METACARPAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_RING_PROXIMAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_RING_PROXIMAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_RING_INTERMEDIATE_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_RING_INTERMEDIATE_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_RING_DISTAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_RING_DISTAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_RING_TIP_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_RING_TIP_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_LITTLE_METACARPAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_LITTLE_METACARPAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_LITTLE_PROXIMAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_LITTLE_PROXIMAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_LITTLE_INTERMEDIATE_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_LITTLE_INTERMEDIATE_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_LITTLE_DISTAL_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_LITTLE_DISTAL_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_LITTLE_TIP_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_LITTLE_TIP_ULTRALEAP";
    case XR_HAND_FOREARM_JOINT_ELBOW_ULTRALEAP: return "XR_HAND_FOREARM_JOINT_ELBOW_ULTRALEAP";
    default: break;
    }
    return "Unhandled XrHandForearmJointULTRALEAP";
}

template <> std::string ToString<XrHandJointEXT>(const XrHandJointEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_HAND_JOINT_PALM_EXT: return "XR_HAND_JOINT_PALM_EXT";
    case XR_HAND_JOINT_WRIST_EXT: return "XR_HAND_JOINT_WRIST_EXT";
    case XR_HAND_JOINT_THUMB_METACARPAL_EXT: return "XR_HAND_JOINT_THUMB_METACARPAL_EXT";
    case XR_HAND_JOINT_THUMB_PROXIMAL_EXT: return "XR_HAND_JOINT_THUMB_PROXIMAL_EXT";
    case XR_HAND_JOINT_THUMB_DISTAL_EXT: return "XR_HAND_JOINT_THUMB_DISTAL_EXT";
    case XR_HAND_JOINT_THUMB_TIP_EXT: return "XR_HAND_JOINT_THUMB_TIP_EXT";
    case XR_HAND_JOINT_INDEX_METACARPAL_EXT: return "XR_HAND_JOINT_INDEX_METACARPAL_EXT";
    case XR_HAND_JOINT_INDEX_PROXIMAL_EXT: return "XR_HAND_JOINT_INDEX_PROXIMAL_EXT";
    case XR_HAND_JOINT_INDEX_INTERMEDIATE_EXT: return "XR_HAND_JOINT_INDEX_INTERMEDIATE_EXT";
    case XR_HAND_JOINT_INDEX_DISTAL_EXT: return "XR_HAND_JOINT_INDEX_DISTAL_EXT";
    case XR_HAND_JOINT_INDEX_TIP_EXT: return "XR_HAND_JOINT_INDEX_TIP_EXT";
    case XR_HAND_JOINT_MIDDLE_METACARPAL_EXT: return "XR_HAND_JOINT_MIDDLE_METACARPAL_EXT";
    case XR_HAND_JOINT_MIDDLE_PROXIMAL_EXT: return "XR_HAND_JOINT_MIDDLE_PROXIMAL_EXT";
    case XR_HAND_JOINT_MIDDLE_INTERMEDIATE_EXT: return "XR_HAND_JOINT_MIDDLE_INTERMEDIATE_EXT";
    case XR_HAND_JOINT_MIDDLE_DISTAL_EXT: return "XR_HAND_JOINT_MIDDLE_DISTAL_EXT";
    case XR_HAND_JOINT_MIDDLE_TIP_EXT: return "XR_HAND_JOINT_MIDDLE_TIP_EXT";
    case XR_HAND_JOINT_RING_METACARPAL_EXT: return "XR_HAND_JOINT_RING_METACARPAL_EXT";
    case XR_HAND_JOINT_RING_PROXIMAL_EXT: return "XR_HAND_JOINT_RING_PROXIMAL_EXT";
    case XR_HAND_JOINT_RING_INTERMEDIATE_EXT: return "XR_HAND_JOINT_RING_INTERMEDIATE_EXT";
    case XR_HAND_JOINT_RING_DISTAL_EXT: return "XR_HAND_JOINT_RING_DISTAL_EXT";
    case XR_HAND_JOINT_RING_TIP_EXT: return "XR_HAND_JOINT_RING_TIP_EXT";
    case XR_HAND_JOINT_LITTLE_METACARPAL_EXT: return "XR_HAND_JOINT_LITTLE_METACARPAL_EXT";
    case XR_HAND_JOINT_LITTLE_PROXIMAL_EXT: return "XR_HAND_JOINT_LITTLE_PROXIMAL_EXT";
    case XR_HAND_JOINT_LITTLE_INTERMEDIATE_EXT: return "XR_HAND_JOINT_LITTLE_INTERMEDIATE_EXT";
    case XR_HAND_JOINT_LITTLE_DISTAL_EXT: return "XR_HAND_JOINT_LITTLE_DISTAL_EXT";
    case XR_HAND_JOINT_LITTLE_TIP_EXT: return "XR_HAND_JOINT_LITTLE_TIP_EXT";
    default: break;
    }
    return "Unhandled XrHandJointEXT";
}

template <> std::string ToString<XrHandJointSetEXT>(const XrHandJointSetEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_HAND_JOINT_SET_DEFAULT_EXT: return "XR_HAND_JOINT_SET_DEFAULT_EXT";
    case XR_HAND_JOINT_SET_HAND_WITH_FOREARM_ULTRALEAP: return "XR_HAND_JOINT_SET_HAND_WITH_FOREARM_ULTRALEAP";
    default: break;
    }
    return "Unhandled XrHandJointSetEXT";
}

template <> std::string ToString<XrHandJointsMotionRangeEXT>(const XrHandJointsMotionRangeEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_HAND_JOINTS_MOTION_RANGE_UNOBSTRUCTED_EXT: return "XR_HAND_JOINTS_MOTION_RANGE_UNOBSTRUCTED_EXT";
    case XR_HAND_JOINTS_MOTION_RANGE_CONFORMING_TO_CONTROLLER_EXT: return "XR_HAND_JOINTS_MOTION_RANGE_CONFORMING_TO_CONTROLLER_EXT";
    default: break;
    }
    return "Unhandled XrHandJointsMotionRangeEXT";
}

template <> std::string ToString<XrHandPoseTypeMSFT>(const XrHandPoseTypeMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_HAND_POSE_TYPE_TRACKED_MSFT: return "XR_HAND_POSE_TYPE_TRACKED_MSFT";
    case XR_HAND_POSE_TYPE_REFERENCE_OPEN_PALM_MSFT: return "XR_HAND_POSE_TYPE_REFERENCE_OPEN_PALM_MSFT";
    default: break;
    }
    return "Unhandled XrHandPoseTypeMSFT";
}

std::string XrHandTrackingAimFlagBitsFBToString(const XrHandTrackingAimFlagsFB value)
{
    switch (value) {
    case XR_HAND_TRACKING_AIM_COMPUTED_BIT_FB: return "XR_HAND_TRACKING_AIM_COMPUTED_BIT_FB";
    case XR_HAND_TRACKING_AIM_VALID_BIT_FB: return "XR_HAND_TRACKING_AIM_VALID_BIT_FB";
    case XR_HAND_TRACKING_AIM_INDEX_PINCHING_BIT_FB: return "XR_HAND_TRACKING_AIM_INDEX_PINCHING_BIT_FB";
    case XR_HAND_TRACKING_AIM_MIDDLE_PINCHING_BIT_FB: return "XR_HAND_TRACKING_AIM_MIDDLE_PINCHING_BIT_FB";
    case XR_HAND_TRACKING_AIM_RING_PINCHING_BIT_FB: return "XR_HAND_TRACKING_AIM_RING_PINCHING_BIT_FB";
    case XR_HAND_TRACKING_AIM_LITTLE_PINCHING_BIT_FB: return "XR_HAND_TRACKING_AIM_LITTLE_PINCHING_BIT_FB";
    case XR_HAND_TRACKING_AIM_SYSTEM_GESTURE_BIT_FB: return "XR_HAND_TRACKING_AIM_SYSTEM_GESTURE_BIT_FB";
    case XR_HAND_TRACKING_AIM_DOMINANT_HAND_BIT_FB: return "XR_HAND_TRACKING_AIM_DOMINANT_HAND_BIT_FB";
    case XR_HAND_TRACKING_AIM_MENU_PRESSED_BIT_FB: return "XR_HAND_TRACKING_AIM_MENU_PRESSED_BIT_FB";
    default: break;
    }
    return "Unhandled XrHandTrackingAimFlagBitsFB";
}

std::string XrHandTrackingAimFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrHandTrackingAimFlagsFB>(xrFlags, XrHandTrackingAimFlagBitsFBToString);
}

template <> std::string ToString<XrHandTrackingDataSourceEXT>(const XrHandTrackingDataSourceEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_HAND_TRACKING_DATA_SOURCE_UNOBSTRUCTED_EXT: return "XR_HAND_TRACKING_DATA_SOURCE_UNOBSTRUCTED_EXT";
    case XR_HAND_TRACKING_DATA_SOURCE_CONTROLLER_EXT: return "XR_HAND_TRACKING_DATA_SOURCE_CONTROLLER_EXT";
    default: break;
    }
    return "Unhandled XrHandTrackingDataSourceEXT";
}

template <> std::string ToString<XrHeadsetFitStatusML>(const XrHeadsetFitStatusML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_HEADSET_FIT_STATUS_UNKNOWN_ML: return "XR_HEADSET_FIT_STATUS_UNKNOWN_ML";
    case XR_HEADSET_FIT_STATUS_NOT_WORN_ML: return "XR_HEADSET_FIT_STATUS_NOT_WORN_ML";
    case XR_HEADSET_FIT_STATUS_GOOD_FIT_ML: return "XR_HEADSET_FIT_STATUS_GOOD_FIT_ML";
    case XR_HEADSET_FIT_STATUS_BAD_FIT_ML: return "XR_HEADSET_FIT_STATUS_BAD_FIT_ML";
    default: break;
    }
    return "Unhandled XrHeadsetFitStatusML";
}

std::string XrInputSourceLocalizedNameFlagBitsToString(const XrInputSourceLocalizedNameFlags value)
{
    switch (value) {
    case XR_INPUT_SOURCE_LOCALIZED_NAME_USER_PATH_BIT: return "XR_INPUT_SOURCE_LOCALIZED_NAME_USER_PATH_BIT";
    case XR_INPUT_SOURCE_LOCALIZED_NAME_INTERACTION_PROFILE_BIT: return "XR_INPUT_SOURCE_LOCALIZED_NAME_INTERACTION_PROFILE_BIT";
    case XR_INPUT_SOURCE_LOCALIZED_NAME_COMPONENT_BIT: return "XR_INPUT_SOURCE_LOCALIZED_NAME_COMPONENT_BIT";
    default: break;
    }
    return "Unhandled XrInputSourceLocalizedNameFlagBits";
}

std::string XrInputSourceLocalizedNameFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrInputSourceLocalizedNameFlags>(xrFlags, XrInputSourceLocalizedNameFlagBitsToString);
}

std::string XrInstanceCreateFlagBitsToString(const XrInstanceCreateFlags value)
{
    return "Unhandled XrInstanceCreateFlagBits";
}

std::string XrInstanceCreateFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrInstanceCreateFlags>(xrFlags, XrInstanceCreateFlagBitsToString);
}

std::string XrKeyboardTrackingFlagBitsFBToString(const XrKeyboardTrackingFlagsFB value)
{
    switch (value) {
    case XR_KEYBOARD_TRACKING_EXISTS_BIT_FB: return "XR_KEYBOARD_TRACKING_EXISTS_BIT_FB";
    case XR_KEYBOARD_TRACKING_LOCAL_BIT_FB: return "XR_KEYBOARD_TRACKING_LOCAL_BIT_FB";
    case XR_KEYBOARD_TRACKING_REMOTE_BIT_FB: return "XR_KEYBOARD_TRACKING_REMOTE_BIT_FB";
    case XR_KEYBOARD_TRACKING_CONNECTED_BIT_FB: return "XR_KEYBOARD_TRACKING_CONNECTED_BIT_FB";
    default: break;
    }
    return "Unhandled XrKeyboardTrackingFlagBitsFB";
}

std::string XrKeyboardTrackingFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrKeyboardTrackingFlagsFB>(xrFlags, XrKeyboardTrackingFlagBitsFBToString);
}

std::string XrKeyboardTrackingQueryFlagBitsFBToString(const XrKeyboardTrackingQueryFlagsFB value)
{
    switch (value) {
    case XR_KEYBOARD_TRACKING_QUERY_LOCAL_BIT_FB: return "XR_KEYBOARD_TRACKING_QUERY_LOCAL_BIT_FB";
    case XR_KEYBOARD_TRACKING_QUERY_REMOTE_BIT_FB: return "XR_KEYBOARD_TRACKING_QUERY_REMOTE_BIT_FB";
    default: break;
    }
    return "Unhandled XrKeyboardTrackingQueryFlagBitsFB";
}

std::string XrKeyboardTrackingQueryFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrKeyboardTrackingQueryFlagsFB>(xrFlags, XrKeyboardTrackingQueryFlagBitsFBToString);
}

template <> std::string ToString<XrLipExpressionHTC>(const XrLipExpressionHTC& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_LIP_EXPRESSION_JAW_RIGHT_HTC: return "XR_LIP_EXPRESSION_JAW_RIGHT_HTC";
    case XR_LIP_EXPRESSION_JAW_LEFT_HTC: return "XR_LIP_EXPRESSION_JAW_LEFT_HTC";
    case XR_LIP_EXPRESSION_JAW_FORWARD_HTC: return "XR_LIP_EXPRESSION_JAW_FORWARD_HTC";
    case XR_LIP_EXPRESSION_JAW_OPEN_HTC: return "XR_LIP_EXPRESSION_JAW_OPEN_HTC";
    case XR_LIP_EXPRESSION_MOUTH_APE_SHAPE_HTC: return "XR_LIP_EXPRESSION_MOUTH_APE_SHAPE_HTC";
    case XR_LIP_EXPRESSION_MOUTH_UPPER_RIGHT_HTC: return "XR_LIP_EXPRESSION_MOUTH_UPPER_RIGHT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_UPPER_LEFT_HTC: return "XR_LIP_EXPRESSION_MOUTH_UPPER_LEFT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_LOWER_RIGHT_HTC: return "XR_LIP_EXPRESSION_MOUTH_LOWER_RIGHT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_LOWER_LEFT_HTC: return "XR_LIP_EXPRESSION_MOUTH_LOWER_LEFT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_UPPER_OVERTURN_HTC: return "XR_LIP_EXPRESSION_MOUTH_UPPER_OVERTURN_HTC";
    case XR_LIP_EXPRESSION_MOUTH_LOWER_OVERTURN_HTC: return "XR_LIP_EXPRESSION_MOUTH_LOWER_OVERTURN_HTC";
    case XR_LIP_EXPRESSION_MOUTH_POUT_HTC: return "XR_LIP_EXPRESSION_MOUTH_POUT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_SMILE_RIGHT_HTC: return "XR_LIP_EXPRESSION_MOUTH_SMILE_RIGHT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_SMILE_LEFT_HTC: return "XR_LIP_EXPRESSION_MOUTH_SMILE_LEFT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_SAD_RIGHT_HTC: return "XR_LIP_EXPRESSION_MOUTH_SAD_RIGHT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_SAD_LEFT_HTC: return "XR_LIP_EXPRESSION_MOUTH_SAD_LEFT_HTC";
    case XR_LIP_EXPRESSION_CHEEK_PUFF_RIGHT_HTC: return "XR_LIP_EXPRESSION_CHEEK_PUFF_RIGHT_HTC";
    case XR_LIP_EXPRESSION_CHEEK_PUFF_LEFT_HTC: return "XR_LIP_EXPRESSION_CHEEK_PUFF_LEFT_HTC";
    case XR_LIP_EXPRESSION_CHEEK_SUCK_HTC: return "XR_LIP_EXPRESSION_CHEEK_SUCK_HTC";
    case XR_LIP_EXPRESSION_MOUTH_UPPER_UPRIGHT_HTC: return "XR_LIP_EXPRESSION_MOUTH_UPPER_UPRIGHT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_UPPER_UPLEFT_HTC: return "XR_LIP_EXPRESSION_MOUTH_UPPER_UPLEFT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_LOWER_DOWNRIGHT_HTC: return "XR_LIP_EXPRESSION_MOUTH_LOWER_DOWNRIGHT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_LOWER_DOWNLEFT_HTC: return "XR_LIP_EXPRESSION_MOUTH_LOWER_DOWNLEFT_HTC";
    case XR_LIP_EXPRESSION_MOUTH_UPPER_INSIDE_HTC: return "XR_LIP_EXPRESSION_MOUTH_UPPER_INSIDE_HTC";
    case XR_LIP_EXPRESSION_MOUTH_LOWER_INSIDE_HTC: return "XR_LIP_EXPRESSION_MOUTH_LOWER_INSIDE_HTC";
    case XR_LIP_EXPRESSION_MOUTH_LOWER_OVERLAY_HTC: return "XR_LIP_EXPRESSION_MOUTH_LOWER_OVERLAY_HTC";
    case XR_LIP_EXPRESSION_TONGUE_LONGSTEP1_HTC: return "XR_LIP_EXPRESSION_TONGUE_LONGSTEP1_HTC";
    case XR_LIP_EXPRESSION_TONGUE_LEFT_HTC: return "XR_LIP_EXPRESSION_TONGUE_LEFT_HTC";
    case XR_LIP_EXPRESSION_TONGUE_RIGHT_HTC: return "XR_LIP_EXPRESSION_TONGUE_RIGHT_HTC";
    case XR_LIP_EXPRESSION_TONGUE_UP_HTC: return "XR_LIP_EXPRESSION_TONGUE_UP_HTC";
    case XR_LIP_EXPRESSION_TONGUE_DOWN_HTC: return "XR_LIP_EXPRESSION_TONGUE_DOWN_HTC";
    case XR_LIP_EXPRESSION_TONGUE_ROLL_HTC: return "XR_LIP_EXPRESSION_TONGUE_ROLL_HTC";
    case XR_LIP_EXPRESSION_TONGUE_LONGSTEP2_HTC: return "XR_LIP_EXPRESSION_TONGUE_LONGSTEP2_HTC";
    case XR_LIP_EXPRESSION_TONGUE_UPRIGHT_MORPH_HTC: return "XR_LIP_EXPRESSION_TONGUE_UPRIGHT_MORPH_HTC";
    case XR_LIP_EXPRESSION_TONGUE_UPLEFT_MORPH_HTC: return "XR_LIP_EXPRESSION_TONGUE_UPLEFT_MORPH_HTC";
    case XR_LIP_EXPRESSION_TONGUE_DOWNRIGHT_MORPH_HTC: return "XR_LIP_EXPRESSION_TONGUE_DOWNRIGHT_MORPH_HTC";
    case XR_LIP_EXPRESSION_TONGUE_DOWNLEFT_MORPH_HTC: return "XR_LIP_EXPRESSION_TONGUE_DOWNLEFT_MORPH_HTC";
    default: break;
    }
    return "Unhandled XrLipExpressionHTC";
}

template <> std::string ToString<XrLoaderInterfaceStructs>(const XrLoaderInterfaceStructs& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_LOADER_INTERFACE_STRUCT_UNINTIALIZED: return "XR_LOADER_INTERFACE_STRUCT_UNINTIALIZED";
    case XR_LOADER_INTERFACE_STRUCT_LOADER_INFO: return "XR_LOADER_INTERFACE_STRUCT_LOADER_INFO";
    case XR_LOADER_INTERFACE_STRUCT_API_LAYER_REQUEST: return "XR_LOADER_INTERFACE_STRUCT_API_LAYER_REQUEST";
    case XR_LOADER_INTERFACE_STRUCT_RUNTIME_REQUEST: return "XR_LOADER_INTERFACE_STRUCT_RUNTIME_REQUEST";
    case XR_LOADER_INTERFACE_STRUCT_API_LAYER_CREATE_INFO: return "XR_LOADER_INTERFACE_STRUCT_API_LAYER_CREATE_INFO";
    case XR_LOADER_INTERFACE_STRUCT_API_LAYER_NEXT_INFO: return "XR_LOADER_INTERFACE_STRUCT_API_LAYER_NEXT_INFO";
    default: break;
    }
    return "Unhandled XrLoaderInterfaceStructs";
}

template <> std::string ToString<XrLocalDimmingModeMETA>(const XrLocalDimmingModeMETA& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_LOCAL_DIMMING_MODE_OFF_META: return "XR_LOCAL_DIMMING_MODE_OFF_META";
    case XR_LOCAL_DIMMING_MODE_ON_META: return "XR_LOCAL_DIMMING_MODE_ON_META";
    default: break;
    }
    return "Unhandled XrLocalDimmingModeMETA";
}

template <> std::string ToString<XrLocalizationMapConfidenceML>(const XrLocalizationMapConfidenceML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_LOCALIZATION_MAP_CONFIDENCE_POOR_ML: return "XR_LOCALIZATION_MAP_CONFIDENCE_POOR_ML";
    case XR_LOCALIZATION_MAP_CONFIDENCE_FAIR_ML: return "XR_LOCALIZATION_MAP_CONFIDENCE_FAIR_ML";
    case XR_LOCALIZATION_MAP_CONFIDENCE_GOOD_ML: return "XR_LOCALIZATION_MAP_CONFIDENCE_GOOD_ML";
    case XR_LOCALIZATION_MAP_CONFIDENCE_EXCELLENT_ML: return "XR_LOCALIZATION_MAP_CONFIDENCE_EXCELLENT_ML";
    default: break;
    }
    return "Unhandled XrLocalizationMapConfidenceML";
}

std::string XrLocalizationMapErrorFlagBitsMLToString(const XrLocalizationMapErrorFlagsML value)
{
    switch (value) {
    case XR_LOCALIZATION_MAP_ERROR_UNKNOWN_BIT_ML: return "XR_LOCALIZATION_MAP_ERROR_UNKNOWN_BIT_ML";
    case XR_LOCALIZATION_MAP_ERROR_OUT_OF_MAPPED_AREA_BIT_ML: return "XR_LOCALIZATION_MAP_ERROR_OUT_OF_MAPPED_AREA_BIT_ML";
    case XR_LOCALIZATION_MAP_ERROR_LOW_FEATURE_COUNT_BIT_ML: return "XR_LOCALIZATION_MAP_ERROR_LOW_FEATURE_COUNT_BIT_ML";
    case XR_LOCALIZATION_MAP_ERROR_EXCESSIVE_MOTION_BIT_ML: return "XR_LOCALIZATION_MAP_ERROR_EXCESSIVE_MOTION_BIT_ML";
    case XR_LOCALIZATION_MAP_ERROR_LOW_LIGHT_BIT_ML: return "XR_LOCALIZATION_MAP_ERROR_LOW_LIGHT_BIT_ML";
    case XR_LOCALIZATION_MAP_ERROR_HEADPOSE_BIT_ML: return "XR_LOCALIZATION_MAP_ERROR_HEADPOSE_BIT_ML";
    default: break;
    }
    return "Unhandled XrLocalizationMapErrorFlagBitsML";
}

std::string XrLocalizationMapErrorFlagsMLToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrLocalizationMapErrorFlagsML>(xrFlags, XrLocalizationMapErrorFlagBitsMLToString);
}

template <> std::string ToString<XrLocalizationMapStateML>(const XrLocalizationMapStateML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_LOCALIZATION_MAP_STATE_NOT_LOCALIZED_ML: return "XR_LOCALIZATION_MAP_STATE_NOT_LOCALIZED_ML";
    case XR_LOCALIZATION_MAP_STATE_LOCALIZED_ML: return "XR_LOCALIZATION_MAP_STATE_LOCALIZED_ML";
    case XR_LOCALIZATION_MAP_STATE_LOCALIZATION_PENDING_ML: return "XR_LOCALIZATION_MAP_STATE_LOCALIZATION_PENDING_ML";
    case XR_LOCALIZATION_MAP_STATE_LOCALIZATION_SLEEPING_BEFORE_RETRY_ML: return "XR_LOCALIZATION_MAP_STATE_LOCALIZATION_SLEEPING_BEFORE_RETRY_ML";
    default: break;
    }
    return "Unhandled XrLocalizationMapStateML";
}

template <> std::string ToString<XrLocalizationMapTypeML>(const XrLocalizationMapTypeML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_LOCALIZATION_MAP_TYPE_ON_DEVICE_ML: return "XR_LOCALIZATION_MAP_TYPE_ON_DEVICE_ML";
    case XR_LOCALIZATION_MAP_TYPE_CLOUD_ML: return "XR_LOCALIZATION_MAP_TYPE_CLOUD_ML";
    default: break;
    }
    return "Unhandled XrLocalizationMapTypeML";
}

template <> std::string ToString<XrMarkerAprilTagDictML>(const XrMarkerAprilTagDictML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_APRIL_TAG_DICT_16H5_ML: return "XR_MARKER_APRIL_TAG_DICT_16H5_ML";
    case XR_MARKER_APRIL_TAG_DICT_25H9_ML: return "XR_MARKER_APRIL_TAG_DICT_25H9_ML";
    case XR_MARKER_APRIL_TAG_DICT_36H10_ML: return "XR_MARKER_APRIL_TAG_DICT_36H10_ML";
    case XR_MARKER_APRIL_TAG_DICT_36H11_ML: return "XR_MARKER_APRIL_TAG_DICT_36H11_ML";
    default: break;
    }
    return "Unhandled XrMarkerAprilTagDictML";
}

template <> std::string ToString<XrMarkerArucoDictML>(const XrMarkerArucoDictML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_ARUCO_DICT_4X4_50_ML: return "XR_MARKER_ARUCO_DICT_4X4_50_ML";
    case XR_MARKER_ARUCO_DICT_4X4_100_ML: return "XR_MARKER_ARUCO_DICT_4X4_100_ML";
    case XR_MARKER_ARUCO_DICT_4X4_250_ML: return "XR_MARKER_ARUCO_DICT_4X4_250_ML";
    case XR_MARKER_ARUCO_DICT_4X4_1000_ML: return "XR_MARKER_ARUCO_DICT_4X4_1000_ML";
    case XR_MARKER_ARUCO_DICT_5X5_50_ML: return "XR_MARKER_ARUCO_DICT_5X5_50_ML";
    case XR_MARKER_ARUCO_DICT_5X5_100_ML: return "XR_MARKER_ARUCO_DICT_5X5_100_ML";
    case XR_MARKER_ARUCO_DICT_5X5_250_ML: return "XR_MARKER_ARUCO_DICT_5X5_250_ML";
    case XR_MARKER_ARUCO_DICT_5X5_1000_ML: return "XR_MARKER_ARUCO_DICT_5X5_1000_ML";
    case XR_MARKER_ARUCO_DICT_6X6_50_ML: return "XR_MARKER_ARUCO_DICT_6X6_50_ML";
    case XR_MARKER_ARUCO_DICT_6X6_100_ML: return "XR_MARKER_ARUCO_DICT_6X6_100_ML";
    case XR_MARKER_ARUCO_DICT_6X6_250_ML: return "XR_MARKER_ARUCO_DICT_6X6_250_ML";
    case XR_MARKER_ARUCO_DICT_6X6_1000_ML: return "XR_MARKER_ARUCO_DICT_6X6_1000_ML";
    case XR_MARKER_ARUCO_DICT_7X7_50_ML: return "XR_MARKER_ARUCO_DICT_7X7_50_ML";
    case XR_MARKER_ARUCO_DICT_7X7_100_ML: return "XR_MARKER_ARUCO_DICT_7X7_100_ML";
    case XR_MARKER_ARUCO_DICT_7X7_250_ML: return "XR_MARKER_ARUCO_DICT_7X7_250_ML";
    case XR_MARKER_ARUCO_DICT_7X7_1000_ML: return "XR_MARKER_ARUCO_DICT_7X7_1000_ML";
    default: break;
    }
    return "Unhandled XrMarkerArucoDictML";
}

template <> std::string ToString<XrMarkerDetectorCameraML>(const XrMarkerDetectorCameraML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_DETECTOR_CAMERA_RGB_CAMERA_ML: return "XR_MARKER_DETECTOR_CAMERA_RGB_CAMERA_ML";
    case XR_MARKER_DETECTOR_CAMERA_WORLD_CAMERAS_ML: return "XR_MARKER_DETECTOR_CAMERA_WORLD_CAMERAS_ML";
    default: break;
    }
    return "Unhandled XrMarkerDetectorCameraML";
}

template <> std::string ToString<XrMarkerDetectorCornerRefineMethodML>(const XrMarkerDetectorCornerRefineMethodML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_NONE_ML: return "XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_NONE_ML";
    case XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_SUBPIX_ML: return "XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_SUBPIX_ML";
    case XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_CONTOUR_ML: return "XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_CONTOUR_ML";
    case XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_APRIL_TAG_ML: return "XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_APRIL_TAG_ML";
    default: break;
    }
    return "Unhandled XrMarkerDetectorCornerRefineMethodML";
}

template <> std::string ToString<XrMarkerDetectorFpsML>(const XrMarkerDetectorFpsML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_DETECTOR_FPS_LOW_ML: return "XR_MARKER_DETECTOR_FPS_LOW_ML";
    case XR_MARKER_DETECTOR_FPS_MEDIUM_ML: return "XR_MARKER_DETECTOR_FPS_MEDIUM_ML";
    case XR_MARKER_DETECTOR_FPS_HIGH_ML: return "XR_MARKER_DETECTOR_FPS_HIGH_ML";
    case XR_MARKER_DETECTOR_FPS_MAX_ML: return "XR_MARKER_DETECTOR_FPS_MAX_ML";
    default: break;
    }
    return "Unhandled XrMarkerDetectorFpsML";
}

template <> std::string ToString<XrMarkerDetectorFullAnalysisIntervalML>(const XrMarkerDetectorFullAnalysisIntervalML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_MAX_ML: return "XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_MAX_ML";
    case XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_FAST_ML: return "XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_FAST_ML";
    case XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_MEDIUM_ML: return "XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_MEDIUM_ML";
    case XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_SLOW_ML: return "XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_SLOW_ML";
    default: break;
    }
    return "Unhandled XrMarkerDetectorFullAnalysisIntervalML";
}

template <> std::string ToString<XrMarkerDetectorProfileML>(const XrMarkerDetectorProfileML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_DETECTOR_PROFILE_DEFAULT_ML: return "XR_MARKER_DETECTOR_PROFILE_DEFAULT_ML";
    case XR_MARKER_DETECTOR_PROFILE_SPEED_ML: return "XR_MARKER_DETECTOR_PROFILE_SPEED_ML";
    case XR_MARKER_DETECTOR_PROFILE_ACCURACY_ML: return "XR_MARKER_DETECTOR_PROFILE_ACCURACY_ML";
    case XR_MARKER_DETECTOR_PROFILE_SMALL_TARGETS_ML: return "XR_MARKER_DETECTOR_PROFILE_SMALL_TARGETS_ML";
    case XR_MARKER_DETECTOR_PROFILE_LARGE_FOV_ML: return "XR_MARKER_DETECTOR_PROFILE_LARGE_FOV_ML";
    case XR_MARKER_DETECTOR_PROFILE_CUSTOM_ML: return "XR_MARKER_DETECTOR_PROFILE_CUSTOM_ML";
    default: break;
    }
    return "Unhandled XrMarkerDetectorProfileML";
}

template <> std::string ToString<XrMarkerDetectorResolutionML>(const XrMarkerDetectorResolutionML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_DETECTOR_RESOLUTION_LOW_ML: return "XR_MARKER_DETECTOR_RESOLUTION_LOW_ML";
    case XR_MARKER_DETECTOR_RESOLUTION_MEDIUM_ML: return "XR_MARKER_DETECTOR_RESOLUTION_MEDIUM_ML";
    case XR_MARKER_DETECTOR_RESOLUTION_HIGH_ML: return "XR_MARKER_DETECTOR_RESOLUTION_HIGH_ML";
    default: break;
    }
    return "Unhandled XrMarkerDetectorResolutionML";
}

template <> std::string ToString<XrMarkerDetectorStatusML>(const XrMarkerDetectorStatusML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_DETECTOR_STATUS_PENDING_ML: return "XR_MARKER_DETECTOR_STATUS_PENDING_ML";
    case XR_MARKER_DETECTOR_STATUS_READY_ML: return "XR_MARKER_DETECTOR_STATUS_READY_ML";
    case XR_MARKER_DETECTOR_STATUS_ERROR_ML: return "XR_MARKER_DETECTOR_STATUS_ERROR_ML";
    default: break;
    }
    return "Unhandled XrMarkerDetectorStatusML";
}

template <> std::string ToString<XrMarkerTypeML>(const XrMarkerTypeML& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MARKER_TYPE_ARUCO_ML: return "XR_MARKER_TYPE_ARUCO_ML";
    case XR_MARKER_TYPE_APRIL_TAG_ML: return "XR_MARKER_TYPE_APRIL_TAG_ML";
    case XR_MARKER_TYPE_QR_ML: return "XR_MARKER_TYPE_QR_ML";
    case XR_MARKER_TYPE_EAN_13_ML: return "XR_MARKER_TYPE_EAN_13_ML";
    case XR_MARKER_TYPE_UPC_A_ML: return "XR_MARKER_TYPE_UPC_A_ML";
    case XR_MARKER_TYPE_CODE_128_ML: return "XR_MARKER_TYPE_CODE_128_ML";
    default: break;
    }
    return "Unhandled XrMarkerTypeML";
}

template <> std::string ToString<XrMeshComputeLodMSFT>(const XrMeshComputeLodMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_MESH_COMPUTE_LOD_COARSE_MSFT: return "XR_MESH_COMPUTE_LOD_COARSE_MSFT";
    case XR_MESH_COMPUTE_LOD_MEDIUM_MSFT: return "XR_MESH_COMPUTE_LOD_MEDIUM_MSFT";
    case XR_MESH_COMPUTE_LOD_FINE_MSFT: return "XR_MESH_COMPUTE_LOD_FINE_MSFT";
    case XR_MESH_COMPUTE_LOD_UNLIMITED_MSFT: return "XR_MESH_COMPUTE_LOD_UNLIMITED_MSFT";
    default: break;
    }
    return "Unhandled XrMeshComputeLodMSFT";
}

template <> std::string ToString<XrObjectType>(const XrObjectType& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_OBJECT_TYPE_UNKNOWN: return "XR_OBJECT_TYPE_UNKNOWN";
    case XR_OBJECT_TYPE_INSTANCE: return "XR_OBJECT_TYPE_INSTANCE";
    case XR_OBJECT_TYPE_SESSION: return "XR_OBJECT_TYPE_SESSION";
    case XR_OBJECT_TYPE_SWAPCHAIN: return "XR_OBJECT_TYPE_SWAPCHAIN";
    case XR_OBJECT_TYPE_SPACE: return "XR_OBJECT_TYPE_SPACE";
    case XR_OBJECT_TYPE_ACTION_SET: return "XR_OBJECT_TYPE_ACTION_SET";
    case XR_OBJECT_TYPE_ACTION: return "XR_OBJECT_TYPE_ACTION";
    case XR_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT: return "XR_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT";
    case XR_OBJECT_TYPE_SPATIAL_ANCHOR_MSFT: return "XR_OBJECT_TYPE_SPATIAL_ANCHOR_MSFT";
    case XR_OBJECT_TYPE_SPATIAL_GRAPH_NODE_BINDING_MSFT: return "XR_OBJECT_TYPE_SPATIAL_GRAPH_NODE_BINDING_MSFT";
    case XR_OBJECT_TYPE_HAND_TRACKER_EXT: return "XR_OBJECT_TYPE_HAND_TRACKER_EXT";
    case XR_OBJECT_TYPE_BODY_TRACKER_FB: return "XR_OBJECT_TYPE_BODY_TRACKER_FB";
    case XR_OBJECT_TYPE_SCENE_OBSERVER_MSFT: return "XR_OBJECT_TYPE_SCENE_OBSERVER_MSFT";
    case XR_OBJECT_TYPE_SCENE_MSFT: return "XR_OBJECT_TYPE_SCENE_MSFT";
    case XR_OBJECT_TYPE_FACIAL_TRACKER_HTC: return "XR_OBJECT_TYPE_FACIAL_TRACKER_HTC";
    case XR_OBJECT_TYPE_FOVEATION_PROFILE_FB: return "XR_OBJECT_TYPE_FOVEATION_PROFILE_FB";
    case XR_OBJECT_TYPE_TRIANGLE_MESH_FB: return "XR_OBJECT_TYPE_TRIANGLE_MESH_FB";
    case XR_OBJECT_TYPE_PASSTHROUGH_FB: return "XR_OBJECT_TYPE_PASSTHROUGH_FB";
    case XR_OBJECT_TYPE_PASSTHROUGH_LAYER_FB: return "XR_OBJECT_TYPE_PASSTHROUGH_LAYER_FB";
    case XR_OBJECT_TYPE_GEOMETRY_INSTANCE_FB: return "XR_OBJECT_TYPE_GEOMETRY_INSTANCE_FB";
    case XR_OBJECT_TYPE_MARKER_DETECTOR_ML: return "XR_OBJECT_TYPE_MARKER_DETECTOR_ML";
    case XR_OBJECT_TYPE_EXPORTED_LOCALIZATION_MAP_ML: return "XR_OBJECT_TYPE_EXPORTED_LOCALIZATION_MAP_ML";
    case XR_OBJECT_TYPE_SPATIAL_ANCHOR_STORE_CONNECTION_MSFT: return "XR_OBJECT_TYPE_SPATIAL_ANCHOR_STORE_CONNECTION_MSFT";
    case XR_OBJECT_TYPE_FACE_TRACKER_FB: return "XR_OBJECT_TYPE_FACE_TRACKER_FB";
    case XR_OBJECT_TYPE_EYE_TRACKER_FB: return "XR_OBJECT_TYPE_EYE_TRACKER_FB";
    case XR_OBJECT_TYPE_VIRTUAL_KEYBOARD_META: return "XR_OBJECT_TYPE_VIRTUAL_KEYBOARD_META";
    case XR_OBJECT_TYPE_SPACE_USER_FB: return "XR_OBJECT_TYPE_SPACE_USER_FB";
    case XR_OBJECT_TYPE_PASSTHROUGH_COLOR_LUT_META: return "XR_OBJECT_TYPE_PASSTHROUGH_COLOR_LUT_META";
    case XR_OBJECT_TYPE_FACE_TRACKER2_FB: return "XR_OBJECT_TYPE_FACE_TRACKER2_FB";
    case XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_PROVIDER_META: return "XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_PROVIDER_META";
    case XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_META: return "XR_OBJECT_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_META";
    case XR_OBJECT_TYPE_PASSTHROUGH_HTC: return "XR_OBJECT_TYPE_PASSTHROUGH_HTC";
    case XR_OBJECT_TYPE_PLANE_DETECTOR_EXT: return "XR_OBJECT_TYPE_PLANE_DETECTOR_EXT";
    default: break;
    }
    return "Unhandled XrObjectType";
}

std::string XrOverlayMainSessionFlagBitsEXTXToString(const XrOverlayMainSessionFlagsEXTX value)
{
    switch (value) {
    case XR_OVERLAY_MAIN_SESSION_ENABLED_COMPOSITION_LAYER_INFO_DEPTH_BIT_EXTX: return "XR_OVERLAY_MAIN_SESSION_ENABLED_COMPOSITION_LAYER_INFO_DEPTH_BIT_EXTX";
    default: break;
    }
    return "Unhandled XrOverlayMainSessionFlagBitsEXTX";
}

std::string XrOverlayMainSessionFlagsEXTXToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrOverlayMainSessionFlagsEXTX>(xrFlags, XrOverlayMainSessionFlagBitsEXTXToString);
}

std::string XrOverlaySessionCreateFlagBitsEXTXToString(const XrOverlaySessionCreateFlagsEXTX value)
{
    return "Unhandled XrOverlaySessionCreateFlagBitsEXTX";
}

std::string XrOverlaySessionCreateFlagsEXTXToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrOverlaySessionCreateFlagsEXTX>(xrFlags, XrOverlaySessionCreateFlagBitsEXTXToString);
}

std::string XrPassthroughCapabilityFlagBitsFBToString(const XrPassthroughCapabilityFlagsFB value)
{
    switch (value) {
    case XR_PASSTHROUGH_CAPABILITY_BIT_FB: return "XR_PASSTHROUGH_CAPABILITY_BIT_FB";
    case XR_PASSTHROUGH_CAPABILITY_COLOR_BIT_FB: return "XR_PASSTHROUGH_CAPABILITY_COLOR_BIT_FB";
    case XR_PASSTHROUGH_CAPABILITY_LAYER_DEPTH_BIT_FB: return "XR_PASSTHROUGH_CAPABILITY_LAYER_DEPTH_BIT_FB";
    default: break;
    }
    return "Unhandled XrPassthroughCapabilityFlagBitsFB";
}

std::string XrPassthroughCapabilityFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrPassthroughCapabilityFlagsFB>(xrFlags, XrPassthroughCapabilityFlagBitsFBToString);
}

template <> std::string ToString<XrPassthroughColorLutChannelsMETA>(const XrPassthroughColorLutChannelsMETA& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PASSTHROUGH_COLOR_LUT_CHANNELS_RGB_META: return "XR_PASSTHROUGH_COLOR_LUT_CHANNELS_RGB_META";
    case XR_PASSTHROUGH_COLOR_LUT_CHANNELS_RGBA_META: return "XR_PASSTHROUGH_COLOR_LUT_CHANNELS_RGBA_META";
    default: break;
    }
    return "Unhandled XrPassthroughColorLutChannelsMETA";
}

std::string XrPassthroughFlagBitsFBToString(const XrPassthroughFlagsFB value)
{
    switch (value) {
    case XR_PASSTHROUGH_IS_RUNNING_AT_CREATION_BIT_FB: return "XR_PASSTHROUGH_IS_RUNNING_AT_CREATION_BIT_FB";
    case XR_PASSTHROUGH_LAYER_DEPTH_BIT_FB: return "XR_PASSTHROUGH_LAYER_DEPTH_BIT_FB";
    default: break;
    }
    return "Unhandled XrPassthroughFlagBitsFB";
}

std::string XrPassthroughFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrPassthroughFlagsFB>(xrFlags, XrPassthroughFlagBitsFBToString);
}

template <> std::string ToString<XrPassthroughFormHTC>(const XrPassthroughFormHTC& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PASSTHROUGH_FORM_PLANAR_HTC: return "XR_PASSTHROUGH_FORM_PLANAR_HTC";
    case XR_PASSTHROUGH_FORM_PROJECTED_HTC: return "XR_PASSTHROUGH_FORM_PROJECTED_HTC";
    default: break;
    }
    return "Unhandled XrPassthroughFormHTC";
}

template <> std::string ToString<XrPassthroughLayerPurposeFB>(const XrPassthroughLayerPurposeFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PASSTHROUGH_LAYER_PURPOSE_RECONSTRUCTION_FB: return "XR_PASSTHROUGH_LAYER_PURPOSE_RECONSTRUCTION_FB";
    case XR_PASSTHROUGH_LAYER_PURPOSE_PROJECTED_FB: return "XR_PASSTHROUGH_LAYER_PURPOSE_PROJECTED_FB";
    case XR_PASSTHROUGH_LAYER_PURPOSE_TRACKED_KEYBOARD_HANDS_FB: return "XR_PASSTHROUGH_LAYER_PURPOSE_TRACKED_KEYBOARD_HANDS_FB";
    case XR_PASSTHROUGH_LAYER_PURPOSE_TRACKED_KEYBOARD_MASKED_HANDS_FB: return "XR_PASSTHROUGH_LAYER_PURPOSE_TRACKED_KEYBOARD_MASKED_HANDS_FB";
    default: break;
    }
    return "Unhandled XrPassthroughLayerPurposeFB";
}

std::string XrPassthroughPreferenceFlagBitsMETAToString(const XrPassthroughPreferenceFlagsMETA value)
{
    switch (value) {
    case XR_PASSTHROUGH_PREFERENCE_DEFAULT_TO_ACTIVE_BIT_META: return "XR_PASSTHROUGH_PREFERENCE_DEFAULT_TO_ACTIVE_BIT_META";
    default: break;
    }
    return "Unhandled XrPassthroughPreferenceFlagBitsMETA";
}

std::string XrPassthroughPreferenceFlagsMETAToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrPassthroughPreferenceFlagsMETA>(xrFlags, XrPassthroughPreferenceFlagBitsMETAToString);
}

std::string XrPassthroughStateChangedFlagBitsFBToString(const XrPassthroughStateChangedFlagsFB value)
{
    switch (value) {
    case XR_PASSTHROUGH_STATE_CHANGED_REINIT_REQUIRED_BIT_FB: return "XR_PASSTHROUGH_STATE_CHANGED_REINIT_REQUIRED_BIT_FB";
    case XR_PASSTHROUGH_STATE_CHANGED_NON_RECOVERABLE_ERROR_BIT_FB: return "XR_PASSTHROUGH_STATE_CHANGED_NON_RECOVERABLE_ERROR_BIT_FB";
    case XR_PASSTHROUGH_STATE_CHANGED_RECOVERABLE_ERROR_BIT_FB: return "XR_PASSTHROUGH_STATE_CHANGED_RECOVERABLE_ERROR_BIT_FB";
    case XR_PASSTHROUGH_STATE_CHANGED_RESTORED_ERROR_BIT_FB: return "XR_PASSTHROUGH_STATE_CHANGED_RESTORED_ERROR_BIT_FB";
    default: break;
    }
    return "Unhandled XrPassthroughStateChangedFlagBitsFB";
}

std::string XrPassthroughStateChangedFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrPassthroughStateChangedFlagsFB>(xrFlags, XrPassthroughStateChangedFlagBitsFBToString);
}

template <> std::string ToString<XrPerfSettingsDomainEXT>(const XrPerfSettingsDomainEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PERF_SETTINGS_DOMAIN_CPU_EXT: return "XR_PERF_SETTINGS_DOMAIN_CPU_EXT";
    case XR_PERF_SETTINGS_DOMAIN_GPU_EXT: return "XR_PERF_SETTINGS_DOMAIN_GPU_EXT";
    default: break;
    }
    return "Unhandled XrPerfSettingsDomainEXT";
}

template <> std::string ToString<XrPerfSettingsLevelEXT>(const XrPerfSettingsLevelEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PERF_SETTINGS_LEVEL_POWER_SAVINGS_EXT: return "XR_PERF_SETTINGS_LEVEL_POWER_SAVINGS_EXT";
    case XR_PERF_SETTINGS_LEVEL_SUSTAINED_LOW_EXT: return "XR_PERF_SETTINGS_LEVEL_SUSTAINED_LOW_EXT";
    case XR_PERF_SETTINGS_LEVEL_SUSTAINED_HIGH_EXT: return "XR_PERF_SETTINGS_LEVEL_SUSTAINED_HIGH_EXT";
    case XR_PERF_SETTINGS_LEVEL_BOOST_EXT: return "XR_PERF_SETTINGS_LEVEL_BOOST_EXT";
    default: break;
    }
    return "Unhandled XrPerfSettingsLevelEXT";
}

template <> std::string ToString<XrPerfSettingsNotificationLevelEXT>(const XrPerfSettingsNotificationLevelEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PERF_SETTINGS_NOTIF_LEVEL_NORMAL_EXT: return "XR_PERF_SETTINGS_NOTIF_LEVEL_NORMAL_EXT";
    case XR_PERF_SETTINGS_NOTIF_LEVEL_WARNING_EXT: return "XR_PERF_SETTINGS_NOTIF_LEVEL_WARNING_EXT";
    case XR_PERF_SETTINGS_NOTIF_LEVEL_IMPAIRED_EXT: return "XR_PERF_SETTINGS_NOTIF_LEVEL_IMPAIRED_EXT";
    default: break;
    }
    return "Unhandled XrPerfSettingsNotificationLevelEXT";
}

template <> std::string ToString<XrPerfSettingsSubDomainEXT>(const XrPerfSettingsSubDomainEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PERF_SETTINGS_SUB_DOMAIN_COMPOSITING_EXT: return "XR_PERF_SETTINGS_SUB_DOMAIN_COMPOSITING_EXT";
    case XR_PERF_SETTINGS_SUB_DOMAIN_RENDERING_EXT: return "XR_PERF_SETTINGS_SUB_DOMAIN_RENDERING_EXT";
    case XR_PERF_SETTINGS_SUB_DOMAIN_THERMAL_EXT: return "XR_PERF_SETTINGS_SUB_DOMAIN_THERMAL_EXT";
    default: break;
    }
    return "Unhandled XrPerfSettingsSubDomainEXT";
}

std::string XrPerformanceMetricsCounterFlagBitsMETAToString(const XrPerformanceMetricsCounterFlagsMETA value)
{
    switch (value) {
    case XR_PERFORMANCE_METRICS_COUNTER_ANY_VALUE_VALID_BIT_META: return "XR_PERFORMANCE_METRICS_COUNTER_ANY_VALUE_VALID_BIT_META";
    case XR_PERFORMANCE_METRICS_COUNTER_UINT_VALUE_VALID_BIT_META: return "XR_PERFORMANCE_METRICS_COUNTER_UINT_VALUE_VALID_BIT_META";
    case XR_PERFORMANCE_METRICS_COUNTER_FLOAT_VALUE_VALID_BIT_META: return "XR_PERFORMANCE_METRICS_COUNTER_FLOAT_VALUE_VALID_BIT_META";
    default: break;
    }
    return "Unhandled XrPerformanceMetricsCounterFlagBitsMETA";
}

std::string XrPerformanceMetricsCounterFlagsMETAToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrPerformanceMetricsCounterFlagsMETA>(xrFlags, XrPerformanceMetricsCounterFlagBitsMETAToString);
}

template <> std::string ToString<XrPerformanceMetricsCounterUnitMETA>(const XrPerformanceMetricsCounterUnitMETA& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PERFORMANCE_METRICS_COUNTER_UNIT_GENERIC_META: return "XR_PERFORMANCE_METRICS_COUNTER_UNIT_GENERIC_META";
    case XR_PERFORMANCE_METRICS_COUNTER_UNIT_PERCENTAGE_META: return "XR_PERFORMANCE_METRICS_COUNTER_UNIT_PERCENTAGE_META";
    case XR_PERFORMANCE_METRICS_COUNTER_UNIT_MILLISECONDS_META: return "XR_PERFORMANCE_METRICS_COUNTER_UNIT_MILLISECONDS_META";
    case XR_PERFORMANCE_METRICS_COUNTER_UNIT_BYTES_META: return "XR_PERFORMANCE_METRICS_COUNTER_UNIT_BYTES_META";
    case XR_PERFORMANCE_METRICS_COUNTER_UNIT_HERTZ_META: return "XR_PERFORMANCE_METRICS_COUNTER_UNIT_HERTZ_META";
    default: break;
    }
    return "Unhandled XrPerformanceMetricsCounterUnitMETA";
}

std::string XrPlaneDetectionCapabilityFlagBitsEXTToString(const XrPlaneDetectionCapabilityFlagsEXT value)
{
    switch (value) {
    case XR_PLANE_DETECTION_CAPABILITY_PLANE_DETECTION_BIT_EXT: return "XR_PLANE_DETECTION_CAPABILITY_PLANE_DETECTION_BIT_EXT";
    case XR_PLANE_DETECTION_CAPABILITY_PLANE_HOLES_BIT_EXT: return "XR_PLANE_DETECTION_CAPABILITY_PLANE_HOLES_BIT_EXT";
    case XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_CEILING_BIT_EXT: return "XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_CEILING_BIT_EXT";
    case XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_FLOOR_BIT_EXT: return "XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_FLOOR_BIT_EXT";
    case XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_WALL_BIT_EXT: return "XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_WALL_BIT_EXT";
    case XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_PLATFORM_BIT_EXT: return "XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_PLATFORM_BIT_EXT";
    case XR_PLANE_DETECTION_CAPABILITY_ORIENTATION_BIT_EXT: return "XR_PLANE_DETECTION_CAPABILITY_ORIENTATION_BIT_EXT";
    default: break;
    }
    return "Unhandled XrPlaneDetectionCapabilityFlagBitsEXT";
}

std::string XrPlaneDetectionCapabilityFlagsEXTToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrPlaneDetectionCapabilityFlagsEXT>(xrFlags, XrPlaneDetectionCapabilityFlagBitsEXTToString);
}

template <> std::string ToString<XrPlaneDetectionStateEXT>(const XrPlaneDetectionStateEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PLANE_DETECTION_STATE_NONE_EXT: return "XR_PLANE_DETECTION_STATE_NONE_EXT";
    case XR_PLANE_DETECTION_STATE_PENDING_EXT: return "XR_PLANE_DETECTION_STATE_PENDING_EXT";
    case XR_PLANE_DETECTION_STATE_DONE_EXT: return "XR_PLANE_DETECTION_STATE_DONE_EXT";
    case XR_PLANE_DETECTION_STATE_ERROR_EXT: return "XR_PLANE_DETECTION_STATE_ERROR_EXT";
    case XR_PLANE_DETECTION_STATE_FATAL_EXT: return "XR_PLANE_DETECTION_STATE_FATAL_EXT";
    default: break;
    }
    return "Unhandled XrPlaneDetectionStateEXT";
}

std::string XrPlaneDetectorFlagBitsEXTToString(const XrPlaneDetectorFlagsEXT value)
{
    switch (value) {
    case XR_PLANE_DETECTOR_ENABLE_CONTOUR_BIT_EXT: return "XR_PLANE_DETECTOR_ENABLE_CONTOUR_BIT_EXT";
    default: break;
    }
    return "Unhandled XrPlaneDetectorFlagBitsEXT";
}

std::string XrPlaneDetectorFlagsEXTToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrPlaneDetectorFlagsEXT>(xrFlags, XrPlaneDetectorFlagBitsEXTToString);
}

template <> std::string ToString<XrPlaneDetectorOrientationEXT>(const XrPlaneDetectorOrientationEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PLANE_DETECTOR_ORIENTATION_HORIZONTAL_UPWARD_EXT: return "XR_PLANE_DETECTOR_ORIENTATION_HORIZONTAL_UPWARD_EXT";
    case XR_PLANE_DETECTOR_ORIENTATION_HORIZONTAL_DOWNWARD_EXT: return "XR_PLANE_DETECTOR_ORIENTATION_HORIZONTAL_DOWNWARD_EXT";
    case XR_PLANE_DETECTOR_ORIENTATION_VERTICAL_EXT: return "XR_PLANE_DETECTOR_ORIENTATION_VERTICAL_EXT";
    case XR_PLANE_DETECTOR_ORIENTATION_ARBITRARY_EXT: return "XR_PLANE_DETECTOR_ORIENTATION_ARBITRARY_EXT";
    default: break;
    }
    return "Unhandled XrPlaneDetectorOrientationEXT";
}

template <> std::string ToString<XrPlaneDetectorSemanticTypeEXT>(const XrPlaneDetectorSemanticTypeEXT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_PLANE_DETECTOR_SEMANTIC_TYPE_UNDEFINED_EXT: return "XR_PLANE_DETECTOR_SEMANTIC_TYPE_UNDEFINED_EXT";
    case XR_PLANE_DETECTOR_SEMANTIC_TYPE_CEILING_EXT: return "XR_PLANE_DETECTOR_SEMANTIC_TYPE_CEILING_EXT";
    case XR_PLANE_DETECTOR_SEMANTIC_TYPE_FLOOR_EXT: return "XR_PLANE_DETECTOR_SEMANTIC_TYPE_FLOOR_EXT";
    case XR_PLANE_DETECTOR_SEMANTIC_TYPE_WALL_EXT: return "XR_PLANE_DETECTOR_SEMANTIC_TYPE_WALL_EXT";
    case XR_PLANE_DETECTOR_SEMANTIC_TYPE_PLATFORM_EXT: return "XR_PLANE_DETECTOR_SEMANTIC_TYPE_PLATFORM_EXT";
    default: break;
    }
    return "Unhandled XrPlaneDetectorSemanticTypeEXT";
}

template <> std::string ToString<XrReferenceSpaceType>(const XrReferenceSpaceType& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_REFERENCE_SPACE_TYPE_VIEW: return "XR_REFERENCE_SPACE_TYPE_VIEW";
    case XR_REFERENCE_SPACE_TYPE_LOCAL: return "XR_REFERENCE_SPACE_TYPE_LOCAL";
    case XR_REFERENCE_SPACE_TYPE_STAGE: return "XR_REFERENCE_SPACE_TYPE_STAGE";
    case XR_REFERENCE_SPACE_TYPE_LOCAL_FLOOR: return "XR_REFERENCE_SPACE_TYPE_LOCAL_FLOOR";
    case XR_REFERENCE_SPACE_TYPE_UNBOUNDED_MSFT: return "XR_REFERENCE_SPACE_TYPE_UNBOUNDED_MSFT";
    case XR_REFERENCE_SPACE_TYPE_COMBINED_EYE_VARJO: return "XR_REFERENCE_SPACE_TYPE_COMBINED_EYE_VARJO";
    case XR_REFERENCE_SPACE_TYPE_LOCALIZATION_MAP_ML: return "XR_REFERENCE_SPACE_TYPE_LOCALIZATION_MAP_ML";
    default: break;
    }
    return "Unhandled XrReferenceSpaceType";
}

std::string XrRenderModelFlagBitsFBToString(const XrRenderModelFlagsFB value)
{
    switch (value) {
    case XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_1_BIT_FB: return "XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_1_BIT_FB";
    case XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_2_BIT_FB: return "XR_RENDER_MODEL_SUPPORTS_GLTF_2_0_SUBSET_2_BIT_FB";
    default: break;
    }
    return "Unhandled XrRenderModelFlagBitsFB";
}

std::string XrRenderModelFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrRenderModelFlagsFB>(xrFlags, XrRenderModelFlagBitsFBToString);
}

template <> std::string ToString<XrReprojectionModeMSFT>(const XrReprojectionModeMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_REPROJECTION_MODE_DEPTH_MSFT: return "XR_REPROJECTION_MODE_DEPTH_MSFT";
    case XR_REPROJECTION_MODE_PLANAR_FROM_DEPTH_MSFT: return "XR_REPROJECTION_MODE_PLANAR_FROM_DEPTH_MSFT";
    case XR_REPROJECTION_MODE_PLANAR_MANUAL_MSFT: return "XR_REPROJECTION_MODE_PLANAR_MANUAL_MSFT";
    case XR_REPROJECTION_MODE_ORIENTATION_ONLY_MSFT: return "XR_REPROJECTION_MODE_ORIENTATION_ONLY_MSFT";
    default: break;
    }
    return "Unhandled XrReprojectionModeMSFT";
}

template <> std::string ToString<XrResult>(const XrResult& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SUCCESS: return "XR_SUCCESS";
    case XR_TIMEOUT_EXPIRED: return "XR_TIMEOUT_EXPIRED";
    case XR_SESSION_LOSS_PENDING: return "XR_SESSION_LOSS_PENDING";
    case XR_EVENT_UNAVAILABLE: return "XR_EVENT_UNAVAILABLE";
    case XR_SPACE_BOUNDS_UNAVAILABLE: return "XR_SPACE_BOUNDS_UNAVAILABLE";
    case XR_SESSION_NOT_FOCUSED: return "XR_SESSION_NOT_FOCUSED";
    case XR_FRAME_DISCARDED: return "XR_FRAME_DISCARDED";
    case XR_ERROR_VALIDATION_FAILURE: return "XR_ERROR_VALIDATION_FAILURE";
    case XR_ERROR_RUNTIME_FAILURE: return "XR_ERROR_RUNTIME_FAILURE";
    case XR_ERROR_OUT_OF_MEMORY: return "XR_ERROR_OUT_OF_MEMORY";
    case XR_ERROR_API_VERSION_UNSUPPORTED: return "XR_ERROR_API_VERSION_UNSUPPORTED";
    case XR_ERROR_INITIALIZATION_FAILED: return "XR_ERROR_INITIALIZATION_FAILED";
    case XR_ERROR_FUNCTION_UNSUPPORTED: return "XR_ERROR_FUNCTION_UNSUPPORTED";
    case XR_ERROR_FEATURE_UNSUPPORTED: return "XR_ERROR_FEATURE_UNSUPPORTED";
    case XR_ERROR_EXTENSION_NOT_PRESENT: return "XR_ERROR_EXTENSION_NOT_PRESENT";
    case XR_ERROR_LIMIT_REACHED: return "XR_ERROR_LIMIT_REACHED";
    case XR_ERROR_SIZE_INSUFFICIENT: return "XR_ERROR_SIZE_INSUFFICIENT";
    case XR_ERROR_HANDLE_INVALID: return "XR_ERROR_HANDLE_INVALID";
    case XR_ERROR_INSTANCE_LOST: return "XR_ERROR_INSTANCE_LOST";
    case XR_ERROR_SESSION_RUNNING: return "XR_ERROR_SESSION_RUNNING";
    case XR_ERROR_SESSION_NOT_RUNNING: return "XR_ERROR_SESSION_NOT_RUNNING";
    case XR_ERROR_SESSION_LOST: return "XR_ERROR_SESSION_LOST";
    case XR_ERROR_SYSTEM_INVALID: return "XR_ERROR_SYSTEM_INVALID";
    case XR_ERROR_PATH_INVALID: return "XR_ERROR_PATH_INVALID";
    case XR_ERROR_PATH_COUNT_EXCEEDED: return "XR_ERROR_PATH_COUNT_EXCEEDED";
    case XR_ERROR_PATH_FORMAT_INVALID: return "XR_ERROR_PATH_FORMAT_INVALID";
    case XR_ERROR_PATH_UNSUPPORTED: return "XR_ERROR_PATH_UNSUPPORTED";
    case XR_ERROR_LAYER_INVALID: return "XR_ERROR_LAYER_INVALID";
    case XR_ERROR_LAYER_LIMIT_EXCEEDED: return "XR_ERROR_LAYER_LIMIT_EXCEEDED";
    case XR_ERROR_SWAPCHAIN_RECT_INVALID: return "XR_ERROR_SWAPCHAIN_RECT_INVALID";
    case XR_ERROR_SWAPCHAIN_FORMAT_UNSUPPORTED: return "XR_ERROR_SWAPCHAIN_FORMAT_UNSUPPORTED";
    case XR_ERROR_ACTION_TYPE_MISMATCH: return "XR_ERROR_ACTION_TYPE_MISMATCH";
    case XR_ERROR_SESSION_NOT_READY: return "XR_ERROR_SESSION_NOT_READY";
    case XR_ERROR_SESSION_NOT_STOPPING: return "XR_ERROR_SESSION_NOT_STOPPING";
    case XR_ERROR_TIME_INVALID: return "XR_ERROR_TIME_INVALID";
    case XR_ERROR_REFERENCE_SPACE_UNSUPPORTED: return "XR_ERROR_REFERENCE_SPACE_UNSUPPORTED";
    case XR_ERROR_FILE_ACCESS_ERROR: return "XR_ERROR_FILE_ACCESS_ERROR";
    case XR_ERROR_FILE_CONTENTS_INVALID: return "XR_ERROR_FILE_CONTENTS_INVALID";
    case XR_ERROR_FORM_FACTOR_UNSUPPORTED: return "XR_ERROR_FORM_FACTOR_UNSUPPORTED";
    case XR_ERROR_FORM_FACTOR_UNAVAILABLE: return "XR_ERROR_FORM_FACTOR_UNAVAILABLE";
    case XR_ERROR_API_LAYER_NOT_PRESENT: return "XR_ERROR_API_LAYER_NOT_PRESENT";
    case XR_ERROR_CALL_ORDER_INVALID: return "XR_ERROR_CALL_ORDER_INVALID";
    case XR_ERROR_GRAPHICS_DEVICE_INVALID: return "XR_ERROR_GRAPHICS_DEVICE_INVALID";
    case XR_ERROR_POSE_INVALID: return "XR_ERROR_POSE_INVALID";
    case XR_ERROR_INDEX_OUT_OF_RANGE: return "XR_ERROR_INDEX_OUT_OF_RANGE";
    case XR_ERROR_VIEW_CONFIGURATION_TYPE_UNSUPPORTED: return "XR_ERROR_VIEW_CONFIGURATION_TYPE_UNSUPPORTED";
    case XR_ERROR_ENVIRONMENT_BLEND_MODE_UNSUPPORTED: return "XR_ERROR_ENVIRONMENT_BLEND_MODE_UNSUPPORTED";
    case XR_ERROR_NAME_DUPLICATED: return "XR_ERROR_NAME_DUPLICATED";
    case XR_ERROR_NAME_INVALID: return "XR_ERROR_NAME_INVALID";
    case XR_ERROR_ACTIONSET_NOT_ATTACHED: return "XR_ERROR_ACTIONSET_NOT_ATTACHED";
    case XR_ERROR_ACTIONSETS_ALREADY_ATTACHED: return "XR_ERROR_ACTIONSETS_ALREADY_ATTACHED";
    case XR_ERROR_LOCALIZED_NAME_DUPLICATED: return "XR_ERROR_LOCALIZED_NAME_DUPLICATED";
    case XR_ERROR_LOCALIZED_NAME_INVALID: return "XR_ERROR_LOCALIZED_NAME_INVALID";
    case XR_ERROR_GRAPHICS_REQUIREMENTS_CALL_MISSING: return "XR_ERROR_GRAPHICS_REQUIREMENTS_CALL_MISSING";
    case XR_ERROR_RUNTIME_UNAVAILABLE: return "XR_ERROR_RUNTIME_UNAVAILABLE";
    case XR_ERROR_EXTENSION_DEPENDENCY_NOT_ENABLED: return "XR_ERROR_EXTENSION_DEPENDENCY_NOT_ENABLED";
    case XR_ERROR_PERMISSION_INSUFFICIENT: return "XR_ERROR_PERMISSION_INSUFFICIENT";
    case XR_ERROR_ANDROID_THREAD_SETTINGS_ID_INVALID_KHR: return "XR_ERROR_ANDROID_THREAD_SETTINGS_ID_INVALID_KHR";
    case XR_ERROR_ANDROID_THREAD_SETTINGS_FAILURE_KHR: return "XR_ERROR_ANDROID_THREAD_SETTINGS_FAILURE_KHR";
    case XR_ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT: return "XR_ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT";
    case XR_ERROR_SECONDARY_VIEW_CONFIGURATION_TYPE_NOT_ENABLED_MSFT: return "XR_ERROR_SECONDARY_VIEW_CONFIGURATION_TYPE_NOT_ENABLED_MSFT";
    case XR_ERROR_CONTROLLER_MODEL_KEY_INVALID_MSFT: return "XR_ERROR_CONTROLLER_MODEL_KEY_INVALID_MSFT";
    case XR_ERROR_REPROJECTION_MODE_UNSUPPORTED_MSFT: return "XR_ERROR_REPROJECTION_MODE_UNSUPPORTED_MSFT";
    case XR_ERROR_COMPUTE_NEW_SCENE_NOT_COMPLETED_MSFT: return "XR_ERROR_COMPUTE_NEW_SCENE_NOT_COMPLETED_MSFT";
    case XR_ERROR_SCENE_COMPONENT_ID_INVALID_MSFT: return "XR_ERROR_SCENE_COMPONENT_ID_INVALID_MSFT";
    case XR_ERROR_SCENE_COMPONENT_TYPE_MISMATCH_MSFT: return "XR_ERROR_SCENE_COMPONENT_TYPE_MISMATCH_MSFT";
    case XR_ERROR_SCENE_MESH_BUFFER_ID_INVALID_MSFT: return "XR_ERROR_SCENE_MESH_BUFFER_ID_INVALID_MSFT";
    case XR_ERROR_SCENE_COMPUTE_FEATURE_INCOMPATIBLE_MSFT: return "XR_ERROR_SCENE_COMPUTE_FEATURE_INCOMPATIBLE_MSFT";
    case XR_ERROR_SCENE_COMPUTE_CONSISTENCY_MISMATCH_MSFT: return "XR_ERROR_SCENE_COMPUTE_CONSISTENCY_MISMATCH_MSFT";
    case XR_ERROR_DISPLAY_REFRESH_RATE_UNSUPPORTED_FB: return "XR_ERROR_DISPLAY_REFRESH_RATE_UNSUPPORTED_FB";
    case XR_ERROR_COLOR_SPACE_UNSUPPORTED_FB: return "XR_ERROR_COLOR_SPACE_UNSUPPORTED_FB";
    case XR_ERROR_SPACE_COMPONENT_NOT_SUPPORTED_FB: return "XR_ERROR_SPACE_COMPONENT_NOT_SUPPORTED_FB";
    case XR_ERROR_SPACE_COMPONENT_NOT_ENABLED_FB: return "XR_ERROR_SPACE_COMPONENT_NOT_ENABLED_FB";
    case XR_ERROR_SPACE_COMPONENT_STATUS_PENDING_FB: return "XR_ERROR_SPACE_COMPONENT_STATUS_PENDING_FB";
    case XR_ERROR_SPACE_COMPONENT_STATUS_ALREADY_SET_FB: return "XR_ERROR_SPACE_COMPONENT_STATUS_ALREADY_SET_FB";
    case XR_ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB: return "XR_ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB";
    case XR_ERROR_FEATURE_ALREADY_CREATED_PASSTHROUGH_FB: return "XR_ERROR_FEATURE_ALREADY_CREATED_PASSTHROUGH_FB";
    case XR_ERROR_FEATURE_REQUIRED_PASSTHROUGH_FB: return "XR_ERROR_FEATURE_REQUIRED_PASSTHROUGH_FB";
    case XR_ERROR_NOT_PERMITTED_PASSTHROUGH_FB: return "XR_ERROR_NOT_PERMITTED_PASSTHROUGH_FB";
    case XR_ERROR_INSUFFICIENT_RESOURCES_PASSTHROUGH_FB: return "XR_ERROR_INSUFFICIENT_RESOURCES_PASSTHROUGH_FB";
    case XR_ERROR_UNKNOWN_PASSTHROUGH_FB: return "XR_ERROR_UNKNOWN_PASSTHROUGH_FB";
    case XR_ERROR_RENDER_MODEL_KEY_INVALID_FB: return "XR_ERROR_RENDER_MODEL_KEY_INVALID_FB";
    case XR_RENDER_MODEL_UNAVAILABLE_FB: return "XR_RENDER_MODEL_UNAVAILABLE_FB";
    case XR_ERROR_MARKER_NOT_TRACKED_VARJO: return "XR_ERROR_MARKER_NOT_TRACKED_VARJO";
    case XR_ERROR_MARKER_ID_INVALID_VARJO: return "XR_ERROR_MARKER_ID_INVALID_VARJO";
    case XR_ERROR_MARKER_DETECTOR_PERMISSION_DENIED_ML: return "XR_ERROR_MARKER_DETECTOR_PERMISSION_DENIED_ML";
    case XR_ERROR_MARKER_DETECTOR_LOCATE_FAILED_ML: return "XR_ERROR_MARKER_DETECTOR_LOCATE_FAILED_ML";
    case XR_ERROR_MARKER_DETECTOR_INVALID_DATA_QUERY_ML: return "XR_ERROR_MARKER_DETECTOR_INVALID_DATA_QUERY_ML";
    case XR_ERROR_MARKER_DETECTOR_INVALID_CREATE_INFO_ML: return "XR_ERROR_MARKER_DETECTOR_INVALID_CREATE_INFO_ML";
    case XR_ERROR_MARKER_INVALID_ML: return "XR_ERROR_MARKER_INVALID_ML";
    case XR_ERROR_LOCALIZATION_MAP_INCOMPATIBLE_ML: return "XR_ERROR_LOCALIZATION_MAP_INCOMPATIBLE_ML";
    case XR_ERROR_LOCALIZATION_MAP_UNAVAILABLE_ML: return "XR_ERROR_LOCALIZATION_MAP_UNAVAILABLE_ML";
    case XR_ERROR_LOCALIZATION_MAP_FAIL_ML: return "XR_ERROR_LOCALIZATION_MAP_FAIL_ML";
    case XR_ERROR_LOCALIZATION_MAP_IMPORT_EXPORT_PERMISSION_DENIED_ML: return "XR_ERROR_LOCALIZATION_MAP_IMPORT_EXPORT_PERMISSION_DENIED_ML";
    case XR_ERROR_LOCALIZATION_MAP_PERMISSION_DENIED_ML: return "XR_ERROR_LOCALIZATION_MAP_PERMISSION_DENIED_ML";
    case XR_ERROR_LOCALIZATION_MAP_ALREADY_EXISTS_ML: return "XR_ERROR_LOCALIZATION_MAP_ALREADY_EXISTS_ML";
    case XR_ERROR_LOCALIZATION_MAP_CANNOT_EXPORT_CLOUD_MAP_ML: return "XR_ERROR_LOCALIZATION_MAP_CANNOT_EXPORT_CLOUD_MAP_ML";
    case XR_ERROR_SPATIAL_ANCHOR_NAME_NOT_FOUND_MSFT: return "XR_ERROR_SPATIAL_ANCHOR_NAME_NOT_FOUND_MSFT";
    case XR_ERROR_SPATIAL_ANCHOR_NAME_INVALID_MSFT: return "XR_ERROR_SPATIAL_ANCHOR_NAME_INVALID_MSFT";
    case XR_SCENE_MARKER_DATA_NOT_STRING_MSFT: return "XR_SCENE_MARKER_DATA_NOT_STRING_MSFT";
    case XR_ERROR_SPACE_MAPPING_INSUFFICIENT_FB: return "XR_ERROR_SPACE_MAPPING_INSUFFICIENT_FB";
    case XR_ERROR_SPACE_LOCALIZATION_FAILED_FB: return "XR_ERROR_SPACE_LOCALIZATION_FAILED_FB";
    case XR_ERROR_SPACE_NETWORK_TIMEOUT_FB: return "XR_ERROR_SPACE_NETWORK_TIMEOUT_FB";
    case XR_ERROR_SPACE_NETWORK_REQUEST_FAILED_FB: return "XR_ERROR_SPACE_NETWORK_REQUEST_FAILED_FB";
    case XR_ERROR_SPACE_CLOUD_STORAGE_DISABLED_FB: return "XR_ERROR_SPACE_CLOUD_STORAGE_DISABLED_FB";
    case XR_ERROR_PASSTHROUGH_COLOR_LUT_BUFFER_SIZE_MISMATCH_META: return "XR_ERROR_PASSTHROUGH_COLOR_LUT_BUFFER_SIZE_MISMATCH_META";
    case XR_ENVIRONMENT_DEPTH_NOT_AVAILABLE_META: return "XR_ENVIRONMENT_DEPTH_NOT_AVAILABLE_META";
    case XR_ERROR_HINT_ALREADY_SET_QCOM: return "XR_ERROR_HINT_ALREADY_SET_QCOM";
    case XR_ERROR_NOT_AN_ANCHOR_HTC: return "XR_ERROR_NOT_AN_ANCHOR_HTC";
    case XR_ERROR_SPACE_NOT_LOCATABLE_EXT: return "XR_ERROR_SPACE_NOT_LOCATABLE_EXT";
    case XR_ERROR_PLANE_DETECTION_PERMISSION_DENIED_EXT: return "XR_ERROR_PLANE_DETECTION_PERMISSION_DENIED_EXT";
    case XR_ERROR_FUTURE_PENDING_EXT: return "XR_ERROR_FUTURE_PENDING_EXT";
    case XR_ERROR_FUTURE_INVALID_EXT: return "XR_ERROR_FUTURE_INVALID_EXT";
    default: break;
    }
    return "Unhandled XrResult";
}

template <> std::string ToString<XrSceneComponentTypeMSFT>(const XrSceneComponentTypeMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SCENE_COMPONENT_TYPE_INVALID_MSFT: return "XR_SCENE_COMPONENT_TYPE_INVALID_MSFT";
    case XR_SCENE_COMPONENT_TYPE_OBJECT_MSFT: return "XR_SCENE_COMPONENT_TYPE_OBJECT_MSFT";
    case XR_SCENE_COMPONENT_TYPE_PLANE_MSFT: return "XR_SCENE_COMPONENT_TYPE_PLANE_MSFT";
    case XR_SCENE_COMPONENT_TYPE_VISUAL_MESH_MSFT: return "XR_SCENE_COMPONENT_TYPE_VISUAL_MESH_MSFT";
    case XR_SCENE_COMPONENT_TYPE_COLLIDER_MESH_MSFT: return "XR_SCENE_COMPONENT_TYPE_COLLIDER_MESH_MSFT";
    case XR_SCENE_COMPONENT_TYPE_SERIALIZED_SCENE_FRAGMENT_MSFT: return "XR_SCENE_COMPONENT_TYPE_SERIALIZED_SCENE_FRAGMENT_MSFT";
    case XR_SCENE_COMPONENT_TYPE_MARKER_MSFT: return "XR_SCENE_COMPONENT_TYPE_MARKER_MSFT";
    default: break;
    }
    return "Unhandled XrSceneComponentTypeMSFT";
}

template <> std::string ToString<XrSceneComputeConsistencyMSFT>(const XrSceneComputeConsistencyMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SCENE_COMPUTE_CONSISTENCY_SNAPSHOT_COMPLETE_MSFT: return "XR_SCENE_COMPUTE_CONSISTENCY_SNAPSHOT_COMPLETE_MSFT";
    case XR_SCENE_COMPUTE_CONSISTENCY_SNAPSHOT_INCOMPLETE_FAST_MSFT: return "XR_SCENE_COMPUTE_CONSISTENCY_SNAPSHOT_INCOMPLETE_FAST_MSFT";
    case XR_SCENE_COMPUTE_CONSISTENCY_OCCLUSION_OPTIMIZED_MSFT: return "XR_SCENE_COMPUTE_CONSISTENCY_OCCLUSION_OPTIMIZED_MSFT";
    default: break;
    }
    return "Unhandled XrSceneComputeConsistencyMSFT";
}

template <> std::string ToString<XrSceneComputeFeatureMSFT>(const XrSceneComputeFeatureMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SCENE_COMPUTE_FEATURE_PLANE_MSFT: return "XR_SCENE_COMPUTE_FEATURE_PLANE_MSFT";
    case XR_SCENE_COMPUTE_FEATURE_PLANE_MESH_MSFT: return "XR_SCENE_COMPUTE_FEATURE_PLANE_MESH_MSFT";
    case XR_SCENE_COMPUTE_FEATURE_VISUAL_MESH_MSFT: return "XR_SCENE_COMPUTE_FEATURE_VISUAL_MESH_MSFT";
    case XR_SCENE_COMPUTE_FEATURE_COLLIDER_MESH_MSFT: return "XR_SCENE_COMPUTE_FEATURE_COLLIDER_MESH_MSFT";
    case XR_SCENE_COMPUTE_FEATURE_SERIALIZE_SCENE_MSFT: return "XR_SCENE_COMPUTE_FEATURE_SERIALIZE_SCENE_MSFT";
    case XR_SCENE_COMPUTE_FEATURE_MARKER_MSFT: return "XR_SCENE_COMPUTE_FEATURE_MARKER_MSFT";
    default: break;
    }
    return "Unhandled XrSceneComputeFeatureMSFT";
}

template <> std::string ToString<XrSceneComputeStateMSFT>(const XrSceneComputeStateMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SCENE_COMPUTE_STATE_NONE_MSFT: return "XR_SCENE_COMPUTE_STATE_NONE_MSFT";
    case XR_SCENE_COMPUTE_STATE_UPDATING_MSFT: return "XR_SCENE_COMPUTE_STATE_UPDATING_MSFT";
    case XR_SCENE_COMPUTE_STATE_COMPLETED_MSFT: return "XR_SCENE_COMPUTE_STATE_COMPLETED_MSFT";
    case XR_SCENE_COMPUTE_STATE_COMPLETED_WITH_ERROR_MSFT: return "XR_SCENE_COMPUTE_STATE_COMPLETED_WITH_ERROR_MSFT";
    default: break;
    }
    return "Unhandled XrSceneComputeStateMSFT";
}

template <> std::string ToString<XrSceneMarkerQRCodeSymbolTypeMSFT>(const XrSceneMarkerQRCodeSymbolTypeMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SCENE_MARKER_QR_CODE_SYMBOL_TYPE_QR_CODE_MSFT: return "XR_SCENE_MARKER_QR_CODE_SYMBOL_TYPE_QR_CODE_MSFT";
    case XR_SCENE_MARKER_QR_CODE_SYMBOL_TYPE_MICRO_QR_CODE_MSFT: return "XR_SCENE_MARKER_QR_CODE_SYMBOL_TYPE_MICRO_QR_CODE_MSFT";
    default: break;
    }
    return "Unhandled XrSceneMarkerQRCodeSymbolTypeMSFT";
}

template <> std::string ToString<XrSceneMarkerTypeMSFT>(const XrSceneMarkerTypeMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SCENE_MARKER_TYPE_QR_CODE_MSFT: return "XR_SCENE_MARKER_TYPE_QR_CODE_MSFT";
    default: break;
    }
    return "Unhandled XrSceneMarkerTypeMSFT";
}

template <> std::string ToString<XrSceneObjectTypeMSFT>(const XrSceneObjectTypeMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SCENE_OBJECT_TYPE_UNCATEGORIZED_MSFT: return "XR_SCENE_OBJECT_TYPE_UNCATEGORIZED_MSFT";
    case XR_SCENE_OBJECT_TYPE_BACKGROUND_MSFT: return "XR_SCENE_OBJECT_TYPE_BACKGROUND_MSFT";
    case XR_SCENE_OBJECT_TYPE_WALL_MSFT: return "XR_SCENE_OBJECT_TYPE_WALL_MSFT";
    case XR_SCENE_OBJECT_TYPE_FLOOR_MSFT: return "XR_SCENE_OBJECT_TYPE_FLOOR_MSFT";
    case XR_SCENE_OBJECT_TYPE_CEILING_MSFT: return "XR_SCENE_OBJECT_TYPE_CEILING_MSFT";
    case XR_SCENE_OBJECT_TYPE_PLATFORM_MSFT: return "XR_SCENE_OBJECT_TYPE_PLATFORM_MSFT";
    case XR_SCENE_OBJECT_TYPE_INFERRED_MSFT: return "XR_SCENE_OBJECT_TYPE_INFERRED_MSFT";
    default: break;
    }
    return "Unhandled XrSceneObjectTypeMSFT";
}

template <> std::string ToString<XrScenePlaneAlignmentTypeMSFT>(const XrScenePlaneAlignmentTypeMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SCENE_PLANE_ALIGNMENT_TYPE_NON_ORTHOGONAL_MSFT: return "XR_SCENE_PLANE_ALIGNMENT_TYPE_NON_ORTHOGONAL_MSFT";
    case XR_SCENE_PLANE_ALIGNMENT_TYPE_HORIZONTAL_MSFT: return "XR_SCENE_PLANE_ALIGNMENT_TYPE_HORIZONTAL_MSFT";
    case XR_SCENE_PLANE_ALIGNMENT_TYPE_VERTICAL_MSFT: return "XR_SCENE_PLANE_ALIGNMENT_TYPE_VERTICAL_MSFT";
    default: break;
    }
    return "Unhandled XrScenePlaneAlignmentTypeMSFT";
}

std::string XrSemanticLabelsSupportFlagBitsFBToString(const XrSemanticLabelsSupportFlagsFB value)
{
    switch (value) {
    case XR_SEMANTIC_LABELS_SUPPORT_MULTIPLE_SEMANTIC_LABELS_BIT_FB: return "XR_SEMANTIC_LABELS_SUPPORT_MULTIPLE_SEMANTIC_LABELS_BIT_FB";
    case XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_DESK_TO_TABLE_MIGRATION_BIT_FB: return "XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_DESK_TO_TABLE_MIGRATION_BIT_FB";
    case XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_INVISIBLE_WALL_FACE_BIT_FB: return "XR_SEMANTIC_LABELS_SUPPORT_ACCEPT_INVISIBLE_WALL_FACE_BIT_FB";
    default: break;
    }
    return "Unhandled XrSemanticLabelsSupportFlagBitsFB";
}

std::string XrSemanticLabelsSupportFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrSemanticLabelsSupportFlagsFB>(xrFlags, XrSemanticLabelsSupportFlagBitsFBToString);
}

std::string XrSessionCreateFlagBitsToString(const XrSessionCreateFlags value)
{
    return "Unhandled XrSessionCreateFlagBits";
}

std::string XrSessionCreateFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrSessionCreateFlags>(xrFlags, XrSessionCreateFlagBitsToString);
}

template <> std::string ToString<XrSessionState>(const XrSessionState& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SESSION_STATE_UNKNOWN: return "XR_SESSION_STATE_UNKNOWN";
    case XR_SESSION_STATE_IDLE: return "XR_SESSION_STATE_IDLE";
    case XR_SESSION_STATE_READY: return "XR_SESSION_STATE_READY";
    case XR_SESSION_STATE_SYNCHRONIZED: return "XR_SESSION_STATE_SYNCHRONIZED";
    case XR_SESSION_STATE_VISIBLE: return "XR_SESSION_STATE_VISIBLE";
    case XR_SESSION_STATE_FOCUSED: return "XR_SESSION_STATE_FOCUSED";
    case XR_SESSION_STATE_STOPPING: return "XR_SESSION_STATE_STOPPING";
    case XR_SESSION_STATE_LOSS_PENDING: return "XR_SESSION_STATE_LOSS_PENDING";
    case XR_SESSION_STATE_EXITING: return "XR_SESSION_STATE_EXITING";
    default: break;
    }
    return "Unhandled XrSessionState";
}

template <> std::string ToString<XrSpaceComponentTypeFB>(const XrSpaceComponentTypeFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SPACE_COMPONENT_TYPE_LOCATABLE_FB: return "XR_SPACE_COMPONENT_TYPE_LOCATABLE_FB";
    case XR_SPACE_COMPONENT_TYPE_STORABLE_FB: return "XR_SPACE_COMPONENT_TYPE_STORABLE_FB";
    case XR_SPACE_COMPONENT_TYPE_SHARABLE_FB: return "XR_SPACE_COMPONENT_TYPE_SHARABLE_FB";
    case XR_SPACE_COMPONENT_TYPE_BOUNDED_2D_FB: return "XR_SPACE_COMPONENT_TYPE_BOUNDED_2D_FB";
    case XR_SPACE_COMPONENT_TYPE_BOUNDED_3D_FB: return "XR_SPACE_COMPONENT_TYPE_BOUNDED_3D_FB";
    case XR_SPACE_COMPONENT_TYPE_SEMANTIC_LABELS_FB: return "XR_SPACE_COMPONENT_TYPE_SEMANTIC_LABELS_FB";
    case XR_SPACE_COMPONENT_TYPE_ROOM_LAYOUT_FB: return "XR_SPACE_COMPONENT_TYPE_ROOM_LAYOUT_FB";
    case XR_SPACE_COMPONENT_TYPE_SPACE_CONTAINER_FB: return "XR_SPACE_COMPONENT_TYPE_SPACE_CONTAINER_FB";
    case XR_SPACE_COMPONENT_TYPE_TRIANGLE_MESH_META: return "XR_SPACE_COMPONENT_TYPE_TRIANGLE_MESH_META";
    default: break;
    }
    return "Unhandled XrSpaceComponentTypeFB";
}

std::string XrSpaceLocationFlagBitsToString(const XrSpaceLocationFlags value)
{
    switch (value) {
    case XR_SPACE_LOCATION_ORIENTATION_VALID_BIT: return "XR_SPACE_LOCATION_ORIENTATION_VALID_BIT";
    case XR_SPACE_LOCATION_POSITION_VALID_BIT: return "XR_SPACE_LOCATION_POSITION_VALID_BIT";
    case XR_SPACE_LOCATION_ORIENTATION_TRACKED_BIT: return "XR_SPACE_LOCATION_ORIENTATION_TRACKED_BIT";
    case XR_SPACE_LOCATION_POSITION_TRACKED_BIT: return "XR_SPACE_LOCATION_POSITION_TRACKED_BIT";
    default: break;
    }
    return "Unhandled XrSpaceLocationFlagBits";
}

std::string XrSpaceLocationFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrSpaceLocationFlags>(xrFlags, XrSpaceLocationFlagBitsToString);
}

template <> std::string ToString<XrSpacePersistenceModeFB>(const XrSpacePersistenceModeFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SPACE_PERSISTENCE_MODE_INVALID_FB: return "XR_SPACE_PERSISTENCE_MODE_INVALID_FB";
    case XR_SPACE_PERSISTENCE_MODE_INDEFINITE_FB: return "XR_SPACE_PERSISTENCE_MODE_INDEFINITE_FB";
    default: break;
    }
    return "Unhandled XrSpacePersistenceModeFB";
}

template <> std::string ToString<XrSpaceQueryActionFB>(const XrSpaceQueryActionFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SPACE_QUERY_ACTION_LOAD_FB: return "XR_SPACE_QUERY_ACTION_LOAD_FB";
    default: break;
    }
    return "Unhandled XrSpaceQueryActionFB";
}

template <> std::string ToString<XrSpaceStorageLocationFB>(const XrSpaceStorageLocationFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SPACE_STORAGE_LOCATION_INVALID_FB: return "XR_SPACE_STORAGE_LOCATION_INVALID_FB";
    case XR_SPACE_STORAGE_LOCATION_LOCAL_FB: return "XR_SPACE_STORAGE_LOCATION_LOCAL_FB";
    case XR_SPACE_STORAGE_LOCATION_CLOUD_FB: return "XR_SPACE_STORAGE_LOCATION_CLOUD_FB";
    default: break;
    }
    return "Unhandled XrSpaceStorageLocationFB";
}

std::string XrSpaceVelocityFlagBitsToString(const XrSpaceVelocityFlags value)
{
    switch (value) {
    case XR_SPACE_VELOCITY_LINEAR_VALID_BIT: return "XR_SPACE_VELOCITY_LINEAR_VALID_BIT";
    case XR_SPACE_VELOCITY_ANGULAR_VALID_BIT: return "XR_SPACE_VELOCITY_ANGULAR_VALID_BIT";
    default: break;
    }
    return "Unhandled XrSpaceVelocityFlagBits";
}

std::string XrSpaceVelocityFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrSpaceVelocityFlags>(xrFlags, XrSpaceVelocityFlagBitsToString);
}

template <> std::string ToString<XrSpatialGraphNodeTypeMSFT>(const XrSpatialGraphNodeTypeMSFT& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_SPATIAL_GRAPH_NODE_TYPE_STATIC_MSFT: return "XR_SPATIAL_GRAPH_NODE_TYPE_STATIC_MSFT";
    case XR_SPATIAL_GRAPH_NODE_TYPE_DYNAMIC_MSFT: return "XR_SPATIAL_GRAPH_NODE_TYPE_DYNAMIC_MSFT";
    default: break;
    }
    return "Unhandled XrSpatialGraphNodeTypeMSFT";
}

template <> std::string ToString<XrStructureType>(const XrStructureType& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_TYPE_UNKNOWN: return "XR_TYPE_UNKNOWN";
    case XR_TYPE_API_LAYER_PROPERTIES: return "XR_TYPE_API_LAYER_PROPERTIES";
    case XR_TYPE_EXTENSION_PROPERTIES: return "XR_TYPE_EXTENSION_PROPERTIES";
    case XR_TYPE_INSTANCE_CREATE_INFO: return "XR_TYPE_INSTANCE_CREATE_INFO";
    case XR_TYPE_SYSTEM_GET_INFO: return "XR_TYPE_SYSTEM_GET_INFO";
    case XR_TYPE_SYSTEM_PROPERTIES: return "XR_TYPE_SYSTEM_PROPERTIES";
    case XR_TYPE_VIEW_LOCATE_INFO: return "XR_TYPE_VIEW_LOCATE_INFO";
    case XR_TYPE_VIEW: return "XR_TYPE_VIEW";
    case XR_TYPE_SESSION_CREATE_INFO: return "XR_TYPE_SESSION_CREATE_INFO";
    case XR_TYPE_SWAPCHAIN_CREATE_INFO: return "XR_TYPE_SWAPCHAIN_CREATE_INFO";
    case XR_TYPE_SESSION_BEGIN_INFO: return "XR_TYPE_SESSION_BEGIN_INFO";
    case XR_TYPE_VIEW_STATE: return "XR_TYPE_VIEW_STATE";
    case XR_TYPE_FRAME_END_INFO: return "XR_TYPE_FRAME_END_INFO";
    case XR_TYPE_HAPTIC_VIBRATION: return "XR_TYPE_HAPTIC_VIBRATION";
    case XR_TYPE_EVENT_DATA_BUFFER: return "XR_TYPE_EVENT_DATA_BUFFER";
    case XR_TYPE_EVENT_DATA_INSTANCE_LOSS_PENDING: return "XR_TYPE_EVENT_DATA_INSTANCE_LOSS_PENDING";
    case XR_TYPE_EVENT_DATA_SESSION_STATE_CHANGED: return "XR_TYPE_EVENT_DATA_SESSION_STATE_CHANGED";
    case XR_TYPE_ACTION_STATE_BOOLEAN: return "XR_TYPE_ACTION_STATE_BOOLEAN";
    case XR_TYPE_ACTION_STATE_FLOAT: return "XR_TYPE_ACTION_STATE_FLOAT";
    case XR_TYPE_ACTION_STATE_VECTOR2F: return "XR_TYPE_ACTION_STATE_VECTOR2F";
    case XR_TYPE_ACTION_STATE_POSE: return "XR_TYPE_ACTION_STATE_POSE";
    case XR_TYPE_ACTION_SET_CREATE_INFO: return "XR_TYPE_ACTION_SET_CREATE_INFO";
    case XR_TYPE_ACTION_CREATE_INFO: return "XR_TYPE_ACTION_CREATE_INFO";
    case XR_TYPE_INSTANCE_PROPERTIES: return "XR_TYPE_INSTANCE_PROPERTIES";
    case XR_TYPE_FRAME_WAIT_INFO: return "XR_TYPE_FRAME_WAIT_INFO";
    case XR_TYPE_COMPOSITION_LAYER_PROJECTION: return "XR_TYPE_COMPOSITION_LAYER_PROJECTION";
    case XR_TYPE_COMPOSITION_LAYER_QUAD: return "XR_TYPE_COMPOSITION_LAYER_QUAD";
    case XR_TYPE_REFERENCE_SPACE_CREATE_INFO: return "XR_TYPE_REFERENCE_SPACE_CREATE_INFO";
    case XR_TYPE_ACTION_SPACE_CREATE_INFO: return "XR_TYPE_ACTION_SPACE_CREATE_INFO";
    case XR_TYPE_EVENT_DATA_REFERENCE_SPACE_CHANGE_PENDING: return "XR_TYPE_EVENT_DATA_REFERENCE_SPACE_CHANGE_PENDING";
    case XR_TYPE_VIEW_CONFIGURATION_VIEW: return "XR_TYPE_VIEW_CONFIGURATION_VIEW";
    case XR_TYPE_SPACE_LOCATION: return "XR_TYPE_SPACE_LOCATION";
    case XR_TYPE_SPACE_VELOCITY: return "XR_TYPE_SPACE_VELOCITY";
    case XR_TYPE_FRAME_STATE: return "XR_TYPE_FRAME_STATE";
    case XR_TYPE_VIEW_CONFIGURATION_PROPERTIES: return "XR_TYPE_VIEW_CONFIGURATION_PROPERTIES";
    case XR_TYPE_FRAME_BEGIN_INFO: return "XR_TYPE_FRAME_BEGIN_INFO";
    case XR_TYPE_COMPOSITION_LAYER_PROJECTION_VIEW: return "XR_TYPE_COMPOSITION_LAYER_PROJECTION_VIEW";
    case XR_TYPE_EVENT_DATA_EVENTS_LOST: return "XR_TYPE_EVENT_DATA_EVENTS_LOST";
    case XR_TYPE_INTERACTION_PROFILE_SUGGESTED_BINDING: return "XR_TYPE_INTERACTION_PROFILE_SUGGESTED_BINDING";
    case XR_TYPE_EVENT_DATA_INTERACTION_PROFILE_CHANGED: return "XR_TYPE_EVENT_DATA_INTERACTION_PROFILE_CHANGED";
    case XR_TYPE_INTERACTION_PROFILE_STATE: return "XR_TYPE_INTERACTION_PROFILE_STATE";
    case XR_TYPE_SWAPCHAIN_IMAGE_ACQUIRE_INFO: return "XR_TYPE_SWAPCHAIN_IMAGE_ACQUIRE_INFO";
    case XR_TYPE_SWAPCHAIN_IMAGE_WAIT_INFO: return "XR_TYPE_SWAPCHAIN_IMAGE_WAIT_INFO";
    case XR_TYPE_SWAPCHAIN_IMAGE_RELEASE_INFO: return "XR_TYPE_SWAPCHAIN_IMAGE_RELEASE_INFO";
    case XR_TYPE_ACTION_STATE_GET_INFO: return "XR_TYPE_ACTION_STATE_GET_INFO";
    case XR_TYPE_HAPTIC_ACTION_INFO: return "XR_TYPE_HAPTIC_ACTION_INFO";
    case XR_TYPE_SESSION_ACTION_SETS_ATTACH_INFO: return "XR_TYPE_SESSION_ACTION_SETS_ATTACH_INFO";
    case XR_TYPE_ACTIONS_SYNC_INFO: return "XR_TYPE_ACTIONS_SYNC_INFO";
    case XR_TYPE_BOUND_SOURCES_FOR_ACTION_ENUMERATE_INFO: return "XR_TYPE_BOUND_SOURCES_FOR_ACTION_ENUMERATE_INFO";
    case XR_TYPE_INPUT_SOURCE_LOCALIZED_NAME_GET_INFO: return "XR_TYPE_INPUT_SOURCE_LOCALIZED_NAME_GET_INFO";
    case XR_TYPE_SPACES_LOCATE_INFO: return "XR_TYPE_SPACES_LOCATE_INFO";
    case XR_TYPE_SPACE_LOCATIONS: return "XR_TYPE_SPACE_LOCATIONS";
    case XR_TYPE_SPACE_VELOCITIES: return "XR_TYPE_SPACE_VELOCITIES";
    case XR_TYPE_COMPOSITION_LAYER_CUBE_KHR: return "XR_TYPE_COMPOSITION_LAYER_CUBE_KHR";
    case XR_TYPE_INSTANCE_CREATE_INFO_ANDROID_KHR: return "XR_TYPE_INSTANCE_CREATE_INFO_ANDROID_KHR";
    case XR_TYPE_COMPOSITION_LAYER_DEPTH_INFO_KHR: return "XR_TYPE_COMPOSITION_LAYER_DEPTH_INFO_KHR";
    case XR_TYPE_VULKAN_SWAPCHAIN_FORMAT_LIST_CREATE_INFO_KHR: return "XR_TYPE_VULKAN_SWAPCHAIN_FORMAT_LIST_CREATE_INFO_KHR";
    case XR_TYPE_EVENT_DATA_PERF_SETTINGS_EXT: return "XR_TYPE_EVENT_DATA_PERF_SETTINGS_EXT";
    case XR_TYPE_COMPOSITION_LAYER_CYLINDER_KHR: return "XR_TYPE_COMPOSITION_LAYER_CYLINDER_KHR";
    case XR_TYPE_COMPOSITION_LAYER_EQUIRECT_KHR: return "XR_TYPE_COMPOSITION_LAYER_EQUIRECT_KHR";
    case XR_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: return "XR_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT";
    case XR_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT: return "XR_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT";
    case XR_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: return "XR_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT";
    case XR_TYPE_DEBUG_UTILS_LABEL_EXT: return "XR_TYPE_DEBUG_UTILS_LABEL_EXT";
    case XR_TYPE_GRAPHICS_BINDING_OPENGL_WIN32_KHR: return "XR_TYPE_GRAPHICS_BINDING_OPENGL_WIN32_KHR";
    case XR_TYPE_GRAPHICS_BINDING_OPENGL_XLIB_KHR: return "XR_TYPE_GRAPHICS_BINDING_OPENGL_XLIB_KHR";
    case XR_TYPE_GRAPHICS_BINDING_OPENGL_XCB_KHR: return "XR_TYPE_GRAPHICS_BINDING_OPENGL_XCB_KHR";
    case XR_TYPE_GRAPHICS_BINDING_OPENGL_WAYLAND_KHR: return "XR_TYPE_GRAPHICS_BINDING_OPENGL_WAYLAND_KHR";
    case XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_KHR: return "XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_KHR";
    case XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_KHR: return "XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_KHR";
    case XR_TYPE_GRAPHICS_BINDING_OPENGL_ES_ANDROID_KHR: return "XR_TYPE_GRAPHICS_BINDING_OPENGL_ES_ANDROID_KHR";
    case XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_ES_KHR: return "XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_ES_KHR";
    case XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_ES_KHR: return "XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_ES_KHR";
    case XR_TYPE_GRAPHICS_BINDING_VULKAN_KHR: return "XR_TYPE_GRAPHICS_BINDING_VULKAN_KHR";
    case XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR: return "XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR";
    case XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN_KHR: return "XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN_KHR";
    case XR_TYPE_GRAPHICS_BINDING_D3D11_KHR: return "XR_TYPE_GRAPHICS_BINDING_D3D11_KHR";
    case XR_TYPE_SWAPCHAIN_IMAGE_D3D11_KHR: return "XR_TYPE_SWAPCHAIN_IMAGE_D3D11_KHR";
    case XR_TYPE_GRAPHICS_REQUIREMENTS_D3D11_KHR: return "XR_TYPE_GRAPHICS_REQUIREMENTS_D3D11_KHR";
    case XR_TYPE_GRAPHICS_BINDING_D3D12_KHR: return "XR_TYPE_GRAPHICS_BINDING_D3D12_KHR";
    case XR_TYPE_SWAPCHAIN_IMAGE_D3D12_KHR: return "XR_TYPE_SWAPCHAIN_IMAGE_D3D12_KHR";
    case XR_TYPE_GRAPHICS_REQUIREMENTS_D3D12_KHR: return "XR_TYPE_GRAPHICS_REQUIREMENTS_D3D12_KHR";
    case XR_TYPE_GRAPHICS_BINDING_METAL_KHR: return "XR_TYPE_GRAPHICS_BINDING_METAL_KHR";
    case XR_TYPE_SWAPCHAIN_IMAGE_METAL_KHR: return "XR_TYPE_SWAPCHAIN_IMAGE_METAL_KHR";
    case XR_TYPE_GRAPHICS_REQUIREMENTS_METAL_KHR: return "XR_TYPE_GRAPHICS_REQUIREMENTS_METAL_KHR";
    case XR_TYPE_SYSTEM_EYE_GAZE_INTERACTION_PROPERTIES_EXT: return "XR_TYPE_SYSTEM_EYE_GAZE_INTERACTION_PROPERTIES_EXT";
    case XR_TYPE_EYE_GAZE_SAMPLE_TIME_EXT: return "XR_TYPE_EYE_GAZE_SAMPLE_TIME_EXT";
    case XR_TYPE_VISIBILITY_MASK_KHR: return "XR_TYPE_VISIBILITY_MASK_KHR";
    case XR_TYPE_EVENT_DATA_VISIBILITY_MASK_CHANGED_KHR: return "XR_TYPE_EVENT_DATA_VISIBILITY_MASK_CHANGED_KHR";
    case XR_TYPE_SESSION_CREATE_INFO_OVERLAY_EXTX: return "XR_TYPE_SESSION_CREATE_INFO_OVERLAY_EXTX";
    case XR_TYPE_EVENT_DATA_MAIN_SESSION_VISIBILITY_CHANGED_EXTX: return "XR_TYPE_EVENT_DATA_MAIN_SESSION_VISIBILITY_CHANGED_EXTX";
    case XR_TYPE_COMPOSITION_LAYER_COLOR_SCALE_BIAS_KHR: return "XR_TYPE_COMPOSITION_LAYER_COLOR_SCALE_BIAS_KHR";
    case XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_MSFT: return "XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_MSFT";
    case XR_TYPE_SPATIAL_ANCHOR_SPACE_CREATE_INFO_MSFT: return "XR_TYPE_SPATIAL_ANCHOR_SPACE_CREATE_INFO_MSFT";
    case XR_TYPE_COMPOSITION_LAYER_IMAGE_LAYOUT_FB: return "XR_TYPE_COMPOSITION_LAYER_IMAGE_LAYOUT_FB";
    case XR_TYPE_COMPOSITION_LAYER_ALPHA_BLEND_FB: return "XR_TYPE_COMPOSITION_LAYER_ALPHA_BLEND_FB";
    case XR_TYPE_VIEW_CONFIGURATION_DEPTH_RANGE_EXT: return "XR_TYPE_VIEW_CONFIGURATION_DEPTH_RANGE_EXT";
    case XR_TYPE_GRAPHICS_BINDING_EGL_MNDX: return "XR_TYPE_GRAPHICS_BINDING_EGL_MNDX";
    case XR_TYPE_SPATIAL_GRAPH_NODE_SPACE_CREATE_INFO_MSFT: return "XR_TYPE_SPATIAL_GRAPH_NODE_SPACE_CREATE_INFO_MSFT";
    case XR_TYPE_SPATIAL_GRAPH_STATIC_NODE_BINDING_CREATE_INFO_MSFT: return "XR_TYPE_SPATIAL_GRAPH_STATIC_NODE_BINDING_CREATE_INFO_MSFT";
    case XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_GET_INFO_MSFT: return "XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_GET_INFO_MSFT";
    case XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_MSFT: return "XR_TYPE_SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_MSFT";
    case XR_TYPE_SYSTEM_HAND_TRACKING_PROPERTIES_EXT: return "XR_TYPE_SYSTEM_HAND_TRACKING_PROPERTIES_EXT";
    case XR_TYPE_HAND_TRACKER_CREATE_INFO_EXT: return "XR_TYPE_HAND_TRACKER_CREATE_INFO_EXT";
    case XR_TYPE_HAND_JOINTS_LOCATE_INFO_EXT: return "XR_TYPE_HAND_JOINTS_LOCATE_INFO_EXT";
    case XR_TYPE_HAND_JOINT_LOCATIONS_EXT: return "XR_TYPE_HAND_JOINT_LOCATIONS_EXT";
    case XR_TYPE_HAND_JOINT_VELOCITIES_EXT: return "XR_TYPE_HAND_JOINT_VELOCITIES_EXT";
    case XR_TYPE_SYSTEM_HAND_TRACKING_MESH_PROPERTIES_MSFT: return "XR_TYPE_SYSTEM_HAND_TRACKING_MESH_PROPERTIES_MSFT";
    case XR_TYPE_HAND_MESH_SPACE_CREATE_INFO_MSFT: return "XR_TYPE_HAND_MESH_SPACE_CREATE_INFO_MSFT";
    case XR_TYPE_HAND_MESH_UPDATE_INFO_MSFT: return "XR_TYPE_HAND_MESH_UPDATE_INFO_MSFT";
    case XR_TYPE_HAND_MESH_MSFT: return "XR_TYPE_HAND_MESH_MSFT";
    case XR_TYPE_HAND_POSE_TYPE_INFO_MSFT: return "XR_TYPE_HAND_POSE_TYPE_INFO_MSFT";
    case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SESSION_BEGIN_INFO_MSFT: return "XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SESSION_BEGIN_INFO_MSFT";
    case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_STATE_MSFT: return "XR_TYPE_SECONDARY_VIEW_CONFIGURATION_STATE_MSFT";
    case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_STATE_MSFT: return "XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_STATE_MSFT";
    case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_END_INFO_MSFT: return "XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_END_INFO_MSFT";
    case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_LAYER_INFO_MSFT: return "XR_TYPE_SECONDARY_VIEW_CONFIGURATION_LAYER_INFO_MSFT";
    case XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SWAPCHAIN_CREATE_INFO_MSFT: return "XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SWAPCHAIN_CREATE_INFO_MSFT";
    case XR_TYPE_CONTROLLER_MODEL_KEY_STATE_MSFT: return "XR_TYPE_CONTROLLER_MODEL_KEY_STATE_MSFT";
    case XR_TYPE_CONTROLLER_MODEL_NODE_PROPERTIES_MSFT: return "XR_TYPE_CONTROLLER_MODEL_NODE_PROPERTIES_MSFT";
    case XR_TYPE_CONTROLLER_MODEL_PROPERTIES_MSFT: return "XR_TYPE_CONTROLLER_MODEL_PROPERTIES_MSFT";
    case XR_TYPE_CONTROLLER_MODEL_NODE_STATE_MSFT: return "XR_TYPE_CONTROLLER_MODEL_NODE_STATE_MSFT";
    case XR_TYPE_CONTROLLER_MODEL_STATE_MSFT: return "XR_TYPE_CONTROLLER_MODEL_STATE_MSFT";
    case XR_TYPE_VIEW_CONFIGURATION_VIEW_FOV_EPIC: return "XR_TYPE_VIEW_CONFIGURATION_VIEW_FOV_EPIC";
    case XR_TYPE_HOLOGRAPHIC_WINDOW_ATTACHMENT_MSFT: return "XR_TYPE_HOLOGRAPHIC_WINDOW_ATTACHMENT_MSFT";
    case XR_TYPE_COMPOSITION_LAYER_REPROJECTION_INFO_MSFT: return "XR_TYPE_COMPOSITION_LAYER_REPROJECTION_INFO_MSFT";
    case XR_TYPE_COMPOSITION_LAYER_REPROJECTION_PLANE_OVERRIDE_MSFT: return "XR_TYPE_COMPOSITION_LAYER_REPROJECTION_PLANE_OVERRIDE_MSFT";
    case XR_TYPE_ANDROID_SURFACE_SWAPCHAIN_CREATE_INFO_FB: return "XR_TYPE_ANDROID_SURFACE_SWAPCHAIN_CREATE_INFO_FB";
    case XR_TYPE_COMPOSITION_LAYER_SECURE_CONTENT_FB: return "XR_TYPE_COMPOSITION_LAYER_SECURE_CONTENT_FB";
    case XR_TYPE_BODY_TRACKER_CREATE_INFO_FB: return "XR_TYPE_BODY_TRACKER_CREATE_INFO_FB";
    case XR_TYPE_BODY_JOINTS_LOCATE_INFO_FB: return "XR_TYPE_BODY_JOINTS_LOCATE_INFO_FB";
    case XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_FB: return "XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_FB";
    case XR_TYPE_BODY_JOINT_LOCATIONS_FB: return "XR_TYPE_BODY_JOINT_LOCATIONS_FB";
    case XR_TYPE_BODY_SKELETON_FB: return "XR_TYPE_BODY_SKELETON_FB";
    case XR_TYPE_INTERACTION_PROFILE_DPAD_BINDING_EXT: return "XR_TYPE_INTERACTION_PROFILE_DPAD_BINDING_EXT";
    case XR_TYPE_INTERACTION_PROFILE_ANALOG_THRESHOLD_VALVE: return "XR_TYPE_INTERACTION_PROFILE_ANALOG_THRESHOLD_VALVE";
    case XR_TYPE_HAND_JOINTS_MOTION_RANGE_INFO_EXT: return "XR_TYPE_HAND_JOINTS_MOTION_RANGE_INFO_EXT";
    case XR_TYPE_LOADER_INIT_INFO_ANDROID_KHR: return "XR_TYPE_LOADER_INIT_INFO_ANDROID_KHR";
    case XR_TYPE_VULKAN_INSTANCE_CREATE_INFO_KHR: return "XR_TYPE_VULKAN_INSTANCE_CREATE_INFO_KHR";
    case XR_TYPE_VULKAN_DEVICE_CREATE_INFO_KHR: return "XR_TYPE_VULKAN_DEVICE_CREATE_INFO_KHR";
    case XR_TYPE_VULKAN_GRAPHICS_DEVICE_GET_INFO_KHR: return "XR_TYPE_VULKAN_GRAPHICS_DEVICE_GET_INFO_KHR";
    case XR_TYPE_COMPOSITION_LAYER_EQUIRECT2_KHR: return "XR_TYPE_COMPOSITION_LAYER_EQUIRECT2_KHR";
    case XR_TYPE_SCENE_OBSERVER_CREATE_INFO_MSFT: return "XR_TYPE_SCENE_OBSERVER_CREATE_INFO_MSFT";
    case XR_TYPE_SCENE_CREATE_INFO_MSFT: return "XR_TYPE_SCENE_CREATE_INFO_MSFT";
    case XR_TYPE_NEW_SCENE_COMPUTE_INFO_MSFT: return "XR_TYPE_NEW_SCENE_COMPUTE_INFO_MSFT";
    case XR_TYPE_VISUAL_MESH_COMPUTE_LOD_INFO_MSFT: return "XR_TYPE_VISUAL_MESH_COMPUTE_LOD_INFO_MSFT";
    case XR_TYPE_SCENE_COMPONENTS_MSFT: return "XR_TYPE_SCENE_COMPONENTS_MSFT";
    case XR_TYPE_SCENE_COMPONENTS_GET_INFO_MSFT: return "XR_TYPE_SCENE_COMPONENTS_GET_INFO_MSFT";
    case XR_TYPE_SCENE_COMPONENT_LOCATIONS_MSFT: return "XR_TYPE_SCENE_COMPONENT_LOCATIONS_MSFT";
    case XR_TYPE_SCENE_COMPONENTS_LOCATE_INFO_MSFT: return "XR_TYPE_SCENE_COMPONENTS_LOCATE_INFO_MSFT";
    case XR_TYPE_SCENE_OBJECTS_MSFT: return "XR_TYPE_SCENE_OBJECTS_MSFT";
    case XR_TYPE_SCENE_COMPONENT_PARENT_FILTER_INFO_MSFT: return "XR_TYPE_SCENE_COMPONENT_PARENT_FILTER_INFO_MSFT";
    case XR_TYPE_SCENE_OBJECT_TYPES_FILTER_INFO_MSFT: return "XR_TYPE_SCENE_OBJECT_TYPES_FILTER_INFO_MSFT";
    case XR_TYPE_SCENE_PLANES_MSFT: return "XR_TYPE_SCENE_PLANES_MSFT";
    case XR_TYPE_SCENE_PLANE_ALIGNMENT_FILTER_INFO_MSFT: return "XR_TYPE_SCENE_PLANE_ALIGNMENT_FILTER_INFO_MSFT";
    case XR_TYPE_SCENE_MESHES_MSFT: return "XR_TYPE_SCENE_MESHES_MSFT";
    case XR_TYPE_SCENE_MESH_BUFFERS_GET_INFO_MSFT: return "XR_TYPE_SCENE_MESH_BUFFERS_GET_INFO_MSFT";
    case XR_TYPE_SCENE_MESH_BUFFERS_MSFT: return "XR_TYPE_SCENE_MESH_BUFFERS_MSFT";
    case XR_TYPE_SCENE_MESH_VERTEX_BUFFER_MSFT: return "XR_TYPE_SCENE_MESH_VERTEX_BUFFER_MSFT";
    case XR_TYPE_SCENE_MESH_INDICES_UINT32_MSFT: return "XR_TYPE_SCENE_MESH_INDICES_UINT32_MSFT";
    case XR_TYPE_SCENE_MESH_INDICES_UINT16_MSFT: return "XR_TYPE_SCENE_MESH_INDICES_UINT16_MSFT";
    case XR_TYPE_SERIALIZED_SCENE_FRAGMENT_DATA_GET_INFO_MSFT: return "XR_TYPE_SERIALIZED_SCENE_FRAGMENT_DATA_GET_INFO_MSFT";
    case XR_TYPE_SCENE_DESERIALIZE_INFO_MSFT: return "XR_TYPE_SCENE_DESERIALIZE_INFO_MSFT";
    case XR_TYPE_EVENT_DATA_DISPLAY_REFRESH_RATE_CHANGED_FB: return "XR_TYPE_EVENT_DATA_DISPLAY_REFRESH_RATE_CHANGED_FB";
    case XR_TYPE_VIVE_TRACKER_PATHS_HTCX: return "XR_TYPE_VIVE_TRACKER_PATHS_HTCX";
    case XR_TYPE_EVENT_DATA_VIVE_TRACKER_CONNECTED_HTCX: return "XR_TYPE_EVENT_DATA_VIVE_TRACKER_CONNECTED_HTCX";
    case XR_TYPE_SYSTEM_FACIAL_TRACKING_PROPERTIES_HTC: return "XR_TYPE_SYSTEM_FACIAL_TRACKING_PROPERTIES_HTC";
    case XR_TYPE_FACIAL_TRACKER_CREATE_INFO_HTC: return "XR_TYPE_FACIAL_TRACKER_CREATE_INFO_HTC";
    case XR_TYPE_FACIAL_EXPRESSIONS_HTC: return "XR_TYPE_FACIAL_EXPRESSIONS_HTC";
    case XR_TYPE_SYSTEM_COLOR_SPACE_PROPERTIES_FB: return "XR_TYPE_SYSTEM_COLOR_SPACE_PROPERTIES_FB";
    case XR_TYPE_HAND_TRACKING_MESH_FB: return "XR_TYPE_HAND_TRACKING_MESH_FB";
    case XR_TYPE_HAND_TRACKING_SCALE_FB: return "XR_TYPE_HAND_TRACKING_SCALE_FB";
    case XR_TYPE_HAND_TRACKING_AIM_STATE_FB: return "XR_TYPE_HAND_TRACKING_AIM_STATE_FB";
    case XR_TYPE_HAND_TRACKING_CAPSULES_STATE_FB: return "XR_TYPE_HAND_TRACKING_CAPSULES_STATE_FB";
    case XR_TYPE_SYSTEM_SPATIAL_ENTITY_PROPERTIES_FB: return "XR_TYPE_SYSTEM_SPATIAL_ENTITY_PROPERTIES_FB";
    case XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_FB: return "XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_FB";
    case XR_TYPE_SPACE_COMPONENT_STATUS_SET_INFO_FB: return "XR_TYPE_SPACE_COMPONENT_STATUS_SET_INFO_FB";
    case XR_TYPE_SPACE_COMPONENT_STATUS_FB: return "XR_TYPE_SPACE_COMPONENT_STATUS_FB";
    case XR_TYPE_EVENT_DATA_SPATIAL_ANCHOR_CREATE_COMPLETE_FB: return "XR_TYPE_EVENT_DATA_SPATIAL_ANCHOR_CREATE_COMPLETE_FB";
    case XR_TYPE_EVENT_DATA_SPACE_SET_STATUS_COMPLETE_FB: return "XR_TYPE_EVENT_DATA_SPACE_SET_STATUS_COMPLETE_FB";
    case XR_TYPE_FOVEATION_PROFILE_CREATE_INFO_FB: return "XR_TYPE_FOVEATION_PROFILE_CREATE_INFO_FB";
    case XR_TYPE_SWAPCHAIN_CREATE_INFO_FOVEATION_FB: return "XR_TYPE_SWAPCHAIN_CREATE_INFO_FOVEATION_FB";
    case XR_TYPE_SWAPCHAIN_STATE_FOVEATION_FB: return "XR_TYPE_SWAPCHAIN_STATE_FOVEATION_FB";
    case XR_TYPE_FOVEATION_LEVEL_PROFILE_CREATE_INFO_FB: return "XR_TYPE_FOVEATION_LEVEL_PROFILE_CREATE_INFO_FB";
    case XR_TYPE_KEYBOARD_SPACE_CREATE_INFO_FB: return "XR_TYPE_KEYBOARD_SPACE_CREATE_INFO_FB";
    case XR_TYPE_KEYBOARD_TRACKING_QUERY_FB: return "XR_TYPE_KEYBOARD_TRACKING_QUERY_FB";
    case XR_TYPE_SYSTEM_KEYBOARD_TRACKING_PROPERTIES_FB: return "XR_TYPE_SYSTEM_KEYBOARD_TRACKING_PROPERTIES_FB";
    case XR_TYPE_TRIANGLE_MESH_CREATE_INFO_FB: return "XR_TYPE_TRIANGLE_MESH_CREATE_INFO_FB";
    case XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES_FB: return "XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES_FB";
    case XR_TYPE_PASSTHROUGH_CREATE_INFO_FB: return "XR_TYPE_PASSTHROUGH_CREATE_INFO_FB";
    case XR_TYPE_PASSTHROUGH_LAYER_CREATE_INFO_FB: return "XR_TYPE_PASSTHROUGH_LAYER_CREATE_INFO_FB";
    case XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_FB: return "XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_FB";
    case XR_TYPE_GEOMETRY_INSTANCE_CREATE_INFO_FB: return "XR_TYPE_GEOMETRY_INSTANCE_CREATE_INFO_FB";
    case XR_TYPE_GEOMETRY_INSTANCE_TRANSFORM_FB: return "XR_TYPE_GEOMETRY_INSTANCE_TRANSFORM_FB";
    case XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES2_FB: return "XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES2_FB";
    case XR_TYPE_PASSTHROUGH_STYLE_FB: return "XR_TYPE_PASSTHROUGH_STYLE_FB";
    case XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_RGBA_FB: return "XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_RGBA_FB";
    case XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_MONO_FB: return "XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_MONO_FB";
    case XR_TYPE_PASSTHROUGH_BRIGHTNESS_CONTRAST_SATURATION_FB: return "XR_TYPE_PASSTHROUGH_BRIGHTNESS_CONTRAST_SATURATION_FB";
    case XR_TYPE_EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB: return "XR_TYPE_EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB";
    case XR_TYPE_RENDER_MODEL_PATH_INFO_FB: return "XR_TYPE_RENDER_MODEL_PATH_INFO_FB";
    case XR_TYPE_RENDER_MODEL_PROPERTIES_FB: return "XR_TYPE_RENDER_MODEL_PROPERTIES_FB";
    case XR_TYPE_RENDER_MODEL_BUFFER_FB: return "XR_TYPE_RENDER_MODEL_BUFFER_FB";
    case XR_TYPE_RENDER_MODEL_LOAD_INFO_FB: return "XR_TYPE_RENDER_MODEL_LOAD_INFO_FB";
    case XR_TYPE_SYSTEM_RENDER_MODEL_PROPERTIES_FB: return "XR_TYPE_SYSTEM_RENDER_MODEL_PROPERTIES_FB";
    case XR_TYPE_RENDER_MODEL_CAPABILITIES_REQUEST_FB: return "XR_TYPE_RENDER_MODEL_CAPABILITIES_REQUEST_FB";
    case XR_TYPE_BINDING_MODIFICATIONS_KHR: return "XR_TYPE_BINDING_MODIFICATIONS_KHR";
    case XR_TYPE_VIEW_LOCATE_FOVEATED_RENDERING_VARJO: return "XR_TYPE_VIEW_LOCATE_FOVEATED_RENDERING_VARJO";
    case XR_TYPE_FOVEATED_VIEW_CONFIGURATION_VIEW_VARJO: return "XR_TYPE_FOVEATED_VIEW_CONFIGURATION_VIEW_VARJO";
    case XR_TYPE_SYSTEM_FOVEATED_RENDERING_PROPERTIES_VARJO: return "XR_TYPE_SYSTEM_FOVEATED_RENDERING_PROPERTIES_VARJO";
    case XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_VARJO: return "XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_VARJO";
    case XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_VARJO: return "XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_VARJO";
    case XR_TYPE_EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO: return "XR_TYPE_EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO";
    case XR_TYPE_MARKER_SPACE_CREATE_INFO_VARJO: return "XR_TYPE_MARKER_SPACE_CREATE_INFO_VARJO";
    case XR_TYPE_FRAME_END_INFO_ML: return "XR_TYPE_FRAME_END_INFO_ML";
    case XR_TYPE_GLOBAL_DIMMER_FRAME_END_INFO_ML: return "XR_TYPE_GLOBAL_DIMMER_FRAME_END_INFO_ML";
    case XR_TYPE_COORDINATE_SPACE_CREATE_INFO_ML: return "XR_TYPE_COORDINATE_SPACE_CREATE_INFO_ML";
    case XR_TYPE_SYSTEM_MARKER_UNDERSTANDING_PROPERTIES_ML: return "XR_TYPE_SYSTEM_MARKER_UNDERSTANDING_PROPERTIES_ML";
    case XR_TYPE_MARKER_DETECTOR_CREATE_INFO_ML: return "XR_TYPE_MARKER_DETECTOR_CREATE_INFO_ML";
    case XR_TYPE_MARKER_DETECTOR_ARUCO_INFO_ML: return "XR_TYPE_MARKER_DETECTOR_ARUCO_INFO_ML";
    case XR_TYPE_MARKER_DETECTOR_SIZE_INFO_ML: return "XR_TYPE_MARKER_DETECTOR_SIZE_INFO_ML";
    case XR_TYPE_MARKER_DETECTOR_APRIL_TAG_INFO_ML: return "XR_TYPE_MARKER_DETECTOR_APRIL_TAG_INFO_ML";
    case XR_TYPE_MARKER_DETECTOR_CUSTOM_PROFILE_INFO_ML: return "XR_TYPE_MARKER_DETECTOR_CUSTOM_PROFILE_INFO_ML";
    case XR_TYPE_MARKER_DETECTOR_SNAPSHOT_INFO_ML: return "XR_TYPE_MARKER_DETECTOR_SNAPSHOT_INFO_ML";
    case XR_TYPE_MARKER_DETECTOR_STATE_ML: return "XR_TYPE_MARKER_DETECTOR_STATE_ML";
    case XR_TYPE_MARKER_SPACE_CREATE_INFO_ML: return "XR_TYPE_MARKER_SPACE_CREATE_INFO_ML";
    case XR_TYPE_LOCALIZATION_MAP_ML: return "XR_TYPE_LOCALIZATION_MAP_ML";
    case XR_TYPE_EVENT_DATA_LOCALIZATION_CHANGED_ML: return "XR_TYPE_EVENT_DATA_LOCALIZATION_CHANGED_ML";
    case XR_TYPE_MAP_LOCALIZATION_REQUEST_INFO_ML: return "XR_TYPE_MAP_LOCALIZATION_REQUEST_INFO_ML";
    case XR_TYPE_LOCALIZATION_MAP_IMPORT_INFO_ML: return "XR_TYPE_LOCALIZATION_MAP_IMPORT_INFO_ML";
    case XR_TYPE_LOCALIZATION_ENABLE_EVENTS_INFO_ML: return "XR_TYPE_LOCALIZATION_ENABLE_EVENTS_INFO_ML";
    case XR_TYPE_EVENT_DATA_HEADSET_FIT_CHANGED_ML: return "XR_TYPE_EVENT_DATA_HEADSET_FIT_CHANGED_ML";
    case XR_TYPE_EVENT_DATA_EYE_CALIBRATION_CHANGED_ML: return "XR_TYPE_EVENT_DATA_EYE_CALIBRATION_CHANGED_ML";
    case XR_TYPE_USER_CALIBRATION_ENABLE_EVENTS_INFO_ML: return "XR_TYPE_USER_CALIBRATION_ENABLE_EVENTS_INFO_ML";
    case XR_TYPE_SPATIAL_ANCHOR_PERSISTENCE_INFO_MSFT: return "XR_TYPE_SPATIAL_ANCHOR_PERSISTENCE_INFO_MSFT";
    case XR_TYPE_SPATIAL_ANCHOR_FROM_PERSISTED_ANCHOR_CREATE_INFO_MSFT: return "XR_TYPE_SPATIAL_ANCHOR_FROM_PERSISTED_ANCHOR_CREATE_INFO_MSFT";
    case XR_TYPE_SCENE_MARKERS_MSFT: return "XR_TYPE_SCENE_MARKERS_MSFT";
    case XR_TYPE_SCENE_MARKER_TYPE_FILTER_MSFT: return "XR_TYPE_SCENE_MARKER_TYPE_FILTER_MSFT";
    case XR_TYPE_SCENE_MARKER_QR_CODES_MSFT: return "XR_TYPE_SCENE_MARKER_QR_CODES_MSFT";
    case XR_TYPE_SPACE_QUERY_INFO_FB: return "XR_TYPE_SPACE_QUERY_INFO_FB";
    case XR_TYPE_SPACE_QUERY_RESULTS_FB: return "XR_TYPE_SPACE_QUERY_RESULTS_FB";
    case XR_TYPE_SPACE_STORAGE_LOCATION_FILTER_INFO_FB: return "XR_TYPE_SPACE_STORAGE_LOCATION_FILTER_INFO_FB";
    case XR_TYPE_SPACE_UUID_FILTER_INFO_FB: return "XR_TYPE_SPACE_UUID_FILTER_INFO_FB";
    case XR_TYPE_SPACE_COMPONENT_FILTER_INFO_FB: return "XR_TYPE_SPACE_COMPONENT_FILTER_INFO_FB";
    case XR_TYPE_EVENT_DATA_SPACE_QUERY_RESULTS_AVAILABLE_FB: return "XR_TYPE_EVENT_DATA_SPACE_QUERY_RESULTS_AVAILABLE_FB";
    case XR_TYPE_EVENT_DATA_SPACE_QUERY_COMPLETE_FB: return "XR_TYPE_EVENT_DATA_SPACE_QUERY_COMPLETE_FB";
    case XR_TYPE_SPACE_SAVE_INFO_FB: return "XR_TYPE_SPACE_SAVE_INFO_FB";
    case XR_TYPE_SPACE_ERASE_INFO_FB: return "XR_TYPE_SPACE_ERASE_INFO_FB";
    case XR_TYPE_EVENT_DATA_SPACE_SAVE_COMPLETE_FB: return "XR_TYPE_EVENT_DATA_SPACE_SAVE_COMPLETE_FB";
    case XR_TYPE_EVENT_DATA_SPACE_ERASE_COMPLETE_FB: return "XR_TYPE_EVENT_DATA_SPACE_ERASE_COMPLETE_FB";
    case XR_TYPE_SWAPCHAIN_IMAGE_FOVEATION_VULKAN_FB: return "XR_TYPE_SWAPCHAIN_IMAGE_FOVEATION_VULKAN_FB";
    case XR_TYPE_SWAPCHAIN_STATE_ANDROID_SURFACE_DIMENSIONS_FB: return "XR_TYPE_SWAPCHAIN_STATE_ANDROID_SURFACE_DIMENSIONS_FB";
    case XR_TYPE_SWAPCHAIN_STATE_SAMPLER_OPENGL_ES_FB: return "XR_TYPE_SWAPCHAIN_STATE_SAMPLER_OPENGL_ES_FB";
    case XR_TYPE_SWAPCHAIN_STATE_SAMPLER_VULKAN_FB: return "XR_TYPE_SWAPCHAIN_STATE_SAMPLER_VULKAN_FB";
    case XR_TYPE_SPACE_SHARE_INFO_FB: return "XR_TYPE_SPACE_SHARE_INFO_FB";
    case XR_TYPE_EVENT_DATA_SPACE_SHARE_COMPLETE_FB: return "XR_TYPE_EVENT_DATA_SPACE_SHARE_COMPLETE_FB";
    case XR_TYPE_COMPOSITION_LAYER_SPACE_WARP_INFO_FB: return "XR_TYPE_COMPOSITION_LAYER_SPACE_WARP_INFO_FB";
    case XR_TYPE_SYSTEM_SPACE_WARP_PROPERTIES_FB: return "XR_TYPE_SYSTEM_SPACE_WARP_PROPERTIES_FB";
    case XR_TYPE_HAPTIC_AMPLITUDE_ENVELOPE_VIBRATION_FB: return "XR_TYPE_HAPTIC_AMPLITUDE_ENVELOPE_VIBRATION_FB";
    case XR_TYPE_SEMANTIC_LABELS_FB: return "XR_TYPE_SEMANTIC_LABELS_FB";
    case XR_TYPE_ROOM_LAYOUT_FB: return "XR_TYPE_ROOM_LAYOUT_FB";
    case XR_TYPE_BOUNDARY_2D_FB: return "XR_TYPE_BOUNDARY_2D_FB";
    case XR_TYPE_SEMANTIC_LABELS_SUPPORT_INFO_FB: return "XR_TYPE_SEMANTIC_LABELS_SUPPORT_INFO_FB";
    case XR_TYPE_DIGITAL_LENS_CONTROL_ALMALENCE: return "XR_TYPE_DIGITAL_LENS_CONTROL_ALMALENCE";
    case XR_TYPE_EVENT_DATA_SCENE_CAPTURE_COMPLETE_FB: return "XR_TYPE_EVENT_DATA_SCENE_CAPTURE_COMPLETE_FB";
    case XR_TYPE_SCENE_CAPTURE_REQUEST_INFO_FB: return "XR_TYPE_SCENE_CAPTURE_REQUEST_INFO_FB";
    case XR_TYPE_SPACE_CONTAINER_FB: return "XR_TYPE_SPACE_CONTAINER_FB";
    case XR_TYPE_FOVEATION_EYE_TRACKED_PROFILE_CREATE_INFO_META: return "XR_TYPE_FOVEATION_EYE_TRACKED_PROFILE_CREATE_INFO_META";
    case XR_TYPE_FOVEATION_EYE_TRACKED_STATE_META: return "XR_TYPE_FOVEATION_EYE_TRACKED_STATE_META";
    case XR_TYPE_SYSTEM_FOVEATION_EYE_TRACKED_PROPERTIES_META: return "XR_TYPE_SYSTEM_FOVEATION_EYE_TRACKED_PROPERTIES_META";
    case XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES_FB: return "XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES_FB";
    case XR_TYPE_FACE_TRACKER_CREATE_INFO_FB: return "XR_TYPE_FACE_TRACKER_CREATE_INFO_FB";
    case XR_TYPE_FACE_EXPRESSION_INFO_FB: return "XR_TYPE_FACE_EXPRESSION_INFO_FB";
    case XR_TYPE_FACE_EXPRESSION_WEIGHTS_FB: return "XR_TYPE_FACE_EXPRESSION_WEIGHTS_FB";
    case XR_TYPE_EYE_TRACKER_CREATE_INFO_FB: return "XR_TYPE_EYE_TRACKER_CREATE_INFO_FB";
    case XR_TYPE_EYE_GAZES_INFO_FB: return "XR_TYPE_EYE_GAZES_INFO_FB";
    case XR_TYPE_EYE_GAZES_FB: return "XR_TYPE_EYE_GAZES_FB";
    case XR_TYPE_SYSTEM_EYE_TRACKING_PROPERTIES_FB: return "XR_TYPE_SYSTEM_EYE_TRACKING_PROPERTIES_FB";
    case XR_TYPE_PASSTHROUGH_KEYBOARD_HANDS_INTENSITY_FB: return "XR_TYPE_PASSTHROUGH_KEYBOARD_HANDS_INTENSITY_FB";
    case XR_TYPE_COMPOSITION_LAYER_SETTINGS_FB: return "XR_TYPE_COMPOSITION_LAYER_SETTINGS_FB";
    case XR_TYPE_HAPTIC_PCM_VIBRATION_FB: return "XR_TYPE_HAPTIC_PCM_VIBRATION_FB";
    case XR_TYPE_DEVICE_PCM_SAMPLE_RATE_STATE_FB: return "XR_TYPE_DEVICE_PCM_SAMPLE_RATE_STATE_FB";
    case XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_FB: return "XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_FB";
    case XR_TYPE_LOCAL_DIMMING_FRAME_END_INFO_META: return "XR_TYPE_LOCAL_DIMMING_FRAME_END_INFO_META";
    case XR_TYPE_PASSTHROUGH_PREFERENCES_META: return "XR_TYPE_PASSTHROUGH_PREFERENCES_META";
    case XR_TYPE_SYSTEM_VIRTUAL_KEYBOARD_PROPERTIES_META: return "XR_TYPE_SYSTEM_VIRTUAL_KEYBOARD_PROPERTIES_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_CREATE_INFO_META: return "XR_TYPE_VIRTUAL_KEYBOARD_CREATE_INFO_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_SPACE_CREATE_INFO_META: return "XR_TYPE_VIRTUAL_KEYBOARD_SPACE_CREATE_INFO_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_LOCATION_INFO_META: return "XR_TYPE_VIRTUAL_KEYBOARD_LOCATION_INFO_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_MODEL_VISIBILITY_SET_INFO_META: return "XR_TYPE_VIRTUAL_KEYBOARD_MODEL_VISIBILITY_SET_INFO_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_ANIMATION_STATE_META: return "XR_TYPE_VIRTUAL_KEYBOARD_ANIMATION_STATE_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_MODEL_ANIMATION_STATES_META: return "XR_TYPE_VIRTUAL_KEYBOARD_MODEL_ANIMATION_STATES_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_TEXTURE_DATA_META: return "XR_TYPE_VIRTUAL_KEYBOARD_TEXTURE_DATA_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_INPUT_INFO_META: return "XR_TYPE_VIRTUAL_KEYBOARD_INPUT_INFO_META";
    case XR_TYPE_VIRTUAL_KEYBOARD_TEXT_CONTEXT_CHANGE_INFO_META: return "XR_TYPE_VIRTUAL_KEYBOARD_TEXT_CONTEXT_CHANGE_INFO_META";
    case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_COMMIT_TEXT_META: return "XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_COMMIT_TEXT_META";
    case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_BACKSPACE_META: return "XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_BACKSPACE_META";
    case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_ENTER_META: return "XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_ENTER_META";
    case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_SHOWN_META: return "XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_SHOWN_META";
    case XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_HIDDEN_META: return "XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_HIDDEN_META";
    case XR_TYPE_EXTERNAL_CAMERA_OCULUS: return "XR_TYPE_EXTERNAL_CAMERA_OCULUS";
    case XR_TYPE_VULKAN_SWAPCHAIN_CREATE_INFO_META: return "XR_TYPE_VULKAN_SWAPCHAIN_CREATE_INFO_META";
    case XR_TYPE_PERFORMANCE_METRICS_STATE_META: return "XR_TYPE_PERFORMANCE_METRICS_STATE_META";
    case XR_TYPE_PERFORMANCE_METRICS_COUNTER_META: return "XR_TYPE_PERFORMANCE_METRICS_COUNTER_META";
    case XR_TYPE_SPACE_LIST_SAVE_INFO_FB: return "XR_TYPE_SPACE_LIST_SAVE_INFO_FB";
    case XR_TYPE_EVENT_DATA_SPACE_LIST_SAVE_COMPLETE_FB: return "XR_TYPE_EVENT_DATA_SPACE_LIST_SAVE_COMPLETE_FB";
    case XR_TYPE_SPACE_USER_CREATE_INFO_FB: return "XR_TYPE_SPACE_USER_CREATE_INFO_FB";
    case XR_TYPE_SYSTEM_HEADSET_ID_PROPERTIES_META: return "XR_TYPE_SYSTEM_HEADSET_ID_PROPERTIES_META";
    case XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_META: return "XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_META";
    case XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_GET_INFO_META: return "XR_TYPE_RECOMMENDED_LAYER_RESOLUTION_GET_INFO_META";
    case XR_TYPE_SYSTEM_PASSTHROUGH_COLOR_LUT_PROPERTIES_META: return "XR_TYPE_SYSTEM_PASSTHROUGH_COLOR_LUT_PROPERTIES_META";
    case XR_TYPE_PASSTHROUGH_COLOR_LUT_CREATE_INFO_META: return "XR_TYPE_PASSTHROUGH_COLOR_LUT_CREATE_INFO_META";
    case XR_TYPE_PASSTHROUGH_COLOR_LUT_UPDATE_INFO_META: return "XR_TYPE_PASSTHROUGH_COLOR_LUT_UPDATE_INFO_META";
    case XR_TYPE_PASSTHROUGH_COLOR_MAP_LUT_META: return "XR_TYPE_PASSTHROUGH_COLOR_MAP_LUT_META";
    case XR_TYPE_PASSTHROUGH_COLOR_MAP_INTERPOLATED_LUT_META: return "XR_TYPE_PASSTHROUGH_COLOR_MAP_INTERPOLATED_LUT_META";
    case XR_TYPE_SPACE_TRIANGLE_MESH_GET_INFO_META: return "XR_TYPE_SPACE_TRIANGLE_MESH_GET_INFO_META";
    case XR_TYPE_SPACE_TRIANGLE_MESH_META: return "XR_TYPE_SPACE_TRIANGLE_MESH_META";
    case XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES2_FB: return "XR_TYPE_SYSTEM_FACE_TRACKING_PROPERTIES2_FB";
    case XR_TYPE_FACE_TRACKER_CREATE_INFO2_FB: return "XR_TYPE_FACE_TRACKER_CREATE_INFO2_FB";
    case XR_TYPE_FACE_EXPRESSION_INFO2_FB: return "XR_TYPE_FACE_EXPRESSION_INFO2_FB";
    case XR_TYPE_FACE_EXPRESSION_WEIGHTS2_FB: return "XR_TYPE_FACE_EXPRESSION_WEIGHTS2_FB";
    case XR_TYPE_ENVIRONMENT_DEPTH_PROVIDER_CREATE_INFO_META: return "XR_TYPE_ENVIRONMENT_DEPTH_PROVIDER_CREATE_INFO_META";
    case XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_CREATE_INFO_META: return "XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_CREATE_INFO_META";
    case XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_STATE_META: return "XR_TYPE_ENVIRONMENT_DEPTH_SWAPCHAIN_STATE_META";
    case XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_ACQUIRE_INFO_META: return "XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_ACQUIRE_INFO_META";
    case XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_VIEW_META: return "XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_VIEW_META";
    case XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_META: return "XR_TYPE_ENVIRONMENT_DEPTH_IMAGE_META";
    case XR_TYPE_ENVIRONMENT_DEPTH_HAND_REMOVAL_SET_INFO_META: return "XR_TYPE_ENVIRONMENT_DEPTH_HAND_REMOVAL_SET_INFO_META";
    case XR_TYPE_SYSTEM_ENVIRONMENT_DEPTH_PROPERTIES_META: return "XR_TYPE_SYSTEM_ENVIRONMENT_DEPTH_PROPERTIES_META";
    case XR_TYPE_PASSTHROUGH_CREATE_INFO_HTC: return "XR_TYPE_PASSTHROUGH_CREATE_INFO_HTC";
    case XR_TYPE_PASSTHROUGH_COLOR_HTC: return "XR_TYPE_PASSTHROUGH_COLOR_HTC";
    case XR_TYPE_PASSTHROUGH_MESH_TRANSFORM_INFO_HTC: return "XR_TYPE_PASSTHROUGH_MESH_TRANSFORM_INFO_HTC";
    case XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_HTC: return "XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_HTC";
    case XR_TYPE_FOVEATION_APPLY_INFO_HTC: return "XR_TYPE_FOVEATION_APPLY_INFO_HTC";
    case XR_TYPE_FOVEATION_DYNAMIC_MODE_INFO_HTC: return "XR_TYPE_FOVEATION_DYNAMIC_MODE_INFO_HTC";
    case XR_TYPE_FOVEATION_CUSTOM_MODE_INFO_HTC: return "XR_TYPE_FOVEATION_CUSTOM_MODE_INFO_HTC";
    case XR_TYPE_SYSTEM_ANCHOR_PROPERTIES_HTC: return "XR_TYPE_SYSTEM_ANCHOR_PROPERTIES_HTC";
    case XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_HTC: return "XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_HTC";
    case XR_TYPE_ACTIVE_ACTION_SET_PRIORITIES_EXT: return "XR_TYPE_ACTIVE_ACTION_SET_PRIORITIES_EXT";
    case XR_TYPE_SYSTEM_FORCE_FEEDBACK_CURL_PROPERTIES_MNDX: return "XR_TYPE_SYSTEM_FORCE_FEEDBACK_CURL_PROPERTIES_MNDX";
    case XR_TYPE_FORCE_FEEDBACK_CURL_APPLY_LOCATIONS_MNDX: return "XR_TYPE_FORCE_FEEDBACK_CURL_APPLY_LOCATIONS_MNDX";
    case XR_TYPE_HAND_TRACKING_DATA_SOURCE_INFO_EXT: return "XR_TYPE_HAND_TRACKING_DATA_SOURCE_INFO_EXT";
    case XR_TYPE_HAND_TRACKING_DATA_SOURCE_STATE_EXT: return "XR_TYPE_HAND_TRACKING_DATA_SOURCE_STATE_EXT";
    case XR_TYPE_PLANE_DETECTOR_CREATE_INFO_EXT: return "XR_TYPE_PLANE_DETECTOR_CREATE_INFO_EXT";
    case XR_TYPE_PLANE_DETECTOR_BEGIN_INFO_EXT: return "XR_TYPE_PLANE_DETECTOR_BEGIN_INFO_EXT";
    case XR_TYPE_PLANE_DETECTOR_GET_INFO_EXT: return "XR_TYPE_PLANE_DETECTOR_GET_INFO_EXT";
    case XR_TYPE_PLANE_DETECTOR_LOCATIONS_EXT: return "XR_TYPE_PLANE_DETECTOR_LOCATIONS_EXT";
    case XR_TYPE_PLANE_DETECTOR_LOCATION_EXT: return "XR_TYPE_PLANE_DETECTOR_LOCATION_EXT";
    case XR_TYPE_PLANE_DETECTOR_POLYGON_BUFFER_EXT: return "XR_TYPE_PLANE_DETECTOR_POLYGON_BUFFER_EXT";
    case XR_TYPE_SYSTEM_PLANE_DETECTION_PROPERTIES_EXT: return "XR_TYPE_SYSTEM_PLANE_DETECTION_PROPERTIES_EXT";
    case XR_TYPE_FUTURE_CANCEL_INFO_EXT: return "XR_TYPE_FUTURE_CANCEL_INFO_EXT";
    case XR_TYPE_FUTURE_POLL_INFO_EXT: return "XR_TYPE_FUTURE_POLL_INFO_EXT";
    case XR_TYPE_FUTURE_COMPLETION_EXT: return "XR_TYPE_FUTURE_COMPLETION_EXT";
    case XR_TYPE_FUTURE_POLL_RESULT_EXT: return "XR_TYPE_FUTURE_POLL_RESULT_EXT";
    case XR_TYPE_EVENT_DATA_USER_PRESENCE_CHANGED_EXT: return "XR_TYPE_EVENT_DATA_USER_PRESENCE_CHANGED_EXT";
    case XR_TYPE_SYSTEM_USER_PRESENCE_PROPERTIES_EXT: return "XR_TYPE_SYSTEM_USER_PRESENCE_PROPERTIES_EXT";
    default: break;
    }
    return "Unhandled XrStructureType";
}

std::string XrSwapchainCreateFlagBitsToString(const XrSwapchainCreateFlags value)
{
    switch (value) {
    case XR_SWAPCHAIN_CREATE_PROTECTED_CONTENT_BIT: return "XR_SWAPCHAIN_CREATE_PROTECTED_CONTENT_BIT";
    case XR_SWAPCHAIN_CREATE_STATIC_IMAGE_BIT: return "XR_SWAPCHAIN_CREATE_STATIC_IMAGE_BIT";
    default: break;
    }
    return "Unhandled XrSwapchainCreateFlagBits";
}

std::string XrSwapchainCreateFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrSwapchainCreateFlags>(xrFlags, XrSwapchainCreateFlagBitsToString);
}

std::string XrSwapchainCreateFoveationFlagBitsFBToString(const XrSwapchainCreateFoveationFlagsFB value)
{
    switch (value) {
    case XR_SWAPCHAIN_CREATE_FOVEATION_SCALED_BIN_BIT_FB: return "XR_SWAPCHAIN_CREATE_FOVEATION_SCALED_BIN_BIT_FB";
    case XR_SWAPCHAIN_CREATE_FOVEATION_FRAGMENT_DENSITY_MAP_BIT_FB: return "XR_SWAPCHAIN_CREATE_FOVEATION_FRAGMENT_DENSITY_MAP_BIT_FB";
    default: break;
    }
    return "Unhandled XrSwapchainCreateFoveationFlagBitsFB";
}

std::string XrSwapchainCreateFoveationFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrSwapchainCreateFoveationFlagsFB>(xrFlags, XrSwapchainCreateFoveationFlagBitsFBToString);
}

std::string XrSwapchainStateFoveationFlagBitsFBToString(const XrSwapchainStateFoveationFlagsFB value)
{
    return "Unhandled XrSwapchainStateFoveationFlagBitsFB";
}

std::string XrSwapchainStateFoveationFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrSwapchainStateFoveationFlagsFB>(xrFlags, XrSwapchainStateFoveationFlagBitsFBToString);
}

std::string XrSwapchainUsageFlagBitsToString(const XrSwapchainUsageFlags value)
{
    switch (value) {
    case XR_SWAPCHAIN_USAGE_COLOR_ATTACHMENT_BIT: return "XR_SWAPCHAIN_USAGE_COLOR_ATTACHMENT_BIT";
    case XR_SWAPCHAIN_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT: return "XR_SWAPCHAIN_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT";
    case XR_SWAPCHAIN_USAGE_UNORDERED_ACCESS_BIT: return "XR_SWAPCHAIN_USAGE_UNORDERED_ACCESS_BIT";
    case XR_SWAPCHAIN_USAGE_TRANSFER_SRC_BIT: return "XR_SWAPCHAIN_USAGE_TRANSFER_SRC_BIT";
    case XR_SWAPCHAIN_USAGE_TRANSFER_DST_BIT: return "XR_SWAPCHAIN_USAGE_TRANSFER_DST_BIT";
    case XR_SWAPCHAIN_USAGE_SAMPLED_BIT: return "XR_SWAPCHAIN_USAGE_SAMPLED_BIT";
    case XR_SWAPCHAIN_USAGE_MUTABLE_FORMAT_BIT: return "XR_SWAPCHAIN_USAGE_MUTABLE_FORMAT_BIT";
    case XR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_MND: return "XR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_MND";
    default: break;
    }
    return "Unhandled XrSwapchainUsageFlagBits";
}

std::string XrSwapchainUsageFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrSwapchainUsageFlags>(xrFlags, XrSwapchainUsageFlagBitsToString);
}

template <> std::string ToString<XrTrackingOptimizationSettingsDomainQCOM>(const XrTrackingOptimizationSettingsDomainQCOM& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_TRACKING_OPTIMIZATION_SETTINGS_DOMAIN_ALL_QCOM: return "XR_TRACKING_OPTIMIZATION_SETTINGS_DOMAIN_ALL_QCOM";
    default: break;
    }
    return "Unhandled XrTrackingOptimizationSettingsDomainQCOM";
}

template <> std::string ToString<XrTrackingOptimizationSettingsHintQCOM>(const XrTrackingOptimizationSettingsHintQCOM& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_NONE_QCOM: return "XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_NONE_QCOM";
    case XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_LONG_RANGE_PRIORIZATION_QCOM: return "XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_LONG_RANGE_PRIORIZATION_QCOM";
    case XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_CLOSE_RANGE_PRIORIZATION_QCOM: return "XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_CLOSE_RANGE_PRIORIZATION_QCOM";
    case XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_LOW_POWER_PRIORIZATION_QCOM: return "XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_LOW_POWER_PRIORIZATION_QCOM";
    case XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_HIGH_POWER_PRIORIZATION_QCOM: return "XR_TRACKING_OPTIMIZATION_SETTINGS_HINT_HIGH_POWER_PRIORIZATION_QCOM";
    default: break;
    }
    return "Unhandled XrTrackingOptimizationSettingsHintQCOM";
}

std::string XrTriangleMeshFlagBitsFBToString(const XrTriangleMeshFlagsFB value)
{
    switch (value) {
    case XR_TRIANGLE_MESH_MUTABLE_BIT_FB: return "XR_TRIANGLE_MESH_MUTABLE_BIT_FB";
    default: break;
    }
    return "Unhandled XrTriangleMeshFlagBitsFB";
}

std::string XrTriangleMeshFlagsFBToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrTriangleMeshFlagsFB>(xrFlags, XrTriangleMeshFlagBitsFBToString);
}

template <> std::string ToString<XrViewConfigurationType>(const XrViewConfigurationType& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_VIEW_CONFIGURATION_TYPE_PRIMARY_MONO: return "XR_VIEW_CONFIGURATION_TYPE_PRIMARY_MONO";
    case XR_VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO: return "XR_VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO";
    case XR_VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO_WITH_FOVEATED_INSET: return "XR_VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO_WITH_FOVEATED_INSET";
    case XR_VIEW_CONFIGURATION_TYPE_SECONDARY_MONO_FIRST_PERSON_OBSERVER_MSFT: return "XR_VIEW_CONFIGURATION_TYPE_SECONDARY_MONO_FIRST_PERSON_OBSERVER_MSFT";
    default: break;
    }
    return "Unhandled XrViewConfigurationType";
}

std::string XrViewStateFlagBitsToString(const XrViewStateFlags value)
{
    switch (value) {
    case XR_VIEW_STATE_ORIENTATION_VALID_BIT: return "XR_VIEW_STATE_ORIENTATION_VALID_BIT";
    case XR_VIEW_STATE_POSITION_VALID_BIT: return "XR_VIEW_STATE_POSITION_VALID_BIT";
    case XR_VIEW_STATE_ORIENTATION_TRACKED_BIT: return "XR_VIEW_STATE_ORIENTATION_TRACKED_BIT";
    case XR_VIEW_STATE_POSITION_TRACKED_BIT: return "XR_VIEW_STATE_POSITION_TRACKED_BIT";
    default: break;
    }
    return "Unhandled XrViewStateFlagBits";
}

std::string XrViewStateFlagsToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrViewStateFlags>(xrFlags, XrViewStateFlagBitsToString);
}

template <> std::string ToString<XrVirtualKeyboardInputSourceMETA>(const XrVirtualKeyboardInputSourceMETA& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_RAY_LEFT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_RAY_LEFT_META";
    case XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_RAY_RIGHT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_RAY_RIGHT_META";
    case XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_RAY_LEFT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_RAY_LEFT_META";
    case XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_RAY_RIGHT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_RAY_RIGHT_META";
    case XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_DIRECT_LEFT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_DIRECT_LEFT_META";
    case XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_DIRECT_RIGHT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_DIRECT_RIGHT_META";
    case XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_DIRECT_INDEX_TIP_LEFT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_DIRECT_INDEX_TIP_LEFT_META";
    case XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_DIRECT_INDEX_TIP_RIGHT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_DIRECT_INDEX_TIP_RIGHT_META";
    default: break;
    }
    return "Unhandled XrVirtualKeyboardInputSourceMETA";
}

std::string XrVirtualKeyboardInputStateFlagBitsMETAToString(const XrVirtualKeyboardInputStateFlagsMETA value)
{
    switch (value) {
    case XR_VIRTUAL_KEYBOARD_INPUT_STATE_PRESSED_BIT_META: return "XR_VIRTUAL_KEYBOARD_INPUT_STATE_PRESSED_BIT_META";
    default: break;
    }
    return "Unhandled XrVirtualKeyboardInputStateFlagBitsMETA";
}

std::string XrVirtualKeyboardInputStateFlagsMETAToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrVirtualKeyboardInputStateFlagsMETA>(xrFlags, XrVirtualKeyboardInputStateFlagBitsMETAToString);
}

template <> std::string ToString<XrVirtualKeyboardLocationTypeMETA>(const XrVirtualKeyboardLocationTypeMETA& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_CUSTOM_META: return "XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_CUSTOM_META";
    case XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_FAR_META: return "XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_FAR_META";
    case XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_DIRECT_META: return "XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_DIRECT_META";
    default: break;
    }
    return "Unhandled XrVirtualKeyboardLocationTypeMETA";
}

template <> std::string ToString<XrVisibilityMaskTypeKHR>(const XrVisibilityMaskTypeKHR& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_VISIBILITY_MASK_TYPE_HIDDEN_TRIANGLE_MESH_KHR: return "XR_VISIBILITY_MASK_TYPE_HIDDEN_TRIANGLE_MESH_KHR";
    case XR_VISIBILITY_MASK_TYPE_VISIBLE_TRIANGLE_MESH_KHR: return "XR_VISIBILITY_MASK_TYPE_VISIBLE_TRIANGLE_MESH_KHR";
    case XR_VISIBILITY_MASK_TYPE_LINE_LOOP_KHR: return "XR_VISIBILITY_MASK_TYPE_LINE_LOOP_KHR";
    default: break;
    }
    return "Unhandled XrVisibilityMaskTypeKHR";
}

std::string XrVulkanDeviceCreateFlagBitsKHRToString(const XrVulkanDeviceCreateFlagsKHR value)
{
    return "Unhandled XrVulkanDeviceCreateFlagBitsKHR";
}

std::string XrVulkanDeviceCreateFlagsKHRToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrVulkanDeviceCreateFlagsKHR>(xrFlags, XrVulkanDeviceCreateFlagBitsKHRToString);
}

std::string XrVulkanInstanceCreateFlagBitsKHRToString(const XrVulkanInstanceCreateFlagsKHR value)
{
    return "Unhandled XrVulkanInstanceCreateFlagBitsKHR";
}

std::string XrVulkanInstanceCreateFlagsKHRToString(XrFlags64 xrFlags)
{
    return BitmaskToString<XrVulkanInstanceCreateFlagsKHR>(xrFlags, XrVulkanInstanceCreateFlagBitsKHRToString);
}

template <> std::string ToString<XrWindingOrderFB>(const XrWindingOrderFB& value, ToStringFlags, uint32_t, uint32_t)
{
    switch (value) {
    case XR_WINDING_ORDER_UNKNOWN_FB: return "XR_WINDING_ORDER_UNKNOWN_FB";
    case XR_WINDING_ORDER_CW_FB: return "XR_WINDING_ORDER_CW_FB";
    case XR_WINDING_ORDER_CCW_FB: return "XR_WINDING_ORDER_CCW_FB";
    default: break;
    }
    return "Unhandled XrWindingOrderFB";
}

GFXRECON_END_NAMESPACE(util)
GFXRECON_END_NAMESPACE(gfxrecon)

#endif // ENABLE_OPENXR_SUPPORT
