/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_PIPELINE_H
#define VN_PROTOCOL_DRIVER_PIPELINE_H

#include "vn_instance.h"
#include "vn_protocol_driver_structs.h"

/* struct VkSpecializationMapEntry */

static inline size_t
vn_sizeof_VkSpecializationMapEntry(const VkSpecializationMapEntry *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->constantID);
    size += vn_sizeof_uint32_t(&val->offset);
    size += vn_sizeof_size_t(&val->size);
    return size;
}

static inline void
vn_encode_VkSpecializationMapEntry(struct vn_cs_encoder *enc, const VkSpecializationMapEntry *val)
{
    vn_encode_uint32_t(enc, &val->constantID);
    vn_encode_uint32_t(enc, &val->offset);
    vn_encode_size_t(enc, &val->size);
}

/* struct VkSpecializationInfo */

static inline size_t
vn_sizeof_VkSpecializationInfo(const VkSpecializationInfo *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->mapEntryCount);
    if (val->pMapEntries) {
        size += vn_sizeof_array_size(val->mapEntryCount);
        for (uint32_t i = 0; i < val->mapEntryCount; i++)
            size += vn_sizeof_VkSpecializationMapEntry(&val->pMapEntries[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_size_t(&val->dataSize);
    if (val->pData) {
        size += vn_sizeof_array_size(val->dataSize);
        size += vn_sizeof_blob_array(val->pData, val->dataSize);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline void
vn_encode_VkSpecializationInfo(struct vn_cs_encoder *enc, const VkSpecializationInfo *val)
{
    vn_encode_uint32_t(enc, &val->mapEntryCount);
    if (val->pMapEntries) {
        vn_encode_array_size(enc, val->mapEntryCount);
        for (uint32_t i = 0; i < val->mapEntryCount; i++)
            vn_encode_VkSpecializationMapEntry(enc, &val->pMapEntries[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_size_t(enc, &val->dataSize);
    if (val->pData) {
        vn_encode_array_size(enc, val->dataSize);
        vn_encode_blob_array(enc, val->pData, val->dataSize);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

/* struct VkPipelineShaderStageCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineShaderStageCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineShaderStageCreateInfo_self(const VkPipelineShaderStageCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkShaderStageFlagBits(&val->stage);
    size += vn_sizeof_VkShaderModule(&val->module);
    if (val->pName) {
        const size_t string_size = strlen(val->pName) + 1;
        size += vn_sizeof_array_size(string_size);
        size += vn_sizeof_char_array(val->pName, string_size);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_simple_pointer(val->pSpecializationInfo);
    if (val->pSpecializationInfo)
        size += vn_sizeof_VkSpecializationInfo(val->pSpecializationInfo);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineShaderStageCreateInfo(const VkPipelineShaderStageCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineShaderStageCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineShaderStageCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineShaderStageCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineShaderStageCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineShaderStageCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkShaderStageFlagBits(enc, &val->stage);
    vn_encode_VkShaderModule(enc, &val->module);
    if (val->pName) {
        const size_t string_size = strlen(val->pName) + 1;
        vn_encode_array_size(enc, string_size);
        vn_encode_char_array(enc, val->pName, string_size);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, val->pSpecializationInfo))
        vn_encode_VkSpecializationInfo(enc, val->pSpecializationInfo);
}

static inline void
vn_encode_VkPipelineShaderStageCreateInfo(struct vn_cs_encoder *enc, const VkPipelineShaderStageCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO });
    vn_encode_VkPipelineShaderStageCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineShaderStageCreateInfo_self(enc, val);
}

/* struct VkVertexInputBindingDescription */

static inline size_t
vn_sizeof_VkVertexInputBindingDescription(const VkVertexInputBindingDescription *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->binding);
    size += vn_sizeof_uint32_t(&val->stride);
    size += vn_sizeof_VkVertexInputRate(&val->inputRate);
    return size;
}

static inline void
vn_encode_VkVertexInputBindingDescription(struct vn_cs_encoder *enc, const VkVertexInputBindingDescription *val)
{
    vn_encode_uint32_t(enc, &val->binding);
    vn_encode_uint32_t(enc, &val->stride);
    vn_encode_VkVertexInputRate(enc, &val->inputRate);
}

/* struct VkVertexInputAttributeDescription */

static inline size_t
vn_sizeof_VkVertexInputAttributeDescription(const VkVertexInputAttributeDescription *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->location);
    size += vn_sizeof_uint32_t(&val->binding);
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_uint32_t(&val->offset);
    return size;
}

static inline void
vn_encode_VkVertexInputAttributeDescription(struct vn_cs_encoder *enc, const VkVertexInputAttributeDescription *val)
{
    vn_encode_uint32_t(enc, &val->location);
    vn_encode_uint32_t(enc, &val->binding);
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_uint32_t(enc, &val->offset);
}

/* struct VkPipelineVertexInputStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineVertexInputStateCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineVertexInputStateCreateInfo_self(const VkPipelineVertexInputStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->vertexBindingDescriptionCount);
    if (val->pVertexBindingDescriptions) {
        size += vn_sizeof_array_size(val->vertexBindingDescriptionCount);
        for (uint32_t i = 0; i < val->vertexBindingDescriptionCount; i++)
            size += vn_sizeof_VkVertexInputBindingDescription(&val->pVertexBindingDescriptions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->vertexAttributeDescriptionCount);
    if (val->pVertexAttributeDescriptions) {
        size += vn_sizeof_array_size(val->vertexAttributeDescriptionCount);
        for (uint32_t i = 0; i < val->vertexAttributeDescriptionCount; i++)
            size += vn_sizeof_VkVertexInputAttributeDescription(&val->pVertexAttributeDescriptions[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkPipelineVertexInputStateCreateInfo(const VkPipelineVertexInputStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineVertexInputStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineVertexInputStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineVertexInputStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineVertexInputStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineVertexInputStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->vertexBindingDescriptionCount);
    if (val->pVertexBindingDescriptions) {
        vn_encode_array_size(enc, val->vertexBindingDescriptionCount);
        for (uint32_t i = 0; i < val->vertexBindingDescriptionCount; i++)
            vn_encode_VkVertexInputBindingDescription(enc, &val->pVertexBindingDescriptions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->vertexAttributeDescriptionCount);
    if (val->pVertexAttributeDescriptions) {
        vn_encode_array_size(enc, val->vertexAttributeDescriptionCount);
        for (uint32_t i = 0; i < val->vertexAttributeDescriptionCount; i++)
            vn_encode_VkVertexInputAttributeDescription(enc, &val->pVertexAttributeDescriptions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkPipelineVertexInputStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineVertexInputStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO });
    vn_encode_VkPipelineVertexInputStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineVertexInputStateCreateInfo_self(enc, val);
}

/* struct VkPipelineInputAssemblyStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineInputAssemblyStateCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineInputAssemblyStateCreateInfo_self(const VkPipelineInputAssemblyStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkPrimitiveTopology(&val->topology);
    size += vn_sizeof_VkBool32(&val->primitiveRestartEnable);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineInputAssemblyStateCreateInfo(const VkPipelineInputAssemblyStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineInputAssemblyStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineInputAssemblyStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineInputAssemblyStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineInputAssemblyStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineInputAssemblyStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkPrimitiveTopology(enc, &val->topology);
    vn_encode_VkBool32(enc, &val->primitiveRestartEnable);
}

static inline void
vn_encode_VkPipelineInputAssemblyStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineInputAssemblyStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO });
    vn_encode_VkPipelineInputAssemblyStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineInputAssemblyStateCreateInfo_self(enc, val);
}

/* struct VkPipelineTessellationDomainOriginStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineTessellationDomainOriginStateCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineTessellationDomainOriginStateCreateInfo_self(const VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkTessellationDomainOrigin(&val->domainOrigin);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineTessellationDomainOriginStateCreateInfo(const VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineTessellationDomainOriginStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineTessellationDomainOriginStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineTessellationDomainOriginStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineTessellationDomainOriginStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkTessellationDomainOrigin(enc, &val->domainOrigin);
}

static inline void
vn_encode_VkPipelineTessellationDomainOriginStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO });
    vn_encode_VkPipelineTessellationDomainOriginStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineTessellationDomainOriginStateCreateInfo_self(enc, val);
}

/* struct VkPipelineTessellationStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineTessellationStateCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPipelineTessellationStateCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPipelineTessellationDomainOriginStateCreateInfo_self((const VkPipelineTessellationDomainOriginStateCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineTessellationStateCreateInfo_self(const VkPipelineTessellationStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->patchControlPoints);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineTessellationStateCreateInfo(const VkPipelineTessellationStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineTessellationStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineTessellationStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineTessellationStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPipelineTessellationStateCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPipelineTessellationDomainOriginStateCreateInfo_self(enc, (const VkPipelineTessellationDomainOriginStateCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineTessellationStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineTessellationStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->patchControlPoints);
}

static inline void
vn_encode_VkPipelineTessellationStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineTessellationStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO });
    vn_encode_VkPipelineTessellationStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineTessellationStateCreateInfo_self(enc, val);
}

/* struct VkPipelineViewportStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineViewportStateCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineViewportStateCreateInfo_self(const VkPipelineViewportStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->viewportCount);
    if (val->pViewports) {
        size += vn_sizeof_array_size(val->viewportCount);
        for (uint32_t i = 0; i < val->viewportCount; i++)
            size += vn_sizeof_VkViewport(&val->pViewports[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->scissorCount);
    if (val->pScissors) {
        size += vn_sizeof_array_size(val->scissorCount);
        for (uint32_t i = 0; i < val->scissorCount; i++)
            size += vn_sizeof_VkRect2D(&val->pScissors[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkPipelineViewportStateCreateInfo(const VkPipelineViewportStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineViewportStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineViewportStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineViewportStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineViewportStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineViewportStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->viewportCount);
    if (val->pViewports) {
        vn_encode_array_size(enc, val->viewportCount);
        for (uint32_t i = 0; i < val->viewportCount; i++)
            vn_encode_VkViewport(enc, &val->pViewports[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->scissorCount);
    if (val->pScissors) {
        vn_encode_array_size(enc, val->scissorCount);
        for (uint32_t i = 0; i < val->scissorCount; i++)
            vn_encode_VkRect2D(enc, &val->pScissors[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkPipelineViewportStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineViewportStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO });
    vn_encode_VkPipelineViewportStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineViewportStateCreateInfo_self(enc, val);
}

/* struct VkPipelineRasterizationStateStreamCreateInfoEXT chain */

static inline size_t
vn_sizeof_VkPipelineRasterizationStateStreamCreateInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineRasterizationStateStreamCreateInfoEXT_self(const VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->rasterizationStream);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineRasterizationStateStreamCreateInfoEXT(const VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineRasterizationStateStreamCreateInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkPipelineRasterizationStateStreamCreateInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineRasterizationStateStreamCreateInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineRasterizationStateStreamCreateInfoEXT_self(struct vn_cs_encoder *enc, const VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->rasterizationStream);
}

static inline void
vn_encode_VkPipelineRasterizationStateStreamCreateInfoEXT(struct vn_cs_encoder *enc, const VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT });
    vn_encode_VkPipelineRasterizationStateStreamCreateInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkPipelineRasterizationStateStreamCreateInfoEXT_self(enc, val);
}

/* struct VkPipelineRasterizationStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineRasterizationStateCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPipelineRasterizationStateCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPipelineRasterizationStateStreamCreateInfoEXT_self((const VkPipelineRasterizationStateStreamCreateInfoEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineRasterizationStateCreateInfo_self(const VkPipelineRasterizationStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkBool32(&val->depthClampEnable);
    size += vn_sizeof_VkBool32(&val->rasterizerDiscardEnable);
    size += vn_sizeof_VkPolygonMode(&val->polygonMode);
    size += vn_sizeof_VkFlags(&val->cullMode);
    size += vn_sizeof_VkFrontFace(&val->frontFace);
    size += vn_sizeof_VkBool32(&val->depthBiasEnable);
    size += vn_sizeof_float(&val->depthBiasConstantFactor);
    size += vn_sizeof_float(&val->depthBiasClamp);
    size += vn_sizeof_float(&val->depthBiasSlopeFactor);
    size += vn_sizeof_float(&val->lineWidth);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineRasterizationStateCreateInfo(const VkPipelineRasterizationStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineRasterizationStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineRasterizationStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineRasterizationStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPipelineRasterizationStateCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPipelineRasterizationStateStreamCreateInfoEXT_self(enc, (const VkPipelineRasterizationStateStreamCreateInfoEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineRasterizationStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineRasterizationStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkBool32(enc, &val->depthClampEnable);
    vn_encode_VkBool32(enc, &val->rasterizerDiscardEnable);
    vn_encode_VkPolygonMode(enc, &val->polygonMode);
    vn_encode_VkFlags(enc, &val->cullMode);
    vn_encode_VkFrontFace(enc, &val->frontFace);
    vn_encode_VkBool32(enc, &val->depthBiasEnable);
    vn_encode_float(enc, &val->depthBiasConstantFactor);
    vn_encode_float(enc, &val->depthBiasClamp);
    vn_encode_float(enc, &val->depthBiasSlopeFactor);
    vn_encode_float(enc, &val->lineWidth);
}

static inline void
vn_encode_VkPipelineRasterizationStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineRasterizationStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO });
    vn_encode_VkPipelineRasterizationStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineRasterizationStateCreateInfo_self(enc, val);
}

/* struct VkPipelineMultisampleStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineMultisampleStateCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineMultisampleStateCreateInfo_self(const VkPipelineMultisampleStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkSampleCountFlagBits(&val->rasterizationSamples);
    size += vn_sizeof_VkBool32(&val->sampleShadingEnable);
    size += vn_sizeof_float(&val->minSampleShading);
    if (val->pSampleMask) {
        size += vn_sizeof_array_size((val->rasterizationSamples + 31) / 32);
        size += vn_sizeof_VkSampleMask_array(val->pSampleMask, (val->rasterizationSamples + 31) / 32);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_VkBool32(&val->alphaToCoverageEnable);
    size += vn_sizeof_VkBool32(&val->alphaToOneEnable);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineMultisampleStateCreateInfo(const VkPipelineMultisampleStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineMultisampleStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineMultisampleStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineMultisampleStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineMultisampleStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineMultisampleStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkSampleCountFlagBits(enc, &val->rasterizationSamples);
    vn_encode_VkBool32(enc, &val->sampleShadingEnable);
    vn_encode_float(enc, &val->minSampleShading);
    if (val->pSampleMask) {
        vn_encode_array_size(enc, (val->rasterizationSamples + 31) / 32);
        vn_encode_VkSampleMask_array(enc, val->pSampleMask, (val->rasterizationSamples + 31) / 32);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkBool32(enc, &val->alphaToCoverageEnable);
    vn_encode_VkBool32(enc, &val->alphaToOneEnable);
}

static inline void
vn_encode_VkPipelineMultisampleStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineMultisampleStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO });
    vn_encode_VkPipelineMultisampleStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineMultisampleStateCreateInfo_self(enc, val);
}

/* struct VkStencilOpState */

static inline size_t
vn_sizeof_VkStencilOpState(const VkStencilOpState *val)
{
    size_t size = 0;
    size += vn_sizeof_VkStencilOp(&val->failOp);
    size += vn_sizeof_VkStencilOp(&val->passOp);
    size += vn_sizeof_VkStencilOp(&val->depthFailOp);
    size += vn_sizeof_VkCompareOp(&val->compareOp);
    size += vn_sizeof_uint32_t(&val->compareMask);
    size += vn_sizeof_uint32_t(&val->writeMask);
    size += vn_sizeof_uint32_t(&val->reference);
    return size;
}

static inline void
vn_encode_VkStencilOpState(struct vn_cs_encoder *enc, const VkStencilOpState *val)
{
    vn_encode_VkStencilOp(enc, &val->failOp);
    vn_encode_VkStencilOp(enc, &val->passOp);
    vn_encode_VkStencilOp(enc, &val->depthFailOp);
    vn_encode_VkCompareOp(enc, &val->compareOp);
    vn_encode_uint32_t(enc, &val->compareMask);
    vn_encode_uint32_t(enc, &val->writeMask);
    vn_encode_uint32_t(enc, &val->reference);
}

/* struct VkPipelineDepthStencilStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineDepthStencilStateCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineDepthStencilStateCreateInfo_self(const VkPipelineDepthStencilStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkBool32(&val->depthTestEnable);
    size += vn_sizeof_VkBool32(&val->depthWriteEnable);
    size += vn_sizeof_VkCompareOp(&val->depthCompareOp);
    size += vn_sizeof_VkBool32(&val->depthBoundsTestEnable);
    size += vn_sizeof_VkBool32(&val->stencilTestEnable);
    size += vn_sizeof_VkStencilOpState(&val->front);
    size += vn_sizeof_VkStencilOpState(&val->back);
    size += vn_sizeof_float(&val->minDepthBounds);
    size += vn_sizeof_float(&val->maxDepthBounds);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineDepthStencilStateCreateInfo(const VkPipelineDepthStencilStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineDepthStencilStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineDepthStencilStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineDepthStencilStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineDepthStencilStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineDepthStencilStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkBool32(enc, &val->depthTestEnable);
    vn_encode_VkBool32(enc, &val->depthWriteEnable);
    vn_encode_VkCompareOp(enc, &val->depthCompareOp);
    vn_encode_VkBool32(enc, &val->depthBoundsTestEnable);
    vn_encode_VkBool32(enc, &val->stencilTestEnable);
    vn_encode_VkStencilOpState(enc, &val->front);
    vn_encode_VkStencilOpState(enc, &val->back);
    vn_encode_float(enc, &val->minDepthBounds);
    vn_encode_float(enc, &val->maxDepthBounds);
}

static inline void
vn_encode_VkPipelineDepthStencilStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineDepthStencilStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO });
    vn_encode_VkPipelineDepthStencilStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineDepthStencilStateCreateInfo_self(enc, val);
}

/* struct VkPipelineColorBlendAttachmentState */

static inline size_t
vn_sizeof_VkPipelineColorBlendAttachmentState(const VkPipelineColorBlendAttachmentState *val)
{
    size_t size = 0;
    size += vn_sizeof_VkBool32(&val->blendEnable);
    size += vn_sizeof_VkBlendFactor(&val->srcColorBlendFactor);
    size += vn_sizeof_VkBlendFactor(&val->dstColorBlendFactor);
    size += vn_sizeof_VkBlendOp(&val->colorBlendOp);
    size += vn_sizeof_VkBlendFactor(&val->srcAlphaBlendFactor);
    size += vn_sizeof_VkBlendFactor(&val->dstAlphaBlendFactor);
    size += vn_sizeof_VkBlendOp(&val->alphaBlendOp);
    size += vn_sizeof_VkFlags(&val->colorWriteMask);
    return size;
}

static inline void
vn_encode_VkPipelineColorBlendAttachmentState(struct vn_cs_encoder *enc, const VkPipelineColorBlendAttachmentState *val)
{
    vn_encode_VkBool32(enc, &val->blendEnable);
    vn_encode_VkBlendFactor(enc, &val->srcColorBlendFactor);
    vn_encode_VkBlendFactor(enc, &val->dstColorBlendFactor);
    vn_encode_VkBlendOp(enc, &val->colorBlendOp);
    vn_encode_VkBlendFactor(enc, &val->srcAlphaBlendFactor);
    vn_encode_VkBlendFactor(enc, &val->dstAlphaBlendFactor);
    vn_encode_VkBlendOp(enc, &val->alphaBlendOp);
    vn_encode_VkFlags(enc, &val->colorWriteMask);
}

/* struct VkPipelineColorBlendStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineColorBlendStateCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineColorBlendStateCreateInfo_self(const VkPipelineColorBlendStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkBool32(&val->logicOpEnable);
    size += vn_sizeof_VkLogicOp(&val->logicOp);
    size += vn_sizeof_uint32_t(&val->attachmentCount);
    if (val->pAttachments) {
        size += vn_sizeof_array_size(val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            size += vn_sizeof_VkPipelineColorBlendAttachmentState(&val->pAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_array_size(4);
    size += vn_sizeof_float_array(val->blendConstants, 4);
    return size;
}

static inline size_t
vn_sizeof_VkPipelineColorBlendStateCreateInfo(const VkPipelineColorBlendStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineColorBlendStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineColorBlendStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineColorBlendStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineColorBlendStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineColorBlendStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkBool32(enc, &val->logicOpEnable);
    vn_encode_VkLogicOp(enc, &val->logicOp);
    vn_encode_uint32_t(enc, &val->attachmentCount);
    if (val->pAttachments) {
        vn_encode_array_size(enc, val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_encode_VkPipelineColorBlendAttachmentState(enc, &val->pAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_array_size(enc, 4);
    vn_encode_float_array(enc, val->blendConstants, 4);
}

static inline void
vn_encode_VkPipelineColorBlendStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineColorBlendStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO });
    vn_encode_VkPipelineColorBlendStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineColorBlendStateCreateInfo_self(enc, val);
}

/* struct VkPipelineDynamicStateCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineDynamicStateCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineDynamicStateCreateInfo_self(const VkPipelineDynamicStateCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->dynamicStateCount);
    if (val->pDynamicStates) {
        size += vn_sizeof_array_size(val->dynamicStateCount);
        size += vn_sizeof_VkDynamicState_array(val->pDynamicStates, val->dynamicStateCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkPipelineDynamicStateCreateInfo(const VkPipelineDynamicStateCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineDynamicStateCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineDynamicStateCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineDynamicStateCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineDynamicStateCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineDynamicStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->dynamicStateCount);
    if (val->pDynamicStates) {
        vn_encode_array_size(enc, val->dynamicStateCount);
        vn_encode_VkDynamicState_array(enc, val->pDynamicStates, val->dynamicStateCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkPipelineDynamicStateCreateInfo(struct vn_cs_encoder *enc, const VkPipelineDynamicStateCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO });
    vn_encode_VkPipelineDynamicStateCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineDynamicStateCreateInfo_self(enc, val);
}

/* struct VkGraphicsPipelineCreateInfo chain */

static inline size_t
vn_sizeof_VkGraphicsPipelineCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkGraphicsPipelineCreateInfo_self(const VkGraphicsPipelineCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->stageCount);
    if (val->pStages) {
        size += vn_sizeof_array_size(val->stageCount);
        for (uint32_t i = 0; i < val->stageCount; i++)
            size += vn_sizeof_VkPipelineShaderStageCreateInfo(&val->pStages[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_simple_pointer(val->pVertexInputState);
    if (val->pVertexInputState)
        size += vn_sizeof_VkPipelineVertexInputStateCreateInfo(val->pVertexInputState);
    size += vn_sizeof_simple_pointer(val->pInputAssemblyState);
    if (val->pInputAssemblyState)
        size += vn_sizeof_VkPipelineInputAssemblyStateCreateInfo(val->pInputAssemblyState);
    size += vn_sizeof_simple_pointer(val->pTessellationState);
    if (val->pTessellationState)
        size += vn_sizeof_VkPipelineTessellationStateCreateInfo(val->pTessellationState);
    size += vn_sizeof_simple_pointer(val->pViewportState);
    if (val->pViewportState)
        size += vn_sizeof_VkPipelineViewportStateCreateInfo(val->pViewportState);
    size += vn_sizeof_simple_pointer(val->pRasterizationState);
    if (val->pRasterizationState)
        size += vn_sizeof_VkPipelineRasterizationStateCreateInfo(val->pRasterizationState);
    size += vn_sizeof_simple_pointer(val->pMultisampleState);
    if (val->pMultisampleState)
        size += vn_sizeof_VkPipelineMultisampleStateCreateInfo(val->pMultisampleState);
    size += vn_sizeof_simple_pointer(val->pDepthStencilState);
    if (val->pDepthStencilState)
        size += vn_sizeof_VkPipelineDepthStencilStateCreateInfo(val->pDepthStencilState);
    size += vn_sizeof_simple_pointer(val->pColorBlendState);
    if (val->pColorBlendState)
        size += vn_sizeof_VkPipelineColorBlendStateCreateInfo(val->pColorBlendState);
    size += vn_sizeof_simple_pointer(val->pDynamicState);
    if (val->pDynamicState)
        size += vn_sizeof_VkPipelineDynamicStateCreateInfo(val->pDynamicState);
    size += vn_sizeof_VkPipelineLayout(&val->layout);
    size += vn_sizeof_VkRenderPass(&val->renderPass);
    size += vn_sizeof_uint32_t(&val->subpass);
    size += vn_sizeof_VkPipeline(&val->basePipelineHandle);
    size += vn_sizeof_int32_t(&val->basePipelineIndex);
    return size;
}

static inline size_t
vn_sizeof_VkGraphicsPipelineCreateInfo(const VkGraphicsPipelineCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkGraphicsPipelineCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkGraphicsPipelineCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkGraphicsPipelineCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkGraphicsPipelineCreateInfo_self(struct vn_cs_encoder *enc, const VkGraphicsPipelineCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->stageCount);
    if (val->pStages) {
        vn_encode_array_size(enc, val->stageCount);
        for (uint32_t i = 0; i < val->stageCount; i++)
            vn_encode_VkPipelineShaderStageCreateInfo(enc, &val->pStages[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, val->pVertexInputState))
        vn_encode_VkPipelineVertexInputStateCreateInfo(enc, val->pVertexInputState);
    if (vn_encode_simple_pointer(enc, val->pInputAssemblyState))
        vn_encode_VkPipelineInputAssemblyStateCreateInfo(enc, val->pInputAssemblyState);
    if (vn_encode_simple_pointer(enc, val->pTessellationState))
        vn_encode_VkPipelineTessellationStateCreateInfo(enc, val->pTessellationState);
    if (vn_encode_simple_pointer(enc, val->pViewportState))
        vn_encode_VkPipelineViewportStateCreateInfo(enc, val->pViewportState);
    if (vn_encode_simple_pointer(enc, val->pRasterizationState))
        vn_encode_VkPipelineRasterizationStateCreateInfo(enc, val->pRasterizationState);
    if (vn_encode_simple_pointer(enc, val->pMultisampleState))
        vn_encode_VkPipelineMultisampleStateCreateInfo(enc, val->pMultisampleState);
    if (vn_encode_simple_pointer(enc, val->pDepthStencilState))
        vn_encode_VkPipelineDepthStencilStateCreateInfo(enc, val->pDepthStencilState);
    if (vn_encode_simple_pointer(enc, val->pColorBlendState))
        vn_encode_VkPipelineColorBlendStateCreateInfo(enc, val->pColorBlendState);
    if (vn_encode_simple_pointer(enc, val->pDynamicState))
        vn_encode_VkPipelineDynamicStateCreateInfo(enc, val->pDynamicState);
    vn_encode_VkPipelineLayout(enc, &val->layout);
    vn_encode_VkRenderPass(enc, &val->renderPass);
    vn_encode_uint32_t(enc, &val->subpass);
    vn_encode_VkPipeline(enc, &val->basePipelineHandle);
    vn_encode_int32_t(enc, &val->basePipelineIndex);
}

static inline void
vn_encode_VkGraphicsPipelineCreateInfo(struct vn_cs_encoder *enc, const VkGraphicsPipelineCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO });
    vn_encode_VkGraphicsPipelineCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkGraphicsPipelineCreateInfo_self(enc, val);
}

/* struct VkComputePipelineCreateInfo chain */

static inline size_t
vn_sizeof_VkComputePipelineCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkComputePipelineCreateInfo_self(const VkComputePipelineCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkPipelineShaderStageCreateInfo(&val->stage);
    size += vn_sizeof_VkPipelineLayout(&val->layout);
    size += vn_sizeof_VkPipeline(&val->basePipelineHandle);
    size += vn_sizeof_int32_t(&val->basePipelineIndex);
    return size;
}

static inline size_t
vn_sizeof_VkComputePipelineCreateInfo(const VkComputePipelineCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkComputePipelineCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkComputePipelineCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkComputePipelineCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkComputePipelineCreateInfo_self(struct vn_cs_encoder *enc, const VkComputePipelineCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkPipelineShaderStageCreateInfo(enc, &val->stage);
    vn_encode_VkPipelineLayout(enc, &val->layout);
    vn_encode_VkPipeline(enc, &val->basePipelineHandle);
    vn_encode_int32_t(enc, &val->basePipelineIndex);
}

static inline void
vn_encode_VkComputePipelineCreateInfo(struct vn_cs_encoder *enc, const VkComputePipelineCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO });
    vn_encode_VkComputePipelineCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkComputePipelineCreateInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkCreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateGraphicsPipelines_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkPipelineCache(&pipelineCache);
    cmd_size += vn_sizeof_uint32_t(&createInfoCount);
    if (pCreateInfos) {
        cmd_size += vn_sizeof_array_size(createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            cmd_size += vn_sizeof_VkGraphicsPipelineCreateInfo(&pCreateInfos[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    if (pPipelines) {
        cmd_size += vn_sizeof_array_size(createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            cmd_size += vn_sizeof_VkPipeline(&pPipelines[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCreateGraphicsPipelines(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateGraphicsPipelines_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkPipelineCache(enc, &pipelineCache);
    vn_encode_uint32_t(enc, &createInfoCount);
    if (pCreateInfos) {
        vn_encode_array_size(enc, createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            vn_encode_VkGraphicsPipelineCreateInfo(enc, &pCreateInfos[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (pPipelines) {
        vn_encode_array_size(enc, createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            vn_encode_VkPipeline(enc, &pPipelines[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCreateGraphicsPipelines_reply(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateGraphicsPipelines_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pipelineCache */
    /* skip createInfoCount */
    /* skip pCreateInfos */
    /* skip pAllocator */
    if (pPipelines) {
        cmd_size += vn_sizeof_array_size(createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            cmd_size += vn_sizeof_VkPipeline(&pPipelines[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateGraphicsPipelines_reply(struct vn_cs_decoder *dec, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateGraphicsPipelines_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pipelineCache */
    /* skip createInfoCount */
    /* skip pCreateInfos */
    /* skip pAllocator */
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, createInfoCount);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPipeline(dec, &pPipelines[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pPipelines = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkCreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateComputePipelines_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkPipelineCache(&pipelineCache);
    cmd_size += vn_sizeof_uint32_t(&createInfoCount);
    if (pCreateInfos) {
        cmd_size += vn_sizeof_array_size(createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            cmd_size += vn_sizeof_VkComputePipelineCreateInfo(&pCreateInfos[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    if (pPipelines) {
        cmd_size += vn_sizeof_array_size(createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            cmd_size += vn_sizeof_VkPipeline(&pPipelines[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCreateComputePipelines(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateComputePipelines_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkPipelineCache(enc, &pipelineCache);
    vn_encode_uint32_t(enc, &createInfoCount);
    if (pCreateInfos) {
        vn_encode_array_size(enc, createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            vn_encode_VkComputePipelineCreateInfo(enc, &pCreateInfos[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (pPipelines) {
        vn_encode_array_size(enc, createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            vn_encode_VkPipeline(enc, &pPipelines[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCreateComputePipelines_reply(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateComputePipelines_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pipelineCache */
    /* skip createInfoCount */
    /* skip pCreateInfos */
    /* skip pAllocator */
    if (pPipelines) {
        cmd_size += vn_sizeof_array_size(createInfoCount);
        for (uint32_t i = 0; i < createInfoCount; i++)
            cmd_size += vn_sizeof_VkPipeline(&pPipelines[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateComputePipelines_reply(struct vn_cs_decoder *dec, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateComputePipelines_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pipelineCache */
    /* skip createInfoCount */
    /* skip pCreateInfos */
    /* skip pAllocator */
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, createInfoCount);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPipeline(dec, &pPipelines[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pPipelines = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPipeline_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkPipeline(&pipeline);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyPipeline(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPipeline_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkPipeline(enc, &pipeline);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyPipeline_reply(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPipeline_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pipeline */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyPipeline_reply(struct vn_cs_decoder *dec, VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyPipeline_EXT);

    /* skip device */
    /* skip pipeline */
    /* skip pAllocator */
}

static inline void vn_submit_vkCreateGraphicsPipelines(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateGraphicsPipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateGraphicsPipelines_reply(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateGraphicsPipelines(enc, cmd_flags, device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCreateComputePipelines(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateComputePipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateComputePipelines_reply(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateComputePipelines(enc, cmd_flags, device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroyPipeline(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyPipeline(device, pipeline, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyPipeline_reply(device, pipeline, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyPipeline(enc, cmd_flags, device, pipeline, pAllocator);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkCreateGraphicsPipelines(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkCreateGraphicsPipelines(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateGraphicsPipelines_reply(dec, device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateGraphicsPipelines(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreateGraphicsPipelines(vn_instance, 0, device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, &submit);
}

static inline VkResult vn_call_vkCreateComputePipelines(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkCreateComputePipelines(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateComputePipelines_reply(dec, device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateComputePipelines(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreateComputePipelines(vn_instance, 0, device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines, &submit);
}

static inline void vn_call_vkDestroyPipeline(struct vn_instance *vn_instance, VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyPipeline(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pipeline, pAllocator, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkDestroyPipeline_reply(dec, device, pipeline, pAllocator);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkDestroyPipeline(struct vn_instance *vn_instance, VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyPipeline(vn_instance, 0, device, pipeline, pAllocator, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_PIPELINE_H */
