/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.sql.Date;
import java.text.SimpleDateFormat;

public class Timestamp
extends java.util.Date {
    private static SimpleDateFormat parse_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
    private static SimpleDateFormat format_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final long serialVersionUID = 3581463369166924961L;
    private int nanos;

    public static Timestamp valueOf(String str) {
        try {
            Date d = (Date)parse_sdf.parseObject(str);
            return new Timestamp(d.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Timestamp(int year, int month, int day, int hour, int minute, int second, int nanos) {
        super(year, month, day, hour, minute, second);
        this.nanos = nanos;
    }

    public Timestamp(long date) {
        super(date);
    }

    public String toString() {
        return format_sdf.format(this) + "." + this.getNanos();
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int nanos) {
        this.nanos = nanos;
    }

    public boolean before(Timestamp ts) {
        if (ts.getTime() > this.getTime()) {
            return true;
        }
        return ts.getNanos() > this.getNanos();
    }

    public boolean after(Timestamp ts) {
        if (ts.getTime() < this.getTime()) {
            return true;
        }
        return ts.getNanos() < this.getNanos();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timestamp)) {
            return false;
        }
        return this.equals((Timestamp)obj);
    }

    public boolean equals(Timestamp ts) {
        if (ts == null) {
            return false;
        }
        if (ts.getTime() != this.getTime()) {
            return false;
        }
        return ts.getNanos() == this.getNanos();
    }
}

