/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.DummySignature;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;

public abstract class Signature
extends SignatureSpi {
    protected static final int UNINITIALIZED = 1;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state;
    private String algorithm;
    private Provider provider;

    private /* synthetic */ void finit$() {
        this.state = 1;
    }

    protected Signature(String algorithm) {
        this.finit$();
        this.algorithm = algorithm;
        this.state = 1;
    }

    public static Signature getInstance(String algorithm) throws NoSuchAlgorithmException {
        String name = "Signature." + algorithm;
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            String classname = p[i].getProperty(name);
            if (classname == null) continue;
            return Signature.getInstance(classname, algorithm, p[i]);
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static Signature getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException();
        }
        return Signature.getInstance(p.getProperty("Signature." + algorithm), algorithm, p);
    }

    private static Signature getInstance(String classname, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            Signature sig;
            Object o = Class.forName(classname).newInstance();
            if (o instanceof SignatureSpi) {
                sig = new DummySignature((SignatureSpi)o, algorithm);
            } else {
                sig = (Signature)o;
                sig.algorithm = algorithm;
            }
            sig.provider = provider;
            return sig;
        }
        catch (ClassNotFoundException cnfe) {
            throw new NoSuchAlgorithmException("Class not found");
        }
        catch (InstantiationException ie) {
            throw new NoSuchAlgorithmException("Class instantiation failed");
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchAlgorithmException("Illegal Access");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.state = 3;
        this.engineInitVerify(publicKey);
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        X509Certificate cert;
        boolean[] array;
        this.state = 3;
        if (certificate.getType().equals("X509") && (array = (cert = (X509Certificate)certificate).getKeyUsage()) != null && !array[0]) {
            throw new InvalidKeyException("KeyUsage of this Certificate indicates it cannot be used for digital signing");
        }
        this.initVerify(certificate.getPublicKey());
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.state = 2;
        this.engineInitSign(privateKey);
    }

    public final void initSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.state = 2;
        this.engineInitSign(privateKey, random);
    }

    public final byte[] sign() throws SignatureException {
        if (this.state == 2) {
            this.state = 1;
            return this.engineSign();
        }
        throw new SignatureException();
    }

    public final int sign(byte[] outbuf, int offset, int len) throws SignatureException {
        if (this.state == 2) {
            this.state = 1;
            return this.engineSign(outbuf, offset, len);
        }
        throw new SignatureException();
    }

    public final boolean verify(byte[] signature) throws SignatureException {
        if (this.state == 3) {
            this.state = 1;
            return this.engineVerify(signature);
        }
        throw new SignatureException();
    }

    public final void update(byte b) throws SignatureException {
        if (this.state == 1) {
            throw new SignatureException();
        }
        this.engineUpdate(b);
    }

    public final void update(byte[] data) throws SignatureException {
        if (this.state == 1) {
            throw new SignatureException();
        }
        this.engineUpdate(data, 0, data.length);
    }

    public final void update(byte[] data, int off, int len) throws SignatureException {
        if (this.state == 1) {
            throw new SignatureException();
        }
        this.engineUpdate(data, off, len);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return this.algorithm + " Signature";
    }

    public final void setParameter(String param, Object value) throws InvalidParameterException {
        this.engineSetParameter(param, value);
    }

    public final void setParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(params);
    }

    public final Object getParameter(String param) throws InvalidParameterException {
        return this.engineGetParameter(param);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

