/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class Runtime {
    private static Runtime self = new Runtime();
    private boolean finalize_on_exit;

    public Process exec(String prog) throws IOException {
        return this.exec(prog, null);
    }

    public Process exec(String prog, String[] envp) throws IOException {
        StringTokenizer st = new StringTokenizer(prog);
        String[] a = new String[st.countTokens()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = st.nextToken();
        }
        return this.exec(a, envp);
    }

    public Process exec(String[] progarray) throws IOException {
        return this.exec(progarray, null);
    }

    public Process exec(String[] progarray, String[] envp) throws IOException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(progarray[0]);
        }
        return new ConcreteProcess(progarray, envp);
    }

    private static final void checkExit(int status) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExit(status);
        }
    }

    public native void exit(int var1);

    final native void _exit(int var1);

    public native long freeMemory();

    public native void gc();

    public InputStream getLocalizedInputStream(InputStream in) {
        return in;
    }

    public OutputStream getLocalizedOutputStream(OutputStream out) {
        return out;
    }

    public static Runtime getRuntime() {
        return self;
    }

    private final void checkLink(String lib) {
        if (lib == null) {
            throw new NullPointerException();
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkLink(lib);
        }
    }

    private native void _load(String var1, boolean var2);

    public void load(String pathname) {
        this._load(pathname, false);
    }

    public void loadLibrary(String libname) {
        this._load(libname, true);
    }

    native boolean loadLibraryInternal(String var1);

    public native void runFinalization();

    public static void runFinalizersOnExit(boolean run) {
        Runtime.checkExit(0);
        Runtime.self.finalize_on_exit = run;
    }

    public native long totalMemory();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    private final native void init();

    private Runtime() {
        this.init();
    }
}

