/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    PipedInputStream sink;
    boolean closed;

    public PipedOutputStream() {
    }

    public PipedOutputStream(PipedInputStream sink) throws IOException {
        sink.connect(this);
    }

    public void connect(PipedInputStream sink) throws IOException {
        if (sink != null) {
            throw new IOException("Already connected");
        }
        sink.connect(this);
    }

    public void write(int b) throws IOException {
        if (this.sink == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink.receive(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sink == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink.receive(b, off, len);
    }

    public void flush() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        if (this.sink == null) return;
        this.closed = true;
        PipedInputStream pipedInputStream = this.sink;
        synchronized (pipedInputStream) {
            try {
                this.sink.notifyAll();
                return;
            }
            finally {
                Object var2_2 = null;
            }
        }
    }
}

