/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    boolean ignoreInitialNewline;
    byte[] buf;

    private /* synthetic */ void finit$() {
        this.ignoreInitialNewline = false;
        this.buf = new byte[8];
    }

    public DataInputStream(InputStream in) {
        super(in);
        this.finit$();
    }

    public final int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public final boolean readBoolean() throws IOException {
        return DataInputStream.convertToBoolean(this.in.read());
    }

    public final byte readByte() throws IOException {
        return DataInputStream.convertToByte(this.in.read());
    }

    public final char readChar() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToChar(this.buf);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int numread = this.in.read(b, off, len);
            if (numread < 0) {
                throw new EOFException();
            }
            len -= numread;
            off += numread;
        }
    }

    public final int readInt() throws IOException {
        this.readFully(this.buf, 0, 4);
        return DataInputStream.convertToInt(this.buf);
    }

    public final String readLine() throws IOException {
        StringBuffer strb = new StringBuffer();
        block0: while (true) {
            int c = 0;
            char ch = ' ';
            boolean getnext = true;
            while (getnext) {
                getnext = false;
                c = this.in.read();
                if (c < 0) {
                    if (strb.length() > 0) {
                        return strb.toString();
                    }
                    return null;
                }
                ch = (char)c;
                if ((ch = (char)(ch & 0xFF)) != 10) continue;
                if (!this.ignoreInitialNewline) break block0;
                this.ignoreInitialNewline = false;
                getnext = true;
            }
            if (ch == '\r') {
                int next_c = 0;
                int next_ch = 32;
                if (this.in instanceof BufferedInputStream) {
                    next_c = this.in.read();
                    next_ch = (char)(next_c & 0xFF);
                    if (next_ch == 10 || next_c < 0) break;
                    BufferedInputStream bin = (BufferedInputStream)this.in;
                    if (bin.pos <= 0) break;
                    --bin.pos;
                    break;
                }
                if (this.markSupported()) {
                    next_c = this.in.read();
                    next_ch = (char)(next_c & 0xFF);
                    if (next_ch == 10 || next_c < 0) break;
                    this.mark(1);
                    if ((this.in.read() & 0xFF) == 10) break;
                    this.reset();
                    break;
                }
                this.ignoreInitialNewline = true;
                break;
            }
            strb.append(ch);
        }
        if (strb.length() > 0) {
            return strb.toString();
        }
        return "";
    }

    public final long readLong() throws IOException {
        this.readFully(this.buf, 0, 8);
        return DataInputStream.convertToLong(this.buf);
    }

    public final short readShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToShort(this.buf);
    }

    public final int readUnsignedByte() throws IOException {
        return DataInputStream.convertToUnsignedByte(this.in.read());
    }

    public final int readUnsignedShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToUnsignedShort(this.buf);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput in) throws IOException {
        int UTFlen = in.readUnsignedShort();
        byte[] buf = new byte[UTFlen];
        in.readFully(buf, 0, UTFlen);
        return DataInputStream.convertFromUTF(buf);
    }

    public final int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        try {
            return (int)this.in.skip(n);
        }
        catch (EOFException eOFException) {
            return n;
        }
    }

    static boolean convertToBoolean(int b) throws EOFException {
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    static byte convertToByte(int i) throws EOFException {
        if (i < 0) {
            throw new EOFException();
        }
        return (byte)i;
    }

    static int convertToUnsignedByte(int i) throws EOFException {
        if (i < 0) {
            throw new EOFException();
        }
        return i & 0xFF;
    }

    static char convertToChar(byte[] buf) {
        return (char)(buf[0] << 8 | buf[1] & 0xFF);
    }

    static short convertToShort(byte[] buf) {
        return (short)((short)(buf[0] << 8) | (short)buf[1] & 0xFF);
    }

    static int convertToUnsignedShort(byte[] buf) {
        return (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
    }

    static int convertToInt(byte[] buf) {
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    static long convertToLong(byte[] buf) {
        return (long)(buf[0] & 0xFF) << 56 | (long)(buf[1] & 0xFF) << 48 | (long)(buf[2] & 0xFF) << 40 | (long)(buf[3] & 0xFF) << 32 | (long)(buf[4] & 0xFF) << 24 | (long)(buf[5] & 0xFF) << 16 | (long)(buf[6] & 0xFF) << 8 | (long)(buf[7] & 0xFF);
    }

    static String convertFromUTF(byte[] buf) throws EOFException, UTFDataFormatException {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < buf.length) {
            if ((buf[i] & 0x80) == 0) {
                strbuf.append((char)(buf[i++] & 0xFF));
                continue;
            }
            if ((buf[i] & 0xE0) == 192) {
                if (i + 1 >= buf.length || (buf[i + 1] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                strbuf.append((char)((buf[i++] & 0x1F) << 6 | buf[i++] & 0x3F));
                continue;
            }
            if ((buf[i] & 0xF0) == 224) {
                if (i + 2 >= buf.length || (buf[i + 1] & 0xC0) != 128 || (buf[i + 2] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                strbuf.append((char)((buf[i++] & 0xF) << 12 | (buf[i++] & 0x3F) << 6 | buf[i++] & 0x3F));
                continue;
            }
            throw new UTFDataFormatException();
        }
        return strbuf.toString();
    }
}

