/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.Serializable;
import java.util.Vector;

public class Choice
extends Component
implements ItemSelectable,
Serializable {
    private static final long serialVersionUID = -4075310674757313071L;
    private Vector pItems;
    private int selectedIndex;
    private ItemListener item_listeners;

    private /* synthetic */ void finit$() {
        this.pItems = new Vector();
        this.selectedIndex = -1;
    }

    public Choice() {
        this.finit$();
    }

    public int getItemCount() {
        return this.pItems.size();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int index) {
        return (String)this.pItems.elementAt(index);
    }

    public synchronized void add(String item) {
        if (item == null) {
            throw new IllegalArgumentException("item must be non-null");
        }
        this.pItems.addElement(item);
        int i = this.pItems.size() - 1;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.add(item, i);
        }
        if (i == 0) {
            this.select(0);
        }
    }

    public synchronized void addItem(String item) {
        this.add(item);
    }

    public synchronized void insert(String item, int index) {
        if (index > this.getItemCount()) {
            index = this.getItemCount();
        }
        this.pItems.insertElementAt(item, index);
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.add(item, index);
        }
        if (this.getItemCount() == 1 || this.selectedIndex >= index) {
            this.select(0);
        }
    }

    public synchronized void remove(String item) {
        int index = this.pItems.indexOf(item);
        if (index == -1) {
            throw new IllegalArgumentException("item \"" + item + "\" not found in Choice");
        }
        this.remove(index);
    }

    public synchronized void remove(int index) {
        this.pItems.removeElementAt(index);
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.remove(index);
        }
        if (index == this.selectedIndex) {
            this.select(0);
        } else if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
    }

    public synchronized void removeAll() {
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.remove(0);
        }
    }

    public synchronized String getSelectedItem() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return (String)this.pItems.elementAt(this.selectedIndex);
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex == -1) {
            return null;
        }
        Object[] objs = new Object[]{this.pItems.elementAt(this.selectedIndex)};
        return objs;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int index) {
        if (index < 0 || index > this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + index);
        }
        this.selectedIndex = index;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.select(index);
        }
    }

    public synchronized void select(String item) {
        int index = this.pItems.indexOf(item);
        if (index >= 0) {
            this.select(index);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
        super.addNotify();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    protected String paramString() {
        return "selectedIndex=" + this.selectedIndex + "," + super.paramString();
    }
}

