/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import java.util.Random;

public class SHA1PRNG
extends SecureRandomSpi
implements Serializable {
    MessageDigest digest;
    byte[] seed;
    byte[] data;
    int seedpos;
    int datapos;

    public SHA1PRNG() {
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            System.out.println("Failed to find SHA Message Digest: " + nsae);
            nsae.printStackTrace();
        }
        this.seed = new byte[20];
        this.seedpos = 0;
        this.data = new byte[40];
        this.datapos = 0;
        new Random().nextBytes(this.seed);
        byte[] digestdata = this.digest.digest(this.data);
        System.arraycopy(digestdata, 0, this.data, 0, 20);
    }

    public void engineSetSeed(byte[] seed) {
        for (int i = 0; i < seed.length; ++i) {
            int n = this.seedpos++ % 20;
            this.seed[n] = this.seed[n] ^ seed[i];
        }
        this.seedpos %= 20;
    }

    public void engineNextBytes(byte[] bytes) {
        int loc = 0;
        while (loc < bytes.length) {
            int copy = Math.min(bytes.length - loc, 20 - this.datapos);
            if (copy > 0) {
                System.arraycopy(this.data, this.datapos, bytes, loc, copy);
                this.datapos += copy;
                loc += copy;
                continue;
            }
            System.arraycopy(this.seed, 0, this.data, 20, 20);
            byte[] digestdata = this.digest.digest(this.data);
            System.arraycopy(digestdata, 0, this.data, 0, 20);
            this.datapos = 0;
        }
    }

    public byte[] engineGenerateSeed(int numBytes) {
        byte[] tmp = new byte[numBytes];
        this.engineNextBytes(tmp);
        return tmp;
    }
}

