/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_epmapper.h"

static bool api_epm_Insert(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct epm_Insert *r;

	call = &ndr_table_epmapper.calls[NDR_EPM_INSERT];

	r = talloc(talloc_tos(), struct epm_Insert);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(epm_Insert, r);
	}

	r->out.result = _epm_Insert(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(epm_Insert, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_epm_Delete(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct epm_Delete *r;

	call = &ndr_table_epmapper.calls[NDR_EPM_DELETE];

	r = talloc(talloc_tos(), struct epm_Delete);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(epm_Delete, r);
	}

	r->out.result = _epm_Delete(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(epm_Delete, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_epm_Lookup(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct epm_Lookup *r;

	call = &ndr_table_epmapper.calls[NDR_EPM_LOOKUP];

	r = talloc(talloc_tos(), struct epm_Lookup);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(epm_Lookup, r);
	}

	ZERO_STRUCT(r->out);
	r->out.entry_handle = r->in.entry_handle;
	r->out.num_ents = talloc_zero(r, uint32_t);
	if (r->out.num_ents == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.entries = talloc_zero_array(r, struct epm_entry_t, r->in.max_ents);
	if (r->out.entries == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _epm_Lookup(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(epm_Lookup, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_epm_Map(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct epm_Map *r;

	call = &ndr_table_epmapper.calls[NDR_EPM_MAP];

	r = talloc(talloc_tos(), struct epm_Map);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(epm_Map, r);
	}

	ZERO_STRUCT(r->out);
	r->out.entry_handle = r->in.entry_handle;
	r->out.num_towers = talloc_zero(r, uint32_t);
	if (r->out.num_towers == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.towers = talloc_zero_array(r, struct epm_twr_p_t, r->in.max_towers);
	if (r->out.towers == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _epm_Map(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(epm_Map, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_epm_LookupHandleFree(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct epm_LookupHandleFree *r;

	call = &ndr_table_epmapper.calls[NDR_EPM_LOOKUPHANDLEFREE];

	r = talloc(talloc_tos(), struct epm_LookupHandleFree);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(epm_LookupHandleFree, r);
	}

	ZERO_STRUCT(r->out);
	r->out.entry_handle = r->in.entry_handle;
	r->out.result = _epm_LookupHandleFree(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(epm_LookupHandleFree, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_epm_InqObject(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct epm_InqObject *r;

	call = &ndr_table_epmapper.calls[NDR_EPM_INQOBJECT];

	r = talloc(talloc_tos(), struct epm_InqObject);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(epm_InqObject, r);
	}

	r->out.result = _epm_InqObject(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(epm_InqObject, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_epm_MgmtDelete(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct epm_MgmtDelete *r;

	call = &ndr_table_epmapper.calls[NDR_EPM_MGMTDELETE];

	r = talloc(talloc_tos(), struct epm_MgmtDelete);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(epm_MgmtDelete, r);
	}

	r->out.result = _epm_MgmtDelete(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(epm_MgmtDelete, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_epm_MapAuth(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct epm_MapAuth *r;

	call = &ndr_table_epmapper.calls[NDR_EPM_MAPAUTH];

	r = talloc(talloc_tos(), struct epm_MapAuth);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(epm_MapAuth, r);
	}

	r->out.result = _epm_MapAuth(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(epm_MapAuth, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_epmapper_cmds[] = 
{
	{"EPM_INSERT", NDR_EPM_INSERT, api_epm_Insert},
	{"EPM_DELETE", NDR_EPM_DELETE, api_epm_Delete},
	{"EPM_LOOKUP", NDR_EPM_LOOKUP, api_epm_Lookup},
	{"EPM_MAP", NDR_EPM_MAP, api_epm_Map},
	{"EPM_LOOKUPHANDLEFREE", NDR_EPM_LOOKUPHANDLEFREE, api_epm_LookupHandleFree},
	{"EPM_INQOBJECT", NDR_EPM_INQOBJECT, api_epm_InqObject},
	{"EPM_MGMTDELETE", NDR_EPM_MGMTDELETE, api_epm_MgmtDelete},
	{"EPM_MAPAUTH", NDR_EPM_MAPAUTH, api_epm_MapAuth},
};

void epmapper_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_epmapper_cmds;
	*n_fns = sizeof(api_epmapper_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_epmapper_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_EPM_INSERT: {
			struct epm_Insert *r = (struct epm_Insert *)_r;
			r->out.result = _epm_Insert(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EPM_DELETE: {
			struct epm_Delete *r = (struct epm_Delete *)_r;
			r->out.result = _epm_Delete(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EPM_LOOKUP: {
			struct epm_Lookup *r = (struct epm_Lookup *)_r;
			ZERO_STRUCT(r->out);
			r->out.entry_handle = r->in.entry_handle;
			r->out.num_ents = talloc_zero(mem_ctx, uint32_t);
			if (r->out.num_ents == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.entries = talloc_zero_array(mem_ctx, struct epm_entry_t, r->in.max_ents);
			if (r->out.entries == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _epm_Lookup(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EPM_MAP: {
			struct epm_Map *r = (struct epm_Map *)_r;
			ZERO_STRUCT(r->out);
			r->out.entry_handle = r->in.entry_handle;
			r->out.num_towers = talloc_zero(mem_ctx, uint32_t);
			if (r->out.num_towers == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.towers = talloc_zero_array(mem_ctx, struct epm_twr_p_t, r->in.max_towers);
			if (r->out.towers == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _epm_Map(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EPM_LOOKUPHANDLEFREE: {
			struct epm_LookupHandleFree *r = (struct epm_LookupHandleFree *)_r;
			ZERO_STRUCT(r->out);
			r->out.entry_handle = r->in.entry_handle;
			r->out.result = _epm_LookupHandleFree(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EPM_INQOBJECT: {
			struct epm_InqObject *r = (struct epm_InqObject *)_r;
			r->out.result = _epm_InqObject(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EPM_MGMTDELETE: {
			struct epm_MgmtDelete *r = (struct epm_MgmtDelete *)_r;
			r->out.result = _epm_MgmtDelete(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EPM_MAPAUTH: {
			struct epm_MapAuth *r = (struct epm_MapAuth *)_r;
			r->out.result = _epm_MapAuth(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_epmapper_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "epmapper", "epmapper", &ndr_table_epmapper, api_epmapper_cmds, sizeof(api_epmapper_cmds) / sizeof(struct api_struct));
}
