#! /usr/bin/perl -w
# -*- Perl -*-
# Copyright (C) 1989-2000, 2001, 2002, 2003, 2004, 2005
# Free Software Foundation, Inc.
#      Written by James Clark (jjc@jclark.com)
#
# This file is part of groff.
#
# groff is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
#
# groff is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with groff; see the file COPYING.  If not, write to the Free Software
# Foundation, 51 Franklin St - Fifth Floor, Boston, MA 02110-1301, USA.

use strict;

my %unicode_decomposed = (
  "00C0", "0041_0300",
  "00C1", "0041_0301",
  "00C2", "0041_0302",
  "00C3", "0041_0303",
  "00C4", "0041_0308",
  "00C5", "0041_030A",
  "00C7", "0043_0327",
  "00C8", "0045_0300",
  "00C9", "0045_0301",
  "00CA", "0045_0302",
  "00CB", "0045_0308",
  "00CC", "0049_0300",
  "00CD", "0049_0301",
  "00CE", "0049_0302",
  "00CF", "0049_0308",
  "00D1", "004E_0303",
  "00D2", "004F_0300",
  "00D3", "004F_0301",
  "00D4", "004F_0302",
  "00D5", "004F_0303",
  "00D6", "004F_0308",
  "00D9", "0055_0300",
  "00DA", "0055_0301",
  "00DB", "0055_0302",
  "00DC", "0055_0308",
  "00DD", "0059_0301",
  "00E0", "0061_0300",
  "00E1", "0061_0301",
  "00E2", "0061_0302",
  "00E3", "0061_0303",
  "00E4", "0061_0308",
  "00E5", "0061_030A",
  "00E7", "0063_0327",
  "00E8", "0065_0300",
  "00E9", "0065_0301",
  "00EA", "0065_0302",
  "00EB", "0065_0308",
  "00EC", "0069_0300",
  "00ED", "0069_0301",
  "00EE", "0069_0302",
  "00EF", "0069_0308",
  "00F1", "006E_0303",
  "00F2", "006F_0300",
  "00F3", "006F_0301",
  "00F4", "006F_0302",
  "00F5", "006F_0303",
  "00F6", "006F_0308",
  "00F9", "0075_0300",
  "00FA", "0075_0301",
  "00FB", "0075_0302",
  "00FC", "0075_0308",
  "00FD", "0079_0301",
  "00FF", "0079_0308",
  "0100", "0041_0304",
  "0101", "0061_0304",
  "0102", "0041_0306",
  "0103", "0061_0306",
  "0104", "0041_0328",
  "0105", "0061_0328",
  "0106", "0043_0301",
  "0107", "0063_0301",
  "0108", "0043_0302",
  "0109", "0063_0302",
  "010A", "0043_0307",
  "010B", "0063_0307",
  "010C", "0043_030C",
  "010D", "0063_030C",
  "010E", "0044_030C",
  "010F", "0064_030C",
  "0112", "0045_0304",
  "0113", "0065_0304",
  "0114", "0045_0306",
  "0115", "0065_0306",
  "0116", "0045_0307",
  "0117", "0065_0307",
  "0118", "0045_0328",
  "0119", "0065_0328",
  "011A", "0045_030C",
  "011B", "0065_030C",
  "011C", "0047_0302",
  "011D", "0067_0302",
  "011E", "0047_0306",
  "011F", "0067_0306",
  "0120", "0047_0307",
  "0121", "0067_0307",
  "0122", "0047_0327",
  "0123", "0067_0327",
  "0124", "0048_0302",
  "0125", "0068_0302",
  "0128", "0049_0303",
  "0129", "0069_0303",
  "012A", "0049_0304",
  "012B", "0069_0304",
  "012C", "0049_0306",
  "012D", "0069_0306",
  "012E", "0049_0328",
  "012F", "0069_0328",
  "0130", "0049_0307",
  "0134", "004A_0302",
  "0135", "006A_0302",
  "0136", "004B_0327",
  "0137", "006B_0327",
  "0139", "004C_0301",
  "013A", "006C_0301",
  "013B", "004C_0327",
  "013C", "006C_0327",
  "013D", "004C_030C",
  "013E", "006C_030C",
  "0143", "004E_0301",
  "0144", "006E_0301",
  "0145", "004E_0327",
  "0146", "006E_0327",
  "0147", "004E_030C",
  "0148", "006E_030C",
  "014C", "004F_0304",
  "014D", "006F_0304",
  "014E", "004F_0306",
  "014F", "006F_0306",
  "0150", "004F_030B",
  "0151", "006F_030B",
  "0154", "0052_0301",
  "0155", "0072_0301",
  "0156", "0052_0327",
  "0157", "0072_0327",
  "0158", "0052_030C",
  "0159", "0072_030C",
  "015A", "0053_0301",
  "015B", "0073_0301",
  "015C", "0053_0302",
  "015D", "0073_0302",
  "015E", "0053_0327",
  "015F", "0073_0327",
  "0160", "0053_030C",
  "0161", "0073_030C",
  "0162", "0054_0327",
  "0163", "0074_0327",
  "0164", "0054_030C",
  "0165", "0074_030C",
  "0168", "0055_0303",
  "0169", "0075_0303",
  "016A", "0055_0304",
  "016B", "0075_0304",
  "016C", "0055_0306",
  "016D", "0075_0306",
  "016E", "0055_030A",
  "016F", "0075_030A",
  "0170", "0055_030B",
  "0171", "0075_030B",
  "0172", "0055_0328",
  "0173", "0075_0328",
  "0174", "0057_0302",
  "0175", "0077_0302",
  "0176", "0059_0302",
  "0177", "0079_0302",
  "0178", "0059_0308",
  "0179", "005A_0301",
  "017A", "007A_0301",
  "017B", "005A_0307",
  "017C", "007A_0307",
  "017D", "005A_030C",
  "017E", "007A_030C",
  "01A0", "004F_031B",
  "01A1", "006F_031B",
  "01AF", "0055_031B",
  "01B0", "0075_031B",
  "01CD", "0041_030C",
  "01CE", "0061_030C",
  "01CF", "0049_030C",
  "01D0", "0069_030C",
  "01D1", "004F_030C",
  "01D2", "006F_030C",
  "01D3", "0055_030C",
  "01D4", "0075_030C",
  "01D5", "0055_0308_0304",
  "01D6", "0075_0308_0304",
  "01D7", "0055_0308_0301",
  "01D8", "0075_0308_0301",
  "01D9", "0055_0308_030C",
  "01DA", "0075_0308_030C",
  "01DB", "0055_0308_0300",
  "01DC", "0075_0308_0300",
  "01DE", "0041_0308_0304",
  "01DF", "0061_0308_0304",
  "01E0", "0041_0307_0304",
  "01E1", "0061_0307_0304",
  "01E2", "00C6_0304",
  "01E3", "00E6_0304",
  "01E6", "0047_030C",
  "01E7", "0067_030C",
  "01E8", "004B_030C",
  "01E9", "006B_030C",
  "01EA", "004F_0328",
  "01EB", "006F_0328",
  "01EC", "004F_0328_0304",
  "01ED", "006F_0328_0304",
  "01EE", "01B7_030C",
  "01EF", "0292_030C",
  "01F0", "006A_030C",
  "01F4", "0047_0301",
  "01F5", "0067_0301",
  "01F8", "004E_0300",
  "01F9", "006E_0300",
  "01FA", "0041_030A_0301",
  "01FB", "0061_030A_0301",
  "01FC", "00C6_0301",
  "01FD", "00E6_0301",
  "01FE", "00D8_0301",
  "01FF", "00F8_0301",
  "0200", "0041_030F",
  "0201", "0061_030F",
  "0202", "0041_0311",
  "0203", "0061_0311",
  "0204", "0045_030F",
  "0205", "0065_030F",
  "0206", "0045_0311",
  "0207", "0065_0311",
  "0208", "0049_030F",
  "0209", "0069_030F",
  "020A", "0049_0311",
  "020B", "0069_0311",
  "020C", "004F_030F",
  "020D", "006F_030F",
  "020E", "004F_0311",
  "020F", "006F_0311",
  "0210", "0052_030F",
  "0211", "0072_030F",
  "0212", "0052_0311",
  "0213", "0072_0311",
  "0214", "0055_030F",
  "0215", "0075_030F",
  "0216", "0055_0311",
  "0217", "0075_0311",
  "0218", "0053_0326",
  "0219", "0073_0326",
  "021A", "0054_0326",
  "021B", "0074_0326",
  "021E", "0048_030C",
  "021F", "0068_030C",
  "0226", "0041_0307",
  "0227", "0061_0307",
  "0228", "0045_0327",
  "0229", "0065_0327",
  "022A", "004F_0308_0304",
  "022B", "006F_0308_0304",
  "022C", "004F_0303_0304",
  "022D", "006F_0303_0304",
  "022E", "004F_0307",
  "022F", "006F_0307",
  "0230", "004F_0307_0304",
  "0231", "006F_0307_0304",
  "0232", "0059_0304",
  "0233", "0079_0304",
  "0340", "0300",
  "0341", "0301",
  "0343", "0313",
  "0344", "0308_0301",
  "0374", "02B9",
  "037E", "003B",
  "0385", "00A8_0301",
  "0386", "0391_0301",
  "0387", "00B7",
  "0388", "0395_0301",
  "0389", "0397_0301",
  "038A", "0399_0301",
  "038C", "039F_0301",
  "038E", "03A5_0301",
  "038F", "03A9_0301",
  "0390", "03B9_0308_0301",
  "03AA", "0399_0308",
  "03AB", "03A5_0308",
  "03AC", "03B1_0301",
  "03AD", "03B5_0301",
  "03AE", "03B7_0301",
  "03AF", "03B9_0301",
  "03B0", "03C5_0308_0301",
  "03CA", "03B9_0308",
  "03CB", "03C5_0308",
  "03CC", "03BF_0301",
  "03CD", "03C5_0301",
  "03CE", "03C9_0301",
  "03D3", "03D2_0301",
  "03D4", "03D2_0308",
  "0400", "0415_0300",
  "0401", "0415_0308",
  "0403", "0413_0301",
  "0407", "0406_0308",
  "040C", "041A_0301",
  "040D", "0418_0300",
  "040E", "0423_0306",
  "0419", "0418_0306",
  "0439", "0438_0306",
  "0450", "0435_0300",
  "0451", "0435_0308",
  "0453", "0433_0301",
  "0457", "0456_0308",
  "045C", "043A_0301",
  "045D", "0438_0300",
  "045E", "0443_0306",
  "0476", "0474_030F",
  "0477", "0475_030F",
  "04C1", "0416_0306",
  "04C2", "0436_0306",
  "04D0", "0410_0306",
  "04D1", "0430_0306",
  "04D2", "0410_0308",
  "04D3", "0430_0308",
  "04D6", "0415_0306",
  "04D7", "0435_0306",
  "04DA", "04D8_0308",
  "04DB", "04D9_0308",
  "04DC", "0416_0308",
  "04DD", "0436_0308",
  "04DE", "0417_0308",
  "04DF", "0437_0308",
  "04E2", "0418_0304",
  "04E3", "0438_0304",
  "04E4", "0418_0308",
  "04E5", "0438_0308",
  "04E6", "041E_0308",
  "04E7", "043E_0308",
  "04EA", "04E8_0308",
  "04EB", "04E9_0308",
  "04EC", "042D_0308",
  "04ED", "044D_0308",
  "04EE", "0423_0304",
  "04EF", "0443_0304",
  "04F0", "0423_0308",
  "04F1", "0443_0308",
  "04F2", "0423_030B",
  "04F3", "0443_030B",
  "04F4", "0427_0308",
  "04F5", "0447_0308",
  "04F8", "042B_0308",
  "04F9", "044B_0308",
  "0622", "0627_0653",
  "0623", "0627_0654",
  "0624", "0648_0654",
  "0625", "0627_0655",
  "0626", "064A_0654",
  "06C0", "06D5_0654",
  "06C2", "06C1_0654",
  "06D3", "06D2_0654",
  "0929", "0928_093C",
  "0931", "0930_093C",
  "0934", "0933_093C",
  "0958", "0915_093C",
  "0959", "0916_093C",
  "095A", "0917_093C",
  "095B", "091C_093C",
  "095C", "0921_093C",
  "095D", "0922_093C",
  "095E", "092B_093C",
  "095F", "092F_093C",
  "09CB", "09C7_09BE",
  "09CC", "09C7_09D7",
  "09DC", "09A1_09BC",
  "09DD", "09A2_09BC",
  "09DF", "09AF_09BC",
  "0A33", "0A32_0A3C",
  "0A36", "0A38_0A3C",
  "0A59", "0A16_0A3C",
  "0A5A", "0A17_0A3C",
  "0A5B", "0A1C_0A3C",
  "0A5E", "0A2B_0A3C",
  "0B48", "0B47_0B56",
  "0B4B", "0B47_0B3E",
  "0B4C", "0B47_0B57",
  "0B5C", "0B21_0B3C",
  "0B5D", "0B22_0B3C",
  "0B94", "0B92_0BD7",
  "0BCA", "0BC6_0BBE",
  "0BCB", "0BC7_0BBE",
  "0BCC", "0BC6_0BD7",
  "0C48", "0C46_0C56",
  "0CC0", "0CBF_0CD5",
  "0CC7", "0CC6_0CD5",
  "0CC8", "0CC6_0CD6",
  "0CCA", "0CC6_0CC2",
  "0CCB", "0CC6_0CC2_0CD5",
  "0D4A", "0D46_0D3E",
  "0D4B", "0D47_0D3E",
  "0D4C", "0D46_0D57",
  "0DDA", "0DD9_0DCA",
  "0DDC", "0DD9_0DCF",
  "0DDD", "0DD9_0DCF_0DCA",
  "0DDE", "0DD9_0DDF",
  "0F43", "0F42_0FB7",
  "0F4D", "0F4C_0FB7",
  "0F52", "0F51_0FB7",
  "0F57", "0F56_0FB7",
  "0F5C", "0F5B_0FB7",
  "0F69", "0F40_0FB5",
  "0F73", "0F71_0F72",
  "0F75", "0F71_0F74",
  "0F76", "0FB2_0F80",
  "0F78", "0FB3_0F80",
  "0F81", "0F71_0F80",
  "0F93", "0F92_0FB7",
  "0F9D", "0F9C_0FB7",
  "0FA2", "0FA1_0FB7",
  "0FA7", "0FA6_0FB7",
  "0FAC", "0FAB_0FB7",
  "0FB9", "0F90_0FB5",
  "1026", "1025_102E",
  "1E00", "0041_0325",
  "1E01", "0061_0325",
  "1E02", "0042_0307",
  "1E03", "0062_0307",
  "1E04", "0042_0323",
  "1E05", "0062_0323",
  "1E06", "0042_0331",
  "1E07", "0062_0331",
  "1E08", "0043_0327_0301",
  "1E09", "0063_0327_0301",
  "1E0A", "0044_0307",
  "1E0B", "0064_0307",
  "1E0C", "0044_0323",
  "1E0D", "0064_0323",
  "1E0E", "0044_0331",
  "1E0F", "0064_0331",
  "1E10", "0044_0327",
  "1E11", "0064_0327",
  "1E12", "0044_032D",
  "1E13", "0064_032D",
  "1E14", "0045_0304_0300",
  "1E15", "0065_0304_0300",
  "1E16", "0045_0304_0301",
  "1E17", "0065_0304_0301",
  "1E18", "0045_032D",
  "1E19", "0065_032D",
  "1E1A", "0045_0330",
  "1E1B", "0065_0330",
  "1E1C", "0045_0327_0306",
  "1E1D", "0065_0327_0306",
  "1E1E", "0046_0307",
  "1E1F", "0066_0307",
  "1E20", "0047_0304",
  "1E21", "0067_0304",
  "1E22", "0048_0307",
  "1E23", "0068_0307",
  "1E24", "0048_0323",
  "1E25", "0068_0323",
  "1E26", "0048_0308",
  "1E27", "0068_0308",
  "1E28", "0048_0327",
  "1E29", "0068_0327",
  "1E2A", "0048_032E",
  "1E2B", "0068_032E",
  "1E2C", "0049_0330",
  "1E2D", "0069_0330",
  "1E2E", "0049_0308_0301",
  "1E2F", "0069_0308_0301",
  "1E30", "004B_0301",
  "1E31", "006B_0301",
  "1E32", "004B_0323",
  "1E33", "006B_0323",
  "1E34", "004B_0331",
  "1E35", "006B_0331",
  "1E36", "004C_0323",
  "1E37", "006C_0323",
  "1E38", "004C_0323_0304",
  "1E39", "006C_0323_0304",
  "1E3A", "004C_0331",
  "1E3B", "006C_0331",
  "1E3C", "004C_032D",
  "1E3D", "006C_032D",
  "1E3E", "004D_0301",
  "1E3F", "006D_0301",
  "1E40", "004D_0307",
  "1E41", "006D_0307",
  "1E42", "004D_0323",
  "1E43", "006D_0323",
  "1E44", "004E_0307",
  "1E45", "006E_0307",
  "1E46", "004E_0323",
  "1E47", "006E_0323",
  "1E48", "004E_0331",
  "1E49", "006E_0331",
  "1E4A", "004E_032D",
  "1E4B", "006E_032D",
  "1E4C", "004F_0303_0301",
  "1E4D", "006F_0303_0301",
  "1E4E", "004F_0303_0308",
  "1E4F", "006F_0303_0308",
  "1E50", "004F_0304_0300",
  "1E51", "006F_0304_0300",
  "1E52", "004F_0304_0301",
  "1E53", "006F_0304_0301",
  "1E54", "0050_0301",
  "1E55", "0070_0301",
  "1E56", "0050_0307",
  "1E57", "0070_0307",
  "1E58", "0052_0307",
  "1E59", "0072_0307",
  "1E5A", "0052_0323",
  "1E5B", "0072_0323",
  "1E5C", "0052_0323_0304",
  "1E5D", "0072_0323_0304",
  "1E5E", "0052_0331",
  "1E5F", "0072_0331",
  "1E60", "0053_0307",
  "1E61", "0073_0307",
  "1E62", "0053_0323",
  "1E63", "0073_0323",
  "1E64", "0053_0301_0307",
  "1E65", "0073_0301_0307",
  "1E66", "0053_030C_0307",
  "1E67", "0073_030C_0307",
  "1E68", "0053_0323_0307",
  "1E69", "0073_0323_0307",
  "1E6A", "0054_0307",
  "1E6B", "0074_0307",
  "1E6C", "0054_0323",
  "1E6D", "0074_0323",
  "1E6E", "0054_0331",
  "1E6F", "0074_0331",
  "1E70", "0054_032D",
  "1E71", "0074_032D",
  "1E72", "0055_0324",
  "1E73", "0075_0324",
  "1E74", "0055_0330",
  "1E75", "0075_0330",
  "1E76", "0055_032D",
  "1E77", "0075_032D",
  "1E78", "0055_0303_0301",
  "1E79", "0075_0303_0301",
  "1E7A", "0055_0304_0308",
  "1E7B", "0075_0304_0308",
  "1E7C", "0056_0303",
  "1E7D", "0076_0303",
  "1E7E", "0056_0323",
  "1E7F", "0076_0323",
  "1E80", "0057_0300",
  "1E81", "0077_0300",
  "1E82", "0057_0301",
  "1E83", "0077_0301",
  "1E84", "0057_0308",
  "1E85", "0077_0308",
  "1E86", "0057_0307",
  "1E87", "0077_0307",
  "1E88", "0057_0323",
  "1E89", "0077_0323",
  "1E8A", "0058_0307",
  "1E8B", "0078_0307",
  "1E8C", "0058_0308",
  "1E8D", "0078_0308",
  "1E8E", "0059_0307",
  "1E8F", "0079_0307",
  "1E90", "005A_0302",
  "1E91", "007A_0302",
  "1E92", "005A_0323",
  "1E93", "007A_0323",
  "1E94", "005A_0331",
  "1E95", "007A_0331",
  "1E96", "0068_0331",
  "1E97", "0074_0308",
  "1E98", "0077_030A",
  "1E99", "0079_030A",
  "1E9B", "017F_0307",
  "1EA0", "0041_0323",
  "1EA1", "0061_0323",
  "1EA2", "0041_0309",
  "1EA3", "0061_0309",
  "1EA4", "0041_0302_0301",
  "1EA5", "0061_0302_0301",
  "1EA6", "0041_0302_0300",
  "1EA7", "0061_0302_0300",
  "1EA8", "0041_0302_0309",
  "1EA9", "0061_0302_0309",
  "1EAA", "0041_0302_0303",
  "1EAB", "0061_0302_0303",
  "1EAC", "0041_0323_0302",
  "1EAD", "0061_0323_0302",
  "1EAE", "0041_0306_0301",
  "1EAF", "0061_0306_0301",
  "1EB0", "0041_0306_0300",
  "1EB1", "0061_0306_0300",
  "1EB2", "0041_0306_0309",
  "1EB3", "0061_0306_0309",
  "1EB4", "0041_0306_0303",
  "1EB5", "0061_0306_0303",
  "1EB6", "0041_0323_0306",
  "1EB7", "0061_0323_0306",
  "1EB8", "0045_0323",
  "1EB9", "0065_0323",
  "1EBA", "0045_0309",
  "1EBB", "0065_0309",
  "1EBC", "0045_0303",
  "1EBD", "0065_0303",
  "1EBE", "0045_0302_0301",
  "1EBF", "0065_0302_0301",
  "1EC0", "0045_0302_0300",
  "1EC1", "0065_0302_0300",
  "1EC2", "0045_0302_0309",
  "1EC3", "0065_0302_0309",
  "1EC4", "0045_0302_0303",
  "1EC5", "0065_0302_0303",
  "1EC6", "0045_0323_0302",
  "1EC7", "0065_0323_0302",
  "1EC8", "0049_0309",
  "1EC9", "0069_0309",
  "1ECA", "0049_0323",
  "1ECB", "0069_0323",
  "1ECC", "004F_0323",
  "1ECD", "006F_0323",
  "1ECE", "004F_0309",
  "1ECF", "006F_0309",
  "1ED0", "004F_0302_0301",
  "1ED1", "006F_0302_0301",
  "1ED2", "004F_0302_0300",
  "1ED3", "006F_0302_0300",
  "1ED4", "004F_0302_0309",
  "1ED5", "006F_0302_0309",
  "1ED6", "004F_0302_0303",
  "1ED7", "006F_0302_0303",
  "1ED8", "004F_0323_0302",
  "1ED9", "006F_0323_0302",
  "1EDA", "004F_031B_0301",
  "1EDB", "006F_031B_0301",
  "1EDC", "004F_031B_0300",
  "1EDD", "006F_031B_0300",
  "1EDE", "004F_031B_0309",
  "1EDF", "006F_031B_0309",
  "1EE0", "004F_031B_0303",
  "1EE1", "006F_031B_0303",
  "1EE2", "004F_031B_0323",
  "1EE3", "006F_031B_0323",
  "1EE4", "0055_0323",
  "1EE5", "0075_0323",
  "1EE6", "0055_0309",
  "1EE7", "0075_0309",
  "1EE8", "0055_031B_0301",
  "1EE9", "0075_031B_0301",
  "1EEA", "0055_031B_0300",
  "1EEB", "0075_031B_0300",
  "1EEC", "0055_031B_0309",
  "1EED", "0075_031B_0309",
  "1EEE", "0055_031B_0303",
  "1EEF", "0075_031B_0303",
  "1EF0", "0055_031B_0323",
  "1EF1", "0075_031B_0323",
  "1EF2", "0059_0300",
  "1EF3", "0079_0300",
  "1EF4", "0059_0323",
  "1EF5", "0079_0323",
  "1EF6", "0059_0309",
  "1EF7", "0079_0309",
  "1EF8", "0059_0303",
  "1EF9", "0079_0303",
  "1F00", "03B1_0313",
  "1F01", "03B1_0314",
  "1F02", "03B1_0313_0300",
  "1F03", "03B1_0314_0300",
  "1F04", "03B1_0313_0301",
  "1F05", "03B1_0314_0301",
  "1F06", "03B1_0313_0342",
  "1F07", "03B1_0314_0342",
  "1F08", "0391_0313",
  "1F09", "0391_0314",
  "1F0A", "0391_0313_0300",
  "1F0B", "0391_0314_0300",
  "1F0C", "0391_0313_0301",
  "1F0D", "0391_0314_0301",
  "1F0E", "0391_0313_0342",
  "1F0F", "0391_0314_0342",
  "1F10", "03B5_0313",
  "1F11", "03B5_0314",
  "1F12", "03B5_0313_0300",
  "1F13", "03B5_0314_0300",
  "1F14", "03B5_0313_0301",
  "1F15", "03B5_0314_0301",
  "1F18", "0395_0313",
  "1F19", "0395_0314",
  "1F1A", "0395_0313_0300",
  "1F1B", "0395_0314_0300",
  "1F1C", "0395_0313_0301",
  "1F1D", "0395_0314_0301",
  "1F20", "03B7_0313",
  "1F21", "03B7_0314",
  "1F22", "03B7_0313_0300",
  "1F23", "03B7_0314_0300",
  "1F24", "03B7_0313_0301",
  "1F25", "03B7_0314_0301",
  "1F26", "03B7_0313_0342",
  "1F27", "03B7_0314_0342",
  "1F28", "0397_0313",
  "1F29", "0397_0314",
  "1F2A", "0397_0313_0300",
  "1F2B", "0397_0314_0300",
  "1F2C", "0397_0313_0301",
  "1F2D", "0397_0314_0301",
  "1F2E", "0397_0313_0342",
  "1F2F", "0397_0314_0342",
  "1F30", "03B9_0313",
  "1F31", "03B9_0314",
  "1F32", "03B9_0313_0300",
  "1F33", "03B9_0314_0300",
  "1F34", "03B9_0313_0301",
  "1F35", "03B9_0314_0301",
  "1F36", "03B9_0313_0342",
  "1F37", "03B9_0314_0342",
  "1F38", "0399_0313",
  "1F39", "0399_0314",
  "1F3A", "0399_0313_0300",
  "1F3B", "0399_0314_0300",
  "1F3C", "0399_0313_0301",
  "1F3D", "0399_0314_0301",
  "1F3E", "0399_0313_0342",
  "1F3F", "0399_0314_0342",
  "1F40", "03BF_0313",
  "1F41", "03BF_0314",
  "1F42", "03BF_0313_0300",
  "1F43", "03BF_0314_0300",
  "1F44", "03BF_0313_0301",
  "1F45", "03BF_0314_0301",
  "1F48", "039F_0313",
  "1F49", "039F_0314",
  "1F4A", "039F_0313_0300",
  "1F4B", "039F_0314_0300",
  "1F4C", "039F_0313_0301",
  "1F4D", "039F_0314_0301",
  "1F50", "03C5_0313",
  "1F51", "03C5_0314",
  "1F52", "03C5_0313_0300",
  "1F53", "03C5_0314_0300",
  "1F54", "03C5_0313_0301",
  "1F55", "03C5_0314_0301",
  "1F56", "03C5_0313_0342",
  "1F57", "03C5_0314_0342",
  "1F59", "03A5_0314",
  "1F5B", "03A5_0314_0300",
  "1F5D", "03A5_0314_0301",
  "1F5F", "03A5_0314_0342",
  "1F60", "03C9_0313",
  "1F61", "03C9_0314",
  "1F62", "03C9_0313_0300",
  "1F63", "03C9_0314_0300",
  "1F64", "03C9_0313_0301",
  "1F65", "03C9_0314_0301",
  "1F66", "03C9_0313_0342",
  "1F67", "03C9_0314_0342",
  "1F68", "03A9_0313",
  "1F69", "03A9_0314",
  "1F6A", "03A9_0313_0300",
  "1F6B", "03A9_0314_0300",
  "1F6C", "03A9_0313_0301",
  "1F6D", "03A9_0314_0301",
  "1F6E", "03A9_0313_0342",
  "1F6F", "03A9_0314_0342",
  "1F70", "03B1_0300",
  "1F71", "03B1_0301",
  "1F72", "03B5_0300",
  "1F73", "03B5_0301",
  "1F74", "03B7_0300",
  "1F75", "03B7_0301",
  "1F76", "03B9_0300",
  "1F77", "03B9_0301",
  "1F78", "03BF_0300",
  "1F79", "03BF_0301",
  "1F7A", "03C5_0300",
  "1F7B", "03C5_0301",
  "1F7C", "03C9_0300",
  "1F7D", "03C9_0301",
  "1F80", "03B1_0313_0345",
  "1F81", "03B1_0314_0345",
  "1F82", "03B1_0313_0300_0345",
  "1F83", "03B1_0314_0300_0345",
  "1F84", "03B1_0313_0301_0345",
  "1F85", "03B1_0314_0301_0345",
  "1F86", "03B1_0313_0342_0345",
  "1F87", "03B1_0314_0342_0345",
  "1F88", "0391_0313_0345",
  "1F89", "0391_0314_0345",
  "1F8A", "0391_0313_0300_0345",
  "1F8B", "0391_0314_0300_0345",
  "1F8C", "0391_0313_0301_0345",
  "1F8D", "0391_0314_0301_0345",
  "1F8E", "0391_0313_0342_0345",
  "1F8F", "0391_0314_0342_0345",
  "1F90", "03B7_0313_0345",
  "1F91", "03B7_0314_0345",
  "1F92", "03B7_0313_0300_0345",
  "1F93", "03B7_0314_0300_0345",
  "1F94", "03B7_0313_0301_0345",
  "1F95", "03B7_0314_0301_0345",
  "1F96", "03B7_0313_0342_0345",
  "1F97", "03B7_0314_0342_0345",
  "1F98", "0397_0313_0345",
  "1F99", "0397_0314_0345",
  "1F9A", "0397_0313_0300_0345",
  "1F9B", "0397_0314_0300_0345",
  "1F9C", "0397_0313_0301_0345",
  "1F9D", "0397_0314_0301_0345",
  "1F9E", "0397_0313_0342_0345",
  "1F9F", "0397_0314_0342_0345",
  "1FA0", "03C9_0313_0345",
  "1FA1", "03C9_0314_0345",
  "1FA2", "03C9_0313_0300_0345",
  "1FA3", "03C9_0314_0300_0345",
  "1FA4", "03C9_0313_0301_0345",
  "1FA5", "03C9_0314_0301_0345",
  "1FA6", "03C9_0313_0342_0345",
  "1FA7", "03C9_0314_0342_0345",
  "1FA8", "03A9_0313_0345",
  "1FA9", "03A9_0314_0345",
  "1FAA", "03A9_0313_0300_0345",
  "1FAB", "03A9_0314_0300_0345",
  "1FAC", "03A9_0313_0301_0345",
  "1FAD", "03A9_0314_0301_0345",
  "1FAE", "03A9_0313_0342_0345",
  "1FAF", "03A9_0314_0342_0345",
  "1FB0", "03B1_0306",
  "1FB1", "03B1_0304",
  "1FB2", "03B1_0300_0345",
  "1FB3", "03B1_0345",
  "1FB4", "03B1_0301_0345",
  "1FB6", "03B1_0342",
  "1FB7", "03B1_0342_0345",
  "1FB8", "0391_0306",
  "1FB9", "0391_0304",
  "1FBA", "0391_0300",
  "1FBB", "0391_0301",
  "1FBC", "0391_0345",
  "1FBE", "03B9",
  "1FC1", "00A8_0342",
  "1FC2", "03B7_0300_0345",
  "1FC3", "03B7_0345",
  "1FC4", "03B7_0301_0345",
  "1FC6", "03B7_0342",
  "1FC7", "03B7_0342_0345",
  "1FC8", "0395_0300",
  "1FC9", "0395_0301",
  "1FCA", "0397_0300",
  "1FCB", "0397_0301",
  "1FCC", "0397_0345",
  "1FCD", "1FBF_0300",
  "1FCE", "1FBF_0301",
  "1FCF", "1FBF_0342",
  "1FD0", "03B9_0306",
  "1FD1", "03B9_0304",
  "1FD2", "03B9_0308_0300",
  "1FD3", "03B9_0308_0301",
  "1FD6", "03B9_0342",
  "1FD7", "03B9_0308_0342",
  "1FD8", "0399_0306",
  "1FD9", "0399_0304",
  "1FDA", "0399_0300",
  "1FDB", "0399_0301",
  "1FDD", "1FFE_0300",
  "1FDE", "1FFE_0301",
  "1FDF", "1FFE_0342",
  "1FE0", "03C5_0306",
  "1FE1", "03C5_0304",
  "1FE2", "03C5_0308_0300",
  "1FE3", "03C5_0308_0301",
  "1FE4", "03C1_0313",
  "1FE5", "03C1_0314",
  "1FE6", "03C5_0342",
  "1FE7", "03C5_0308_0342",
  "1FE8", "03A5_0306",
  "1FE9", "03A5_0304",
  "1FEA", "03A5_0300",
  "1FEB", "03A5_0301",
  "1FEC", "03A1_0314",
  "1FED", "00A8_0300",
  "1FEE", "00A8_0301",
  "1FEF", "0060",
  "1FF2", "03C9_0300_0345",
  "1FF3", "03C9_0345",
  "1FF4", "03C9_0301_0345",
  "1FF6", "03C9_0342",
  "1FF7", "03C9_0342_0345",
  "1FF8", "039F_0300",
  "1FF9", "039F_0301",
  "1FFA", "03A9_0300",
  "1FFB", "03A9_0301",
  "1FFC", "03A9_0345",
  "1FFD", "00B4",
  "2000", "2002",
  "2001", "2003",
  "2126", "03A9",
  "212A", "004B",
  "212B", "0041_030A",
  "219A", "2190_0338",
  "219B", "2192_0338",
  "21AE", "2194_0338",
  "21CD", "21D0_0338",
  "21CE", "21D4_0338",
  "21CF", "21D2_0338",
  "2204", "2203_0338",
  "2209", "2208_0338",
  "220C", "220B_0338",
  "2224", "2223_0338",
  "2226", "2225_0338",
  "2241", "223C_0338",
  "2244", "2243_0338",
  "2247", "2245_0338",
  "2249", "2248_0338",
  "2260", "003D_0338",
  "2262", "2261_0338",
  "226D", "224D_0338",
  "226E", "003C_0338",
  "226F", "003E_0338",
  "2270", "2264_0338",
  "2271", "2265_0338",
  "2274", "2272_0338",
  "2275", "2273_0338",
  "2278", "2276_0338",
  "2279", "2277_0338",
  "2280", "227A_0338",
  "2281", "227B_0338",
  "2284", "2282_0338",
  "2285", "2283_0338",
  "2288", "2286_0338",
  "2289", "2287_0338",
  "22AC", "22A2_0338",
  "22AD", "22A8_0338",
  "22AE", "22A9_0338",
  "22AF", "22AB_0338",
  "22E0", "227C_0338",
  "22E1", "227D_0338",
  "22E2", "2291_0338",
  "22E3", "2292_0338",
  "22EA", "22B2_0338",
  "22EB", "22B3_0338",
  "22EC", "22B4_0338",
  "22ED", "22B5_0338",
  "2329", "3008",
  "232A", "3009",
  "2ADC", "2ADD_0338",
  "304C", "304B_3099",
  "304E", "304D_3099",
  "3050", "304F_3099",
  "3052", "3051_3099",
  "3054", "3053_3099",
  "3056", "3055_3099",
  "3058", "3057_3099",
  "305A", "3059_3099",
  "305C", "305B_3099",
  "305E", "305D_3099",
  "3060", "305F_3099",
  "3062", "3061_3099",
  "3065", "3064_3099",
  "3067", "3066_3099",
  "3069", "3068_3099",
  "3070", "306F_3099",
  "3071", "306F_309A",
  "3073", "3072_3099",
  "3074", "3072_309A",
  "3076", "3075_3099",
  "3077", "3075_309A",
  "3079", "3078_3099",
  "307A", "3078_309A",
  "307C", "307B_3099",
  "307D", "307B_309A",
  "3094", "3046_3099",
  "309E", "309D_3099",
  "30AC", "30AB_3099",
  "30AE", "30AD_3099",
  "30B0", "30AF_3099",
  "30B2", "30B1_3099",
  "30B4", "30B3_3099",
  "30B6", "30B5_3099",
  "30B8", "30B7_3099",
  "30BA", "30B9_3099",
  "30BC", "30BB_3099",
  "30BE", "30BD_3099",
  "30C0", "30BF_3099",
  "30C2", "30C1_3099",
  "30C5", "30C4_3099",
  "30C7", "30C6_3099",
  "30C9", "30C8_3099",
  "30D0", "30CF_3099",
  "30D1", "30CF_309A",
  "30D3", "30D2_3099",
  "30D4", "30D2_309A",
  "30D6", "30D5_3099",
  "30D7", "30D5_309A",
  "30D9", "30D8_3099",
  "30DA", "30D8_309A",
  "30DC", "30DB_3099",
  "30DD", "30DB_309A",
  "30F4", "30A6_3099",
  "30F7", "30EF_3099",
  "30F8", "30F0_3099",
  "30F9", "30F1_3099",
  "30FA", "30F2_3099",
  "30FE", "30FD_3099",
  "F900", "8C48",
  "F901", "66F4",
  "F902", "8ECA",
  "F903", "8CC8",
  "F904", "6ED1",
  "F905", "4E32",
  "F906", "53E5",
  "F907", "9F9C",
  "F908", "9F9C",
  "F909", "5951",
  "F90A", "91D1",
  "F90B", "5587",
  "F90C", "5948",
  "F90D", "61F6",
  "F90E", "7669",
  "F90F", "7F85",
  "F910", "863F",
  "F911", "87BA",
  "F912", "88F8",
  "F913", "908F",
  "F914", "6A02",
  "F915", "6D1B",
  "F916", "70D9",
  "F917", "73DE",
  "F918", "843D",
  "F919", "916A",
  "F91A", "99F1",
  "F91B", "4E82",
  "F91C", "5375",
  "F91D", "6B04",
  "F91E", "721B",
  "F91F", "862D",
  "F920", "9E1E",
  "F921", "5D50",
  "F922", "6FEB",
  "F923", "85CD",
  "F924", "8964",
  "F925", "62C9",
  "F926", "81D8",
  "F927", "881F",
  "F928", "5ECA",
  "F929", "6717",
  "F92A", "6D6A",
  "F92B", "72FC",
  "F92C", "90CE",
  "F92D", "4F86",
  "F92E", "51B7",
  "F92F", "52DE",
  "F930", "64C4",
  "F931", "6AD3",
  "F932", "7210",
  "F933", "76E7",
  "F934", "8001",
  "F935", "8606",
  "F936", "865C",
  "F937", "8DEF",
  "F938", "9732",
  "F939", "9B6F",
  "F93A", "9DFA",
  "F93B", "788C",
  "F93C", "797F",
  "F93D", "7DA0",
  "F93E", "83C9",
  "F93F", "9304",
  "F940", "9E7F",
  "F941", "8AD6",
  "F942", "58DF",
  "F943", "5F04",
  "F944", "7C60",
  "F945", "807E",
  "F946", "7262",
  "F947", "78CA",
  "F948", "8CC2",
  "F949", "96F7",
  "F94A", "58D8",
  "F94B", "5C62",
  "F94C", "6A13",
  "F94D", "6DDA",
  "F94E", "6F0F",
  "F94F", "7D2F",
  "F950", "7E37",
  "F951", "964B",
  "F952", "52D2",
  "F953", "808B",
  "F954", "51DC",
  "F955", "51CC",
  "F956", "7A1C",
  "F957", "7DBE",
  "F958", "83F1",
  "F959", "9675",
  "F95A", "8B80",
  "F95B", "62CF",
  "F95C", "6A02",
  "F95D", "8AFE",
  "F95E", "4E39",
  "F95F", "5BE7",
  "F960", "6012",
  "F961", "7387",
  "F962", "7570",
  "F963", "5317",
  "F964", "78FB",
  "F965", "4FBF",
  "F966", "5FA9",
  "F967", "4E0D",
  "F968", "6CCC",
  "F969", "6578",
  "F96A", "7D22",
  "F96B", "53C3",
  "F96C", "585E",
  "F96D", "7701",
  "F96E", "8449",
  "F96F", "8AAA",
  "F970", "6BBA",
  "F971", "8FB0",
  "F972", "6C88",
  "F973", "62FE",
  "F974", "82E5",
  "F975", "63A0",
  "F976", "7565",
  "F977", "4EAE",
  "F978", "5169",
  "F979", "51C9",
  "F97A", "6881",
  "F97B", "7CE7",
  "F97C", "826F",
  "F97D", "8AD2",
  "F97E", "91CF",
  "F97F", "52F5",
  "F980", "5442",
  "F981", "5973",
  "F982", "5EEC",
  "F983", "65C5",
  "F984", "6FFE",
  "F985", "792A",
  "F986", "95AD",
  "F987", "9A6A",
  "F988", "9E97",
  "F989", "9ECE",
  "F98A", "529B",
  "F98B", "66C6",
  "F98C", "6B77",
  "F98D", "8F62",
  "F98E", "5E74",
  "F98F", "6190",
  "F990", "6200",
  "F991", "649A",
  "F992", "6F23",
  "F993", "7149",
  "F994", "7489",
  "F995", "79CA",
  "F996", "7DF4",
  "F997", "806F",
  "F998", "8F26",
  "F999", "84EE",
  "F99A", "9023",
  "F99B", "934A",
  "F99C", "5217",
  "F99D", "52A3",
  "F99E", "54BD",
  "F99F", "70C8",
  "F9A0", "88C2",
  "F9A1", "8AAA",
  "F9A2", "5EC9",
  "F9A3", "5FF5",
  "F9A4", "637B",
  "F9A5", "6BAE",
  "F9A6", "7C3E",
  "F9A7", "7375",
  "F9A8", "4EE4",
  "F9A9", "56F9",
  "F9AA", "5BE7",
  "F9AB", "5DBA",
  "F9AC", "601C",
  "F9AD", "73B2",
  "F9AE", "7469",
  "F9AF", "7F9A",
  "F9B0", "8046",
  "F9B1", "9234",
  "F9B2", "96F6",
  "F9B3", "9748",
  "F9B4", "9818",
  "F9B5", "4F8B",
  "F9B6", "79AE",
  "F9B7", "91B4",
  "F9B8", "96B8",
  "F9B9", "60E1",
  "F9BA", "4E86",
  "F9BB", "50DA",
  "F9BC", "5BEE",
  "F9BD", "5C3F",
  "F9BE", "6599",
  "F9BF", "6A02",
  "F9C0", "71CE",
  "F9C1", "7642",
  "F9C2", "84FC",
  "F9C3", "907C",
  "F9C4", "9F8D",
  "F9C5", "6688",
  "F9C6", "962E",
  "F9C7", "5289",
  "F9C8", "677B",
  "F9C9", "67F3",
  "F9CA", "6D41",
  "F9CB", "6E9C",
  "F9CC", "7409",
  "F9CD", "7559",
  "F9CE", "786B",
  "F9CF", "7D10",
  "F9D0", "985E",
  "F9D1", "516D",
  "F9D2", "622E",
  "F9D3", "9678",
  "F9D4", "502B",
  "F9D5", "5D19",
  "F9D6", "6DEA",
  "F9D7", "8F2A",
  "F9D8", "5F8B",
  "F9D9", "6144",
  "F9DA", "6817",
  "F9DB", "7387",
  "F9DC", "9686",
  "F9DD", "5229",
  "F9DE", "540F",
  "F9DF", "5C65",
  "F9E0", "6613",
  "F9E1", "674E",
  "F9E2", "68A8",
  "F9E3", "6CE5",
  "F9E4", "7406",
  "F9E5", "75E2",
  "F9E6", "7F79",
  "F9E7", "88CF",
  "F9E8", "88E1",
  "F9E9", "91CC",
  "F9EA", "96E2",
  "F9EB", "533F",
  "F9EC", "6EBA",
  "F9ED", "541D",
  "F9EE", "71D0",
  "F9EF", "7498",
  "F9F0", "85FA",
  "F9F1", "96A3",
  "F9F2", "9C57",
  "F9F3", "9E9F",
  "F9F4", "6797",
  "F9F5", "6DCB",
  "F9F6", "81E8",
  "F9F7", "7ACB",
  "F9F8", "7B20",
  "F9F9", "7C92",
  "F9FA", "72C0",
  "F9FB", "7099",
  "F9FC", "8B58",
  "F9FD", "4EC0",
  "F9FE", "8336",
  "F9FF", "523A",
  "FA00", "5207",
  "FA01", "5EA6",
  "FA02", "62D3",
  "FA03", "7CD6",
  "FA04", "5B85",
  "FA05", "6D1E",
  "FA06", "66B4",
  "FA07", "8F3B",
  "FA08", "884C",
  "FA09", "964D",
  "FA0A", "898B",
  "FA0B", "5ED3",
  "FA0C", "5140",
  "FA0D", "55C0",
  "FA10", "585A",
  "FA12", "6674",
  "FA15", "51DE",
  "FA16", "732A",
  "FA17", "76CA",
  "FA18", "793C",
  "FA19", "795E",
  "FA1A", "7965",
  "FA1B", "798F",
  "FA1C", "9756",
  "FA1D", "7CBE",
  "FA1E", "7FBD",
  "FA20", "8612",
  "FA22", "8AF8",
  "FA25", "9038",
  "FA26", "90FD",
  "FA2A", "98EF",
  "FA2B", "98FC",
  "FA2C", "9928",
  "FA2D", "9DB4",
  "FA30", "4FAE",
  "FA31", "50E7",
  "FA32", "514D",
  "FA33", "52C9",
  "FA34", "52E4",
  "FA35", "5351",
  "FA36", "559D",
  "FA37", "5606",
  "FA38", "5668",
  "FA39", "5840",
  "FA3A", "58A8",
  "FA3B", "5C64",
  "FA3C", "5C6E",
  "FA3D", "6094",
  "FA3E", "6168",
  "FA3F", "618E",
  "FA40", "61F2",
  "FA41", "654F",
  "FA42", "65E2",
  "FA43", "6691",
  "FA44", "6885",
  "FA45", "6D77",
  "FA46", "6E1A",
  "FA47", "6F22",
  "FA48", "716E",
  "FA49", "722B",
  "FA4A", "7422",
  "FA4B", "7891",
  "FA4C", "793E",
  "FA4D", "7949",
  "FA4E", "7948",
  "FA4F", "7950",
  "FA50", "7956",
  "FA51", "795D",
  "FA52", "798D",
  "FA53", "798E",
  "FA54", "7A40",
  "FA55", "7A81",
  "FA56", "7BC0",
  "FA57", "7DF4",
  "FA58", "7E09",
  "FA59", "7E41",
  "FA5A", "7F72",
  "FA5B", "8005",
  "FA5C", "81ED",
  "FA5D", "8279",
  "FA5E", "8279",
  "FA5F", "8457",
  "FA60", "8910",
  "FA61", "8996",
  "FA62", "8B01",
  "FA63", "8B39",
  "FA64", "8CD3",
  "FA65", "8D08",
  "FA66", "8FB6",
  "FA67", "9038",
  "FA68", "96E3",
  "FA69", "97FF",
  "FA6A", "983B",
  "FB1D", "05D9_05B4",
  "FB1F", "05F2_05B7",
  "FB2A", "05E9_05C1",
  "FB2B", "05E9_05C2",
  "FB2C", "05E9_05BC_05C1",
  "FB2D", "05E9_05BC_05C2",
  "FB2E", "05D0_05B7",
  "FB2F", "05D0_05B8",
  "FB30", "05D0_05BC",
  "FB31", "05D1_05BC",
  "FB32", "05D2_05BC",
  "FB33", "05D3_05BC",
  "FB34", "05D4_05BC",
  "FB35", "05D5_05BC",
  "FB36", "05D6_05BC",
  "FB38", "05D8_05BC",
  "FB39", "05D9_05BC",
  "FB3A", "05DA_05BC",
  "FB3B", "05DB_05BC",
  "FB3C", "05DC_05BC",
  "FB3E", "05DE_05BC",
  "FB40", "05E0_05BC",
  "FB41", "05E1_05BC",
  "FB43", "05E3_05BC",
  "FB44", "05E4_05BC",
  "FB46", "05E6_05BC",
  "FB47", "05E7_05BC",
  "FB48", "05E8_05BC",
  "FB49", "05E9_05BC",
  "FB4A", "05EA_05BC",
  "FB4B", "05D5_05B9",
  "FB4C", "05D1_05BF",
  "FB4D", "05DB_05BF",
  "FB4E", "05E4_05BF",
  "1D15E", "1D157_1D165",
  "1D15F", "1D158_1D165",
  "1D160", "1D158_1D165_1D16E",
  "1D161", "1D158_1D165_1D16F",
  "1D162", "1D158_1D165_1D170",
  "1D163", "1D158_1D165_1D171",
  "1D164", "1D158_1D165_1D172",
  "1D1BB", "1D1B9_1D165",
  "1D1BC", "1D1BA_1D165",
  "1D1BD", "1D1B9_1D165_1D16E",
  "1D1BE", "1D1BA_1D165_1D16E",
  "1D1BF", "1D1B9_1D165_1D16F",
  "1D1C0", "1D1BA_1D165_1D16F",
  "2F800", "4E3D",
  "2F801", "4E38",
  "2F802", "4E41",
  "2F803", "20122",
  "2F804", "4F60",
  "2F805", "4FAE",
  "2F806", "4FBB",
  "2F807", "5002",
  "2F808", "507A",
  "2F809", "5099",
  "2F80A", "50E7",
  "2F80B", "50CF",
  "2F80C", "349E",
  "2F80D", "2063A",
  "2F80E", "514D",
  "2F80F", "5154",
  "2F810", "5164",
  "2F811", "5177",
  "2F812", "2051C",
  "2F813", "34B9",
  "2F814", "5167",
  "2F815", "518D",
  "2F816", "2054B",
  "2F817", "5197",
  "2F818", "51A4",
  "2F819", "4ECC",
  "2F81A", "51AC",
  "2F81B", "51B5",
  "2F81C", "291DF",
  "2F81D", "51F5",
  "2F81E", "5203",
  "2F81F", "34DF",
  "2F820", "523B",
  "2F821", "5246",
  "2F822", "5272",
  "2F823", "5277",
  "2F824", "3515",
  "2F825", "52C7",
  "2F826", "52C9",
  "2F827", "52E4",
  "2F828", "52FA",
  "2F829", "5305",
  "2F82A", "5306",
  "2F82B", "5317",
  "2F82C", "5349",
  "2F82D", "5351",
  "2F82E", "535A",
  "2F82F", "5373",
  "2F830", "537D",
  "2F831", "537F",
  "2F832", "537F",
  "2F833", "537F",
  "2F834", "20A2C",
  "2F835", "7070",
  "2F836", "53CA",
  "2F837", "53DF",
  "2F838", "20B63",
  "2F839", "53EB",
  "2F83A", "53F1",
  "2F83B", "5406",
  "2F83C", "549E",
  "2F83D", "5438",
  "2F83E", "5448",
  "2F83F", "5468",
  "2F840", "54A2",
  "2F841", "54F6",
  "2F842", "5510",
  "2F843", "5553",
  "2F844", "5563",
  "2F845", "5584",
  "2F846", "5584",
  "2F847", "5599",
  "2F848", "55AB",
  "2F849", "55B3",
  "2F84A", "55C2",
  "2F84B", "5716",
  "2F84C", "5606",
  "2F84D", "5717",
  "2F84E", "5651",
  "2F84F", "5674",
  "2F850", "5207",
  "2F851", "58EE",
  "2F852", "57CE",
  "2F853", "57F4",
  "2F854", "580D",
  "2F855", "578B",
  "2F856", "5832",
  "2F857", "5831",
  "2F858", "58AC",
  "2F859", "214E4",
  "2F85A", "58F2",
  "2F85B", "58F7",
  "2F85C", "5906",
  "2F85D", "591A",
  "2F85E", "5922",
  "2F85F", "5962",
  "2F860", "216A8",
  "2F861", "216EA",
  "2F862", "59EC",
  "2F863", "5A1B",
  "2F864", "5A27",
  "2F865", "59D8",
  "2F866", "5A66",
  "2F867", "36EE",
  "2F868", "2136A",
  "2F869", "5B08",
  "2F86A", "5B3E",
  "2F86B", "5B3E",
  "2F86C", "219C8",
  "2F86D", "5BC3",
  "2F86E", "5BD8",
  "2F86F", "5BE7",
  "2F870", "5BF3",
  "2F871", "21B18",
  "2F872", "5BFF",
  "2F873", "5C06",
  "2F874", "5F33",
  "2F875", "5C22",
  "2F876", "3781",
  "2F877", "5C60",
  "2F878", "5C6E",
  "2F879", "5CC0",
  "2F87A", "5C8D",
  "2F87B", "21DE4",
  "2F87C", "5D43",
  "2F87D", "21DE6",
  "2F87E", "5D6E",
  "2F87F", "5D6B",
  "2F880", "5D7C",
  "2F881", "5DE1",
  "2F882", "5DE2",
  "2F883", "382F",
  "2F884", "5DFD",
  "2F885", "5E28",
  "2F886", "5E3D",
  "2F887", "5E69",
  "2F888", "3862",
  "2F889", "22183",
  "2F88A", "387C",
  "2F88B", "5EB0",
  "2F88C", "5EB3",
  "2F88D", "5EB6",
  "2F88E", "5ECA",
  "2F88F", "2A392",
  "2F890", "5EFE",
  "2F891", "22331",
  "2F892", "22331",
  "2F893", "8201",
  "2F894", "5F22",
  "2F895", "5F22",
  "2F896", "38C7",
  "2F897", "232B8",
  "2F898", "261DA",
  "2F899", "5F62",
  "2F89A", "5F6B",
  "2F89B", "38E3",
  "2F89C", "5F9A",
  "2F89D", "5FCD",
  "2F89E", "5FD7",
  "2F89F", "5FF9",
  "2F8A0", "6081",
  "2F8A1", "393A",
  "2F8A2", "391C",
  "2F8A3", "6094",
  "2F8A4", "226D4",
  "2F8A5", "60C7",
  "2F8A6", "6148",
  "2F8A7", "614C",
  "2F8A8", "614E",
  "2F8A9", "614C",
  "2F8AA", "617A",
  "2F8AB", "618E",
  "2F8AC", "61B2",
  "2F8AD", "61A4",
  "2F8AE", "61AF",
  "2F8AF", "61DE",
  "2F8B0", "61F2",
  "2F8B1", "61F6",
  "2F8B2", "6210",
  "2F8B3", "621B",
  "2F8B4", "625D",
  "2F8B5", "62B1",
  "2F8B6", "62D4",
  "2F8B7", "6350",
  "2F8B8", "22B0C",
  "2F8B9", "633D",
  "2F8BA", "62FC",
  "2F8BB", "6368",
  "2F8BC", "6383",
  "2F8BD", "63E4",
  "2F8BE", "22BF1",
  "2F8BF", "6422",
  "2F8C0", "63C5",
  "2F8C1", "63A9",
  "2F8C2", "3A2E",
  "2F8C3", "6469",
  "2F8C4", "647E",
  "2F8C5", "649D",
  "2F8C6", "6477",
  "2F8C7", "3A6C",
  "2F8C8", "654F",
  "2F8C9", "656C",
  "2F8CA", "2300A",
  "2F8CB", "65E3",
  "2F8CC", "66F8",
  "2F8CD", "6649",
  "2F8CE", "3B19",
  "2F8CF", "6691",
  "2F8D0", "3B08",
  "2F8D1", "3AE4",
  "2F8D2", "5192",
  "2F8D3", "5195",
  "2F8D4", "6700",
  "2F8D5", "669C",
  "2F8D6", "80AD",
  "2F8D7", "43D9",
  "2F8D8", "6717",
  "2F8D9", "671B",
  "2F8DA", "6721",
  "2F8DB", "675E",
  "2F8DC", "6753",
  "2F8DD", "233C3",
  "2F8DE", "3B49",
  "2F8DF", "67FA",
  "2F8E0", "6785",
  "2F8E1", "6852",
  "2F8E2", "6885",
  "2F8E3", "2346D",
  "2F8E4", "688E",
  "2F8E5", "681F",
  "2F8E6", "6914",
  "2F8E7", "3B9D",
  "2F8E8", "6942",
  "2F8E9", "69A3",
  "2F8EA", "69EA",
  "2F8EB", "6AA8",
  "2F8EC", "236A3",
  "2F8ED", "6ADB",
  "2F8EE", "3C18",
  "2F8EF", "6B21",
  "2F8F0", "238A7",
  "2F8F1", "6B54",
  "2F8F2", "3C4E",
  "2F8F3", "6B72",
  "2F8F4", "6B9F",
  "2F8F5", "6BBA",
  "2F8F6", "6BBB",
  "2F8F7", "23A8D",
  "2F8F8", "21D0B",
  "2F8F9", "23AFA",
  "2F8FA", "6C4E",
  "2F8FB", "23CBC",
  "2F8FC", "6CBF",
  "2F8FD", "6CCD",
  "2F8FE", "6C67",
  "2F8FF", "6D16",
  "2F900", "6D3E",
  "2F901", "6D77",
  "2F902", "6D41",
  "2F903", "6D69",
  "2F904", "6D78",
  "2F905", "6D85",
  "2F906", "23D1E",
  "2F907", "6D34",
  "2F908", "6E2F",
  "2F909", "6E6E",
  "2F90A", "3D33",
  "2F90B", "6ECB",
  "2F90C", "6EC7",
  "2F90D", "23ED1",
  "2F90E", "6DF9",
  "2F90F", "6F6E",
  "2F910", "23F5E",
  "2F911", "23F8E",
  "2F912", "6FC6",
  "2F913", "7039",
  "2F914", "701E",
  "2F915", "701B",
  "2F916", "3D96",
  "2F917", "704A",
  "2F918", "707D",
  "2F919", "7077",
  "2F91A", "70AD",
  "2F91B", "20525",
  "2F91C", "7145",
  "2F91D", "24263",
  "2F91E", "719C",
  "2F91F", "43AB",
  "2F920", "7228",
  "2F921", "7235",
  "2F922", "7250",
  "2F923", "24608",
  "2F924", "7280",
  "2F925", "7295",
  "2F926", "24735",
  "2F927", "24814",
  "2F928", "737A",
  "2F929", "738B",
  "2F92A", "3EAC",
  "2F92B", "73A5",
  "2F92C", "3EB8",
  "2F92D", "3EB8",
  "2F92E", "7447",
  "2F92F", "745C",
  "2F930", "7471",
  "2F931", "7485",
  "2F932", "74CA",
  "2F933", "3F1B",
  "2F934", "7524",
  "2F935", "24C36",
  "2F936", "753E",
  "2F937", "24C92",
  "2F938", "7570",
  "2F939", "2219F",
  "2F93A", "7610",
  "2F93B", "24FA1",
  "2F93C", "24FB8",
  "2F93D", "25044",
  "2F93E", "3FFC",
  "2F93F", "4008",
  "2F940", "76F4",
  "2F941", "250F3",
  "2F942", "250F2",
  "2F943", "25119",
  "2F944", "25133",
  "2F945", "771E",
  "2F946", "771F",
  "2F947", "771F",
  "2F948", "774A",
  "2F949", "4039",
  "2F94A", "778B",
  "2F94B", "4046",
  "2F94C", "4096",
  "2F94D", "2541D",
  "2F94E", "784E",
  "2F94F", "788C",
  "2F950", "78CC",
  "2F951", "40E3",
  "2F952", "25626",
  "2F953", "7956",
  "2F954", "2569A",
  "2F955", "256C5",
  "2F956", "798F",
  "2F957", "79EB",
  "2F958", "412F",
  "2F959", "7A40",
  "2F95A", "7A4A",
  "2F95B", "7A4F",
  "2F95C", "2597C",
  "2F95D", "25AA7",
  "2F95E", "25AA7",
  "2F95F", "7AAE",
  "2F960", "4202",
  "2F961", "25BAB",
  "2F962", "7BC6",
  "2F963", "7BC9",
  "2F964", "4227",
  "2F965", "25C80",
  "2F966", "7CD2",
  "2F967", "42A0",
  "2F968", "7CE8",
  "2F969", "7CE3",
  "2F96A", "7D00",
  "2F96B", "25F86",
  "2F96C", "7D63",
  "2F96D", "4301",
  "2F96E", "7DC7",
  "2F96F", "7E02",
  "2F970", "7E45",
  "2F971", "4334",
  "2F972", "26228",
  "2F973", "26247",
  "2F974", "4359",
  "2F975", "262D9",
  "2F976", "7F7A",
  "2F977", "2633E",
  "2F978", "7F95",
  "2F979", "7FFA",
  "2F97A", "8005",
  "2F97B", "264DA",
  "2F97C", "26523",
  "2F97D", "8060",
  "2F97E", "265A8",
  "2F97F", "8070",
  "2F980", "2335F",
  "2F981", "43D5",
  "2F982", "80B2",
  "2F983", "8103",
  "2F984", "440B",
  "2F985", "813E",
  "2F986", "5AB5",
  "2F987", "267A7",
  "2F988", "267B5",
  "2F989", "23393",
  "2F98A", "2339C",
  "2F98B", "8201",
  "2F98C", "8204",
  "2F98D", "8F9E",
  "2F98E", "446B",
  "2F98F", "8291",
  "2F990", "828B",
  "2F991", "829D",
  "2F992", "52B3",
  "2F993", "82B1",
  "2F994", "82B3",
  "2F995", "82BD",
  "2F996", "82E6",
  "2F997", "26B3C",
  "2F998", "82E5",
  "2F999", "831D",
  "2F99A", "8363",
  "2F99B", "83AD",
  "2F99C", "8323",
  "2F99D", "83BD",
  "2F99E", "83E7",
  "2F99F", "8457",
  "2F9A0", "8353",
  "2F9A1", "83CA",
  "2F9A2", "83CC",
  "2F9A3", "83DC",
  "2F9A4", "26C36",
  "2F9A5", "26D6B",
  "2F9A6", "26CD5",
  "2F9A7", "452B",
  "2F9A8", "84F1",
  "2F9A9", "84F3",
  "2F9AA", "8516",
  "2F9AB", "273CA",
  "2F9AC", "8564",
  "2F9AD", "26F2C",
  "2F9AE", "455D",
  "2F9AF", "4561",
  "2F9B0", "26FB1",
  "2F9B1", "270D2",
  "2F9B2", "456B",
  "2F9B3", "8650",
  "2F9B4", "865C",
  "2F9B5", "8667",
  "2F9B6", "8669",
  "2F9B7", "86A9",
  "2F9B8", "8688",
  "2F9B9", "870E",
  "2F9BA", "86E2",
  "2F9BB", "8779",
  "2F9BC", "8728",
  "2F9BD", "876B",
  "2F9BE", "8786",
  "2F9BF", "4D57",
  "2F9C0", "87E1",
  "2F9C1", "8801",
  "2F9C2", "45F9",
  "2F9C3", "8860",
  "2F9C4", "8863",
  "2F9C5", "27667",
  "2F9C6", "88D7",
  "2F9C7", "88DE",
  "2F9C8", "4635",
  "2F9C9", "88FA",
  "2F9CA", "34BB",
  "2F9CB", "278AE",
  "2F9CC", "27966",
  "2F9CD", "46BE",
  "2F9CE", "46C7",
  "2F9CF", "8AA0",
  "2F9D0", "8AED",
  "2F9D1", "8B8A",
  "2F9D2", "8C55",
  "2F9D3", "27CA8",
  "2F9D4", "8CAB",
  "2F9D5", "8CC1",
  "2F9D6", "8D1B",
  "2F9D7", "8D77",
  "2F9D8", "27F2F",
  "2F9D9", "20804",
  "2F9DA", "8DCB",
  "2F9DB", "8DBC",
  "2F9DC", "8DF0",
  "2F9DD", "208DE",
  "2F9DE", "8ED4",
  "2F9DF", "8F38",
  "2F9E0", "285D2",
  "2F9E1", "285ED",
  "2F9E2", "9094",
  "2F9E3", "90F1",
  "2F9E4", "9111",
  "2F9E5", "2872E",
  "2F9E6", "911B",
  "2F9E7", "9238",
  "2F9E8", "92D7",
  "2F9E9", "92D8",
  "2F9EA", "927C",
  "2F9EB", "93F9",
  "2F9EC", "9415",
  "2F9ED", "28BFA",
  "2F9EE", "958B",
  "2F9EF", "4995",
  "2F9F0", "95B7",
  "2F9F1", "28D77",
  "2F9F2", "49E6",
  "2F9F3", "96C3",
  "2F9F4", "5DB2",
  "2F9F5", "9723",
  "2F9F6", "29145",
  "2F9F7", "2921A",
  "2F9F8", "4A6E",
  "2F9F9", "4A76",
  "2F9FA", "97E0",
  "2F9FB", "2940A",
  "2F9FC", "4AB2",
  "2F9FD", "29496",
  "2F9FE", "980B",
  "2F9FF", "980B",
  "2FA00", "9829",
  "2FA01", "295B6",
  "2FA02", "98E2",
  "2FA03", "4B33",
  "2FA04", "9929",
  "2FA05", "99A7",
  "2FA06", "99C2",
  "2FA07", "99FE",
  "2FA08", "4BCE",
  "2FA09", "29B30",
  "2FA0A", "9B12",
  "2FA0B", "9C40",
  "2FA0C", "9CFD",
  "2FA0D", "4CCE",
  "2FA0E", "4CED",
  "2FA0F", "9D67",
  "2FA10", "2A0CE",
  "2FA11", "4CF8",
  "2FA12", "2A105",
  "2FA13", "2A20E",
  "2FA14", "2A291",
  "2FA15", "9EBB",
  "2FA16", "4D56",
  "2FA17", "9EF9",
  "2FA18", "9EFE",
  "2FA19", "9F05",
  "2FA1A", "9F0F",
  "2FA1B", "9F16",
  "2FA1C", "9F3B",
  "2FA1D", "2A600",
);

my %AGL_to_unicode = (
  "A", "0041",
  "AE", "00C6",
  "AEacute", "01FC",
  "AEmacron", "01E2",
  "Aacute", "00C1",
  "Abreve", "0102",
  "Abreveacute", "1EAE",
  "Abrevecyrillic", "04D0",
  "Abrevedotbelow", "1EB6",
  "Abrevegrave", "1EB0",
  "Abrevehookabove", "1EB2",
  "Abrevetilde", "1EB4",
  "Acaron", "01CD",
  "Acircle", "24B6",
  "Acircumflex", "00C2",
  "Acircumflexacute", "1EA4",
  "Acircumflexdotbelow", "1EAC",
  "Acircumflexgrave", "1EA6",
  "Acircumflexhookabove", "1EA8",
  "Acircumflextilde", "1EAA",
  "Acyrillic", "0410",
  "Adblgrave", "0200",
  "Adieresis", "00C4",
  "Adieresiscyrillic", "04D2",
  "Adieresismacron", "01DE",
  "Adotbelow", "1EA0",
  "Adotmacron", "01E0",
  "Agrave", "00C0",
  "Ahookabove", "1EA2",
  "Aiecyrillic", "04D4",
  "Ainvertedbreve", "0202",
  "Alpha", "0391",
  "Alphatonos", "0386",
  "Amacron", "0100",
  "Amonospace", "FF21",
  "Aogonek", "0104",
  "Aring", "00C5",
  "Aringacute", "01FA",
  "Aringbelow", "1E00",
  "Atilde", "00C3",
  "Aybarmenian", "0531",
  "B", "0042",
  "Bcircle", "24B7",
  "Bdotaccent", "1E02",
  "Bdotbelow", "1E04",
  "Becyrillic", "0411",
  "Benarmenian", "0532",
  "Beta", "0392",
  "Bhook", "0181",
  "Blinebelow", "1E06",
  "Bmonospace", "FF22",
  "Btopbar", "0182",
  "C", "0043",
  "Caarmenian", "053E",
  "Cacute", "0106",
  "Ccaron", "010C",
  "Ccedilla", "00C7",
  "Ccedillaacute", "1E08",
  "Ccircle", "24B8",
  "Ccircumflex", "0108",
  "Cdot", "010A",
  "Cdotaccent", "010A",
  "Chaarmenian", "0549",
  "Cheabkhasiancyrillic", "04BC",
  "Checyrillic", "0427",
  "Chedescenderabkhasiancyrillic", "04BE",
  "Chedescendercyrillic", "04B6",
  "Chedieresiscyrillic", "04F4",
  "Cheharmenian", "0543",
  "Chekhakassiancyrillic", "04CB",
  "Cheverticalstrokecyrillic", "04B8",
  "Chi", "03A7",
  "Chook", "0187",
  "Cmonospace", "FF23",
  "Coarmenian", "0551",
  "D", "0044",
  "DZ", "01F1",
  "DZcaron", "01C4",
  "Daarmenian", "0534",
  "Dafrican", "0189",
  "Dcaron", "010E",
  "Dcedilla", "1E10",
  "Dcircle", "24B9",
  "Dcircumflexbelow", "1E12",
  "Dcroat", "0110",
  "Ddotaccent", "1E0A",
  "Ddotbelow", "1E0C",
  "Decyrillic", "0414",
  "Deicoptic", "03EE",
  "Delta", "2206",
  "Deltagreek", "0394",
  "Dhook", "018A",
  "Digammagreek", "03DC",
  "Djecyrillic", "0402",
  "Dlinebelow", "1E0E",
  "Dmonospace", "FF24",
  "Dslash", "0110",
  "Dtopbar", "018B",
  "Dz", "01F2",
  "Dzcaron", "01C5",
  "Dzeabkhasiancyrillic", "04E0",
  "Dzecyrillic", "0405",
  "Dzhecyrillic", "040F",
  "E", "0045",
  "Eacute", "00C9",
  "Ebreve", "0114",
  "Ecaron", "011A",
  "Ecedillabreve", "1E1C",
  "Echarmenian", "0535",
  "Ecircle", "24BA",
  "Ecircumflex", "00CA",
  "Ecircumflexacute", "1EBE",
  "Ecircumflexbelow", "1E18",
  "Ecircumflexdotbelow", "1EC6",
  "Ecircumflexgrave", "1EC0",
  "Ecircumflexhookabove", "1EC2",
  "Ecircumflextilde", "1EC4",
  "Ecyrillic", "0404",
  "Edblgrave", "0204",
  "Edieresis", "00CB",
  "Edot", "0116",
  "Edotaccent", "0116",
  "Edotbelow", "1EB8",
  "Efcyrillic", "0424",
  "Egrave", "00C8",
  "Eharmenian", "0537",
  "Ehookabove", "1EBA",
  "Eightroman", "2167",
  "Einvertedbreve", "0206",
  "Eiotifiedcyrillic", "0464",
  "Elcyrillic", "041B",
  "Elevenroman", "216A",
  "Emacron", "0112",
  "Emacronacute", "1E16",
  "Emacrongrave", "1E14",
  "Emcyrillic", "041C",
  "Emonospace", "FF25",
  "Encyrillic", "041D",
  "Endescendercyrillic", "04A2",
  "Eng", "014A",
  "Enghecyrillic", "04A4",
  "Enhookcyrillic", "04C7",
  "Eogonek", "0118",
  "Eopen", "0190",
  "Epsilon", "0395",
  "Epsilontonos", "0388",
  "Ercyrillic", "0420",
  "Ereversed", "018E",
  "Ereversedcyrillic", "042D",
  "Escyrillic", "0421",
  "Esdescendercyrillic", "04AA",
  "Esh", "01A9",
  "Eta", "0397",
  "Etarmenian", "0538",
  "Etatonos", "0389",
  "Eth", "00D0",
  "Etilde", "1EBC",
  "Etildebelow", "1E1A",
  "Euro", "20AC",
  "Ezh", "01B7",
  "Ezhcaron", "01EE",
  "Ezhreversed", "01B8",
  "F", "0046",
  "Fcircle", "24BB",
  "Fdotaccent", "1E1E",
  "Feharmenian", "0556",
  "Feicoptic", "03E4",
  "Fhook", "0191",
  "Fitacyrillic", "0472",
  "Fiveroman", "2164",
  "Fmonospace", "FF26",
  "Fourroman", "2163",
  "G", "0047",
  "GBsquare", "3387",
  "Gacute", "01F4",
  "Gamma", "0393",
  "Gammaafrican", "0194",
  "Gangiacoptic", "03EA",
  "Gbreve", "011E",
  "Gcaron", "01E6",
  "Gcedilla", "0122",
  "Gcircle", "24BC",
  "Gcircumflex", "011C",
  "Gcommaaccent", "0122",
  "Gdot", "0120",
  "Gdotaccent", "0120",
  "Gecyrillic", "0413",
  "Ghadarmenian", "0542",
  "Ghemiddlehookcyrillic", "0494",
  "Ghestrokecyrillic", "0492",
  "Gheupturncyrillic", "0490",
  "Ghook", "0193",
  "Gimarmenian", "0533",
  "Gjecyrillic", "0403",
  "Gmacron", "1E20",
  "Gmonospace", "FF27",
  "Gsmallhook", "029B",
  "Gstroke", "01E4",
  "H", "0048",
  "H18533", "25CF",
  "H18543", "25AA",
  "H18551", "25AB",
  "H22073", "25A1",
  "HPsquare", "33CB",
  "Haabkhasiancyrillic", "04A8",
  "Hadescendercyrillic", "04B2",
  "Hardsigncyrillic", "042A",
  "Hbar", "0126",
  "Hbrevebelow", "1E2A",
  "Hcedilla", "1E28",
  "Hcircle", "24BD",
  "Hcircumflex", "0124",
  "Hdieresis", "1E26",
  "Hdotaccent", "1E22",
  "Hdotbelow", "1E24",
  "Hmonospace", "FF28",
  "Hoarmenian", "0540",
  "Horicoptic", "03E8",
  "Hzsquare", "3390",
  "I", "0049",
  "IAcyrillic", "042F",
  "IJ", "0132",
  "IUcyrillic", "042E",
  "Iacute", "00CD",
  "Ibreve", "012C",
  "Icaron", "01CF",
  "Icircle", "24BE",
  "Icircumflex", "00CE",
  "Icyrillic", "0406",
  "Idblgrave", "0208",
  "Idieresis", "00CF",
  "Idieresisacute", "1E2E",
  "Idieresiscyrillic", "04E4",
  "Idot", "0130",
  "Idotaccent", "0130",
  "Idotbelow", "1ECA",
  "Iebrevecyrillic", "04D6",
  "Iecyrillic", "0415",
  "Ifraktur", "2111",
  "Igrave", "00CC",
  "Ihookabove", "1EC8",
  "Iicyrillic", "0418",
  "Iinvertedbreve", "020A",
  "Iishortcyrillic", "0419",
  "Imacron", "012A",
  "Imacroncyrillic", "04E2",
  "Imonospace", "FF29",
  "Iniarmenian", "053B",
  "Iocyrillic", "0401",
  "Iogonek", "012E",
  "Iota", "0399",
  "Iotaafrican", "0196",
  "Iotadieresis", "03AA",
  "Iotatonos", "038A",
  "Istroke", "0197",
  "Itilde", "0128",
  "Itildebelow", "1E2C",
  "Izhitsacyrillic", "0474",
  "Izhitsadblgravecyrillic", "0476",
  "J", "004A",
  "Jaarmenian", "0541",
  "Jcircle", "24BF",
  "Jcircumflex", "0134",
  "Jecyrillic", "0408",
  "Jheharmenian", "054B",
  "Jmonospace", "FF2A",
  "K", "004B",
  "KBsquare", "3385",
  "KKsquare", "33CD",
  "Kabashkircyrillic", "04A0",
  "Kacute", "1E30",
  "Kacyrillic", "041A",
  "Kadescendercyrillic", "049A",
  "Kahookcyrillic", "04C3",
  "Kappa", "039A",
  "Kastrokecyrillic", "049E",
  "Kaverticalstrokecyrillic", "049C",
  "Kcaron", "01E8",
  "Kcedilla", "0136",
  "Kcircle", "24C0",
  "Kcommaaccent", "0136",
  "Kdotbelow", "1E32",
  "Keharmenian", "0554",
  "Kenarmenian", "053F",
  "Khacyrillic", "0425",
  "Kheicoptic", "03E6",
  "Khook", "0198",
  "Kjecyrillic", "040C",
  "Klinebelow", "1E34",
  "Kmonospace", "FF2B",
  "Koppacyrillic", "0480",
  "Koppagreek", "03DE",
  "Ksicyrillic", "046E",
  "L", "004C",
  "LJ", "01C7",
  "Lacute", "0139",
  "Lambda", "039B",
  "Lcaron", "013D",
  "Lcedilla", "013B",
  "Lcircle", "24C1",
  "Lcircumflexbelow", "1E3C",
  "Lcommaaccent", "013B",
  "Ldot", "013F",
  "Ldotaccent", "013F",
  "Ldotbelow", "1E36",
  "Ldotbelowmacron", "1E38",
  "Liwnarmenian", "053C",
  "Lj", "01C8",
  "Ljecyrillic", "0409",
  "Llinebelow", "1E3A",
  "Lmonospace", "FF2C",
  "Lslash", "0141",
  "M", "004D",
  "MBsquare", "3386",
  "Macute", "1E3E",
  "Mcircle", "24C2",
  "Mdotaccent", "1E40",
  "Mdotbelow", "1E42",
  "Menarmenian", "0544",
  "Mmonospace", "FF2D",
  "Mturned", "019C",
  "Mu", "039C",
  "N", "004E",
  "NJ", "01CA",
  "Nacute", "0143",
  "Ncaron", "0147",
  "Ncedilla", "0145",
  "Ncircle", "24C3",
  "Ncircumflexbelow", "1E4A",
  "Ncommaaccent", "0145",
  "Ndotaccent", "1E44",
  "Ndotbelow", "1E46",
  "Nhookleft", "019D",
  "Nineroman", "2168",
  "Nj", "01CB",
  "Njecyrillic", "040A",
  "Nlinebelow", "1E48",
  "Nmonospace", "FF2E",
  "Nowarmenian", "0546",
  "Ntilde", "00D1",
  "Nu", "039D",
  "O", "004F",
  "OE", "0152",
  "Oacute", "00D3",
  "Obarredcyrillic", "04E8",
  "Obarreddieresiscyrillic", "04EA",
  "Obreve", "014E",
  "Ocaron", "01D1",
  "Ocenteredtilde", "019F",
  "Ocircle", "24C4",
  "Ocircumflex", "00D4",
  "Ocircumflexacute", "1ED0",
  "Ocircumflexdotbelow", "1ED8",
  "Ocircumflexgrave", "1ED2",
  "Ocircumflexhookabove", "1ED4",
  "Ocircumflextilde", "1ED6",
  "Ocyrillic", "041E",
  "Odblacute", "0150",
  "Odblgrave", "020C",
  "Odieresis", "00D6",
  "Odieresiscyrillic", "04E6",
  "Odotbelow", "1ECC",
  "Ograve", "00D2",
  "Oharmenian", "0555",
  "Ohm", "2126",
  "Ohookabove", "1ECE",
  "Ohorn", "01A0",
  "Ohornacute", "1EDA",
  "Ohorndotbelow", "1EE2",
  "Ohorngrave", "1EDC",
  "Ohornhookabove", "1EDE",
  "Ohorntilde", "1EE0",
  "Ohungarumlaut", "0150",
  "Oi", "01A2",
  "Oinvertedbreve", "020E",
  "Omacron", "014C",
  "Omacronacute", "1E52",
  "Omacrongrave", "1E50",
  "Omega", "2126",
  "Omegacyrillic", "0460",
  "Omegagreek", "03A9",
  "Omegaroundcyrillic", "047A",
  "Omegatitlocyrillic", "047C",
  "Omegatonos", "038F",
  "Omicron", "039F",
  "Omicrontonos", "038C",
  "Omonospace", "FF2F",
  "Oneroman", "2160",
  "Oogonek", "01EA",
  "Oogonekmacron", "01EC",
  "Oopen", "0186",
  "Oslash", "00D8",
  "Oslashacute", "01FE",
  "Ostrokeacute", "01FE",
  "Otcyrillic", "047E",
  "Otilde", "00D5",
  "Otildeacute", "1E4C",
  "Otildedieresis", "1E4E",
  "P", "0050",
  "Pacute", "1E54",
  "Pcircle", "24C5",
  "Pdotaccent", "1E56",
  "Pecyrillic", "041F",
  "Peharmenian", "054A",
  "Pemiddlehookcyrillic", "04A6",
  "Phi", "03A6",
  "Phook", "01A4",
  "Pi", "03A0",
  "Piwrarmenian", "0553",
  "Pmonospace", "FF30",
  "Psi", "03A8",
  "Psicyrillic", "0470",
  "Q", "0051",
  "Qcircle", "24C6",
  "Qmonospace", "FF31",
  "R", "0052",
  "Raarmenian", "054C",
  "Racute", "0154",
  "Rcaron", "0158",
  "Rcedilla", "0156",
  "Rcircle", "24C7",
  "Rcommaaccent", "0156",
  "Rdblgrave", "0210",
  "Rdotaccent", "1E58",
  "Rdotbelow", "1E5A",
  "Rdotbelowmacron", "1E5C",
  "Reharmenian", "0550",
  "Rfraktur", "211C",
  "Rho", "03A1",
  "Rinvertedbreve", "0212",
  "Rlinebelow", "1E5E",
  "Rmonospace", "FF32",
  "Rsmallinverted", "0281",
  "Rsmallinvertedsuperior", "02B6",
  "S", "0053",
  "SF010000", "250C",
  "SF020000", "2514",
  "SF030000", "2510",
  "SF040000", "2518",
  "SF050000", "253C",
  "SF060000", "252C",
  "SF070000", "2534",
  "SF080000", "251C",
  "SF090000", "2524",
  "SF100000", "2500",
  "SF110000", "2502",
  "SF190000", "2561",
  "SF200000", "2562",
  "SF210000", "2556",
  "SF220000", "2555",
  "SF230000", "2563",
  "SF240000", "2551",
  "SF250000", "2557",
  "SF260000", "255D",
  "SF270000", "255C",
  "SF280000", "255B",
  "SF360000", "255E",
  "SF370000", "255F",
  "SF380000", "255A",
  "SF390000", "2554",
  "SF400000", "2569",
  "SF410000", "2566",
  "SF420000", "2560",
  "SF430000", "2550",
  "SF440000", "256C",
  "SF450000", "2567",
  "SF460000", "2568",
  "SF470000", "2564",
  "SF480000", "2565",
  "SF490000", "2559",
  "SF500000", "2558",
  "SF510000", "2552",
  "SF520000", "2553",
  "SF530000", "256B",
  "SF540000", "256A",
  "Sacute", "015A",
  "Sacutedotaccent", "1E64",
  "Sampigreek", "03E0",
  "Scaron", "0160",
  "Scarondotaccent", "1E66",
  "Scedilla", "015E",
  "Schwa", "018F",
  "Schwacyrillic", "04D8",
  "Schwadieresiscyrillic", "04DA",
  "Scircle", "24C8",
  "Scircumflex", "015C",
  "Scommaaccent", "0218",
  "Sdotaccent", "1E60",
  "Sdotbelow", "1E62",
  "Sdotbelowdotaccent", "1E68",
  "Seharmenian", "054D",
  "Sevenroman", "2166",
  "Shaarmenian", "0547",
  "Shacyrillic", "0428",
  "Shchacyrillic", "0429",
  "Sheicoptic", "03E2",
  "Shhacyrillic", "04BA",
  "Shimacoptic", "03EC",
  "Sigma", "03A3",
  "Sixroman", "2165",
  "Smonospace", "FF33",
  "Softsigncyrillic", "042C",
  "Stigmagreek", "03DA",
  "T", "0054",
  "Tau", "03A4",
  "Tbar", "0166",
  "Tcaron", "0164",
  "Tcedilla", "0162",
  "Tcircle", "24C9",
  "Tcircumflexbelow", "1E70",
  "Tcommaaccent", "0162",
  "Tdotaccent", "1E6A",
  "Tdotbelow", "1E6C",
  "Tecyrillic", "0422",
  "Tedescendercyrillic", "04AC",
  "Tenroman", "2169",
  "Tetsecyrillic", "04B4",
  "Theta", "0398",
  "Thook", "01AC",
  "Thorn", "00DE",
  "Threeroman", "2162",
  "Tiwnarmenian", "054F",
  "Tlinebelow", "1E6E",
  "Tmonospace", "FF34",
  "Toarmenian", "0539",
  "Tonefive", "01BC",
  "Tonesix", "0184",
  "Tonetwo", "01A7",
  "Tretroflexhook", "01AE",
  "Tsecyrillic", "0426",
  "Tshecyrillic", "040B",
  "Twelveroman", "216B",
  "Tworoman", "2161",
  "U", "0055",
  "Uacute", "00DA",
  "Ubreve", "016C",
  "Ucaron", "01D3",
  "Ucircle", "24CA",
  "Ucircumflex", "00DB",
  "Ucircumflexbelow", "1E76",
  "Ucyrillic", "0423",
  "Udblacute", "0170",
  "Udblgrave", "0214",
  "Udieresis", "00DC",
  "Udieresisacute", "01D7",
  "Udieresisbelow", "1E72",
  "Udieresiscaron", "01D9",
  "Udieresiscyrillic", "04F0",
  "Udieresisgrave", "01DB",
  "Udieresismacron", "01D5",
  "Udotbelow", "1EE4",
  "Ugrave", "00D9",
  "Uhookabove", "1EE6",
  "Uhorn", "01AF",
  "Uhornacute", "1EE8",
  "Uhorndotbelow", "1EF0",
  "Uhorngrave", "1EEA",
  "Uhornhookabove", "1EEC",
  "Uhorntilde", "1EEE",
  "Uhungarumlaut", "0170",
  "Uhungarumlautcyrillic", "04F2",
  "Uinvertedbreve", "0216",
  "Ukcyrillic", "0478",
  "Umacron", "016A",
  "Umacroncyrillic", "04EE",
  "Umacrondieresis", "1E7A",
  "Umonospace", "FF35",
  "Uogonek", "0172",
  "Upsilon", "03A5",
  "Upsilon1", "03D2",
  "Upsilonacutehooksymbolgreek", "03D3",
  "Upsilonafrican", "01B1",
  "Upsilondieresis", "03AB",
  "Upsilondieresishooksymbolgreek", "03D4",
  "Upsilonhooksymbol", "03D2",
  "Upsilontonos", "038E",
  "Uring", "016E",
  "Ushortcyrillic", "040E",
  "Ustraightcyrillic", "04AE",
  "Ustraightstrokecyrillic", "04B0",
  "Utilde", "0168",
  "Utildeacute", "1E78",
  "Utildebelow", "1E74",
  "V", "0056",
  "Vcircle", "24CB",
  "Vdotbelow", "1E7E",
  "Vecyrillic", "0412",
  "Vewarmenian", "054E",
  "Vhook", "01B2",
  "Vmonospace", "FF36",
  "Voarmenian", "0548",
  "Vtilde", "1E7C",
  "W", "0057",
  "Wacute", "1E82",
  "Wcircle", "24CC",
  "Wcircumflex", "0174",
  "Wdieresis", "1E84",
  "Wdotaccent", "1E86",
  "Wdotbelow", "1E88",
  "Wgrave", "1E80",
  "Wmonospace", "FF37",
  "X", "0058",
  "Xcircle", "24CD",
  "Xdieresis", "1E8C",
  "Xdotaccent", "1E8A",
  "Xeharmenian", "053D",
  "Xi", "039E",
  "Xmonospace", "FF38",
  "Y", "0059",
  "Yacute", "00DD",
  "Yatcyrillic", "0462",
  "Ycircle", "24CE",
  "Ycircumflex", "0176",
  "Ydieresis", "0178",
  "Ydotaccent", "1E8E",
  "Ydotbelow", "1EF4",
  "Yericyrillic", "042B",
  "Yerudieresiscyrillic", "04F8",
  "Ygrave", "1EF2",
  "Yhook", "01B3",
  "Yhookabove", "1EF6",
  "Yiarmenian", "0545",
  "Yicyrillic", "0407",
  "Yiwnarmenian", "0552",
  "Ymonospace", "FF39",
  "Ytilde", "1EF8",
  "Yusbigcyrillic", "046A",
  "Yusbigiotifiedcyrillic", "046C",
  "Yuslittlecyrillic", "0466",
  "Yuslittleiotifiedcyrillic", "0468",
  "Z", "005A",
  "Zaarmenian", "0536",
  "Zacute", "0179",
  "Zcaron", "017D",
  "Zcircle", "24CF",
  "Zcircumflex", "1E90",
  "Zdot", "017B",
  "Zdotaccent", "017B",
  "Zdotbelow", "1E92",
  "Zecyrillic", "0417",
  "Zedescendercyrillic", "0498",
  "Zedieresiscyrillic", "04DE",
  "Zeta", "0396",
  "Zhearmenian", "053A",
  "Zhebrevecyrillic", "04C1",
  "Zhecyrillic", "0416",
  "Zhedescendercyrillic", "0496",
  "Zhedieresiscyrillic", "04DC",
  "Zlinebelow", "1E94",
  "Zmonospace", "FF3A",
  "Zstroke", "01B5",
  "a", "0061",
  "aabengali", "0986",
  "aacute", "00E1",
  "aadeva", "0906",
  "aagujarati", "0A86",
  "aagurmukhi", "0A06",
  "aamatragurmukhi", "0A3E",
  "aarusquare", "3303",
  "aavowelsignbengali", "09BE",
  "aavowelsigndeva", "093E",
  "aavowelsigngujarati", "0ABE",
  "abbreviationmarkarmenian", "055F",
  "abbreviationsigndeva", "0970",
  "abengali", "0985",
  "abopomofo", "311A",
  "abreve", "0103",
  "abreveacute", "1EAF",
  "abrevecyrillic", "04D1",
  "abrevedotbelow", "1EB7",
  "abrevegrave", "1EB1",
  "abrevehookabove", "1EB3",
  "abrevetilde", "1EB5",
  "acaron", "01CE",
  "acircle", "24D0",
  "acircumflex", "00E2",
  "acircumflexacute", "1EA5",
  "acircumflexdotbelow", "1EAD",
  "acircumflexgrave", "1EA7",
  "acircumflexhookabove", "1EA9",
  "acircumflextilde", "1EAB",
  "acute", "00B4",
  "acutebelowcmb", "0317",
  "acutecmb", "0301",
  "acutecomb", "0301",
  "acutedeva", "0954",
  "acutelowmod", "02CF",
  "acutetonecmb", "0341",
  "acyrillic", "0430",
  "adblgrave", "0201",
  "addakgurmukhi", "0A71",
  "adeva", "0905",
  "adieresis", "00E4",
  "adieresiscyrillic", "04D3",
  "adieresismacron", "01DF",
  "adotbelow", "1EA1",
  "adotmacron", "01E1",
  "ae", "00E6",
  "aeacute", "01FD",
  "aekorean", "3150",
  "aemacron", "01E3",
  "afii00208", "2015",
  "afii08941", "20A4",
  "afii10017", "0410",
  "afii10018", "0411",
  "afii10019", "0412",
  "afii10020", "0413",
  "afii10021", "0414",
  "afii10022", "0415",
  "afii10023", "0401",
  "afii10024", "0416",
  "afii10025", "0417",
  "afii10026", "0418",
  "afii10027", "0419",
  "afii10028", "041A",
  "afii10029", "041B",
  "afii10030", "041C",
  "afii10031", "041D",
  "afii10032", "041E",
  "afii10033", "041F",
  "afii10034", "0420",
  "afii10035", "0421",
  "afii10036", "0422",
  "afii10037", "0423",
  "afii10038", "0424",
  "afii10039", "0425",
  "afii10040", "0426",
  "afii10041", "0427",
  "afii10042", "0428",
  "afii10043", "0429",
  "afii10044", "042A",
  "afii10045", "042B",
  "afii10046", "042C",
  "afii10047", "042D",
  "afii10048", "042E",
  "afii10049", "042F",
  "afii10050", "0490",
  "afii10051", "0402",
  "afii10052", "0403",
  "afii10053", "0404",
  "afii10054", "0405",
  "afii10055", "0406",
  "afii10056", "0407",
  "afii10057", "0408",
  "afii10058", "0409",
  "afii10059", "040A",
  "afii10060", "040B",
  "afii10061", "040C",
  "afii10062", "040E",
  "afii10065", "0430",
  "afii10066", "0431",
  "afii10067", "0432",
  "afii10068", "0433",
  "afii10069", "0434",
  "afii10070", "0435",
  "afii10071", "0451",
  "afii10072", "0436",
  "afii10073", "0437",
  "afii10074", "0438",
  "afii10075", "0439",
  "afii10076", "043A",
  "afii10077", "043B",
  "afii10078", "043C",
  "afii10079", "043D",
  "afii10080", "043E",
  "afii10081", "043F",
  "afii10082", "0440",
  "afii10083", "0441",
  "afii10084", "0442",
  "afii10085", "0443",
  "afii10086", "0444",
  "afii10087", "0445",
  "afii10088", "0446",
  "afii10089", "0447",
  "afii10090", "0448",
  "afii10091", "0449",
  "afii10092", "044A",
  "afii10093", "044B",
  "afii10094", "044C",
  "afii10095", "044D",
  "afii10096", "044E",
  "afii10097", "044F",
  "afii10098", "0491",
  "afii10099", "0452",
  "afii10100", "0453",
  "afii10101", "0454",
  "afii10102", "0455",
  "afii10103", "0456",
  "afii10104", "0457",
  "afii10105", "0458",
  "afii10106", "0459",
  "afii10107", "045A",
  "afii10108", "045B",
  "afii10109", "045C",
  "afii10110", "045E",
  "afii10145", "040F",
  "afii10146", "0462",
  "afii10147", "0472",
  "afii10148", "0474",
  "afii10193", "045F",
  "afii10194", "0463",
  "afii10195", "0473",
  "afii10196", "0475",
  "afii10846", "04D9",
  "afii299", "200E",
  "afii300", "200F",
  "afii301", "200D",
  "afii57381", "066A",
  "afii57388", "060C",
  "afii57392", "0660",
  "afii57393", "0661",
  "afii57394", "0662",
  "afii57395", "0663",
  "afii57396", "0664",
  "afii57397", "0665",
  "afii57398", "0666",
  "afii57399", "0667",
  "afii57400", "0668",
  "afii57401", "0669",
  "afii57403", "061B",
  "afii57407", "061F",
  "afii57409", "0621",
  "afii57410", "0622",
  "afii57411", "0623",
  "afii57412", "0624",
  "afii57413", "0625",
  "afii57414", "0626",
  "afii57415", "0627",
  "afii57416", "0628",
  "afii57417", "0629",
  "afii57418", "062A",
  "afii57419", "062B",
  "afii57420", "062C",
  "afii57421", "062D",
  "afii57422", "062E",
  "afii57423", "062F",
  "afii57424", "0630",
  "afii57425", "0631",
  "afii57426", "0632",
  "afii57427", "0633",
  "afii57428", "0634",
  "afii57429", "0635",
  "afii57430", "0636",
  "afii57431", "0637",
  "afii57432", "0638",
  "afii57433", "0639",
  "afii57434", "063A",
  "afii57440", "0640",
  "afii57441", "0641",
  "afii57442", "0642",
  "afii57443", "0643",
  "afii57444", "0644",
  "afii57445", "0645",
  "afii57446", "0646",
  "afii57448", "0648",
  "afii57449", "0649",
  "afii57450", "064A",
  "afii57451", "064B",
  "afii57452", "064C",
  "afii57453", "064D",
  "afii57454", "064E",
  "afii57455", "064F",
  "afii57456", "0650",
  "afii57457", "0651",
  "afii57458", "0652",
  "afii57470", "0647",
  "afii57505", "06A4",
  "afii57506", "067E",
  "afii57507", "0686",
  "afii57508", "0698",
  "afii57509", "06AF",
  "afii57511", "0679",
  "afii57512", "0688",
  "afii57513", "0691",
  "afii57514", "06BA",
  "afii57519", "06D2",
  "afii57534", "06D5",
  "afii57636", "20AA",
  "afii57645", "05BE",
  "afii57658", "05C3",
  "afii57664", "05D0",
  "afii57665", "05D1",
  "afii57666", "05D2",
  "afii57667", "05D3",
  "afii57668", "05D4",
  "afii57669", "05D5",
  "afii57670", "05D6",
  "afii57671", "05D7",
  "afii57672", "05D8",
  "afii57673", "05D9",
  "afii57674", "05DA",
  "afii57675", "05DB",
  "afii57676", "05DC",
  "afii57677", "05DD",
  "afii57678", "05DE",
  "afii57679", "05DF",
  "afii57680", "05E0",
  "afii57681", "05E1",
  "afii57682", "05E2",
  "afii57683", "05E3",
  "afii57684", "05E4",
  "afii57685", "05E5",
  "afii57686", "05E6",
  "afii57687", "05E7",
  "afii57688", "05E8",
  "afii57689", "05E9",
  "afii57690", "05EA",
  "afii57694", "FB2A",
  "afii57695", "FB2B",
  "afii57700", "FB4B",
  "afii57705", "FB1F",
  "afii57716", "05F0",
  "afii57717", "05F1",
  "afii57718", "05F2",
  "afii57723", "FB35",
  "afii57793", "05B4",
  "afii57794", "05B5",
  "afii57795", "05B6",
  "afii57796", "05BB",
  "afii57797", "05B8",
  "afii57798", "05B7",
  "afii57799", "05B0",
  "afii57800", "05B2",
  "afii57801", "05B1",
  "afii57802", "05B3",
  "afii57803", "05C2",
  "afii57804", "05C1",
  "afii57806", "05B9",
  "afii57807", "05BC",
  "afii57839", "05BD",
  "afii57841", "05BF",
  "afii57842", "05C0",
  "afii57929", "02BC",
  "afii61248", "2105",
  "afii61289", "2113",
  "afii61352", "2116",
  "afii61573", "202C",
  "afii61574", "202D",
  "afii61575", "202E",
  "afii61664", "200C",
  "afii63167", "066D",
  "afii64937", "02BD",
  "agrave", "00E0",
  "agujarati", "0A85",
  "agurmukhi", "0A05",
  "ahiragana", "3042",
  "ahookabove", "1EA3",
  "aibengali", "0990",
  "aibopomofo", "311E",
  "aideva", "0910",
  "aiecyrillic", "04D5",
  "aigujarati", "0A90",
  "aigurmukhi", "0A10",
  "aimatragurmukhi", "0A48",
  "ainarabic", "0639",
  "ainfinalarabic", "FECA",
  "aininitialarabic", "FECB",
  "ainmedialarabic", "FECC",
  "ainvertedbreve", "0203",
  "aivowelsignbengali", "09C8",
  "aivowelsigndeva", "0948",
  "aivowelsigngujarati", "0AC8",
  "akatakana", "30A2",
  "akatakanahalfwidth", "FF71",
  "akorean", "314F",
  "alef", "05D0",
  "alefarabic", "0627",
  "alefdageshhebrew", "FB30",
  "aleffinalarabic", "FE8E",
  "alefhamzaabovearabic", "0623",
  "alefhamzaabovefinalarabic", "FE84",
  "alefhamzabelowarabic", "0625",
  "alefhamzabelowfinalarabic", "FE88",
  "alefhebrew", "05D0",
  "aleflamedhebrew", "FB4F",
  "alefmaddaabovearabic", "0622",
  "alefmaddaabovefinalarabic", "FE82",
  "alefmaksuraarabic", "0649",
  "alefmaksurafinalarabic", "FEF0",
  "alefmaksurainitialarabic", "FEF3",
  "alefmaksuramedialarabic", "FEF4",
  "alefpatahhebrew", "FB2E",
  "alefqamatshebrew", "FB2F",
  "aleph", "2135",
  "allequal", "224C",
  "alpha", "03B1",
  "alphatonos", "03AC",
  "amacron", "0101",
  "amonospace", "FF41",
  "ampersand", "0026",
  "ampersandmonospace", "FF06",
  "amsquare", "33C2",
  "anbopomofo", "3122",
  "angbopomofo", "3124",
  "angkhankhuthai", "0E5A",
  "angle", "2220",
  "anglebracketleft", "3008",
  "anglebracketleftvertical", "FE3F",
  "anglebracketright", "3009",
  "anglebracketrightvertical", "FE40",
  "angleleft", "2329",
  "angleright", "232A",
  "angstrom", "212B",
  "anoteleia", "0387",
  "anudattadeva", "0952",
  "anusvarabengali", "0982",
  "anusvaradeva", "0902",
  "anusvaragujarati", "0A82",
  "aogonek", "0105",
  "apaatosquare", "3300",
  "aparen", "249C",
  "apostrophearmenian", "055A",
  "apostrophemod", "02BC",
  "approaches", "2250",
  "approxequal", "2248",
  "approxequalorimage", "2252",
  "approximatelyequal", "2245",
  "araeaekorean", "318E",
  "araeakorean", "318D",
  "arc", "2312",
  "arighthalfring", "1E9A",
  "aring", "00E5",
  "aringacute", "01FB",
  "aringbelow", "1E01",
  "arrowboth", "2194",
  "arrowdashdown", "21E3",
  "arrowdashleft", "21E0",
  "arrowdashright", "21E2",
  "arrowdashup", "21E1",
  "arrowdblboth", "21D4",
  "arrowdbldown", "21D3",
  "arrowdblleft", "21D0",
  "arrowdblright", "21D2",
  "arrowdblup", "21D1",
  "arrowdown", "2193",
  "arrowdownleft", "2199",
  "arrowdownright", "2198",
  "arrowdownwhite", "21E9",
  "arrowheaddownmod", "02C5",
  "arrowheadleftmod", "02C2",
  "arrowheadrightmod", "02C3",
  "arrowheadupmod", "02C4",
  "arrowleft", "2190",
  "arrowleftdbl", "21D0",
  "arrowleftdblstroke", "21CD",
  "arrowleftoverright", "21C6",
  "arrowleftwhite", "21E6",
  "arrowright", "2192",
  "arrowrightdblstroke", "21CF",
  "arrowrightheavy", "279E",
  "arrowrightoverleft", "21C4",
  "arrowrightwhite", "21E8",
  "arrowtableft", "21E4",
  "arrowtabright", "21E5",
  "arrowup", "2191",
  "arrowupdn", "2195",
  "arrowupdnbse", "21A8",
  "arrowupdownbase", "21A8",
  "arrowupleft", "2196",
  "arrowupleftofdown", "21C5",
  "arrowupright", "2197",
  "arrowupwhite", "21E7",
  "asciicircum", "005E",
  "asciicircummonospace", "FF3E",
  "asciitilde", "007E",
  "asciitildemonospace", "FF5E",
  "ascript", "0251",
  "ascriptturned", "0252",
  "asmallhiragana", "3041",
  "asmallkatakana", "30A1",
  "asmallkatakanahalfwidth", "FF67",
  "asterisk", "002A",
  "asteriskaltonearabic", "066D",
  "asteriskarabic", "066D",
  "asteriskmath", "2217",
  "asteriskmonospace", "FF0A",
  "asterisksmall", "FE61",
  "asterism", "2042",
  "asymptoticallyequal", "2243",
  "at", "0040",
  "atilde", "00E3",
  "atmonospace", "FF20",
  "atsmall", "FE6B",
  "aturned", "0250",
  "aubengali", "0994",
  "aubopomofo", "3120",
  "audeva", "0914",
  "augujarati", "0A94",
  "augurmukhi", "0A14",
  "aulengthmarkbengali", "09D7",
  "aumatragurmukhi", "0A4C",
  "auvowelsignbengali", "09CC",
  "auvowelsigndeva", "094C",
  "auvowelsigngujarati", "0ACC",
  "avagrahadeva", "093D",
  "aybarmenian", "0561",
  "ayin", "05E2",
  "ayinaltonehebrew", "FB20",
  "ayinhebrew", "05E2",
  "b", "0062",
  "babengali", "09AC",
  "backslash", "005C",
  "backslashmonospace", "FF3C",
  "badeva", "092C",
  "bagujarati", "0AAC",
  "bagurmukhi", "0A2C",
  "bahiragana", "3070",
  "bahtthai", "0E3F",
  "bakatakana", "30D0",
  "bar", "007C",
  "barmonospace", "FF5C",
  "bbopomofo", "3105",
  "bcircle", "24D1",
  "bdotaccent", "1E03",
  "bdotbelow", "1E05",
  "beamedsixteenthnotes", "266C",
  "because", "2235",
  "becyrillic", "0431",
  "beharabic", "0628",
  "behfinalarabic", "FE90",
  "behinitialarabic", "FE91",
  "behiragana", "3079",
  "behmedialarabic", "FE92",
  "behmeeminitialarabic", "FC9F",
  "behmeemisolatedarabic", "FC08",
  "behnoonfinalarabic", "FC6D",
  "bekatakana", "30D9",
  "benarmenian", "0562",
  "bet", "05D1",
  "beta", "03B2",
  "betasymbolgreek", "03D0",
  "betdagesh", "FB31",
  "betdageshhebrew", "FB31",
  "bethebrew", "05D1",
  "betrafehebrew", "FB4C",
  "bhabengali", "09AD",
  "bhadeva", "092D",
  "bhagujarati", "0AAD",
  "bhagurmukhi", "0A2D",
  "bhook", "0253",
  "bihiragana", "3073",
  "bikatakana", "30D3",
  "bilabialclick", "0298",
  "bindigurmukhi", "0A02",
  "birusquare", "3331",
  "blackcircle", "25CF",
  "blackdiamond", "25C6",
  "blackdownpointingtriangle", "25BC",
  "blackleftpointingpointer", "25C4",
  "blackleftpointingtriangle", "25C0",
  "blacklenticularbracketleft", "3010",
  "blacklenticularbracketleftvertical", "FE3B",
  "blacklenticularbracketright", "3011",
  "blacklenticularbracketrightvertical", "FE3C",
  "blacklowerlefttriangle", "25E3",
  "blacklowerrighttriangle", "25E2",
  "blackrectangle", "25AC",
  "blackrightpointingpointer", "25BA",
  "blackrightpointingtriangle", "25B6",
  "blacksmallsquare", "25AA",
  "blacksmilingface", "263B",
  "blacksquare", "25A0",
  "blackstar", "2605",
  "blackupperlefttriangle", "25E4",
  "blackupperrighttriangle", "25E5",
  "blackuppointingsmalltriangle", "25B4",
  "blackuppointingtriangle", "25B2",
  "blank", "2423",
  "blinebelow", "1E07",
  "block", "2588",
  "bmonospace", "FF42",
  "bobaimaithai", "0E1A",
  "bohiragana", "307C",
  "bokatakana", "30DC",
  "bparen", "249D",
  "bqsquare", "33C3",
  "braceleft", "007B",
  "braceleftmonospace", "FF5B",
  "braceleftsmall", "FE5B",
  "braceleftvertical", "FE37",
  "braceright", "007D",
  "bracerightmonospace", "FF5D",
  "bracerightsmall", "FE5C",
  "bracerightvertical", "FE38",
  "bracketleft", "005B",
  "bracketleftmonospace", "FF3B",
  "bracketright", "005D",
  "bracketrightmonospace", "FF3D",
  "breve", "02D8",
  "brevebelowcmb", "032E",
  "brevecmb", "0306",
  "breveinvertedbelowcmb", "032F",
  "breveinvertedcmb", "0311",
  "breveinverteddoublecmb", "0361",
  "bridgebelowcmb", "032A",
  "bridgeinvertedbelowcmb", "033A",
  "brokenbar", "00A6",
  "bstroke", "0180",
  "btopbar", "0183",
  "buhiragana", "3076",
  "bukatakana", "30D6",
  "bullet", "2022",
  "bulletinverse", "25D8",
  "bulletoperator", "2219",
  "bullseye", "25CE",
  "c", "0063",
  "caarmenian", "056E",
  "cabengali", "099A",
  "cacute", "0107",
  "cadeva", "091A",
  "cagujarati", "0A9A",
  "cagurmukhi", "0A1A",
  "calsquare", "3388",
  "candrabindubengali", "0981",
  "candrabinducmb", "0310",
  "candrabindudeva", "0901",
  "candrabindugujarati", "0A81",
  "capslock", "21EA",
  "careof", "2105",
  "caron", "02C7",
  "caronbelowcmb", "032C",
  "caroncmb", "030C",
  "carriagereturn", "21B5",
  "cbopomofo", "3118",
  "ccaron", "010D",
  "ccedilla", "00E7",
  "ccedillaacute", "1E09",
  "ccircle", "24D2",
  "ccircumflex", "0109",
  "ccurl", "0255",
  "cdot", "010B",
  "cdotaccent", "010B",
  "cdsquare", "33C5",
  "cedilla", "00B8",
  "cedillacmb", "0327",
  "cent", "00A2",
  "centigrade", "2103",
  "centmonospace", "FFE0",
  "chaarmenian", "0579",
  "chabengali", "099B",
  "chadeva", "091B",
  "chagujarati", "0A9B",
  "chagurmukhi", "0A1B",
  "chbopomofo", "3114",
  "cheabkhasiancyrillic", "04BD",
  "checkmark", "2713",
  "checyrillic", "0447",
  "chedescenderabkhasiancyrillic", "04BF",
  "chedescendercyrillic", "04B7",
  "chedieresiscyrillic", "04F5",
  "cheharmenian", "0573",
  "chekhakassiancyrillic", "04CC",
  "cheverticalstrokecyrillic", "04B9",
  "chi", "03C7",
  "chieuchacirclekorean", "3277",
  "chieuchaparenkorean", "3217",
  "chieuchcirclekorean", "3269",
  "chieuchkorean", "314A",
  "chieuchparenkorean", "3209",
  "chochangthai", "0E0A",
  "chochanthai", "0E08",
  "chochingthai", "0E09",
  "chochoethai", "0E0C",
  "chook", "0188",
  "cieucacirclekorean", "3276",
  "cieucaparenkorean", "3216",
  "cieuccirclekorean", "3268",
  "cieuckorean", "3148",
  "cieucparenkorean", "3208",
  "cieucuparenkorean", "321C",
  "circle", "25CB",
  "circlemultiply", "2297",
  "circleot", "2299",
  "circleplus", "2295",
  "circlepostalmark", "3036",
  "circlewithlefthalfblack", "25D0",
  "circlewithrighthalfblack", "25D1",
  "circumflex", "02C6",
  "circumflexbelowcmb", "032D",
  "circumflexcmb", "0302",
  "clear", "2327",
  "clickalveolar", "01C2",
  "clickdental", "01C0",
  "clicklateral", "01C1",
  "clickretroflex", "01C3",
  "club", "2663",
  "clubsuitblack", "2663",
  "clubsuitwhite", "2667",
  "cmcubedsquare", "33A4",
  "cmonospace", "FF43",
  "cmsquaredsquare", "33A0",
  "coarmenian", "0581",
  "colon", "003A",
  "colonmonetary", "20A1",
  "colonmonospace", "FF1A",
  "colonsign", "20A1",
  "colonsmall", "FE55",
  "colontriangularhalfmod", "02D1",
  "colontriangularmod", "02D0",
  "comma", "002C",
  "commaabovecmb", "0313",
  "commaaboverightcmb", "0315",
  "commaarabic", "060C",
  "commaarmenian", "055D",
  "commamonospace", "FF0C",
  "commareversedabovecmb", "0314",
  "commareversedmod", "02BD",
  "commasmall", "FE50",
  "commaturnedabovecmb", "0312",
  "commaturnedmod", "02BB",
  "compass", "263C",
  "congruent", "2245",
  "contourintegral", "222E",
  "control", "2303",
  "controlACK", "0006",
  "controlBEL", "0007",
  "controlBS", "0008",
  "controlCAN", "0018",
  "controlCR", "000D",
  "controlDC1", "0011",
  "controlDC2", "0012",
  "controlDC3", "0013",
  "controlDC4", "0014",
  "controlDEL", "007F",
  "controlDLE", "0010",
  "controlEM", "0019",
  "controlENQ", "0005",
  "controlEOT", "0004",
  "controlESC", "001B",
  "controlETB", "0017",
  "controlETX", "0003",
  "controlFF", "000C",
  "controlFS", "001C",
  "controlGS", "001D",
  "controlHT", "0009",
  "controlLF", "000A",
  "controlNAK", "0015",
  "controlRS", "001E",
  "controlSI", "000F",
  "controlSO", "000E",
  "controlSOT", "0002",
  "controlSTX", "0001",
  "controlSUB", "001A",
  "controlSYN", "0016",
  "controlUS", "001F",
  "controlVT", "000B",
  "copyright", "00A9",
  "cornerbracketleft", "300C",
  "cornerbracketlefthalfwidth", "FF62",
  "cornerbracketleftvertical", "FE41",
  "cornerbracketright", "300D",
  "cornerbracketrighthalfwidth", "FF63",
  "cornerbracketrightvertical", "FE42",
  "corporationsquare", "337F",
  "cosquare", "33C7",
  "coverkgsquare", "33C6",
  "cparen", "249E",
  "cruzeiro", "20A2",
  "cstretched", "0297",
  "curlyand", "22CF",
  "curlyor", "22CE",
  "currency", "00A4",
  "d", "0064",
  "daarmenian", "0564",
  "dabengali", "09A6",
  "dadarabic", "0636",
  "dadeva", "0926",
  "dadfinalarabic", "FEBE",
  "dadinitialarabic", "FEBF",
  "dadmedialarabic", "FEC0",
  "dagesh", "05BC",
  "dageshhebrew", "05BC",
  "dagger", "2020",
  "daggerdbl", "2021",
  "dagujarati", "0AA6",
  "dagurmukhi", "0A26",
  "dahiragana", "3060",
  "dakatakana", "30C0",
  "dalarabic", "062F",
  "dalet", "05D3",
  "daletdagesh", "FB33",
  "daletdageshhebrew", "FB33",
  "dalethatafpatah", "05D3_05B2",
  "dalethatafpatahhebrew", "05D3_05B2",
  "dalethatafsegol", "05D3_05B1",
  "dalethatafsegolhebrew", "05D3_05B1",
  "dalethebrew", "05D3",
  "dalethiriq", "05D3_05B4",
  "dalethiriqhebrew", "05D3_05B4",
  "daletholam", "05D3_05B9",
  "daletholamhebrew", "05D3_05B9",
  "daletpatah", "05D3_05B7",
  "daletpatahhebrew", "05D3_05B7",
  "daletqamats", "05D3_05B8",
  "daletqamatshebrew", "05D3_05B8",
  "daletqubuts", "05D3_05BB",
  "daletqubutshebrew", "05D3_05BB",
  "daletsegol", "05D3_05B6",
  "daletsegolhebrew", "05D3_05B6",
  "daletsheva", "05D3_05B0",
  "daletshevahebrew", "05D3_05B0",
  "dalettsere", "05D3_05B5",
  "dalettserehebrew", "05D3_05B5",
  "dalfinalarabic", "FEAA",
  "dammaarabic", "064F",
  "dammalowarabic", "064F",
  "dammatanaltonearabic", "064C",
  "dammatanarabic", "064C",
  "danda", "0964",
  "dargahebrew", "05A7",
  "dargalefthebrew", "05A7",
  "dasiapneumatacyrilliccmb", "0485",
  "dblanglebracketleft", "300A",
  "dblanglebracketleftvertical", "FE3D",
  "dblanglebracketright", "300B",
  "dblanglebracketrightvertical", "FE3E",
  "dblarchinvertedbelowcmb", "032B",
  "dblarrowleft", "21D4",
  "dblarrowright", "21D2",
  "dbldanda", "0965",
  "dblgravecmb", "030F",
  "dblintegral", "222C",
  "dbllowline", "2017",
  "dbllowlinecmb", "0333",
  "dbloverlinecmb", "033F",
  "dblprimemod", "02BA",
  "dblverticalbar", "2016",
  "dblverticallineabovecmb", "030E",
  "dbopomofo", "3109",
  "dbsquare", "33C8",
  "dcaron", "010F",
  "dcedilla", "1E11",
  "dcircle", "24D3",
  "dcircumflexbelow", "1E13",
  "dcroat", "0111",
  "ddabengali", "09A1",
  "ddadeva", "0921",
  "ddagujarati", "0AA1",
  "ddagurmukhi", "0A21",
  "ddalarabic", "0688",
  "ddalfinalarabic", "FB89",
  "dddhadeva", "095C",
  "ddhabengali", "09A2",
  "ddhadeva", "0922",
  "ddhagujarati", "0AA2",
  "ddhagurmukhi", "0A22",
  "ddotaccent", "1E0B",
  "ddotbelow", "1E0D",
  "decimalseparatorarabic", "066B",
  "decimalseparatorpersian", "066B",
  "decyrillic", "0434",
  "degree", "00B0",
  "dehihebrew", "05AD",
  "dehiragana", "3067",
  "deicoptic", "03EF",
  "dekatakana", "30C7",
  "deleteleft", "232B",
  "deleteright", "2326",
  "delta", "03B4",
  "deltaturned", "018D",
  "denominatorminusonenumeratorbengali", "09F8",
  "dezh", "02A4",
  "dhabengali", "09A7",
  "dhadeva", "0927",
  "dhagujarati", "0AA7",
  "dhagurmukhi", "0A27",
  "dhook", "0257",
  "dialytikatonos", "0385",
  "dialytikatonoscmb", "0344",
  "diamond", "2666",
  "diamondsuitwhite", "2662",
  "dieresis", "00A8",
  "dieresisbelowcmb", "0324",
  "dieresiscmb", "0308",
  "dieresistonos", "0385",
  "dihiragana", "3062",
  "dikatakana", "30C2",
  "dittomark", "3003",
  "divide", "00F7",
  "divides", "2223",
  "divisionslash", "2215",
  "djecyrillic", "0452",
  "dkshade", "2593",
  "dlinebelow", "1E0F",
  "dlsquare", "3397",
  "dmacron", "0111",
  "dmonospace", "FF44",
  "dnblock", "2584",
  "dochadathai", "0E0E",
  "dodekthai", "0E14",
  "dohiragana", "3069",
  "dokatakana", "30C9",
  "dollar", "0024",
  "dollarmonospace", "FF04",
  "dollarsmall", "FE69",
  "dong", "20AB",
  "dorusquare", "3326",
  "dotaccent", "02D9",
  "dotaccentcmb", "0307",
  "dotbelowcmb", "0323",
  "dotbelowcomb", "0323",
  "dotkatakana", "30FB",
  "dotlessi", "0131",
  "dotlessjstrokehook", "0284",
  "dotmath", "22C5",
  "dottedcircle", "25CC",
  "doubleyodpatah", "FB1F",
  "doubleyodpatahhebrew", "FB1F",
  "downtackbelowcmb", "031E",
  "downtackmod", "02D5",
  "dparen", "249F",
  "dtail", "0256",
  "dtopbar", "018C",
  "duhiragana", "3065",
  "dukatakana", "30C5",
  "dz", "01F3",
  "dzaltone", "02A3",
  "dzcaron", "01C6",
  "dzcurl", "02A5",
  "dzeabkhasiancyrillic", "04E1",
  "dzecyrillic", "0455",
  "dzhecyrillic", "045F",
  "e", "0065",
  "eacute", "00E9",
  "earth", "2641",
  "ebengali", "098F",
  "ebopomofo", "311C",
  "ebreve", "0115",
  "ecandradeva", "090D",
  "ecandragujarati", "0A8D",
  "ecandravowelsigndeva", "0945",
  "ecandravowelsigngujarati", "0AC5",
  "ecaron", "011B",
  "ecedillabreve", "1E1D",
  "echarmenian", "0565",
  "echyiwnarmenian", "0587",
  "ecircle", "24D4",
  "ecircumflex", "00EA",
  "ecircumflexacute", "1EBF",
  "ecircumflexbelow", "1E19",
  "ecircumflexdotbelow", "1EC7",
  "ecircumflexgrave", "1EC1",
  "ecircumflexhookabove", "1EC3",
  "ecircumflextilde", "1EC5",
  "ecyrillic", "0454",
  "edblgrave", "0205",
  "edeva", "090F",
  "edieresis", "00EB",
  "edot", "0117",
  "edotaccent", "0117",
  "edotbelow", "1EB9",
  "eegurmukhi", "0A0F",
  "eematragurmukhi", "0A47",
  "efcyrillic", "0444",
  "egrave", "00E8",
  "egujarati", "0A8F",
  "eharmenian", "0567",
  "ehbopomofo", "311D",
  "ehiragana", "3048",
  "ehookabove", "1EBB",
  "eibopomofo", "311F",
  "eight", "0038",
  "eightarabic", "0668",
  "eightbengali", "09EE",
  "eightcircle", "2467",
  "eightcircleinversesansserif", "2791",
  "eightdeva", "096E",
  "eighteencircle", "2471",
  "eighteenparen", "2485",
  "eighteenperiod", "2499",
  "eightgujarati", "0AEE",
  "eightgurmukhi", "0A6E",
  "eighthackarabic", "0668",
  "eighthangzhou", "3028",
  "eighthnotebeamed", "266B",
  "eightideographicparen", "3227",
  "eightinferior", "2088",
  "eightmonospace", "FF18",
  "eightparen", "247B",
  "eightperiod", "248F",
  "eightpersian", "06F8",
  "eightroman", "2177",
  "eightsuperior", "2078",
  "eightthai", "0E58",
  "einvertedbreve", "0207",
  "eiotifiedcyrillic", "0465",
  "ekatakana", "30A8",
  "ekatakanahalfwidth", "FF74",
  "ekonkargurmukhi", "0A74",
  "ekorean", "3154",
  "elcyrillic", "043B",
  "element", "2208",
  "elevencircle", "246A",
  "elevenparen", "247E",
  "elevenperiod", "2492",
  "elevenroman", "217A",
  "ellipsis", "2026",
  "ellipsisvertical", "22EE",
  "emacron", "0113",
  "emacronacute", "1E17",
  "emacrongrave", "1E15",
  "emcyrillic", "043C",
  "emdash", "2014",
  "emdashvertical", "FE31",
  "emonospace", "FF45",
  "emphasismarkarmenian", "055B",
  "emptyset", "2205",
  "enbopomofo", "3123",
  "encyrillic", "043D",
  "endash", "2013",
  "endashvertical", "FE32",
  "endescendercyrillic", "04A3",
  "eng", "014B",
  "engbopomofo", "3125",
  "enghecyrillic", "04A5",
  "enhookcyrillic", "04C8",
  "enspace", "2002",
  "eogonek", "0119",
  "eokorean", "3153",
  "eopen", "025B",
  "eopenclosed", "029A",
  "eopenreversed", "025C",
  "eopenreversedclosed", "025E",
  "eopenreversedhook", "025D",
  "eparen", "24A0",
  "epsilon", "03B5",
  "epsilontonos", "03AD",
  "equal", "003D",
  "equalmonospace", "FF1D",
  "equalsmall", "FE66",
  "equalsuperior", "207C",
  "equivalence", "2261",
  "erbopomofo", "3126",
  "ercyrillic", "0440",
  "ereversed", "0258",
  "ereversedcyrillic", "044D",
  "escyrillic", "0441",
  "esdescendercyrillic", "04AB",
  "esh", "0283",
  "eshcurl", "0286",
  "eshortdeva", "090E",
  "eshortvowelsigndeva", "0946",
  "eshreversedloop", "01AA",
  "eshsquatreversed", "0285",
  "esmallhiragana", "3047",
  "esmallkatakana", "30A7",
  "esmallkatakanahalfwidth", "FF6A",
  "estimated", "212E",
  "eta", "03B7",
  "etarmenian", "0568",
  "etatonos", "03AE",
  "eth", "00F0",
  "etilde", "1EBD",
  "etildebelow", "1E1B",
  "etnahtafoukhhebrew", "0591",
  "etnahtafoukhlefthebrew", "0591",
  "etnahtahebrew", "0591",
  "etnahtalefthebrew", "0591",
  "eturned", "01DD",
  "eukorean", "3161",
  "euro", "20AC",
  "evowelsignbengali", "09C7",
  "evowelsigndeva", "0947",
  "evowelsigngujarati", "0AC7",
  "exclam", "0021",
  "exclamarmenian", "055C",
  "exclamdbl", "203C",
  "exclamdown", "00A1",
  "exclammonospace", "FF01",
  "existential", "2203",
  "ezh", "0292",
  "ezhcaron", "01EF",
  "ezhcurl", "0293",
  "ezhreversed", "01B9",
  "ezhtail", "01BA",
  "f", "0066",
  "fadeva", "095E",
  "fagurmukhi", "0A5E",
  "fahrenheit", "2109",
  "fathaarabic", "064E",
  "fathalowarabic", "064E",
  "fathatanarabic", "064B",
  "fbopomofo", "3108",
  "fcircle", "24D5",
  "fdotaccent", "1E1F",
  "feharabic", "0641",
  "feharmenian", "0586",
  "fehfinalarabic", "FED2",
  "fehinitialarabic", "FED3",
  "fehmedialarabic", "FED4",
  "feicoptic", "03E5",
  "female", "2640",
  "ff", "FB00",
  "ffi", "FB03",
  "ffl", "FB04",
  "fi", "FB01",
  "fifteencircle", "246E",
  "fifteenparen", "2482",
  "fifteenperiod", "2496",
  "figuredash", "2012",
  "filledbox", "25A0",
  "filledrect", "25AC",
  "finalkaf", "05DA",
  "finalkafdagesh", "FB3A",
  "finalkafdageshhebrew", "FB3A",
  "finalkafhebrew", "05DA",
  "finalkafqamats", "05DA_05B8",
  "finalkafqamatshebrew", "05DA_05B8",
  "finalkafsheva", "05DA_05B0",
  "finalkafshevahebrew", "05DA_05B0",
  "finalmem", "05DD",
  "finalmemhebrew", "05DD",
  "finalnun", "05DF",
  "finalnunhebrew", "05DF",
  "finalpe", "05E3",
  "finalpehebrew", "05E3",
  "finaltsadi", "05E5",
  "finaltsadihebrew", "05E5",
  "firsttonechinese", "02C9",
  "fisheye", "25C9",
  "fitacyrillic", "0473",
  "five", "0035",
  "fivearabic", "0665",
  "fivebengali", "09EB",
  "fivecircle", "2464",
  "fivecircleinversesansserif", "278E",
  "fivedeva", "096B",
  "fiveeighths", "215D",
  "fivegujarati", "0AEB",
  "fivegurmukhi", "0A6B",
  "fivehackarabic", "0665",
  "fivehangzhou", "3025",
  "fiveideographicparen", "3224",
  "fiveinferior", "2085",
  "fivemonospace", "FF15",
  "fiveparen", "2478",
  "fiveperiod", "248C",
  "fivepersian", "06F5",
  "fiveroman", "2174",
  "fivesuperior", "2075",
  "fivethai", "0E55",
  "fl", "FB02",
  "florin", "0192",
  "fmonospace", "FF46",
  "fmsquare", "3399",
  "fofanthai", "0E1F",
  "fofathai", "0E1D",
  "fongmanthai", "0E4F",
  "forall", "2200",
  "four", "0034",
  "fourarabic", "0664",
  "fourbengali", "09EA",
  "fourcircle", "2463",
  "fourcircleinversesansserif", "278D",
  "fourdeva", "096A",
  "fourgujarati", "0AEA",
  "fourgurmukhi", "0A6A",
  "fourhackarabic", "0664",
  "fourhangzhou", "3024",
  "fourideographicparen", "3223",
  "fourinferior", "2084",
  "fourmonospace", "FF14",
  "fournumeratorbengali", "09F7",
  "fourparen", "2477",
  "fourperiod", "248B",
  "fourpersian", "06F4",
  "fourroman", "2173",
  "foursuperior", "2074",
  "fourteencircle", "246D",
  "fourteenparen", "2481",
  "fourteenperiod", "2495",
  "fourthai", "0E54",
  "fourthtonechinese", "02CB",
  "fparen", "24A1",
  "fraction", "2044",
  "franc", "20A3",
  "g", "0067",
  "gabengali", "0997",
  "gacute", "01F5",
  "gadeva", "0917",
  "gafarabic", "06AF",
  "gaffinalarabic", "FB93",
  "gafinitialarabic", "FB94",
  "gafmedialarabic", "FB95",
  "gagujarati", "0A97",
  "gagurmukhi", "0A17",
  "gahiragana", "304C",
  "gakatakana", "30AC",
  "gamma", "03B3",
  "gammalatinsmall", "0263",
  "gammasuperior", "02E0",
  "gangiacoptic", "03EB",
  "gbopomofo", "310D",
  "gbreve", "011F",
  "gcaron", "01E7",
  "gcedilla", "0123",
  "gcircle", "24D6",
  "gcircumflex", "011D",
  "gcommaaccent", "0123",
  "gdot", "0121",
  "gdotaccent", "0121",
  "gecyrillic", "0433",
  "gehiragana", "3052",
  "gekatakana", "30B2",
  "geometricallyequal", "2251",
  "gereshaccenthebrew", "059C",
  "gereshhebrew", "05F3",
  "gereshmuqdamhebrew", "059D",
  "germandbls", "00DF",
  "gershayimaccenthebrew", "059E",
  "gershayimhebrew", "05F4",
  "getamark", "3013",
  "ghabengali", "0998",
  "ghadarmenian", "0572",
  "ghadeva", "0918",
  "ghagujarati", "0A98",
  "ghagurmukhi", "0A18",
  "ghainarabic", "063A",
  "ghainfinalarabic", "FECE",
  "ghaininitialarabic", "FECF",
  "ghainmedialarabic", "FED0",
  "ghemiddlehookcyrillic", "0495",
  "ghestrokecyrillic", "0493",
  "gheupturncyrillic", "0491",
  "ghhadeva", "095A",
  "ghhagurmukhi", "0A5A",
  "ghook", "0260",
  "ghzsquare", "3393",
  "gihiragana", "304E",
  "gikatakana", "30AE",
  "gimarmenian", "0563",
  "gimel", "05D2",
  "gimeldagesh", "FB32",
  "gimeldageshhebrew", "FB32",
  "gimelhebrew", "05D2",
  "gjecyrillic", "0453",
  "glottalinvertedstroke", "01BE",
  "glottalstop", "0294",
  "glottalstopinverted", "0296",
  "glottalstopmod", "02C0",
  "glottalstopreversed", "0295",
  "glottalstopreversedmod", "02C1",
  "glottalstopreversedsuperior", "02E4",
  "glottalstopstroke", "02A1",
  "glottalstopstrokereversed", "02A2",
  "gmacron", "1E21",
  "gmonospace", "FF47",
  "gohiragana", "3054",
  "gokatakana", "30B4",
  "gparen", "24A2",
  "gpasquare", "33AC",
  "gradient", "2207",
  "grave", "0060",
  "gravebelowcmb", "0316",
  "gravecmb", "0300",
  "gravecomb", "0300",
  "gravedeva", "0953",
  "gravelowmod", "02CE",
  "gravemonospace", "FF40",
  "gravetonecmb", "0340",
  "greater", "003E",
  "greaterequal", "2265",
  "greaterequalorless", "22DB",
  "greatermonospace", "FF1E",
  "greaterorequivalent", "2273",
  "greaterorless", "2277",
  "greateroverequal", "2267",
  "greatersmall", "FE65",
  "gscript", "0261",
  "gstroke", "01E5",
  "guhiragana", "3050",
  "guillemotleft", "00AB",
  "guillemotright", "00BB",
  "guilsinglleft", "2039",
  "guilsinglright", "203A",
  "gukatakana", "30B0",
  "guramusquare", "3318",
  "gysquare", "33C9",
  "h", "0068",
  "haabkhasiancyrillic", "04A9",
  "haaltonearabic", "06C1",
  "habengali", "09B9",
  "hadescendercyrillic", "04B3",
  "hadeva", "0939",
  "hagujarati", "0AB9",
  "hagurmukhi", "0A39",
  "haharabic", "062D",
  "hahfinalarabic", "FEA2",
  "hahinitialarabic", "FEA3",
  "hahiragana", "306F",
  "hahmedialarabic", "FEA4",
  "haitusquare", "332A",
  "hakatakana", "30CF",
  "hakatakanahalfwidth", "FF8A",
  "halantgurmukhi", "0A4D",
  "hamzaarabic", "0621",
  "hamzadammaarabic", "0621_064F",
  "hamzadammatanarabic", "0621_064C",
  "hamzafathaarabic", "0621_064E",
  "hamzafathatanarabic", "0621_064B",
  "hamzalowarabic", "0621",
  "hamzalowkasraarabic", "0621_0650",
  "hamzalowkasratanarabic", "0621_064D",
  "hamzasukunarabic", "0621_0652",
  "hangulfiller", "3164",
  "hardsigncyrillic", "044A",
  "harpoonleftbarbup", "21BC",
  "harpoonrightbarbup", "21C0",
  "hasquare", "33CA",
  "hatafpatah", "05B2",
  "hatafpatah16", "05B2",
  "hatafpatah23", "05B2",
  "hatafpatah2f", "05B2",
  "hatafpatahhebrew", "05B2",
  "hatafpatahnarrowhebrew", "05B2",
  "hatafpatahquarterhebrew", "05B2",
  "hatafpatahwidehebrew", "05B2",
  "hatafqamats", "05B3",
  "hatafqamats1b", "05B3",
  "hatafqamats28", "05B3",
  "hatafqamats34", "05B3",
  "hatafqamatshebrew", "05B3",
  "hatafqamatsnarrowhebrew", "05B3",
  "hatafqamatsquarterhebrew", "05B3",
  "hatafqamatswidehebrew", "05B3",
  "hatafsegol", "05B1",
  "hatafsegol17", "05B1",
  "hatafsegol24", "05B1",
  "hatafsegol30", "05B1",
  "hatafsegolhebrew", "05B1",
  "hatafsegolnarrowhebrew", "05B1",
  "hatafsegolquarterhebrew", "05B1",
  "hatafsegolwidehebrew", "05B1",
  "hbar", "0127",
  "hbopomofo", "310F",
  "hbrevebelow", "1E2B",
  "hcedilla", "1E29",
  "hcircle", "24D7",
  "hcircumflex", "0125",
  "hdieresis", "1E27",
  "hdotaccent", "1E23",
  "hdotbelow", "1E25",
  "he", "05D4",
  "heart", "2665",
  "heartsuitblack", "2665",
  "heartsuitwhite", "2661",
  "hedagesh", "FB34",
  "hedageshhebrew", "FB34",
  "hehaltonearabic", "06C1",
  "heharabic", "0647",
  "hehebrew", "05D4",
  "hehfinalaltonearabic", "FBA7",
  "hehfinalalttwoarabic", "FEEA",
  "hehfinalarabic", "FEEA",
  "hehhamzaabovefinalarabic", "FBA5",
  "hehhamzaaboveisolatedarabic", "FBA4",
  "hehinitialaltonearabic", "FBA8",
  "hehinitialarabic", "FEEB",
  "hehiragana", "3078",
  "hehmedialaltonearabic", "FBA9",
  "hehmedialarabic", "FEEC",
  "heiseierasquare", "337B",
  "hekatakana", "30D8",
  "hekatakanahalfwidth", "FF8D",
  "hekutaarusquare", "3336",
  "henghook", "0267",
  "herutusquare", "3339",
  "het", "05D7",
  "hethebrew", "05D7",
  "hhook", "0266",
  "hhooksuperior", "02B1",
  "hieuhacirclekorean", "327B",
  "hieuhaparenkorean", "321B",
  "hieuhcirclekorean", "326D",
  "hieuhkorean", "314E",
  "hieuhparenkorean", "320D",
  "hihiragana", "3072",
  "hikatakana", "30D2",
  "hikatakanahalfwidth", "FF8B",
  "hiriq", "05B4",
  "hiriq14", "05B4",
  "hiriq21", "05B4",
  "hiriq2d", "05B4",
  "hiriqhebrew", "05B4",
  "hiriqnarrowhebrew", "05B4",
  "hiriqquarterhebrew", "05B4",
  "hiriqwidehebrew", "05B4",
  "hlinebelow", "1E96",
  "hmonospace", "FF48",
  "hoarmenian", "0570",
  "hohipthai", "0E2B",
  "hohiragana", "307B",
  "hokatakana", "30DB",
  "hokatakanahalfwidth", "FF8E",
  "holam", "05B9",
  "holam19", "05B9",
  "holam26", "05B9",
  "holam32", "05B9",
  "holamhebrew", "05B9",
  "holamnarrowhebrew", "05B9",
  "holamquarterhebrew", "05B9",
  "holamwidehebrew", "05B9",
  "honokhukthai", "0E2E",
  "hookabovecomb", "0309",
  "hookcmb", "0309",
  "hookpalatalizedbelowcmb", "0321",
  "hookretroflexbelowcmb", "0322",
  "hoonsquare", "3342",
  "horicoptic", "03E9",
  "horizontalbar", "2015",
  "horncmb", "031B",
  "hotsprings", "2668",
  "house", "2302",
  "hparen", "24A3",
  "hsuperior", "02B0",
  "hturned", "0265",
  "huhiragana", "3075",
  "huiitosquare", "3333",
  "hukatakana", "30D5",
  "hukatakanahalfwidth", "FF8C",
  "hungarumlaut", "02DD",
  "hungarumlautcmb", "030B",
  "hv", "0195",
  "hyphen", "002D",
  "hyphenmonospace", "FF0D",
  "hyphensmall", "FE63",
  "hyphentwo", "2010",
  "i", "0069",
  "iacute", "00ED",
  "iacyrillic", "044F",
  "ibengali", "0987",
  "ibopomofo", "3127",
  "ibreve", "012D",
  "icaron", "01D0",
  "icircle", "24D8",
  "icircumflex", "00EE",
  "icyrillic", "0456",
  "idblgrave", "0209",
  "ideographearthcircle", "328F",
  "ideographfirecircle", "328B",
  "ideographicallianceparen", "323F",
  "ideographiccallparen", "323A",
  "ideographiccentrecircle", "32A5",
  "ideographicclose", "3006",
  "ideographiccomma", "3001",
  "ideographiccommaleft", "FF64",
  "ideographiccongratulationparen", "3237",
  "ideographiccorrectcircle", "32A3",
  "ideographicearthparen", "322F",
  "ideographicenterpriseparen", "323D",
  "ideographicexcellentcircle", "329D",
  "ideographicfestivalparen", "3240",
  "ideographicfinancialcircle", "3296",
  "ideographicfinancialparen", "3236",
  "ideographicfireparen", "322B",
  "ideographichaveparen", "3232",
  "ideographichighcircle", "32A4",
  "ideographiciterationmark", "3005",
  "ideographiclaborcircle", "3298",
  "ideographiclaborparen", "3238",
  "ideographicleftcircle", "32A7",
  "ideographiclowcircle", "32A6",
  "ideographicmedicinecircle", "32A9",
  "ideographicmetalparen", "322E",
  "ideographicmoonparen", "322A",
  "ideographicnameparen", "3234",
  "ideographicperiod", "3002",
  "ideographicprintcircle", "329E",
  "ideographicreachparen", "3243",
  "ideographicrepresentparen", "3239",
  "ideographicresourceparen", "323E",
  "ideographicrightcircle", "32A8",
  "ideographicsecretcircle", "3299",
  "ideographicselfparen", "3242",
  "ideographicsocietyparen", "3233",
  "ideographicspace", "3000",
  "ideographicspecialparen", "3235",
  "ideographicstockparen", "3231",
  "ideographicstudyparen", "323B",
  "ideographicsunparen", "3230",
  "ideographicsuperviseparen", "323C",
  "ideographicwaterparen", "322C",
  "ideographicwoodparen", "322D",
  "ideographiczero", "3007",
  "ideographmetalcircle", "328E",
  "ideographmooncircle", "328A",
  "ideographnamecircle", "3294",
  "ideographsuncircle", "3290",
  "ideographwatercircle", "328C",
  "ideographwoodcircle", "328D",
  "ideva", "0907",
  "idieresis", "00EF",
  "idieresisacute", "1E2F",
  "idieresiscyrillic", "04E5",
  "idotbelow", "1ECB",
  "iebrevecyrillic", "04D7",
  "iecyrillic", "0435",
  "ieungacirclekorean", "3275",
  "ieungaparenkorean", "3215",
  "ieungcirclekorean", "3267",
  "ieungkorean", "3147",
  "ieungparenkorean", "3207",
  "igrave", "00EC",
  "igujarati", "0A87",
  "igurmukhi", "0A07",
  "ihiragana", "3044",
  "ihookabove", "1EC9",
  "iibengali", "0988",
  "iicyrillic", "0438",
  "iideva", "0908",
  "iigujarati", "0A88",
  "iigurmukhi", "0A08",
  "iimatragurmukhi", "0A40",
  "iinvertedbreve", "020B",
  "iishortcyrillic", "0439",
  "iivowelsignbengali", "09C0",
  "iivowelsigndeva", "0940",
  "iivowelsigngujarati", "0AC0",
  "ij", "0133",
  "ikatakana", "30A4",
  "ikatakanahalfwidth", "FF72",
  "ikorean", "3163",
  "ilde", "02DC",
  "iluyhebrew", "05AC",
  "imacron", "012B",
  "imacroncyrillic", "04E3",
  "imageorapproximatelyequal", "2253",
  "imatragurmukhi", "0A3F",
  "imonospace", "FF49",
  "increment", "2206",
  "infinity", "221E",
  "iniarmenian", "056B",
  "integral", "222B",
  "integralbottom", "2321",
  "integralbt", "2321",
  "integraltop", "2320",
  "integraltp", "2320",
  "intersection", "2229",
  "intisquare", "3305",
  "invbullet", "25D8",
  "invcircle", "25D9",
  "invsmileface", "263B",
  "iocyrillic", "0451",
  "iogonek", "012F",
  "iota", "03B9",
  "iotadieresis", "03CA",
  "iotadieresistonos", "0390",
  "iotalatin", "0269",
  "iotatonos", "03AF",
  "iparen", "24A4",
  "irigurmukhi", "0A72",
  "ismallhiragana", "3043",
  "ismallkatakana", "30A3",
  "ismallkatakanahalfwidth", "FF68",
  "issharbengali", "09FA",
  "istroke", "0268",
  "iterationhiragana", "309D",
  "iterationkatakana", "30FD",
  "itilde", "0129",
  "itildebelow", "1E2D",
  "iubopomofo", "3129",
  "iucyrillic", "044E",
  "ivowelsignbengali", "09BF",
  "ivowelsigndeva", "093F",
  "ivowelsigngujarati", "0ABF",
  "izhitsacyrillic", "0475",
  "izhitsadblgravecyrillic", "0477",
  "j", "006A",
  "jaarmenian", "0571",
  "jabengali", "099C",
  "jadeva", "091C",
  "jagujarati", "0A9C",
  "jagurmukhi", "0A1C",
  "jbopomofo", "3110",
  "jcaron", "01F0",
  "jcircle", "24D9",
  "jcircumflex", "0135",
  "jcrossedtail", "029D",
  "jdotlessstroke", "025F",
  "jecyrillic", "0458",
  "jeemarabic", "062C",
  "jeemfinalarabic", "FE9E",
  "jeeminitialarabic", "FE9F",
  "jeemmedialarabic", "FEA0",
  "jeharabic", "0698",
  "jehfinalarabic", "FB8B",
  "jhabengali", "099D",
  "jhadeva", "091D",
  "jhagujarati", "0A9D",
  "jhagurmukhi", "0A1D",
  "jheharmenian", "057B",
  "jis", "3004",
  "jmonospace", "FF4A",
  "jparen", "24A5",
  "jsuperior", "02B2",
  "k", "006B",
  "kabashkircyrillic", "04A1",
  "kabengali", "0995",
  "kacute", "1E31",
  "kacyrillic", "043A",
  "kadescendercyrillic", "049B",
  "kadeva", "0915",
  "kaf", "05DB",
  "kafarabic", "0643",
  "kafdagesh", "FB3B",
  "kafdageshhebrew", "FB3B",
  "kaffinalarabic", "FEDA",
  "kafhebrew", "05DB",
  "kafinitialarabic", "FEDB",
  "kafmedialarabic", "FEDC",
  "kafrafehebrew", "FB4D",
  "kagujarati", "0A95",
  "kagurmukhi", "0A15",
  "kahiragana", "304B",
  "kahookcyrillic", "04C4",
  "kakatakana", "30AB",
  "kakatakanahalfwidth", "FF76",
  "kappa", "03BA",
  "kappasymbolgreek", "03F0",
  "kapyeounmieumkorean", "3171",
  "kapyeounphieuphkorean", "3184",
  "kapyeounpieupkorean", "3178",
  "kapyeounssangpieupkorean", "3179",
  "karoriisquare", "330D",
  "kashidaautoarabic", "0640",
  "kashidaautonosidebearingarabic", "0640",
  "kasmallkatakana", "30F5",
  "kasquare", "3384",
  "kasraarabic", "0650",
  "kasratanarabic", "064D",
  "kastrokecyrillic", "049F",
  "katahiraprolongmarkhalfwidth", "FF70",
  "kaverticalstrokecyrillic", "049D",
  "kbopomofo", "310E",
  "kcalsquare", "3389",
  "kcaron", "01E9",
  "kcedilla", "0137",
  "kcircle", "24DA",
  "kcommaaccent", "0137",
  "kdotbelow", "1E33",
  "keharmenian", "0584",
  "kehiragana", "3051",
  "kekatakana", "30B1",
  "kekatakanahalfwidth", "FF79",
  "kenarmenian", "056F",
  "kesmallkatakana", "30F6",
  "kgreenlandic", "0138",
  "khabengali", "0996",
  "khacyrillic", "0445",
  "khadeva", "0916",
  "khagujarati", "0A96",
  "khagurmukhi", "0A16",
  "khaharabic", "062E",
  "khahfinalarabic", "FEA6",
  "khahinitialarabic", "FEA7",
  "khahmedialarabic", "FEA8",
  "kheicoptic", "03E7",
  "khhadeva", "0959",
  "khhagurmukhi", "0A59",
  "khieukhacirclekorean", "3278",
  "khieukhaparenkorean", "3218",
  "khieukhcirclekorean", "326A",
  "khieukhkorean", "314B",
  "khieukhparenkorean", "320A",
  "khokhaithai", "0E02",
  "khokhonthai", "0E05",
  "khokhuatthai", "0E03",
  "khokhwaithai", "0E04",
  "khomutthai", "0E5B",
  "khook", "0199",
  "khorakhangthai", "0E06",
  "khzsquare", "3391",
  "kihiragana", "304D",
  "kikatakana", "30AD",
  "kikatakanahalfwidth", "FF77",
  "kiroguramusquare", "3315",
  "kiromeetorusquare", "3316",
  "kirosquare", "3314",
  "kiyeokacirclekorean", "326E",
  "kiyeokaparenkorean", "320E",
  "kiyeokcirclekorean", "3260",
  "kiyeokkorean", "3131",
  "kiyeokparenkorean", "3200",
  "kiyeoksioskorean", "3133",
  "kjecyrillic", "045C",
  "klinebelow", "1E35",
  "klsquare", "3398",
  "kmcubedsquare", "33A6",
  "kmonospace", "FF4B",
  "kmsquaredsquare", "33A2",
  "kohiragana", "3053",
  "kohmsquare", "33C0",
  "kokaithai", "0E01",
  "kokatakana", "30B3",
  "kokatakanahalfwidth", "FF7A",
  "kooposquare", "331E",
  "koppacyrillic", "0481",
  "koreanstandardsymbol", "327F",
  "koroniscmb", "0343",
  "kparen", "24A6",
  "kpasquare", "33AA",
  "ksicyrillic", "046F",
  "ktsquare", "33CF",
  "kturned", "029E",
  "kuhiragana", "304F",
  "kukatakana", "30AF",
  "kukatakanahalfwidth", "FF78",
  "kvsquare", "33B8",
  "kwsquare", "33BE",
  "l", "006C",
  "labengali", "09B2",
  "lacute", "013A",
  "ladeva", "0932",
  "lagujarati", "0AB2",
  "lagurmukhi", "0A32",
  "lakkhangyaothai", "0E45",
  "lamaleffinalarabic", "FEFC",
  "lamalefhamzaabovefinalarabic", "FEF8",
  "lamalefhamzaaboveisolatedarabic", "FEF7",
  "lamalefhamzabelowfinalarabic", "FEFA",
  "lamalefhamzabelowisolatedarabic", "FEF9",
  "lamalefisolatedarabic", "FEFB",
  "lamalefmaddaabovefinalarabic", "FEF6",
  "lamalefmaddaaboveisolatedarabic", "FEF5",
  "lamarabic", "0644",
  "lambda", "03BB",
  "lambdastroke", "019B",
  "lamed", "05DC",
  "lameddagesh", "FB3C",
  "lameddageshhebrew", "FB3C",
  "lamedhebrew", "05DC",
  "lamedholam", "05DC_05B9",
  "lamedholamdagesh", "05DC_05B9_05BC",
  "lamedholamdageshhebrew", "05DC_05B9_05BC",
  "lamedholamhebrew", "05DC_05B9",
  "lamfinalarabic", "FEDE",
  "lamhahinitialarabic", "FCCA",
  "laminitialarabic", "FEDF",
  "lamjeeminitialarabic", "FCC9",
  "lamkhahinitialarabic", "FCCB",
  "lamlamhehisolatedarabic", "FDF2",
  "lammedialarabic", "FEE0",
  "lammeemhahinitialarabic", "FD88",
  "lammeeminitialarabic", "FCCC",
  "lammeemjeeminitialarabic", "FEDF_FEE4_FEA0",
  "lammeemkhahinitialarabic", "FEDF_FEE4_FEA8",
  "largecircle", "25EF",
  "lbar", "019A",
  "lbelt", "026C",
  "lbopomofo", "310C",
  "lcaron", "013E",
  "lcedilla", "013C",
  "lcircle", "24DB",
  "lcircumflexbelow", "1E3D",
  "lcommaaccent", "013C",
  "ldot", "0140",
  "ldotaccent", "0140",
  "ldotbelow", "1E37",
  "ldotbelowmacron", "1E39",
  "leftangleabovecmb", "031A",
  "lefttackbelowcmb", "0318",
  "less", "003C",
  "lessequal", "2264",
  "lessequalorgreater", "22DA",
  "lessmonospace", "FF1C",
  "lessorequivalent", "2272",
  "lessorgreater", "2276",
  "lessoverequal", "2266",
  "lesssmall", "FE64",
  "lezh", "026E",
  "lfblock", "258C",
  "lhookretroflex", "026D",
  "lira", "20A4",
  "liwnarmenian", "056C",
  "lj", "01C9",
  "ljecyrillic", "0459",
  "lladeva", "0933",
  "llagujarati", "0AB3",
  "llinebelow", "1E3B",
  "llladeva", "0934",
  "llvocalicbengali", "09E1",
  "llvocalicdeva", "0961",
  "llvocalicvowelsignbengali", "09E3",
  "llvocalicvowelsigndeva", "0963",
  "lmiddletilde", "026B",
  "lmonospace", "FF4C",
  "lmsquare", "33D0",
  "lochulathai", "0E2C",
  "logicaland", "2227",
  "logicalnot", "00AC",
  "logicalnotreversed", "2310",
  "logicalor", "2228",
  "lolingthai", "0E25",
  "longs", "017F",
  "lowlinecenterline", "FE4E",
  "lowlinecmb", "0332",
  "lowlinedashed", "FE4D",
  "lozenge", "25CA",
  "lparen", "24A7",
  "lslash", "0142",
  "lsquare", "2113",
  "ltshade", "2591",
  "luthai", "0E26",
  "lvocalicbengali", "098C",
  "lvocalicdeva", "090C",
  "lvocalicvowelsignbengali", "09E2",
  "lvocalicvowelsigndeva", "0962",
  "lxsquare", "33D3",
  "m", "006D",
  "mabengali", "09AE",
  "macron", "00AF",
  "macronbelowcmb", "0331",
  "macroncmb", "0304",
  "macronlowmod", "02CD",
  "macronmonospace", "FFE3",
  "macute", "1E3F",
  "madeva", "092E",
  "magujarati", "0AAE",
  "magurmukhi", "0A2E",
  "mahapakhhebrew", "05A4",
  "mahapakhlefthebrew", "05A4",
  "mahiragana", "307E",
  "maichattawathai", "0E4B",
  "maiekthai", "0E48",
  "maihanakatthai", "0E31",
  "maitaikhuthai", "0E47",
  "maithothai", "0E49",
  "maitrithai", "0E4A",
  "maiyamokthai", "0E46",
  "makatakana", "30DE",
  "makatakanahalfwidth", "FF8F",
  "male", "2642",
  "mansyonsquare", "3347",
  "maqafhebrew", "05BE",
  "mars", "2642",
  "masoracirclehebrew", "05AF",
  "masquare", "3383",
  "mbopomofo", "3107",
  "mbsquare", "33D4",
  "mcircle", "24DC",
  "mcubedsquare", "33A5",
  "mdotaccent", "1E41",
  "mdotbelow", "1E43",
  "meemarabic", "0645",
  "meemfinalarabic", "FEE2",
  "meeminitialarabic", "FEE3",
  "meemmedialarabic", "FEE4",
  "meemmeeminitialarabic", "FCD1",
  "meemmeemisolatedarabic", "FC48",
  "meetorusquare", "334D",
  "mehiragana", "3081",
  "meizierasquare", "337E",
  "mekatakana", "30E1",
  "mekatakanahalfwidth", "FF92",
  "mem", "05DE",
  "memdagesh", "FB3E",
  "memdageshhebrew", "FB3E",
  "memhebrew", "05DE",
  "menarmenian", "0574",
  "merkhahebrew", "05A5",
  "merkhakefulahebrew", "05A6",
  "merkhakefulalefthebrew", "05A6",
  "merkhalefthebrew", "05A5",
  "mhook", "0271",
  "mhzsquare", "3392",
  "middledotkatakanahalfwidth", "FF65",
  "middot", "00B7",
  "mieumacirclekorean", "3272",
  "mieumaparenkorean", "3212",
  "mieumcirclekorean", "3264",
  "mieumkorean", "3141",
  "mieumpansioskorean", "3170",
  "mieumparenkorean", "3204",
  "mieumpieupkorean", "316E",
  "mieumsioskorean", "316F",
  "mihiragana", "307F",
  "mikatakana", "30DF",
  "mikatakanahalfwidth", "FF90",
  "minus", "2212",
  "minusbelowcmb", "0320",
  "minuscircle", "2296",
  "minusmod", "02D7",
  "minusplus", "2213",
  "minute", "2032",
  "miribaarusquare", "334A",
  "mirisquare", "3349",
  "mlonglegturned", "0270",
  "mlsquare", "3396",
  "mmcubedsquare", "33A3",
  "mmonospace", "FF4D",
  "mmsquaredsquare", "339F",
  "mohiragana", "3082",
  "mohmsquare", "33C1",
  "mokatakana", "30E2",
  "mokatakanahalfwidth", "FF93",
  "molsquare", "33D6",
  "momathai", "0E21",
  "moverssquare", "33A7",
  "moverssquaredsquare", "33A8",
  "mparen", "24A8",
  "mpasquare", "33AB",
  "mssquare", "33B3",
  "mturned", "026F",
  "mu", "00B5",
  "mu1", "00B5",
  "muasquare", "3382",
  "muchgreater", "226B",
  "muchless", "226A",
  "mufsquare", "338C",
  "mugreek", "03BC",
  "mugsquare", "338D",
  "muhiragana", "3080",
  "mukatakana", "30E0",
  "mukatakanahalfwidth", "FF91",
  "mulsquare", "3395",
  "multiply", "00D7",
  "mumsquare", "339B",
  "munahhebrew", "05A3",
  "munahlefthebrew", "05A3",
  "musicalnote", "266A",
  "musicalnotedbl", "266B",
  "musicflatsign", "266D",
  "musicsharpsign", "266F",
  "mussquare", "33B2",
  "muvsquare", "33B6",
  "muwsquare", "33BC",
  "mvmegasquare", "33B9",
  "mvsquare", "33B7",
  "mwmegasquare", "33BF",
  "mwsquare", "33BD",
  "n", "006E",
  "nabengali", "09A8",
  "nabla", "2207",
  "nacute", "0144",
  "nadeva", "0928",
  "nagujarati", "0AA8",
  "nagurmukhi", "0A28",
  "nahiragana", "306A",
  "nakatakana", "30CA",
  "nakatakanahalfwidth", "FF85",
  "napostrophe", "0149",
  "nasquare", "3381",
  "nbopomofo", "310B",
  "nbspace", "00A0",
  "ncaron", "0148",
  "ncedilla", "0146",
  "ncircle", "24DD",
  "ncircumflexbelow", "1E4B",
  "ncommaaccent", "0146",
  "ndotaccent", "1E45",
  "ndotbelow", "1E47",
  "nehiragana", "306D",
  "nekatakana", "30CD",
  "nekatakanahalfwidth", "FF88",
  "newsheqelsign", "20AA",
  "nfsquare", "338B",
  "ngabengali", "0999",
  "ngadeva", "0919",
  "ngagujarati", "0A99",
  "ngagurmukhi", "0A19",
  "ngonguthai", "0E07",
  "nhiragana", "3093",
  "nhookleft", "0272",
  "nhookretroflex", "0273",
  "nieunacirclekorean", "326F",
  "nieunaparenkorean", "320F",
  "nieuncieuckorean", "3135",
  "nieuncirclekorean", "3261",
  "nieunhieuhkorean", "3136",
  "nieunkorean", "3134",
  "nieunpansioskorean", "3168",
  "nieunparenkorean", "3201",
  "nieunsioskorean", "3167",
  "nieuntikeutkorean", "3166",
  "nihiragana", "306B",
  "nikatakana", "30CB",
  "nikatakanahalfwidth", "FF86",
  "nikhahitthai", "0E4D",
  "nine", "0039",
  "ninearabic", "0669",
  "ninebengali", "09EF",
  "ninecircle", "2468",
  "ninecircleinversesansserif", "2792",
  "ninedeva", "096F",
  "ninegujarati", "0AEF",
  "ninegurmukhi", "0A6F",
  "ninehackarabic", "0669",
  "ninehangzhou", "3029",
  "nineideographicparen", "3228",
  "nineinferior", "2089",
  "ninemonospace", "FF19",
  "nineparen", "247C",
  "nineperiod", "2490",
  "ninepersian", "06F9",
  "nineroman", "2178",
  "ninesuperior", "2079",
  "nineteencircle", "2472",
  "nineteenparen", "2486",
  "nineteenperiod", "249A",
  "ninethai", "0E59",
  "nj", "01CC",
  "njecyrillic", "045A",
  "nkatakana", "30F3",
  "nkatakanahalfwidth", "FF9D",
  "nlegrightlong", "019E",
  "nlinebelow", "1E49",
  "nmonospace", "FF4E",
  "nmsquare", "339A",
  "nnabengali", "09A3",
  "nnadeva", "0923",
  "nnagujarati", "0AA3",
  "nnagurmukhi", "0A23",
  "nnnadeva", "0929",
  "nohiragana", "306E",
  "nokatakana", "30CE",
  "nokatakanahalfwidth", "FF89",
  "nonbreakingspace", "00A0",
  "nonenthai", "0E13",
  "nonuthai", "0E19",
  "noonarabic", "0646",
  "noonfinalarabic", "FEE6",
  "noonghunnaarabic", "06BA",
  "noonghunnafinalarabic", "FB9F",
  "noonhehinitialarabic", "FEE7_FEEC",
  "nooninitialarabic", "FEE7",
  "noonjeeminitialarabic", "FCD2",
  "noonjeemisolatedarabic", "FC4B",
  "noonmedialarabic", "FEE8",
  "noonmeeminitialarabic", "FCD5",
  "noonmeemisolatedarabic", "FC4E",
  "noonnoonfinalarabic", "FC8D",
  "notcontains", "220C",
  "notelement", "2209",
  "notelementof", "2209",
  "notequal", "2260",
  "notgreater", "226F",
  "notgreaternorequal", "2271",
  "notgreaternorless", "2279",
  "notidentical", "2262",
  "notless", "226E",
  "notlessnorequal", "2270",
  "notparallel", "2226",
  "notprecedes", "2280",
  "notsubset", "2284",
  "notsucceeds", "2281",
  "notsuperset", "2285",
  "nowarmenian", "0576",
  "nparen", "24A9",
  "nssquare", "33B1",
  "nsuperior", "207F",
  "ntilde", "00F1",
  "nu", "03BD",
  "nuhiragana", "306C",
  "nukatakana", "30CC",
  "nukatakanahalfwidth", "FF87",
  "nuktabengali", "09BC",
  "nuktadeva", "093C",
  "nuktagujarati", "0ABC",
  "nuktagurmukhi", "0A3C",
  "numbersign", "0023",
  "numbersignmonospace", "FF03",
  "numbersignsmall", "FE5F",
  "numeralsigngreek", "0374",
  "numeralsignlowergreek", "0375",
  "numero", "2116",
  "nun", "05E0",
  "nundagesh", "FB40",
  "nundageshhebrew", "FB40",
  "nunhebrew", "05E0",
  "nvsquare", "33B5",
  "nwsquare", "33BB",
  "nyabengali", "099E",
  "nyadeva", "091E",
  "nyagujarati", "0A9E",
  "nyagurmukhi", "0A1E",
  "o", "006F",
  "oacute", "00F3",
  "oangthai", "0E2D",
  "obarred", "0275",
  "obarredcyrillic", "04E9",
  "obarreddieresiscyrillic", "04EB",
  "obengali", "0993",
  "obopomofo", "311B",
  "obreve", "014F",
  "ocandradeva", "0911",
  "ocandragujarati", "0A91",
  "ocandravowelsigndeva", "0949",
  "ocandravowelsigngujarati", "0AC9",
  "ocaron", "01D2",
  "ocircle", "24DE",
  "ocircumflex", "00F4",
  "ocircumflexacute", "1ED1",
  "ocircumflexdotbelow", "1ED9",
  "ocircumflexgrave", "1ED3",
  "ocircumflexhookabove", "1ED5",
  "ocircumflextilde", "1ED7",
  "ocyrillic", "043E",
  "odblacute", "0151",
  "odblgrave", "020D",
  "odeva", "0913",
  "odieresis", "00F6",
  "odieresiscyrillic", "04E7",
  "odotbelow", "1ECD",
  "oe", "0153",
  "oekorean", "315A",
  "ogonek", "02DB",
  "ogonekcmb", "0328",
  "ograve", "00F2",
  "ogujarati", "0A93",
  "oharmenian", "0585",
  "ohiragana", "304A",
  "ohookabove", "1ECF",
  "ohorn", "01A1",
  "ohornacute", "1EDB",
  "ohorndotbelow", "1EE3",
  "ohorngrave", "1EDD",
  "ohornhookabove", "1EDF",
  "ohorntilde", "1EE1",
  "ohungarumlaut", "0151",
  "oi", "01A3",
  "oinvertedbreve", "020F",
  "okatakana", "30AA",
  "okatakanahalfwidth", "FF75",
  "okorean", "3157",
  "olehebrew", "05AB",
  "omacron", "014D",
  "omacronacute", "1E53",
  "omacrongrave", "1E51",
  "omdeva", "0950",
  "omega", "03C9",
  "omega1", "03D6",
  "omegacyrillic", "0461",
  "omegalatinclosed", "0277",
  "omegaroundcyrillic", "047B",
  "omegatitlocyrillic", "047D",
  "omegatonos", "03CE",
  "omgujarati", "0AD0",
  "omicron", "03BF",
  "omicrontonos", "03CC",
  "omonospace", "FF4F",
  "one", "0031",
  "onearabic", "0661",
  "onebengali", "09E7",
  "onecircle", "2460",
  "onecircleinversesansserif", "278A",
  "onedeva", "0967",
  "onedotenleader", "2024",
  "oneeighth", "215B",
  "onegujarati", "0AE7",
  "onegurmukhi", "0A67",
  "onehackarabic", "0661",
  "onehalf", "00BD",
  "onehangzhou", "3021",
  "oneideographicparen", "3220",
  "oneinferior", "2081",
  "onemonospace", "FF11",
  "onenumeratorbengali", "09F4",
  "oneparen", "2474",
  "oneperiod", "2488",
  "onepersian", "06F1",
  "onequarter", "00BC",
  "oneroman", "2170",
  "onesuperior", "00B9",
  "onethai", "0E51",
  "onethird", "2153",
  "oogonek", "01EB",
  "oogonekmacron", "01ED",
  "oogurmukhi", "0A13",
  "oomatragurmukhi", "0A4B",
  "oopen", "0254",
  "oparen", "24AA",
  "openbullet", "25E6",
  "option", "2325",
  "ordfeminine", "00AA",
  "ordmasculine", "00BA",
  "orthogonal", "221F",
  "oshortdeva", "0912",
  "oshortvowelsigndeva", "094A",
  "oslash", "00F8",
  "oslashacute", "01FF",
  "osmallhiragana", "3049",
  "osmallkatakana", "30A9",
  "osmallkatakanahalfwidth", "FF6B",
  "ostrokeacute", "01FF",
  "otcyrillic", "047F",
  "otilde", "00F5",
  "otildeacute", "1E4D",
  "otildedieresis", "1E4F",
  "oubopomofo", "3121",
  "overline", "203E",
  "overlinecenterline", "FE4A",
  "overlinecmb", "0305",
  "overlinedashed", "FE49",
  "overlinedblwavy", "FE4C",
  "overlinewavy", "FE4B",
  "overscore", "00AF",
  "ovowelsignbengali", "09CB",
  "ovowelsigndeva", "094B",
  "ovowelsigngujarati", "0ACB",
  "p", "0070",
  "paampssquare", "3380",
  "paasentosquare", "332B",
  "pabengali", "09AA",
  "pacute", "1E55",
  "padeva", "092A",
  "pagedown", "21DF",
  "pageup", "21DE",
  "pagujarati", "0AAA",
  "pagurmukhi", "0A2A",
  "pahiragana", "3071",
  "paiyannoithai", "0E2F",
  "pakatakana", "30D1",
  "palatalizationcyrilliccmb", "0484",
  "palochkacyrillic", "04C0",
  "pansioskorean", "317F",
  "paragraph", "00B6",
  "parallel", "2225",
  "parenleft", "0028",
  "parenleftaltonearabic", "FD3E",
  "parenleftinferior", "208D",
  "parenleftmonospace", "FF08",
  "parenleftsmall", "FE59",
  "parenleftsuperior", "207D",
  "parenleftvertical", "FE35",
  "parenright", "0029",
  "parenrightaltonearabic", "FD3F",
  "parenrightinferior", "208E",
  "parenrightmonospace", "FF09",
  "parenrightsmall", "FE5A",
  "parenrightsuperior", "207E",
  "parenrightvertical", "FE36",
  "partialdiff", "2202",
  "paseqhebrew", "05C0",
  "pashtahebrew", "0599",
  "pasquare", "33A9",
  "patah", "05B7",
  "patah11", "05B7",
  "patah1d", "05B7",
  "patah2a", "05B7",
  "patahhebrew", "05B7",
  "patahnarrowhebrew", "05B7",
  "patahquarterhebrew", "05B7",
  "patahwidehebrew", "05B7",
  "pazerhebrew", "05A1",
  "pbopomofo", "3106",
  "pcircle", "24DF",
  "pdotaccent", "1E57",
  "pe", "05E4",
  "pecyrillic", "043F",
  "pedagesh", "FB44",
  "pedageshhebrew", "FB44",
  "peezisquare", "333B",
  "pefinaldageshhebrew", "FB43",
  "peharabic", "067E",
  "peharmenian", "057A",
  "pehebrew", "05E4",
  "pehfinalarabic", "FB57",
  "pehinitialarabic", "FB58",
  "pehiragana", "307A",
  "pehmedialarabic", "FB59",
  "pekatakana", "30DA",
  "pemiddlehookcyrillic", "04A7",
  "perafehebrew", "FB4E",
  "percent", "0025",
  "percentarabic", "066A",
  "percentmonospace", "FF05",
  "percentsmall", "FE6A",
  "period", "002E",
  "periodarmenian", "0589",
  "periodcentered", "00B7",
  "periodhalfwidth", "FF61",
  "periodmonospace", "FF0E",
  "periodsmall", "FE52",
  "perispomenigreekcmb", "0342",
  "perpendicular", "22A5",
  "perthousand", "2030",
  "peseta", "20A7",
  "pfsquare", "338A",
  "phabengali", "09AB",
  "phadeva", "092B",
  "phagujarati", "0AAB",
  "phagurmukhi", "0A2B",
  "phi", "03C6",
  "phi1", "03D5",
  "phieuphacirclekorean", "327A",
  "phieuphaparenkorean", "321A",
  "phieuphcirclekorean", "326C",
  "phieuphkorean", "314D",
  "phieuphparenkorean", "320C",
  "philatin", "0278",
  "phinthuthai", "0E3A",
  "phisymbolgreek", "03D5",
  "phook", "01A5",
  "phophanthai", "0E1E",
  "phophungthai", "0E1C",
  "phosamphaothai", "0E20",
  "pi", "03C0",
  "pieupacirclekorean", "3273",
  "pieupaparenkorean", "3213",
  "pieupcieuckorean", "3176",
  "pieupcirclekorean", "3265",
  "pieupkiyeokkorean", "3172",
  "pieupkorean", "3142",
  "pieupparenkorean", "3205",
  "pieupsioskiyeokkorean", "3174",
  "pieupsioskorean", "3144",
  "pieupsiostikeutkorean", "3175",
  "pieupthieuthkorean", "3177",
  "pieuptikeutkorean", "3173",
  "pihiragana", "3074",
  "pikatakana", "30D4",
  "pisymbolgreek", "03D6",
  "piwrarmenian", "0583",
  "plus", "002B",
  "plusbelowcmb", "031F",
  "pluscircle", "2295",
  "plusminus", "00B1",
  "plusmod", "02D6",
  "plusmonospace", "FF0B",
  "plussmall", "FE62",
  "plussuperior", "207A",
  "pmonospace", "FF50",
  "pmsquare", "33D8",
  "pohiragana", "307D",
  "pointingindexdownwhite", "261F",
  "pointingindexleftwhite", "261C",
  "pointingindexrightwhite", "261E",
  "pointingindexupwhite", "261D",
  "pokatakana", "30DD",
  "poplathai", "0E1B",
  "postalmark", "3012",
  "postalmarkface", "3020",
  "pparen", "24AB",
  "precedes", "227A",
  "prescription", "211E",
  "primemod", "02B9",
  "primereversed", "2035",
  "product", "220F",
  "projective", "2305",
  "prolongedkana", "30FC",
  "propellor", "2318",
  "propersubset", "2282",
  "propersuperset", "2283",
  "proportion", "2237",
  "proportional", "221D",
  "psi", "03C8",
  "psicyrillic", "0471",
  "psilipneumatacyrilliccmb", "0486",
  "pssquare", "33B0",
  "puhiragana", "3077",
  "pukatakana", "30D7",
  "pvsquare", "33B4",
  "pwsquare", "33BA",
  "q", "0071",
  "qadeva", "0958",
  "qadmahebrew", "05A8",
  "qafarabic", "0642",
  "qaffinalarabic", "FED6",
  "qafinitialarabic", "FED7",
  "qafmedialarabic", "FED8",
  "qamats", "05B8",
  "qamats10", "05B8",
  "qamats1a", "05B8",
  "qamats1c", "05B8",
  "qamats27", "05B8",
  "qamats29", "05B8",
  "qamats33", "05B8",
  "qamatsde", "05B8",
  "qamatshebrew", "05B8",
  "qamatsnarrowhebrew", "05B8",
  "qamatsqatanhebrew", "05B8",
  "qamatsqatannarrowhebrew", "05B8",
  "qamatsqatanquarterhebrew", "05B8",
  "qamatsqatanwidehebrew", "05B8",
  "qamatsquarterhebrew", "05B8",
  "qamatswidehebrew", "05B8",
  "qarneyparahebrew", "059F",
  "qbopomofo", "3111",
  "qcircle", "24E0",
  "qhook", "02A0",
  "qmonospace", "FF51",
  "qof", "05E7",
  "qofdagesh", "FB47",
  "qofdageshhebrew", "FB47",
  "qofhatafpatah", "05E7_05B2",
  "qofhatafpatahhebrew", "05E7_05B2",
  "qofhatafsegol", "05E7_05B1",
  "qofhatafsegolhebrew", "05E7_05B1",
  "qofhebrew", "05E7",
  "qofhiriq", "05E7_05B4",
  "qofhiriqhebrew", "05E7_05B4",
  "qofholam", "05E7_05B9",
  "qofholamhebrew", "05E7_05B9",
  "qofpatah", "05E7_05B7",
  "qofpatahhebrew", "05E7_05B7",
  "qofqamats", "05E7_05B8",
  "qofqamatshebrew", "05E7_05B8",
  "qofqubuts", "05E7_05BB",
  "qofqubutshebrew", "05E7_05BB",
  "qofsegol", "05E7_05B6",
  "qofsegolhebrew", "05E7_05B6",
  "qofsheva", "05E7_05B0",
  "qofshevahebrew", "05E7_05B0",
  "qoftsere", "05E7_05B5",
  "qoftserehebrew", "05E7_05B5",
  "qparen", "24AC",
  "quarternote", "2669",
  "qubuts", "05BB",
  "qubuts18", "05BB",
  "qubuts25", "05BB",
  "qubuts31", "05BB",
  "qubutshebrew", "05BB",
  "qubutsnarrowhebrew", "05BB",
  "qubutsquarterhebrew", "05BB",
  "qubutswidehebrew", "05BB",
  "question", "003F",
  "questionarabic", "061F",
  "questionarmenian", "055E",
  "questiondown", "00BF",
  "questiongreek", "037E",
  "questionmonospace", "FF1F",
  "quotedbl", "0022",
  "quotedblbase", "201E",
  "quotedblleft", "201C",
  "quotedblmonospace", "FF02",
  "quotedblprime", "301E",
  "quotedblprimereversed", "301D",
  "quotedblright", "201D",
  "quoteleft", "2018",
  "quoteleftreversed", "201B",
  "quotereversed", "201B",
  "quoteright", "2019",
  "quoterightn", "0149",
  "quotesinglbase", "201A",
  "quotesingle", "0027",
  "quotesinglemonospace", "FF07",
  "r", "0072",
  "raarmenian", "057C",
  "rabengali", "09B0",
  "racute", "0155",
  "radeva", "0930",
  "radical", "221A",
  "radoverssquare", "33AE",
  "radoverssquaredsquare", "33AF",
  "radsquare", "33AD",
  "rafe", "05BF",
  "rafehebrew", "05BF",
  "ragujarati", "0AB0",
  "ragurmukhi", "0A30",
  "rahiragana", "3089",
  "rakatakana", "30E9",
  "rakatakanahalfwidth", "FF97",
  "ralowerdiagonalbengali", "09F1",
  "ramiddlediagonalbengali", "09F0",
  "ramshorn", "0264",
  "ratio", "2236",
  "rbopomofo", "3116",
  "rcaron", "0159",
  "rcedilla", "0157",
  "rcircle", "24E1",
  "rcommaaccent", "0157",
  "rdblgrave", "0211",
  "rdotaccent", "1E59",
  "rdotbelow", "1E5B",
  "rdotbelowmacron", "1E5D",
  "referencemark", "203B",
  "reflexsubset", "2286",
  "reflexsuperset", "2287",
  "registered", "00AE",
  "reharabic", "0631",
  "reharmenian", "0580",
  "rehfinalarabic", "FEAE",
  "rehiragana", "308C",
  "rehyehaleflamarabic", "0631_FEF3_FE8E_0644",
  "rekatakana", "30EC",
  "rekatakanahalfwidth", "FF9A",
  "resh", "05E8",
  "reshdageshhebrew", "FB48",
  "reshhatafpatah", "05E8_05B2",
  "reshhatafpatahhebrew", "05E8_05B2",
  "reshhatafsegol", "05E8_05B1",
  "reshhatafsegolhebrew", "05E8_05B1",
  "reshhebrew", "05E8",
  "reshhiriq", "05E8_05B4",
  "reshhiriqhebrew", "05E8_05B4",
  "reshholam", "05E8_05B9",
  "reshholamhebrew", "05E8_05B9",
  "reshpatah", "05E8_05B7",
  "reshpatahhebrew", "05E8_05B7",
  "reshqamats", "05E8_05B8",
  "reshqamatshebrew", "05E8_05B8",
  "reshqubuts", "05E8_05BB",
  "reshqubutshebrew", "05E8_05BB",
  "reshsegol", "05E8_05B6",
  "reshsegolhebrew", "05E8_05B6",
  "reshsheva", "05E8_05B0",
  "reshshevahebrew", "05E8_05B0",
  "reshtsere", "05E8_05B5",
  "reshtserehebrew", "05E8_05B5",
  "reversedtilde", "223D",
  "reviahebrew", "0597",
  "reviamugrashhebrew", "0597",
  "revlogicalnot", "2310",
  "rfishhook", "027E",
  "rfishhookreversed", "027F",
  "rhabengali", "09DD",
  "rhadeva", "095D",
  "rho", "03C1",
  "rhook", "027D",
  "rhookturned", "027B",
  "rhookturnedsuperior", "02B5",
  "rhosymbolgreek", "03F1",
  "rhotichookmod", "02DE",
  "rieulacirclekorean", "3271",
  "rieulaparenkorean", "3211",
  "rieulcirclekorean", "3263",
  "rieulhieuhkorean", "3140",
  "rieulkiyeokkorean", "313A",
  "rieulkiyeoksioskorean", "3169",
  "rieulkorean", "3139",
  "rieulmieumkorean", "313B",
  "rieulpansioskorean", "316C",
  "rieulparenkorean", "3203",
  "rieulphieuphkorean", "313F",
  "rieulpieupkorean", "313C",
  "rieulpieupsioskorean", "316B",
  "rieulsioskorean", "313D",
  "rieulthieuthkorean", "313E",
  "rieultikeutkorean", "316A",
  "rieulyeorinhieuhkorean", "316D",
  "rightangle", "221F",
  "righttackbelowcmb", "0319",
  "righttriangle", "22BF",
  "rihiragana", "308A",
  "rikatakana", "30EA",
  "rikatakanahalfwidth", "FF98",
  "ring", "02DA",
  "ringbelowcmb", "0325",
  "ringcmb", "030A",
  "ringhalfleft", "02BF",
  "ringhalfleftarmenian", "0559",
  "ringhalfleftbelowcmb", "031C",
  "ringhalfleftcentered", "02D3",
  "ringhalfright", "02BE",
  "ringhalfrightbelowcmb", "0339",
  "ringhalfrightcentered", "02D2",
  "rinvertedbreve", "0213",
  "rittorusquare", "3351",
  "rlinebelow", "1E5F",
  "rlongleg", "027C",
  "rlonglegturned", "027A",
  "rmonospace", "FF52",
  "rohiragana", "308D",
  "rokatakana", "30ED",
  "rokatakanahalfwidth", "FF9B",
  "roruathai", "0E23",
  "rparen", "24AD",
  "rrabengali", "09DC",
  "rradeva", "0931",
  "rragurmukhi", "0A5C",
  "rreharabic", "0691",
  "rrehfinalarabic", "FB8D",
  "rrvocalicbengali", "09E0",
  "rrvocalicdeva", "0960",
  "rrvocalicgujarati", "0AE0",
  "rrvocalicvowelsignbengali", "09C4",
  "rrvocalicvowelsigndeva", "0944",
  "rrvocalicvowelsigngujarati", "0AC4",
  "rtblock", "2590",
  "rturned", "0279",
  "rturnedsuperior", "02B4",
  "ruhiragana", "308B",
  "rukatakana", "30EB",
  "rukatakanahalfwidth", "FF99",
  "rupeemarkbengali", "09F2",
  "rupeesignbengali", "09F3",
  "ruthai", "0E24",
  "rvocalicbengali", "098B",
  "rvocalicdeva", "090B",
  "rvocalicgujarati", "0A8B",
  "rvocalicvowelsignbengali", "09C3",
  "rvocalicvowelsigndeva", "0943",
  "rvocalicvowelsigngujarati", "0AC3",
  "s", "0073",
  "sabengali", "09B8",
  "sacute", "015B",
  "sacutedotaccent", "1E65",
  "sadarabic", "0635",
  "sadeva", "0938",
  "sadfinalarabic", "FEBA",
  "sadinitialarabic", "FEBB",
  "sadmedialarabic", "FEBC",
  "sagujarati", "0AB8",
  "sagurmukhi", "0A38",
  "sahiragana", "3055",
  "sakatakana", "30B5",
  "sakatakanahalfwidth", "FF7B",
  "sallallahoualayhewasallamarabic", "FDFA",
  "samekh", "05E1",
  "samekhdagesh", "FB41",
  "samekhdageshhebrew", "FB41",
  "samekhhebrew", "05E1",
  "saraaathai", "0E32",
  "saraaethai", "0E41",
  "saraaimaimalaithai", "0E44",
  "saraaimaimuanthai", "0E43",
  "saraamthai", "0E33",
  "saraathai", "0E30",
  "saraethai", "0E40",
  "saraiithai", "0E35",
  "saraithai", "0E34",
  "saraothai", "0E42",
  "saraueethai", "0E37",
  "sarauethai", "0E36",
  "sarauthai", "0E38",
  "sarauuthai", "0E39",
  "sbopomofo", "3119",
  "scaron", "0161",
  "scarondotaccent", "1E67",
  "scedilla", "015F",
  "schwa", "0259",
  "schwacyrillic", "04D9",
  "schwadieresiscyrillic", "04DB",
  "schwahook", "025A",
  "scircle", "24E2",
  "scircumflex", "015D",
  "scommaaccent", "0219",
  "sdotaccent", "1E61",
  "sdotbelow", "1E63",
  "sdotbelowdotaccent", "1E69",
  "seagullbelowcmb", "033C",
  "second", "2033",
  "secondtonechinese", "02CA",
  "section", "00A7",
  "seenarabic", "0633",
  "seenfinalarabic", "FEB2",
  "seeninitialarabic", "FEB3",
  "seenmedialarabic", "FEB4",
  "segol", "05B6",
  "segol13", "05B6",
  "segol1f", "05B6",
  "segol2c", "05B6",
  "segolhebrew", "05B6",
  "segolnarrowhebrew", "05B6",
  "segolquarterhebrew", "05B6",
  "segoltahebrew", "0592",
  "segolwidehebrew", "05B6",
  "seharmenian", "057D",
  "sehiragana", "305B",
  "sekatakana", "30BB",
  "sekatakanahalfwidth", "FF7E",
  "semicolon", "003B",
  "semicolonarabic", "061B",
  "semicolonmonospace", "FF1B",
  "semicolonsmall", "FE54",
  "semivoicedmarkkana", "309C",
  "semivoicedmarkkanahalfwidth", "FF9F",
  "sentisquare", "3322",
  "sentosquare", "3323",
  "seven", "0037",
  "sevenarabic", "0667",
  "sevenbengali", "09ED",
  "sevencircle", "2466",
  "sevencircleinversesansserif", "2790",
  "sevendeva", "096D",
  "seveneighths", "215E",
  "sevengujarati", "0AED",
  "sevengurmukhi", "0A6D",
  "sevenhackarabic", "0667",
  "sevenhangzhou", "3027",
  "sevenideographicparen", "3226",
  "seveninferior", "2087",
  "sevenmonospace", "FF17",
  "sevenparen", "247A",
  "sevenperiod", "248E",
  "sevenpersian", "06F7",
  "sevenroman", "2176",
  "sevensuperior", "2077",
  "seventeencircle", "2470",
  "seventeenparen", "2484",
  "seventeenperiod", "2498",
  "seventhai", "0E57",
  "sfthyphen", "00AD",
  "shaarmenian", "0577",
  "shabengali", "09B6",
  "shacyrillic", "0448",
  "shaddaarabic", "0651",
  "shaddadammaarabic", "FC61",
  "shaddadammatanarabic", "FC5E",
  "shaddafathaarabic", "FC60",
  "shaddafathatanarabic", "0651_064B",
  "shaddakasraarabic", "FC62",
  "shaddakasratanarabic", "FC5F",
  "shade", "2592",
  "shadedark", "2593",
  "shadelight", "2591",
  "shademedium", "2592",
  "shadeva", "0936",
  "shagujarati", "0AB6",
  "shagurmukhi", "0A36",
  "shalshelethebrew", "0593",
  "shbopomofo", "3115",
  "shchacyrillic", "0449",
  "sheenarabic", "0634",
  "sheenfinalarabic", "FEB6",
  "sheeninitialarabic", "FEB7",
  "sheenmedialarabic", "FEB8",
  "sheicoptic", "03E3",
  "sheqel", "20AA",
  "sheqelhebrew", "20AA",
  "sheva", "05B0",
  "sheva115", "05B0",
  "sheva15", "05B0",
  "sheva22", "05B0",
  "sheva2e", "05B0",
  "shevahebrew", "05B0",
  "shevanarrowhebrew", "05B0",
  "shevaquarterhebrew", "05B0",
  "shevawidehebrew", "05B0",
  "shhacyrillic", "04BB",
  "shimacoptic", "03ED",
  "shin", "05E9",
  "shindagesh", "FB49",
  "shindageshhebrew", "FB49",
  "shindageshshindot", "FB2C",
  "shindageshshindothebrew", "FB2C",
  "shindageshsindot", "FB2D",
  "shindageshsindothebrew", "FB2D",
  "shindothebrew", "05C1",
  "shinhebrew", "05E9",
  "shinshindot", "FB2A",
  "shinshindothebrew", "FB2A",
  "shinsindot", "FB2B",
  "shinsindothebrew", "FB2B",
  "shook", "0282",
  "sigma", "03C3",
  "sigma1", "03C2",
  "sigmafinal", "03C2",
  "sigmalunatesymbolgreek", "03F2",
  "sihiragana", "3057",
  "sikatakana", "30B7",
  "sikatakanahalfwidth", "FF7C",
  "siluqhebrew", "05BD",
  "siluqlefthebrew", "05BD",
  "similar", "223C",
  "sindothebrew", "05C2",
  "siosacirclekorean", "3274",
  "siosaparenkorean", "3214",
  "sioscieuckorean", "317E",
  "sioscirclekorean", "3266",
  "sioskiyeokkorean", "317A",
  "sioskorean", "3145",
  "siosnieunkorean", "317B",
  "siosparenkorean", "3206",
  "siospieupkorean", "317D",
  "siostikeutkorean", "317C",
  "six", "0036",
  "sixarabic", "0666",
  "sixbengali", "09EC",
  "sixcircle", "2465",
  "sixcircleinversesansserif", "278F",
  "sixdeva", "096C",
  "sixgujarati", "0AEC",
  "sixgurmukhi", "0A6C",
  "sixhackarabic", "0666",
  "sixhangzhou", "3026",
  "sixideographicparen", "3225",
  "sixinferior", "2086",
  "sixmonospace", "FF16",
  "sixparen", "2479",
  "sixperiod", "248D",
  "sixpersian", "06F6",
  "sixroman", "2175",
  "sixsuperior", "2076",
  "sixteencircle", "246F",
  "sixteencurrencydenominatorbengali", "09F9",
  "sixteenparen", "2483",
  "sixteenperiod", "2497",
  "sixthai", "0E56",
  "slash", "002F",
  "slashmonospace", "FF0F",
  "slong", "017F",
  "slongdotaccent", "1E9B",
  "smileface", "263A",
  "smonospace", "FF53",
  "sofpasuqhebrew", "05C3",
  "softhyphen", "00AD",
  "softsigncyrillic", "044C",
  "sohiragana", "305D",
  "sokatakana", "30BD",
  "sokatakanahalfwidth", "FF7F",
  "soliduslongoverlaycmb", "0338",
  "solidusshortoverlaycmb", "0337",
  "sorusithai", "0E29",
  "sosalathai", "0E28",
  "sosothai", "0E0B",
  "sosuathai", "0E2A",
  "space", "0020",
  "spacehackarabic", "0020",
  "spade", "2660",
  "spadesuitblack", "2660",
  "spadesuitwhite", "2664",
  "sparen", "24AE",
  "squarebelowcmb", "033B",
  "squarecc", "33C4",
  "squarecm", "339D",
  "squarediagonalcrosshatchfill", "25A9",
  "squarehorizontalfill", "25A4",
  "squarekg", "338F",
  "squarekm", "339E",
  "squarekmcapital", "33CE",
  "squareln", "33D1",
  "squarelog", "33D2",
  "squaremg", "338E",
  "squaremil", "33D5",
  "squaremm", "339C",
  "squaremsquared", "33A1",
  "squareorthogonalcrosshatchfill", "25A6",
  "squareupperlefttolowerrightfill", "25A7",
  "squareupperrighttolowerleftfill", "25A8",
  "squareverticalfill", "25A5",
  "squarewhitewithsmallblack", "25A3",
  "srsquare", "33DB",
  "ssabengali", "09B7",
  "ssadeva", "0937",
  "ssagujarati", "0AB7",
  "ssangcieuckorean", "3149",
  "ssanghieuhkorean", "3185",
  "ssangieungkorean", "3180",
  "ssangkiyeokkorean", "3132",
  "ssangnieunkorean", "3165",
  "ssangpieupkorean", "3143",
  "ssangsioskorean", "3146",
  "ssangtikeutkorean", "3138",
  "sterling", "00A3",
  "sterlingmonospace", "FFE1",
  "strokelongoverlaycmb", "0336",
  "strokeshortoverlaycmb", "0335",
  "subset", "2282",
  "subsetnotequal", "228A",
  "subsetorequal", "2286",
  "succeeds", "227B",
  "suchthat", "220B",
  "suhiragana", "3059",
  "sukatakana", "30B9",
  "sukatakanahalfwidth", "FF7D",
  "sukunarabic", "0652",
  "summation", "2211",
  "sun", "263C",
  "superset", "2283",
  "supersetnotequal", "228B",
  "supersetorequal", "2287",
  "svsquare", "33DC",
  "syouwaerasquare", "337C",
  "t", "0074",
  "tabengali", "09A4",
  "tackdown", "22A4",
  "tackleft", "22A3",
  "tadeva", "0924",
  "tagujarati", "0AA4",
  "tagurmukhi", "0A24",
  "taharabic", "0637",
  "tahfinalarabic", "FEC2",
  "tahinitialarabic", "FEC3",
  "tahiragana", "305F",
  "tahmedialarabic", "FEC4",
  "taisyouerasquare", "337D",
  "takatakana", "30BF",
  "takatakanahalfwidth", "FF80",
  "tatweelarabic", "0640",
  "tau", "03C4",
  "tav", "05EA",
  "tavdages", "FB4A",
  "tavdagesh", "FB4A",
  "tavdageshhebrew", "FB4A",
  "tavhebrew", "05EA",
  "tbar", "0167",
  "tbopomofo", "310A",
  "tcaron", "0165",
  "tccurl", "02A8",
  "tcedilla", "0163",
  "tcheharabic", "0686",
  "tchehfinalarabic", "FB7B",
  "tchehinitialarabic", "FB7C",
  "tchehmedialarabic", "FB7D",
  "tchehmeeminitialarabic", "FB7C_FEE4",
  "tcircle", "24E3",
  "tcircumflexbelow", "1E71",
  "tcommaaccent", "0163",
  "tdieresis", "1E97",
  "tdotaccent", "1E6B",
  "tdotbelow", "1E6D",
  "tecyrillic", "0442",
  "tedescendercyrillic", "04AD",
  "teharabic", "062A",
  "tehfinalarabic", "FE96",
  "tehhahinitialarabic", "FCA2",
  "tehhahisolatedarabic", "FC0C",
  "tehinitialarabic", "FE97",
  "tehiragana", "3066",
  "tehjeeminitialarabic", "FCA1",
  "tehjeemisolatedarabic", "FC0B",
  "tehmarbutaarabic", "0629",
  "tehmarbutafinalarabic", "FE94",
  "tehmedialarabic", "FE98",
  "tehmeeminitialarabic", "FCA4",
  "tehmeemisolatedarabic", "FC0E",
  "tehnoonfinalarabic", "FC73",
  "tekatakana", "30C6",
  "tekatakanahalfwidth", "FF83",
  "telephone", "2121",
  "telephoneblack", "260E",
  "telishagedolahebrew", "05A0",
  "telishaqetanahebrew", "05A9",
  "tencircle", "2469",
  "tenideographicparen", "3229",
  "tenparen", "247D",
  "tenperiod", "2491",
  "tenroman", "2179",
  "tesh", "02A7",
  "tet", "05D8",
  "tetdagesh", "FB38",
  "tetdageshhebrew", "FB38",
  "tethebrew", "05D8",
  "tetsecyrillic", "04B5",
  "tevirhebrew", "059B",
  "tevirlefthebrew", "059B",
  "thabengali", "09A5",
  "thadeva", "0925",
  "thagujarati", "0AA5",
  "thagurmukhi", "0A25",
  "thalarabic", "0630",
  "thalfinalarabic", "FEAC",
  "thanthakhatthai", "0E4C",
  "theharabic", "062B",
  "thehfinalarabic", "FE9A",
  "thehinitialarabic", "FE9B",
  "thehmedialarabic", "FE9C",
  "thereexists", "2203",
  "therefore", "2234",
  "theta", "03B8",
  "theta1", "03D1",
  "thetasymbolgreek", "03D1",
  "thieuthacirclekorean", "3279",
  "thieuthaparenkorean", "3219",
  "thieuthcirclekorean", "326B",
  "thieuthkorean", "314C",
  "thieuthparenkorean", "320B",
  "thirteencircle", "246C",
  "thirteenparen", "2480",
  "thirteenperiod", "2494",
  "thonangmonthothai", "0E11",
  "thook", "01AD",
  "thophuthaothai", "0E12",
  "thorn", "00FE",
  "thothahanthai", "0E17",
  "thothanthai", "0E10",
  "thothongthai", "0E18",
  "thothungthai", "0E16",
  "thousandcyrillic", "0482",
  "thousandsseparatorarabic", "066C",
  "thousandsseparatorpersian", "066C",
  "three", "0033",
  "threearabic", "0663",
  "threebengali", "09E9",
  "threecircle", "2462",
  "threecircleinversesansserif", "278C",
  "threedeva", "0969",
  "threeeighths", "215C",
  "threegujarati", "0AE9",
  "threegurmukhi", "0A69",
  "threehackarabic", "0663",
  "threehangzhou", "3023",
  "threeideographicparen", "3222",
  "threeinferior", "2083",
  "threemonospace", "FF13",
  "threenumeratorbengali", "09F6",
  "threeparen", "2476",
  "threeperiod", "248A",
  "threepersian", "06F3",
  "threequarters", "00BE",
  "threeroman", "2172",
  "threesuperior", "00B3",
  "threethai", "0E53",
  "thzsquare", "3394",
  "tihiragana", "3061",
  "tikatakana", "30C1",
  "tikatakanahalfwidth", "FF81",
  "tikeutacirclekorean", "3270",
  "tikeutaparenkorean", "3210",
  "tikeutcirclekorean", "3262",
  "tikeutkorean", "3137",
  "tikeutparenkorean", "3202",
  "tilde", "02DC",
  "tildebelowcmb", "0330",
  "tildecmb", "0303",
  "tildecomb", "0303",
  "tildedoublecmb", "0360",
  "tildeoperator", "223C",
  "tildeoverlaycmb", "0334",
  "tildeverticalcmb", "033E",
  "timescircle", "2297",
  "tipehahebrew", "0596",
  "tipehalefthebrew", "0596",
  "tippigurmukhi", "0A70",
  "titlocyrilliccmb", "0483",
  "tiwnarmenian", "057F",
  "tlinebelow", "1E6F",
  "tmonospace", "FF54",
  "toarmenian", "0569",
  "tohiragana", "3068",
  "tokatakana", "30C8",
  "tokatakanahalfwidth", "FF84",
  "tonebarextrahighmod", "02E5",
  "tonebarextralowmod", "02E9",
  "tonebarhighmod", "02E6",
  "tonebarlowmod", "02E8",
  "tonebarmidmod", "02E7",
  "tonefive", "01BD",
  "tonesix", "0185",
  "tonetwo", "01A8",
  "tonos", "0384",
  "tonsquare", "3327",
  "topatakthai", "0E0F",
  "tortoiseshellbracketleft", "3014",
  "tortoiseshellbracketleftsmall", "FE5D",
  "tortoiseshellbracketleftvertical", "FE39",
  "tortoiseshellbracketright", "3015",
  "tortoiseshellbracketrightsmall", "FE5E",
  "tortoiseshellbracketrightvertical", "FE3A",
  "totaothai", "0E15",
  "tpalatalhook", "01AB",
  "tparen", "24AF",
  "trademark", "2122",
  "tretroflexhook", "0288",
  "triagdn", "25BC",
  "triaglf", "25C4",
  "triagrt", "25BA",
  "triagup", "25B2",
  "ts", "02A6",
  "tsadi", "05E6",
  "tsadidagesh", "FB46",
  "tsadidageshhebrew", "FB46",
  "tsadihebrew", "05E6",
  "tsecyrillic", "0446",
  "tsere", "05B5",
  "tsere12", "05B5",
  "tsere1e", "05B5",
  "tsere2b", "05B5",
  "tserehebrew", "05B5",
  "tserenarrowhebrew", "05B5",
  "tserequarterhebrew", "05B5",
  "tserewidehebrew", "05B5",
  "tshecyrillic", "045B",
  "ttabengali", "099F",
  "ttadeva", "091F",
  "ttagujarati", "0A9F",
  "ttagurmukhi", "0A1F",
  "tteharabic", "0679",
  "ttehfinalarabic", "FB67",
  "ttehinitialarabic", "FB68",
  "ttehmedialarabic", "FB69",
  "tthabengali", "09A0",
  "tthadeva", "0920",
  "tthagujarati", "0AA0",
  "tthagurmukhi", "0A20",
  "tturned", "0287",
  "tuhiragana", "3064",
  "tukatakana", "30C4",
  "tukatakanahalfwidth", "FF82",
  "tusmallhiragana", "3063",
  "tusmallkatakana", "30C3",
  "tusmallkatakanahalfwidth", "FF6F",
  "twelvecircle", "246B",
  "twelveparen", "247F",
  "twelveperiod", "2493",
  "twelveroman", "217B",
  "twentycircle", "2473",
  "twentyhangzhou", "5344",
  "twentyparen", "2487",
  "twentyperiod", "249B",
  "two", "0032",
  "twoarabic", "0662",
  "twobengali", "09E8",
  "twocircle", "2461",
  "twocircleinversesansserif", "278B",
  "twodeva", "0968",
  "twodotenleader", "2025",
  "twodotleader", "2025",
  "twodotleadervertical", "FE30",
  "twogujarati", "0AE8",
  "twogurmukhi", "0A68",
  "twohackarabic", "0662",
  "twohangzhou", "3022",
  "twoideographicparen", "3221",
  "twoinferior", "2082",
  "twomonospace", "FF12",
  "twonumeratorbengali", "09F5",
  "twoparen", "2475",
  "twoperiod", "2489",
  "twopersian", "06F2",
  "tworoman", "2171",
  "twostroke", "01BB",
  "twosuperior", "00B2",
  "twothai", "0E52",
  "twothirds", "2154",
  "u", "0075",
  "uacute", "00FA",
  "ubar", "0289",
  "ubengali", "0989",
  "ubopomofo", "3128",
  "ubreve", "016D",
  "ucaron", "01D4",
  "ucircle", "24E4",
  "ucircumflex", "00FB",
  "ucircumflexbelow", "1E77",
  "ucyrillic", "0443",
  "udattadeva", "0951",
  "udblacute", "0171",
  "udblgrave", "0215",
  "udeva", "0909",
  "udieresis", "00FC",
  "udieresisacute", "01D8",
  "udieresisbelow", "1E73",
  "udieresiscaron", "01DA",
  "udieresiscyrillic", "04F1",
  "udieresisgrave", "01DC",
  "udieresismacron", "01D6",
  "udotbelow", "1EE5",
  "ugrave", "00F9",
  "ugujarati", "0A89",
  "ugurmukhi", "0A09",
  "uhiragana", "3046",
  "uhookabove", "1EE7",
  "uhorn", "01B0",
  "uhornacute", "1EE9",
  "uhorndotbelow", "1EF1",
  "uhorngrave", "1EEB",
  "uhornhookabove", "1EED",
  "uhorntilde", "1EEF",
  "uhungarumlaut", "0171",
  "uhungarumlautcyrillic", "04F3",
  "uinvertedbreve", "0217",
  "ukatakana", "30A6",
  "ukatakanahalfwidth", "FF73",
  "ukcyrillic", "0479",
  "ukorean", "315C",
  "umacron", "016B",
  "umacroncyrillic", "04EF",
  "umacrondieresis", "1E7B",
  "umatragurmukhi", "0A41",
  "umonospace", "FF55",
  "underscore", "005F",
  "underscoredbl", "2017",
  "underscoremonospace", "FF3F",
  "underscorevertical", "FE33",
  "underscorewavy", "FE4F",
  "union", "222A",
  "universal", "2200",
  "uogonek", "0173",
  "uparen", "24B0",
  "upblock", "2580",
  "upperdothebrew", "05C4",
  "upsilon", "03C5",
  "upsilondieresis", "03CB",
  "upsilondieresistonos", "03B0",
  "upsilonlatin", "028A",
  "upsilontonos", "03CD",
  "uptackbelowcmb", "031D",
  "uptackmod", "02D4",
  "uragurmukhi", "0A73",
  "uring", "016F",
  "ushortcyrillic", "045E",
  "usmallhiragana", "3045",
  "usmallkatakana", "30A5",
  "usmallkatakanahalfwidth", "FF69",
  "ustraightcyrillic", "04AF",
  "ustraightstrokecyrillic", "04B1",
  "utilde", "0169",
  "utildeacute", "1E79",
  "utildebelow", "1E75",
  "uubengali", "098A",
  "uudeva", "090A",
  "uugujarati", "0A8A",
  "uugurmukhi", "0A0A",
  "uumatragurmukhi", "0A42",
  "uuvowelsignbengali", "09C2",
  "uuvowelsigndeva", "0942",
  "uuvowelsigngujarati", "0AC2",
  "uvowelsignbengali", "09C1",
  "uvowelsigndeva", "0941",
  "uvowelsigngujarati", "0AC1",
  "v", "0076",
  "vadeva", "0935",
  "vagujarati", "0AB5",
  "vagurmukhi", "0A35",
  "vakatakana", "30F7",
  "vav", "05D5",
  "vavdagesh", "FB35",
  "vavdagesh65", "FB35",
  "vavdageshhebrew", "FB35",
  "vavhebrew", "05D5",
  "vavholam", "FB4B",
  "vavholamhebrew", "FB4B",
  "vavvavhebrew", "05F0",
  "vavyodhebrew", "05F1",
  "vcircle", "24E5",
  "vdotbelow", "1E7F",
  "vecyrillic", "0432",
  "veharabic", "06A4",
  "vehfinalarabic", "FB6B",
  "vehinitialarabic", "FB6C",
  "vehmedialarabic", "FB6D",
  "vekatakana", "30F9",
  "venus", "2640",
  "verticalbar", "007C",
  "verticallineabovecmb", "030D",
  "verticallinebelowcmb", "0329",
  "verticallinelowmod", "02CC",
  "verticallinemod", "02C8",
  "vewarmenian", "057E",
  "vhook", "028B",
  "vikatakana", "30F8",
  "viramabengali", "09CD",
  "viramadeva", "094D",
  "viramagujarati", "0ACD",
  "visargabengali", "0983",
  "visargadeva", "0903",
  "visargagujarati", "0A83",
  "vmonospace", "FF56",
  "voarmenian", "0578",
  "voicediterationhiragana", "309E",
  "voicediterationkatakana", "30FE",
  "voicedmarkkana", "309B",
  "voicedmarkkanahalfwidth", "FF9E",
  "vokatakana", "30FA",
  "vparen", "24B1",
  "vtilde", "1E7D",
  "vturned", "028C",
  "vuhiragana", "3094",
  "vukatakana", "30F4",
  "w", "0077",
  "wacute", "1E83",
  "waekorean", "3159",
  "wahiragana", "308F",
  "wakatakana", "30EF",
  "wakatakanahalfwidth", "FF9C",
  "wakorean", "3158",
  "wasmallhiragana", "308E",
  "wasmallkatakana", "30EE",
  "wattosquare", "3357",
  "wavedash", "301C",
  "wavyunderscorevertical", "FE34",
  "wawarabic", "0648",
  "wawfinalarabic", "FEEE",
  "wawhamzaabovearabic", "0624",
  "wawhamzaabovefinalarabic", "FE86",
  "wbsquare", "33DD",
  "wcircle", "24E6",
  "wcircumflex", "0175",
  "wdieresis", "1E85",
  "wdotaccent", "1E87",
  "wdotbelow", "1E89",
  "wehiragana", "3091",
  "weierstrass", "2118",
  "wekatakana", "30F1",
  "wekorean", "315E",
  "weokorean", "315D",
  "wgrave", "1E81",
  "whitebullet", "25E6",
  "whitecircle", "25CB",
  "whitecircleinverse", "25D9",
  "whitecornerbracketleft", "300E",
  "whitecornerbracketleftvertical", "FE43",
  "whitecornerbracketright", "300F",
  "whitecornerbracketrightvertical", "FE44",
  "whitediamond", "25C7",
  "whitediamondcontainingblacksmalldiamond", "25C8",
  "whitedownpointingsmalltriangle", "25BF",
  "whitedownpointingtriangle", "25BD",
  "whiteleftpointingsmalltriangle", "25C3",
  "whiteleftpointingtriangle", "25C1",
  "whitelenticularbracketleft", "3016",
  "whitelenticularbracketright", "3017",
  "whiterightpointingsmalltriangle", "25B9",
  "whiterightpointingtriangle", "25B7",
  "whitesmallsquare", "25AB",
  "whitesmilingface", "263A",
  "whitesquare", "25A1",
  "whitestar", "2606",
  "whitetelephone", "260F",
  "whitetortoiseshellbracketleft", "3018",
  "whitetortoiseshellbracketright", "3019",
  "whiteuppointingsmalltriangle", "25B5",
  "whiteuppointingtriangle", "25B3",
  "wihiragana", "3090",
  "wikatakana", "30F0",
  "wikorean", "315F",
  "wmonospace", "FF57",
  "wohiragana", "3092",
  "wokatakana", "30F2",
  "wokatakanahalfwidth", "FF66",
  "won", "20A9",
  "wonmonospace", "FFE6",
  "wowaenthai", "0E27",
  "wparen", "24B2",
  "wring", "1E98",
  "wsuperior", "02B7",
  "wturned", "028D",
  "wynn", "01BF",
  "x", "0078",
  "xabovecmb", "033D",
  "xbopomofo", "3112",
  "xcircle", "24E7",
  "xdieresis", "1E8D",
  "xdotaccent", "1E8B",
  "xeharmenian", "056D",
  "xi", "03BE",
  "xmonospace", "FF58",
  "xparen", "24B3",
  "xsuperior", "02E3",
  "y", "0079",
  "yaadosquare", "334E",
  "yabengali", "09AF",
  "yacute", "00FD",
  "yadeva", "092F",
  "yaekorean", "3152",
  "yagujarati", "0AAF",
  "yagurmukhi", "0A2F",
  "yahiragana", "3084",
  "yakatakana", "30E4",
  "yakatakanahalfwidth", "FF94",
  "yakorean", "3151",
  "yamakkanthai", "0E4E",
  "yasmallhiragana", "3083",
  "yasmallkatakana", "30E3",
  "yasmallkatakanahalfwidth", "FF6C",
  "yatcyrillic", "0463",
  "ycircle", "24E8",
  "ycircumflex", "0177",
  "ydieresis", "00FF",
  "ydotaccent", "1E8F",
  "ydotbelow", "1EF5",
  "yeharabic", "064A",
  "yehbarreearabic", "06D2",
  "yehbarreefinalarabic", "FBAF",
  "yehfinalarabic", "FEF2",
  "yehhamzaabovearabic", "0626",
  "yehhamzaabovefinalarabic", "FE8A",
  "yehhamzaaboveinitialarabic", "FE8B",
  "yehhamzaabovemedialarabic", "FE8C",
  "yehinitialarabic", "FEF3",
  "yehmedialarabic", "FEF4",
  "yehmeeminitialarabic", "FCDD",
  "yehmeemisolatedarabic", "FC58",
  "yehnoonfinalarabic", "FC94",
  "yehthreedotsbelowarabic", "06D1",
  "yekorean", "3156",
  "yen", "00A5",
  "yenmonospace", "FFE5",
  "yeokorean", "3155",
  "yeorinhieuhkorean", "3186",
  "yerahbenyomohebrew", "05AA",
  "yerahbenyomolefthebrew", "05AA",
  "yericyrillic", "044B",
  "yerudieresiscyrillic", "04F9",
  "yesieungkorean", "3181",
  "yesieungpansioskorean", "3183",
  "yesieungsioskorean", "3182",
  "yetivhebrew", "059A",
  "ygrave", "1EF3",
  "yhook", "01B4",
  "yhookabove", "1EF7",
  "yiarmenian", "0575",
  "yicyrillic", "0457",
  "yikorean", "3162",
  "yinyang", "262F",
  "yiwnarmenian", "0582",
  "ymonospace", "FF59",
  "yod", "05D9",
  "yoddagesh", "FB39",
  "yoddageshhebrew", "FB39",
  "yodhebrew", "05D9",
  "yodyodhebrew", "05F2",
  "yodyodpatahhebrew", "FB1F",
  "yohiragana", "3088",
  "yoikorean", "3189",
  "yokatakana", "30E8",
  "yokatakanahalfwidth", "FF96",
  "yokorean", "315B",
  "yosmallhiragana", "3087",
  "yosmallkatakana", "30E7",
  "yosmallkatakanahalfwidth", "FF6E",
  "yotgreek", "03F3",
  "yoyaekorean", "3188",
  "yoyakorean", "3187",
  "yoyakthai", "0E22",
  "yoyingthai", "0E0D",
  "yparen", "24B4",
  "ypogegrammeni", "037A",
  "ypogegrammenigreekcmb", "0345",
  "yr", "01A6",
  "yring", "1E99",
  "ysuperior", "02B8",
  "ytilde", "1EF9",
  "yturned", "028E",
  "yuhiragana", "3086",
  "yuikorean", "318C",
  "yukatakana", "30E6",
  "yukatakanahalfwidth", "FF95",
  "yukorean", "3160",
  "yusbigcyrillic", "046B",
  "yusbigiotifiedcyrillic", "046D",
  "yuslittlecyrillic", "0467",
  "yuslittleiotifiedcyrillic", "0469",
  "yusmallhiragana", "3085",
  "yusmallkatakana", "30E5",
  "yusmallkatakanahalfwidth", "FF6D",
  "yuyekorean", "318B",
  "yuyeokorean", "318A",
  "yyabengali", "09DF",
  "yyadeva", "095F",
  "z", "007A",
  "zaarmenian", "0566",
  "zacute", "017A",
  "zadeva", "095B",
  "zagurmukhi", "0A5B",
  "zaharabic", "0638",
  "zahfinalarabic", "FEC6",
  "zahinitialarabic", "FEC7",
  "zahiragana", "3056",
  "zahmedialarabic", "FEC8",
  "zainarabic", "0632",
  "zainfinalarabic", "FEB0",
  "zakatakana", "30B6",
  "zaqefgadolhebrew", "0595",
  "zaqefqatanhebrew", "0594",
  "zarqahebrew", "0598",
  "zayin", "05D6",
  "zayindagesh", "FB36",
  "zayindageshhebrew", "FB36",
  "zayinhebrew", "05D6",
  "zbopomofo", "3117",
  "zcaron", "017E",
  "zcircle", "24E9",
  "zcircumflex", "1E91",
  "zcurl", "0291",
  "zdot", "017C",
  "zdotaccent", "017C",
  "zdotbelow", "1E93",
  "zecyrillic", "0437",
  "zedescendercyrillic", "0499",
  "zedieresiscyrillic", "04DF",
  "zehiragana", "305C",
  "zekatakana", "30BC",
  "zero", "0030",
  "zeroarabic", "0660",
  "zerobengali", "09E6",
  "zerodeva", "0966",
  "zerogujarati", "0AE6",
  "zerogurmukhi", "0A66",
  "zerohackarabic", "0660",
  "zeroinferior", "2080",
  "zeromonospace", "FF10",
  "zeropersian", "06F0",
  "zerosuperior", "2070",
  "zerothai", "0E50",
  "zerowidthjoiner", "FEFF",
  "zerowidthnonjoiner", "200C",
  "zerowidthspace", "200B",
  "zeta", "03B6",
  "zhbopomofo", "3113",
  "zhearmenian", "056A",
  "zhebrevecyrillic", "04C2",
  "zhecyrillic", "0436",
  "zhedescendercyrillic", "0497",
  "zhedieresiscyrillic", "04DD",
  "zihiragana", "3058",
  "zikatakana", "30B8",
  "zinorhebrew", "05AE",
  "zlinebelow", "1E95",
  "zmonospace", "FF5A",
  "zohiragana", "305E",
  "zokatakana", "30BE",
  "zparen", "24B5",
  "zretroflexhook", "0290",
  "zstroke", "01B6",
  "zuhiragana", "305A",
  "zukatakana", "30BA",
);


my $prog = $0;
$prog =~ s@.*/@@;

my $groff_sys_fontdir = "@FONTDIR@";

use Getopt::Std;
getopts('a:d:e:i:mnsvx');

our ($opt_a, $opt_d, $opt_e, $opt_i, $opt_m, $opt_n, $opt_s, $opt_v, $opt_x);

if ($opt_v) {
    print "GNU afmtodit (groff) version @VERSION@\n";
    exit 0;
}

if ($#ARGV != 2) {
    die "usage: $prog [-mnsvx] [-a angle] [-d DESC] [-e encoding]\n" .
	"       [-i n] afmfile mapfile font\n";
}

my $afm = $ARGV[0];
my $map = $ARGV[1];
my $font = $ARGV[2];
my $desc = $opt_d || "DESC";
my $sys_map = $groff_sys_fontdir . "/devps/generate/" . $map;
my $sys_desc = $groff_sys_fontdir . "/devps/" . $desc;

# read the afm file

my $psname;
my $italic_angle = 0;
my (@kern1, @kern2, @kernx);
my (%italic_correction, %left_italic_correction);
my %subscript_correction;
# my %ligs
my %ligatures;
my (@encoding, %in_encoding);
my (%width, %height, %depth);
my (%left_side_bearing, %right_side_bearing);

open(AFM, $afm) || die "$prog: can't open \`$ARGV[0]': $!\n";

while (<AFM>) {
    chop;
    my @field = split(' ');
    next if $#field < 0;
    if ($field[0] eq "FontName") {
	$psname = $field[1];
    }
    elsif($field[0] eq "ItalicAngle") {
	$italic_angle = -$field[1];
    }
    elsif ($field[0] eq "KPX") {
	if ($#field == 3) {
	    push(@kern1, $field[1]);
	    push(@kern2, $field[2]);
	    push(@kernx, $field[3]);
	}
    }
    elsif ($field[0] eq "italicCorrection") {
	$italic_correction{$field[1]} = $field[2];
    }
    elsif ($field[0] eq "leftItalicCorrection") {
	$left_italic_correction{$field[1]} = $field[2];
    }
    elsif ($field[0] eq "subscriptCorrection") {
	$subscript_correction{$field[1]} = $field[2];
    }
    elsif ($field[0] eq "StartCharMetrics") {
	while (<AFM>) {
	    @field = split(' ');
	    next if $#field < 0;
	    last if ($field[0] eq "EndCharMetrics");
	    if ($field[0] eq "C") {
		my $w;
		my $wx = 0;
		my $n = "";
#		%ligs = ();
		my $lly = 0;
		my $ury = 0;
		my $llx = 0;
		my $urx = 0;
		my $c = $field[1];
		my $i = 2;
		while ($i <= $#field) {
		    if ($field[$i] eq "WX") {
			$w = $field[$i + 1];
			$i += 2;
		    }
		    elsif ($field[$i] eq "N") {
			$n = $field[$i + 1];
			$i += 2;
		    }
		    elsif ($field[$i] eq "B") {
			$llx = $field[$i + 1];
			$lly = $field[$i + 2];
			$urx = $field[$i + 3];
			$ury = $field[$i + 4];
			$i += 5;
		    }
#		    elsif ($field[$i] eq "L") {
#			$ligs{$field[$i + 2]} = $field[$i + 1];
#			$i += 3;
#		    }
		    else {
			while ($i <= $#field && $field[$i] ne ";") {
			    $i++;
			}
			$i++;
		    }
		}
		if (!$opt_e && $c != -1) {
		    $encoding[$c] = $n;
		    $in_encoding{$n} = 1;
		}
		$width{$n} = $w;
		$height{$n} = $ury;
		$depth{$n} = -$lly;
		$left_side_bearing{$n} = -$llx;
		$right_side_bearing{$n} = $urx - $w;
#		while ((my $lig, my $glyph2) = each %ligs) {
#		    $ligatures{$lig} = $n . " " . $glyph2;
#		}
	    }
	}
    }
}
close(AFM);

# read the DESC file

my ($sizescale, $resolution, $unitwidth);
$sizescale = 1;

open(DESC, $desc) || open(DESC, $sys_desc) ||
    die "$prog: can't open \`$desc' or \`$sys_desc': $!\n";
while (<DESC>) {
    next if /^#/;
    chop;
    my @field = split(' ');
    next if $#field < 0;
    last if $field[0] eq "charset";
    if ($field[0] eq "res") {
	$resolution = $field[1];
    }
    elsif ($field[0] eq "unitwidth") {
	$unitwidth = $field[1];
    }
    elsif ($field[0] eq "sizescale") {
	$sizescale = $field[1];
    }
}
close(DESC);

if ($opt_e) {
    # read the encoding file

    my $sys_opt_e = $groff_sys_fontdir . "/devps/" . $opt_e;
    open(ENCODING, $opt_e) || open(ENCODING, $sys_opt_e) ||
	die "$prog: can't open \`$opt_e' or \`$sys_opt_e': $!\n";
    while (<ENCODING>) {
	next if /^#/;
	chop;
	my @field = split(' ');
	next if $#field < 0;
	if ($#field == 1) {
	    if ($field[1] >= 0 && defined $width{$field[0]}) {
		$encoding[$field[1]] = $field[0];
		$in_encoding{$field[0]} = 1;
	    }
	}
    }
    close(ENCODING);
}

# read the map file

my (%nmap, %map);

open(MAP, $map) || open(MAP, $sys_map) ||
    die "$prog: can't open \`$map' or \`$sys_map': $!\n";
while (<MAP>) {
    next if /^#/;
    chop;
    my @field = split(' ');
    next if $#field < 0;
    if ($#field == 1) {
	if ($field[1] eq "space") {
	    # The PostScript character "space" is automatically mapped
	    # to the groff character "space"; this is for grops.
	    warn "you are not allowed to map to " .
		 "the groff character \`space'";
	}
	elsif ($field[0] eq "space") {
	    warn "you are not allowed to map " .
		 "the PostScript character \`space'";
	}
	else {
	    $nmap{$field[0]} += 0;
	    $map{$field[0], $nmap{$field[0]}} = $field[1];
	    $nmap{$field[0]} += 1;

	    # There is more then one way to make a PS glyph name;
	    # let us try unicode names with `uni' and `u' prefixes.
	    my $utmp = $AGL_to_unicode{$field[0]};
	    if (defined $utmp && $utmp =~ /^[0-9A-F]{4}$/) {
		foreach my $unicodepsname ("uni" . $utmp, "u" . $utmp) {
		    $nmap{$unicodepsname} += 0;
		    $map{$unicodepsname, $nmap{$unicodepsname}} = $field[1];
		    $nmap{$unicodepsname} += 1;
		}
	    }
	}
    }
}
close(MAP);

$italic_angle = $opt_a if $opt_a;


if (!$opt_x) {
    my %mapped;
    my $i = ($#encoding > 256) ? ($#encoding + 1) : 256;
    while (my $ch = each %width) {
	# add unencoded characters
	if (!$in_encoding{$ch}) {
	    $encoding[$i] = $ch;
	    $i++;
	}
	if ($nmap{$ch}) {
	    for (my $j = 0; $j < $nmap{$ch}; $j++) {
		if (defined $mapped{$map{$ch, $j}}) {
		    warn "both $mapped{$map{$ch, $j}} and $ch " .
			 "map to $map{$ch, $j}";
		}
		else {
		    $mapped{$map{$ch, $j}} = $ch;
		}
	    }
	}
	else {
	    my $u = "";		# the resulting groff glyph name
	    my $ucomp = "";	# Unicode string before decomposition
	    my $utmp = "";	# temporary value
	    my $component = "";
	    my $nv = 0;

	    # Step 1:
	    #   Drop all characters from the glyph name starting with the
	    #   first occurrence of a period (U+002E FULL STOP), if any.
	    #   ?? We avoid mapping of glyphs with periods, since they are
	    #   likely to be variant glyphs, leading to a `many ps glyphs --
	    #   one groff glyph' conflict.
	    #
	    #   If multiple glyphs in the font represent the same character
	    #   in the Unicode standard, as do `A' and `A.swash', for example,
	    #   they can be differentiated by using the same base name with
	    #   different suffixes.  This suffix (the part of glyph name that
	    #   follows the first period) does not participate in the
	    #   computation of a character sequence.  It can be used by font
	    #   designers to indicate some characteristics of the glyph.  The
	    #   suffix may contain periods or any other permitted characters.
	    #   Small cap A, for example, could be named `uni0041.sc' or `A.sc'.

	    next if $ch =~ /\./;

	    # Step 2:
	    #  Split the remaining string into a sequence of components,
	    #  using the underscore character (U+005F LOW LINE) as the
	    #  delimiter.

	    while ($ch =~ /([^_]+)/g) {
		$component = $1;

		# Step 3:
		#   Map each component to a character string according to the
		#   procedure below:
		#
		#   * If the component is in the Adobe Glyph List, then map
		#     it to the corresponding character in that list.

		$utmp = $AGL_to_unicode{$component};
		if ($utmp) {
		    $utmp = "U+" . $utmp;
		}

		#   * Otherwise, if the component is of the form `uni'
		#     (U+0075 U+006E U+0069) followed by a sequence of
		#     uppercase hexadecimal digits (0 .. 9, A .. F, i.e.,
		#     U+0030 .. U+0039, U+0041 .. U+0046), the length of
		#     that sequence is a multiple of four, and each group of
		#     four digits represents a number in the set {0x0000 ..
		#     0xD7FF, 0xE000 .. 0xFFFF}, then interpret each such
		#     number as a Unicode scalar value and map the component
		#     to the string made of those scalar values.

		elsif ($component =~ /^uni([0-9A-F]{4})+$/) {
		    while ($component =~ /([0-9A-F]{4})/g) {
			$nv = hex("0x" . $1);
			if ($nv <= 0xD7FF || $nv >= 0xE000) {
			    $utmp .= "U+" . $1;
			}
			else {
			    $utmp = "";
			    last;
			}
		    }
		}

		#   * Otherwise, if the component is of the form `u' (U+0075)
		#     followed by a sequence of four to six uppercase
		#     hexadecimal digits {0 .. 9, A .. F} (U+0030 .. U+0039,
		#     U+0041 .. U+0046), and those digits represent a number
		#     in {0x0000 .. 0xD7FF, 0xE000 .. 0x10FFFF}, then
		#     interpret this number as a Unicode scalar value and map
		#     the component to the string made of this scalar value.

		elsif ($component =~ /^u([0-9A-F]{4,6})$/) {
		    $nv = hex("0x" . $1);
		    if ($nv <= 0xD7FF || ($nv >= 0xE000 && $nv <= 0x10FFFF)) {
			$utmp .= "U+" . $1;
		    }
		}

		# Finally, concatenate those strings; the result is the
		# character string to which the glyph name is mapped.

		$ucomp .= $utmp if $utmp;
	    }

	    # Unicode decomposition
	    while ($ucomp =~ /([0-9A-F]{4,6})/g) {
		$component = $1;
		$utmp = $unicode_decomposed{$component};
		$u .= "_" . ($utmp ? $utmp : $component);
	    }
	    $u =~ s/^_/u/;
	    if ($u) {
		if (defined $mapped{$u}) {
		    warn "both $mapped{$u} and $ch map to $u";
		}
		else {
		    $mapped{$u} = $ch;
		}
		$nmap{$ch} += 1;
		$map{$ch, "0"} = $u;
	    }
	}
    }
}

# Check explicitly for groff's standard ligatures -- many afm files don't
# have proper `L' entries.

my %default_ligatures = (
  "fi", "f i",
  "fl", "f l",
  "ff", "f f",
  "ffi", "ff i",
  "ffl", "ff l",
);

while (my ($lig, $components) = each %default_ligatures) {
    if (defined $width{$lig} && !defined $ligatures{$lig}) {
	$ligatures{$lig} = $components;
    }
}

# print it all out

open(FONT, ">$font") || die "$prog: can't open \`$font' for output: $!\n";
select(FONT);

print("name $font\n");
print("internalname $psname\n") if $psname;
print("special\n") if $opt_s;
printf("slant %g\n", $italic_angle) if $italic_angle != 0;
printf("spacewidth %d\n", conv($width{"space"})) if defined $width{"space"};

if ($opt_e) {
    my $e = $opt_e;
    $e =~ s@.*/@@;
    print("encoding $e\n");
}

if (!$opt_n && %ligatures) {
    print("ligatures");
    while (my $lig = each %ligatures) {
	print(" $lig");
    }
    print(" 0\n");
}

if ($#kern1 >= 0) {
    print("kernpairs\n");

    for (my $i = 0; $i <= $#kern1; $i++) {
	my $c1 = $kern1[$i];
	my $c2 = $kern2[$i];
	if ($nmap{$c1} != 0 && $nmap{$c2} != 0) {
	    for (my $j = 0; $j < $nmap{$c1}; $j++) {
		for (my $k = 0; $k < $nmap{$c2}; $k++) {
		    if ($kernx[$i] != 0) {
			printf("%s %s %d\n",
			       $map{$c1, $j},
			       $map{$c2, $k},
			       conv($kernx[$i]));
		    }
		}
	    }
	}
    }
}

my ($asc_boundary, $desc_boundary, $xheight, $slant);

# characters not shorter than asc_boundary are considered to have ascenders

$asc_boundary = 0;
$asc_boundary = $height{"t"} if defined $height{"t"};
$asc_boundary -= 1;

# likewise for descenders

$desc_boundary = 0;
$desc_boundary = $depth{"g"} if defined $depth{"g"};
$desc_boundary = $depth{"j"} if defined $depth{"g"} && $depth{"j"} < $desc_boundary;
$desc_boundary = $depth{"p"} if defined $depth{"p"} && $depth{"p"} < $desc_boundary;
$desc_boundary = $depth{"q"} if defined $depth{"q"} && $depth{"q"} < $desc_boundary;
$desc_boundary = $depth{"y"} if defined $depth{"y"} && $depth{"y"} < $desc_boundary;
$desc_boundary -= 1;

if (defined $height{"x"}) {
    $xheight = $height{"x"};
}
elsif (defined $height{"alpha"}) {
    $xheight = $height{"alpha"};
}
else {
    $xheight = 450;
}

$italic_angle = $italic_angle*3.14159265358979323846/180.0;
$slant = sin($italic_angle)/cos($italic_angle);
$slant = 0 if $slant < 0;

print("charset\n");
for (my $i = 0; $i <= $#encoding; $i++) {
    my $ch = $encoding[$i];
    if (defined $ch && $ch ne "" && $ch ne "space") {
	$map{$ch, "0"} = "---" if !defined $nmap{$ch} || $nmap{$ch} == 0;
	my $type = 0;
	my $h = $height{$ch};
	$h = 0 if $h < 0;
	my $d = $depth{$ch};
	$d = 0 if $d < 0;
	$type = 1 if $d >= $desc_boundary;
	$type += 2 if $h >= $asc_boundary;
	printf("%s\t%d", $map{$ch, "0"}, conv($width{$ch}));
	my $italic_correction = 0;
	my $left_math_fit = 0;
	my $subscript_correction = 0;
	if (defined $opt_i) {
	    $italic_correction = $right_side_bearing{$ch} + $opt_i;
	    $italic_correction = 0 if $italic_correction < 0;
	    $subscript_correction = $slant * $xheight * .8;
	    $subscript_correction = $italic_correction if
		$subscript_correction > $italic_correction;
	    $left_math_fit = $left_side_bearing{$ch} + $opt_i;
	    if (defined $opt_m) {
		$left_math_fit = 0 if $left_math_fit < 0;
	    }
	}
	if (defined $italic_correction{$ch}) {
	    $italic_correction = $italic_correction{$ch};
	}
	if (defined $left_italic_correction{$ch}) {
	    $left_math_fit = $left_italic_correction{$ch};
	}
	if (defined $subscript_correction{$ch}) {
	    $subscript_correction = $subscript_correction{$ch};
	}
	if ($subscript_correction != 0) {
	    printf(",%d,%d", conv($h), conv($d));
	    printf(",%d,%d,%d", conv($italic_correction),
		   conv($left_math_fit),
		   conv($subscript_correction));
	}
	elsif ($left_math_fit != 0) {
	    printf(",%d,%d", conv($h), conv($d));
	    printf(",%d,%d", conv($italic_correction),
		   conv($left_math_fit));
	}
	elsif ($italic_correction != 0) {
	    printf(",%d,%d", conv($h), conv($d));
	    printf(",%d", conv($italic_correction));
	}
	elsif ($d != 0) {
	    printf(",%d,%d", conv($h), conv($d));
	}
	else {
	    # always put the height in to stop groff guessing
	    printf(",%d", conv($h));
	}
	printf("\t%d", $type);
	printf("\t%d\t%s\n", $i, $ch);
	if (defined $nmap{$ch}) {
	    for (my $j = 1; $j < $nmap{$ch}; $j++) {
		printf("%s\t\"\n", $map{$ch, $j});
	    }
	}
    }
    if (defined $ch && $ch eq "space" && defined $width{"space"}) {
	printf("space\t%d\t0\t%d\tspace\n", conv($width{"space"}), $i);
    }
}

sub conv {
    $_[0]*$unitwidth*$resolution/(72*1000*$sizescale) + ($_[0] < 0 ? -.5 : .5);
}
