var IMServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
var pIIMManager  = IMServiceClass.getService(Components.interfaces.nsIIMManager)
var lastRadio = null;
var lastViewRadio = null;
var allEnums = Components.interfaces.nsAimPrivacyModes;
var stateEnums = Components.interfaces.nsAimOnlineStates;
var globalPrivacyObject = pIIMManager.QueryInterface(Components.interfaces.nsIAimPrivacy);
var MozPreferences = Components.classes['@mozilla.org/preferences-service;1'];
MozPreferences = MozPreferences.getService();
MozPreferences = MozPreferences.QueryInterface(Components.interfaces.nsIPrefBranch);

//connection panel
var connLinks = new Object();
connLinks.ConnectionName = "";
connLinks.SessionType    = "";
connLinks.Host           = "";
connLinks.Port           = "";
connLinks.ProxyHost      = "";
connLinks.ProxyPort      = "";
connLinks.ProxyUser      = "";
connLinks.ProxyPassword  = "";
connLinks.ProxyProtocol  = "";
connLinks.IsProxy        = false;
connLinks.ConnectionType = 0;

//end connection panel

function getString(name)
{
    if (aimStringBundle()){
                return aimStringBundle().GetStringFromName(name);
        }
        else{
            return "";
        }
}


var awayarg;

function EditAwayMessageOnLoad()
{
  var nameItem = document.getElementById("awayMessageName");
  var textItem = document.getElementById("awayMessageText");

  nameItem.value = window.arguments[1];
  textItem.value = window.arguments[2];
  nameItem.focus();

  if (window.arguments[1] == "" && window.arguments[2] == "")
    window.title= aimString("away.newmsg");
  else
    window.title= aimString("away.editmsg");

  // construct some of the static labels here; had problems placing
  // '%' into an DTD ENTITY

  var labelItem = document.getElementById("editAwayMessageSpecial1");
  var stringItem = getString( "editAwayMessageSpecial1" );
  labelItem.setAttribute( "value", stringItem );
  labelItem = document.getElementById("editAwayMessageSpecial2");
  stringItem = getString( "editAwayMessageSpecial2" );
  labelItem.setAttribute( "value", stringItem );
  labelItem = document.getElementById("editAwayMessageSpecial3");
  stringItem = getString( "editAwayMessageSpecial3" );
  labelItem.setAttribute( "value", stringItem );
  labelItem = document.getElementById("editAwayMessageSpecial4");
  stringItem = getString( "editAwayMessageSpecial4" );
  labelItem.setAttribute( "value", stringItem );

  // set the OK, Cancel callbacks
  awayarg = window.arguments[3];
  if (awayarg) {
    document.getElementById("savelater").removeAttribute("hidden");
    var imaway = aimString("msg.imaway");
    document.getElementById("ok").setAttribute("label", imaway);
  }
  else {
    document.getElementById("savelater").setAttribute("hidden", "true");
  }
  if (nameItem.value == "")
    doSetOKCancel(AddAwayMessageOnOK, 0);
  else
    doSetOKCancel(EditAwayMessageOnOK, 0);
}

function PrefIMAwayOnLoad()
{
  if((!IsSignedOn()) || (isIcq())) {
    var offlinetxt = aimString("away.plsfirstsignon");
    var element = document.getElementById("AwayOffline");
    var textNode = document.createTextNode(offlinetxt);
    element.appendChild(textNode);
    document.getElementById("AwayGroup").setAttribute("hidden", "true");
    document.getElementById("AwayMsgs").setAttribute("hidden", "true");
    return;
  }

  document.getElementById("AwayOffline").setAttribute("hidden", "true");
  GetRDFService();
  sidebar_file = GetRdfFileUrl("default-messages.rdf", "dm.rdf");  
  datasource = RDF.GetDataSource(sidebar_file);
  var tree = document.getElementById("AwayMessages");
  tree.database.AddDataSource(datasource);
  tree.setAttribute('ref', tree.getAttribute('ref'));
}

/*
 * Function:  PrefIMStyleOnload ()
 * Arguments:
 * Return:  None
 * Description:  This function intializes the pref-IM_style.xul panel
 *               In paticular the text and background color widgets
 *               are filled in and the Special Text Styles are turned
 *               on or off depending on the pref.
 *
 * Author: jelwell@netscape.com
*/
function PrefIMStyleOnload()
{
  var textData = document.getElementById("textColorData");
  var backgroundData = document.getElementById("backgroundColorData");
  var customTextColor = textData.getAttribute("value");
  var customBackgroundColor = backgroundData.getAttribute("value");

  if ( !customBackgroundColor || customBackgroundColor == "")
    customBackgroundColor = "#FFFFFF";
  if ( !customTextColor || customTextColor == "")
    customTextColor = "#000000";
  setColorWell("textCW", customTextColor);
  setColorWell("backgroundCW", customBackgroundColor);

  textData.setAttribute("value", customTextColor); 
  backgroundData.setAttribute("value", customBackgroundColor); 

  SwapSpecialStyles();
}

/*
 * Function:  SwapSpecialStyles()
 * Arguments:
 * Return:  None
 * Description:  This function is used to toggle the special
 *               text style checkboxes, on and off depending
 *               on the pref and current setting.
 *
 * Author: jelwell@netscape.com
*/
function SwapSpecialStyles()
{
  if (document.getElementById("textstyles").getAttribute("value") == "1")
  {
    document.getElementById("bold").removeAttribute("disabled");
    document.getElementById("italics").removeAttribute("disabled");
    document.getElementById("underline").removeAttribute("disabled");
    
  }
  else
  {
    document.getElementById("bold").setAttribute("disabled", "true");
    document.getElementById("italics").setAttribute("disabled", "true");
    document.getElementById("underline").setAttribute("disabled", "true");
    
  }
}

/*
 * Function:  GetColorAndUpdate(ColorWellID)
 * Arguments:
 *    ColorWellID -- id of the color spacer inside the button.
 * Return:  None
 * Description:  This function is used to change the background
 *               color of the spacer based on prefs.
 *
 * Author: jelwell@netscape.com
*/
function GetColorAndUpdate(ColorWellID)
{
  var colorObj = new Object;
  var colorWell = document.getElementById(ColorWellID);
  var customTextColor = document.getElementById("textColorData").getAttribute("value"); 
  var customBackgroundColor = document.getElementById("backgroundColorData").getAttribute("value"); 
  if (!colorWell) return;

  // Don't allow a blank color, i.e., using the "default"
  colorObj.NoDefault = true;

  switch( ColorWellID )
  {
    case "textCW":
      colorObj.Type = "Text";
      colorObj.TextColor = customTextColor;
      break;
    case "backgroundCW":
      colorObj.Type = "Page";
      colorObj.PageColor = customBackgroundColor;
      break;
  }

  window.openDialog("chrome://editor/content/EdColorPicker.xul", "_blank", "chrome,close,titlebar,modal", "", colorObj);

  // User canceled the dialog
  if (colorObj.Cancel)
    return;

  var color = "";
  switch( ColorWellID )
  {
    case "textCW":
      color = customTextColor = colorObj.TextColor;
      document.getElementById("textColorData").setAttribute("value", color); 
      break;
    case "backgroundCW":
      color = customBackgroundColor = colorObj.BackgroundColor;
      document.getElementById("backgroundColorData").setAttribute("value", color);
      break;
  }
  setColorWell(ColorWellID, color); 
//  SetColorPreview(ColorWellID, color);
}


// XXXVISHy 
// Add a user to the allow or deny list. top.addMode defines which list

function GetUserAdd()
{
        var fldUserName = top.document.getElementById("fldUserName");
        var pIAimPrivacy = aimPrivacy();
        var name = fldUserName.value;
        if ( name && name != "" ) {
           if ( top.addMode == "Allow" ) {
              pIAimPrivacy.AllowListAdd( name );
           }
        else if ( top.addMode == "Deny" ) {
            pIAimPrivacy.DenyListAdd( name );
        }
        //pIAimPrivacy.UpdateStorage();
           top.opener.updateListBoxSelection(top.addMode);
           top.window.close();
        }
}



function updateListBoxSelection(mode){
   var targetListBox = document.getElementById(mode);
   var targetListBoxSelectedCount = targetListBox.selectedCount
   var targetListBoxRows = targetListBox.listBoxObject.getRowCount();
   if(targetListBoxRows >0 && targetListBoxSelectedCount <1){
      targetListBox.selectedIndex=0;
   }

}

/* 
 * Name: StandardURL
 *
 * Arguments: URI string, e.g., chrome://foo/bar
 *
 * Description: obtains an instance of nsIURL and sets the spec to the passed
 * uri. Returns the nsIURL instance.
 *
 */

function StandardURL(s) {
    var clazz = Components.classes["@mozilla.org/network/standard-url;1"];
    var iface = Components.interfaces.nsIURL;
    var obj = clazz.createInstance(iface);
    obj.spec = s;
    return obj;
} 

/* 
 * Name: Sound
 *
 * Arguments: none 
 *
 * Description: Creates and returns an instance of nsISound
 *
 */

function Sound() {
    var clazz = Components.classes["@mozilla.org/sound;1"];
    var iface = Components.interfaces.nsISound;
    var obj = clazz.createInstance(iface);
    return obj;
}

/* 
 * Name: PlaySound
 *
 * Arguments: chrome URI to a sound file
 *
 * Description: Called by onclick handler for speaker titled buttons in
 * the sound preferences panel for IM.
 *
 */

function PlaySound( myURIPref )
{
    var sound = new Sound();
    var myURI;

    try {
        myURI = aimPrefsManager().GetCharPref( myURIPref , null, false );
    }
    catch(e) {
        try {
            myURI = aimPrefsManager().GetCharPref( myURIPref , null, true); // get the global one if the per screen name doesnt work
        }
        catch(e) {
            return;
        }         
    }        

    var uri = new StandardURL(myURI);
    if ( sound != undefined && sound != null && uri != undefined && uri != null ) {
        try {
            sound.play( uri );
        }
        catch( e ) {
            // device may not support sound, so ignore
        }
    }    
}

/* away messages */

var datasource = null;
var RDF = null;
var awayMessages = null;

function
GetRDFService()
{
    if ( RDF == null ) {
        RDF=aimRDF();
    }
}

function
RemoveTarget( msgName )
{
    GetRDFService();

    var messages_file = GetRdfFileUrl("default-messages.rdf", "dm.rdf"); 
    var datasource = RDF.GetDataSource(messages_file);

    var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
      container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
      container.Init(datasource, RDF.GetResource("NC:AIM/AwayMessageBag"));

    var elements = container.GetElements();
    var target, node;
    var nameResource = 
                RDF.GetResource("http://home.netscape.com/NC-rdf#MsgName");
    while ( elements.hasMoreElements() ) {
        node = elements.getNext();
        if ( node ) 
            target = datasource.GetTarget( node, nameResource, 
                true );
        if ( target ) 
            target = target.QueryInterface(Components.interfaces.nsIRDFLiteral);
        if ( target && target.Value == msgName ) {
            container.RemoveElement( node, true );
            datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
        }
    }
    return null;
}

function
SetAwayMessageTarget( msgName, msgText )
{
    GetRDFService();

    var messages_file = GetRdfFileUrl("default-messages.rdf", "dm.rdf"); 
    var datasource = RDF.GetDataSource(messages_file);

    var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
      container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
      container.Init(datasource, RDF.GetResource("NC:AIM/AwayMessageBag"));

    var elements = container.GetElements();
    var nametarget, texttarget, node;
    var nameResource = 
                RDF.GetResource("http://home.netscape.com/NC-rdf#MsgName");
    var textResource = 
                RDF.GetResource("http://home.netscape.com/NC-rdf#MsgText");
    while ( elements.hasMoreElements() ) {
        node = elements.getNext();
        if ( node ) 
            nametarget = datasource.GetTarget( node, nameResource, 
                true );
        if ( nametarget ) 
            nametarget = nametarget.QueryInterface(Components.interfaces.nsIRDFLiteral);
        if ( nametarget && nametarget.Value == msgName ) {
            texttarget = datasource.GetTarget( node, textResource, 
                true );
            if ( texttarget ) 
                texttarget = texttarget.QueryInterface(Components.interfaces.nsIRDFLiteral);
            if ( texttarget ) {
                var newText = RDF.GetLiteral(msgText);
                datasource.Change( node, textResource,
                    texttarget, newText);
                datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
            }
            break;
        }
    }
}

//XXXVISHY - two 

function modeToRadio(mode)
{
  switch(mode) {
    case allEnums.AllowAll:
      document.getElementById("allowradio").setAttribute("selected","true");
      document.getElementById("denyradio").removeAttribute("selected");
      document.getElementById("allowmenulist").selectedIndex = 0;
      return document.getElementById("aim_privacy_contact_allowallusers"); 
      break;
    case allEnums.AllowBuddies:
      document.getElementById("allowradio").setAttribute("selected","true");
      document.getElementById("denyradio").removeAttribute("selected");
      document.getElementById("allowmenulist").selectedIndex = 1;
      return document.getElementById("aim_privacy_contact_allowbuddylistusers"); 
      break;
    case allEnums.AllowList:
      document.getElementById("allowradio").setAttribute("selected","true");
      document.getElementById("denyradio").removeAttribute("selected");
      document.getElementById("allowmenulist").selectedIndex = 2;
      return document.getElementById("aim_privacy_contact_allowonlylist"); 
      break;
    case allEnums.DenyAll:
      document.getElementById("denyradio").setAttribute("selected","true");
      document.getElementById("allowradio").removeAttribute("selected");
      document.getElementById("denymenulist").selectedIndex = 0;
      return document.getElementById("aim_privacy_contact_blockallusers"); 
      break;
    case allEnums.DenyList:
      document.getElementById("denyradio").setAttribute("selected","true");
      document.getElementById("allowradio").removeAttribute("selected");
      document.getElementById("denymenulist").selectedIndex = 2;
      return document.getElementById("aim_privacy_contact_blocklistusers"); 
      break;
    case allEnums.DenyAim:
      document.getElementById("denyradio").setAttribute("selected","true");
      document.getElementById("allowradio").removeAttribute("selected");
      document.getElementById("denymenulist").selectedIndex = 1;
      return document.getElementById("aim_privacy_contact_blockaimusers"); 
      break;
    default:
      document.getElementById("allowradio").setAttribute("selected","true");
      document.getElementById("denyradio").removeAttribute("selected");
      document.getElementById("allowmenulist").selectedIndex = 0;
      return document.getElementById("aim_privacy_contact_allowallusers"); 
      break;
  }
}

function privacyModeRadio(mode)
{
  // this should not be needed, but believe me dont remove it 
  // otherwise radio UI can show two things selected ;-)
  lastRadio.checked = false;
  lastRadio = modeToRadio(mode);
  lastRadio.checked = true;
  parent.lastPrivacyMode = mode;
}

function privacyChatInvites(value)
{
  parent.lastChatInvites = value;
}

function privacyIdle(value)
{
  parent.lastIdle = value;
}

function privacyMobile(value)
{
  parent.lastMobile = value;
}

function privacyTyping(value)
{
  parent.lastTyping = value;
}

function viewToRadio(view)
{
  dump("in function viewToRadio\n" + view);

    switch(view) {
    case '1':
        return document.getElementById("nodisclosure"); 
        break;
    case '2':
        return document.getElementById("limiteddisclosure"); 
        break;
    case '3':
        return document.getElementById("fulldisclosure"); 
        break;
    default:
        dump("Bad privacy view\n");
        return document.getElementById("nodisclosure"); 
        break;
    }
}

function privacyViewRadio(view)
{
  dump("privacyModeRadio\n");

  // this should not be needed, but believe me dont remove it 
  // otherwise radio UI can show two things selected ;-)
  //lastViewRadio.checked = false;
  //lastViewRadio = viewToRadio(view);
  dump ("lastViewRadio is " + lastViewRadio + "\n");
  //lastViewRadio.checked = true;
  parent.lastPrivacyView = view;

  dump ("lastPrivacyView is " + parent.lastPrivacyView + "\n");
}

// onload handler for privacy panel. grab the privacy mode enums, and register
// AssertChanges with prefwindow so we get called on OK presses.

AdminCallback = new Object();
AdminCallback.OnRequestInfoComplete = function(type,info)
{
    dump("On RequestInfoComplete\n");

    switch (type) { 
    case Components.interfaces.nsIAimAdminInfo.RegistrationStatusPreference:
        dump("info is " + info + "\n");
        parent.lastPrivacyView = info;

        dump("Got the aim privacy view\n");
        lastViewRadio = viewToRadio(parent.lastPrivacyView);
    
        if ( lastViewRadio != undefined && lastViewRadio != null) {
            var privacyViewElement = document.getElementById("privacyView");
            privacyViewElement.selectedItem = lastViewRadio;
        }
        break;
    default:
        break;
    }
}
AdminCallback.OnRequestInfoError = function(pErrMsg)
{
    dump("OnRequestInfoError\n");
}

adminGetterCallback = new Object();

adminGetterCallback.ExecuteIfReady = function()
{
    dump("about to get the disclosure level\n");
    aimAdminManager().RequestInfoRegistrationStatusPreference(AdminCallback);
}

function DisablePrivacyUI()
{
  document.getElementById("contact").setAttribute("hidden", "true");
  document.getElementById("whocancontact").setAttribute("hidden", "true");
  document.getElementById("whocancontact1").setAttribute("hidden", "true");
}


function IsSignedOn()
{
    var state = aimSession().CurrentState;
dump( "state is " + state + " \n" );

    if ( state == stateEnums.Online || state == stateEnums.OnlineAway )
        return true;
    return false;
}

function PrefIMPrivacyOnLoad()
{
  var hideprivacy = false;
  var offlinetxt;
  if((!IsSignedOn()) || (isIcq())) {
    offlinetxt = aimString("msg.offline");
    hideprivacy = true;
  }
  else {
    var feedbag = aimFeedbagManager();
    var flag = feedbag.CheckFeedbag();
    if (!flag) {
      //feedbag is down, hide all the fields. you cannot do any thing in privacy pane without feedbag.
      offlinetxt = aimString("msg.feedbagdown");
      hideprivacy = true;
    }
  }

  if (hideprivacy) {
    var element = document.getElementById("privacyOfflineIntro");
    var textNode = document.createTextNode(offlinetxt);
    element.appendChild(textNode);
    DisablePrivacyUI();
    return;
  }

  document.getElementById("privacyOfflineIntro").setAttribute("hidden", "true");
  parent.hPrefWindow.registerOKCallbackFunc( AssertPrivacyChanges );
  var sessionType =aimPrefsManager().GetIntPref("aim.session.sessiontype", null, false);
  if(sessionType == 0) {
    var tree = document.getElementById("Allow");
    tree.database.AddDataSource(aimRDF().GetDataSource("rdf:AIM"));
    tree.setAttribute('ref', tree.getAttribute('ref'));
    var tree = document.getElementById("Deny");
    tree.database.AddDataSource(aimRDF().GetDataSource("rdf:AIM"));
    tree.setAttribute('ref', tree.getAttribute('ref'));
  }

  var priv = aimPrivacy();
  // do it only the first time!
  if (parent.lastPrivacyMode == undefined)
    parent.lastPrivacyMode = priv.PrivacyMode;

  lastRadio = modeToRadio(parent.lastPrivacyMode);

  if ( parent.lastChatInvites != undefined && parent.lastChatInvites != null) {
    var checkbox = document.getElementById("chatInvites");
    if ( checkbox != undefined && checkbox != null)
      checkbox.setAttribute("selected",parent.lastChatInvites);
  }


  var loggedin = true;

  if (loggedin && (parent.lastPrivacyView == undefined))
    aimAdminManager().ExecuteIfReady(adminGetterCallback);
  
  var prefmask = feedbag.GetBuddyPrefs();
  if (prefmask & Components.interfaces.nsAimBuddyPrefs.DiscloseIdleTime) {
    document.getElementById("idle").checked = true;
    parent.lastIdle = true;
  }
  else
    parent.lastIdle = false;

  var mobilepresence = feedbag.GetBosPrefs();
  if (mobilepresence & Components.interfaces.nsAimBosPrefs.HideWireless) {
    document.getElementById("mobile").checked = true;
    parent.lastMobile = true;
  }
  else
    parent.lastMobile = false;

  if ( prefmask & Components.interfaces.nsAimBuddyPrefs.DiscloseTyping) {
    document.getElementById("showtyping").checked = true;
    parent.lastTyping = true;
  }
  else
    parent.lastTyping = false;

  updateListBoxSelection("Allow");
  updateListBoxSelection("Deny");
}

function PrefIMPrivacyOnUnload() 
{
    // nothing for now
}

// grab a screenname from the user.

function PostGetUserDlg( which )
{ 
    openDialog("chrome://aim/content/pref-IM_getuser.xul", "", 
        "modal=yes,chrome", which);
}

// delete the screenname entered by the user from the allow or deny list.
// "which" indicates which list to purge from

function DeleteFromList( which )
{
    var listbox = document.getElementById(which);
    var pIAimPrivacy = aimPrivacy();
    var selectedUser;
    
        
    for (var i = 0; i <= listbox.selectedItems.length; i++) {
      selectedUser = listbox.selectedItems[i].getAttribute("label");
      if ( which == "Allow" ) {
          pIAimPrivacy.AllowListRemove( selectedUser );
          }
      else if ( which == "Deny" ) {
          pIAimPrivacy.DenyListRemove( selectedUser );
          }
      updateListBoxSelection(which);
      break;
    }
}

// onload handler for the dialog used to get a screenname from the user

function GetUserOnLoad()
{
        doSetOKCancel(GetUserAdd, 0);
    top.addMode = window.arguments[0];
    document.getElementById("fldUserName").focus();
}

// called when OK button is pressed in privacy mode preferences panel. Figure
// out what changed, communicate this to AIM Glue backend

function AssertPrivacyChanges()
{
  // We cannot use global variables as this is called in the
  // context of the Parent window much later!!
  var IMServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
  var pIIMManager  = IMServiceClass.getService(Components.interfaces.nsIIMManager)
  var lastRadio = null;
  var allEnums = Components.interfaces.nsAimPrivacyModes;
  var pIAimPrivacy = pIIMManager.QueryInterface(Components.interfaces.nsIAimPrivacy)

  if ( pIAimPrivacy == undefined || pIAimPrivacy == null )
    return;

  // This has been simplified and made correct
  pIAimPrivacy.PrivacyMode = parent.lastPrivacyMode;

  var tvalues = false;
  var pAimAdmin = pIIMManager.QueryInterface(Components.interfaces.nsIAimAdminManager);
  if ( pAimAdmin == undefined || pAimAdmin == null )
    return;

  adminSetterCallback = new Object();
  adminSetterCallback.ExecuteIfReady = function()
  {
    // this kinda code is dangerous -- should not glom so many
    // things that can fail into one statement XXX
    Components.classes['@netscape.com/aim/IMManager;1'].getService(Components.interfaces.nsIIMManager).QueryInterface(Components.interfaces.nsIAimAdminManager).ChangeRegistrationStatusPreference(null,parent.lastPrivacyView);
  }

  pAimAdmin.ExecuteIfReady(adminSetterCallback);
  var pAimPrefs =  pIIMManager.QueryInterface(Components.interfaces.nsIPrefsManager);
  if (parent.lastChatInvites != undefined)
    pAimPrefs.SetBoolPref("aim.chat.unavailable", parent.lastChatInvites, null, false);

  var chatInvite_pref=false;
  try {
    chatInvite_pref= pAimPrefs.GetBoolPref("aim.chat.unavailable", null, false);
  }
  catch (ex) {
    dump("chat announce pref could not be read\n");
    chatInvite_pref = false;
  }
  pChatManager= pIIMManager.QueryInterface(Components.interfaces.nsIAimChatManager);
  // Suresh: Setting it to complement coz the pref is aim.chat._un_available. Gee...This is confusing..heh.
  pChatManager.SetAvailableForChat(!chatInvite_pref);

  var feedbag = aimFeedbagManager();
  
  try {
    prefmask = feedbag.GetBuddyPrefs();
    var typingmask = Components.interfaces.nsAimBuddyPrefs.DiscloseTyping;
    var idlemask = Components.interfaces.nsAimBuddyPrefs.DiscloseIdleTime;
    var typingset=prefmask & typingmask;
    var idleset=prefmask & idlemask;
    // User is setting it only now, the typing pref was not set before
    if (parent.lastTyping  && !(typingset)) {
      prefmask += typingmask;
    }
    // User is clearing it, even though the typing pref was set to begin with
    else
      if (!parent.lastTyping  && (typingset)) {
        prefmask -= typingmask;
      } 
    // User is setting it only now, the idle pref was not set before
    if (parent.lastIdle  && !(idleset)) {
      prefmask += idlemask;
    }
    // User is clearing it, even though the idle pref was set to begin with
    else
      if (!parent.lastIdle  && (idleset)) {
        prefmask -= idlemask;
        aimSession().AimIdleStop(); 
      } 
    feedbag.SetBuddyPrefs(prefmask);
  }

  catch (ex) {}

  //Mobile stuff
  if (parent.lastMobile)
    feedbag.SetBosPrefs(Components.interfaces.nsAimBosPrefs.HideWireless);
  else
    feedbag.SetBosPrefs(0);
  
    

  return;

}


function
FindAwayMessageTargetByName( msgName )
{
    GetRDFService();

    var messages_file = GetRdfFileUrl("default-messages.rdf", "dm.rdf");  
    var datasource = RDF.GetDataSource(messages_file);

    var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
      container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
      container.Init(datasource, RDF.GetResource("NC:AIM/AwayMessageBag"));

    var elements = container.GetElements();
    var target, node;
    var nameResource = 
                RDF.GetResource("http://home.netscape.com/NC-rdf#MsgName");
    while ( elements.hasMoreElements() ) {
        node = elements.getNext();
        if ( node ) 
            target = datasource.GetTarget( node, nameResource, 
                true );
        if ( target ) 
            target = target.QueryInterface(Components.interfaces.nsIRDFLiteral);
        if ( target && target.Value == msgName ) 
            return target.Value;
    }
    return null;
}

function
EditAwayMessageOnOK()
{
    var nameItem = document.getElementById("awayMessageName");
    var textItem = document.getElementById("awayMessageText");
    var nameValue = null;
    var textValue = null;

    if ( !nameItem || nameItem == undefined ) 
        return;
    if ( !textItem || textItem == undefined ) 
        return;
    nameValue = nameItem.value;
    textValue = textItem.value;
    if ( nameValue == "" ) {
        alert(getString("away.EnterLabel"));
        return;
    }
    
    if ( textValue == "" ) {
        alert(getString("away.EnterMessage"));
        return;
    }

    if ( textValue.length > 900 ) {
        alert(getString("away.TooLongMessage"));
        return;
    }

    var target = FindAwayMessageTargetByName( nameValue );
    if ( target == null ) {
        retval = confirm(getString("away.DoesNotExist"));
        if ( retval == true ) 
            AssertAwayMessage( nameValue, textValue ); 
        else
            return;
    } else 
        SetAwayMessageTarget( nameValue, textValue )
    top.window.close();
}

function AddAwayMessageOnOK()
{
  var nameItem = document.getElementById("awayMessageName");
  var textItem = document.getElementById("awayMessageText");
  var nameValue = null;
  var textValue = null;

  if ( !nameItem || nameItem == undefined ) 
    return;
  if ( !textItem || textItem == undefined ) 
    return;
  nameValue = nameItem.value;
  textValue = textItem.value;
  if ( nameValue == "" ) {
    alert(getString("away.EnterLabel"));
    return;
  }
  if ( textValue == "" ) {
    alert(getString("away.EnterMessage"));
    return;
  }

  if ( textValue.length > 900 ) {
    alert(getString("away.TooLongMessage"));
    return;
  }

  if (awayarg) {
    var locateManager = aimLocateManager();
    locateManager.SetUserInfoAwayMessage(textValue);
    if (!document.getElementById('savelater').checked) {
      top.window.close();
      return;
    }
  }

  if ( FindAwayMessageTargetByName( nameValue ) != null ) {
    // ask them if they would like to overwrite (i.e., 
    // turn this into an edit).
    var response = confirm(getString("away.AlreadyExists"));
    if (response) {
      EditAwayMessageOnOK();
      return;
    } 
    else {
      alert(getString("away.EnterLabel"));
      return;
    }
  }

  AssertAwayMessage( nameValue, textValue ); 
  top.window.close();
}

function
AssertAwayMessage( nameValue, textValue )
{
    GetRDFService();

    var newmsg = RDF.GetAnonymousResource();
    var messages_file = GetRdfFileUrl("default-messages.rdf", "dm.rdf");  

    var datasource = 
        RDF.GetDataSource(messages_file);
    datasource.Assert(newmsg, 
        RDF.GetResource("http://home.netscape.com/NC-rdf#MsgName"),
            RDF.GetLiteral(nameValue), true);
    datasource.Assert(newmsg, 
        RDF.GetResource("http://home.netscape.com/NC-rdf#MsgText"),
        RDF.GetLiteral(textValue), true);

    var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
      container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
      container.Init(datasource, RDF.GetResource("NC:AIM/AwayMessageBag"));

    container.AppendElement(newmsg);
    datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
}

function
AddAwayMessage()
{
// title is window.arguments[1];
// content is window.arguments[2];

     window.openDialog("chrome://aim/content/AddAwayMessage.xul","_blank", "chrome,close,titlebar,modal", "", "", "");
}

function
EditAwayMessage()
{
// title is window.arguments[1];
// content is window.arguments[2];

    var msgName, msgText;
    var response;

    response = FindSelectedAwayMessage();
    if ( response == null ) {
        alert(getString("away.PleaseSelectToEdit"));
        return;
    } else {
        msgName = response.msgName;
        msgText = response.msgText;
    }

     window.openDialog("chrome://aim/content/AddAwayMessage.xul","_blank", "chrome,close,titlebar, modal", "", msgName, msgText);
}

function
RemoveAwayMessage()
{
    var msgName, msgText;
    var response;

    response = FindSelectedAwayMessage();
    if ( response == null ) {
        alert(getString("away.PleaseSelectToRemove"));
        return;
    } 

    answer = confirm(getString("away.AreYouSure").replace(/%AwayMsg%/,response.msgName));
    if ( answer == true ) 
        RemoveTarget( response.msgName );
}

function
FindSelectedAwayMessage()
{
        var selection;
    var tree = document.getElementById("AwayMessages");

    var response = new Object();

        if ( tree )
                selection = tree.contentView.getItemAtIndex(tree.currentIndex);

        if ( selection) {
            response.msgName = selection.getAttribute("MsgName");
        response.msgText = selection.getAttribute("MsgText");

        return response;
    }
    return null;
}


 //XXXVISHY - per screen name stuff
  
function getCurrentScreenName()
{
  var myaimSession = aimSession();
  if (myaimSession) {
    return myaimSession.CurrentScreenName;
  }
  else
    return "";
}

// XXXVISHY - the aimPreferenceOnload function MUST be called in the
// onload handler of every aim preference panel so as to do the
// per screen name munging
 
/* every element has: prefstring, preftype, preattribute, pref (true/false), prefscope(0,1,2)

preftype, a type of value to retrieve;
preattribute, a type of element attribute to assign


preftype = true, if it is for preference element only
prefscope = 0, PER_SN,
prefscope = 2, SESSION_GLOBAL,
prefscope = 1, GEN_GLOBAL

*/

function aimPreferenceOnload()
 {
  dump("starting aimPreferenceOnload\n");   
	var aimprefs = document.getElementsByAttribute("pref", "true");
	var sN;
	var qPreference;
	var curDefPref;
	var panelType = 0;
     
    for (var i = 0 ; i < aimprefs.length ; i++) {
 		var preference = aimprefs[i].getAttribute("prefstring");
		var curprefScope = aimprefs[i].getAttribute("prefscope");
dump("curprefScope=" + curprefScope + "\n");		
		if (curprefScope == 2 || curprefScope == 1) {
		
			if (panelType == 0)
				qPreference = preference + ".aim";
			else //panelType == 2
			    qPreference = preference + ".icq";
						
		}
		else { // scope == 0, PER_SN

          if (panelType == aimPrefsManager().GetSessionType()) 
          {
			sN = getCurrentScreenName() + "."; 
			qPreference = sN + preference;

		    if (MozPreferences.getPrefType(qPreference) == Components.interfaces.nsIPrefBranch.PREF_INVALID)
				 {
			// first time with this pref, so create a per screen name copy
				if (MozPreferences.getPrefType(preference) == Components.interfaces.nsIPrefBranch.PREF_INVALID)
				 {
				// "preference" is not default name, create default name
					
					if (panelType == 0)
						curDefPref = preference + ".aim";
					else //panelType == 2
					    curDefPref = preference + ".icq";
				}
                else {
					curDefPref = preference;
                }
dump("curDefPref=" + curDefPref + "\n");

				switch (MozPreferences.getPrefType(curDefPref)) {
				case Components.interfaces.nsIPrefBranch.PREF_STRING:
				var sPref = MozPreferences.getCharPref(curDefPref);		
				MozPreferences.setCharPref(qPreference, sPref);
				break;
				case Components.interfaces.nsIPrefBranch.PREF_INT:
				var iPref = MozPreferences.getIntPref(curDefPref);
				MozPreferences.setIntPref(qPreference, iPref);
				break;
				case Components.interfaces.nsIPrefBranch.PREF_BOOL:
				var bPref = MozPreferences.getBoolPref(curDefPref);
				MozPreferences.setBoolPref(qPreference, bPref);
				break;
				default:
				dump("Bad pref type for NIM\n");
				break;
				}


			}
          }
          else
          {
            qPreference = "__sys." + preference;
          
          }

			
		}
	
		aimprefs[i].setAttribute("prefstring", qPreference);
	
     }

 }



/*
    XXXVISHY - this is a hack. The aimPreferenceOnload would have munged
    aim.mail.presence into a per-screen name pref. This function
    will unmunge it back into a global preference. This is done in this 
    ugly manner since it is the least invasive way at this point. 
 */

function aimMailPresenceUnMunge()
{
    var mailPref = document.getElementById("mailPresence");
    mailPref.setAttribute("prefstring", "aim.mail.presence");
}



/************* Related to the Connection/Proxy Panel ********************/

// Remove whitespace from both ends of a string
function TrimString(string)
{
  if (!string) return "";
  return string.replace(/(^\s+)|(\s+$)/g, '')
}


function PrefIMConnectionOnload()
{
  var proxPass = "";
  DoEnabling();
  parent.ConnectionLoad = 1;
  parent.connectionSaved = 0;
  if (parent.ConnectionCallback == undefined || 
    parent.ConnectionCallback == null ) {

    // Register the OK callback func once, and unmunge the initial value 
    parent.ConnectionCallback = 1;
    parent.hPrefWindow.registerOKCallbackFunc(AssertProxyChanges);
    var pIAimSession = aimSession();
    if (pIAimSession) {
      var aimPrefs = aimPrefsManager();
      var mungedproxypassword = aimPrefs.GetWCharPrefEdit("aim.session.proxypassword.aim", null, 1, null, -1);
      proxPass = pIAimSession.UnMungeString(mungedproxypassword);
      parent.proxyPassword = proxPass;
    }
  }
  else {

    // we switched back from some other panel, so restore the 
    // saved off value from the unload handler
    proxPass = parent.proxyPassword;    
  }

  document.getElementById("proxyPassword").value = proxPass;
}

function AssertProxyChanges()
{
  parent.proxyPassword = document.getElementById("proxyPassword").value;
  // if the connection panel is loaded, base64 the current password
  if (parent.ConnectionLoad == 1)
    MungeProxyPassword();

  // set this so the unload handler doesn't do anything when called
  parent.connectionSaved = 1;
}

function PrefIMConnectionOnunload()
{
  // we already saved (e.g., here because OK was hit), so juswt return
  if ( parent.connectionSaved == 1 )
    return;

  // ok, switching to some other panel. Save off the current value
  // to be restored in the onload handler, and remember we are not
  // visible so we deal with the AssertProxyChanges() callback in
  // the correct manner

  parent.proxyPassword = document.getElementById("proxyPassword").value;
  parent.ConnectionLoad = 0;    
}

function DoEnabling()
{
  var host = document.getElementById("proxyHost");
  var port = document.getElementById("proxyPort");
  var protocol = document.getElementById("proxyProtocol");
  var userName = document.getElementById("proxyUserName");
  var password = document.getElementById("proxyPassword");
  var radiogroup0 = document.getElementById("proxyProtocolSocks4");
  var radiogroup1 = document.getElementById("proxyProtocolSocks5");
  var radiogroup2 = document.getElementById("proxyProtocolHttps");
  var radiogroup3 = document.getElementById("proxyProtocolHttp");

  // convenience arrays
  var manual = [host, port, protocol, userName, password, radiogroup0, radiogroup1, radiogroup2, radiogroup3];
  
  // checkbox button
  var checkboxitem = document.getElementById("proxyUse");
  if ( checkboxitem.checked ) {
      for( var i = 0; i < manual.length; i++ ) {
        manual[i].setAttribute( "disabled", "false" );
        manual[i].removeAttribute( "disabled" );
      }
  } else {
      for( var i = 0; i < manual.length; i++ ) 
        manual[i].setAttribute( "disabled", "true" );
  }
}

/*This function must be called ONLY by AsserProxyChanges function */
function MungeProxyPassword()
{
  var IMServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
  var pIIMManager  = IMServiceClass.getService(Components.interfaces.nsIIMManager);
  var pIAimSession = pIIMManager.QueryInterface(Components.interfaces.nsIAimSession);
  var proxPass = "";
  if(pIAimSession) {
      var aimPrefs = pIIMManager.QueryInterface(Components.interfaces.nsIPrefsManager);
      proxPass = pIAimSession.MungeString(parent.proxyPassword);
      aimPrefs.SetWCharPrefEdit("aim.session.proxypassword.aim", proxPass, null, 1, null, -1);
  }
}

function changePort()
{
  var proxyprotocol = document.getElementById("proxyProtocol").value;
  if (proxyprotocol == "1" || proxyprotocol == "2" || proxyprotocol == "4")
    document.getElementById("aimPort").value = "5190";
  else
    document.getElementById("aimPort").value = "443";
}

function resetConnection()
{
  document.getElementById("aimHost").value = "login.oscar.aol.com"
  document.getElementById("aimPort").value = "5190";

  //reset all the proxy stuff. clear all the fields.
  document.getElementById("proxyUse").checked = false;
  document.getElementById("proxyHost").value = "";
  document.getElementById("proxyPort").value = "1080";
  document.getElementById("proxyUserName").value = "";
  document.getElementById("proxyPassword").value = "";
  parent.proxyPassword = "";
  document.getElementById("proxyProtocolSocks4").setAttribute("selected","true");
  document.getElementById("proxyProtocolSocks5").removeAttribute("selected");
  document.getElementById("proxyProtocolHttps").removeAttribute("selected");
  document.getElementById("proxyProtocolHttp").removeAttribute("selected");
  DoEnabling();
}


/*connection panel end*/


function UpdateAwayButtons()
{
  var selection;
  var tree = document.getElementById("AwayMessages");
  if (tree)
    selection = tree.contentView.getItemAtIndex(tree.currentIndex);
  if ( selection ) {
    document.getElementById("buttonEditMess").setAttribute("disabled", "false");
    var parent = selection.parentNode;
    if (parent.childNodes.length != 1) {
      // If this is the last element in away tree, do not allow remove
      document.getElementById("buttonRemoveMess").setAttribute("disabled", "false");
    }
  }        
  return;
}

function DisableButtons()
{
    document.getElementById("buttonEditMess").setAttribute("disabled", "true");
    document.getElementById("buttonRemoveMess").setAttribute("disabled", "true");
}

function PrefIMBuddyIconOnLoad() {
  if((!IsSignedOn()) || (isIcq())) {
    var offlinetxt = aimString("bi.plsfirstsignon");
    var element = document.getElementById("OfflineIntro");
    var textNode = document.createTextNode(offlinetxt);
    element.appendChild(textNode);
    DisableBIElements();
    return;
  }

  var biframe = document.getElementById("content");
  var biurl = aimRegionString("aim.buddyiconpage");
  if (biframe)
    biframe.setAttribute("src", biurl);

  var nimBuddy = aimBuddyManager();
  nimBuddy.InitBuddyIconsState();

  //select the first element *My Buddy Icon* on pref load.
  var buddyTree = document.getElementById("buddyIconTree");
  var treeselection = buddyTree.treeBoxObject.selection;
  treeselection.select(0);


  document.getElementById("OfflineIntro").setAttribute("hidden", "true");
  LoadPersonalBuddyIcon();
}

function buddyIconBrowse() {
  var buddyTree = document.getElementById("buddyIconTree");
  var startIndex = {};
  var endIndex = {};
  buddyTree.treeBoxObject.selection.getRangeAt(0, startIndex, endIndex);
  var sindex = startIndex.value;
  var eindex = endIndex.value;
  var view = buddyTree.treeBoxObject.view;
  var level = view.getLevel(sindex);
  var selectedItem = view.getCellText(sindex, "ListSetupCol");

  if ((level == 0) && (sindex > 0)) {
    //some group is selected....just return;
    return;
  }

  var fileHandler = GetFileHandler();
  var currentTime = new Date().getTime();
  var biimage = document.getElementById("buddyIconImage");
  var pIAimSession = pIIMManager.QueryInterface(Components.interfaces.nsIAimSession);
  var pDir = pIAimSession.profileDir;
  
  //set the image to current picture.gif
  var pictureDir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
  pictureDir.initWithPath(pDir.path);

  //buddy picture directory.
  var bpictureDir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
  bpictureDir.initWithPath(pDir.path);
    
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
  if (!fp) {
    dump("Unable to create file picker...\n");
    return;
  }
  fp.init(window, aimString("bibrowse.title"),  Components.interfaces.nsIFilePicker.modeOpen);
  fp.appendFilter(aimString("bi.filetypes"), "*.gif;*.jpg;*.bmp;*.ico;*.xbm");
  var ret = fp.show();
  if (ret == Components.interfaces.nsIFilePicker.returnOK && fp.fileURL.spec) {
    var fileurl = fp.fileURL.spec;
    var Ifile = fp.fileURL.file;
    var filesize = Ifile.fileSize;
    if(filesize > 7168) {
      aimErrorBox(aimString("bi.toolarge"));
      return;
    }
  }

  //if the slected item is *my BI* then do this
  if ((level == 0) && (selectedItem == "*My Buddy Icon*") && (sindex == 0)) {
    pictureDir.append("picture.gif");
    if (pictureDir.exists()) {
      //delete the existing file
      pictureDir.remove(false);
    }

    Ifile.copyTo(pDir, "picture.gif");
    var anotherPictureDir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
    anotherPictureDir.initWithPath(pDir.path);
    anotherPictureDir.append("picture.gif");
    if (anotherPictureDir.exists()) {
      var tfileurl = fileHandler.getURLSpecFromFile(anotherPictureDir);
      if (biimage) {
        //The picture.gif will be stored in cache. so everytime you click browse and change you image
        //the url remains the same and it loads from cache. That's the reason a unique value is used.
        biimage.setAttribute("src", tfileurl+"?foobar="+currentTime);
      }
    }

    try {
      pIAimSession.SetBuddyIcon(false);
    }
    catch(e) {
      dump("Error setting Buddy Icon...:" + e + "\n");
    }
  } //end of setting personal BI
  else {
    pictureDir.append("picture");
    if(!pictureDir.exists()) {
      return;
    }
    bpictureDir.append("picture");
    if(!bpictureDir.exists()) {
      return;
    }

    pictureDir.append(selectedItem+".gif");
    if (pictureDir.exists()) {
      //delete the existing one
      pictureDir.remove(false);
    }

    var newfileName = selectedItem + ".gif";
    Ifile.copyTo(bpictureDir, newfileName);
    bpictureDir.append(newfileName);
    if (!bpictureDir.exists()) {
      return;
    }
    var buddyBI = fileHandler.getURLSpecFromFile(bpictureDir);
    if (biimage) {
      //The picture.gif will be stored in cache. so everytime you click browse and change you image
      //the url remains the same and it loads from cache. That's the reason a unique value is used.
      biimage.setAttribute("src", buddyBI+"?foobar="+currentTime);
    }


    //this guy should set the reject flag in *defaulr-BI.rdf* (Not in Buddy List DS)
    // for this buddy so that the user won't receive BI from that remote Buddy.
    //this guy should also call the main RDF code to set the hasBI property.
    var rdf = aimRDF();
    var nimIM = aimIM();
    nimIM.SetHasBIBuddyIconFlag(selectedItem, true);

    var wantBIres = rdf.GetResource("http://home.netscape.com/NC-rdf#WantBI");
    var falseliteral = rdf.GetLiteral("false");
    nimIM.SetBuddyIconFlag(selectedItem, wantBIres, falseliteral);

    var nimBuddy = aimBuddyManager();
    nimBuddy.SetHasBuddyIconFlag(selectedItem, true);

  } //else 
}

function GetFileHandler()
{
  var IOService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);

  return IOService.getProtocolHandler("file")
                  .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
}

function clearBuddyIcon()
{
  var userresponse;
  userresponse = confirm(getString("bi.clearbi"));
  if (!userresponse) 
    return;

  var buddyTree = document.getElementById("buddyIconTree");
  var startIndex = {};
  var endIndex = {};
  buddyTree.treeBoxObject.selection.getRangeAt(0, startIndex, endIndex);
  var sindex = startIndex.value;
  var eindex = endIndex.value;
  var view = buddyTree.treeBoxObject.view;
  var level = view.getLevel(sindex);
  var selectedItem = view.getCellText(sindex, "ListSetupCol");
  var biimage = document.getElementById("buddyIconImage");
  var pIAimSession = pIIMManager.QueryInterface(Components.interfaces.nsIAimSession);
  var pDir = pIAimSession.profileDir;
  
  //set the image to current picture.gif
  var pictureDir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
  pictureDir.initWithPath(pDir.path);

  if ((level == 0) && (selectedItem == "*My Buddy Icon*") && (sindex == 0)) {
    clearPersonalBuddyIcon();
    clearBuddyIconImage();
    return;
  }

  if ((level == 0) && (sidex > 0)) {
    //a group is selected
    return;
  }

  //four steps done.
  //1. Delete the <SN>.gif
  //2. Clear the RejectBI flag, if any.
  //3. Clear the HasBI flag, if any.
  //4. Clear in any open IM windows

  pictureDir.append("picture");
  if (!pictureDir.exists()) {
    return;
  }
  pictureDir.append(selectedItem+".gif");
  if (pictureDir.exists()) {
    //remove the picture file
    pictureDir.remove(false);
  }

  
  var nimIM = aimIM();
  nimIM.SetHasBIBuddyIconFlag(selectedItem, false);
  var rdf = aimRDF();

  //clear wantBI flag
  var wantBIres = rdf.GetResource("http://home.netscape.com/NC-rdf#WantBI");
  var trueliteral = rdf.GetLiteral("true");
  nimIM.SetBuddyIconFlag(selectedItem, wantBIres, trueliteral);

  //clear reject BI flag
  var rejBIres = rdf.GetResource("http://home.netscape.com/NC-rdf#Reject");
  var falseliteral = rdf.GetLiteral("false");
  nimIM.SetBuddyIconFlag(selectedItem, rejBIres, falseliteral);

  //clear FileSize BI res
  var filesizeBIres = rdf.GetResource("http://home.netscape.com/NC-rdf#FileSize");
  var filesizeliteral = rdf.GetIntLiteral(0);
  nimIM.SetBuddyIconFlag(selectedItem, filesizeBIres, filesizeliteral);

  //clear checksum BI res
  var checksumBIres = rdf.GetResource("http://home.netscape.com/NC-rdf#CheckSum");
  var csliteral = rdf.GetIntLiteral(0);
  nimIM.SetBuddyIconFlag(selectedItem, checksumBIres, csliteral);
  
  var nimBuddy = aimBuddyManager();
  nimBuddy.SetHasBuddyIconFlag(selectedItem, false);
  nimBuddy.SetBuddyIconRejectFlag(selectedItem, false);
  
  clearBuddyIconImage();

  //4. Clear in any open IM windows
  setBuddyIconImageinIMWindow(selectedItem, null);

}

function setBuddyIconImageinIMWindow(screenName, url)
{
  var aimIM = aimIMObject();
  var existingIM = aimIM.GetExistingIM(screenName);
  if (existingIM) {
    var biElement = existingIM.document.getElementById("BuddyIcon");
    if (biElement)
      biElement.setAttribute("src", url);
  }
}

function clearAllBuddyIcons()
{
  var userresponse;
  userresponse = confirm(getString("bi.clearall"));
  if (userresponse == false) 
    return;

  clearPersonalBuddyIcon();
  clearAllRemoteBuddyIcons();
  var nimIM = aimIM();
  nimIM.ClearAllBuddyIconFlags();
  clearBuddyIconImage();

}

/*clears all the remote buudies BI
  deletes the entries in picture directory */
function clearAllRemoteBuddyIcons()
{
  var pIAimSession = pIIMManager.QueryInterface(Components.interfaces.nsIAimSession);
  var pDir = pIAimSession.profileDir;
  var pictureDir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
  pictureDir.initWithPath(pDir.path);
  pictureDir.append("picture");
  if ((pictureDir.exists()) && (pictureDir.isDirectory())) {
    var fileslist = pictureDir.directoryEntries;
    while(fileslist.hasMoreElements()) {
      var nextfile = fileslist.getNext().QueryInterface(Components.interfaces.nsIFile);
      if (nextfile && !nextfile.isDirectory())
        nextfile.remove(false);
    }
  }
}


/*Clears the personal Buddy Icon from the profilr directory and in COOL */
function clearPersonalBuddyIcon()
{
  var biimage = document.getElementById("buddyIconImage");
  var pIAimSession = pIIMManager.QueryInterface(Components.interfaces.nsIAimSession);
  var pDir = pIAimSession.profileDir;
  var pictureDir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
  pictureDir.initWithPath(pDir.path);
  pictureDir.append("picture.gif");
  if (pictureDir.exists()) {
    //remove the image from the profile dir. clear the bi. send signal back to COOL.
    biimage.removeAttribute("src");
    pIAimSession.SetBuddyIcon(true);
    pictureDir.remove(false);
  }
}


function DisableBIElements()
{
  document.getElementById("buddyIconTree").setAttribute("hidden", "true");
  document.getElementById("btnBrowseFile").setAttribute("hidden", "true");
  document.getElementById("btnClear").setAttribute("hidden", "true");
  document.getElementById("btnClearAll").setAttribute("hidden", "true");
  document.getElementById("acceptFromUsers").setAttribute("hidden", "true");
  document.getElementById("buddyKnockKnock").setAttribute("hidden", "true");
  document.getElementById("neverAccept").setAttribute("hidden", "true");
  document.getElementById("neverDisplay").setAttribute("hidden", "true");
  document.getElementById("imagegpbox").setAttribute("hidden", "true");
  document.getElementById("content").setAttribute("hidden", "true");
  document.getElementById("prefgpbox").setAttribute("hidden", "true");
}

function changeKnockKnock()
{
  var displayBI = document.getElementById("displayBI").value;
  var kk = document.getElementById("buddyKnockKnock");
  if(displayBI == "0")
    kk.removeAttribute("disabled");
  else
    kk.setAttribute("disabled", "true");
}

function onBISelectionChange()
{
  var buddyTree = document.getElementById("buddyIconTree");
  var startIndex = {};
  var endIndex = {};
  buddyTree.treeBoxObject.selection.getRangeAt(0, startIndex, endIndex);
  var sindex = startIndex.value;
  var eindex = endIndex.value;
  var view = buddyTree.treeBoxObject.view;
  var level = view.getLevel(sindex);
  var selectedItem = view.getCellText(sindex, "ListSetupCol");
  

  if ((level == 0) && (sindex > 0)) {
    //a group is selected. disable the buttons and clear the image.
    document.getElementById("btnBrowseFile").setAttribute("disabled", "true");
    document.getElementById("btnClear").setAttribute("disabled", "true");
    clearBuddyIconImage();
    return;
  }
  else {
    document.getElementById("btnBrowseFile").setAttribute("disabled", "false");
    document.getElementById("btnClear").setAttribute("disabled", "false");
  }

  if (sindex == 0) {
    LoadPersonalBuddyIcon();
    return;
  }

  if ((sindex >0) && (level != 0)) {
    //load the remote buddies buddy icon
    LoadRemoteBuddyBuddyIcon(selectedItem);
  }

}


/* As the name implies, this guy loads the buddy Icon of the remote buddy from the picture directory*/
function LoadRemoteBuddyBuddyIcon(buddyname)
{
  var pIAimSession = pIIMManager.QueryInterface(Components.interfaces.nsIAimSession);
  var pDir = pIAimSession.profileDir;
  
  //set the image to current picture.gif
  var pictureDir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
  pictureDir.initWithPath(pDir.path);
  pictureDir.append("picture");
  if(!pictureDir.exists()) {
    return;
  }
  pictureDir.append(buddyname + ".gif");
  if (!pictureDir.exists()) {
    clearBuddyIconImage();
    return;
  }

  var fileHandler = GetFileHandler();
  var tfileurl1 = fileHandler.getURLSpecFromFile(pictureDir);
  //avoid loading from cache
  var currentTime = new Date().getTime();
  var biimage = document.getElementById("buddyIconImage");
  biimage.setAttribute("src", tfileurl1+"?foobar="+currentTime);

  return;
}

/*This just clears the image from the pref panel. */
function clearBuddyIconImage() {
  var biimage = document.getElementById("buddyIconImage");
  biimage.removeAttribute("src");
  return;
}

/*This loads the personal Buddy Icon from the profile directory*/
function LoadPersonalBuddyIcon() {
  var biimage = document.getElementById("buddyIconImage");
  var pIAimSession = pIIMManager.QueryInterface(Components.interfaces.nsIAimSession);
  var pDir = pIAimSession.profileDir;
  
  //set the image to current picture.gif
  var pictureDir = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
  pictureDir.initWithPath(pDir.path);
  pictureDir.append("picture.gif");
  if (pictureDir.exists()) {
    var fileHandler = GetFileHandler();
    var tfileurl1 = fileHandler.getURLSpecFromFile(pictureDir);
    //avoid loading from cache
    var currentTime = new Date().getTime();
    biimage.setAttribute("src", tfileurl1+"?foobar="+currentTime);     
  }
  else {
    clearBuddyIconImage();
  }
  return;
}

//Most of these code are inherited from browser code.
//And a note to whoever own the Buddy Icons content page: Please do not change the urls. ;-)

function bicontentAreaClick(event)
{
  var target = event.target;
  var linkNode;
  var local_name = target.localName;

  if (local_name)
    local_name = local_name.toLowerCase();

  switch (local_name) {
    case "a":
    case "area":
    case "link":
      if (target.hasAttribute("href")) 
        linkNode = target;
      break;
    default:
      linkNode = findBIParentNode(event.originalTarget, "a");
      // <a> cannot be nested.  So if we find an anchor without an
      // href, there is no useful <a> around the target
      if (linkNode && !linkNode.hasAttribute("href"))
        linkNode = null;
      break;
  }

  if (linkNode) {
    var linkNodehref = linkNode.href;
    //if the url contains aol.com just load it in BI pref pane
    if (linkNodehref.substr(0, 18) == aimRegionString("aim.aolurl"))
      return false;
    else {
      //if url does not contain aol.com and it is a http url load it in a new window.
      if (linkNodehref.substr(0, 7) == aimRegionString("aim.httpurl")) {
        event.preventDefault();
        openTopWin(linkNodehref);
        return true;
      }
    }
  }

  return false;
}

function findBIParentNode(node, parentNode)
{
  if (node && node.nodeType == Node.TEXT_NODE) {
    node = node.parentNode;
  }
  while (node) {
    var nodeName = node.localName;
    if (!nodeName)
      return null;
    nodeName = nodeName.toLowerCase();
    if (nodeName == "body" || nodeName == "html" ||
        nodeName == "#document") {
      return null;
    }
    if (nodeName == parentNode)
      return node;
    node = node.parentNode;
  }
  return null;
}


function boottoggle(value)
{
  parent.isBootEnabled = value;
}

function instantMessageOnOk()
{
  var winhooksService = Components.classes["@mozilla.org/winhooks;1"].getService(Components.interfaces.nsIWindowsHooks);
  if (winhooksService) {
    if (parent.isBootEnabled)
      winhooksService.startupAddOption("-aim");
    else
      winhooksService.startupRemoveOption("-aim");
  }
}

function instantMessageOnload()
{
  var todayhide = aimPrefsManager().GetBoolPref("aim.internal.hidetoday", null, false);
  if (todayhide)
  {
    document.getElementById("today").setAttribute("style", "display: none" );
  }
  if (navigator.platform != "Win32")
  {
    document.getElementById("boot").setAttribute("hidden", "true");
    // If all the elements in the Sign On group are removed, get ride of the groupbox
    // Otherwise we'll show an empty groupbox!
    if (todayhide)
    {
      document.getElementById("signongroup").setAttribute("style", "display: none" );
    }
    return;
  }
  if (!parent.hPrefWindow)
  {
    setTimeout("instantMessageOnload()", 1);
    return;
  }
  parent.hPrefWindow.registerOKCallbackFunc(instantMessageOnOk);
  if (!aimSession().CheckConflictRunKey())
  {
    var winhooksService = Components.classes["@mozilla.org/winhooks;1"].getService(Components.interfaces.nsIWindowsHooks);
    if (winhooksService) {
      parent.isBootEnabled = winhooksService.isOptionEnabled("-aim");
      document.getElementById("boot").checked = parent.isBootEnabled;
    }
  } 
  else
    document.getElementById("boot").setAttribute("disabled", "true");
}

function openfilepicker()
{
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  fp.init(window, aimString('file.choose'), nsIFilePicker.modeGetFolder);

  fp.appendFilters(nsIFilePicker.filterAll);

  try {
    fp.show();
  }
  catch (ex) {
    dump ("filePicker.chooseInputFile threw an exception\n");
    return false;
  }
  var kdir_separator = "/";
  if (navigator.platform == 'MacPPC')
    kdir_separator = ":";
  else if (navigator.platform == 'Win32')
    kdir_separator = "\\";
  if (fp.file && fp.file.path.length > 0)
    document.getElementById("location").setAttribute("value", fp.file.path + kdir_separator);
}