/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/

#include "qmalamute.h"

///
//  Copy-construct to return the proper wrapped c types
QMlmClient::QMlmClient (mlm_client_t *self, QObject *qObjParent) : QObject (qObjParent)
{
    this->self = self;
}


///
//  Create a new mlm_client, return the reference if successful,   
//  or NULL if construction failed due to lack of available memory.
QMlmClient::QMlmClient (QObject *qObjParent) : QObject (qObjParent)
{
    this->self = mlm_client_new ();
}

///
//  Destroy the mlm_client and free all memory used by the object.
QMlmClient::~QMlmClient ()
{
    mlm_client_destroy (&self);
}

///
//  Return actor, when caller wants to work with multiple actors and/or
//  input sockets asynchronously.                                      
QZactor * QMlmClient::actor ()
{
    QZactor *rv = new QZactor (mlm_client_actor (self));
    return rv;
}

///
//  Return message pipe for asynchronous message I/O. In the high-volume case,
//  we send methods and get replies to the actor, in a synchronous manner, and
//  we send/recv high volume message data to a second pipe, the msgpipe. In   
//  the low-volume case we can do everything over the actor pipe, if traffic  
//  is never ambiguous.                                                       
QZsock * QMlmClient::msgpipe ()
{
    QZsock *rv = new QZsock (mlm_client_msgpipe (self));
    return rv;
}

///
//  Return true if client is currently connected, else false. Note that the   
//  client will automatically re-connect if the server dies and restarts after
//  a successful first connection.                                            
bool QMlmClient::connected ()
{
    bool rv = mlm_client_connected (self);
    return rv;
}

///
//  Set PLAIN authentication username and password. If you do not call this, the    
//  client will use NULL authentication. TODO: add "set curve auth".                
//  Returns >= 0 if successful, -1 if interrupted.                                  
int QMlmClient::setPlainAuth (const QString &username, const QString &password)
{
    int rv = mlm_client_set_plain_auth (self, username.toUtf8().data(), password.toUtf8().data());
    return rv;
}

///
//  Connect to server endpoint, with specified timeout in msecs (zero means wait    
//  forever). Constructor succeeds if connection is successful. The caller may      
//  specify its address.                                                            
//  Returns >= 0 if successful, -1 if interrupted.                                  
int QMlmClient::connect (const QString &endpoint, quint32 timeout, const QString &address)
{
    int rv = mlm_client_connect (self, endpoint.toUtf8().data(), (uint32_t) timeout, address.toUtf8().data());
    return rv;
}

///
//  Prepare to publish to a specified stream. After this, all messages are sent to  
//  this stream exclusively.                                                        
//  Returns >= 0 if successful, -1 if interrupted.                                  
int QMlmClient::setProducer (const QString &stream)
{
    int rv = mlm_client_set_producer (self, stream.toUtf8().data());
    return rv;
}

///
//  Consume messages with matching subjects. The pattern is a regular expression    
//  using the CZMQ zrex syntax. The most useful elements are: ^ and $ to match the  
//  start and end, . to match any character, \s and \S to match whitespace and      
//  non-whitespace, \d and \D to match a digit and non-digit, \a and \A to match    
//  alphabetic and non-alphabetic, \w and \W to match alphanumeric and              
//  non-alphanumeric, + for one or more repetitions, * for zero or more repetitions,
//  and ( ) to create groups. Returns 0 if subscription was successful, else -1.    
//  Returns >= 0 if successful, -1 if interrupted.                                  
int QMlmClient::setConsumer (const QString &stream, const QString &pattern)
{
    int rv = mlm_client_set_consumer (self, stream.toUtf8().data(), pattern.toUtf8().data());
    return rv;
}

///
//  Offer a particular named service, where the pattern matches request subjects    
//  using the CZMQ zrex syntax.                                                     
//  Returns >= 0 if successful, -1 if interrupted.                                  
int QMlmClient::setWorker (const QString &address, const QString &pattern)
{
    int rv = mlm_client_set_worker (self, address.toUtf8().data(), pattern.toUtf8().data());
    return rv;
}

///
//  Send STREAM SEND message to server, takes ownership of message
//  and destroys message when done sending it.                    
int QMlmClient::send (const QString &subject, QZmsg *content)
{
    int rv = mlm_client_send (self, subject.toUtf8().data(), &content->self);
    return rv;
}

///
//  Send MAILBOX SEND message to server, takes ownership of message
//  and destroys message when done sending it.                     
int QMlmClient::sendto (const QString &address, const QString &subject, const QString &tracker, quint32 timeout, QZmsg *content)
{
    int rv = mlm_client_sendto (self, address.toUtf8().data(), subject.toUtf8().data(), tracker.toUtf8().data(), (uint32_t) timeout, &content->self);
    return rv;
}

///
//  Send SERVICE SEND message to server, takes ownership of message
//  and destroys message when done sending it.                     
int QMlmClient::sendfor (const QString &address, const QString &subject, const QString &tracker, quint32 timeout, QZmsg *content)
{
    int rv = mlm_client_sendfor (self, address.toUtf8().data(), subject.toUtf8().data(), tracker.toUtf8().data(), (uint32_t) timeout, &content->self);
    return rv;
}

///
//  Receive message from server; caller destroys message when done
QZmsg * QMlmClient::recv ()
{
    QZmsg *rv = new QZmsg (mlm_client_recv (self));
    return rv;
}

///
//  Return last received command. Can be one of these values:
//      "STREAM DELIVER"                                     
//      "MAILBOX DELIVER"                                    
//      "SERVICE DELIVER"                                    
const QString QMlmClient::command ()
{
    const QString rv = QString (mlm_client_command (self));
    return rv;
}

///
//  Return last received status
int QMlmClient::status ()
{
    int rv = mlm_client_status (self);
    return rv;
}

///
//  Return last received reason
const QString QMlmClient::reason ()
{
    const QString rv = QString (mlm_client_reason (self));
    return rv;
}

///
//  Return last received address
const QString QMlmClient::address ()
{
    const QString rv = QString (mlm_client_address (self));
    return rv;
}

///
//  Return last received sender
const QString QMlmClient::sender ()
{
    const QString rv = QString (mlm_client_sender (self));
    return rv;
}

///
//  Return last received subject
const QString QMlmClient::subject ()
{
    const QString rv = QString (mlm_client_subject (self));
    return rv;
}

///
//  Return last received content
QZmsg * QMlmClient::content ()
{
    QZmsg *rv = new QZmsg (mlm_client_content (self));
    return rv;
}

///
//  Return last received tracker
const QString QMlmClient::tracker ()
{
    const QString rv = QString (mlm_client_tracker (self));
    return rv;
}

///
//  Enable verbose tracing (animation) of state machine activity.
void QMlmClient::setVerbose (bool verbose)
{
    mlm_client_set_verbose (self, verbose);
    
}

///
//  Self test of this class.
void QMlmClient::test (bool verbose)
{
    mlm_client_test (verbose);
    
}
/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/
