/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/

#ifndef QML_MLM_CLIENT_H
#define QML_MLM_CLIENT_H

#include <QtQml>

#include <malamute.h>
#include "qml_malamute_plugin.h"


class QmlMlmClient : public QObject
{
    Q_OBJECT
    Q_PROPERTY(bool isNULL READ isNULL)
    
public:
    mlm_client_t *self;
    
    QmlMlmClient() { self = NULL; }
    bool isNULL() { return self == NULL; }
    
    static QObject* qmlAttachedProperties(QObject* object); // defined in QmlMlmClient.cpp
    
public slots:
    //  Return actor, when caller wants to work with multiple actors and/or
    //  input sockets asynchronously.                                      
    zactor_t *actor ();

    //  Return message pipe for asynchronous message I/O. In the high-volume case,
    //  we send methods and get replies to the actor, in a synchronous manner, and
    //  we send/recv high volume message data to a second pipe, the msgpipe. In   
    //  the low-volume case we can do everything over the actor pipe, if traffic  
    //  is never ambiguous.                                                       
    zsock_t *msgpipe ();

    //  Return true if client is currently connected, else false. Note that the   
    //  client will automatically re-connect if the server dies and restarts after
    //  a successful first connection.                                            
    bool connected ();

    //  Set PLAIN authentication username and password. If you do not call this, the    
    //  client will use NULL authentication. TODO: add "set curve auth".                
    //  Returns >= 0 if successful, -1 if interrupted.                                  
    int setPlainAuth (const QString &username, const QString &password);

    //  Connect to server endpoint, with specified timeout in msecs (zero means wait    
    //  forever). Constructor succeeds if connection is successful. The caller may      
    //  specify its address.                                                            
    //  Returns >= 0 if successful, -1 if interrupted.                                  
    int connect (const QString &endpoint, uint32_t timeout, const QString &address);

    //  Prepare to publish to a specified stream. After this, all messages are sent to  
    //  this stream exclusively.                                                        
    //  Returns >= 0 if successful, -1 if interrupted.                                  
    int setProducer (const QString &stream);

    //  Consume messages with matching subjects. The pattern is a regular expression    
    //  using the CZMQ zrex syntax. The most useful elements are: ^ and $ to match the  
    //  start and end, . to match any character, \s and \S to match whitespace and      
    //  non-whitespace, \d and \D to match a digit and non-digit, \a and \A to match    
    //  alphabetic and non-alphabetic, \w and \W to match alphanumeric and              
    //  non-alphanumeric, + for one or more repetitions, * for zero or more repetitions,
    //  and ( ) to create groups. Returns 0 if subscription was successful, else -1.    
    //  Returns >= 0 if successful, -1 if interrupted.                                  
    int setConsumer (const QString &stream, const QString &pattern);

    //  Offer a particular named service, where the pattern matches request subjects    
    //  using the CZMQ zrex syntax.                                                     
    //  Returns >= 0 if successful, -1 if interrupted.                                  
    int setWorker (const QString &address, const QString &pattern);

    //  Send STREAM SEND message to server, takes ownership of message
    //  and destroys message when done sending it.                    
    int send (const QString &subject, zmsg_t **content);

    //  Send MAILBOX SEND message to server, takes ownership of message
    //  and destroys message when done sending it.                     
    int sendto (const QString &address, const QString &subject, const QString &tracker, uint32_t timeout, zmsg_t **content);

    //  Send SERVICE SEND message to server, takes ownership of message
    //  and destroys message when done sending it.                     
    int sendfor (const QString &address, const QString &subject, const QString &tracker, uint32_t timeout, zmsg_t **content);

    //  Receive message from server; caller destroys message when done
    zmsg_t *recv ();

    //  Return last received command. Can be one of these values:
    //      "STREAM DELIVER"                                     
    //      "MAILBOX DELIVER"                                    
    //      "SERVICE DELIVER"                                    
    const QString command ();

    //  Return last received status
    int status ();

    //  Return last received reason
    const QString reason ();

    //  Return last received address
    const QString address ();

    //  Return last received sender
    const QString sender ();

    //  Return last received subject
    const QString subject ();

    //  Return last received content
    zmsg_t *content ();

    //  Return last received tracker
    const QString tracker ();

    //  Send multipart string message to stream, end list with NULL        
    //  Returns 0 if OK, -1 if failed due to lack of memory or other error.
    int sendx (const QString &subject, const QString &content);

    //  Send multipart string to mailbox, end list with NULL               
    //  Returns 0 if OK, -1 if failed due to lack of memory or other error.
    int sendtox (const QString &address, const QString &subject, const QString &content);

    //  Send multipart string to service, end list with NULL               
    //  Returns 0 if OK, -1 if failed due to lack of memory or other error.
    int sendforx (const QString &address, const QString &subject, const QString &content);

    //  Receive a subject and string content from the server. The content may be
    //  1 or more string frames. This method is orthogonal to the sendx methods.
    //  End the string arguments with NULL. If there are not enough frames in   
    //  the received message, remaining strings are set to NULL. Returns number 
    //  of string contents received, or -1 in case of error. Free the returned  
    //  subject and content strings when finished with them. To get the type of 
    //  the command, use mlm_client_command ().                                 
    int recvx (QString subjectP, QString stringP);

    //  Enable verbose tracing (animation) of state machine activity.
    void setVerbose (bool verbose);
};

class QmlMlmClientAttached : public QObject
{
    Q_OBJECT
    QObject* m_attached;
    
public:
    QmlMlmClientAttached (QObject* attached) {
        Q_UNUSED (attached);
    };
    
public slots:
    //  Self test of this class.
    void test (bool verbose);

    //  Create a new mlm_client, return the reference if successful,   
    //  or NULL if construction failed due to lack of available memory.
    QmlMlmClient *construct ();

    //  Destroy the mlm_client and free all memory used by the object.
    void destruct (QmlMlmClient *qmlSelf);
};


QML_DECLARE_TYPEINFO(QmlMlmClient, QML_HAS_ATTACHED_PROPERTIES)

#endif
/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/
