# Raspberry Pi

Cross compile environment for the Raspberry Pi (all models)

## Cross compile for Raspbian

Simply run

    ./build.sh

Once the build script finishes the installation data is located at `tmp/`.
To copy those files to your Raspberry Pi you can use `rsync`. Therefore
you'll have to make sure rsync is installed on the Raspberry Pi

    apt-get install rsync

Next make sure your Pi user has sufficient access rights to copy data to
`/usr/local`. To force this you can use the following command to change
the ownership of the directory accordingly.

    chown -R root:users /usr/local/

And finally sync your libraries to the Pi

    rsync -avz tmp/ <pi-user>@<pi-ip>:/usr/local

The first time you install a library onto the Raspberry Pi you'll need to run

    sudo ldconfig

During development running the build script with all dependencies just to test
a minor change is overkill. To run an incremental build use the option
`-i|--incremental` which will only build this project.

    ./build.sh --incremental

Once in a while you might want to update the dependencies. You can do this by
adding the option `-u|--update`.

    ./build.sh --update

Note that incremental and update are exclusiv options.

## Cross compile and install to Raspbian image

This requires sudo access rights on your local maschine. Also make sure
you have `kpartx`, `qemu-user` and `proot` installed.

To cross compile and install this project to an raspbian image run

    ./build_image.sh

This script will download the latest Raspbian image extend it so we can install
software into it and finally copy the cross compiled stuff to it. Once it's done
simple copy the image to a SD card and plug it into your Raspberry Pi.

```
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
```
