#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.12';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFInfo2',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 87 => 0x69 },
	'about' => { 393 => 'about' },
	'abspeakaudiofilepath' => { 399 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 68 => 0x518 },
	'accelerometer' => { 309 => 0x3 },
	'accelerometerx' => { 253 => 0x8d },
	'accelerometery' => { 253 => 0x8e },
	'accelerometerz' => { 253 => 0x8c },
	'accessoryserialnumber' => { 253 => 0x54 },
	'accessorytype' => { 253 => 0x53 },
	'actionadvised' => { 103 => 0x2a },
	'activearea' => { 95 => 0xc68d },
	'actived-lighting' => { 182 => 0x22, 213 => 0x24 },
	'actived-lightingmode' => { 213 => 0x25 },
	'addaspectratioinfo' => { 68 => 0x80e },
	'additionalmodelinformation' => { 386 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 68 => 0x80f, 69 => 0x11, 70 => 0x13, 73 => 0x14 },
	'address' => { 130 => 'Address' },
	'adjustmentmode' => { 315 => 0x15 },
	'adobe' => { 96 => 'Adobe' },
	'adultcontentwarning' => { 389 => 'AdultContentWarning', 392 => 'adultContentWarning' },
	'advancedraw' => { 215 => 0x76a43203 },
	'advancedscenetype' => { 253 => 0x3d },
	'advisory' => { 397 => 'Advisory' },
	'ae_iso' => { 258 => 0x2, 259 => 0x4, 260 => 0x12 },
	'aeaperture' => { 258 => 0x1, 259 => 0x3, 260 => 0x11 },
	'aeaperturesteps' => { 258 => 0x8, 259 => 0xb },
	'aebautocancel' => { 68 => 0x104 },
	'aebbracketvalue' => { 62 => 0x11 },
	'aebsequence' => { 68 => 0x105 },
	'aebsequenceautocancel' => { 66 => 0x9, 67 => 0x9, 69 => 0x8, 70 => 0x9, 73 => 0x9, 74 => 0x7 },
	'aebshotcount' => { 68 => 0x106 },
	'aebxv' => { 258 => 0x4, 259 => 0x6 },
	'aeerror' => { 259 => 0x8 },
	'aeexposuretime' => { 258 => 0x0, 259 => 0x2, 260 => 0x10 },
	'aelbutton' => { 150 => 0x45 },
	'aelexposureindicator' => { 150 => 0x51 },
	'aelock' => { 150 => 0x5b, 223 => '4.2', 229 => '4.2', 233 => 0x201, 284 => 0x48, 325 => [0x86,0x286] },
	'aelockbutton' => { 222 => '16.1', 223 => '4.1', 224 => '15.1', 225 => '16.1', 226 => '16.1', 227 => '30.1', 228 => '16.1', 229 => '4.1', 231 => '17.1' },
	'aelockbuttonplusdials' => { 222 => '16.2', 227 => '32.1' },
	'aelockformb-d80' => { 231 => '3.1' },
	'aemaxaperture' => { 258 => 0x9, 259 => 0x10, 260 => 0x1c },
	'aemaxaperture2' => { 258 => 0xa, 259 => 0x11, 260 => 0x1d },
	'aemeteringmode' => { 258 => 0xc },
	'aemeteringmode2' => { 258 => '13.1' },
	'aemeteringsegments' => { 153 => 0x628, 284 => 0x209 },
	'aemicroadjustment' => { 68 => 0x110 },
	'aeminaperture' => { 258 => 0xb, 259 => 0x12, 260 => 0x1e },
	'aeminexposuretime' => { 258 => 0x5, 259 => 0x13, 260 => 0x1f },
	'aeprogrammode' => { 258 => 0x6 },
	'aesetting' => { 29 => 0x21 },
	'aewhitebalance' => { 258 => 0xd },
	'aexv' => { 258 => 0x3, 259 => 0x5 },
	'af-cpriorityselection' => { 222 => '1.1', 225 => '0.1', 226 => '0.1', 227 => '1.1', 228 => '0.1' },
	'af-onformb-d10' => { 222 => '3.3', 227 => '3.2' },
	'af-onformb-d11' => { 228 => '2.2' },
	'af-spriorityselection' => { 222 => '1.2', 227 => '1.2', 228 => '0.2' },
	'afactivation' => { 222 => '2.1', 227 => '2.1' },
	'afadjustment' => { 284 => 0x72 },
	'afandmeteringbuttons' => { 68 => 0x701 },
	'afaperture' => { 178 => 0x5, 179 => 0x5 },
	'afareaheight' => { 158 => 0x1a },
	'afareaillumination' => { 150 => 0x4b, 229 => '15.3' },
	'afareamode' => { 146 => 0x33, 150 => 0xe, 157 => 0x0, 158 => 0x5, 253 => 0xf, 306 => 0x1205, 316 => [0xa,0x3a], 323 => 0x11, 324 => 0x10, 325 => 0x24, 335 => 0xb043, 353 => 0x17 },
	'afareamodesetting' => { 223 => '11.1', 224 => '0.1', 229 => '16.1', 231 => '2.1', 335 => 0x201c },
	'afareas' => { 233 => 0x304 },
	'afareaselectmethod' => { 68 => 0x51b },
	'afareawidth' => { 158 => 0x18 },
	'afareaxposition' => { 158 => 0x14, 306 => 0x1203 },
	'afareaxposition1' => { 306 => 0x1201 },
	'afareayposition' => { 158 => 0x16, 306 => 0x1204 },
	'afareayposition1' => { 306 => 0x1202 },
	'afassist' => { 66 => 0x5, 74 => 0x5, 150 => 0x48, 222 => '2.5', 223 => '0.2', 224 => '0.2', 225 => '1.1', 226 => '1.1', 227 => '2.4', 228 => '1.4', 229 => '0.2', 231 => '2.3' },
	'afassistbeam' => { 68 => 0x50e, 69 => 0x4, 70 => 0x5, 71 => 0x4, 72 => 0x4, 73 => 0x5 },
	'afassistlamp' => { 253 => 0x31 },
	'afbuttonpressed' => { 325 => [0x83,0x283] },
	'afdefocus' => { 261 => 0x6 },
	'afduringliveview' => { 68 => 0x511 },
	'affinea' => { 370 => 'AffineA' },
	'affineb' => { 370 => 'AffineB' },
	'affinec' => { 370 => 'AffineC' },
	'affined' => { 370 => 'AffineD' },
	'affinetune' => { 159 => 0x0, 233 => 0x306 },
	'affinetuneadj' => { 159 => 0x2, 190 => 0x2d1, 191 => 0x2dc, 233 => 0x307 },
	'affinetuneindex' => { 159 => 0x1 },
	'affinex' => { 370 => 'AffineX' },
	'affiney' => { 370 => 'AffineY' },
	'afilluminator' => { 323 => 0x29, 335 => 0xb044 },
	'afimageheight' => { 158 => 0x12 },
	'afimagewidth' => { 158 => 0x10 },
	'afintegrationtime' => { 261 => 0x7 },
	'afmicroadj' => { 316 => [0x17d,0x50] },
	'afmicroadjmode' => { 2 => 0x1, 320 => 0x131 },
	'afmicroadjregisteredlenses' => { 320 => '305.1' },
	'afmicroadjustment' => { 68 => 0x507 },
	'afmicroadjvalue' => { 2 => 0x2, 320 => 0x130 },
	'afmode' => { 91 => 0x3009, 146 => 0x16, 315 => 0x5 },
	'afonaelockbuttonswitch' => { 68 => 0x702 },
	'afonbutton' => { 222 => '3.1' },
	'afpoint' => { 29 => 0x13, 90 => 0x18, 146 => 0x15, 157 => 0x1, 236 => 0x308, 315 => 0x1f, 316 => 0x7, 320 => 0x19, 321 => 0x18, 322 => [0x18,0x20] },
	'afpointactivationarea' => { 67 => 0x11, 73 => 0x11 },
	'afpointareaexpansion' => { 68 => 0x508 },
	'afpointatshutterrelease' => { 316 => 0x9 },
	'afpointautoselection' => { 68 => 0x50b },
	'afpointbrightness' => { 68 => 0x50d, 222 => '2.4' },
	'afpointdisplayduringfocus' => { 68 => 0x50c },
	'afpointillumination' => { 67 => 0xa, 222 => '2.3', 227 => '2.3', 228 => '1.3', 231 => '2.4' },
	'afpointinfocus' => { 316 => 0x8 },
	'afpointmode' => { 265 => 0x3 },
	'afpointposition' => { 91 => 0x2021, 253 => 0x4d },
	'afpointregistration' => { 66 => 0x7 },
	'afpoints' => { 149 => 0x10 },
	'afpointselected' => { 150 => 0xd, 233 => 0x305, 284 => 0xe, 320 => 0x15, 321 => 0x14, 322 => [0x14,0x1c], 335 => 0x201e },
	'afpointselected2' => { 265 => 0x4 },
	'afpointselection' => { 67 => 0xb, 222 => '1.3', 227 => '1.3' },
	'afpointselectionmethod' => { 68 => 0x50f, 69 => 0xc, 70 => 0xd, 73 => 0xd },
	'afpointset' => { 100 => 0x1022 },
	'afpointsetting' => { 323 => 0x12, 324 => 0x11 },
	'afpointsinfocus' => { 62 => 0xe, 157 => 0x2, 261 => 0xb, 284 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 17 => 0x38 },
	'afpointspotmetering' => { 67 => 0xd },
	'afpointsselected' => { 360 => 0x4 },
	'afpointsunknown1' => { 261 => 0x0 },
	'afpointsunknown2' => { 261 => 0x2 },
	'afpointsused' => { 158 => 0x8, 317 => 0x0 },
	'afpredictor' => { 261 => 0x4 },
	'afresponse' => { 182 => 0xad },
	'afresult' => { 238 => 0x1038 },
	'afsearch' => { 233 => 0x303 },
	'afsensoractive' => { 146 => 0x1 },
	'afstatus' => { 306 => 0x1200 },
	'afstatusactivesensor' => { 146 => 0x2, 316 => 0x4, 320 => 0x1e, 321 => 0x1b, 322 => [0x1b,0x21] },
	'afstatusbottom' => { 146 => 0x8, 320 => 0x2a, 321 => 0x21, 322 => 0x21 },
	'afstatusbottom-left' => { 146 => 0x12, 321 => 0x2b, 322 => 0x2b },
	'afstatusbottom-right' => { 146 => 0x6, 321 => 0x1f, 322 => 0x1f },
	'afstatusbottomassist-left' => { 320 => 0x28 },
	'afstatusbottomassist-right' => { 320 => 0x2c },
	'afstatusbottomhorizontal' => { 318 => 0x10, 319 => 0x1c },
	'afstatusbottomvertical' => { 318 => 0x16, 319 => 0x26 },
	'afstatuscenter-10' => { 320 => 0x34 },
	'afstatuscenter-11' => { 320 => 0x36 },
	'afstatuscenter-12' => { 320 => 0x38 },
	'afstatuscenter-14' => { 320 => 0x3c },
	'afstatuscenter-7' => { 320 => 0x2e },
	'afstatuscenter-9' => { 320 => 0x32 },
	'afstatuscenter-horizontal' => { 320 => 0x30 },
	'afstatuscenter-vertical' => { 320 => 0x3a },
	'afstatuscenterf2-8' => { 320 => 0x4c },
	'afstatuscenterhorizontal' => { 146 => 0x2f, 318 => 0xc, 319 => 0x18, 321 => 0x2f, 322 => 0x2f },
	'afstatuscentervertical' => { 146 => 0xc, 318 => 0x14, 319 => 0x22, 321 => 0x25, 322 => 0x25 },
	'afstatusfarleft' => { 318 => 0x6, 320 => 0x26 },
	'afstatusfarlefthorizontal' => { 319 => 0x4 },
	'afstatusfarleftvertical' => { 319 => 0x12 },
	'afstatusfarright' => { 318 => 0x18, 320 => 0x44 },
	'afstatusfarrighthorizontal' => { 319 => 0x2c },
	'afstatusfarrightvertical' => { 319 => 0x34 },
	'afstatusleft' => { 146 => 0x2d, 318 => 0x2, 320 => 0x22, 321 => 0x2d, 322 => 0x2d },
	'afstatuslefthorizontal' => { 319 => 0x6 },
	'afstatusleftvertical' => { 319 => 0xe },
	'afstatuslower-left' => { 318 => 0x4, 320 => 0x24 },
	'afstatuslower-lefthorizontal' => { 319 => 0xa },
	'afstatuslower-leftvertical' => { 319 => 0x10 },
	'afstatuslower-middle' => { 318 => 0x22, 319 => 0x24 },
	'afstatuslower-right' => { 318 => 0x1e, 320 => 0x4a },
	'afstatuslower-righthorizontal' => { 319 => 0x32 },
	'afstatuslower-rightvertical' => { 319 => 0x3a },
	'afstatuslowerfarleft' => { 319 => 0x8 },
	'afstatuslowerfarright' => { 319 => 0x30 },
	'afstatusmiddlehorizontal' => { 146 => 0xa, 321 => 0x23, 322 => 0x23 },
	'afstatusnearleft' => { 318 => 0xe, 319 => 0x1a },
	'afstatusnearright' => { 318 => 0xa, 319 => 0x16 },
	'afstatusright' => { 146 => 0x31, 318 => 0x1c, 320 => 0x48, 321 => 0x31, 322 => 0x31 },
	'afstatusrighthorizontal' => { 319 => 0x2e },
	'afstatusrightvertical' => { 319 => 0x38 },
	'afstatustop' => { 146 => 0xe, 320 => 0x40, 321 => 0x27, 322 => 0x27 },
	'afstatustop-left' => { 146 => 0x10, 321 => 0x29, 322 => 0x29 },
	'afstatustop-right' => { 146 => 0x4, 321 => 0x1d, 322 => 0x1d },
	'afstatustopassist-left' => { 320 => 0x3e },
	'afstatustopassist-right' => { 320 => 0x42 },
	'afstatustophorizontal' => { 318 => 0x8, 319 => 0x14 },
	'afstatustopvertical' => { 318 => 0x12, 319 => 0x1e },
	'afstatusupper-left' => { 318 => 0x0, 320 => 0x20 },
	'afstatusupper-lefthorizontal' => { 319 => 0x2 },
	'afstatusupper-leftvertical' => { 319 => 0xc },
	'afstatusupper-middle' => { 318 => 0x20, 319 => 0x20 },
	'afstatusupper-right' => { 318 => 0x1a, 320 => 0x46 },
	'afstatusupper-righthorizontal' => { 319 => 0x2a },
	'afstatusupper-rightvertical' => { 319 => 0x36 },
	'afstatusupperfarleft' => { 319 => 0x0 },
	'afstatusupperfarright' => { 319 => 0x28 },
	'aftype' => { 316 => 0x2 },
	'afwithshutter' => { 323 => 0x2a },
	'aggregationtype' => { 390 => 'aggregationType' },
	'agreement' => { 392 => 'agreement' },
	'aiservocontinuousshooting' => { 67 => 0x15 },
	'aiservofirstimagepriority' => { 68 => 0x519 },
	'aiservoimagepriority' => { 68 => 0x503 },
	'aiservosecondimagepriority' => { 68 => 0x51a },
	'aiservotrackingmethod' => { 68 => 0x504 },
	'aiservotrackingsensitivity' => { 67 => 0x14, 68 => 0x502 },
	'album' => { 399 => 'album' },
	'alreadyapplied' => { 376 => 'AlreadyApplied' },
	'alternatetitle' => { 390 => 'alternateTitle' },
	'altitude' => { 160 => 0x6 },
	'alttapename' => { 399 => 'altTapeName' },
	'alttimecode' => { 399 => 'altTimecode' },
	'alttimecodetimeformat' => { 399 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 399 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 399 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 3 => 0x1 },
	'ambienttemperature' => { 302 => 0x14, 353 => 0x4 },
	'ambienttemperaturefahrenheit' => { 302 => 0x13 },
	'analogbalance' => { 95 => 0xc627 },
	'angleadj' => { 87 => 0x8b },
	'angleinforoll' => { 372 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 372 => 'AngleInfoYaw' },
	'anti-blur' => { 335 => 0xb04b },
	'antialiasstrength' => { 95 => 0xc632 },
	'aperturerange' => { 68 => 0x10d },
	'apertureringuse' => { 265 => '1.4' },
	'aperturesetting' => { 150 => 0x7, 323 => 0x30, 324 => 0x29, 325 => 0x1 },
	'aperturevalue' => { 77 => 0x2, 95 => 0x9202, 238 => 0x1002, 380 => 'ApertureValue' },
	'applekeywords' => { 242 => 'AAPL:Keywords' },
	'applicationnotes' => { 95 => 0x2bc, 257 => 0x2bc },
	'applicationrecordversion' => { 103 => 0x0 },
	'applyshootingmeteringmode' => { 68 => 0x10e },
	'approved' => { 382 => 'Approved' },
	'approvedby' => { 382 => 'ApprovedBy' },
	'approximatefnumber' => { 249 => 0x313, 255 => 0x3406 },
	'approximatefocusdistance' => { 373 => 'ApproximateFocusDistance' },
	'armidentifier' => { 104 => 0x78 },
	'armversion' => { 104 => 0x7a },
	'artfilter' => { 233 => 0x529 },
	'artfiltereffect' => { 233 => 0x52f },
	'artist' => { 95 => 0x13b, 245 => 'Artist', 284 => 0x22e, 395 => 'Artist', 399 => 'artist' },
	'artmode' => { 91 => 0x301b },
	'artmodeparameters' => { 91 => 0x310b },
	'artworkcopyrightnotice' => { 386 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 386 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 386 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 386 => 'ArtworkOrObject' },
	'artworksource' => { 386 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 386 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 386 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 237 => 0x1113 },
	'aspectratio' => { 4 => 0x0, 237 => 0x1112, 284 => 0x80, 323 => 0x55, 324 => 0x55, 325 => 0xa },
	'asshoticcprofile' => { 95 => 0xc68f },
	'asshotneutral' => { 95 => 0xc628 },
	'asshotpreprofilematrix' => { 95 => 0xc690 },
	'asshotprofilename' => { 95 => 0xc6f6 },
	'asshotwhitexy' => { 95 => 0xc629 },
	'assignbktbutton' => { 222 => '4.2' },
	'assignfuncbutton' => { 68 => 0x70b },
	'assistbuttonfunction' => { 66 => 0xd },
	'attributionname' => { 374 => 'attributionName' },
	'attributionurl' => { 374 => 'attributionURL' },
	'audio' => { 253 => 0x20 },
	'audiobitrate' => { 54 => 0x6c },
	'audiochannels' => { 54 => 0x70 },
	'audiochanneltype' => { 399 => 'audioChannelType' },
	'audiocompression' => { 124 => 'Compression' },
	'audiocompressor' => { 399 => 'audioCompressor' },
	'audioduration' => { 103 => 0x99 },
	'audiomoddate' => { 399 => 'audioModDate' },
	'audiooutcue' => { 103 => 0x9a },
	'audiosamplerate' => { 54 => 0x6e, 399 => 'audioSampleRate' },
	'audiosampletype' => { 399 => 'audioSampleType' },
	'audiosamplingrate' => { 103 => 0x97 },
	'audiosamplingresolution' => { 103 => 0x98 },
	'audiotype' => { 103 => 0x96 },
	'author' => { 126 => 'Author', 242 => 'Author', 245 => 'Author', 297 => 'Author', 371 => 'author', 387 => 'Author', 397 => 'Author' },
	'authorsposition' => { 388 => 'AuthorsPosition' },
	'autoaperture' => { 275 => '0.1' },
	'autobracket' => { 315 => 0x19 },
	'autobracketing' => { 100 => 0x1100, 284 => 0x18, 306 => 0x1007 },
	'autobracketingmode' => { 230 => '12.3' },
	'autobracketingset' => { 230 => '12.1' },
	'autobracketmodem' => { 222 => '21.2', 227 => '26.2' },
	'autobracketorder' => { 150 => 0x43, 222 => '21.3', 227 => '26.3', 228 => '12.2', 229 => '2.2', 230 => '12.2', 231 => '13.2' },
	'autobracketset' => { 222 => '21.1', 224 => '11.1', 225 => '12.1', 226 => '12.1', 227 => '26.1', 228 => '12.1', 229 => '2.1', 231 => '13.1' },
	'autobrightness' => { 376 => 'AutoBrightness' },
	'autocontrast' => { 376 => 'AutoContrast' },
	'autodistortioncontrol' => { 168 => 0x4 },
	'autodynamicrange' => { 100 => 0x140b },
	'autoexposure' => { 376 => 'AutoExposure' },
	'autoexposurebracketing' => { 62 => 0x10 },
	'autofocus' => { 236 => 0x209 },
	'autofp' => { 229 => '7.3', 231 => '31.4' },
	'autoiso' => { 62 => 0x1, 91 => 0x3008, 223 => '1.1', 229 => '1.1' },
	'autoisomax' => { 223 => '1.2', 229 => '1.2' },
	'autoisominshutterspeed' => { 223 => '1.3', 229 => '1.3' },
	'autolateralca' => { 376 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 14 => 0xbe, 15 => 0xbf, 18 => 0xbf, 50 => 0x2, 68 => 0x204, 87 => 0x6f },
	'autolightingoptimizeron' => { 87 => 0x6e },
	'autoportraitframed' => { 335 => 0x2016 },
	'autoredeye' => { 215 => 0xfe28a44f },
	'autorotate' => { 62 => 0x1b },
	'autoshadows' => { 376 => 'AutoShadows' },
	'autowhiteversion' => { 376 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 182 => 0x82 },
	'avaperturesetting' => { 265 => 0x13 },
	'averageblacklevel' => { 36 => 0xe7, 38 => 0xfb, 39 => 0x114 },
	'averagelv' => { 153 => 0x38 },
	'avsettingwithoutlens' => { 68 => 0x707 },
	'azimuth' => { 134 => 'Azimuth' },
	'babyage' => { 253 => [0x8010,0x33] },
	'babyname' => { 253 => 0x66 },
	'backgroundalpha' => { 394 => 'bgalpha' },
	'baseexposurecompensation' => { 265 => 0x15 },
	'baseiso' => { 62 => 0x2, 81 => 0x101c, 255 => 0x312a, 358 => 0x6 },
	'baselineexposure' => { 95 => 0xc62a },
	'baselineexposureoffset' => { 95 => 0xc7a5 },
	'baselinenoise' => { 95 => 0xc62b },
	'baselinesharpness' => { 95 => 0xc62c },
	'baseurl' => { 397 => 'BaseURL' },
	'batterylevel' => { 323 => 0x51, 327 => 0xc, 328 => 0x4, 329 => 0x4, 359 => 0x7 },
	'batterylevelgrip1' => { 359 => 0x6 },
	'batterylevelgrip2' => { 359 => 0x8 },
	'batteryorder' => { 222 => '12.5', 227 => '13.2', 228 => '2.1' },
	'batterystate' => { 150 => 0x60, 323 => 0x50, 329 => 0x14 },
	'batterytemperature' => { 327 => 0x1, 329 => 0x2, 359 => 0x5 },
	'batteryunknown' => { 327 => 0x2, 329 => 0x0 },
	'batteryvoltage' => { 302 => 0x2a, 327 => 0x8 },
	'batteryvoltage1' => { 329 => 0x6 },
	'batteryvoltage2' => { 329 => 0x8 },
	'bayergreensplit' => { 95 => 0xc62d },
	'bayerpattern' => { 108 => 0xf902, 154 => 0x17 },
	'beatspliceparams' => { 399 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 399 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 399 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 399 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 399 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 399 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 222 => '13.1', 223 => '0.1', 224 => '2.1', 225 => '3.1', 226 => '3.1', 227 => '10.1', 229 => '0.1', 231 => '4.1' },
	'beeppitch' => { 228 => '3.1' },
	'beepvolume' => { 228 => '4.5' },
	'bestqualityscale' => { 95 => 0xc65c },
	'bestshotmode' => { 91 => 0x3007 },
	'bitdepth' => { 131 => 'BitDepth', 154 => 0x11, 187 => 0x41 },
	'bitspercomponent' => { 105 => 0x87 },
	'bitspersample' => { 95 => 0x102, 395 => 'BitsPerSample' },
	'blacklevel' => { 95 => 0xc61a, 182 => 0x3d, 238 => 0x1012 },
	'blacklevel1' => { 257 => 0x8 },
	'blacklevel2' => { 237 => 0x600, 241 => 0x600, 257 => 0x9 },
	'blacklevel3' => { 257 => 0xa },
	'blacklevelblue' => { 257 => 0x1e },
	'blackleveldeltah' => { 95 => 0xc61b },
	'blackleveldeltav' => { 95 => 0xc61c },
	'blacklevelgreen' => { 257 => 0x1d },
	'blacklevelred' => { 257 => 0x1c },
	'blacklevelrepeatdim' => { 95 => 0xc619 },
	'blackpoint' => { 284 => 0x200 },
	'blacks2012' => { 376 => 'Blacks2012' },
	'bleachbypasstoning' => { 284 => 0x7f },
	'bluebalance' => { 166 => 0x271, 238 => 0x1018, 257 => 0x12, 284 => 0x1b },
	'bluecurvelimits' => { 86 => 0x1fe },
	'bluecurvepoints' => { 86 => 0x1d4 },
	'bluehue' => { 376 => 'BlueHue' },
	'bluesaturation' => { 376 => 'BlueSaturation' },
	'blurcontrol' => { 284 => 0x82 },
	'blurwarning' => { 100 => 0x1300 },
	'bodybatteryadload' => { 263 => 0x3 },
	'bodybatteryadnoload' => { 263 => 0x2 },
	'bodybatterystate' => { 263 => '1.1' },
	'bodybatteryvoltage1' => { 263 => 0x2 },
	'bodybatteryvoltage2' => { 263 => 0x4 },
	'bodybatteryvoltage3' => { 263 => 0x6 },
	'bodybatteryvoltage4' => { 263 => 0x8 },
	'bodyfirmware' => { 307 => 0x0 },
	'bodyfirmwareversion' => { 234 => 0x104, 235 => 0x100, 238 => 0x104 },
	'bodyserialnumber' => { 307 => 0x10 },
	'bracketmode' => { 46 => 0x3 },
	'bracketsequence' => { 91 => 0x301d },
	'bracketsettings' => { 253 => 0x45 },
	'bracketshotnumber' => { 46 => 0x5, 265 => 0x9, 334 => 0x2b },
	'bracketshotnumber2' => { 334 => 0x2d },
	'bracketstep' => { 147 => 0xe },
	'bracketvalue' => { 46 => 0x4 },
	'brightness' => { 95 => 0xfe53, 125 => 'Brightness', 147 => 0x2c, 184 => 0x34, 302 => 0x25, 323 => 0x22, 335 => 0x2007, 376 => 'Brightness' },
	'brightnessadj' => { 86 => 0x114, 208 => 0x0, 218 => 0x2d, 362 => 0x8018 },
	'brightnessvalue' => { 95 => 0x9203, 153 => [0x691,0x49c3], 238 => 0x1003, 342 => 0x1140, 343 => 0x1140, 344 => 0x111c, 345 => 0x1198, 346 => 0x1174, 347 => 0x102c, 348 => 0x224, 380 => 'BrightnessValue' },
	'bulbduration' => { 62 => 0x18 },
	'burstmode' => { 111 => 0xa, 253 => 0x2a },
	'burstmode2' => { 111 => 0x18 },
	'burstshot' => { 315 => 0x34 },
	'burstspeed' => { 253 => 0x77 },
	'buttonfunctioncontroloff' => { 68 => 0x70a },
	'bwfilter' => { 147 => 0x2a, 155 => 0x39 },
	'bwmode' => { 238 => 0x203 },
	'by-line' => { 103 => 0x50 },
	'by-linetitle' => { 103 => 0x55 },
	'bytecount' => { 390 => 'byteCount' },
	'calibration' => { 315 => [0x24,0x30] },
	'calibrationilluminant1' => { 95 => 0xc65a },
	'calibrationilluminant2' => { 95 => 0xc65b },
	'cameraangle' => { 399 => 'cameraAngle' },
	'cameracalibration1' => { 95 => 0xc623 },
	'cameracalibration2' => { 95 => 0xc624 },
	'cameracalibrationsig' => { 95 => 0xc6f3 },
	'cameracolorcalibration01' => { 31 => 0x0, 37 => 0xba },
	'cameracolorcalibration02' => { 31 => 0x4, 37 => 0xbf },
	'cameracolorcalibration03' => { 31 => 0x8, 37 => 0xc4 },
	'cameracolorcalibration04' => { 31 => 0xc, 37 => 0xc9 },
	'cameracolorcalibration05' => { 31 => 0x10, 37 => 0xce },
	'cameracolorcalibration06' => { 31 => 0x14, 37 => 0xd3 },
	'cameracolorcalibration07' => { 31 => 0x18, 37 => 0xd8 },
	'cameracolorcalibration08' => { 31 => 0x1c, 37 => 0xdd },
	'cameracolorcalibration09' => { 31 => 0x20, 37 => 0xe2 },
	'cameracolorcalibration10' => { 31 => 0x24, 37 => 0xe7 },
	'cameracolorcalibration11' => { 31 => 0x28, 37 => 0xec },
	'cameracolorcalibration12' => { 31 => 0x2c, 37 => 0xf1 },
	'cameracolorcalibration13' => { 31 => 0x30, 37 => 0xf6 },
	'cameracolorcalibration14' => { 31 => 0x34, 37 => 0xfb },
	'cameracolorcalibration15' => { 31 => 0x38, 37 => 0x100 },
	'cameraid' => { 238 => 0x209, 314 => 0x209 },
	'cameraiso' => { 29 => 0x10 },
	'cameralabel' => { 95 => 0xc7a1, 399 => 'cameraLabel' },
	'cameramodel' => { 399 => 'cameraModel' },
	'cameramove' => { 399 => 'cameraMove' },
	'cameraorientation' => { 5 => 0x30, 7 => 0x7d, 9 => 0x30, 11 => 0x35, 12 => 0x30, 13 => 0x30, 14 => 0x31, 15 => 0x31, 16 => 0x35, 17 => 0x27, 18 => 0x31, 19 => 0x7d, 20 => 0x38, 21 => 0x36, 22 => 0x7d, 23 => 0x83, 24 => 0x84, 25 => 0x35, 253 => 0x8f, 287 => 0x1, 329 => [0x16,0x18], 350 => 0x28, 351 => 0x24, 352 => 0x29 },
	'cameraowner' => { 112 => 0xc353 },
	'cameraparameters' => { 238 => 0x2050 },
	'cameraprofile' => { 376 => 'CameraProfile' },
	'cameraprofiledigest' => { 376 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 95 => 0xc62f, 145 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 233 => 0x0 },
	'cameratemperature' => { 5 => 0x18, 7 => 0x1b, 9 => 0x18, 11 => 0x19, 12 => 0x18, 13 => 0x18, 14 => 0x19, 15 => 0x19, 16 => 0x19, 17 => 0x17, 18 => 0x19, 19 => 0x1b, 20 => 0x19, 21 => 0x19, 22 => 0x1b, 23 => 0x1b, 24 => 0x1b, 25 => 0x19, 26 => [0x87,0x91], 27 => [0x99,0x9f,0xa4,0xa8,0x105], 28 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 62 => 0xc, 237 => 0x1306, 249 => 0x320, 255 => 0x3402, 284 => 0x47, 312 => 0x43, 354 => 0x5 },
	'cameratemperature2' => { 288 => 0xc },
	'cameratemperature3' => { 288 => 0xe },
	'cameratemperature4' => { 288 => 0x14 },
	'cameratemperature5' => { 288 => 0x16 },
	'cameratemperaturerangemax' => { 97 => 0x5 },
	'cameratemperaturerangemin' => { 97 => 0x6 },
	'cameratype' => { 62 => 0x1a, 238 => 0x207 },
	'cameratype2' => { 234 => 0x100 },
	'canonexposuremode' => { 29 => 0x14 },
	'canonfiledescription' => { 81 => 0x805 },
	'canonfilelength' => { 51 => 0xe },
	'canonfirmwareversion' => { 51 => 0x7, 81 => 0x80b },
	'canonflashinfo' => { 81 => 0x1028 },
	'canonflashmode' => { 29 => 0x4 },
	'canonimagesize' => { 8 => 0x39, 29 => 0xa },
	'canonimagetype' => { 51 => 0x6, 81 => 0x815 },
	'canonmodelid' => { 51 => 0x10, 81 => 0x1834 },
	'canonvrd' => { 96 => 'CanonVRD' },
	'caption' => { 371 => 'caption' },
	'caption-abstract' => { 103 => 0x78 },
	'captionsauthornames' => { 379 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 379 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 388 => 'CaptionWriter' },
	'captureframerate' => { 91 => 0x4001 },
	'capturesoftware' => { 366 => 'CaptureSoftware' },
	'cardshutterlock' => { 150 => 0x49 },
	'casioimagesize' => { 91 => 0x9 },
	'catalogsets' => { 103 => 0xff, 365 => 'CatalogSets', 369 => 'CatalogSets' },
	'categories' => { 51 => 0x23, 371 => 'categories' },
	'category' => { 103 => 0xf, 232 => 0x30, 388 => 'Category' },
	'ccdboardversion' => { 249 => 0x331 },
	'ccdscanmode' => { 238 => 0x1039 },
	'ccdsensitivity' => { 205 => 0x6 },
	'ccdversion' => { 249 => 0x330 },
	'cellglobalid' => { 375 => 'cgi' },
	'celllength' => { 95 => 0x109 },
	'cellr' => { 375 => 'r' },
	'celltowerid' => { 375 => 'cellid' },
	'cellwidth' => { 95 => 0x108 },
	'centerafarea' => { 229 => '15.1' },
	'centerfocuspoint' => { 231 => '2.2' },
	'centerweightedareasize' => { 222 => '7.1', 227 => '5.1', 228 => '7.1', 229 => '6.3', 231 => '8.1' },
	'certificate' => { 403 => 'Certificate' },
	'cfapattern' => { 95 => 0xa302, 380 => 'CFAPattern' },
	'cfapattern2' => { 95 => 0x828e },
	'cfapatterncolumns' => { 380 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 380 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 380 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 95 => 0x828d },
	'channel' => { 390 => 'channel' },
	'channels' => { 124 => 'Channels' },
	'checkmark' => { 86 => 0x26a },
	'checkmark2' => { 87 => 0x8e },
	'childfontfiles' => { 404 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 222 => '10.3' },
	'chromablurradius' => { 95 => 0xc631 },
	'chromaticaberration' => { 87 => 0x66 },
	'chromaticaberrationb' => { 376 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 87 => 0x6b },
	'chromaticaberrationcorr' => { 64 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 274 => 0x1 },
	'chromaticaberrationon' => { 87 => 0x62 },
	'chromaticaberrationr' => { 376 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 87 => 0x6a },
	'chromaticaberrationsetting' => { 65 => 0x6 },
	'chrominancenoisereduction' => { 87 => 0x5e, 315 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 87 => 0x60 },
	'circgradbasedcorractive' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 376 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 376 => 'CircularGradientBasedCorrections' },
	'city' => { 103 => 0x5a, 130 => 'City', 253 => 0x6d, 388 => 'City' },
	'city2' => { 253 => 0x80 },
	'clarity' => { 376 => 'Clarity' },
	'clarity2012' => { 376 => 'Clarity2012' },
	'classifystate' => { 103 => 0xe1 },
	'clearretouch' => { 253 => 0x7c },
	'clearretouchvalue' => { 253 => 0xa3 },
	'client' => { 399 => 'client' },
	'clientname' => { 382 => 'ClientName' },
	'clmodeshootingspeed' => { 222 => '10.2', 227 => '11.2', 228 => '10.2', 231 => '11.1' },
	'cmcontrast' => { 241 => 0x2022 },
	'cmexposurecompensation' => { 241 => 0x2000 },
	'cmhue' => { 241 => 0x2021 },
	'cmsaturation' => { 241 => 0x2020 },
	'cmsharpness' => { 241 => 0x2023 },
	'cmwhitebalance' => { 241 => 0x2001 },
	'cmwhitebalancecomp' => { 241 => 0x2002 },
	'cmwhitebalancegraypoint' => { 241 => 0x2010 },
	'codec' => { 138 => 'Codec' },
	'codedcharacterset' => { 104 => 0x5a },
	'collectionname' => { 139 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 139 => 'Collections' },
	'collectionuri' => { 139 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 215 => 0xc89224b },
	'coloradjustment' => { 315 => 0x14 },
	'coloradjustmentmode' => { 314 => 0x210 },
	'coloranta' => { 404 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 404 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 404 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 404 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 404 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 404 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 404 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 404 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 404 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 404 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 404 => 'Colorants' },
	'colorantswatchname' => { 404 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 404 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 404 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 404 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 125 => 'ColorBalance' },
	'colorbalanceadj' => { 215 => 0x76a43202 },
	'colorbalanceblue' => { 147 => 0x1e },
	'colorbalancegreen' => { 147 => 0x1d },
	'colorbalancered' => { 147 => 0x1c },
	'colorbalanceversion' => { 167 => 0x0 },
	'colorblur' => { 87 => 0x65 },
	'colorbooster' => { 215 => 0x5f0e7d23 },
	'colorboostlevel' => { 209 => 0x1 },
	'colorboosttype' => { 209 => 0x0 },
	'colorclass' => { 292 => 0xde, 293 => 'ColorClass' },
	'colorcompensationfilter' => { 150 => [0x3a,0x5f], 152 => 0x111, 335 => 0xb022 },
	'colorcompensationfilterset' => { 323 => 0xd, 324 => 0xc, 325 => 0x18, 339 => 0xf },
	'colorcontrol' => { 238 => 0x102b },
	'colorcorrection' => { 362 => 0x8015 },
	'colordataversion' => { 35 => 0x0, 36 => 0x0, 38 => 0x0, 39 => 0x0 },
	'coloreffect' => { 253 => 0x28 },
	'colorfilter' => { 90 => 0x17, 91 => 0x3017, 147 => 0x29, 155 => [0x38,0x4d,0x4f], 290 => 0x17 },
	'colorgain' => { 187 => 0x51 },
	'colorhue' => { 182 => 0x8d },
	'colorimetricreference' => { 95 => 0xc6bf },
	'colorlabel' => { 379 => 'ColorLabel' },
	'colormatrix' => { 237 => 0x200, 238 => 0x1011, 312 => 0xa030 },
	'colormatrix1' => { 95 => 0xc621 },
	'colormatrix2' => { 95 => 0xc622, 241 => 0x200 },
	'colormatrixa' => { 284 => 0x203 },
	'colormatrixadobergb' => { 312 => 0xa032 },
	'colormatrixb' => { 284 => 0x204 },
	'colormatrixnumber' => { 238 => 0x1019 },
	'colormatrixsrgb' => { 312 => 0xa031 },
	'colormode' => { 91 => 0x3015, 100 => 0x1210, 111 => 0x66, 147 => 0x28, 150 => 0x16, 152 => 0x101, 153 => 0x36, 155 => 0x7, 182 => 0x3, 205 => 0x4, 253 => 0x32, 315 => 0x2c, 335 => 0xb029, 388 => 'ColorMode' },
	'colormoirereduction' => { 216 => 0x15 },
	'colormoirereductionmode' => { 216 => 0x5 },
	'colornoisereduction' => { 362 => 0x8029, 376 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 376 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 216 => 0x18 },
	'colornoisereductionsharpness' => { 216 => 0x1c },
	'colornoisereductionsmoothness' => { 376 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 99 => 0x2 },
	'colorprofile' => { 147 => 0x33 },
	'colorrepresentation' => { 105 => 0x3c },
	'colorsequence' => { 105 => 0x41 },
	'colorspace' => { 40 => 0x3, 51 => 0xb4, 81 => 0x10b4, 95 => 0xa001, 131 => 'ColorSpace', 148 => 0x2f, 149 => 0x25, 150 => 0x17, 182 => 0x1e, 233 => 0x507, 284 => 0x37, 312 => 0xa011, 315 => 0xb, 323 => 0x1b, 324 => 0x83, 325 => 0xe, 339 => 0x6, 380 => 'ColorSpace' },
	'colortempasshot' => { 32 => 0x4, 33 => 0x1d, 34 => 0x26, 35 => 0x43, 38 => 0x43, 39 => 0x43 },
	'colortempauto' => { 32 => 0x9, 33 => 0x22, 34 => 0x1c, 35 => 0x48, 38 => 0x48, 39 => 0x48 },
	'colortempcloudy' => { 32 => 0x22, 33 => 0x31, 34 => 0x35, 35 => 0x5c, 38 => 0x75, 39 => 0x8e, 284 => 0x55 },
	'colortempcustom' => { 35 => 0x84 },
	'colortempcustom1' => { 33 => 0x45 },
	'colortempcustom2' => { 33 => 0x4a },
	'colortempdaylight' => { 32 => 0x18, 33 => 0x27, 34 => 0x2b, 35 => 0x52, 38 => 0x6b, 39 => 0x84, 284 => 0x53 },
	'colortemperature' => { 5 => 0x73, 6 => [0x48,0x4e], 7 => 0xc0, 8 => 0x37, 9 => 0x62, 10 => 0x37, 11 => 0x7c, 12 => 0x73, 13 => 0x73, 14 => 0x77, 15 => 0x73, 16 => 0x7c, 17 => 0x58, 18 => 0x73, 19 => 0xc0, 20 => 0x7f, 21 => 0x7d, 22 => 0xc0, 23 => 0xc6, 24 => 0xc7, 25 => 0x7b, 51 => 0xae, 60 => 0x9, 81 => 0x10ae, 100 => 0x1005, 109 => 0x846, 125 => 'ColorTemperature', 148 => [0x6e,0x49], 149 => 0x3f, 150 => [0x39,0x5e], 152 => 0x10b, 155 => [0x3c,0x4c,0x4e], 249 => 0x321, 284 => 0x50, 306 => 0x1308, 335 => 0xb021, 376 => 'Temperature' },
	'colortemperatureadj' => { 362 => 0x8013 },
	'colortemperaturebg' => { 238 => 0x1013 },
	'colortemperaturerg' => { 238 => 0x1014 },
	'colortemperaturesetting' => { 150 => 0x25, 323 => 0xc, 324 => 0xb, 325 => 0x17, 339 => 0xe },
	'colortempflash' => { 32 => 0x36, 33 => 0x40, 34 => 0x49, 35 => 0x70, 38 => 0x89, 39 => 0xa2, 284 => 0x5a },
	'colortempflashdata' => { 35 => 0x24a },
	'colortempfluorescent' => { 32 => 0x2c, 33 => 0x3b, 34 => 0x3f, 35 => 0x66, 38 => 0x7f, 39 => 0x98 },
	'colortempfluorescentd' => { 284 => 0x57 },
	'colortempfluorescentn' => { 284 => 0x58 },
	'colortempfluorescentw' => { 284 => 0x59 },
	'colortempkelvin' => { 32 => 0x31, 34 => 0x44, 35 => 0x6b, 38 => 0x84, 39 => 0x9d, 253 => 0x44, 306 => 0x1307 },
	'colortempmeasured' => { 32 => 0xe, 35 => 0x4d, 38 => 0x4d, 39 => 0x4d },
	'colortemppc1' => { 34 => 0x94, 35 => 0x75 },
	'colortemppc2' => { 34 => 0x99, 35 => 0x7a },
	'colortemppc3' => { 34 => 0x9e, 35 => 0x7f },
	'colortempshade' => { 32 => 0x1d, 33 => 0x2c, 34 => 0x30, 35 => 0x57, 38 => 0x70, 39 => 0x89, 284 => 0x54 },
	'colortemptungsten' => { 32 => 0x27, 33 => 0x36, 34 => 0x3a, 35 => 0x61, 38 => 0x7a, 39 => 0x93, 284 => 0x56 },
	'colortempunknown' => { 32 => 0x13, 34 => 0x21, 38 => 0x52, 39 => 0x52 },
	'colortempunknown10' => { 32 => 0x63, 34 => 0x76, 38 => 0xa2, 39 => 0x7f },
	'colortempunknown11' => { 32 => 0x68, 34 => 0x7b, 38 => 0xa7, 39 => 0xa7 },
	'colortempunknown12' => { 32 => 0x6d, 34 => 0x80, 38 => 0xac, 39 => 0xac },
	'colortempunknown13' => { 32 => 0x72, 34 => 0x85, 38 => 0xb1, 39 => 0xb1 },
	'colortempunknown14' => { 34 => 0x8a, 38 => 0xb6, 39 => 0xb6 },
	'colortempunknown15' => { 34 => 0x8f, 38 => 0xbb, 39 => 0xbb },
	'colortempunknown16' => { 34 => 0xa3, 39 => 0xc0 },
	'colortempunknown17' => { 39 => 0xc5 },
	'colortempunknown18' => { 39 => 0xca },
	'colortempunknown19' => { 39 => 0xcf },
	'colortempunknown2' => { 32 => 0x3b, 34 => 0x4e, 38 => 0x57, 39 => 0x57 },
	'colortempunknown20' => { 39 => 0xd4 },
	'colortempunknown3' => { 32 => 0x40, 34 => 0x53, 38 => 0x5c, 39 => 0x5c },
	'colortempunknown4' => { 32 => 0x45, 34 => 0x58, 38 => 0x61, 39 => 0x61 },
	'colortempunknown5' => { 32 => 0x4a, 34 => 0x5d, 38 => 0x66, 39 => 0x66 },
	'colortempunknown6' => { 32 => 0x4f, 34 => 0x62, 38 => 0x8e, 39 => 0x6b },
	'colortempunknown7' => { 32 => 0x54, 34 => 0x67, 38 => 0x93, 39 => 0x70 },
	'colortempunknown8' => { 32 => 0x59, 34 => 0x6c, 38 => 0x98, 39 => 0x75 },
	'colortempunknown9' => { 32 => 0x5e, 34 => 0x71, 38 => 0x9d, 39 => 0x7a },
	'colortone' => { 8 => 0x6f, 10 => 0x77, 29 => 0x2a, 40 => 0x2 },
	'colortoneadj' => { 86 => 0x11e },
	'colortoneauto' => { 57 => 0x9c },
	'colortonefaithful' => { 17 => 0x107, 56 => 0x6c, 57 => 0x6c },
	'colortonelandscape' => { 17 => 0x105, 56 => 0x3c, 57 => 0x3c },
	'colortonemonochrome' => { 56 => 0x84, 57 => 0x84 },
	'colortoneneutral' => { 17 => 0x106, 56 => 0x54, 57 => 0x54 },
	'colortoneportrait' => { 17 => 0x104, 56 => 0x24, 57 => 0x24 },
	'colortonestandard' => { 17 => 0x103, 56 => 0xc, 57 => 0xc },
	'colortoneuserdef1' => { 17 => 0x109, 56 => 0x9c, 57 => 0xb4 },
	'colortoneuserdef2' => { 17 => 0x10a, 56 => 0xb4, 57 => 0xcc },
	'colortoneuserdef3' => { 17 => 0x10b, 56 => 0xcc, 57 => 0xe4 },
	'commanddials' => { 229 => '5.1' },
	'commanddialsaperturesetting' => { 222 => '17.3', 227 => '33.3', 228 => '17.3' },
	'commanddialschangemainsub' => { 222 => '17.2', 227 => '33.2', 228 => '17.2' },
	'commanddialsmenuandplayback' => { 222 => '17.4', 227 => '33.4', 228 => '17.4' },
	'commanddialsreverserotation' => { 222 => '17.1', 224 => '16.2', 225 => '17.2', 227 => '33.1', 228 => '17.1', 231 => '18.1' },
	'commanderchannel' => { 229 => '10.2', 230 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 229 => '13.1', 230 => '31.1' },
	'commandergroupa_ttlcomp' => { 231 => '32.1' },
	'commandergroupamanualoutput' => { 229 => '13.2', 230 => '28.2' },
	'commandergroupamode' => { 229 => '11.2', 230 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 229 => '14.1', 230 => '32.1' },
	'commandergroupb_ttlcomp' => { 231 => '33.1' },
	'commandergroupbmanualoutput' => { 229 => '14.2', 230 => '29.2' },
	'commandergroupbmode' => { 229 => '11.3', 230 => '29.1' },
	'commanderinternalflash' => { 229 => '11.1', 230 => '27.1' },
	'commanderinternalmanualoutput' => { 229 => '12.2', 230 => '27.2' },
	'commanderinternalttlchannel' => { 227 => '18.2' },
	'commanderinternalttlcomp' => { 229 => '12.1', 230 => '30.2', 231 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 227 => '20.1', 228 => '26.1' },
	'commanderinternalttlcompgroupa' => { 227 => '21.1', 228 => '27.1' },
	'commanderinternalttlcompgroupb' => { 227 => '22.1', 228 => '28.1' },
	'comment' => { 0 => 0x2, 96 => 'Comment', 126 => 'Comment', 245 => 'Comment' },
	'compass' => { 309 => 0x4 },
	'complianceprofile' => { 390 => 'complianceProfile' },
	'componentsconfiguration' => { 95 => 0x9101, 131 => 'Components', 380 => 'ComponentsConfiguration' },
	'componentversion' => { 81 => 0x80c },
	'composer' => { 399 => 'composer' },
	'compositionadjust' => { 283 => '0.1' },
	'compositionadjustrotation' => { 283 => 0x7 },
	'compositionadjustx' => { 283 => 0x5 },
	'compositionadjusty' => { 283 => 0x6 },
	'compressedbitsperpixel' => { 95 => 0x9102, 380 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 152 => 0x40, 238 => 0x40 },
	'compression' => { 95 => 0x103, 395 => 'Compression' },
	'compressionfactor' => { 233 => 0x50d },
	'compressionratio' => { 131 => 'Compression', 238 => 0x1034 },
	'confidencelevel' => { 372 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 86 => 0x266, 292 => 0xd6 },
	'constrainedcropwidth' => { 86 => 0x262, 292 => 0xd5 },
	'contact' => { 103 => 0x76 },
	'contentlocationcode' => { 103 => 0x1a },
	'contentlocationname' => { 103 => 0x1b },
	'continuousbracketing' => { 150 => 0x20 },
	'continuousdrive' => { 29 => 0x5 },
	'continuousshootingspeed' => { 68 => 0x610 },
	'continuousshotlimit' => { 68 => 0x611 },
	'contrast' => { 8 => 0x73, 10 => 0x75, 29 => 0xd, 90 => 0xc, 91 => [0x3012,0x20], 95 => [0xa408,0xfe54], 100 => [0x1004,0x1006], 125 => 'Contrast', 147 => 0x20, 148 => 0x31, 149 => 0x27, 150 => 0x19, 155 => 0x2, 184 => 0x33, 238 => 0x1029, 253 => 0x39, 255 => 0x300a, 284 => 0x20, 290 => 0xc, 302 => 0x24, 306 => 0x1012, 315 => 0xd, 323 => 0x1d, 324 => 0x1a, 335 => 0x2004, 376 => 'Contrast', 380 => 'Contrast' },
	'contrast2012' => { 376 => 'Contrast2012' },
	'contrastadj' => { 86 => 0x115, 218 => 0x2c, 362 => 0x8017 },
	'contrastauto' => { 57 => 0x90 },
	'contrastcurve' => { 182 => 0x8c },
	'contrastdetectaf' => { 158 => 0x4 },
	'contrastdetectafarea' => { 284 => 0x231 },
	'contrastdetectafinfocus' => { 158 => 0x1c },
	'contrastfaithful' => { 17 => 0xec, 56 => 0x60, 57 => 0x60 },
	'contrasthighlight' => { 284 => 0x6d },
	'contrasthighlightshadowadj' => { 284 => 0x6f },
	'contrastlandscape' => { 17 => 0xea, 56 => 0x30, 57 => 0x30 },
	'contrastmode' => { 253 => 0x2c },
	'contrastmonochrome' => { 17 => 0xed, 56 => 0x78, 57 => 0x78 },
	'contrastneutral' => { 17 => 0xeb, 56 => 0x48, 57 => 0x48 },
	'contrastportrait' => { 17 => 0xe9, 56 => 0x18, 57 => 0x18 },
	'contrastsetting' => { 233 => 0x505, 241 => 0x1012, 325 => 0x10, 339 => 0x8 },
	'contrastshadow' => { 284 => 0x6e },
	'contraststandard' => { 17 => 0xe8, 56 => 0x0, 57 => 0x0 },
	'contrastuserdef1' => { 17 => 0xee, 56 => 0x90, 57 => 0xa8 },
	'contrastuserdef2' => { 17 => 0xef, 56 => 0xa8, 57 => 0xc0 },
	'contrastuserdef3' => { 17 => 0xf0, 56 => 0xc0, 57 => 0xd8 },
	'contributedmedia' => { 399 => 'contributedMedia' },
	'contributedmediaduration' => { 399 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 399 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 399 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 399 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 399 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 399 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 399 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 399 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 399 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 399 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 377 => 'contributor' },
	'contributors' => { 126 => 'Contributors' },
	'controldialset' => { 150 => 0x46 },
	'controlledvocabularyterm' => { 386 => 'CVterm' },
	'controllerboardversion' => { 249 => 0x332 },
	'controlmode' => { 62 => 0x12 },
	'conversionlens' => { 234 => 0x403, 253 => 0x35 },
	'converter' => { 95 => 0xfe4d, 205 => 0xb, 376 => 'Converter' },
	'converttograyscale' => { 376 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 95 => 0x8298, 126 => 'Copyright', 245 => 'Copyright', 284 => 0x22f, 297 => 'Copyright', 387 => 'Copyright', 390 => 'copyright', 392 => 'copyright', 395 => 'Copyright', 399 => 'copyright' },
	'copyrightflag' => { 295 => 0x40a },
	'copyrightnotice' => { 103 => 0x74 },
	'copyrightowner' => { 389 => 'CopyrightOwner' },
	'copyrightownerid' => { 389 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 389 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 389 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 389 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 389 => 'CopyrightStatus' },
	'coringfilter' => { 237 => 0x310, 238 => 0x102d, 241 => 0x310 },
	'coringvalues' => { 237 => 0x311, 241 => 0x311 },
	'corporateentity' => { 390 => 'corporateEntity' },
	'country' => { 130 => 'Country', 253 => 0x69, 388 => 'Country' },
	'country-primarylocationcode' => { 103 => 0x64 },
	'country-primarylocationname' => { 103 => 0x65 },
	'countrycode' => { 181 => 0x5, 293 => 'CountryCode', 385 => 'CountryCode' },
	'coverage' => { 377 => 'coverage' },
	'coverdate' => { 390 => 'coverDate' },
	'coverdisplaydate' => { 390 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 284 => 0x28 },
	'crc32' => { 378 => 'crc32' },
	'createdate' => { 95 => 0x9004, 126 => 'CreateDate', 242 => 'CreationDate', 245 => 'create-date', 297 => 'CreationDate', 299 => 0x1, 397 => 'CreateDate' },
	'creationdate' => { 387 => 'CreationDate', 390 => 'creationDate' },
	'creationtime' => { 245 => 'Creation Time' },
	'creativestyle' => { 323 => 0x1a, 324 => 0x18, 334 => 0x41, 335 => 0xb020, 358 => 0x4a },
	'creativestylesetting' => { 325 => 0xf, 339 => 0x7 },
	'creativestylewaschanged' => { 362 => 0x8001 },
	'creator' => { 242 => 'Creator', 297 => 'Creator', 377 => 'creator', 387 => 'Creator' },
	'creatoraddress' => { 385 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 385 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 385 => 'CreatorContactInfo' },
	'creatorcountry' => { 385 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 385 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 385 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 397 => 'CreatorTool' },
	'creatorworkemail' => { 385 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 385 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 385 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 103 => 0x6e, 388 => 'Credit' },
	'creditline' => { 392 => 'creditLine' },
	'creditlinereq' => { 402 => 'CreditLineReq' },
	'creditlinerequired' => { 389 => 'CreditLineRequired' },
	'cropactive' => { 86 => 0x244 },
	'cropangle' => { 376 => 'CropAngle' },
	'cropaspectratio' => { 86 => 0x260 },
	'cropbottom' => { 99 => 0x9, 210 => 0x36, 292 => 0xdc, 376 => 'CropBottom' },
	'cropbottommargin' => { 42 => 0x3 },
	'cropcircleactive' => { 87 => 0xd6 },
	'cropcircleradius' => { 87 => 0xd9 },
	'cropcirclex' => { 87 => 0xd7 },
	'cropcircley' => { 87 => 0xd8 },
	'cropconstraintowarp' => { 376 => 'CropConstrainToWarp' },
	'croph' => { 370 => 'CropH' },
	'cropheight' => { 86 => 0x24c, 237 => 0x615, 241 => 0x615, 376 => 'CropHeight' },
	'crophispeed' => { 182 => 0x1b },
	'cropleft' => { 86 => 0x246, 99 => 0x6, 210 => 0x1e, 237 => 0x612, 241 => 0x612, 292 => 0xd9, 376 => 'CropLeft' },
	'cropleftmargin' => { 42 => 0x0 },
	'cropmode35mm' => { 306 => 0x1018 },
	'cropoutputheight' => { 210 => 0xce },
	'cropoutputheightinches' => { 210 => 0x96 },
	'cropoutputpixels' => { 210 => 0xd6 },
	'cropoutputresolution' => { 210 => 0xb6 },
	'cropoutputscale' => { 210 => 0xbe },
	'cropoutputwidth' => { 210 => 0xc6 },
	'cropoutputwidthinches' => { 210 => 0x8e },
	'croppedareaimageheightpixels' => { 366 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 366 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 366 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 366 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 4 => 0x2, 306 => 0x1604 },
	'croppedimageleft' => { 4 => 0x3 },
	'croppedimagetop' => { 4 => 0x4 },
	'croppedimagewidth' => { 4 => 0x1, 306 => 0x1603 },
	'cropright' => { 99 => 0x8, 210 => 0x2e, 292 => 0xdb, 376 => 'CropRight' },
	'croprightmargin' => { 42 => 0x1 },
	'croprotation' => { 99 => 0xb },
	'cropscaledresolution' => { 210 => 0x9e },
	'cropsourceresolution' => { 210 => 0xae },
	'croptop' => { 86 => 0x248, 99 => 0x7, 210 => 0x26, 237 => 0x613, 241 => 0x613, 292 => 0xda, 376 => 'CropTop' },
	'croptopmargin' => { 42 => 0x2 },
	'cropunit' => { 376 => 'CropUnit' },
	'cropunits' => { 376 => 'CropUnits' },
	'cropw' => { 370 => 'CropW' },
	'cropwidth' => { 86 => 0x24a, 237 => 0x614, 241 => 0x614, 376 => 'CropWidth' },
	'cropx' => { 370 => 'CropX' },
	'cropy' => { 370 => 'CropY' },
	'crossprocess' => { 284 => 0x7b },
	'crossprocessparams' => { 284 => 0x235 },
	'currenticcprofile' => { 95 => 0xc691 },
	'currentpreprofilematrix' => { 95 => 0xc692 },
	'currentversion' => { 362 => 0xd000 },
	'curve0x' => { 370 => 'Curve0x' },
	'curve0y' => { 370 => 'Curve0y' },
	'curve1x' => { 370 => 'Curve1x' },
	'curve1y' => { 370 => 'Curve1y' },
	'curve2x' => { 370 => 'Curve2x' },
	'curve2y' => { 370 => 'Curve2y' },
	'curve3x' => { 370 => 'Curve3x' },
	'curve3y' => { 370 => 'Curve3y' },
	'curve4x' => { 370 => 'Curve4x' },
	'curve4y' => { 370 => 'Curve4y' },
	'curves' => { 215 => 0x76a43201 },
	'custom1' => { 389 => 'Custom1' },
	'custom10' => { 389 => 'Custom10' },
	'custom2' => { 389 => 'Custom2' },
	'custom3' => { 389 => 'Custom3' },
	'custom4' => { 389 => 'Custom4' },
	'custom5' => { 389 => 'Custom5' },
	'custom6' => { 389 => 'Custom6' },
	'custom7' => { 389 => 'Custom7' },
	'custom8' => { 389 => 'Custom8' },
	'custom9' => { 389 => 'Custom9' },
	'customcontrast' => { 87 => 0x4e },
	'customcontrols' => { 68 => 0x70c },
	'customdefaultunsharpfineness' => { 87 => 0xbe },
	'customdefaultunsharpstrength' => { 87 => 0xbc },
	'customdefaultunsharpthreshold' => { 87 => 0xc0 },
	'customlinear' => { 87 => 0x4f },
	'customoutputhighlightpoint' => { 87 => 0x53 },
	'customoutputshadowpoint' => { 87 => 0x54 },
	'custompicturestylefilename' => { 51 => 0x4010 },
	'customrawhighlight' => { 87 => 0x7c },
	'customrawhighlightpoint' => { 87 => 0x51 },
	'customrawshadow' => { 87 => 0x85 },
	'customrawshadowpoint' => { 87 => 0x52 },
	'customrendered' => { 95 => 0xa401, 380 => 'CustomRendered' },
	'customsaturation' => { 233 => 0x503 },
	'customsettingsalldefault' => { 222 => '0.2', 227 => '0.2' },
	'customsettingsbank' => { 222 => '0.1', 227 => '0.1' },
	'customsharpness' => { 87 => 0x50 },
	'customunsharpmaskfineness' => { 87 => 0xb8 },
	'customunsharpmaskstrength' => { 87 => 0xb6 },
	'customunsharpmaskthreshold' => { 87 => 0xba },
	'customwb_rblevels' => { 339 => 0x1a },
	'customwb_rgblevels' => { 325 => 0x19 },
	'customwbbluelevel' => { 150 => 0x36 },
	'customwberror' => { 150 => 0x37 },
	'customwbgreenlevel' => { 150 => 0x35 },
	'customwbredlevel' => { 150 => 0x34 },
	'customwbsetting' => { 150 => 0x26 },
	'd-lightinghq' => { 215 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 211 => 0x2 },
	'd-lightinghqhighlight' => { 211 => 0x1 },
	'd-lightinghqselected' => { 215 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 211 => 0x0 },
	'd-lightinghs' => { 215 => 0xce5554aa },
	'd-lightinghsadjustment' => { 212 => 0x0 },
	'd-lightinghscolorboost' => { 212 => 0x1 },
	'd-rangeoptimizerhighlight' => { 362 => 0x8024 },
	'd-rangeoptimizermode' => { 362 => 0x8022 },
	'd-rangeoptimizershadow' => { 362 => 0x802d },
	'd-rangeoptimizervalue' => { 362 => 0x8023 },
	'datacompressionmethod' => { 105 => 0x6e },
	'dataimprint' => { 147 => 0x34 },
	'date' => { 284 => 0x6, 377 => 'date' },
	'dateacquired' => { 145 => 'DateAcquired' },
	'datecreated' => { 103 => 0x37, 388 => 'DateCreated' },
	'datedisplayformat' => { 207 => 0x3 },
	'dateidentified' => { 94 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 224 => '4.2' },
	'daterecieved' => { 390 => 'dateRecieved' },
	'datesent' => { 104 => 0x46 },
	'datestampmode' => { 51 => 0x1c },
	'datetime' => { 371 => 'datetime', 395 => 'DateTime' },
	'datetimedigitized' => { 380 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 84 => 0x0, 95 => 0x9003, 123 => 0x14, 126 => 'OriginalDate', 302 => 0xb, 380 => 'DateTimeOriginal' },
	'datetimestamp' => { 111 => 0x64 },
	'datetimeutc' => { 233 => 0x908 },
	'daylightsavings' => { 63 => 0x3, 207 => 0x2 },
	'dccontinent' => { 94 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 94 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 94 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 94 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 94 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 94 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 94 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 94 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 94 => 'Event' },
	'dcfootprintspatialfit' => { 94 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 94 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 94 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 94 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 94 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 94 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 94 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 94 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 94 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 94 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 94 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 94 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 94 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 94 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 94 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 94 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 94 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 94 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 94 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 94 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 134 => 'Declination' },
	'decposition' => { 147 => 0x32 },
	'defaultblackrender' => { 95 => 0xc7a6 },
	'defaultcroporigin' => { 95 => 0xc61f },
	'defaultcropsize' => { 95 => 0xc620 },
	'defaulteraseoption' => { 68 => 0x813 },
	'defaultscale' => { 95 => 0xc61e },
	'defaultusercrop' => { 95 => 0xc7b5 },
	'defringe' => { 376 => 'Defringe' },
	'defringegreenamount' => { 376 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 376 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 376 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 376 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 376 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 376 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 182 => 0xa6, 188 => 0x6e },
	'deprecatedon' => { 374 => 'deprecatedOn' },
	'derivedfrom' => { 400 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 400 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 400 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 400 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 400 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 400 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 400 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 400 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 400 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 400 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 400 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 400 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 400 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 400 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 400 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 400 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 400 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 400 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 245 => 'Description', 377 => 'description', 397 => 'Description' },
	'destination' => { 104 => 0x5 },
	'destinationcity' => { 284 => 0x24, 289 => 0x3 },
	'destinationcitycode' => { 290 => 0x1001 },
	'destinationdst' => { 284 => 0x26, 289 => '0.3' },
	'developmentdynamicrange' => { 100 => 0x1403 },
	'devicesettingdescription' => { 380 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 380 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 380 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 380 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 68 => 0x706 },
	'digitalcreationdate' => { 103 => 0x3e },
	'digitalcreationtime' => { 103 => 0x3f },
	'digitaldeehighlightadj' => { 187 => 0x202 },
	'digitaldeeshadowadj' => { 187 => 0x200 },
	'digitaldeethreshold' => { 187 => 0x201 },
	'digitalfilter' => { 315 => 0x59 },
	'digitalfilter01' => { 271 => 0x5 },
	'digitalfilter02' => { 271 => 0x16 },
	'digitalfilter03' => { 271 => 0x27 },
	'digitalfilter04' => { 271 => 0x38 },
	'digitalfilter05' => { 271 => 0x49 },
	'digitalfilter06' => { 271 => 0x5a },
	'digitalfilter07' => { 271 => 0x6b },
	'digitalfilter08' => { 271 => 0x7c },
	'digitalfilter09' => { 271 => 0x8d },
	'digitalfilter10' => { 271 => 0x9e },
	'digitalfilter11' => { 271 => 0xaf },
	'digitalfilter12' => { 271 => 0xc0 },
	'digitalfilter13' => { 271 => 0xd1 },
	'digitalfilter14' => { 271 => 0xe2 },
	'digitalfilter15' => { 271 => 0xf3 },
	'digitalfilter16' => { 271 => 0x104 },
	'digitalfilter17' => { 271 => 0x115 },
	'digitalfilter18' => { 271 => 0x126 },
	'digitalfilter19' => { 271 => 0x137 },
	'digitalfilter20' => { 271 => 0x148 },
	'digitalgain' => { 60 => 0xb },
	'digitalgem' => { 174 => 0x0 },
	'digitalice' => { 187 => 0x100 },
	'digitalimageguid' => { 386 => 'DigImageGUID' },
	'digitalroc' => { 186 => 0x0 },
	'digitalsourcefiletype' => { 386 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 386 => 'DigitalSourceType' },
	'digitalzoom' => { 29 => 0xc, 90 => 0xa, 111 => 0x68, 125 => 'DigitalZoom', 147 => 0xc, 182 => 0x86, 205 => 0xa, 238 => 0x204, 284 => 0x1e, 290 => 0xa, 314 => 0x204, 350 => 0x12, 351 => 0x12 },
	'digitalzoomon' => { 314 => 0x21b },
	'digitalzoomratio' => { 95 => 0xa404, 344 => 0x200, 346 => 0x21c, 380 => 'DigitalZoomRatio' },
	'director' => { 399 => 'director' },
	'directorphotography' => { 399 => 'directorPhotography' },
	'directory' => { 96 => 'Directory' },
	'directoryindex' => { 5 => 0x137, 7 => 0x2dc, 9 => 0x17e, 11 => 0x238, 12 => 0x13f, 13 => 0x133, 14 => 0x1df, 15 => 0x1a7, 16 => 0x1f0, 17 => 0xcc, 18 => 0x1c7, 19 => 0x298, 20 => 0x1e7, 21 => 0x1e5, 22 => [0x27c,0x280], 23 => 0x2b6, 24 => 0x2bf, 25 => 0x1f7 },
	'directoryindex2' => { 19 => 0x29c },
	'directorynumber' => { 170 => 0x6 },
	'disclaimer' => { 245 => 'Disclaimer' },
	'discnumber' => { 399 => 'discNumber' },
	'displayallafpoints' => { 68 => 0x514 },
	'displayaperture' => { 29 => 0x23 },
	'displayedunitsx' => { 296 => 0x2 },
	'displayedunitsy' => { 296 => 0x6 },
	'distance1' => { 111 => 0x28 },
	'distance2' => { 111 => 0x2c },
	'distance3' => { 111 => 0x30 },
	'distance4' => { 111 => 0x34 },
	'distortioncontrol' => { 188 => 0x10 },
	'distortioncorrection' => { 87 => 0x67, 233 => 0x50b, 256 => '7.1', 274 => 0x0, 357 => 0x601, 358 => 0x5b },
	'distortioncorrection2' => { 237 => 0x1011 },
	'distortioncorrectionon' => { 87 => 0x63 },
	'distortioncorrectionsetting' => { 335 => 0x2013 },
	'distortionn' => { 256 => 0xc },
	'distortionparam02' => { 256 => 0x2 },
	'distortionparam04' => { 256 => 0x4 },
	'distortionparam08' => { 256 => 0x8 },
	'distortionparam09' => { 256 => 0x9 },
	'distortionparam11' => { 256 => 0xb },
	'distortionscale' => { 256 => 0x5 },
	'distributor' => { 390 => 'distributor' },
	'dloon' => { 87 => 0xdc },
	'dlosetting' => { 87 => 0xdd },
	'dlosettingapplied' => { 87 => 0xe4 },
	'dloshootingdistance' => { 87 => 0xde },
	'dloversion' => { 87 => 0xe5 },
	'dmcomment' => { 399 => 'comment' },
	'dngadobedata' => { 95 => 0xc634 },
	'dngbackwardversion' => { 95 => 0xc613 },
	'dnglensinfo' => { 95 => 0xc630 },
	'dngprivatedata' => { 95 => 0xc634 },
	'dngversion' => { 95 => 0xc612 },
	'document' => { 245 => 'Document' },
	'documentancestorid' => { 388 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 388 => 'DocumentAncestors' },
	'documenthistory' => { 103 => 0xe7 },
	'documentid' => { 400 => 'DocumentID' },
	'documentname' => { 95 => 0x10d },
	'documentnotes' => { 103 => 0xe6 },
	'doi' => { 390 => 'doi' },
	'dotrange' => { 95 => 0x150 },
	'dpp' => { 371 => 'dpp' },
	'drivemode' => { 91 => 0x3103, 147 => 0x6, 150 => 0x1e, 153 => 0xe, 233 => 0x600, 284 => 0x34, 306 => 0x1002, 315 => 0x3, 323 => 0x4, 324 => 0x7e, 325 => 0x34 },
	'drivemode2' => { 150 => 0xa, 265 => 0x7, 334 => 0xe, 339 => 0x1 },
	'drivemodesetting' => { 325 => 0x4 },
	'dspfirmwareversion' => { 284 => 0x27 },
	'duration' => { 54 => 0x6a, 124 => 'Duration', 138 => 'Duration', 399 => 'duration' },
	'durationscale' => { 399 => [\'duration','durationScale'] },
	'durationvalue' => { 399 => [\'duration','durationValue'] },
	'dustremovaldata' => { 51 => 0x97 },
	'dynamicafarea' => { 222 => '1.4', 227 => '1.4' },
	'dynamicrange' => { 100 => 0x1400 },
	'dynamicrangeexpansion' => { 284 => 0x69, 306 => 0x100e },
	'dynamicrangemax' => { 86 => 0x7c },
	'dynamicrangemin' => { 86 => 0x7a },
	'dynamicrangeoptimizer' => { 150 => 0x15, 335 => [0xb025,0xb04f], 342 => 0x1144, 343 => [0x1144,0x324], 344 => [0x1120,0x300], 345 => [0x119c,0x37c], 346 => [0x1178,0x328], 347 => [0x1030,0x50], 348 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 334 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 323 => 0x19, 324 => 0x17, 325 => 0xd, 334 => 0x79, 339 => 0x5 },
	'dynamicrangeoptimizermode' => { 153 => 0x15, 323 => 0x18, 324 => 0x16, 334 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 150 => 0x27, 325 => 0xc, 339 => 0x4 },
	'dynamicrangesetting' => { 100 => 0x1402 },
	'e-dialinprogram' => { 265 => '1.3' },
	'earliestageorloweststage' => { 94 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 94 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 94 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 94 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 94 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 231 => '6.1' },
	'easyexposurecompensation' => { 222 => '6.4', 227 => '4.4', 228 => '5.2' },
	'easymode' => { 29 => 0xb },
	'edgenoisereduction' => { 216 => 0x4, 362 => 0x8028 },
	'edition' => { 390 => 'edition' },
	'editorialupdate' => { 103 => 0x8 },
	'editstatus' => { 103 => 0x7, 293 => 'EditStatus' },
	'editversionname' => { 215 => 0x3d136244 },
	'effectivelv' => { 284 => 0x2d },
	'effectivemaxaperture' => { 178 => 0x12, 179 => 0x13 },
	'eissn' => { 390 => 'eIssn' },
	'elevation' => { 134 => 'Elevation' },
	'email' => { 126 => 'EMail' },
	'embargodate' => { 390 => 'embargoDate', 392 => 'embargoDate' },
	'embeddedxmpdigest' => { 388 => 'EmbeddedXMPDigest' },
	'emissivity' => { 97 => 0x3 },
	'encryptionkey' => { 312 => 0xa020 },
	'endingpage' => { 390 => 'endingPage' },
	'enduser' => { 389 => 'EndUser' },
	'enduserid' => { 389 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 389 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 399 => 'engineer' },
	'enhancedarktones' => { 208 => 0x8 },
	'enhancement' => { 90 => 0x16, 91 => 0x3016 },
	'enhancer' => { 237 => 0x300 },
	'enhancervalues' => { 237 => 0x301 },
	'envelopenumber' => { 104 => 0x28 },
	'envelopepriority' => { 104 => 0x3c },
	'enveloperecordversion' => { 104 => 0x0 },
	'epsonimageheight' => { 238 => 0x20c },
	'epsonimagewidth' => { 238 => 0x20b },
	'epsonsoftware' => { 238 => 0x20d },
	'equipmentinstitution' => { 364 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 364 => 'EquipmentManufacturer' },
	'equipmentversion' => { 234 => 0x0 },
	'ettlii' => { 68 => 0x304, 69 => 0xd, 70 => 0xe, 71 => 0x7, 72 => 0x7, 73 => 0xe },
	'event' => { 365 => 'Event', 369 => 'Event', 386 => 'Event', 390 => 'event' },
	'eventday' => { 94 => [\'Event','EventDay'] },
	'eventearliestdate' => { 94 => [\'Event','EventEarliestDate'] },
	'eventenddayofyear' => { 94 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 94 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 94 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 94 => [\'Event','EventHabitat'] },
	'eventid' => { 94 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 94 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 94 => [\'Event','EventMonth'] },
	'eventnumber' => { 302 => 0x9 },
	'eventremarks' => { 94 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 94 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 94 => [\'Event','EventSamplingProtocol'] },
	'eventstartdayofyear' => { 94 => [\'Event','EventStartDayOfYear'] },
	'eventtime' => { 94 => [\'Event','EventEventTime'] },
	'eventverbatimeventdate' => { 94 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 94 => [\'Event','EventYear'] },
	'evsteps' => { 265 => '1.2', 267 => 0x0 },
	'evstepsize' => { 224 => '5.1', 225 => '6.1', 226 => '6.1', 229 => '0.7' },
	'exclusivityenddate' => { 392 => 'exclusivityEndDate' },
	'excursiontolerance' => { 105 => 0x82 },
	'exif' => { 96 => 'EXIF' },
	'exifbyteorder' => { 96 => 'ExifByteOrder' },
	'exifcamerainfo' => { 103 => 0xe8 },
	'exifimageheight' => { 95 => 0xa003, 380 => 'PixelYDimension' },
	'exifimagewidth' => { 95 => 0xa002, 380 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 96 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 95 => 0x9000, 380 => 'ExifVersion' },
	'exitpupilposition' => { 178 => 0x4, 179 => 0x4 },
	'expirationdate' => { 103 => 0x25, 390 => 'expirationDate', 392 => 'expirationDate' },
	'expirationtime' => { 103 => 0x26 },
	'exposure' => { 95 => 0xfe51, 376 => 'Exposure' },
	'exposure2012' => { 376 => 'Exposure2012' },
	'exposureadj' => { 213 => 0x0 },
	'exposureadj2' => { 213 => 0x12 },
	'exposureadjust' => { 315 => 0xc },
	'exposurebracketingindicatorlast' => { 150 => 0x52 },
	'exposurebracketshotnumber' => { 153 => 0x2d, 334 => 0x2f },
	'exposurebracketstepsize' => { 265 => 0x8 },
	'exposurebracketvalue' => { 182 => 0x19 },
	'exposurecompensation' => { 62 => 0x6, 77 => 0x0, 95 => 0x9204, 111 => 0x24, 125 => 'ExposureComp', 147 => 0xd, 148 => 0x53, 149 => 0x1e, 153 => 0x49c0, 238 => 0x1006, 284 => 0x16, 312 => 0xa013, 315 => [0xc,0x35,0x4d], 342 => 0x114c, 343 => 0x114c, 344 => 0x1128, 346 => 0x1180, 347 => 0x1038, 348 => 0x230, 380 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 339 => 0x2a },
	'exposurecompensationmode' => { 150 => 0x47, 153 => 0x2a },
	'exposurecompensationset' => { 325 => 0x3, 339 => 0x1e },
	'exposurecompensationsetting' => { 150 => 0x1 },
	'exposurecompstepsize' => { 222 => '6.3', 227 => '4.3' },
	'exposurecontrolstep' => { 228 => '6.1' },
	'exposurecontrolstepsize' => { 222 => '6.2', 227 => '4.2', 231 => '7.1' },
	'exposurecount' => { 100 => 0x1032 },
	'exposuredelaymode' => { 222 => '10.1', 224 => '9.1', 225 => '10.1', 226 => '10.1', 227 => '10.4', 228 => '10.1', 229 => '6.4', 231 => '11.2' },
	'exposuredifference' => { 182 => 0xe },
	'exposureindex' => { 95 => 0xa215, 380 => 'ExposureIndex' },
	'exposureindicator' => { 150 => 0x50 },
	'exposurelevelincrements' => { 66 => 0x6, 67 => 0x6, 68 => 0x101, 69 => 0x5, 70 => 0x6, 71 => 0x5, 72 => 0x5, 73 => 0x6, 74 => 0x4, 323 => 0x58, 324 => 0x58 },
	'exposurelockused' => { 366 => 'ExposureLockUsed' },
	'exposuremode' => { 95 => 0xa402, 125 => 'ExposureMode', 147 => 0x1, 148 => 0xa, 149 => 0x0, 150 => 0x0, 153 => 0x34, 233 => 0x200, 251 => 0x40d, 315 => 0x8, 335 => 0xb041, 380 => 'ExposureMode' },
	'exposuremodeinmanual' => { 68 => 0x10b },
	'exposureprogram' => { 95 => 0x8822, 306 => 0x1001, 316 => 0x17e, 323 => 0x3c, 324 => 0x3c, 325 => 0x5, 329 => 0x14, 334 => 0x3f, 339 => 0x2, 342 => 0x1175, 343 => 0x1179, 344 => 0x1155, 345 => 0x11d1, 346 => 0x11ad, 347 => 0x1065, 348 => 0x25d, 358 => 0x48, 380 => 'ExposureProgram' },
	'exposureshift' => { 233 => 0x203 },
	'exposuretime' => { 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x6, 27 => 0x7, 62 => 0x16, 95 => 0x829a, 108 => 0xfd05, 111 => 0x20, 113 => 0xfa24, 115 => 0xf104, 118 => 0x12, 120 => 0x38, 123 => 0x10, 125 => 'ExposureTime', 147 => 0x9, 148 => 0x35, 149 => 0x48, 150 => 0x8, 153 => 0x49b8, 284 => 0x12, 312 => 0xa018, 315 => [0x32,0x4a], 323 => 0x0, 324 => 0x0, 339 => 0x27, 358 => 0x10, 380 => 'ExposureTime' },
	'exposuretime2' => { 315 => [0x33,0x4b] },
	'exposuretuning' => { 182 => 0x1c },
	'exposurevalue' => { 109 => 0x3 },
	'exposurewarning' => { 100 => 0x1302 },
	'exrauto' => { 100 => 0x1033 },
	'exrmode' => { 100 => 0x1034 },
	'extendedwbdetect' => { 233 => 0x902 },
	'extender' => { 234 => 0x301 },
	'extenderfirmwareversion' => { 234 => 0x304 },
	'extendermagnification' => { 127 => 'Magnification' },
	'extendermake' => { 127 => 'Make' },
	'extendermodel' => { 127 => 'Model', 234 => 0x303 },
	'extenderserialnumber' => { 127 => 'SerialNumber', 234 => 0x302 },
	'externalflash' => { 236 => 0x1201 },
	'externalflashae1' => { 238 => 0x101f },
	'externalflashae1_0' => { 238 => 0x101b },
	'externalflashae2' => { 238 => 0x1020 },
	'externalflashae2_0' => { 238 => 0x101c },
	'externalflashbounce' => { 236 => 0x1204, 238 => 0x1026, 272 => 0x1a },
	'externalflashcompensation' => { 173 => 0x1b },
	'externalflashexposurecomp' => { 182 => 0x17, 272 => 0x19 },
	'externalflashfirmware' => { 171 => 0x6, 172 => 0x6, 173 => 0x6 },
	'externalflashflags' => { 171 => 0x8, 172 => 0x8, 173 => 0x8 },
	'externalflashguidenumber' => { 236 => 0x1203, 272 => '24.1' },
	'externalflashgvalue' => { 238 => 0x1025 },
	'externalflashmode' => { 238 => 0x1028, 272 => 0x2 },
	'externalflashzoom' => { 236 => 0x1205, 238 => 0x1027 },
	'externalsensorbrightnessvalue' => { 249 => 0x311, 255 => 0x3408 },
	'extrainfoversion' => { 327 => 0x1a },
	'eyestartaf' => { 150 => 0x40 },
	'face10position' => { 88 => 0x3f4, 89 => 0x1ec, 169 => 0x28, 269 => 0x12 },
	'face10size' => { 270 => 0x12 },
	'face11position' => { 169 => 0x2c, 269 => 0x14 },
	'face11size' => { 270 => 0x14 },
	'face12position' => { 169 => 0x30, 269 => 0x16 },
	'face12size' => { 270 => 0x16 },
	'face13position' => { 269 => 0x18 },
	'face13size' => { 270 => 0x18 },
	'face14position' => { 269 => 0x1a },
	'face14size' => { 270 => 0x1a },
	'face15position' => { 269 => 0x1c },
	'face15size' => { 270 => 0x1c },
	'face16position' => { 269 => 0x1e },
	'face16size' => { 270 => 0x1e },
	'face17position' => { 269 => 0x20 },
	'face17size' => { 270 => 0x20 },
	'face18position' => { 269 => 0x22 },
	'face18size' => { 270 => 0x22 },
	'face19position' => { 269 => 0x24 },
	'face19size' => { 270 => 0x24 },
	'face1position' => { 43 => 0x8, 88 => 0xd, 89 => 0x18, 169 => 0x4, 247 => 0x1, 269 => 0x0, 303 => 0xbc, 330 => 0x1, 331 => 0x0, 332 => 0x0, 333 => 0x5b },
	'face1size' => { 270 => 0x0 },
	'face20position' => { 269 => 0x26 },
	'face20size' => { 270 => 0x26 },
	'face21position' => { 269 => 0x28 },
	'face21size' => { 270 => 0x28 },
	'face22position' => { 269 => 0x2a },
	'face22size' => { 270 => 0x2a },
	'face23position' => { 269 => 0x2c },
	'face23size' => { 270 => 0x2c },
	'face24position' => { 269 => 0x2e },
	'face24size' => { 270 => 0x2e },
	'face25position' => { 269 => 0x30 },
	'face25size' => { 270 => 0x30 },
	'face26position' => { 269 => 0x32 },
	'face26size' => { 270 => 0x32 },
	'face27position' => { 269 => 0x34 },
	'face27size' => { 270 => 0x34 },
	'face28position' => { 269 => 0x36 },
	'face28size' => { 270 => 0x36 },
	'face29position' => { 269 => 0x38 },
	'face29size' => { 270 => 0x38 },
	'face2position' => { 43 => 0xa, 88 => 0x7c, 89 => 0x4c, 169 => 0x8, 247 => 0x5, 269 => 0x2, 303 => 0xc8, 330 => 0x6, 331 => 0x20, 332 => 0x25, 333 => 0x65 },
	'face2size' => { 270 => 0x2 },
	'face30position' => { 269 => 0x3a },
	'face30size' => { 270 => 0x3a },
	'face31position' => { 269 => 0x3c },
	'face31size' => { 270 => 0x3c },
	'face32position' => { 269 => 0x3e },
	'face32size' => { 270 => 0x3e },
	'face3position' => { 43 => 0xc, 88 => 0xeb, 89 => 0x80, 169 => 0xc, 247 => 0x9, 269 => 0x4, 303 => 0xd4, 330 => 0xb, 331 => 0x40, 332 => 0x4a, 333 => 0x6f },
	'face3size' => { 270 => 0x4 },
	'face4position' => { 43 => 0xe, 88 => 0x15a, 89 => 0xb4, 169 => 0x10, 247 => 0xd, 269 => 0x6, 303 => 0xe0, 330 => 0x10, 331 => 0x60, 332 => 0x6f, 333 => 0x79 },
	'face4size' => { 270 => 0x6 },
	'face5position' => { 43 => 0x10, 88 => 0x1c9, 89 => 0xe8, 169 => 0x14, 247 => 0x11, 269 => 0x8, 303 => 0xec, 330 => 0x15, 331 => 0x80, 332 => 0x94 },
	'face5size' => { 270 => 0x8 },
	'face6position' => { 43 => 0x12, 88 => 0x238, 89 => 0x11c, 169 => 0x18, 269 => 0xa, 303 => 0xf8, 330 => 0x1a, 331 => 0xa0, 332 => 0xb9 },
	'face6size' => { 270 => 0xa },
	'face7position' => { 43 => 0x14, 88 => 0x2a7, 89 => 0x150, 169 => 0x1c, 269 => 0xc, 303 => 0x104, 330 => 0x1f, 331 => 0xc0, 332 => 0xde },
	'face7size' => { 270 => 0xc },
	'face8position' => { 43 => 0x16, 88 => 0x316, 89 => 0x184, 169 => 0x20, 269 => 0xe, 303 => 0x110, 330 => 0x24, 331 => 0xe0, 332 => 0x103 },
	'face8size' => { 270 => 0xe },
	'face9position' => { 43 => 0x18, 88 => 0x385, 89 => 0x1b8, 169 => 0x24, 269 => 0x10 },
	'face9size' => { 270 => 0x10 },
	'facedetect' => { 284 => 0x76 },
	'facedetectarea' => { 237 => 0x1201 },
	'facedetectframecrop' => { 237 => 0x1207 },
	'facedetectframesize' => { 43 => 0x3, 88 => 0x1, 89 => 0x4, 169 => 0x1, 237 => 0x1203, 284 => 0x77, 303 => 0xb6 },
	'facedetection' => { 325 => 0x30, 339 => 0x19 },
	'faceid' => { 372 => 'FaceID' },
	'faceinfounknown' => { 91 => 0x2089 },
	'faceorientation' => { 89 => 0x8 },
	'faceposition' => { 268 => 0x2, 313 => 0x4 },
	'facepositions' => { 100 => 0x4103 },
	'facesdetected' => { 43 => 0x2, 44 => 0x2, 45 => 0x3, 88 => 0x0, 89 => 0x2, 91 => 0x211c, 100 => 0x4100, 169 => 0x3, 237 => 0x1200, 253 => 0x3f, 268 => 0x0, 303 => 0xb5, 313 => 0x0, 330 => 0x0, 333 => 0x3, 341 => 0x30 },
	'facesrecognized' => { 248 => 0x0 },
	'facewidth' => { 44 => 0x1 },
	'faithfuloutputhighlightpoint' => { 87 => 0x38 },
	'faithfuloutputshadowpoint' => { 87 => 0x39 },
	'faithfulrawcolortone' => { 87 => 0x31 },
	'faithfulrawcontrast' => { 87 => 0x33 },
	'faithfulrawhighlight' => { 87 => 0x79 },
	'faithfulrawhighlightpoint' => { 87 => 0x36 },
	'faithfulrawlinear' => { 87 => 0x34 },
	'faithfulrawsaturation' => { 87 => 0x32 },
	'faithfulrawshadow' => { 87 => 0x82 },
	'faithfulrawshadowpoint' => { 87 => 0x37 },
	'faithfulrawsharpness' => { 87 => 0x35 },
	'faithfulunsharpmaskfineness' => { 87 => 0xac },
	'faithfulunsharpmaskstrength' => { 87 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 87 => 0xae },
	'femicroadjustment' => { 68 => 0x111 },
	'ffid' => { 378 => 'ffid' },
	'fieldcount' => { 238 => 0x103f },
	'filecreatedate' => { 96 => 'FileCreateDate' },
	'filedatarate' => { 399 => 'fileDataRate' },
	'fileformat' => { 79 => 0x0, 104 => 0x14, 315 => [0x22,0x26], 335 => 0xb000 },
	'fileindex' => { 5 => 0x143, 7 => 0x2d0, 9 => 0x172, 11 => 0x22c, 12 => 0x133, 13 => 0x13f, 14 => 0x1d3, 15 => 0x19b, 16 => 0x1e4, 17 => 0xd0, 18 => 0x1bb, 19 => 0x28c, 20 => 0x1db, 21 => 0x1d9, 22 => [0x270,0x274], 23 => 0x2aa, 24 => 0x2b3, 25 => 0x1eb, 254 => 0x0 },
	'fileindex2' => { 19 => 0x290 },
	'filemodifydate' => { 96 => 'FileModifyDate' },
	'filename' => { 96 => 'FileName' },
	'filenameasdelivered' => { 389 => 'FileNameAsDelivered' },
	'filenumber' => { 46 => 0x1, 51 => 0x8, 81 => 0x1817, 92 => 'FileNumber', 170 => 0x8 },
	'filenumbermemory' => { 147 => 0x1a },
	'filenumbersequence' => { 222 => '12.2', 224 => '3.1', 225 => '4.1', 226 => '4.1', 227 => '11.1', 228 => '4.3', 231 => '5.2' },
	'filesource' => { 95 => 0xa300, 100 => 0x8000, 380 => 'FileSource' },
	'fileversion' => { 104 => 0x16 },
	'fillflashautoreduction' => { 66 => 0xe, 67 => 0xe, 74 => 0xa },
	'filllight' => { 376 => 'FillLight' },
	'fillorder' => { 95 => 0x10a },
	'filmmode' => { 100 => 0x1401, 251 => 0x412, 253 => 0x42 },
	'filmtype' => { 187 => 0x2 },
	'filtereffect' => { 46 => 0xe, 184 => 0x37 },
	'filtereffectauto' => { 57 => 0xa0 },
	'filtereffectfaithful' => { 56 => 0x70, 57 => 0x70 },
	'filtereffectlandscape' => { 56 => 0x40, 57 => 0x40 },
	'filtereffectmonochrome' => { 17 => 0xff, 56 => 0x88, 57 => 0x88 },
	'filtereffectneutral' => { 56 => 0x58, 57 => 0x58 },
	'filtereffectportrait' => { 56 => 0x28, 57 => 0x28 },
	'filtereffectstandard' => { 56 => 0x10, 57 => 0x10 },
	'filtereffectuserdef1' => { 56 => 0xa0, 57 => 0xb8 },
	'filtereffectuserdef2' => { 56 => 0xb8, 57 => 0xd0 },
	'filtereffectuserdef3' => { 56 => 0xd0, 57 => 0xe8 },
	'finderdisplayduringexposure' => { 67 => 0x1 },
	'finesharpness' => { 284 => 0x70 },
	'finetuneoptcenterweighted' => { 222 => '7.2', 231 => '9.1' },
	'finetuneoptmatrixmetering' => { 222 => '8.1', 227 => '6.1', 231 => '8.2' },
	'finetuneoptspotmetering' => { 222 => '8.2', 227 => '6.2', 231 => '9.2' },
	'firmware' => { 238 => 0x405, 315 => [0x17,0x3b,0x57], 373 => 'Firmware' },
	'firmwaredate' => { 90 => 0x15, 91 => 0x2001, 302 => 0x4 },
	'firmwareid' => { 154 => 0x0 },
	'firmwarename' => { 312 => 0xa001 },
	'firmwarerevision' => { 17 => 0xa4, 51 => 0x1e, 304 => 0x0 },
	'firmwarerevision2' => { 304 => 0xc },
	'firmwareversion' => { 5 => 0x10b, 9 => 0x136, 12 => 0xff, 13 => 0x107, 109 => 0xce5, 123 => 0x57, 125 => 'FirmwareVersion', 253 => 0x2, 255 => 0x3109, 284 => 0x230, 306 => 0x2 },
	'firstphotodate' => { 366 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 389 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 103 => 0x16 },
	'flash' => { 92 => 'Flash', 95 => 0x9209, 148 => 0x1f, 149 => 0x15, 380 => 'Flash' },
	'flashaction' => { 325 => [0x87,0x287] },
	'flashaction2' => { 339 => 0x30 },
	'flashactivity' => { 29 => 0x1c },
	'flashbatterylevel' => { 35 => 0x249 },
	'flashbias' => { 253 => 0x24 },
	'flashbits' => { 29 => 0x1d },
	'flashbuttonfunction' => { 68 => 0x70e },
	'flashchargelevel' => { 238 => 0x1010 },
	'flashcolorfilter' => { 173 => 0x10 },
	'flashcommandermode' => { 171 => '9.1', 172 => '9.1', 173 => '9.1' },
	'flashcompensation' => { 171 => 0xa, 172 => 0xa, 173 => 0xa, 373 => 'FlashCompensation' },
	'flashcontrol' => { 325 => 0x21 },
	'flashcontrolbuilt-in' => { 227 => '16.1', 228 => '23.1', 230 => '23.1' },
	'flashcontrolmode' => { 171 => '9.2', 172 => '9.2', 173 => '9.2', 233 => 0x404 },
	'flashcurtain' => { 253 => 0x48 },
	'flashdefault' => { 150 => 0x42 },
	'flashdevice' => { 238 => 0x1005 },
	'flashdistance' => { 91 => 0x2034 },
	'flashenergy' => { 95 => 0xa20b, 380 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 182 => 0x18 },
	'flashexposurecomp' => { 62 => 0xf, 100 => 0x1011, 128 => 'ExposureComp', 147 => 0x23, 152 => 0x104, 153 => 0x49c1, 182 => 0x12, 233 => 0x401, 238 => 0x1023, 284 => 0x4d, 306 => 0x100b, 315 => [0x3a,0x56], 335 => 0x104 },
	'flashexposurecomp2' => { 203 => 0x4d2 },
	'flashexposurecomp3' => { 173 => 0x1d },
	'flashexposurecomp4' => { 173 => 0x27 },
	'flashexposurecompset' => { 150 => 0x10, 258 => 0xe, 325 => 0x23, 339 => 0x1f },
	'flashexposurecompset2' => { 339 => 0x2c },
	'flashexposureindicator' => { 150 => 0x54 },
	'flashexposureindicatorlast' => { 150 => 0x56 },
	'flashexposureindicatornext' => { 150 => 0x55 },
	'flashexposurelock' => { 46 => 0x19 },
	'flashfired' => { 111 => 0x5d, 128 => 'Fired', 147 => 0x14, 202 => '590.3', 253 => 0x8007, 380 => [\'Flash','FlashFired'] },
	'flashfiring' => { 68 => 0x306, 69 => 0x6, 70 => 0x7, 73 => 0x7 },
	'flashfirmwareversion' => { 234 => 0x1002 },
	'flashfocallength' => { 171 => 0xb, 172 => 0xc, 173 => 0xc },
	'flashfunction' => { 153 => 0x31, 380 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 171 => 0xe, 172 => 0xf, 173 => 0xf },
	'flashgroupacompensation' => { 171 => 0x11, 172 => 0x12, 173 => 0x13 },
	'flashgroupacontrolmode' => { 171 => 0xf, 172 => '16.1', 173 => '17.1' },
	'flashgroupaoutput' => { 171 => 0x11, 172 => 0x12, 173 => 0x13 },
	'flashgroupbcompensation' => { 171 => 0x12, 172 => 0x13, 173 => 0x14 },
	'flashgroupbcontrolmode' => { 171 => 0x10, 172 => '17.1', 173 => '18.1' },
	'flashgroupboutput' => { 171 => 0x12, 172 => 0x13, 173 => 0x14 },
	'flashgroupccompensation' => { 172 => 0x14, 173 => 0x15 },
	'flashgroupccontrolmode' => { 172 => '17.2', 173 => '18.2' },
	'flashgroupcoutput' => { 172 => 0x14, 173 => 0x15 },
	'flashguidenumber' => { 62 => 0xd, 78 => 0x0, 128 => 'GuideNumber' },
	'flashintensity' => { 90 => [0x19,0x5], 233 => 0x405 },
	'flashlevel' => { 223 => 0x9, 335 => 0xb048 },
	'flashmake' => { 128 => 'Make' },
	'flashmanufacturer' => { 145 => 'FlashManufacturer' },
	'flashmetering' => { 147 => 0x3f, 150 => 0x1c },
	'flashmeteringmode' => { 5 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 18 => 0x15, 20 => 0x15, 25 => 0x15 },
	'flashmeteringsegments' => { 284 => 0x20a },
	'flashmode' => { 90 => 0x4, 111 => 0x5c, 128 => 'Mode', 147 => 0x2, 148 => 0x20, 149 => 0x16, 150 => 0xf, 182 => 0x87, 233 => 0x400, 238 => 0x1004, 284 => 0xc, 290 => 0x4, 305 => 0x20, 306 => 0x100a, 314 => 0x225, 323 => 0x23, 324 => 0x1f, 325 => 0x20, 339 => 0x10, 380 => [\'Flash','FlashMode'] },
	'flashmodel' => { 128 => 'Model', 145 => 'FlashModel', 234 => 0x1001 },
	'flashoptions' => { 265 => 0x2 },
	'flashoptions2' => { 265 => 0x10 },
	'flashoutput' => { 35 => 0x248, 62 => 0x21, 171 => 0xa, 172 => 0xa, 173 => 0xa },
	'flashpixversion' => { 95 => 0xa000, 380 => 'FlashpixVersion' },
	'flashredeyemode' => { 380 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 233 => 0x403 },
	'flashreturn' => { 380 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 128 => 'SerialNumber', 234 => 0x1003 },
	'flashsetting' => { 182 => 0x8 },
	'flashshutterspeed' => { 222 => '20.2', 227 => '15.2', 228 => '22.2', 229 => '7.2', 230 => '22.2', 231 => '23.1' },
	'flashsource' => { 171 => 0x4, 172 => 0x4, 173 => 0x4 },
	'flashstatus' => { 272 => 0x0, 349 => 0x31 },
	'flashsyncspeed' => { 222 => '20.1', 227 => '15.1', 228 => '22.1', 230 => '22.1' },
	'flashsyncspeedav' => { 66 => 0x3, 68 => 0x10f, 69 => 0x2, 70 => 0x3, 71 => 0x2, 72 => 0x2, 73 => 0x3, 74 => 0x6 },
	'flashthreshold' => { 78 => 0x1 },
	'flashtype' => { 128 => 'Type', 150 => 0x59, 182 => 0x9, 234 => 0x1000 },
	'flashwarning' => { 228 => '30.1', 229 => '7.1', 231 => '31.1', 253 => 0x62 },
	'flexiblespotposition' => { 335 => 0x201d },
	'flickerreduce' => { 314 => 0x218 },
	'fliphorizontal' => { 215 => 0x76a43206 },
	'fnumber' => { 5 => 0x3, 7 => 0x3, 9 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x5, 27 => 0x6, 62 => 0x15, 95 => 0x829d, 108 => 0xfd04, 111 => 0x1e, 113 => 0xfa23, 115 => 0xf103, 118 => 0x13, 120 => 0x3c, 123 => 0xc, 132 => 'FNumber', 147 => 0xa, 148 => 0x36, 149 => 0x47, 150 => 0x9, 153 => 0x49c7, 284 => 0x13, 312 => 0xa019, 315 => [0x31,0x49], 323 => 0x1, 324 => 0x1, 339 => 0x26, 380 => 'FNumber' },
	'focallength' => { 5 => 0x1d, 6 => 0xa, 7 => 0x23, 8 => 0x9, 9 => 0x1d, 10 => 0x9, 11 => 0x1e, 12 => 0x1d, 13 => 0x1d, 14 => 0x1e, 15 => 0x1e, 16 => 0x1e, 17 => 0x28, 18 => 0x1e, 19 => 0x23, 20 => 0x1e, 21 => 0x1e, 22 => 0x23, 23 => 0x23, 24 => 0x23, 25 => 0x1e, 48 => 0x1, 91 => 0x1d, 95 => 0x920a, 118 => 0x1d, 132 => 'FocalLength', 147 => 0x12, 178 => 0xa, 179 => 0xb, 275 => 0x9, 284 => 0x1d, 306 => 0x1500, 322 => 0xe, 346 => 0x1278, 347 => 0x1134, 348 => 0x32c, 380 => 'FocalLength' },
	'focallength2' => { 339 => 0x29 },
	'focallengthin35mmformat' => { 95 => 0xa405, 312 => 0xa01a, 380 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 322 => 0x10 },
	'focalplanediagonal' => { 234 => 0x103, 238 => 0x205 },
	'focalplaneresolutionunit' => { 95 => 0xa210, 380 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 95 => 0xa20e, 380 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 48 => 0x2 },
	'focalplanexunknown' => { 48 => 0x2 },
	'focalplaneyresolution' => { 95 => 0xa20f, 380 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 48 => 0x3 },
	'focalplaneyunknown' => { 48 => 0x3 },
	'focaltype' => { 8 => 0x2d, 48 => 0x0 },
	'focalunits' => { 29 => 0x19 },
	'focus' => { 205 => 0x8 },
	'focusarea' => { 147 => 0x31 },
	'focusareaselection' => { 229 => '15.2' },
	'focuscontinuous' => { 29 => 0x20 },
	'focusdisplayaiservoandmf' => { 68 => 0x515 },
	'focusdistance' => { 132 => 'FocusDistance', 147 => 0x13, 153 => 0x49bb, 178 => 0x9, 179 => 0xa, 236 => 0x305 },
	'focusdistancelower' => { 5 => 0x45, 7 => 0x8e, 9 => 0x45, 11 => 0x56, 12 => 0x45, 13 => 0x45, 14 => 0x52, 15 => 0x52, 16 => 0x56, 18 => 0x52, 19 => 0x8e, 20 => 0x59, 21 => 0x57, 22 => 0x8e, 23 => 0x94, 24 => 0x95, 25 => 0x56, 46 => 0x15, 62 => 0x14 },
	'focusdistanceupper' => { 5 => 0x43, 7 => 0x8c, 9 => 0x43, 11 => 0x54, 12 => 0x43, 13 => 0x43, 14 => 0x50, 15 => 0x50, 16 => 0x54, 18 => 0x50, 19 => 0x8c, 20 => 0x57, 21 => 0x55, 22 => 0x8c, 23 => 0x92, 24 => 0x93, 25 => 0x54, 46 => 0x14, 62 => 0x13 },
	'focusholdbutton' => { 150 => 0x44 },
	'focusinfoversion' => { 236 => 0x0 },
	'focusingscreen' => { 67 => 0x0, 68 => 0x80b, 73 => 0x0 },
	'focuslocked' => { 146 => 0x14 },
	'focusmode' => { 29 => 0x7, 90 => 0x3, 91 => [0x3003,0xd], 100 => 0x1021, 111 => 0x38, 125 => 'FocusMode', 147 => 0x30, 149 => 0xe, 150 => 0xc, 182 => 0x7, 233 => 0x301, 238 => 0x100b, 253 => 0x7, 284 => 0xd, 290 => 0x3, 306 => 0x1006, 316 => [0xb,0x5], 322 => [0x15,0x1d], 323 => 0x4d, 324 => 0x4d, 335 => [0xb042,0xb04e,0x201b], 339 => 0x13, 353 => 0x16 },
	'focusmode2' => { 265 => '3.1', 339 => 0x32 },
	'focusmodesetting' => { 223 => '10.1', 320 => 0x14, 321 => 0x15, 323 => 0x10, 324 => 0xf, 325 => 0x6 },
	'focusmodeswitch' => { 150 => 0x58, 323 => 0x2e },
	'focuspixel' => { 100 => 0x1023 },
	'focuspointwrap' => { 222 => '2.2', 227 => '2.2', 228 => '1.2', 231 => '2.5' },
	'focusposition' => { 178 => 0x8, 179 => 0x8, 284 => 0x10, 334 => 0x9bb },
	'focusposition2' => { 339 => [0x29,0x2b,0x2f], 353 => 0x2d, 356 => 0x20 },
	'focusprocess' => { 233 => 0x302 },
	'focusrange' => { 29 => 0x12, 238 => 0x100a },
	'focussetting' => { 315 => 0x6 },
	'focusstatus' => { 322 => 0x19, 323 => 0x53, 324 => 0x53 },
	'focusstepcount' => { 236 => 0x301, 238 => 0x100e },
	'focusstepinfinity' => { 236 => 0x303, 238 => 0x103b },
	'focusstepnear' => { 236 => 0x304, 238 => 0x103c },
	'focustrackinglockon' => { 222 => ['1.5','4.1'], 227 => '3.1', 228 => '0.4' },
	'focuswarning' => { 100 => 0x1301 },
	'foldername' => { 147 => 0x27 },
	'foldernumber' => { 323 => 0x9a, 325 => [0x402,0x114,0x316] },
	'fontcomposite' => { 404 => [\'Fonts','FontsComposite'] },
	'fontface' => { 404 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 404 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 404 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 404 => [\'Fonts','FontsFontName'] },
	'fonts' => { 404 => 'Fonts' },
	'fonttype' => { 404 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 404 => [\'Fonts','FontsVersionString'] },
	'for' => { 297 => 'For' },
	'format' => { 377 => 'format', 397 => 'Format' },
	'forwardlock' => { 394 => 'forwardlock' },
	'forwardmatrix1' => { 95 => 0xc714 },
	'forwardmatrix2' => { 95 => 0xc715 },
	'framecount' => { 54 => [0x2,0x4] },
	'frameheight' => { 100 => 0x3822 },
	'framenum' => { 292 => 0xd7 },
	'framenumber' => { 100 => 0x8003, 153 => 0x3c, 284 => 0x29 },
	'framerate' => { 54 => [0x1,0x6], 95 => 0xc764, 100 => 0x3820 },
	'framewidth' => { 100 => 0x3821 },
	'freebytes' => { 81 => 0x1 },
	'freememorycardimages' => { 148 => [0x37,0x54], 149 => [0x2d,0x4a], 150 => 0x32 },
	'fujiflashmode' => { 100 => 0x1010 },
	'fullimagesize' => { 335 => 0xb02b },
	'fullpanoheightpixels' => { 366 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 366 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 306 => 0x100d },
	'fullsizeimage' => { 131 => 'data' },
	'fullsizeimagename' => { 131 => '1Name' },
	'fullsizeimagetype' => { 131 => '0Type' },
	'funcbutton' => { 222 => ['14.1','15.1'], 227 => '28.1', 228 => '13.1', 231 => '14.1' },
	'funcbuttonplusdials' => { 222 => ['14.2','15.2'], 227 => '31.1' },
	'functionbutton' => { 226 => '13.1', 229 => '5.2' },
	'gainbase' => { 237 => 0x610 },
	'gaincontrol' => { 95 => 0xa407, 380 => 'GainControl' },
	'gamma' => { 95 => 0xa500, 381 => 'Gamma' },
	'gammacompensatedvalue' => { 105 => 0x91 },
	'geimagesize' => { 100 => 0x1304 },
	'gemake' => { 101 => 0x300 },
	'gemodel' => { 101 => 0x207 },
	'genre' => { 390 => 'genre', 399 => 'genre' },
	'geography' => { 391 => 'geography' },
	'geologicalcontext' => { 94 => 'GeologicalContext' },
	'geologicalcontextbed' => { 94 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 94 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 94 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 94 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 94 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 96 => 'Geosync' },
	'geotag' => { 96 => 'Geotag' },
	'geotiffasciiparams' => { 95 => 0x87b1 },
	'geotiffdirectory' => { 95 => 0x87af },
	'geotiffdoubleparams' => { 95 => 0x87b0 },
	'geotime' => { 96 => 'Geotime' },
	'globalaltitude' => { 295 => 0x419 },
	'globalangle' => { 295 => 0x40d },
	'good' => { 399 => 'good' },
	'googleplusuploadcode' => { 95 => 0x9009 },
	'gpsaltitude' => { 102 => 0x6, 129 => 'Altitude', 380 => 'GPSAltitude' },
	'gpsaltituderef' => { 102 => 0x5, 380 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 102 => 0x1c, 380 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 102 => 0x1d },
	'gpsdatetime' => { 129 => 'DateTime', 380 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 102 => 0x18, 129 => 'Bearing', 380 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 102 => 0x17, 380 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 102 => 0x1a, 129 => 'Distance', 380 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 102 => 0x19, 380 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 102 => 0x14, 380 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 102 => 0x13 },
	'gpsdestlongitude' => { 102 => 0x16, 380 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 102 => 0x15 },
	'gpsdifferential' => { 102 => 0x1e, 129 => 'Differential', 380 => 'GPSDifferential' },
	'gpsdop' => { 102 => 0xb, 380 => 'GPSDOP' },
	'gpshpositioningerror' => { 102 => 0x1f, 380 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 102 => 0x11, 380 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 102 => 0x10, 380 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 102 => 0x2, 129 => 'Latitude', 380 => 'GPSLatitude' },
	'gpslatituderef' => { 102 => 0x1 },
	'gpslongitude' => { 102 => 0x4, 129 => 'Longitude', 380 => 'GPSLongitude' },
	'gpslongituderef' => { 102 => 0x3 },
	'gpsmapdatum' => { 102 => 0x12, 129 => 'Datum', 380 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 102 => 0xa, 129 => 'MeasureMode', 380 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 102 => 0x1b, 380 => 'GPSProcessingMethod' },
	'gpssatellites' => { 102 => 0x8, 129 => 'Satellites', 380 => 'GPSSatellites' },
	'gpsspeed' => { 102 => 0xd, 129 => 'Speed', 380 => 'GPSSpeed' },
	'gpsspeedref' => { 102 => 0xc, 380 => 'GPSSpeedRef' },
	'gpsstatus' => { 102 => 0x9, 380 => 'GPSStatus' },
	'gpstimestamp' => { 102 => 0x7 },
	'gpstrack' => { 102 => 0xf, 129 => 'Heading', 380 => 'GPSTrack' },
	'gpstrackref' => { 102 => 0xe, 380 => 'GPSTrackRef' },
	'gpsversionid' => { 102 => 0x0, 380 => 'GPSVersionID' },
	'gradation' => { 233 => 0x50f },
	'gradientbasedcorractive' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 376 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 376 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 376 => 'GrainAmount' },
	'grainfrequency' => { 376 => 'GrainFrequency' },
	'grainsize' => { 376 => 'GrainSize' },
	'graymixeraqua' => { 376 => 'GrayMixerAqua' },
	'graymixerblue' => { 376 => 'GrayMixerBlue' },
	'graymixergreen' => { 376 => 'GrayMixerGreen' },
	'graymixermagenta' => { 376 => 'GrayMixerMagenta' },
	'graymixerorange' => { 376 => 'GrayMixerOrange' },
	'graymixerpurple' => { 376 => 'GrayMixerPurple' },
	'graymixerred' => { 376 => 'GrayMixerRed' },
	'graymixeryellow' => { 376 => 'GrayMixerYellow' },
	'graypoint' => { 362 => 0x8021 },
	'grayresponseunit' => { 95 => 0x122 },
	'greencurvelimits' => { 86 => 0x1c4 },
	'greencurvepoints' => { 86 => 0x19a },
	'greenhue' => { 376 => 'GreenHue' },
	'greensaturation' => { 376 => 'GreenSaturation' },
	'griddisplay' => { 222 => '13.3', 224 => '2.2', 227 => '10.5', 228 => '3.4', 229 => '6.1', 231 => '4.2' },
	'gripbatteryadload' => { 263 => 0x5 },
	'gripbatteryadnoload' => { 263 => 0x4 },
	'gripbatterystate' => { 263 => '1.2' },
	'halftonehints' => { 95 => 0x141 },
	'hardlink' => { 96 => 'HardLink' },
	'hasalternative' => { 390 => 'hasAlternative' },
	'hascorrection' => { 390 => 'hasCorrection' },
	'hascrop' => { 376 => 'HasCrop' },
	'hasextendedxmp' => { 401 => 'HasExtendedXMP' },
	'haspreviousversion' => { 390 => 'hasPreviousVersion' },
	'hassettings' => { 376 => 'HasSettings' },
	'hastranslation' => { 390 => 'hasTranslation' },
	'hdr' => { 175 => 0x4, 253 => 0x9e, 284 => 0x85, 335 => 0x200a },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 175 => 0x0 },
	'hdrlevel' => { 175 => 0x5, 325 => 0x2e, 339 => 0x17 },
	'hdrlevel2' => { 175 => 0x7 },
	'hdrsetting' => { 325 => 0x2d, 339 => 0x16, 342 => 0x1148, 343 => 0x1148, 344 => 0x1124, 345 => 0x11a0, 346 => 0x117c, 347 => 0x1034, 348 => 0x22c },
	'hdrsmoothing' => { 175 => 0x6 },
	'headline' => { 103 => 0x69, 388 => 'Headline' },
	'hierarchicalkeywords' => { 140 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 140 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 140 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 140 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 140 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 140 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 368 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 94 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 257 => 0x1a },
	'highisomultipliergreen' => { 257 => 0x19 },
	'highisomultiplierred' => { 257 => 0x18 },
	'highisonoisereduction' => { 14 => 0xbc, 15 => 0xbd, 18 => 0xbd, 25 => 0xc9, 68 => 0x202, 100 => 0x100e, 182 => 0xb1, 284 => 0x71, 323 => 0x2c, 324 => 0x26, 325 => 0x26, 335 => 0x2009, 339 => 0x12, 358 => 0x42 },
	'highisonoisereduction2' => { 335 => 0xb050 },
	'highlight' => { 315 => 0xf },
	'highlightcolordistortreduct' => { 362 => 0x8026 },
	'highlightprotection' => { 214 => 0x6 },
	'highlightrecovery' => { 376 => 'HighlightRecovery' },
	'highlights' => { 370 => 'Highlights' },
	'highlights2012' => { 376 => 'Highlights2012' },
	'highlighttone' => { 100 => 0x1041 },
	'highlighttonepriority' => { 11 => 0x7, 14 => 0x7, 15 => 0x7, 16 => 0x7, 18 => 0x7, 20 => 0x7, 25 => 0x7, 68 => 0x203 },
	'highlowkeyadj' => { 284 => 0x6c },
	'highspeedsync' => { 150 => 0x5 },
	'histogramxml' => { 215 => 0x83a1a25 },
	'history' => { 388 => 'History', 400 => 'History' },
	'historyaction' => { 400 => [\'History','HistoryAction'] },
	'historychanged' => { 400 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 400 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 400 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 400 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 400 => [\'History','HistoryWhen'] },
	'hometowncity' => { 91 => 0x3006, 284 => 0x23, 289 => 0x2 },
	'hometowncitycode' => { 290 => 0x1000 },
	'hometowndst' => { 284 => 0x25, 289 => '0.2' },
	'hostcomputer' => { 95 => 0x13c },
	'hue' => { 155 => 0x3b, 284 => 0x67 },
	'hueadj' => { 218 => 0x2f, 362 => 0x8019 },
	'hueadjust' => { 306 => 0x1016 },
	'hueadjustment' => { 148 => 0x4a, 149 => 0x40, 182 => 0x92, 184 => 0x36 },
	'hueadjustmentaqua' => { 376 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 376 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 376 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 376 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 376 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 376 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 376 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 376 => 'HueAdjustmentYellow' },
	'huesetting' => { 241 => 0x1011 },
	'icc_profile' => { 96 => 'ICC_Profile' },
	'iccprofilename' => { 388 => 'ICCProfile' },
	'idccreativestyle' => { 362 => 0x8000 },
	'idcpreviewlength' => { 362 => 0x202 },
	'idcpreviewstart' => { 362 => 0x201 },
	'identification' => { 94 => 'Identification' },
	'identificationid' => { 94 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 94 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 94 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 94 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 94 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 94 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 377 => 'identifier', 397 => 'Identifier' },
	'illumination' => { 229 => '0.5' },
	'imageadjustment' => { 182 => 0x80, 205 => 0x5 },
	'imagealterationconstraints' => { 389 => 'ImageAlterationConstraints' },
	'imagearea' => { 192 => 0x10, 195 => 0x10 },
	'imageareaoffset' => { 284 => 0x38 },
	'imageauthentication' => { 182 => 0x20 },
	'imageboundary' => { 182 => 0x16 },
	'imagecount' => { 182 => 0xa5, 337 => 0x11b, 349 => 0x32 },
	'imagecount2' => { 349 => 0x4c },
	'imagecreator' => { 389 => 'ImageCreator' },
	'imagecreatorid' => { 389 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 389 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 389 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 182 => 0xa2 },
	'imagedescription' => { 95 => 0x10e, 395 => 'ImageDescription' },
	'imageduplicationconstraints' => { 389 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 215 => 0xfe443a45 },
	'imageeditcount' => { 284 => 0x41 },
	'imageediting' => { 284 => 0x32 },
	'imageeffects' => { 306 => 0x1010 },
	'imagefileconstraints' => { 389 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 389 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 389 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 100 => 0x1436 },
	'imageheight' => { 95 => 0x101, 154 => 0xc, 395 => 'ImageLength' },
	'imagehistory' => { 95 => 0x9213 },
	'imageidnumber' => { 249 => 0x340 },
	'imagenumber' => { 95 => 0x9211, 125 => 'ImageNumber', 148 => 0xae, 149 => 0x5e, 323 => 0x9b, 325 => [0x400,'276.1',0x314], 373 => 'ImageNumber' },
	'imagenumber2' => { 149 => 0x62 },
	'imageoptimization' => { 182 => 0xa9 },
	'imageorientation' => { 103 => 0x83 },
	'imageprocessing' => { 182 => 0x1a },
	'imageprocessingversion' => { 237 => 0x0 },
	'imagequality' => { 125 => 'ImageQuality', 194 => '723.2', 195 => '732.2', 202 => '708.1', 253 => 0x1 },
	'imagequality2' => { 233 => 0x603 },
	'imageref' => { 384 => 'ImageRef' },
	'imagereview' => { 223 => '0.4', 229 => '0.4' },
	'imagereviewtime' => { 223 => '2.1', 224 => '19.1', 225 => '20.1', 226 => '20.1', 227 => '9.2', 228 => '20.1', 231 => '21.2' },
	'imagesize' => { 131 => 'ImageSize' },
	'imagesizerestriction' => { 392 => 'imageSizeRestriction' },
	'imagesourcedata' => { 95 => 0x935c },
	'imagestabilization' => { 29 => 0x22, 91 => 0x3020, 100 => 0x1422, 125 => 'ImageStabilization', 148 => 0xbd, 149 => 0x71, 150 => 0x57, 151 => 0x0, 152 => [0x18,0x107,0x113], 153 => 0x49c2, 182 => 0xac, 233 => 0x604, 236 => 0x1600, 253 => 0x1a, 328 => 0x12, 329 => 0x11, 335 => 0xb026 },
	'imagestabilization2' => { 327 => 0xa },
	'imagestabilizationsetting' => { 153 => 0x14, 323 => 0x3d, 324 => 0x3d, 334 => 0x14 },
	'imagestyle' => { 323 => 0x2d, 324 => 0x27 },
	'imagesupplier' => { 389 => 'ImageSupplier' },
	'imagesupplierid' => { 389 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 389 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 389 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 97 => 0x1 },
	'imagetemperaturemin' => { 97 => 0x2 },
	'imagetone' => { 284 => 0x4f },
	'imagetype' => { 103 => 0x82, 389 => 'ImageType' },
	'imageuniqueid' => { 51 => 0x28, 95 => 0xa420, 380 => 'ImageUniqueID' },
	'imagewidth' => { 95 => 0x100, 154 => 0xe, 395 => 'ImageWidth' },
	'incrementaltemperature' => { 376 => 'IncrementalTemperature' },
	'incrementaltint' => { 376 => 'IncrementalTint' },
	'industry' => { 390 => 'industry', 391 => 'industry' },
	'infobuttonwhenshooting' => { 68 => 0x409 },
	'infraredilluminator' => { 302 => 0x28 },
	'ingredients' => { 400 => 'Ingredients' },
	'ingredientsalternatepaths' => { 400 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 400 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 400 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 400 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 400 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 400 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 400 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 400 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 400 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 400 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 400 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 400 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 400 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 400 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 400 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 400 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 400 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 366 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 366 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 366 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 366 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 222 => '4.4' },
	'initialzoomsetting' => { 222 => '9.3', 227 => '27.3' },
	'inkset' => { 95 => 0x14c },
	'instanceid' => { 400 => 'InstanceID' },
	'instantplaybacksetup' => { 150 => 0x3e },
	'instantplaybacktime' => { 150 => 0x3d },
	'instructions' => { 388 => 'Instructions' },
	'instrument' => { 399 => 'instrument' },
	'intellectualgenre' => { 385 => 'IntellectualGenre' },
	'intelligentauto' => { 335 => 0xb052 },
	'intelligentcontrast' => { 41 => 0x4 },
	'intelligentd-range' => { 253 => 0x79 },
	'intelligentexposure' => { 253 => 0x5d },
	'intelligentresolution' => { 253 => 0x70 },
	'interchangecolorspace' => { 105 => 0x40 },
	'internalflash' => { 147 => 0x2b, 222 => '23.1', 223 => '8.1', 224 => '22.1', 226 => '23.1', 229 => '8.1', 231 => '24.1', 236 => 0x1208 },
	'internalflashae1' => { 238 => 0x1021 },
	'internalflashae1_0' => { 238 => 0x101d },
	'internalflashae2' => { 238 => 0x1022 },
	'internalflashae2_0' => { 238 => 0x101e },
	'internalflashmode' => { 272 => 0x1 },
	'internalflashstrength' => { 272 => 0x3 },
	'internalflashtable' => { 238 => 0x1024 },
	'internalndfilter' => { 253 => 0x9d },
	'internalserialnumber' => { 51 => 0x96, 61 => 0x9, 100 => 0x10, 153 => 0x49dc, 232 => 0x18, 234 => 0x102, 253 => 0x25, 264 => 0x4, 306 => 0x5, 349 => 0xf0 },
	'interopindex' => { 95 => 0x1, 381 => 'InteroperabilityIndex' },
	'interopversion' => { 95 => 0x2 },
	'intervallength' => { 147 => 0x10 },
	'intervalmode' => { 147 => 0x26 },
	'intervalnumber' => { 147 => 0x11 },
	'introtime' => { 399 => 'introTime' },
	'introtimescale' => { 399 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 399 => [\'introTime','introTimeValue'] },
	'iptc' => { 96 => 'IPTC' },
	'iptc-naa' => { 95 => 0x83bb, 257 => 0x83bb },
	'iptcbitspersample' => { 105 => 0x56 },
	'iptcdigest' => { 295 => 0x425 },
	'iptcimageheight' => { 105 => 0x1e },
	'iptcimagerotation' => { 105 => 0x66 },
	'iptcimagewidth' => { 105 => 0x14 },
	'iptclastedited' => { 386 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 105 => 0xa },
	'iptcpixelheight' => { 105 => 0x32 },
	'iptcpixelwidth' => { 105 => 0x28 },
	'isbn' => { 390 => 'isbn' },
	'iscorrectionof' => { 390 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 87 => 0x3 },
	'iso' => { 5 => 0x6, 7 => 0x6, 8 => 0x75, 9 => 0x6, 10 => 0x79, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x0, 27 => 0x1, 90 => 0x14, 91 => [0x3014,0x14], 95 => 0x8827, 108 => 0xfd06, 109 => 0x1784, 111 => 0x60, 113 => [0xfa2e,0xfa46], 114 => [0x27,0x28], 115 => 0xf105, 118 => 0x14, 120 => 0x4e, 123 => 0x34, 125 => 'ISO', 147 => 0x8, 153 => 0x49ba, 176 => 0x0, 182 => 0x2, 257 => 0x17, 284 => [0x8b,0x14], 290 => 0x14, 312 => 0xa014, 334 => 0x6f, 339 => [0x1f,0x21,0x25], 380 => 'ISOSpeedRatings' },
	'iso2' => { 176 => 0x6, 189 => 0x265, 190 => 0x25c, 191 => 0x265, 192 => 0x221, 193 => 0x25d, 194 => 0x256, 195 => 0x25d, 197 => 0x2b5, 200 => 0x265, 204 => 0x2b5 },
	'isoauto' => { 265 => '14.4' },
	'isoautoparameters' => { 284 => 0x7a },
	'isodisplay' => { 224 => '2.3', 225 => '3.3', 226 => '3.3', 228 => '3.3', 231 => '4.3' },
	'isoexpansion' => { 68 => 0x103, 69 => 0x7, 70 => 0x8, 73 => 0x8, 176 => 0x4 },
	'isoexpansion2' => { 176 => 0xa },
	'isofloor' => { 265 => 0x6 },
	'isoselection' => { 182 => 0xf },
	'isosensitivitystep' => { 228 => '6.2' },
	'isosetting' => { 111 => 0x5e, 125 => 'ISOSetting', 147 => 0x24, 148 => 0x26, 149 => 0x1c, 150 => 0x13, 155 => 0x6, 182 => 0x13, 265 => '17.3', 305 => 0x27, 323 => 0x16, 324 => 0x14, 325 => 0x2, 334 => 0x6d },
	'isospeed' => { 95 => 0x8833, 381 => 'ISOSpeed' },
	'isospeedexpansion' => { 67 => 0x3 },
	'isospeedincrements' => { 68 => 0x102 },
	'isospeedlatitudeyyy' => { 95 => 0x8834, 381 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 95 => 0x8835, 381 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 68 => 0x103 },
	'isostepsize' => { 222 => '6.1', 227 => '4.1' },
	'isovalue' => { 238 => 0x1001 },
	'issn' => { 390 => 'issn' },
	'issueidentifier' => { 390 => 'issueIdentifier' },
	'issuename' => { 390 => 'issueName' },
	'istranslationof' => { 390 => 'isTranslationOf' },
	'jobid' => { 103 => 0xb8 },
	'jobname' => { 382 => 'JobName' },
	'jobref' => { 398 => 'JobRef' },
	'jobrefid' => { 398 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 398 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 398 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 382 => 'JobStatus' },
	'jpegquality' => { 8 => 0x66, 255 => 0x3034, 335 => 0xb047 },
	'jpegsize' => { 255 => 0x303a },
	'jpgfromraw' => { 81 => 0x2007, 92 => 'JpgFromRaw', 257 => 0x2e },
	'jpgfromrawlength' => { 95 => [0x117,0x202] },
	'jpgfromrawstart' => { 95 => [0x111,0x201] },
	'jpgrecordedpixels' => { 265 => '14.1' },
	'jurisdiction' => { 374 => 'jurisdiction' },
	'kelvinwb_01' => { 273 => 0x5 },
	'kelvinwb_02' => { 273 => 0x9 },
	'kelvinwb_03' => { 273 => 0xd },
	'kelvinwb_04' => { 273 => 0x11 },
	'kelvinwb_05' => { 273 => 0x15 },
	'kelvinwb_06' => { 273 => 0x19 },
	'kelvinwb_07' => { 273 => 0x1d },
	'kelvinwb_08' => { 273 => 0x21 },
	'kelvinwb_09' => { 273 => 0x25 },
	'kelvinwb_10' => { 273 => 0x29 },
	'kelvinwb_11' => { 273 => 0x2d },
	'kelvinwb_12' => { 273 => 0x31 },
	'kelvinwb_13' => { 273 => 0x35 },
	'kelvinwb_14' => { 273 => 0x39 },
	'kelvinwb_15' => { 273 => 0x3d },
	'kelvinwb_16' => { 273 => 0x41 },
	'kelvinwb_daylight' => { 273 => 0x1 },
	'key' => { 399 => 'key' },
	'keyword' => { 390 => 'keyword' },
	'keywordinfo' => { 140 => 'Keywords' },
	'keywords' => { 103 => 0x19, 126 => 'Keywords', 242 => 'Keywords', 297 => 'Keywords', 371 => 'keywords', 387 => 'Keywords', 397 => 'Keywords' },
	'killdate' => { 390 => 'killDate' },
	'kodakimageheight' => { 108 => 0xf908, 111 => 0xe, 113 => [0xfa1e,0xfa52], 119 => 0x70 },
	'kodakimagewidth' => { 108 => 0xf907, 111 => 0xc, 113 => [0xfa1d,0xfa51], 119 => 0x6c },
	'kodakinfotype' => { 108 => 0xfa00 },
	'kodakmaker' => { 119 => 0x8 },
	'kodakmodel' => { 111 => 0x0, 119 => 0x28 },
	'label' => { 245 => 'Label', 397 => 'Label' },
	'labelname1' => { 384 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 384 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 253 => 0x6f },
	'landscapeoutputhighlightpoint' => { 87 => 0x26 },
	'landscapeoutputshadowpoint' => { 87 => 0x27 },
	'landscaperawcolortone' => { 87 => 0x1f },
	'landscaperawcontrast' => { 87 => 0x21 },
	'landscaperawhighlight' => { 87 => 0x77 },
	'landscaperawhighlightpoint' => { 87 => 0x24 },
	'landscaperawlinear' => { 87 => 0x22 },
	'landscaperawsaturation' => { 87 => 0x20 },
	'landscaperawshadow' => { 87 => 0x80 },
	'landscaperawshadowpoint' => { 87 => 0x25 },
	'landscaperawsharpness' => { 87 => 0x23 },
	'landscapeunsharpmaskfineness' => { 87 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 87 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 87 => 0xa2 },
	'language' => { 377 => 'language' },
	'languageidentifier' => { 103 => 0x87 },
	'largestvalidinteriorrectheight' => { 366 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 366 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 366 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 366 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 147 => 0x1b },
	'lastkeywordiptc' => { 145 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 145 => 'LastKeywordXMP' },
	'lastphotodate' => { 366 => 'LastPhotoDate' },
	'lasturl' => { 400 => 'LastURL' },
	'lateralchromaticaberration' => { 335 => 0x2012 },
	'latestageorhigheststage' => { 94 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 94 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 94 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 94 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 94 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 275 => 0x2 },
	'lc10' => { 275 => 0xb },
	'lc11' => { 275 => 0xc },
	'lc12' => { 275 => 0xd },
	'lc14' => { 275 => 0xf },
	'lc15' => { 275 => 0x10 },
	'lc2' => { 275 => 0x3 },
	'lc3' => { 275 => 0x4 },
	'lc4' => { 275 => 0x5 },
	'lc5' => { 275 => 0x6 },
	'lc6' => { 275 => 0x7 },
	'lc7' => { 275 => 0x8 },
	'lcddisplayatpoweron' => { 68 => 0x811, 72 => 0xa },
	'lcddisplayreturntoshoot' => { 73 => 0x12 },
	'lcdillumination' => { 222 => '17.5', 227 => '10.3', 228 => '4.2', 231 => '5.4' },
	'lcdilluminationduringbulb' => { 68 => 0x408 },
	'lcdpanels' => { 67 => 0x8 },
	'lcheditor' => { 215 => 0x8ae85e },
	'legacyiptcdigest' => { 388 => 'LegacyIPTCDigest' },
	'legalcode' => { 374 => 'legalcode' },
	'lens' => { 95 => 0xfdea, 182 => 0x84, 373 => 'Lens' },
	'lensafstopbutton' => { 66 => 0x11, 67 => 0x13, 68 => 0x506, 69 => 0x10, 70 => 0x12, 73 => 0x13, 74 => 0x9 },
	'lensaperturerange' => { 315 => [0x30,0x48] },
	'lensdistortionparams' => { 238 => 0x206 },
	'lensdrivenoaf' => { 68 => 0x505 },
	'lensfirmware' => { 307 => 0x20, 312 => 0xa004 },
	'lensfirmwareversion' => { 234 => 0x204, 253 => 0x60 },
	'lensfocalrange' => { 315 => [0xa,0x2a] },
	'lensformat' => { 346 => 0x1891, 348 => 0x18bd, 349 => 0x106, 357 => 0x603, 358 => 0x5d },
	'lensfstops' => { 177 => 0x7, 178 => 0xc, 179 => 0xd, 182 => 0x8b, 275 => '0.3' },
	'lensid' => { 373 => 'LensID' },
	'lensidnumber' => { 177 => 0x6, 178 => 0xb, 179 => 0xc },
	'lensinfo' => { 95 => 0xa432, 281 => 0x2a, 373 => 'LensInfo', 381 => 'LensSpecification' },
	'lenskind' => { 275 => 0x1 },
	'lensmake' => { 95 => 0xa433, 132 => 'Make', 381 => 'LensMake' },
	'lensmanualdistortionamount' => { 376 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 145 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 315 => 0x2b },
	'lensmodel' => { 5 => 0x937, 12 => 0x92b, 13 => 0x933, 51 => 0x95, 95 => 0xa434, 132 => 'Model', 145 => 'LensModel', 180 => 0x18a, 234 => 0x203, 251 => 0x303, 281 => 0xc, 381 => 'LensModel' },
	'lensmount' => { 325 => 0x99, 346 => 0x1892, 348 => 0x18be, 349 => 0x105, 357 => 0x604, 358 => 0x5e, 361 => 0x8 },
	'lensparameters' => { 343 => 0x1a23, 346 => 0x1870, 348 => 0x189c, 357 => 0x6ca, 358 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 376 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 376 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 376 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 376 => 'LensProfileEnable' },
	'lensprofilefilename' => { 376 => 'LensProfileFilename' },
	'lensprofilename' => { 376 => 'LensProfileName' },
	'lensprofilesetup' => { 376 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 376 => 'LensProfileVignettingScale' },
	'lensproperties' => { 234 => 0x20b },
	'lensserialnumber' => { 49 => 0x0, 95 => 0xa435, 132 => 'SerialNumber', 234 => 0x202, 253 => 0x52, 307 => 0x30, 373 => 'LensSerialNumber', 381 => 'LensSerialNumber' },
	'lensshutterlock' => { 150 => 0x4a },
	'lensspec' => { 320 => 0x0, 321 => 0x0, 322 => 0x0, 335 => 0xb02a },
	'lenstemperature' => { 238 => 0x1008 },
	'lenstype' => { 5 => 0xe2, 6 => 0xd, 7 => 0x1a7, 8 => 0xc, 9 => 0x111, 10 => 0xc, 11 => 0x14f, 12 => 0xd6, 13 => 0xde, 14 => 0xf6, 15 => 0xea, 16 => 0xff, 17 => [0xc,0x97], 18 => 0xe6, 19 => 0x153, 20 => 0xea, 21 => 0xe8, 22 => 0x127, 23 => 0x161, 24 => 0x166, 25 => 0x112, 29 => 0x16, 152 => 0x10c, 153 => 0x49bd, 182 => 0x83, 234 => 0x201, 246 => 0x16, 249 => 0x310, 252 => 0x303, 253 => 0x51, 255 => 0x3405, 276 => 0x0, 277 => 0x0, 278 => 0x1, 279 => 0x1, 280 => 0x1, 282 => 0x0, 312 => 0xa003, 315 => 0x27, 335 => 0xb027, 346 => 0x1896, 348 => 0x18c2, 349 => 0x109, 357 => 0x608, 358 => 0x62 },
	'lenstype2' => { 325 => 0x3f7, 346 => 0x1893, 348 => 0x18bf, 349 => 0x107, 357 => 0x605, 358 => 0x60, 361 => 0x9 },
	'lenszoomposition' => { 355 => 0x19, 356 => 0x1e, 358 => 0x342 },
	'levelgaugepitch' => { 233 => 0x904 },
	'levelgaugeroll' => { 233 => 0x903 },
	'levelindicator' => { 258 => 0x15 },
	'levelorientation' => { 283 => 0x0 },
	'license' => { 374 => 'license' },
	'licensee' => { 389 => 'Licensee' },
	'licenseeid' => { 389 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 389 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 389 => 'LicenseeImageNotes' },
	'licenseename' => { 389 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 389 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 389 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 389 => 'LicenseeTransactionID' },
	'licenseid' => { 389 => 'LicenseID' },
	'licensestartdate' => { 389 => 'LicenseStartDate' },
	'licensetransactiondate' => { 389 => 'LicenseTransactionDate' },
	'licensetype' => { 378 => 'licensetype' },
	'licensor' => { 389 => 'Licensor' },
	'licensorcity' => { 389 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 389 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 389 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 389 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 389 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 389 => 'LicensorImageID' },
	'licensorname' => { 389 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 389 => 'LicensorNotes' },
	'licensorpostalcode' => { 389 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 389 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 389 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 389 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 389 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 389 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 389 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 389 => 'LicensorTransactionID' },
	'licensorurl' => { 389 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 238 => 0x1009 },
	'lightingmode' => { 91 => 0x302a },
	'lightreading' => { 284 => 0x15 },
	'lightsource' => { 95 => 0x9208, 182 => 0x90, 241 => 0x1000, 380 => 'LightSource' },
	'lightsourcespecial' => { 314 => 0x21d },
	'lightswitch' => { 231 => '0.1' },
	'lightvaluecenter' => { 238 => 0x103d },
	'lightvalueperiphery' => { 238 => 0x103e },
	'linearitylimitblue' => { 257 => 0x10 },
	'linearitylimitgreen' => { 257 => 0xf },
	'linearitylimitred' => { 257 => 0xe },
	'linearityuppermargin' => { 36 => [0x2ba,0x2d1,0x2d5], 38 => 0x1e5, 39 => [0x1fe,0x2de] },
	'linearizationtable' => { 95 => 0xc618 },
	'linearresponselimit' => { 95 => 0xc62e },
	'linkaetoafpoint' => { 265 => '14.2' },
	'lithostratigraphicterms' => { 94 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 224 => '32.1', 231 => '34.1' },
	'liveviewafareamode' => { 228 => '34.1' },
	'liveviewafmethod' => { 339 => 0x20 },
	'liveviewafmode' => { 228 => '34.2' },
	'liveviewafsetting' => { 325 => 0x36 },
	'liveviewexposuresimulation' => { 68 => 0x810 },
	'liveviewfocusmode' => { 325 => [0x8b,0x28b] },
	'liveviewmetering' => { 325 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 225 => '20.2', 226 => '20.2', 228 => '20.2' },
	'liveviewshooting' => { 46 => 0x13 },
	'localcaption' => { 103 => 0x79 },
	'localizedcameramodel' => { 95 => 0xc615 },
	'locallocationname' => { 312 => 0x30 },
	'location' => { 181 => 0x9, 253 => 0x67, 369 => 'Location', 385 => 'Location', 390 => 'location' },
	'locationareacode' => { 375 => 'lac' },
	'locationcreated' => { 386 => 'LocationCreated' },
	'locationcreatedcity' => { 386 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 386 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 386 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 386 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 386 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 386 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 181 => 0x0 },
	'locationname' => { 312 => 0x31 },
	'locationshown' => { 386 => 'LocationShown' },
	'locationshowncity' => { 386 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 386 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 386 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 386 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 386 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 386 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 68 => 0x709 },
	'logcomment' => { 399 => 'logComment' },
	'longexposurenoisereduction' => { 68 => 0x201, 69 => 0x1, 70 => 0x2, 71 => 0x1, 72 => 0x1, 73 => 0x2, 74 => 0x1, 253 => 0x49, 323 => 0x2b, 324 => 0x25, 325 => 0x25, 335 => 0x2008, 339 => 0x11, 358 => 0x44 },
	'longexposurenoisereduction2' => { 46 => 0x8 },
	'loop' => { 399 => 'loop' },
	'lowestbiostratigraphiczone' => { 94 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 376 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 376 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 376 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 376 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 376 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 376 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 376 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 376 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 86 => 0x150 },
	'luminancecurvepoints' => { 86 => 0x126 },
	'luminancenoisereduction' => { 87 => 0x5f, 315 => 0x1b },
	'luminancenoisereductioncontrast' => { 376 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 376 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 87 => 0x6d },
	'luminancesmoothing' => { 376 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 68 => 0x40b },
	'lyrics' => { 399 => 'lyrics' },
	'm16cversion' => { 249 => 0x333 },
	'macro' => { 100 => 0x1020, 101 => 0x202, 238 => 0x202, 305 => 0x21, 314 => 0x202, 335 => 0xb040 },
	'macroled' => { 236 => 0x120a },
	'macromagnification' => { 5 => 0x1b, 9 => 0x1b, 12 => 0x1b, 13 => 0x1b, 17 => 0x1b, 18 => 0x1b, 46 => 0x10 },
	'macromode' => { 29 => 0x1, 147 => 0xb, 233 => 0x300, 253 => 0x1c, 306 => 0x1009 },
	'magicfilter' => { 233 => 0x52c },
	'magnifiedview' => { 70 => 0x11, 72 => 0x9 },
	'maindialexposurecomp' => { 229 => '0.6' },
	'make' => { 82 => 0x0, 95 => 0x10f, 125 => 'Make', 245 => 'Make', 257 => 0x10f, 395 => 'Make' },
	'makernote' => { 380 => 'MakerNote' },
	'makernoteapple' => { 93 => 'MakN', 95 => 0x927c },
	'makernotecanon' => { 93 => 'MakN', 95 => 0x927c },
	'makernotecasio' => { 93 => 'MakN', 95 => 0x927c },
	'makernotecasio2' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteflir' => { 93 => 'MakN', 95 => 0x927c },
	'makernotefujifilm' => { 93 => 'MakN', 95 => 0x927c },
	'makernotege' => { 93 => 'MakN', 95 => 0x927c },
	'makernotege2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehasselblad' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehp' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehp2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehp4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotehp6' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteisl' => { 93 => 'MakN', 95 => 0x927c },
	'makernotejvc' => { 93 => 'MakN', 95 => 0x927c },
	'makernotejvctext' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak10' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak11' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak1a' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak1b' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak5' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak6a' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak6b' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak7' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak8a' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak8b' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak8c' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodak9' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekodakunknown' => { 93 => 'MakN', 95 => 0x927c },
	'makernotekyocera' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica2' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica3' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica4' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica5' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteleica6' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteminolta' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteminolta2' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteminolta3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotenikon' => { 93 => 'MakN', 95 => 0x927c },
	'makernotenikon2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotenikon3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotenintendo' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteoffset' => { 314 => 0xff },
	'makernoteolympus' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteolympus2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepanasonic' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepanasonic2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax5' => { 93 => 'MakN', 95 => 0x927c },
	'makernotepentax6' => { 93 => 'MakN', 95 => 0x927c },
	'makernotephaseone' => { 93 => 'MakN', 95 => 0x927c },
	'makernotereconyx' => { 93 => 'MakN', 95 => 0x927c },
	'makernotericoh' => { 93 => 'MakN', 95 => 0x927c },
	'makernotericoh2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotericohtext' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesafety' => { 95 => 0xc635 },
	'makernotesamsung1a' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesamsung1b' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesamsung2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesanyo' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesanyoc4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesanyopatch' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesigma' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony2' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony3' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony4' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesony5' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesonyericsson' => { 93 => 'MakN', 95 => 0x927c },
	'makernotesonysrf' => { 93 => 'MakN', 95 => 0x927c },
	'makernotetype' => { 306 => 0x1 },
	'makernoteunknown' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteunknownbinary' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteunknowntext' => { 93 => 'MakN', 95 => 0x927c },
	'makernoteversion' => { 152 => 0x0, 182 => 0x1, 238 => 0x0, 253 => 0x8000, 310 => 0x0, 312 => 0x1, 315 => [0x1d,0x1f], 326 => 0x2000 },
	'managedfrom' => { 400 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 400 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 400 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 400 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 400 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 400 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 400 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 400 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 400 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 400 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 400 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 400 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 400 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 400 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 400 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 400 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 400 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 400 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 400 => 'Manager' },
	'managervariant' => { 400 => 'ManagerVariant' },
	'manageto' => { 400 => 'ManageTo' },
	'manageui' => { 400 => 'ManageUI' },
	'manifest' => { 400 => 'Manifest' },
	'manifestlinkform' => { 400 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 400 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 400 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 400 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 400 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 400 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 400 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 400 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 400 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 400 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 400 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 400 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 400 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 400 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 400 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 400 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 400 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 400 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 400 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 400 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 400 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 400 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 233 => 0x900, 253 => 0x86 },
	'manometerreading' => { 233 => 0x901 },
	'manualafpointselectpattern' => { 68 => 0x513 },
	'manualflash' => { 236 => 0x1209 },
	'manualflashoutput' => { 29 => 0x29, 223 => '8.2', 224 => '22.2', 225 => '23.1', 226 => '23.2', 227 => '16.2', 228 => '23.2', 229 => '8.2', 230 => '23.2', 231 => '24.2', 306 => 0x100c },
	'manualflashstrength' => { 233 => 0x406 },
	'manualfocusdistance' => { 182 => 0x85, 238 => 0x100c, 314 => 0x223 },
	'manualtv' => { 67 => 0x5, 68 => 0x705 },
	'manufacturedate' => { 264 => 0x1 },
	'manufacturedate1' => { 308 => 0x4 },
	'manufacturedate2' => { 308 => 0x5 },
	'marked' => { 387 => 'Marked', 403 => 'Marked' },
	'markers' => { 399 => 'markers' },
	'markerscomment' => { 399 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 399 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 399 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 399 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 399 => [\'markers','markersCuePointType'] },
	'markersduration' => { 399 => [\'markers','markersDuration'] },
	'markerslocation' => { 399 => [\'markers','markersLocation'] },
	'markersname' => { 399 => [\'markers','markersName'] },
	'markersprobability' => { 399 => [\'markers','markersProbability'] },
	'markersspeaker' => { 399 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 399 => [\'markers','markersStartTime'] },
	'markerstarget' => { 399 => [\'markers','markersTarget'] },
	'markerstype' => { 399 => [\'markers','markersType'] },
	'maskedareas' => { 95 => 0xc68e },
	'masterdocumentid' => { 103 => 0xb9 },
	'mastergain' => { 187 => 0x50 },
	'maxaperture' => { 29 => 0x1a, 115 => 0x6103, 132 => 'MaxAperture', 147 => 0x17, 153 => 0x49c5, 234 => 0x20a, 275 => '14.1', 349 => 0x0 },
	'maxapertureatmaxfocal' => { 100 => 0x1407, 132 => 'MaxApertureAtMaxFocal', 177 => 0xb, 178 => 0x10, 179 => 0x11, 234 => 0x206 },
	'maxapertureatminfocal' => { 100 => 0x1406, 177 => 0xa, 178 => 0xf, 179 => 0x10, 234 => 0x205 },
	'maxaperturevalue' => { 95 => 0x9205, 380 => 'MaxApertureValue' },
	'maxavailheight' => { 386 => 'MaxAvailHeight' },
	'maxavailwidth' => { 386 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 222 => 0xb, 227 => 0xc, 228 => 0xb },
	'maxfaces' => { 237 => 0x1202 },
	'maxfocallength' => { 5 => 0xe6, 6 => 0x10, 7 => 0x1ab, 8 => 0x13, 9 => 0x115, 10 => 0x13, 11 => 0x153, 12 => 0xda, 14 => 0xfa, 15 => 0xee, 16 => 0x103, 17 => 0x95, 18 => 0xea, 19 => 0x157, 20 => 0xee, 21 => 0xec, 22 => 0x12b, 23 => 0x165, 24 => 0x16a, 25 => 0x116, 29 => 0x17, 100 => 0x1405, 132 => 'MaxFocalLength', 177 => 0x9, 178 => 0xe, 179 => 0xf, 234 => 0x208, 346 => 0x127c, 347 => 0x1138, 348 => 0x330 },
	'maximumdensityrange' => { 105 => 0x8c },
	'maxpagesize' => { 404 => 'MaxPageSize' },
	'maxpagesizeh' => { 404 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 404 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 404 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 95 => 0x119 },
	'maxstorage' => { 394 => 'maxstorage' },
	'mb-d10batteries' => { 222 => '12.6' },
	'mb-d10batterytype' => { 227 => '13.3' },
	'mb-d11batterytype' => { 228 => '2.3' },
	'mb-d80batteries' => { 229 => '6.5' },
	'mb-d80batterytype' => { 231 => '3.2' },
	'mcuversion' => { 177 => 0xc, 178 => 0x11, 179 => 0x12 },
	'md5digest' => { 133 => 'zmd5' },
	'measuredev' => { 25 => 0x9, 62 => 0x3, 81 => 0x1814, 125 => 'MeasuredEV' },
	'measuredev2' => { 11 => 0x8, 25 => 0x8, 62 => 0x17 },
	'measuredev3' => { 11 => 0x9 },
	'measuredlv' => { 153 => 0x690, 249 => 0x312, 255 => 0x3407 },
	'measuredrggb' => { 52 => 0x1 },
	'measuredrggbdata' => { 35 => 0x287 },
	'measurementaccuracy' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 94 => 'MeasurementOrFact' },
	'measurementremarks' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 94 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 389 => 'MediaConstraints' },
	'mediacreatedate' => { 298 => 0x1 },
	'mediamodifydate' => { 298 => 0x2 },
	'mediasummarycode' => { 389 => 'MediaSummaryCode' },
	'memoaudioquality' => { 68 => 0x812 },
	'memorycardconfiguration' => { 329 => 0x16 },
	'menubuttondisplayposition' => { 66 => 0xb, 69 => 0xa, 70 => 0xb, 73 => 0xb },
	'menubuttonreturn' => { 74 => 0xb },
	'menumonitorofftime' => { 227 => '8.2', 228 => '21.1', 231 => '22.1' },
	'metadatadate' => { 397 => 'MetadataDate' },
	'metadatamoddate' => { 399 => 'metadataModDate' },
	'metaversion' => { 341 => 0x34 },
	'meterinfo1row1' => { 336 => 0x0 },
	'meterinfo1row2' => { 336 => 0x6c },
	'meterinfo1row3' => { 336 => 0xd8 },
	'meterinfo1row4' => { 336 => 0x144 },
	'meterinfo1row5' => { 336 => 0x1b0 },
	'meterinfo1row6' => { 336 => 0x21c },
	'meterinfo1row7' => { 336 => 0x288 },
	'meterinfo2row1' => { 336 => 0x2f4 },
	'meterinfo2row2' => { 336 => 0x378 },
	'meterinfo2row3' => { 336 => 0x3fc },
	'meterinfo2row4' => { 336 => 0x480 },
	'meterinfo2row5' => { 336 => 0x504 },
	'meterinfo2row6' => { 336 => 0x588 },
	'meterinfo2row7' => { 336 => 0x60c },
	'meterinfo2row8' => { 336 => 0x690 },
	'meterinfo2row9' => { 336 => 0x714 },
	'metering' => { 223 => '6.1' },
	'meteringmode' => { 29 => 0x11, 95 => 0x9207, 111 => 0x1c, 147 => 0x7, 148 => 0x25, 150 => 0x12, 233 => 0x202, 284 => 0x17, 315 => 0x9, 323 => 0x15, 324 => 0x13, 325 => 0x7, 339 => 0x3, 342 => 0x1174, 343 => 0x1178, 344 => 0x1154, 345 => 0x11d0, 346 => 0x11ac, 347 => 0x1064, 348 => 0x25c, 380 => 'MeteringMode' },
	'meteringmode2' => { 265 => '2.1' },
	'meteringmode3' => { 265 => '16.1' },
	'meteringoffscaleindicator' => { 150 => 0x53 },
	'meteringtime' => { 222 => '22.2', 223 => '3.2', 224 => '17.1', 225 => '18.1', 227 => '7.3', 228 => '18.1', 229 => '3.2', 231 => '19.1' },
	'mieversion' => { 133 => '0Vers' },
	'minaperture' => { 29 => 0x1b, 132 => 'MinAperture', 275 => '0.2', 349 => 0x1 },
	'minfocallength' => { 5 => 0xe4, 6 => 0xe, 7 => 0x1a9, 8 => 0x11, 9 => 0x113, 10 => 0x11, 11 => 0x151, 12 => 0xd8, 14 => 0xf8, 15 => 0xec, 16 => 0x101, 17 => 0x93, 18 => 0xe8, 19 => 0x155, 20 => 0xec, 21 => 0xea, 22 => 0x129, 23 => 0x163, 24 => 0x168, 25 => 0x114, 29 => 0x18, 100 => 0x1404, 132 => 'MinFocalLength', 177 => 0x8, 178 => 0xd, 179 => 0xe, 234 => 0x207, 346 => 0x127a, 347 => 0x1136, 348 => 0x32e },
	'minoltadate' => { 147 => 0x15 },
	'minoltaimagesize' => { 147 => 0x4, 148 => 0xc, 149 => 0x2, 152 => 0x103 },
	'minoltamodelid' => { 147 => 0x25 },
	'minoltaquality' => { 147 => 0x5, 148 => 0xd, 149 => 0x3, 152 => [0x102,0x103] },
	'minoltatime' => { 147 => 0x16 },
	'minormodelagedisclosure' => { 389 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 95 => 0x118 },
	'mirrorlockup' => { 66 => 0xc, 67 => 0xc, 68 => 0x60f, 69 => 0xb, 70 => 0xc, 71 => 0x6, 72 => 0x6, 73 => 0xc, 74 => 0x3 },
	'mobilecountrycode' => { 375 => 'mcc' },
	'mobilenetworkcode' => { 375 => 'mnc' },
	'moddate' => { 245 => 'modify-date', 387 => 'ModDate' },
	'modedialposition' => { 329 => 0x14 },
	'model' => { 82 => 0x6, 95 => 0x110, 125 => 'Model', 245 => 'Model', 257 => 0x110, 395 => 'Model' },
	'modelage' => { 386 => 'ModelAge' },
	'modelid' => { 232 => 0x0 },
	'modelingflash' => { 222 => '21.4', 227 => '26.4', 228 => '30.2', 229 => '7.4', 230 => '30.1', 231 => '31.3' },
	'modelreleaseid' => { 389 => 'ModelReleaseID' },
	'modelreleasestatus' => { 389 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 350 => 0x52, 351 => 0x46 },
	'modificationdate' => { 390 => 'modificationDate' },
	'modifiedcolortemp' => { 53 => 0x9 },
	'modifieddigitalgain' => { 53 => 0xb },
	'modifiedparamflag' => { 47 => 0x1 },
	'modifiedpicturestyle' => { 53 => 0xa },
	'modifiedsaturation' => { 233 => 0x504 },
	'modifiedsensorbluelevel' => { 53 => 0x5 },
	'modifiedsensorredlevel' => { 53 => 0x4 },
	'modifiedsharpness' => { 53 => 0x2 },
	'modifiedsharpnessfreq' => { 53 => 0x3 },
	'modifiedtonecurve' => { 53 => 0x1 },
	'modifiedwhitebalance' => { 53 => 0x8 },
	'modifiedwhitebalanceblue' => { 53 => 0x7 },
	'modifiedwhitebalancered' => { 53 => 0x6 },
	'modifydate' => { 95 => 0x132, 126 => 'ModifyDate', 242 => 'ModDate', 243 => 'tIME', 297 => 'ModDate', 299 => 0x2, 397 => 'ModifyDate' },
	'moirefilter' => { 95 => 0xfe58, 376 => 'MoireFilter' },
	'monitordisplayoff' => { 150 => 0x4c },
	'monitorofftime' => { 222 => '18.2', 223 => '3.1', 229 => '3.1' },
	'monochromecontrast' => { 87 => 0x3c },
	'monochromefiltereffect' => { 87 => 0x3a, 284 => 0x73 },
	'monochromelinear' => { 87 => 0x3d },
	'monochromeoutputhighlightpoint' => { 87 => 0x41 },
	'monochromeoutputshadowpoint' => { 87 => 0x42 },
	'monochromerawhighlight' => { 87 => 0x7a },
	'monochromerawhighlightpoint' => { 87 => 0x3f },
	'monochromerawshadow' => { 87 => 0x83 },
	'monochromerawshadowpoint' => { 87 => 0x40 },
	'monochromesharpness' => { 87 => 0x3e },
	'monochrometoning' => { 284 => 0x74 },
	'monochrometoningeffect' => { 87 => 0x3b },
	'monochromeunsharpmaskfineness' => { 87 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 87 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 87 => 0xb4 },
	'monthdaycreated' => { 111 => 0x12, 120 => 0xe },
	'moonphase' => { 302 => 0x12 },
	'morepermissions' => { 374 => 'morePermissions' },
	'motionsensitivity' => { 302 => 0x29 },
	'multiburstimageheight' => { 335 => 0x1002 },
	'multiburstimagewidth' => { 335 => 0x1001 },
	'multiburstmode' => { 335 => 0x1000 },
	'multicontrollerwhilemetering' => { 68 => 0x517 },
	'multiexposureautogain' => { 183 => 0x3 },
	'multiexposuremode' => { 183 => 0x1 },
	'multiexposureshots' => { 183 => 0x2 },
	'multiframenoisereduction' => { 325 => 0x35, 335 => 0x200b, 339 => 0x15 },
	'multifunctionlock' => { 68 => 0x70f },
	'multipleexposuremode' => { 237 => 0x101c },
	'multipleexposureset' => { 265 => '10.1' },
	'multisample' => { 187 => 0x40 },
	'multiselector' => { 222 => '9.4', 227 => '27.4' },
	'multiselectorliveview' => { 222 => '4.3' },
	'multiselectorplaybackmode' => { 222 => ['13.5','9.2'], 227 => '27.2' },
	'multiselectorshootmode' => { 222 => '9.1', 227 => '27.1' },
	'mycolormode' => { 55 => 0x2 },
	'nativedigest' => { 380 => 'NativeDigest', 395 => 'NativeDigest' },
	'ncdfileinfo' => { 109 => 0x414 },
	'ndfilter' => { 62 => 0x1c, 233 => 0x204, 306 => 0x1019 },
	'nefbitdepth' => { 182 => 0xe22 },
	'nefcompression' => { 182 => 0x93 },
	'neflinearizationtable' => { 182 => 0x96 },
	'neutraldensityfilter' => { 284 => 0x88 },
	'neutraloutputhighlightpoint' => { 87 => 0x2f },
	'neutraloutputshadowpoint' => { 87 => 0x30 },
	'neutralrawcolortone' => { 87 => 0x28 },
	'neutralrawcontrast' => { 87 => 0x2a },
	'neutralrawhighlight' => { 87 => 0x78 },
	'neutralrawhighlightpoint' => { 87 => 0x2d },
	'neutralrawlinear' => { 87 => 0x2b },
	'neutralrawsaturation' => { 87 => 0x29 },
	'neutralrawshadow' => { 87 => 0x81 },
	'neutralrawshadowpoint' => { 87 => 0x2e },
	'neutralrawsharpness' => { 87 => 0x2c },
	'neutralunsharpmaskfineness' => { 87 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 87 => 0xa8 },
	'neutraunsharpmaskstrength' => { 87 => 0xa4 },
	'newrawimagedigest' => { 95 => 0xc7a7 },
	'newsphotoversion' => { 105 => 0x0 },
	'nickname' => { 397 => 'Nickname' },
	'nikoncapturedata' => { 182 => 0xe01 },
	'nikoncaptureeditversions' => { 182 => 0xe13 },
	'nikoncaptureoutput' => { 182 => 0xe1e },
	'nikoncaptureversion' => { 182 => 0xe09 },
	'nikoniccprofile' => { 182 => 0xe1d },
	'nikonimagesize' => { 194 => '723.1', 195 => '732.1', 202 => 0x2c4 },
	'noisefilter' => { 233 => 0x527 },
	'noiseprofile' => { 95 => 0xc761 },
	'noisereduction' => { 100 => 0x100b, 148 => 0xb0, 149 => 0x60, 150 => 0x3f, 182 => 0x95, 215 => 0x753dcbc0, 216 => 0x17, 233 => 0x50a, 238 => 0x103a, 253 => 0x2d, 284 => 0x49, 306 => 0x100f, 308 => 0x2a },
	'noisereduction2' => { 237 => 0x1010 },
	'noisereductionapplied' => { 95 => 0xc6f7 },
	'noisereductionintensity' => { 216 => 0x9 },
	'noisereductionmethod' => { 216 => 0x11 },
	'noisereductionmode' => { 362 => 0x801e },
	'noisereductionsharpness' => { 216 => 0xd },
	'noisereductionvalue' => { 362 => 0x8027 },
	'nomemorycard' => { 222 => '22.1', 223 => '0.3', 224 => '2.4', 225 => '3.2', 226 => '3.2', 227 => '33.7', 228 => '3.2', 229 => '0.3', 231 => '4.5' },
	'nominalmaxaperture' => { 275 => 0xa },
	'nominalminaperture' => { 275 => '10.1' },
	'normalwhitelevel' => { 36 => [0x2b8,0x2cf,0x2d3], 38 => 0x1e3, 39 => [0x1fc,0x2dc] },
	'notes' => { 363 => 'Notes', 371 => 'notes' },
	'npages' => { 404 => 'NPages' },
	'nrwdata' => { 182 => 0x14 },
	'nullrecord' => { 81 => 0x0 },
	'number' => { 390 => 'number' },
	'numberofbeats' => { 399 => 'numberOfBeats' },
	'numberoffocuspoints' => { 226 => '0.2', 228 => '0.3' },
	'numfacepositions' => { 247 => 0x0 },
	'numindexentries' => { 105 => 0x54 },
	'object' => { 390 => 'object' },
	'objectattributereference' => { 103 => 0x4 },
	'objectcycle' => { 103 => 0x4b },
	'objectdistance' => { 90 => 0x6, 91 => 0x2022 },
	'objectname' => { 103 => 0x5 },
	'objectpreviewdata' => { 103 => 0xca },
	'objectpreviewfileformat' => { 103 => 0xc8 },
	'objectpreviewfileversion' => { 103 => 0xc9 },
	'objecttypereference' => { 103 => 0x3 },
	'occurrence' => { 94 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 94 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 94 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 94 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 94 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 94 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 94 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 94 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 94 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 94 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 94 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 94 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 94 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 94 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 94 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 94 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 94 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 94 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 94 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 94 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 94 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 94 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 94 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 94 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 380 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 380 => [\'OECF','OECFNames'] },
	'oecfrows' => { 380 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 380 => [\'OECF','OECFValues'] },
	'offsetschema' => { 95 => 0xea1d },
	'okbutton' => { 228 => '15.1', 231 => '16.1' },
	'oldsubfiletype' => { 95 => 0xff },
	'olympusimageheight' => { 238 => 0x102f },
	'olympusimagewidth' => { 238 => 0x102e },
	'onetouchwb' => { 238 => 0x302 },
	'opticalzoom' => { 113 => 0xfa3d, 115 => [0x6006,0xf006], 116 => 0x1000, 117 => 0xf, 120 => 0x1e, 132 => 'OpticalZoom' },
	'opticalzoomcode' => { 62 => 0xa },
	'opticalzoommode' => { 253 => 0x34 },
	'opticalzoomon' => { 314 => 0x219 },
	'optionenddate' => { 392 => 'optionEndDate' },
	'opto-electricconvfactor' => { 380 => 'OECF' },
	'ordernumber' => { 100 => 0x8002 },
	'organisationinimagecode' => { 386 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 386 => 'OrganisationInImageName' },
	'organization' => { 390 => 'organization' },
	'orientation' => { 95 => 0x112, 257 => 0x112, 395 => 'Orientation' },
	'orientation2' => { 339 => 0x2e },
	'orientationlinkedafpoint' => { 68 => 0x516 },
	'originalbestqualitysize' => { 95 => 0xc792 },
	'originaldecisiondata' => { 92 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 51 => 0x83 },
	'originaldefaultcropsize' => { 95 => 0xc793 },
	'originaldefaultfinalsize' => { 95 => 0xc791 },
	'originaldirectory' => { 251 => 0x408 },
	'originaldocumentid' => { 400 => 'OriginalDocumentID' },
	'originalfilename' => { 81 => 0x816, 109 => 0x3e9, 121 => 0x20, 251 => 0x407, 367 => 'OriginalFilename' },
	'originalimageheight' => { 64 => 0xc, 99 => 0x1 },
	'originalimagewidth' => { 64 => 0xb, 99 => 0x0 },
	'originalrawfiledata' => { 95 => 0xc68c },
	'originalrawfiledigest' => { 95 => 0xc71d },
	'originalrawfilename' => { 95 => 0xc68b },
	'originaltransmissionreference' => { 103 => 0x67 },
	'originatingprogram' => { 103 => 0x41 },
	'originplatform' => { 390 => 'originPlatform' },
	'os' => { 378 => 'os' },
	'otherconditions' => { 389 => 'OtherConditions' },
	'otherconstraints' => { 389 => 'OtherConstraints' },
	'otherimage' => { 92 => 'OtherImage' },
	'otherimageinfo' => { 389 => 'OtherImageInfo' },
	'otherimagelength' => { 95 => 0x202 },
	'otherimagestart' => { 95 => 0x201 },
	'otherlicensedocuments' => { 389 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 389 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 389 => 'OtherLicenseRequirements' },
	'outcue' => { 399 => 'outCue' },
	'outcuescale' => { 399 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 399 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 161 => 0x3 },
	'outputimagewidth' => { 161 => 0x2 },
	'outputresolution' => { 161 => 0x4 },
	'owner' => { 403 => 'Owner' },
	'ownerid' => { 103 => 0xbc },
	'ownername' => { 13 => 0x10f, 51 => 0x9, 81 => 0x810, 95 => [0xa430,0xfde8], 125 => 'OwnerName', 373 => 'OwnerName', 381 => 'CameraOwnerName' },
	'padding' => { 95 => 0xea1c },
	'pageimage' => { 397 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 397 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 397 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 397 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 397 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 397 => 'PageInfo' },
	'pagename' => { 95 => 0x11d },
	'pagenumber' => { 95 => 0x129 },
	'pagerange' => { 390 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 376 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 376 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 253 => 0x26 },
	'panasonicimageheight' => { 253 => 0x4c },
	'panasonicimagewidth' => { 253 => 0x4b },
	'panasonicrawversion' => { 257 => 0x1 },
	'panasonictitle' => { 95 => 0xc6d2 },
	'panasonictitle2' => { 95 => 0xc6d3 },
	'panoramacropbottom' => { 340 => 0x7 },
	'panoramacropleft' => { 340 => 0x4 },
	'panoramacropright' => { 340 => 0x6 },
	'panoramacroptop' => { 340 => 0x5 },
	'panoramadirection' => { 58 => 0x5, 340 => 0x3 },
	'panoramaframeheight' => { 340 => 0x9 },
	'panoramaframenumber' => { 58 => 0x2 },
	'panoramaframewidth' => { 340 => 0x8 },
	'panoramafullheight' => { 340 => 0x2 },
	'panoramafullwidth' => { 340 => 0x1 },
	'panoramamode' => { 111 => 0x3c, 233 => 0x601 },
	'panoramasize3d' => { 325 => 0x38 },
	'panoramasourceheight' => { 340 => 0xb },
	'panoramasourcewidth' => { 340 => 0xa },
	'panoramicstitchcameramotion' => { 143 => 'PanoramicStitchCameraMotion', 144 => 0x1 },
	'panoramicstitchmaptype' => { 143 => 'PanoramicStitchMapType', 144 => 0x2 },
	'panoramicstitchphi0' => { 143 => 'PanoramicStitchPhi0', 144 => 0x5 },
	'panoramicstitchphi1' => { 143 => 'PanoramicStitchPhi1', 144 => 0x6 },
	'panoramicstitchtheta0' => { 143 => 'PanoramicStitchTheta0', 144 => 0x3 },
	'panoramicstitchtheta1' => { 143 => 'PanoramicStitchTheta1', 144 => 0x4 },
	'panoramicstitchversion' => { 144 => 0x0 },
	'pantry' => { 400 => 'Pantry' },
	'parallax' => { 100 => 0xb211, 232 => 0x28 },
	'parametricdarks' => { 376 => 'ParametricDarks' },
	'parametrichighlights' => { 376 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 376 => 'ParametricHighlightSplit' },
	'parametriclights' => { 376 => 'ParametricLights' },
	'parametricmidtonesplit' => { 376 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 376 => 'ParametricShadows' },
	'parametricshadowsplit' => { 376 => 'ParametricShadowSplit' },
	'parentmeid' => { 367 => 'ParentMEID' },
	'parentreference1' => { 384 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 384 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 399 => 'partOfCompilation' },
	'patientbirthdate' => { 364 => 'PatientDOB' },
	'patientid' => { 364 => 'PatientID' },
	'patientname' => { 364 => 'PatientName' },
	'patientsex' => { 364 => 'PatientSex' },
	'pdfversion' => { 387 => 'PDFVersion' },
	'pentaximagesize' => { 284 => 0x9 },
	'pentaxmodelid' => { 264 => 0x0, 284 => 0x5 },
	'pentaxmodeltype' => { 284 => 0x1 },
	'pentaxversion' => { 284 => 0x0 },
	'people' => { 365 => 'People', 369 => 'People' },
	'perchannelblacklevel' => { 35 => 0xc4, 36 => [0x2b4,0x2cb,0x2cf], 37 => 0x108, 38 => 0x1df, 39 => [0x1f8,0x2d8] },
	'peripheralillumcentralradius' => { 362 => 0x8030 },
	'peripheralillumcentralvalue' => { 362 => 0x8031 },
	'peripheralillumination' => { 87 => 0x68 },
	'peripheralilluminationon' => { 87 => 0x64 },
	'peripheralillumperiphvalue' => { 362 => 0x8032 },
	'peripherallighting' => { 64 => 0x2 },
	'peripherallightingsetting' => { 65 => 0x5 },
	'peripherallightingvalue' => { 64 => 0x6 },
	'permissions' => { 392 => 'permissions' },
	'permits' => { 374 => 'permits' },
	'person' => { 390 => 'person' },
	'personality' => { 367 => 'Personality' },
	'personinimage' => { 386 => 'PersonInImage' },
	'perspectiveaspect' => { 376 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 376 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 376 => 'PerspectiveRotate' },
	'perspectivescale' => { 376 => 'PerspectiveScale' },
	'perspectiveupright' => { 376 => 'PerspectiveUpright' },
	'perspectivevertical' => { 376 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 76 => 0x1 },
	'pf10retainprogramshift' => { 76 => 0xb },
	'pf13drivepriority' => { 76 => 0xe },
	'pf14disablefocussearch' => { 76 => 0xf },
	'pf15disableafassistbeam' => { 76 => 0x10 },
	'pf16autofocuspointshoot' => { 76 => 0x11 },
	'pf17disableafpointsel' => { 76 => 0x12 },
	'pf18enableautoafpointsel' => { 76 => 0x13 },
	'pf19continuousshootspeed' => { 76 => 0x14 },
	'pf19shootingspeedhigh' => { 75 => 0xa },
	'pf19shootingspeedlow' => { 75 => 0x9 },
	'pf1disableshootingmodes' => { 76 => 0x2 },
	'pf1value' => { 75 => 0x1 },
	'pf20limitcontinousshots' => { 76 => 0x15 },
	'pf20maxcontinousshots' => { 75 => 0xb },
	'pf21enablequietoperation' => { 76 => 0x16 },
	'pf23felocktime' => { 75 => 0xd },
	'pf23postreleasetime' => { 75 => 0xe },
	'pf23settimerlengths' => { 76 => 0x18 },
	'pf23shutterbuttontime' => { 75 => 0xc },
	'pf24lightlcdduringbulb' => { 76 => 0x19 },
	'pf25aemode' => { 75 => 0xf },
	'pf25afmode' => { 75 => 0x12 },
	'pf25afpointsel' => { 75 => 0x13 },
	'pf25colormatrix' => { 75 => 0x17 },
	'pf25defaultclearsettings' => { 76 => 0x1a },
	'pf25drivemode' => { 75 => 0x11 },
	'pf25imagesize' => { 75 => 0x14 },
	'pf25meteringmode' => { 75 => 0x10 },
	'pf25parameters' => { 75 => 0x16 },
	'pf25wbmode' => { 75 => 0x15 },
	'pf26shortenreleaselag' => { 76 => 0x1b },
	'pf27reversedialrotation' => { 76 => 0x1c },
	'pf27value' => { 75 => 0x18 },
	'pf28noquickdialexpcomp' => { 76 => 0x1d },
	'pf29quickdialswitchoff' => { 76 => 0x1e },
	'pf2disablemeteringmodes' => { 76 => 0x3 },
	'pf2value' => { 75 => 0x2 },
	'pf30enlargementmode' => { 76 => 0x1f },
	'pf31originaldecisiondata' => { 76 => 0x20 },
	'pf3manualexposuremetering' => { 76 => 0x4 },
	'pf3value' => { 75 => 0x3 },
	'pf4exposuretimelimits' => { 76 => 0x5 },
	'pf4exposuretimemax' => { 75 => 0x5 },
	'pf4exposuretimemin' => { 75 => 0x4 },
	'pf5aperturelimits' => { 76 => 0x6 },
	'pf5aperturemax' => { 75 => 0x7 },
	'pf5aperturemin' => { 75 => 0x6 },
	'pf6presetshootingmodes' => { 76 => 0x7 },
	'pf7bracketcontinuousshoot' => { 76 => 0x8 },
	'pf8bracketshots' => { 75 => 0x8 },
	'pf8setbracketshots' => { 76 => 0x9 },
	'pf9changebracketsequence' => { 76 => 0xa },
	'phasedetectaf' => { 158 => 0x6 },
	'phonenumber' => { 126 => 'Phone' },
	'photoeffect' => { 29 => 0x28 },
	'photoeffecthistoryxml' => { 215 => 0xe9651831 },
	'photoeffects' => { 215 => 0xab5eca5e },
	'photoeffectsblue' => { 217 => 0x8 },
	'photoeffectsgreen' => { 217 => 0x6 },
	'photoeffectsred' => { 217 => 0x4 },
	'photoeffectstype' => { 217 => 0x0 },
	'photographicsensitivity' => { 381 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 222 => '17.6', 227 => '33.6' },
	'photometricinterpretation' => { 95 => 0x106, 395 => 'PhotometricInterpretation' },
	'photoshopquality' => { 294 => 0x0 },
	'photostyle' => { 253 => 0x89 },
	'picklabel' => { 379 => 'PickLabel' },
	'pictinfo' => { 314 => 0x208 },
	'picturecontrol' => { 215 => 0xe2173c47 },
	'picturecontrolactive' => { 218 => 0x0 },
	'picturecontroladjust' => { 184 => 0x30 },
	'picturecontrolbase' => { 184 => 0x18 },
	'picturecontroldata' => { 182 => [0xbd,0x23] },
	'picturecontrolmode' => { 218 => 0x13 },
	'picturecontrolname' => { 184 => 0x4 },
	'picturecontrolquickadjust' => { 184 => 0x31 },
	'pictureeffect' => { 335 => 0x200e },
	'pictureeffect2' => { 342 => 0x1163, 343 => 0x1167, 344 => 0x1143, 345 => 0x11bf, 346 => 0x119b, 347 => 0x1053, 348 => 0x24b, 358 => 0x46 },
	'picturefinish' => { 148 => 0x71 },
	'picturemode' => { 100 => 0x1031, 233 => 0x520, 284 => [0xb,0x33], 315 => 0x3d },
	'picturemode2' => { 265 => 0x0 },
	'picturemodebwfilter' => { 233 => 0x525 },
	'picturemodecontrast' => { 233 => 0x523 },
	'picturemodeeffect' => { 233 => 0x52d },
	'picturemodehue' => { 233 => 0x522 },
	'picturemodesaturation' => { 233 => 0x521 },
	'picturemodesharpness' => { 233 => 0x524 },
	'picturemodetone' => { 233 => 0x526 },
	'picturestyle' => { 6 => [0x4b,0x51], 7 => 0xf4, 8 => 0x6c, 9 => 0x86, 10 => 0x73, 14 => 0xab, 15 => 0xa7, 16 => 0xb0, 17 => 0x6c, 18 => 0xa7, 19 => 0xf4, 20 => 0xb3, 22 => 0xf4, 23 => 0xfa, 60 => 0xa, 87 => 0x2 },
	'picturewizard' => { 312 => 0x21 },
	'picturewizardcolor' => { 311 => 0x1 },
	'picturewizardcontrast' => { 311 => 0x4 },
	'picturewizardmode' => { 311 => 0x0 },
	'picturewizardsaturation' => { 311 => 0x2 },
	'picturewizardsharpness' => { 311 => 0x3 },
	'pitchangle' => { 253 => 0x91, 283 => 0x2 },
	'pixelsperunitx' => { 244 => 0x0 },
	'pixelsperunity' => { 244 => 0x4 },
	'pixelunits' => { 244 => 0x8 },
	'planarconfiguration' => { 95 => 0x11c, 395 => 'PlanarConfiguration' },
	'platenames' => { 404 => 'PlateNames' },
	'playbackmenustime' => { 224 => '20.1', 225 => '21.1', 226 => '21.1' },
	'playbackmonitorofftime' => { 227 => '8.1', 228 => '35.1', 231 => '21.1' },
	'playdisplay' => { 150 => 0x4e },
	'plusversion' => { 389 => 'Version' },
	'pmversion' => { 293 => 'PMVersion' },
	'pngwarning' => { 245 => 'Warning' },
	'poilevel' => { 181 => 0x8 },
	'portraitoutputhighlightpoint' => { 87 => 0x1d },
	'portraitoutputshadowpoint' => { 87 => 0x1e },
	'portraitrawcolortone' => { 87 => 0x16 },
	'portraitrawcontrast' => { 87 => 0x18 },
	'portraitrawhighlight' => { 87 => 0x76 },
	'portraitrawhighlightpoint' => { 87 => 0x1b },
	'portraitrawlinear' => { 87 => 0x19 },
	'portraitrawsaturation' => { 87 => 0x17 },
	'portraitrawshadow' => { 87 => 0x7f },
	'portraitrawshadowpoint' => { 87 => 0x1c },
	'portraitrawsharpness' => { 87 => 0x1a },
	'portraitrefiner' => { 91 => 0x302b },
	'portraitunsharpmaskfineness' => { 87 => 0x9a },
	'portraitunsharpmaskstrength' => { 87 => 0x98 },
	'portraitunsharpmaskthreshold' => { 87 => 0x9c },
	'poseheadingdegrees' => { 366 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 366 => 'PosePitchDegrees' },
	'poserolldegrees' => { 366 => 'PoseRollDegrees' },
	'postalcode' => { 130 => 'PostalCode' },
	'postcropvignetteamount' => { 376 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 376 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 376 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 376 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 376 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 376 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 333 => 0xb },
	'potentialface2position' => { 333 => 0x15 },
	'potentialface3position' => { 333 => 0x1f },
	'potentialface4position' => { 333 => 0x29 },
	'potentialface5position' => { 333 => 0x33 },
	'potentialface6position' => { 333 => 0x3d },
	'potentialface7position' => { 333 => 0x47 },
	'potentialface8position' => { 333 => 0x51 },
	'powersource' => { 263 => '0.1' },
	'poweruptime' => { 182 => 0xb6 },
	'precaptureframes' => { 238 => 0x300 },
	'predictor' => { 95 => 0x13d },
	'preflashreturnstrength' => { 195 => 0x28a },
	'prefs' => { 103 => 0xdd, 293 => 'Prefs' },
	'preservedfilename' => { 400 => 'PreservedFileName' },
	'presetwhitebalance' => { 150 => 0x24, 362 => 0x8002 },
	'presetwhitebalanceadj' => { 362 => 0x8014 },
	'previewapplicationname' => { 95 => 0xc716 },
	'previewapplicationversion' => { 95 => 0xc717 },
	'previewbutton' => { 222 => ['14.1','15.1'], 227 => '29.1', 228 => '14.1' },
	'previewbuttonplusdials' => { 222 => ['14.2','15.2'], 227 => '31.2' },
	'previewcolorspace' => { 95 => 0xc71a },
	'previewcropbottom' => { 292 => 0xef },
	'previewcropleft' => { 292 => 0xec },
	'previewcropright' => { 292 => 0xee },
	'previewcroptop' => { 292 => 0xed },
	'previewdate' => { 300 => 0x0 },
	'previewdatetime' => { 95 => 0xc71b },
	'previewimage' => { 91 => 0x2000, 92 => 'PreviewImage', 96 => 'PreviewImage', 98 => 0x4, 135 => 'data', 152 => 0x81, 238 => 0x280, 252 => 0x300, 335 => 0x2001 },
	'previewimageborders' => { 284 => 0x3e },
	'previewimageheight' => { 59 => 0x4, 113 => 0xfa58 },
	'previewimagelength' => { 59 => 0x2, 91 => 0x3, 95 => [0x117,0x202], 152 => 0x89, 185 => 0x202, 233 => 0x102, 238 => 0x1037, 284 => 0x3, 305 => 0x1e, 310 => 0x3, 315 => [0x1b,0x1d], 326 => 0x202 },
	'previewimagename' => { 135 => '1Name' },
	'previewimagesize' => { 91 => 0x2, 118 => 0x2, 135 => 'ImageSize', 284 => 0x2, 315 => [0x1c,0x1e], 335 => 0xb02c },
	'previewimagestart' => { 59 => 0x5, 91 => 0x4, 95 => [0x111,0x201], 152 => 0x88, 185 => 0x201, 233 => 0x101, 238 => 0x1036, 284 => 0x4, 305 => 0x1c, 310 => 0x2, 315 => [0x1a,0x1c], 326 => 0x201 },
	'previewimagetype' => { 135 => '0Type' },
	'previewimagevalid' => { 233 => 0x100, 238 => 0x1035 },
	'previewimagewidth' => { 59 => 0x3, 113 => 0xfa57 },
	'previewquality' => { 59 => 0x1 },
	'previewsettingsdigest' => { 95 => 0xc719 },
	'previewsettingsname' => { 95 => 0xc718 },
	'primaryafpoint' => { 158 => 0x7 },
	'primarychromaticities' => { 95 => 0x13f, 395 => 'PrimaryChromaticities' },
	'printim' => { 95 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 150 => 0x1d, 323 => 0x28 },
	'privatertkinfo' => { 368 => 'privateRTKInfo' },
	'processingsoftware' => { 95 => 0xb },
	'processversion' => { 376 => 'ProcessVersion' },
	'producer' => { 242 => 'Producer', 387 => 'Producer' },
	'productid' => { 104 => 0x32 },
	'productioncode' => { 264 => 0x2 },
	'productorserviceconstraints' => { 389 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 95 => 0xc6f4 },
	'profilecopyright' => { 95 => 0xc6fe },
	'profileembedpolicy' => { 95 => 0xc6fd },
	'profilehuesatmapdata1' => { 95 => 0xc6fa },
	'profilehuesatmapdata2' => { 95 => 0xc6fb },
	'profilehuesatmapdims' => { 95 => 0xc6f9 },
	'profilehuesatmapencoding' => { 95 => 0xc7a3 },
	'profilelooktabledata' => { 95 => 0xc726 },
	'profilelooktabledims' => { 95 => 0xc725 },
	'profilelooktableencoding' => { 95 => 0xc7a4 },
	'profilename' => { 95 => 0xc6f8 },
	'profiletonecurve' => { 95 => 0xc6fc },
	'programiso' => { 253 => 0x3c },
	'programline' => { 265 => '1.1' },
	'programmode' => { 155 => 0x5 },
	'programshift' => { 182 => 0xd },
	'programversion' => { 103 => 0x46 },
	'prohibits' => { 374 => 'prohibits' },
	'projectiontype' => { 366 => 'ProjectionType' },
	'projectname' => { 399 => 'projectName' },
	'projectref' => { 399 => 'projectRef' },
	'projectrefpath' => { 399 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 399 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 389 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 389 => 'PropertyReleaseStatus' },
	'province-state' => { 103 => 0x5f },
	'publicationdate' => { 390 => 'publicationDate' },
	'publicationname' => { 390 => 'publicationName' },
	'publisher' => { 377 => 'publisher' },
	'pulldown' => { 399 => 'pullDown' },
	'quality' => { 0 => 0x1, 29 => 0x3, 90 => 0x2, 91 => 0x3002, 100 => 0x1000, 111 => 0x9, 182 => 0x4, 205 => 0x3, 238 => 0x201, 249 => 0x300, 284 => 0x8, 290 => 0x2, 315 => 0x16, 323 => 0x56, 324 => 0x56, 325 => 0xb, 335 => 0x102 },
	'quality2' => { 342 => 0x1170, 343 => 0x1174, 344 => 0x1150, 346 => 0x11a8, 347 => 0x1060, 348 => 0x258, 350 => 0x29, 351 => 0x25, 352 => 0x2a },
	'qualitymode' => { 91 => 0x8 },
	'quantizationmethod' => { 105 => 0x78 },
	'quickadjust' => { 218 => 0x2a },
	'quickcontroldialinmeter' => { 68 => 0x703 },
	'quickfix' => { 215 => 0x416391c6 },
	'quickshot' => { 314 => 0x213 },
	'rangefinder' => { 224 => '4.1', 225 => '5.1', 226 => '5.1' },
	'rasterizedcaption' => { 103 => 0x7d },
	'rating' => { 95 => 0x4746, 292 => 0xdf, 335 => 0x2002, 371 => 'rating', 378 => 'rating', 397 => 'Rating' },
	'ratingpercent' => { 95 => 0x4749, 145 => 'Rating' },
	'rawandjpgrecording' => { 66 => 0x8, 152 => 0x109, 265 => 0xd },
	'rawbrightnessadj' => { 86 => 0x38 },
	'rawcoloradj' => { 86 => 0x2e },
	'rawcropbottom' => { 292 => 0xd4 },
	'rawcropleft' => { 292 => 0xd1 },
	'rawcropright' => { 292 => 0xd3 },
	'rawcroptop' => { 292 => 0xd2 },
	'rawcustomsaturation' => { 86 => 0x30 },
	'rawcustomtone' => { 86 => 0x34 },
	'rawdatauniqueid' => { 95 => 0xc65d },
	'rawdepth' => { 154 => 0x10 },
	'rawdevartfilter' => { 240 => 0x121 },
	'rawdevautogradation' => { 240 => 0x119 },
	'rawdevcolorspace' => { 239 => 0x108, 240 => 0x109 },
	'rawdevcontrastvalue' => { 239 => 0x106, 240 => 0x105 },
	'rawdeveditstatus' => { 239 => 0x10b },
	'rawdevelopmentprocess' => { 284 => 0x62 },
	'rawdevengine' => { 239 => 0x109, 240 => 0x10b },
	'rawdevexposurebiasvalue' => { 239 => 0x100, 240 => 0x100 },
	'rawdevgradation' => { 240 => 0x112 },
	'rawdevgraypoint' => { 239 => 0x103, 240 => 0x104 },
	'rawdevmemorycoloremphasis' => { 239 => 0x105, 240 => 0x108 },
	'rawdevnoisereduction' => { 239 => 0x10a, 240 => 0x10a },
	'rawdevpicturemode' => { 240 => 0x10c },
	'rawdevpm_bwfilter' => { 240 => 0x110 },
	'rawdevpmcontrast' => { 240 => 0x10e },
	'rawdevpmnoisefilter' => { 240 => 0x120 },
	'rawdevpmpicturetone' => { 240 => 0x111 },
	'rawdevpmsaturation' => { 240 => 0x10d },
	'rawdevpmsharpness' => { 240 => 0x10f },
	'rawdevsaturation3' => { 240 => 0x113 },
	'rawdevsaturationemphasis' => { 239 => 0x104, 240 => 0x107 },
	'rawdevsettings' => { 239 => 0x10c },
	'rawdevsharpnessvalue' => { 239 => 0x107, 240 => 0x106 },
	'rawdevversion' => { 239 => 0x0, 240 => 0x0 },
	'rawdevwbfineadjustment' => { 239 => 0x102, 240 => 0x103 },
	'rawdevwhitebalance' => { 240 => 0x101 },
	'rawdevwhitebalancevalue' => { 239 => 0x101, 240 => 0x102 },
	'rawfile' => { 95 => 0xfe4c },
	'rawfilename' => { 376 => 'RawFileName' },
	'rawimagecenter' => { 182 => 0x99 },
	'rawimagedigest' => { 95 => 0xc71c },
	'rawimagesize' => { 284 => 0x39 },
	'rawinfoversion' => { 241 => 0x0 },
	'rawjpgheight' => { 83 => 0x4 },
	'rawjpgquality' => { 46 => 0x6, 83 => 0x1 },
	'rawjpgsize' => { 46 => 0x7, 83 => 0x2 },
	'rawjpgwidth' => { 83 => 0x3 },
	'rawmeasuredrggb' => { 34 => 0x26a, 36 => 0x280, 38 => 0x194, 39 => [0x1ad,0x26b] },
	'rawrppused' => { 371 => 'rawrppused' },
	'rawtopreviewgain' => { 95 => 0xc7a8 },
	'reardisplay' => { 222 => '12.3' },
	'recognizedface1age' => { 248 => 0x20 },
	'recognizedface1name' => { 248 => 0x4 },
	'recognizedface1position' => { 248 => 0x18 },
	'recognizedface2age' => { 248 => 0x50 },
	'recognizedface2name' => { 248 => 0x34 },
	'recognizedface2position' => { 248 => 0x48 },
	'recognizedface3age' => { 248 => 0x80 },
	'recognizedface3name' => { 248 => 0x64 },
	'recognizedface3position' => { 248 => 0x78 },
	'recognizedfaceflags' => { 253 => 0x63 },
	'recommendedexposureindex' => { 95 => 0x8832, 381 => 'RecommendedExposureIndex' },
	'record' => { 94 => 'Record' },
	'recordbasisofrecord' => { 94 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 94 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 94 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 94 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 94 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 94 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 150 => 0x4d },
	'recorddynamicproperties' => { 94 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 81 => 0x1804 },
	'recordinformationwithheld' => { 94 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 306 => 0x1000 },
	'recordingmode' => { 90 => 0x1, 290 => 0x1 },
	'recordinstitutioncode' => { 94 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 94 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 29 => 0x9, 91 => 0x3000 },
	'recordownerinstitutioncode' => { 94 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 314 => 0x217 },
	'redbalance' => { 166 => 0x270, 238 => 0x1017, 257 => 0x11, 284 => 0x1c },
	'redcurvelimits' => { 86 => 0x18a },
	'redcurvepoints' => { 86 => 0x160 },
	'redeyecorrection' => { 219 => 0x0 },
	'redeyeinfo' => { 376 => 'RedEyeInfo' },
	'redeyereduction' => { 150 => 0x41, 325 => 0x28 },
	'redhue' => { 376 => 'RedHue' },
	'redsaturation' => { 376 => 'RedSaturation' },
	'reductionmatrix1' => { 95 => 0xc625 },
	'reductionmatrix2' => { 95 => 0xc626 },
	'reelname' => { 95 => 0xc789 },
	'reference1' => { 384 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 384 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 95 => 0x214, 395 => 'ReferenceBlackWhite' },
	'referencedate' => { 103 => 0x2f },
	'referencenumber' => { 103 => 0x32 },
	'references' => { 126 => 'References' },
	'referenceservice' => { 103 => 0x2d },
	'regionappliedtodimensions' => { 141 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 141 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 141 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 141 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 141 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 141 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 141 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 141 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 141 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 141 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 141 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 141 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 389 => 'RegionConstraints' },
	'regiondescription' => { 141 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 141 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 141 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 141 => 'Regions' },
	'regioninfodateregionsvalid' => { 142 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 142 => 'RegionInfo' },
	'regioninforegions' => { 142 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 141 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 141 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 142 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 142 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 142 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 142 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 142 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 141 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 141 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 386 => 'RegistryId' },
	'registryitemid' => { 386 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 386 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 124 => 'data' },
	'relatedaudiofilename' => { 124 => '1Name' },
	'relatedaudiofiletype' => { 124 => '0Type' },
	'relatedimagefileformat' => { 95 => 0x1000 },
	'relatedimageheight' => { 95 => 0x1002 },
	'relatedimagewidth' => { 95 => 0x1001 },
	'relatedresourceid' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 95 => 0xa004, 380 => 'RelatedSoundFile' },
	'relatedvideofile' => { 138 => 'data' },
	'relatedvideofilename' => { 138 => '1Name' },
	'relatedvideofiletype' => { 138 => '0Type' },
	'relation' => { 377 => 'relation' },
	'relationshipaccordingto' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 94 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 399 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 399 => 'relativeTimestamp' },
	'relativetimestampscale' => { 399 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 399 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 222 => '17.8', 227 => '33.8', 228 => '17.6' },
	'releasedate' => { 103 => 0x1e, 399 => 'releaseDate' },
	'releasemode' => { 91 => 0x3001, 335 => 0xb049 },
	'releasemode2' => { 342 => 0x112c, 343 => [0x112c,0x8], 344 => [0x1108,0x8], 345 => [0x1184,0x8], 346 => [0x1160,0x8], 347 => [0x4,0x1018], 348 => [0x4,0x210], 350 => 0x10, 351 => 0x10, 352 => 0x9, 358 => 0x34 },
	'releasemode3' => { 342 => 0x1128, 343 => 0x1128, 344 => 0x1104, 345 => 0x1180, 346 => 0x115c, 347 => 0x1014, 348 => 0x20c },
	'releasesetting' => { 81 => 0x1016 },
	'releasetime' => { 103 => 0x23 },
	'remoteonduration' => { 223 => '3.4', 224 => '17.2', 225 => '18.2', 226 => '18.2', 228 => '18.2', 229 => '4.3', 231 => '19.2' },
	'renditionclass' => { 400 => 'RenditionClass' },
	'renditionof' => { 400 => 'RenditionOf' },
	'renditionofalternatepaths' => { 400 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 400 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 400 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 400 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 400 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 400 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 400 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 400 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 400 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 400 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 400 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 400 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 400 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 400 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 400 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 400 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 400 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 400 => 'RenditionParams' },
	'repeatingflashcount' => { 171 => 0xd, 172 => 0xe, 173 => 0xe, 227 => '17.2', 228 => '24.2', 229 => '9.2', 230 => '24.2', 231 => '25.2' },
	'repeatingflashcountbuilt-in' => { 203 => 0x4db },
	'repeatingflashcountexternal' => { 203 => 0x4c3 },
	'repeatingflashoutput' => { 227 => '17.1', 228 => '24.1', 229 => '9.1', 230 => '24.1', 231 => '25.1' },
	'repeatingflashoutputexternal' => { 203 => 0x4c0 },
	'repeatingflashrate' => { 171 => 0xc, 172 => 0xd, 173 => 0xd, 227 => '18.1', 228 => '25.1', 229 => '10.1', 230 => '25.1', 231 => '26.1' },
	'repeatingflashratebuilt-in' => { 203 => 0x4da },
	'repeatingflashrateexternal' => { 203 => 0x4c2 },
	'requires' => { 374 => 'requires' },
	'resampleparams' => { 399 => 'resampleParams' },
	'resampleparamsquality' => { 399 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 314 => 0x21e },
	'resolution' => { 131 => 'Resolution' },
	'resolutionmode' => { 315 => 0x4 },
	'resolutionunit' => { 95 => 0x128, 106 => 0x2, 395 => 'ResolutionUnit' },
	'resourceid' => { 94 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 94 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 94 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 68 => 0x612 },
	'restrictions' => { 392 => 'restrictions' },
	'retouchareafeather' => { 376 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 376 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 376 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 376 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 376 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 376 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 376 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 376 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 376 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 376 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 376 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 376 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 376 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 376 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 376 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 376 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 376 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 376 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 376 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 376 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 376 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 376 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 376 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 376 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 376 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 376 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 376 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 376 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 376 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 376 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 376 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 376 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 376 => 'RetouchAreas' },
	'retouchareaseed' => { 376 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 376 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 376 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 376 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 182 => 0x9e },
	'retouchinfo' => { 376 => 'RetouchInfo' },
	'reuse' => { 389 => 'Reuse' },
	'reuseallowed' => { 402 => 'ReuseAllowed' },
	'reuseprohibited' => { 392 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 226 => '5.2' },
	'reverseindicators' => { 222 => '12.1', 224 => '4.3', 225 => '5.2', 226 => '5.4', 227 => '33.5', 228 => '5.1', 231 => '6.2' },
	'reverseshutterspeedaperture' => { 226 => '5.3' },
	'revision' => { 378 => 'revision' },
	'rgbcurvelimits' => { 86 => 0x238 },
	'rgbcurvepoints' => { 86 => 0x20e },
	'richtextcomment' => { 383 => 'RichTextComment' },
	'ricohdate' => { 305 => 0x6 },
	'ricohimageheight' => { 305 => 0x2 },
	'ricohimagewidth' => { 305 => 0x0 },
	'rightascension' => { 134 => 'RightAscension' },
	'rights' => { 377 => 'rights' },
	'rightsagent' => { 390 => 'rightsAgent', 392 => 'rightsAgent' },
	'rightsowner' => { 392 => 'rightsOwner' },
	'rollangle' => { 253 => 0x90, 283 => 0x1 },
	'romoperationmode' => { 81 => 0x80d },
	'rotation' => { 26 => 0x17, 27 => 0x18, 80 => 0x3, 86 => 0x26e, 99 => 0x4, 134 => 'Rotation', 148 => [0x65,0x50], 149 => 0x46, 150 => 0x5a, 153 => 0x10, 202 => '590.1', 215 => 0x76a43207, 253 => 0x30, 265 => '17.2', 292 => 0xd8, 323 => 0x3f, 324 => 0x3f, 334 => 0x10 },
	'routedto' => { 382 => 'RoutedTo' },
	'routing' => { 297 => 'Routing' },
	'routingnotes' => { 382 => 'RoutingNotes' },
	'rowsperstrip' => { 95 => 0x116 },
	'rpp' => { 371 => 'rpp' },
	'safetyshift' => { 68 => 0x108 },
	'safetyshiftinavortv' => { 66 => 0x10, 67 => 0x10, 69 => 0xf, 70 => 0x10, 73 => 0x10 },
	'samplebits' => { 124 => 'SampleBits' },
	'samplerate' => { 124 => 'SampleRate' },
	'samplesperpixel' => { 95 => 0x115, 395 => 'SamplesPerPixel' },
	'samplestructure' => { 105 => 0x5a },
	'sanyoquality' => { 314 => 0x201 },
	'sanyothumbnail' => { 314 => 0x100 },
	'saturation' => { 8 => 0x6e, 10 => 0x76, 29 => 0xe, 40 => 0x1, 90 => 0xd, 91 => [0x3013,0x1f], 95 => [0xa409,0xfe55], 100 => 0x1003, 125 => 'Saturation', 147 => 0x1f, 148 => 0x32, 149 => 0x28, 150 => 0x1a, 155 => 0x1, 182 => [0x94,0xaa], 184 => 0x35, 253 => 0x40, 255 => 0x300d, 284 => 0x1f, 290 => 0xd, 302 => 0x27, 305 => 0x28, 306 => 0x1013, 315 => 0x10, 323 => 0x1e, 324 => 0x1b, 335 => 0x2005, 376 => 'Saturation', 380 => 'Saturation' },
	'saturationadj' => { 86 => 0x116, 214 => 0x1, 218 => 0x2e, 362 => 0x8016 },
	'saturationadjustmentaqua' => { 376 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 376 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 376 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 376 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 376 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 376 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 376 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 376 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 57 => 0x98 },
	'saturationfaithful' => { 17 => 0xfe, 56 => 0x68, 57 => 0x68 },
	'saturationlandscape' => { 17 => 0xfc, 56 => 0x38, 57 => 0x38 },
	'saturationmonochrome' => { 56 => 0x80, 57 => 0x80 },
	'saturationneutral' => { 17 => 0xfd, 56 => 0x50, 57 => 0x50 },
	'saturationportrait' => { 17 => 0xfb, 56 => 0x20, 57 => 0x20 },
	'saturationsetting' => { 241 => 0x1010, 325 => 0x11, 339 => 0x9 },
	'saturationstandard' => { 17 => 0xfa, 56 => 0x8, 57 => 0x8 },
	'saturationuserdef1' => { 17 => 0x100, 56 => 0x98, 57 => 0xb0 },
	'saturationuserdef2' => { 17 => 0x101, 56 => 0xb0, 57 => 0xc8 },
	'saturationuserdef3' => { 17 => 0x102, 56 => 0xc8, 57 => 0xe0 },
	'saveid' => { 400 => 'SaveID' },
	'scaletype' => { 399 => 'scaleType' },
	'scanimageenhancer' => { 187 => 0x60 },
	'scanningdirection' => { 105 => 0x64 },
	'scene' => { 385 => 'Scene', 399 => 'scene' },
	'scenearea' => { 236 => 0x211, 238 => 0x1031 },
	'sceneassist' => { 182 => 0x9c },
	'scenecapturetype' => { 95 => 0xa406, 380 => 'SceneCaptureType' },
	'scenedetect' => { 236 => 0x210, 238 => 0x1030 },
	'scenedetectdata' => { 236 => 0x212, 238 => 0x1033 },
	'scenemode' => { 113 => 0xfa02, 152 => 0x100, 182 => 0x8f, 233 => 0x509, 238 => 0x403, 253 => 0x8001, 259 => 0xf, 335 => 0xb023 },
	'scenemodeused' => { 115 => [0x6002,0xf002] },
	'sceneselect' => { 314 => 0x21f },
	'scenetype' => { 95 => 0xa301, 380 => 'SceneType' },
	'screentips' => { 222 => '12.7', 227 => '13.1', 228 => '4.4', 231 => '5.1' },
	'section' => { 390 => 'section' },
	'securityclassification' => { 95 => 0x9212 },
	'selectableafpoint' => { 68 => 0x509 },
	'selectafareaselectmode' => { 68 => 0x512 },
	'selftimer' => { 29 => 0x2, 253 => 0x2e, 314 => 0x214 },
	'selftimer2' => { 62 => 0x1d },
	'selftimerinterval' => { 228 => '19.2' },
	'selftimermode' => { 95 => 0x882b },
	'selftimershotcount' => { 224 => '18.2', 225 => '19.2', 226 => '19.2', 228 => '19.3', 231 => '20.2' },
	'selftimertime' => { 81 => 0x1806, 150 => 0x1f, 222 => '18.1', 223 => '3.3', 224 => '18.1', 225 => '19.1', 226 => '19.1', 227 => '7.2', 228 => '19.1', 229 => '3.3', 231 => '20.1' },
	'seminfo' => { 95 => 0x8546 },
	'sensingmethod' => { 95 => 0xa217, 380 => 'SensingMethod' },
	'sensitivityadjust' => { 284 => 0x40 },
	'sensitivitysteps' => { 265 => ['14.3','17.4'], 267 => 0x1 },
	'sensitivitytype' => { 95 => 0x8830, 381 => 'SensitivityType' },
	'sensorareas' => { 312 => 0xa010 },
	'sensorbitdepth' => { 255 => 0x312d },
	'sensorbluelevel' => { 60 => 0x5 },
	'sensorcalibration' => { 237 => 0x805 },
	'sensorcleaning' => { 74 => 0xd },
	'sensorfullheight' => { 108 => 0xf904 },
	'sensorfullwidth' => { 108 => 0xf903 },
	'sensorheight' => { 108 => 0xf901, 113 => 0xfa21, 154 => 0x8, 255 => 0x312c, 306 => 0x1602 },
	'sensorpixelsize' => { 182 => 0x9a },
	'sensorredlevel' => { 60 => 0x4 },
	'sensorsize' => { 125 => 'SensorSize', 284 => 0x35 },
	'sensortemperature' => { 236 => 0x1500, 238 => 0x1007, 315 => [0x39,0x55] },
	'sensorwidth' => { 108 => 0xf900, 113 => 0xfa20, 154 => 0xa, 255 => 0x312b, 306 => 0x1601 },
	'sequence' => { 302 => 0x7 },
	'sequencefilenumber' => { 343 => 0x4, 344 => 0x4, 345 => 0x4, 346 => 0x4, 350 => 0xc, 351 => 0xc, 352 => 0x1a },
	'sequenceimagenumber' => { 343 => 0x0, 344 => 0x0, 345 => 0x0, 346 => 0x0, 350 => 0x8, 351 => 0x8, 352 => 0x12, 358 => 0x24 },
	'sequencelength' => { 350 => 0x22, 351 => 0x1e, 352 => [0x16,0x1e] },
	'sequencenumber' => { 62 => 0x9, 91 => 0x301c, 100 => 0x1101, 111 => 0x1d, 203 => 0x51c, 253 => 0x2b, 325 => [0x10c,0x30c], 335 => 0xb04a },
	'sequenceshotinterval' => { 314 => 0x224 },
	'sequentialshot' => { 314 => 0x20e },
	'serialnumber' => { 51 => 0xc, 81 => 0x180b, 95 => [0xa431,0xfde9], 108 => 0xfa04, 110 => 0xfa00, 112 => 0xc354, 113 => 0xfa19, 122 => 0x0, 125 => 'SerialNumber', 182 => [0xa0,0x1d], 234 => 0x101, 238 => [0x404,0x101a], 249 => 0x303, 255 => 0x3103, 284 => 0x229, 302 => 0x15, 306 => 0x5, 315 => 0x2, 373 => 'SerialNumber', 381 => 'BodySerialNumber' },
	'serialnumberformat' => { 51 => 0x15, 81 => 0x183b },
	'seriesdatetime' => { 364 => 'SeriesDateTime' },
	'seriesdescription' => { 364 => 'SeriesDescription' },
	'seriesmodality' => { 364 => 'SeriesModality' },
	'seriesnumber' => { 364 => 'SeriesNumber' },
	'serviceidentifier' => { 104 => 0x1e },
	'setbuttoncrosskeysfunc' => { 71 => 0x0, 72 => 0x0 },
	'setbuttonwhenshooting' => { 66 => 0x1, 68 => 0x704, 74 => 0xc },
	'setfunctionwhenshooting' => { 69 => 0x0, 70 => 0x1, 73 => 0x1 },
	'shadingcompensation' => { 233 => 0x50c, 253 => 0x8a },
	'shadingcompensation2' => { 237 => 0x1012 },
	'shadow' => { 315 => 0xe },
	'shadowcorrection' => { 284 => 0x79 },
	'shadowprotection' => { 214 => 0x0 },
	'shadows' => { 95 => 0xfe52, 370 => 'Shadows', 376 => 'Shadows' },
	'shadows2012' => { 376 => 'Shadows2012' },
	'shadowscale' => { 95 => 0xc633 },
	'shadowtint' => { 376 => 'ShadowTint' },
	'shadowtone' => { 100 => 0x1040 },
	'shakereduction' => { 285 => 0x1, 286 => 0x1 },
	'sharpendetail' => { 376 => 'SharpenDetail' },
	'sharpenedgemasking' => { 376 => 'SharpenEdgeMasking' },
	'sharpening' => { 255 => 0x300b },
	'sharpeningadj' => { 218 => 0x2b },
	'sharpenradius' => { 376 => 'SharpenRadius' },
	'sharpness' => { 6 => [0x42,0x48], 8 => 0x72, 10 => 0x74, 29 => 0xf, 60 => 0x2, 90 => 0xb, 91 => [0x3011,0x21], 95 => [0xa40a,0xfe56], 100 => 0x1001, 111 => 0x6b, 120 => 0x37, 125 => 'Sharpness', 147 => 0x21, 148 => 0x30, 149 => 0x26, 150 => 0x18, 155 => 0x3, 182 => 0x6, 184 => 0x32, 238 => 0x100f, 253 => 0x41, 284 => 0x21, 290 => 0xb, 302 => 0x26, 305 => 0x22, 306 => [0x1003,0x1014], 315 => 0x11, 323 => 0x1c, 324 => 0x19, 335 => 0x2006, 358 => 0x52, 376 => 'Sharpness', 380 => 'Sharpness' },
	'sharpnessadj' => { 86 => 0x25a, 362 => 0x801a },
	'sharpnessauto' => { 57 => 0x94 },
	'sharpnessfactor' => { 238 => 0x102a },
	'sharpnessfaithful' => { 17 => 0xf5, 56 => 0x64, 57 => 0x64 },
	'sharpnessfrequency' => { 6 => [0x41,0x47], 60 => 0x3 },
	'sharpnesslandscape' => { 17 => 0xf3, 56 => 0x34, 57 => 0x34 },
	'sharpnessmonochrome' => { 17 => 0xf6, 56 => 0x7c, 57 => 0x7c },
	'sharpnessneutral' => { 17 => 0xf4, 56 => 0x4c, 57 => 0x4c },
	'sharpnessovershoot' => { 362 => 0x801b },
	'sharpnessportrait' => { 17 => 0xf2, 56 => 0x1c, 57 => 0x1c },
	'sharpnesssetting' => { 233 => 0x506, 241 => 0x1013, 325 => 0x12, 339 => 0xa },
	'sharpnessstandard' => { 17 => 0xf1, 56 => 0x4, 57 => 0x4 },
	'sharpnessthreshold' => { 362 => 0x801d },
	'sharpnessundershoot' => { 362 => 0x801c },
	'sharpnessuserdef1' => { 17 => 0xf7, 56 => 0x94, 57 => 0xac },
	'sharpnessuserdef2' => { 17 => 0xf8, 56 => 0xac, 57 => 0xc4 },
	'sharpnessuserdef3' => { 17 => 0xf9, 56 => 0xc4, 57 => 0xdc },
	'shootinginfodisplay' => { 222 => '13.2', 227 => '10.2', 228 => '4.1', 231 => '5.3' },
	'shootinginfomonitorofftime' => { 227 => '9.1', 228 => '21.2', 231 => '22.2' },
	'shootingmode' => { 125 => 'ShootingMode', 182 => 0x89, 253 => 0x1f },
	'shootingmodesetting' => { 223 => '5.1' },
	'shortdescription' => { 378 => 'shortdescription' },
	'shortdocumentid' => { 103 => 0xba },
	'shortownername' => { 17 => 0xac },
	'shortreleasetimelag' => { 68 => 0x80d },
	'shotdate' => { 399 => 'shotDate' },
	'shotday' => { 399 => 'shotDay' },
	'shotlocation' => { 399 => 'shotLocation' },
	'shotname' => { 399 => 'shotName' },
	'shotnumber' => { 399 => 'shotNumber' },
	'shotnumbersincepowerup' => { 338 => 0x44e, 350 => 0x1a, 351 => 0x16, 352 => 0xa },
	'shotnumbersincepowerup2' => { 325 => 0x200 },
	'shotsize' => { 399 => 'shotSize' },
	'shutter-aelock' => { 66 => 0x4, 68 => 0x701, 69 => 0x3, 70 => 0x4, 71 => 0x3, 72 => 0x3, 73 => 0x4, 74 => 0x2 },
	'shutteraelbutton' => { 67 => 0x4 },
	'shutterbuttonafonbutton' => { 68 => 0x701 },
	'shuttercount' => { 9 => 0x176, 46 => 0x1, 182 => 0xa7, 188 => [0x6a,0x157,0x24d], 189 => 0x286, 190 => 0x279, 191 => 0x284, 192 => 0x242, 193 => 0x280, 194 => 0x276, 195 => [0x27d,0x27f], 196 => 0x246, 197 => 0x2d6, 198 => 0x321, 199 => 0xbd8, 200 => 0x287, 201 => 0x320, 202 => 0x24a, 203 => 0x5fb, 204 => 0x2d5, 284 => 0x5d, 334 => 0x846, 337 => [0x125,0x14a] },
	'shuttercurtainsync' => { 66 => 0xf, 67 => 0xf, 68 => 0x305, 69 => 0xe, 70 => 0xf, 71 => 0x8, 72 => 0x8, 73 => 0xf, 74 => 0x8 },
	'shuttermode' => { 111 => 0x1b },
	'shutterreleasebuttonae-l' => { 222 => '17.7', 224 => '16.1', 225 => '17.1', 226 => '17.1', 227 => '7.1', 228 => '17.5', 231 => '18.2' },
	'shutterreleasemethod' => { 81 => 0x1010 },
	'shutterreleasenocfcard' => { 66 => 0x2, 67 => 0x2, 74 => 0xf },
	'shutterreleasetiming' => { 81 => 0x1011 },
	'shutterreleasewithoutlens' => { 68 => 0x711 },
	'shutterspeedrange' => { 68 => 0x10c },
	'shutterspeedsetting' => { 150 => 0x6, 323 => 0x2f, 324 => 0x28, 325 => 0x0 },
	'shutterspeedvalue' => { 77 => 0x1, 95 => 0x9201, 238 => 0x1000, 380 => 'ShutterSpeedValue' },
	'shuttertype' => { 253 => 0x9f },
	'sidecarforextension' => { 388 => 'SidecarForExtension' },
	'similarityindex' => { 103 => 0xe4 },
	'singleframebracketing' => { 150 => 0x21 },
	'slaveflashmeteringsegments' => { 284 => 0x20b },
	'slowshutter' => { 62 => 0x8 },
	'slowsync' => { 100 => 0x1030 },
	'smartrange' => { 312 => 0xa012 },
	'smileshutter' => { 325 => 0x31 },
	'smileshuttermode' => { 325 => 0x27 },
	'smoothness' => { 95 => 0xfe57, 376 => 'Smoothness' },
	'softskineffect' => { 335 => 0x200f },
	'software' => { 95 => 0x131, 126 => 'Software', 245 => 'Software', 315 => 0x18, 395 => 'Software' },
	'softwareversion' => { 314 => 0x207 },
	'sonydatetime' => { 341 => 0x6, 343 => 0x1b6, 344 => 0x210, 345 => 0x1fe, 346 => 0x22c },
	'sonydatetime2' => { 349 => 0x51 },
	'sonyexposuretime' => { 349 => 0x3a },
	'sonyexposuretime2' => { 358 => 0xe },
	'sonyfnumber' => { 349 => 0x3c, 358 => 0x14 },
	'sonyimageheight' => { 341 => 0x1a, 350 => 0x44, 351 => 0x3f, 352 => 0x47 },
	'sonyimagesize' => { 150 => 0x3b, 323 => 0x54, 324 => 0x54, 325 => 0x9 },
	'sonyimagewidth' => { 341 => 0x1c },
	'sonyiso' => { 343 => 0x1218, 344 => 0x11f4, 345 => 0x1270, 346 => [0x1254,0x1258,0x1280], 347 => 0x113c, 348 => 0x344, 358 => 0x4 },
	'sonymaxaperturevalue' => { 358 => 0x16 },
	'sonymodelid' => { 335 => 0xb001 },
	'sonyquality' => { 150 => 0x3c },
	'source' => { 103 => 0x73, 245 => 'Source', 377 => 'source', 378 => 'source', 388 => 'Source' },
	'sourcedirectoryindex' => { 271 => 0x0 },
	'sourcefileindex' => { 271 => 0x2 },
	'sourcephotoscount' => { 366 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 380 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 380 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 380 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 380 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 380 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 399 => 'speakerPlacement' },
	'specialeffectlevel' => { 91 => 0x3030 },
	'specialeffectmode' => { 91 => 0x2076 },
	'specialeffectsetting' => { 91 => 0x3031 },
	'specialinstructions' => { 103 => 0x28 },
	'specialmode' => { 238 => 0x200, 314 => 0x200 },
	'spectralsensitivity' => { 95 => 0x8824, 380 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 36 => [0x2b9,0x2d0,0x2d4], 38 => 0x1e4, 39 => [0x1fd,0x2dd] },
	'splittoningbalance' => { 376 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 376 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 376 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 376 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 376 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 147 => 0x2d },
	'spotfocuspointy' => { 147 => 0x2e },
	'spotmeteringmode' => { 29 => 0x27 },
	'spotmeterlinktoafpoint' => { 68 => 0x107 },
	'sractive' => { 265 => '17.1' },
	'srawquality' => { 29 => 0x2e },
	'srfocallength' => { 285 => 0x3 },
	'srhalfpresstime' => { 285 => 0x2 },
	'srresult' => { 285 => 0x0, 286 => 0x0 },
	'standardoutputhighlightpoint' => { 87 => 0x14 },
	'standardoutputsensitivity' => { 95 => 0x8831, 381 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 87 => 0x15 },
	'standardrawcolortone' => { 87 => 0xd },
	'standardrawcontrast' => { 87 => 0xf },
	'standardrawhighlight' => { 87 => 0x75 },
	'standardrawhighlightpoint' => { 87 => 0x12 },
	'standardrawlinear' => { 87 => 0x10 },
	'standardrawsaturation' => { 87 => 0xe },
	'standardrawshadow' => { 87 => 0x7e },
	'standardrawshadowpoint' => { 87 => 0x13 },
	'standardrawsharpness' => { 87 => 0x11 },
	'standardunsharpmaskfineness' => { 87 => 0x94 },
	'standardunsharpmaskstrength' => { 87 => 0x92 },
	'standardunsharpmaskthreshold' => { 87 => 0x96 },
	'standbytimer' => { 226 => '18.1' },
	'startingpage' => { 390 => 'startingPage' },
	'startmovieshooting' => { 68 => 0x70d },
	'starttimecode' => { 399 => 'startTimecode' },
	'starttimecodetimeformat' => { 399 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 399 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 399 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 130 => 'State', 253 => 0x6b, 388 => 'State' },
	'status' => { 365 => 'Status', 369 => 'Status' },
	'stitchingsoftware' => { 366 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 342 => 0x113e, 343 => 0x113e, 344 => 0x111a, 345 => 0x1196, 346 => 0x1172, 347 => 0x102a, 348 => 0x222, 358 => 0xa },
	'storagemethod' => { 154 => 0x12 },
	'straightenangle' => { 215 => 0x2fc08431 },
	'stretchmode' => { 399 => 'stretchMode' },
	'studydatetime' => { 364 => 'StudyDateTime' },
	'studydescription' => { 364 => 'StudyDescription' },
	'studyid' => { 364 => 'StudyID' },
	'studyphysician' => { 364 => 'StudyPhysician' },
	'sub-location' => { 103 => 0x5c },
	'subfiledata' => { 133 => 'data' },
	'subfiledirectory' => { 133 => '1Directory' },
	'subfilemimetype' => { 133 => '2MIME' },
	'subfilename' => { 133 => '1Name' },
	'subfileresource' => { 133 => 'rsrc' },
	'subfiletype' => { 95 => 0xfe, 133 => '0Type' },
	'subject' => { 242 => 'Subject', 297 => 'Subject', 377 => 'subject', 387 => 'Subject', 400 => 'subject' },
	'subjectarea' => { 95 => 0x9214, 380 => 'SubjectArea' },
	'subjectcode' => { 385 => 'SubjectCode' },
	'subjectdistance' => { 95 => 0x9206, 111 => 0x3e, 380 => 'SubjectDistance' },
	'subjectdistancerange' => { 95 => 0xa40c, 380 => 'SubjectDistanceRange' },
	'subjectlocation' => { 95 => 0xa214, 380 => 'SubjectLocation' },
	'subjectprogram' => { 147 => 0x22 },
	'subjectreference' => { 103 => 0xc },
	'sublabels4' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 384 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 384 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 95 => 0x9290 },
	'subsectimedigitized' => { 95 => 0x9292 },
	'subsectimeoriginal' => { 95 => 0x9291 },
	'subsection1' => { 390 => 'subsection1' },
	'subsection2' => { 390 => 'subsection2' },
	'subsection3' => { 390 => 'subsection3' },
	'subsection4' => { 390 => 'subsection4' },
	'subversionfilename' => { 384 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 384 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 384 => 'SubVersions' },
	'superimposeddisplay' => { 66 => 0xa, 68 => 0x510, 69 => 0x9, 70 => 0xa, 73 => 0xa, 74 => 0xe },
	'supermacro' => { 51 => 0x1a },
	'supplementalcategories' => { 103 => 0x14, 388 => 'SupplementalCategories' },
	'supplementaltype' => { 105 => 0x37 },
	'svisosetting' => { 265 => 0x14 },
	'sweeppanoramadirection' => { 253 => 0x93, 325 => 0x33 },
	'sweeppanoramafieldofview' => { 253 => 0x94 },
	'sweeppanoramasize' => { 325 => 0x32 },
	'switchtoregisteredafpoint' => { 67 => 0x12, 68 => 0x50a },
	'tagged' => { 292 => 0xdd, 293 => 'Tagged', 371 => 'tagged' },
	'tagslist' => { 379 => 'TagsList' },
	'tagstructure' => { 384 => 'TagStructure' },
	'takenumber' => { 399 => 'takeNumber' },
	'tapename' => { 399 => 'tapeName' },
	'targetaperture' => { 62 => 0x4 },
	'targetcompressionratio' => { 79 => 0x1 },
	'targetdistancesetting' => { 81 => 0x1807 },
	'targetexposuretime' => { 62 => 0x5 },
	'targetimagetype' => { 81 => 0x100a },
	'taxon' => { 94 => 'Taxon' },
	'taxonacceptednameusage' => { 94 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 94 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 94 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 94 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 94 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 94 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 94 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 94 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 94 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 94 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 94 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 94 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 94 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 94 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 94 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 94 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 94 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 94 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 94 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 94 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 94 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 94 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 94 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 94 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 94 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 94 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 94 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 94 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 94 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 94 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 94 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 94 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 94 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 390 => 'teaser' },
	'teleconverter' => { 152 => 0x105, 335 => 0x105 },
	'tempo' => { 399 => 'tempo' },
	'termsandconditionstext' => { 389 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 389 => 'TermsAndConditionsURL' },
	'testname' => { 96 => 'TestName' },
	'textencoding' => { 181 => 0x4 },
	'textlayername' => { 388 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 388 => 'TextLayers' },
	'textlayertext' => { 388 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 253 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 95 => 0x107 },
	'thumbnailfilename' => { 81 => 0x817 },
	'thumbnailformat' => { 397 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 113 => 0xfa55, 397 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 81 => 0x2008, 92 => 'ThumbnailImage', 98 => 0x3, 136 => 'data', 238 => 0x100, 397 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 136 => '1Name' },
	'thumbnailimagesize' => { 136 => 'ImageSize' },
	'thumbnailimagetype' => { 136 => '0Type' },
	'thumbnailimagevalidarea' => { 51 => 0x13 },
	'thumbnaillength' => { 95 => 0x202 },
	'thumbnailoffset' => { 95 => 0x201 },
	'thumbnails' => { 397 => 'Thumbnails' },
	'thumbnailwidth' => { 113 => 0xfa54, 397 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 390 => 'ticker' },
	'tilelength' => { 95 => 0x143 },
	'tilewidth' => { 95 => 0x142 },
	'time' => { 109 => 0x401, 284 => 0x7 },
	'timecodes' => { 95 => 0xc763 },
	'timecreated' => { 103 => 0x3c, 111 => 0x14, 120 => 0x10, 293 => 'TimeCreated' },
	'timeperiod' => { 390 => 'timePeriod' },
	'timerfunctionbutton' => { 223 => '5.2', 224 => '12.1', 225 => '13.1' },
	'timerlength' => { 68 => 0x80c },
	'timerrecording' => { 253 => 0x96 },
	'timescaleparams' => { 399 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 399 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 399 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 399 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 104 => 0x50 },
	'timesignature' => { 399 => 'timeSignature' },
	'timesincepoweron' => { 253 => 0x29 },
	'timestamp' => { 9 => 0x45e, 17 => 0x11c, 232 => 0x8, 245 => 'TimeStamp', 372 => 'Timestamp' },
	'timestamp1' => { 9 => 0x45a },
	'timezone' => { 63 => 0x1, 207 => 0x0 },
	'timezonecity' => { 63 => 0x2 },
	'timezonecode' => { 84 => 0x1 },
	'timezoneinfo' => { 84 => 0x2 },
	'timezoneoffset' => { 95 => 0x882a },
	'tint' => { 376 => 'Tint' },
	'title' => { 126 => 'Title', 242 => 'Title', 245 => 'Title', 253 => 0x65, 297 => 'Title', 377 => 'title', 387 => 'Title', 397 => 'Title' },
	'tonecomp' => { 182 => 0x81 },
	'tonecurve' => { 60 => 0x1, 284 => 0x402, 376 => 'ToneCurve' },
	'tonecurve1' => { 312 => 0xa040 },
	'tonecurve2' => { 312 => 0xa041 },
	'tonecurve3' => { 312 => 0xa042 },
	'tonecurve4' => { 312 => 0xa043 },
	'tonecurveactive' => { 86 => 0x110 },
	'tonecurveblue' => { 376 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 362 => 0x9003 },
	'tonecurvebluey' => { 362 => 0x9007 },
	'tonecurvebrightnessx' => { 362 => 0x9000 },
	'tonecurvebrightnessy' => { 362 => 0x9004 },
	'tonecurvefilename' => { 109 => 0x1391 },
	'tonecurvegreen' => { 376 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 362 => 0x9002 },
	'tonecurvegreeny' => { 362 => 0x9006 },
	'tonecurveinterpolation' => { 86 => 0x159 },
	'tonecurvemode' => { 86 => 0x113 },
	'tonecurvename' => { 376 => 'ToneCurveName' },
	'tonecurvename2012' => { 376 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 86 => 0x3c },
	'tonecurvepv2012' => { 376 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 376 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 376 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 376 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 376 => 'ToneCurveRed' },
	'tonecurveredx' => { 362 => 0x9001 },
	'tonecurveredy' => { 362 => 0x9005 },
	'tonecurves' => { 284 => 0x403 },
	'tonelevel' => { 233 => 0x52e },
	'toningeffect' => { 46 => 0xf, 182 => 0xb3, 184 => 0x38, 306 => 0x1015 },
	'toningeffectauto' => { 57 => 0xa4 },
	'toningeffectfaithful' => { 56 => 0x74, 57 => 0x74 },
	'toningeffectlandscape' => { 56 => 0x44, 57 => 0x44 },
	'toningeffectmonochrome' => { 17 => 0x108, 56 => 0x8c, 57 => 0x8c },
	'toningeffectneutral' => { 56 => 0x5c, 57 => 0x5c },
	'toningeffectportrait' => { 56 => 0x2c, 57 => 0x2c },
	'toningeffectstandard' => { 56 => 0x14, 57 => 0x14 },
	'toningeffectuserdef1' => { 56 => 0xa4, 57 => 0xbc },
	'toningeffectuserdef2' => { 56 => 0xbc, 57 => 0xd4 },
	'toningeffectuserdef3' => { 56 => 0xd4, 57 => 0xec },
	'toningsaturation' => { 184 => 0x39 },
	'totalzoom' => { 111 => 0x62 },
	'touchae' => { 253 => 0xab },
	'trackcreatedate' => { 301 => 0x1 },
	'trackmodifydate' => { 301 => 0x2 },
	'tracknumber' => { 399 => 'trackNumber' },
	'tracks' => { 399 => 'Tracks' },
	'tracksframerate' => { 399 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 399 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 399 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 399 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 399 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 399 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 399 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 399 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 399 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 399 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 399 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 399 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 399 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 399 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 399 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 399 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 399 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 133 => 'zmie' },
	'transferfunction' => { 95 => 0x12d, 395 => 'TransferFunction' },
	'transform' => { 253 => [0x8012,0x59] },
	'transmissionreference' => { 388 => 'TransmissionReference' },
	'trapped' => { 242 => 'Trapped', 387 => 'Trapped' },
	'trashbuttonfunction' => { 68 => 0x710 },
	'travelday' => { 253 => 0x36 },
	'triggermode' => { 302 => 0x6 },
	'tstop' => { 95 => 0xc772 },
	'ttl_da_adown' => { 272 => 0x5 },
	'ttl_da_aup' => { 272 => 0x4 },
	'ttl_da_bdown' => { 272 => 0x7 },
	'ttl_da_bup' => { 272 => 0x6 },
	'tungstenawb' => { 262 => 0x1 },
	'tvexposuretimesetting' => { 265 => 0x12 },
	'type' => { 377 => 'type', 394 => 'type' },
	'typestatus' => { 94 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 95 => 0xc614 },
	'uniquedocumentid' => { 103 => 0xbb },
	'uniqueobjectname' => { 104 => 0x64 },
	'unknownblock' => { 284 => 0x405 },
	'unknownblock1' => { 237 => 0x635 },
	'unknownblock2' => { 237 => 0x636 },
	'unknownblock3' => { 237 => 0x1103 },
	'unknownblock4' => { 237 => 0x1104 },
	'unknowncontrast' => { 87 => 0x45 },
	'unknownev' => { 109 => 0x1 },
	'unknownlinear' => { 87 => 0x46 },
	'unknownnumber' => { 81 => 0x180b },
	'unknownoutputhighlightpoint' => { 87 => 0x4a },
	'unknownoutputshadowpoint' => { 87 => 0x4b },
	'unknownrawhighlight' => { 87 => 0x7b },
	'unknownrawhighlightpoint' => { 87 => 0x48 },
	'unknownrawshadow' => { 87 => 0x84 },
	'unknownrawshadowpoint' => { 87 => 0x49 },
	'unknownsharpness' => { 87 => 0x47 },
	'unknowntemperature' => { 97 => 0x4 },
	'unsharp1color' => { 220 => 0x13 },
	'unsharp1halowidth' => { 220 => 0x19 },
	'unsharp1intensity' => { 220 => 0x17 },
	'unsharp1threshold' => { 220 => 0x1b },
	'unsharp2color' => { 220 => 0x2e },
	'unsharp2halowidth' => { 220 => 0x34 },
	'unsharp2intensity' => { 220 => 0x32 },
	'unsharp2threshold' => { 220 => 0x36 },
	'unsharp3color' => { 220 => 0x49 },
	'unsharp3halowidth' => { 220 => 0x4f },
	'unsharp3intensity' => { 220 => 0x4d },
	'unsharp3threshold' => { 220 => 0x51 },
	'unsharp4color' => { 220 => 0x64 },
	'unsharp4halowidth' => { 220 => 0x6a },
	'unsharp4intensity' => { 220 => 0x68 },
	'unsharp4threshold' => { 220 => 0x6c },
	'unsharpcount' => { 220 => 0x0 },
	'unsharpmask' => { 87 => 0x90, 215 => 0x76a43200 },
	'uprightcentermode' => { 376 => 'UprightCenterMode' },
	'uprightcenternormx' => { 376 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 376 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 376 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 376 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 376 => 'UprightFocalMode' },
	'uprightpreview' => { 376 => 'UprightPreview' },
	'uprighttransform_0' => { 376 => 'UprightTransform_0' },
	'uprighttransform_1' => { 376 => 'UprightTransform_1' },
	'uprighttransform_2' => { 376 => 'UprightTransform_2' },
	'uprighttransform_3' => { 376 => 'UprightTransform_3' },
	'uprighttransform_4' => { 376 => 'UprightTransform_4' },
	'uprighttransformcount' => { 376 => 'UprightTransformCount' },
	'uprightversion' => { 376 => 'UprightVersion' },
	'urgency' => { 103 => 0xa, 388 => 'Urgency' },
	'url' => { 126 => 'URL', 245 => 'URL', 295 => 0x40b, 390 => 'url' },
	'usablemeteringmodes' => { 68 => 0x10a },
	'usableshootingmodes' => { 68 => 0x109 },
	'usage' => { 391 => 'usage' },
	'usagefee' => { 392 => 'usageFee' },
	'usageterms' => { 403 => 'UsageTerms' },
	'useguidelines' => { 374 => 'useGuidelines' },
	'usepanoramaviewer' => { 366 => 'UsePanoramaViewer' },
	'usercomment' => { 81 => 0x805, 95 => 0x9286, 380 => 'UserComment' },
	'userdef1picturestyle' => { 17 => 0x10c, 56 => 0xd8, 57 => 0xf0 },
	'userdef2picturestyle' => { 17 => 0x10e, 56 => 0xda, 57 => 0xf2 },
	'userdef3picturestyle' => { 17 => 0x110, 56 => 0xdc, 57 => 0xf4 },
	'userfields' => { 369 => 'UserFields' },
	'userlabel' => { 302 => 0x2b },
	'userprofile' => { 249 => 0x302, 255 => 0x3038 },
	'usmlenselectronicmf' => { 67 => 0x7, 68 => 0x501 },
	'utmeasting' => { 137 => 'Easting' },
	'utmmapdatum' => { 137 => 'Datum' },
	'utmnorthing' => { 137 => 'Northing' },
	'utmzone' => { 137 => 'Zone' },
	'uv-irfiltercorrection' => { 249 => 0x325 },
	'validbits' => { 237 => 0x611, 238 => 0x102c },
	'validpixeldepth' => { 241 => 0x611 },
	'variousmodes' => { 111 => 0x26 },
	'variousmodes2' => { 111 => 0x3a },
	'variprogram' => { 182 => 0xab },
	'version' => { 100 => 0x0, 297 => 'Version', 376 => 'Version' },
	'versioncreatedate' => { 362 => 0xd100 },
	'versionid' => { 400 => 'VersionID' },
	'versionidentifier' => { 390 => 'versionIdentifier' },
	'versionmodifydate' => { 362 => 0xd101 },
	'versions' => { 400 => 'Versions' },
	'versionscomments' => { 400 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 400 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 400 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 400 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 400 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 400 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 400 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 400 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 400 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 400 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 400 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 222 => '3.2' },
	'vfdisplayillumination' => { 68 => 0x510 },
	'vibrance' => { 370 => 'Vibrance', 376 => 'Vibrance' },
	'vibrationreduction' => { 188 => [0x75,0x82,0x1ae], 196 => '586.1', 202 => '590.2', 206 => 0x4 },
	'videoalphamode' => { 399 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 399 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 399 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 399 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 54 => 0x74 },
	'videocolorspace' => { 399 => 'videoColorSpace' },
	'videocompressor' => { 399 => 'videoCompressor' },
	'videofieldorder' => { 399 => 'videoFieldOrder' },
	'videoframerate' => { 399 => 'videoFrameRate' },
	'videoframesize' => { 399 => 'videoFrameSize' },
	'videoframesizeh' => { 399 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 399 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 399 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 399 => 'videoModDate' },
	'videopixelaspectratio' => { 399 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 399 => 'videoPixelDepth' },
	'videoquality' => { 91 => 0x4003 },
	'viewfinderdisplay' => { 222 => '12.4' },
	'viewfinderwarning' => { 222 => '13.4', 228 => '3.5', 229 => '6.2', 231 => '4.4' },
	'viewfinderwarnings' => { 68 => 0x40a },
	'viewinfoduringexposure' => { 68 => 0x407 },
	'viewingmode' => { 325 => 0x2f, 339 => 0x18 },
	'viewingmode2' => { 325 => [0x85,0x285] },
	'vignetteamount' => { 376 => 'VignetteAmount' },
	'vignettecontrol' => { 182 => 0x2a, 215 => 0x76a43205 },
	'vignettecontrolintensity' => { 215 => 0xac6bd5c0 },
	'vignettemidpoint' => { 376 => 'VignetteMidpoint' },
	'vignetting' => { 306 => 0x1011 },
	'vignettingcorrection' => { 274 => 0x2, 335 => 0x2011 },
	'voicememo' => { 314 => 0x216 },
	'volume' => { 390 => 'volume' },
	'vr_0x66' => { 188 => 0x66 },
	'vrdoffset' => { 51 => 0xd0 },
	'vrmode' => { 206 => 0x6 },
	'wb_bluelevel3500k' => { 153 => 0x19a },
	'wb_bluelevel6500k' => { 153 => 0x18a },
	'wb_bluelevelcustom' => { 153 => 0x18e },
	'wb_bluelevelscloudy' => { 153 => 0x106 },
	'wb_bluelevelsdaylight' => { 153 => 0xea },
	'wb_bluelevelsflash' => { 153 => 0x122 },
	'wb_bluelevelsfluorescent' => { 153 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 153 => 0x254 },
	'wb_bluelevelsshade' => { 153 => 0x176 },
	'wb_bluelevelstungsten' => { 153 => 0xce },
	'wb_gbrglevels' => { 153 => 0xae, 156 => 0x4 },
	'wb_glevel' => { 237 => 0x11f },
	'wb_glevel3000k' => { 237 => 0x113 },
	'wb_glevel3300k' => { 237 => 0x114 },
	'wb_glevel3600k' => { 237 => 0x115 },
	'wb_glevel3900k' => { 237 => 0x116 },
	'wb_glevel4000k' => { 237 => 0x117 },
	'wb_glevel4300k' => { 237 => 0x118 },
	'wb_glevel4500k' => { 237 => 0x119 },
	'wb_glevel4800k' => { 237 => 0x11a },
	'wb_glevel5300k' => { 237 => 0x11b },
	'wb_glevel6000k' => { 237 => 0x11c },
	'wb_glevel6600k' => { 237 => 0x11d },
	'wb_glevel7500k' => { 237 => 0x11e },
	'wb_grbglevels' => { 165 => 0x0 },
	'wb_rbgglevels' => { 162 => 0x0 },
	'wb_rblevels' => { 182 => 0xc, 237 => 0x100 },
	'wb_rblevels3000k' => { 237 => 0x102 },
	'wb_rblevels3300k' => { 237 => 0x103 },
	'wb_rblevels3500k' => { 153 => 0x430 },
	'wb_rblevels3600k' => { 237 => 0x104 },
	'wb_rblevels3900k' => { 237 => 0x105 },
	'wb_rblevels4000k' => { 237 => 0x106 },
	'wb_rblevels4300k' => { 237 => 0x107 },
	'wb_rblevels4500k' => { 237 => 0x108 },
	'wb_rblevels4800k' => { 237 => 0x109 },
	'wb_rblevels5300k' => { 237 => 0x10a },
	'wb_rblevels6000k' => { 237 => 0x10b },
	'wb_rblevels6500k' => { 153 => 0x420 },
	'wb_rblevels6600k' => { 237 => 0x10c },
	'wb_rblevels7500k' => { 237 => 0x10d },
	'wb_rblevelsauto' => { 241 => 0x110 },
	'wb_rblevelscloudy' => { 153 => 0x3f0, 155 => 0x10, 241 => 0x121 },
	'wb_rblevelscoolwhitef' => { 153 => 0x308, 155 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 241 => 0x132 },
	'wb_rblevelscustom' => { 153 => 0x424 },
	'wb_rblevelscwb1' => { 237 => 0x10e },
	'wb_rblevelscwb2' => { 237 => 0x10f },
	'wb_rblevelscwb3' => { 237 => 0x110 },
	'wb_rblevelscwb4' => { 237 => 0x111 },
	'wb_rblevelsdaylight' => { 153 => [0x3ec,0x528], 155 => 0xc },
	'wb_rblevelsdaylightf' => { 155 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 241 => 0x130 },
	'wb_rblevelsdaywhitef' => { 155 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 241 => 0x131 },
	'wb_rblevelseveningsunlight' => { 241 => 0x124 },
	'wb_rblevelsfineweather' => { 241 => 0x122 },
	'wb_rblevelsflash' => { 153 => [0x3f4,0x304], 155 => 0x18 },
	'wb_rblevelsshade' => { 153 => 0x418, 155 => 0x20, 241 => 0x120 },
	'wb_rblevelstungsten' => { 153 => 0x3e8, 155 => 0x8, 241 => 0x123 },
	'wb_rblevelsunknown' => { 155 => 0x1c },
	'wb_rblevelsused' => { 241 => 0x100 },
	'wb_rblevelswhitef' => { 155 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 241 => 0x133 },
	'wb_redlevel3500k' => { 153 => 0x198 },
	'wb_redlevel6500k' => { 153 => 0x188 },
	'wb_redlevelcustom' => { 153 => 0x18c },
	'wb_redlevelscloudy' => { 153 => 0xf8 },
	'wb_redlevelsdaylight' => { 153 => 0xdc },
	'wb_redlevelsflash' => { 153 => 0x114 },
	'wb_redlevelsfluorescent' => { 153 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 153 => 0x1be },
	'wb_redlevelsshade' => { 153 => 0x168 },
	'wb_redlevelstungsten' => { 153 => 0xc0 },
	'wb_rgbglevels' => { 164 => 0x0 },
	'wb_rgblevels' => { 153 => [0x546,0x96], 250 => 0xd, 251 => 0x413, 255 => 0x3036, 342 => 0x117c, 343 => 0x1180, 344 => 0x115c, 345 => 0x11d8, 346 => 0x11b4, 347 => 0x106c, 348 => 0x264 },
	'wb_rggbblacklevels' => { 30 => 0x25 },
	'wb_rggblevels' => { 156 => 0x4, 163 => 0x0 },
	'wb_rggblevelsasshot' => { 32 => 0x0, 33 => 0x19, 34 => 0x22, 35 => 0x3f, 38 => 0x3f, 39 => 0x3f },
	'wb_rggblevelsauto' => { 30 => 0x1, 32 => 0x5, 33 => 0x1e, 34 => 0x18, 35 => 0x44, 38 => 0x44, 39 => 0x44, 312 => 0xa022 },
	'wb_rggblevelsblack' => { 312 => 0xa028 },
	'wb_rggblevelscloudy' => { 30 => 0xd, 32 => 0x1e, 33 => 0x2d, 34 => 0x31, 35 => 0x58, 38 => 0x71, 39 => 0x8a, 284 => 0x20f, 291 => 0x14 },
	'wb_rggblevelscustom' => { 30 => 0x1d, 35 => 0x80 },
	'wb_rggblevelscustom1' => { 33 => 0x41 },
	'wb_rggblevelscustom2' => { 33 => 0x46 },
	'wb_rggblevelsdaylight' => { 30 => 0x5, 32 => 0x14, 33 => 0x23, 34 => 0x27, 35 => 0x4e, 38 => 0x67, 39 => 0x80, 284 => 0x20d, 291 => 0x2 },
	'wb_rggblevelsflash' => { 30 => 0x19, 32 => 0x32, 33 => 0x3c, 34 => 0x45, 35 => 0x6c, 38 => 0x85, 39 => 0x9e, 284 => 0x214, 291 => 0x41 },
	'wb_rggblevelsfluorescent' => { 30 => 0x15, 32 => 0x28, 33 => 0x37, 34 => 0x3b, 35 => 0x62, 38 => 0x7b, 39 => 0x94 },
	'wb_rggblevelsfluorescentd' => { 284 => 0x211, 291 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 291 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 284 => 0x212, 291 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 284 => 0x213, 291 => 0x38 },
	'wb_rggblevelsilluminator1' => { 312 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 312 => 0xa024 },
	'wb_rggblevelskelvin' => { 30 => 0x21, 32 => 0x2d, 34 => 0x40, 35 => 0x67, 38 => 0x80, 39 => 0x99 },
	'wb_rggblevelsmeasured' => { 32 => 0xa, 35 => 0x49, 38 => 0x49, 39 => 0x49 },
	'wb_rggblevelspc1' => { 34 => 0x90, 35 => 0x71 },
	'wb_rggblevelspc2' => { 34 => 0x95, 35 => 0x76 },
	'wb_rggblevelspc3' => { 34 => 0x9a, 35 => 0x7b },
	'wb_rggblevelsshade' => { 30 => 0x9, 32 => 0x19, 33 => 0x28, 34 => 0x2c, 35 => 0x53, 38 => 0x6c, 39 => 0x85, 284 => 0x20e, 291 => 0xb },
	'wb_rggblevelstungsten' => { 30 => 0x11, 32 => 0x23, 33 => 0x32, 34 => 0x36, 35 => 0x5d, 38 => 0x76, 39 => 0x8f, 284 => 0x210, 291 => 0x1d },
	'wb_rggblevelsuncorrected' => { 312 => 0xa021 },
	'wb_rggblevelsunknown' => { 32 => 0xf, 34 => 0x1d, 38 => 0x4e, 39 => 0x4e, 291 => 0x53 },
	'wb_rggblevelsunknown10' => { 32 => 0x5f, 34 => 0x72, 38 => 0x9e, 39 => 0x7b },
	'wb_rggblevelsunknown11' => { 32 => 0x64, 34 => 0x77, 38 => 0xa3, 39 => 0xa3 },
	'wb_rggblevelsunknown12' => { 32 => 0x69, 34 => 0x7c, 38 => 0xa8, 39 => 0xa8 },
	'wb_rggblevelsunknown13' => { 32 => 0x6e, 34 => 0x81, 38 => 0xad, 39 => 0xad },
	'wb_rggblevelsunknown14' => { 34 => 0x86, 38 => 0xb2, 39 => 0xb2 },
	'wb_rggblevelsunknown15' => { 34 => 0x8b, 38 => 0xb7, 39 => 0xb7 },
	'wb_rggblevelsunknown16' => { 34 => 0x9f, 39 => 0xbc },
	'wb_rggblevelsunknown17' => { 39 => 0xc1 },
	'wb_rggblevelsunknown18' => { 39 => 0xc6 },
	'wb_rggblevelsunknown19' => { 39 => 0xcb },
	'wb_rggblevelsunknown2' => { 32 => 0x37, 34 => 0x4a, 38 => 0x53, 39 => 0x53 },
	'wb_rggblevelsunknown20' => { 39 => 0xd0 },
	'wb_rggblevelsunknown3' => { 32 => 0x3c, 34 => 0x4f, 38 => 0x58, 39 => 0x58 },
	'wb_rggblevelsunknown4' => { 32 => 0x41, 34 => 0x54, 38 => 0x5d, 39 => 0x5d },
	'wb_rggblevelsunknown5' => { 32 => 0x46, 34 => 0x59, 38 => 0x62, 39 => 0x62 },
	'wb_rggblevelsunknown6' => { 32 => 0x4b, 34 => 0x5e, 38 => 0x8a, 39 => 0x67 },
	'wb_rggblevelsunknown7' => { 32 => 0x50, 34 => 0x63, 38 => 0x8f, 39 => 0x6c },
	'wb_rggblevelsunknown8' => { 32 => 0x55, 34 => 0x68, 38 => 0x94, 39 => 0x71 },
	'wb_rggblevelsunknown9' => { 32 => 0x5a, 34 => 0x6d, 38 => 0x99, 39 => 0x76 },
	'wb_rggblevelsuserselected' => { 291 => 0x5c },
	'wbadjbluebalance' => { 221 => 0x8 },
	'wbadjcolortemp' => { 86 => 0x1a },
	'wbadjlighting' => { 221 => 0x14 },
	'wbadjmode' => { 221 => 0x10 },
	'wbadjredbalance' => { 221 => 0x0 },
	'wbadjrggblevels' => { 86 => 0x6 },
	'wbadjtemperature' => { 221 => 0x18 },
	'wbadjtint' => { 221 => 0x25 },
	'wbbluelevel' => { 249 => 0x324, 253 => 0x8006, 257 => 0x26 },
	'wbbracketmode' => { 46 => 0x9 },
	'wbbracketshotnumber' => { 153 => 0x2b, 306 => 0x101a },
	'wbbracketvalueab' => { 46 => 0xc },
	'wbbracketvaluegm' => { 46 => 0xd },
	'wbfinetuneactive' => { 86 => 0x24 },
	'wbfinetunesaturation' => { 86 => 0x28 },
	'wbfinetunetone' => { 86 => 0x2c },
	'wbgreenlevel' => { 249 => 0x323, 253 => 0x8005, 257 => 0x25 },
	'wbmediaimagesizesetting' => { 68 => 0x708 },
	'wbmode' => { 155 => 0x4, 238 => 0x1015 },
	'wbredlevel' => { 249 => 0x322, 253 => 0x8004, 257 => 0x24 },
	'wbscale' => { 156 => 0x0 },
	'wbshiftab' => { 60 => 0xc, 253 => 0x46, 266 => 0x10 },
	'wbshiftab_gm' => { 335 => 0x2014 },
	'wbshiftgm' => { 60 => 0xd, 253 => 0x47, 266 => 0x11 },
	'webstatement' => { 403 => 'WebStatement' },
	'whitebalance' => { 5 => 0x6f, 6 => [0x44,0x4a], 7 => 0xbc, 8 => 0x36, 9 => 0x5e, 10 => 0x36, 11 => 0x78, 12 => 0x6f, 13 => 0x6f, 14 => 0x73, 15 => 0x6f, 16 => 0x78, 17 => 0x54, 18 => 0x6f, 19 => 0xbc, 20 => 0x7b, 22 => 0xbc, 23 => 0xc2, 25 => 0x77, 60 => 0x8, 62 => 0x7, 90 => 0x7, 91 => [0x19,0x2012], 95 => [0xa403,0xfe4e], 100 => 0x1002, 109 => 0x3fc, 110 => 0xfa0d, 111 => 0x40, 147 => 0x3, 148 => 0xe, 149 => 0x4, 150 => 0xb, 152 => 0x115, 182 => 0x5, 205 => 0x7, 249 => 0x304, 253 => 0x3, 255 => 0x3033, 284 => 0x19, 290 => 0x7, 305 => 0x26, 306 => 0x1003, 315 => [0x3c,0x7,0x58], 335 => [0x115,0xb054], 376 => 'WhiteBalance', 380 => 'WhiteBalance' },
	'whitebalance2' => { 233 => 0x500 },
	'whitebalanceadj' => { 86 => 0x18, 215 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 262 => 0x0 },
	'whitebalancebias' => { 91 => 0x2011, 238 => 0x304, 253 => 0x23 },
	'whitebalanceblue' => { 60 => 0x7 },
	'whitebalancebracket' => { 233 => 0x502, 238 => 0x303 },
	'whitebalancebracketing' => { 150 => 0x22, 153 => 0x2c, 334 => 0x2c },
	'whitebalancecomp' => { 241 => 0x1001 },
	'whitebalancefinetune' => { 100 => 0x100a, 150 => 0x38, 152 => 0x112, 182 => 0xb, 306 => 0x1004, 323 => 0x6, 335 => 0x112 },
	'whitebalancemode' => { 284 => 0x1a },
	'whitebalancered' => { 60 => 0x6 },
	'whitebalanceset' => { 265 => 0xa },
	'whitebalancesetting' => { 150 => 0x23, 325 => 0x16, 339 => 0xd },
	'whitebalancetemperature' => { 233 => 0x501 },
	'whiteboard' => { 238 => 0x301 },
	'whitelevel' => { 95 => 0xc61d },
	'whitepoint' => { 95 => 0x13e, 284 => 0x201, 395 => 'WhitePoint' },
	'whites2012' => { 376 => 'Whites2012' },
	'wideadapter' => { 306 => 0x1017 },
	'widefocuszone' => { 147 => 0x2f },
	'widerange' => { 314 => 0x20f },
	'wordcount' => { 390 => 'wordCount' },
	'workcolorspace' => { 86 => 0x270 },
	'worktodo' => { 382 => 'WorkToDo' },
	'worldtimelocation' => { 253 => 0x3a, 284 => 0x22, 289 => '0.1' },
	'writer-editor' => { 103 => 0x7a },
	'x3filllight' => { 315 => 0x12 },
	'xml' => { 107 => 'xml ' },
	'xmp' => { 85 => 0xffff00f6, 96 => 'XMP' },
	'xmptoolkit' => { 396 => 'xmptk' },
	'xpauthor' => { 95 => 0x9c9d },
	'xpcomment' => { 95 => 0x9c9c },
	'xpkeywords' => { 95 => 0x9c9e },
	'xposition' => { 95 => 0x11e },
	'xpsubject' => { 95 => 0x9c9f },
	'xptitle' => { 95 => 0x9c9b },
	'xresolution' => { 95 => 0x11a, 106 => 0x3, 296 => 0x0, 395 => 'XResolution' },
	'xyresolution' => { 99 => 0x3 },
	'ycbcrcoefficients' => { 95 => 0x211, 395 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 95 => 0x213, 395 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 95 => 0x212, 395 => 'YCbCrSubSampling' },
	'yearcreated' => { 111 => 0x10, 120 => 0xc },
	'yposition' => { 95 => 0x11f },
	'yresolution' => { 95 => 0x11b, 106 => 0x5, 296 => 0x4, 395 => 'YResolution' },
	'zonematching' => { 152 => 0x10a, 155 => [0x3a,0x4a], 335 => 0xb024 },
	'zonematchingmode' => { 150 => 0x14 },
	'zonematchingon' => { 149 => 0x75 },
	'zonematchingvalue' => { 323 => 0x1f },
	'zoomedpreviewlength' => { 238 => 0xf05 },
	'zoomedpreviewsize' => { 238 => 0xf06 },
	'zoomedpreviewstart' => { 238 => 0xf04 },
	'zoomsourcewidth' => { 29 => 0x24 },
	'zoomstepcount' => { 236 => 0x300, 238 => 0x100d },
	'zoomtargetwidth' => { 29 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chapternum' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'platform' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profession' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencetemperature' => 1,
	'referencevirtual' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensorserialnumber' => 1,
	'sensortemperature2' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimage' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsdaylight' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2014, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
