# -*- coding: utf-8 -*-
#
# ccwatcher (http://ccwatcher.sourceforge.net/)
# Copyright (C) 2009-2013 Xaver Wurzenberger <xaverxn at users.sourceforge.net>
#
# This program is free software; you can redistribute and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

"""ccw_messages.py
"""


version = "1.3.1"

list_plot_mode = ["Gnuplot autoscale","Customized scaling","Highest point zeroed [Hartree]","[kJ/mole] scale","Highest point zeroed [kJ/mole]","First point zeroed [kJ/mole]","Lowest-points scale [kJ/mole]", "More zoom [kJ/mole]", "Ultra zoom [kJ/mole]", "Recent points zoom [kJ/mole]", "Last eight points [kJ/mole]"]
#                                        0                                1                                      2                                        3                                         4    	                                     5                                               6                                        7                             8                              9                                    10
list_plot_mode_qwt = ["Auto [Hartree]", "Highest point zeroed [Hartree]","Auto [kJ/mole]","Highest point zeroed [kJ/mole]","First point zeroed [kJ/mole]"]

list_multi_mode = ["0: No multifile handling", "1: Parse the last one & Plot several lines", "2: Parse the last one & Plot one joined line", "3: Parse all & Plot one joined line"]

list_verbosity_str = ["Very high (even 'Debug' messages)", "High ('Info' and above)",  "Medium ('Warning' and above)", "Low ('Error' and above)", "Lowest (Only 'Critical' messages"]
#list_verbosity = [logging.DEBUG,logging.INFO,logging.WARNING,logging.ERROR,logging.CRITICAL]
list_verbosity = [10,20,30,40,50] #if we use just the numbers we don't have to import logging - hope they don't change sometime

str_syntax_message = "\nCCWatcher Syntax:\tccwatcher [-s <scalemode>] [-v <verbosity_level>] [-m <multifile mode>] [-o] [-g] logfile\
                                            \n\n\twhere <scalemode> is a number between 0 and 10,\
                                            \n\t<verbosity_level> is a number between 4 ('Even debug messages') and 0 ('only critical errors')\
                                            \n\tand <multifile mode> is a number between 0 and 2.\
                                            \n\tThe -g switch enables the GUI, -o the only-single-run mode.\n" #-f the 'force gaussian' mode, 
str_h_for_help_message = "(Type 'ccwatcher -h' for help)"



str_thisisccw_pt1 = "This is ccwatcher "+version+". Copyright (C) 2009-2013 Xaver Wurzenberger.\nThis program is free software (GPL v2 or later); see license.txt for more information."
str_thisisccw_pt2 = "If you find bugs, please report them to the ccwatcher bug tracker on sourceforge. You can also find forums there. Thanks for reporting - or any kind of feedback!"
str_minihelp = "Use -g for GUI, -h for help.\n"

dict_hardcodedsettings = dict( #Remember to update settingshandler(eval) if adding or removing an item here
                        configversion = version, 
                        list_keywords_gaussian = ["termination","SCF Done","Low frequencies","Number of steps exceeded","Full point group","Converged?","The SCF is confused.","Gaussian 09:","Gaussian 03:","Gaussian 98:","Rerun with SCF=IntRep.","Warning:","found in this molecule","Atomic number out of range","Stationary point","run aborted","run terminated","NtrErr Called from FileIO.","Error on Z-matrix","Step number  ","Route card not found","galloc:","Convergence criterion not met","QPErr"],
                        list_keywords_orca = ["Invalid assignment","Total Energy", "Converged", "Program Version", "WARNING", "===>", "ORCA TERMINATED", "ORCA finished", "Error:", "SCF CONVERGED AFTER", "SCAN STEP","OPTIMIZATION RUN DONE","Geometry Optimization Run", "Displacing", "Number of atoms","ORCA NUMERICAL FREQUENCIES","imaginary mode","ABORTING THE RUN","ERROR","NOT CONVERGED","O   R   C   A"], #orca is NOT written in capitals because the settingsfile saves it in small letters
                        list_keywords_turbomole = ["a t b a n d b t a","e g r a d","e s c f","d s c f","R E L A X","R I C C 2","a o f o r c e","r d g r a d", "g r a d", "S T A T P T", "r i d f t","e n t h a l p y", "I n i t i o", "M o l e c u l a r","SCF energy", "symmetry group", "normally", "satisfied", "data group", "actual -r", "CONVERGENCE INFORMATION"], #bsseenergy,eigerf missing; continue from haga
                        list_keywords_molpro = ["Variable memory released","SYSTEM MOLPRO", "LABEL", "Point group", "!RHF", "!UHF", "!RKS", "MP2", "!MP2", "MP3", "MP4"], #SYSTEM MOLPRO needs 3 extra lines, LABEL+1
                        list_keywords_gamess_us = ["GAMESS TERMINATED", "EQUILIBRIUM GEOMETRY", "ENERGY IS", "LOCATE STATIONARY POINT", "THE GEOMETRY SEARCH", "POINT GROUP IS", "GAMESS VERSION"],
                        list_keywords_nwchem = ["symmetry detected","(NWChem)", "energy =", "Optimization converged", "Total times", "failed"],
                        list_keywords_jaguar = ["Jaguar version", "Molecular Point Group", "SCF energy", "completed"],
                        list_keywords_firefly = ["ERROR:","WARNING","FIREFLY TERMINATED","LOCATED","FINAL ENERGY","*Firefly"],
                        list_keywords_adf = ["Geometry Convergence Tests","Amsterdam Density Functional","NORMAL TERMINATION", "Geometry CONVERGED","Criterion    Conv."], 
                        list_keywords_adf2012 = ["LINEAR TRANSIT point"," ADF ","NORMAL TERMINATION", "GEOMETRY CONVERGED", "energy change", "current energy", "has finished","WARNING:","ERROR:"], 
                        use_gui = False,
                        num_max_file_age_minutes = 120,
#                        num_perc_plot_ysurplus = 0.15, # not equal to xsurplus #I don't think it makes a lot of sense to make this user-adjustable
                        num_verbosity = 1, 
                        str_avogadro_path = '', 
                        str_gnuplot_path = '',
                        num_multifile_opt = 0, 
                        str_plot_system = 'qwt',
                        no_guess_mode = False, 
                        str_lastpath = '', 
                        no_zero_convergence = True)

