/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.g1;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class G1HeapRegionTable
extends VMObject {
    private static AddressField baseField;
    private static CIntegerField lengthField;
    private static AddressField biasedBaseField;
    private static CIntegerField biasField;
    private static CIntegerField shiftByField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("G1HeapRegionTable");
        baseField = type.getAddressField("_base");
        lengthField = type.getCIntegerField("_length");
        biasedBaseField = type.getAddressField("_biased_base");
        biasField = type.getCIntegerField("_bias");
        shiftByField = type.getCIntegerField("_shift_by");
    }

    private HeapRegion at(long index) {
        Address arrayAddr = baseField.getValue(this.addr);
        long offset = index * VM.getVM().getAddressSize();
        Address regionAddr = arrayAddr.getAddressAt(offset);
        return (HeapRegion)VMObjectFactory.newObject(HeapRegion.class, regionAddr);
    }

    public long length() {
        return lengthField.getValue(this.addr);
    }

    public long bias() {
        return biasField.getValue(this.addr);
    }

    public long shiftBy() {
        return shiftByField.getValue(this.addr);
    }

    public Iterator<HeapRegion> heapRegionIterator(long committedLength) {
        return new HeapRegionIterator(committedLength);
    }

    public G1HeapRegionTable(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                G1HeapRegionTable.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    private class HeapRegionIterator
    implements Iterator<HeapRegion> {
        private long index = 0L;
        private long length;

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public HeapRegion next() {
            return G1HeapRegionTable.this.at(this.index++);
        }

        @Override
        public void remove() {
        }

        HeapRegionIterator(long committedLength) {
            this.length = committedLength;
        }
    }
}

