/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.tree;

import de.uib.configed.Globals;
import de.uib.utilities.tree.SimpleIconNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SimpleIconNodeRenderer
extends DefaultTreeCellRenderer {
    public static int labelWidth = 300;
    public static int labelHeight = 22;
    protected Font emphasized;
    protected Font standard;
    public static Dimension preferred = new Dimension(labelWidth, labelHeight);

    private Font deriveFont0(Font font) {
        HashMap hashMap = new HashMap();
        return font.deriveFont(hashMap);
    }

    private Font deriveFont1(Font font) {
        HashMap hashMap = new HashMap();
        return font.deriveFont(hashMap);
    }

    public SimpleIconNodeRenderer() {
        this.setOpaque(true);
        this.standard = Globals.defaultFontBig;
        this.emphasized = Globals.defaultFontStandardBold;
        this.setFont(this.standard);
        this.setForeground(Globals.lightBlack);
        this.setTextSelectionColor(Globals.lightBlack);
        this.setBackground(Color.white);
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setPreferredSize(preferred);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof SimpleIconNode) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.setText(string);
            this.setToolTipText(((SimpleIconNode)object).getToolTipText());
            SimpleIconNode simpleIconNode = (SimpleIconNode)object;
            boolean bl5 = jTree.isEnabled();
            this.setEnabled(bl5);
            simpleIconNode.setEnabled(bl5);
            if (n == 0) {
                this.setFont(this.emphasized);
            } else {
                this.setFont(this.standard);
            }
            if (bl && n != 0) {
                this.setBackground(Globals.backLightBlue);
            } else {
                this.setBackground(Color.white);
            }
            if (bl3) {
                this.setIcon(simpleIconNode.getLeafIcon());
            } else if (bl2) {
                this.setIcon(simpleIconNode.getOpenIcon());
            } else {
                this.setIcon(simpleIconNode.getClosedIcon());
            }
            if (!bl) {
                this.setIcon(simpleIconNode.getNonSelectedIcon());
            }
            this.setComponentOrientation(jTree.getComponentOrientation());
            return this;
        }
        return this;
    }
}

