/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table.provider;

import de.uib.utilities.logging.logging;
import de.uib.utilities.table.provider.TableProvider;
import de.uib.utilities.table.provider.TableSource;
import java.util.TreeSet;
import java.util.Vector;

public class DefaultTableProvider
implements TableProvider {
    protected TableSource source;
    protected Vector<String> columnNames;
    protected Vector<String> classNames;
    protected Vector<Vector<Object>> rows;
    protected Vector<Vector<Object>> rowsCopy;

    public DefaultTableProvider(TableSource tableSource) {
        this.source = tableSource;
    }

    @Override
    public void setTableSource(TableSource tableSource) {
        this.source = tableSource;
    }

    @Override
    public Vector<String> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.source.retrieveColumnNames();
        }
        return this.columnNames;
    }

    @Override
    public Vector<String> getClassNames() {
        if (this.classNames == null) {
            this.classNames = this.source.retrieveClassNames();
        }
        return this.classNames;
    }

    @Override
    public Vector<Vector<Object>> getRows() {
        if (this.rowsCopy == null) {
            this.resetRows();
        }
        return this.rowsCopy;
    }

    protected void resetRows() {
        if (this.rowsCopy != null) {
            this.rowsCopy.clear();
        } else {
            this.rowsCopy = new Vector();
        }
        if (this.rows == null) {
            this.rows = this.source.retrieveRows();
        }
        if (this.rows == null) {
            logging.info(" no data rows retrieved ");
            return;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            Vector vector = (Vector)this.rows.get(i).clone();
            this.rowsCopy.add(vector);
        }
    }

    @Override
    public void setWorkingCopyAsNewOriginalRows() {
        if (this.rows != null && this.rowsCopy != null) {
            this.rows.clear();
            for (int i = 0; i < this.rowsCopy.size(); ++i) {
                this.rows.add(this.rowsCopy.get(i));
            }
        }
        this.resetRows();
    }

    @Override
    public void requestReturnToOriginal() {
        this.rowsCopy = null;
    }

    @Override
    public void requestReloadRows() {
        this.rows = null;
        this.rowsCopy = null;
        this.source.requestReload();
    }

    @Override
    public void structureChanged() {
        this.source.structureChanged();
        this.classNames = null;
        this.columnNames = null;
    }

    @Override
    public Vector<String> getOrderedColumn(int n, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.rowsCopy.size(); ++i) {
            String string = (String)this.rowsCopy.get(i).get(n);
            if (!bl && (string == null || string.equals(""))) continue;
            treeSet.add((String)this.rowsCopy.get(i).get(n));
        }
        Vector<String> vector = new Vector<String>(treeSet);
        return vector;
    }
}

