/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities;

import de.uib.utilities.logging.logging;

public class ExtendedInteger {
    static final String infiniteImport = "infinite";
    static final String sINFINITE = "INFINITE";
    static final String displayInfinite = "\u221e";
    public static final ExtendedInteger INFINITE = new ExtendedInteger("INFINITE");
    public static final ExtendedInteger ZERO = new ExtendedInteger(0);
    private Integer number;
    private String value;

    private ExtendedInteger(Integer n, String string) {
        this.number = n;
        this.value = string;
    }

    public ExtendedInteger(int n) {
        this.number = new Integer(n);
        this.value = "" + n;
    }

    public ExtendedInteger(ExtendedInteger extendedInteger) {
        this.value = extendedInteger.getString();
        this.number = extendedInteger.getNumber();
    }

    public ExtendedInteger(String string) {
        this.number = null;
        this.value = null;
        if (string.equals(sINFINITE) || string.equals(infiniteImport) || string.equals(displayInfinite)) {
            this.value = sINFINITE;
        } else {
            try {
                this.number = Integer.decode(string);
                this.value = string;
            }
            catch (Exception exception) {
                if (string.equals(sINFINITE) || string.toLowerCase().equals(infiniteImport) || string.equals(displayInfinite)) {
                    this.value = sINFINITE;
                }
                logging.error("possible values are numbers  or \"infinite\" resp. \"\u221e\"");
            }
        }
    }

    public Integer getNumber() {
        return this.number;
    }

    public String getString() {
        return this.value;
    }

    public String getDisplay() {
        if (this.value.equals(sINFINITE)) {
            return displayInfinite;
        }
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtendedInteger)) {
            return false;
        }
        ExtendedInteger extendedInteger = (ExtendedInteger)object;
        return extendedInteger.getString().equals(this.getString());
    }

    public ExtendedInteger add(ExtendedInteger extendedInteger) {
        ExtendedInteger extendedInteger2;
        if (extendedInteger.equals(INFINITE) || this.equals(INFINITE)) {
            extendedInteger2 = new ExtendedInteger(INFINITE);
        } else {
            int n = this.getNumber() + extendedInteger.getNumber();
            extendedInteger2 = new ExtendedInteger(new Integer(n), "" + n);
        }
        return extendedInteger2;
    }

    public ExtendedInteger add(Integer n) {
        ExtendedInteger extendedInteger;
        if (this.equals(INFINITE)) {
            extendedInteger = new ExtendedInteger(INFINITE);
        } else {
            int n2 = this.getNumber() + n;
            extendedInteger = new ExtendedInteger(n2, "" + n2);
        }
        return extendedInteger;
    }

    public String toString() {
        return this.getString();
    }
}

