/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel.productstate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class LastAction {
    public static final String KEY = "lastAction";
    public static final int CONFLICT = -4;
    public static final int INVALID = -2;
    public static final int NOT_AVAILABLE = -6;
    public static final int NONE = 0;
    public static final int SETUP = 1;
    public static final int UPDATE = 3;
    public static final int UNINSTALL = 5;
    public static final int ALWAYS = 7;
    public static final int ONCE = 8;
    public static final int CUSTOM = 11;
    private static Map<Integer, String> state2label;
    private static Map<String, Integer> label2state;
    private static Map<String, String> label2displayLabel;
    private static Map<String, String> displayLabel2label;
    private static Vector<Integer> states;
    private static Vector<String> labels;
    private static String[] choiceLabels;
    private int state = -2;

    private static void checkCollections() {
        if (states != null) {
            return;
        }
        states = new Vector();
        states.add(-4);
        states.add(-2);
        states.add(-6);
        states.add(0);
        states.add(1);
        states.add(3);
        states.add(5);
        states.add(7);
        states.add(8);
        states.add(11);
        labels = new Vector();
        labels.add("mixed");
        labels.add("");
        labels.add("not_available");
        labels.add("none");
        labels.add("setup");
        labels.add("update");
        labels.add("uninstall");
        labels.add("always");
        labels.add("once");
        labels.add("custom");
        state2label = new HashMap<Integer, String>();
        state2label.put(-4, "mixed");
        state2label.put(-2, "");
        state2label.put(-6, "not_available");
        state2label.put(0, "none");
        state2label.put(1, "setup");
        state2label.put(3, "update");
        state2label.put(5, "uninstall");
        state2label.put(7, "always");
        state2label.put(8, "once");
        state2label.put(11, "custom");
        label2state = new HashMap<String, Integer>();
        label2state.put("mixed", -4);
        label2state.put("", -2);
        label2state.put("not_available", -6);
        label2state.put("none", 0);
        label2state.put("setup", 1);
        label2state.put("update", 3);
        label2state.put("uninstall", 5);
        label2state.put("always", 7);
        label2state.put("once", 8);
        label2state.put("custom", 11);
        label2displayLabel = new HashMap<String, String>();
        label2displayLabel.put("mixed", "mixed");
        label2displayLabel.put("", "");
        label2displayLabel.put("not_available", "not_available");
        label2displayLabel.put("none", "none");
        label2displayLabel.put("setup", "setup");
        label2displayLabel.put("update", "update");
        label2displayLabel.put("uninstall", "uninstall");
        label2displayLabel.put("always", "always");
        label2displayLabel.put("once", "once");
        label2displayLabel.put("custom", "custom");
        displayLabel2label = new HashMap<String, String>();
        displayLabel2label.put("mixed", "mixed");
        displayLabel2label.put("", "");
        displayLabel2label.put("not_available", "not_available");
        displayLabel2label.put("none", "none");
        displayLabel2label.put("setup", "setup");
        displayLabel2label.put("update", "update");
        displayLabel2label.put("uninstall", "uninstall");
        displayLabel2label.put("always", "always");
        displayLabel2label.put("once", "once");
        displayLabel2label.put("custom", "custom");
        choiceLabels = new String[]{label2displayLabel.get("none")};
    }

    public static Map<String, String> getLabel2DisplayLabel() {
        LastAction.checkCollections();
        return label2displayLabel;
    }

    public static boolean existsState(int n) {
        LastAction.checkCollections();
        return states.contains(n);
    }

    public static boolean existsLabel(String string) {
        LastAction.checkCollections();
        return labels.contains(string);
    }

    public static String getLabel(int n) {
        LastAction.checkCollections();
        if (!LastAction.existsState(n)) {
            return null;
        }
        return state2label.get(n);
    }

    public static Vector<String> getLabels() {
        LastAction.checkCollections();
        return labels;
    }

    public static Integer getVal(String string) {
        LastAction.checkCollections();
        if (string == null || string.equals("")) {
            return 0;
        }
        if (!LastAction.existsLabel(string)) {
            return null;
        }
        return label2state.get(string);
    }

    public static String getDisplayLabel(int n) {
        LastAction.checkCollections();
        return label2displayLabel.get(LastAction.getLabel(n));
    }

    public int getVal() {
        return this.state;
    }

    public String getString() {
        return LastAction.getLabel(this.state);
    }

    public String toString() {
        return LastAction.getLabel(this.state);
    }

    public static LastAction produceFromDisplayLabel(String string) {
        return LastAction.produceFromLabel(displayLabel2label.get(string));
    }

    public static LastAction produceFromLabel(String string) {
        LastAction.checkCollections();
        if (string == null) {
            return new LastAction(-6);
        }
        if (!labels.contains(string)) {
            return new LastAction(-2);
        }
        return new LastAction(LastAction.getVal(string));
    }

    public LastAction() {
    }

    public LastAction(int n) {
        this.state = LastAction.existsState(n) ? n : -6;
    }

    public static void main(String[] stringArray) {
        System.out.println(" test LastAction.java");
        LastAction.checkCollections();
        Iterator<Integer> iterator = states.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            int n2 = iterator.next();
        }
    }
}

