/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel.productstate;

import de.uib.configed.Globals;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class ActionRequest {
    public static final String KEY = "actionRequest";
    public static final int CONFLICT = -4;
    public static final int INVALID = -2;
    public static final int NOT_AVAILABLE = -6;
    public static final int NONE = 0;
    public static final int SETUP = 1;
    public static final int UPDATE = 3;
    public static final int UNINSTALL = 5;
    public static final int ALWAYS = 7;
    public static final int ONCE = 8;
    public static final int CUSTOM = 11;
    public static final int LAST = 11;
    public static final Color NONEcolor = Globals.INVISIBLE;
    public static final Color SETUPcolor = Globals.actionRed;
    public static final Color UPDATEcolor = Globals.actionRed;
    public static final Color UNINSTALLcolor = Color.blue;
    public static final Color ALWAYScolor = Globals.actionRed;
    public static final Color ONCEcolor = Globals.actionRed;
    public static final Color CUSTOMcolor = Globals.actionRed;
    public static final Color LASTcolor = Color.black;
    private static Map<Integer, String> state2label;
    private static Map<String, Integer> label2state;
    private static Map<String, String> label2displayLabel;
    private static Map<String, String> displayLabel2label;
    private static Map<String, Color> label2textColor;
    private static Map<String, Integer> serviceValue2state;
    private static Vector<Integer> states;
    private static Vector<Integer> possibleRequests;
    private static Vector<String> labels;
    private static String[] choiceLabels;
    private static Vector<String> serviceValues;
    private static Vector<String> scriptKeys;
    private static Map<String, String> scriptKey2label;
    private int state = -2;

    private static void checkCollections() {
        if (states != null) {
            return;
        }
        states = new Vector();
        states.add(-4);
        states.add(-2);
        states.add(-6);
        states.add(0);
        states.add(1);
        states.add(3);
        states.add(5);
        states.add(7);
        states.add(8);
        states.add(11);
        possibleRequests = new Vector();
        possibleRequests.add(1);
        possibleRequests.add(3);
        possibleRequests.add(5);
        possibleRequests.add(7);
        possibleRequests.add(8);
        possibleRequests.add(11);
        labels = new Vector();
        labels.add("mixed");
        labels.add("");
        labels.add("not_available");
        labels.add("none");
        labels.add("setup");
        labels.add("update");
        labels.add("uninstall");
        labels.add("always");
        labels.add("once");
        labels.add("custom");
        state2label = new HashMap<Integer, String>();
        state2label.put(-4, "mixed");
        state2label.put(-2, "");
        state2label.put(-6, "not_available");
        state2label.put(0, "none");
        state2label.put(1, "setup");
        state2label.put(3, "update");
        state2label.put(5, "uninstall");
        state2label.put(7, "always");
        state2label.put(8, "once");
        state2label.put(11, "custom");
        serviceValue2state = new LinkedHashMap<String, Integer>();
        serviceValue2state.put("setup", 1);
        serviceValue2state.put("update", 3);
        serviceValue2state.put("uninstall", 5);
        serviceValue2state.put("always", 7);
        serviceValue2state.put("once", 8);
        serviceValue2state.put("custom", 11);
        serviceValues = new Vector<String>(serviceValue2state.keySet());
        scriptKeys = new Vector();
        scriptKey2label = new HashMap<String, String>();
        for (String string : serviceValues) {
            scriptKeys.add(string + "Script");
            scriptKey2label.put(string + "Script", state2label.get(serviceValue2state.get(string)));
        }
        label2state = new HashMap<String, Integer>();
        label2state.put("mixed", -4);
        label2state.put("", -2);
        label2state.put("not_available", -6);
        label2state.put("none", 0);
        label2state.put("setup", 1);
        label2state.put("update", 3);
        label2state.put("uninstall", 5);
        label2state.put("always", 7);
        label2state.put("once", 8);
        label2state.put("custom", 11);
        label2displayLabel = new HashMap<String, String>();
        label2displayLabel.put("mixed", "mixed");
        label2displayLabel.put("", "");
        label2displayLabel.put("not_available", "not_available");
        label2displayLabel.put("none", "none");
        label2displayLabel.put("setup", "setup");
        label2displayLabel.put("update", "update");
        label2displayLabel.put("uninstall", "uninstall");
        label2displayLabel.put("always", "always");
        label2displayLabel.put("once", "once");
        label2displayLabel.put("custom", "custom");
        displayLabel2label = new HashMap<String, String>();
        displayLabel2label.put("mixed", "mixed");
        displayLabel2label.put("", "");
        displayLabel2label.put("not_available", "not_available");
        displayLabel2label.put("none", "none");
        displayLabel2label.put("setup", "setup");
        displayLabel2label.put("update", "update");
        displayLabel2label.put("uninstall", "uninstall");
        displayLabel2label.put("always", "always");
        displayLabel2label.put("once", "once");
        displayLabel2label.put("custom", "custom");
        choiceLabels = new String[]{label2displayLabel.get("none"), label2displayLabel.get("setup"), label2displayLabel.get("update"), label2displayLabel.get("uninstall"), label2displayLabel.get("always"), label2displayLabel.get("once"), label2displayLabel.get("custom")};
        label2textColor = new HashMap<String, Color>();
        label2textColor.put("none", NONEcolor);
        label2textColor.put("setup", SETUPcolor);
        label2textColor.put("update", UPDATEcolor);
        label2textColor.put("uninstall", UNINSTALLcolor);
        label2textColor.put("always", ALWAYScolor);
        label2textColor.put("once", ONCEcolor);
        label2textColor.put("custom", CUSTOMcolor);
    }

    public static Vector<Integer> getPossibleRequests() {
        ActionRequest.checkCollections();
        return possibleRequests;
    }

    public static Vector<String> getServiceValues() {
        ActionRequest.checkCollections();
        return serviceValues;
    }

    public static Vector<String> getScriptKeys() {
        ActionRequest.checkCollections();
        return scriptKeys;
    }

    public static Map<String, String> getScriptKey2Label() {
        ActionRequest.checkCollections();
        return scriptKey2label;
    }

    public static Map<String, String> getLabel2DisplayLabel() {
        ActionRequest.checkCollections();
        return label2displayLabel;
    }

    public static Map<Integer, String> getState2Label() {
        ActionRequest.checkCollections();
        return state2label;
    }

    public static Map<String, Color> getLabel2TextColor() {
        ActionRequest.checkCollections();
        return label2textColor;
    }

    public static boolean existsState(int n) {
        ActionRequest.checkCollections();
        return states.contains(n);
    }

    public static boolean existsLabel(String string) {
        ActionRequest.checkCollections();
        return labels.contains(string);
    }

    public static String getLabel(int n) {
        ActionRequest.checkCollections();
        if (!ActionRequest.existsState(n)) {
            return null;
        }
        return state2label.get(n);
    }

    public static Vector<String> getLabels() {
        ActionRequest.checkCollections();
        return labels;
    }

    public static Integer getVal(String string) {
        ActionRequest.checkCollections();
        if (string == null || string.equals("")) {
            return 0;
        }
        if (!ActionRequest.existsLabel(string)) {
            return null;
        }
        return label2state.get(string);
    }

    public static String getDisplayLabel(int n) {
        ActionRequest.checkCollections();
        return label2displayLabel.get(ActionRequest.getLabel(n));
    }

    public static String getStaticString(String string) {
        Integer n = label2state.get(string);
        if (n == null) {
            return null;
        }
        return state2label.get(n);
    }

    public static String[] getDisplayLabelsForChoice() {
        ActionRequest.checkCollections();
        return choiceLabels;
    }

    public int getVal() {
        return this.state;
    }

    public String getString() {
        return ActionRequest.getLabel(this.state);
    }

    public String toString() {
        return ActionRequest.getLabel(this.state);
    }

    public static ActionRequest produceFromDisplayLabel(String string) {
        return ActionRequest.produceFromLabel(displayLabel2label.get(string));
    }

    public static ActionRequest produceFromLabel(String string) {
        ActionRequest.checkCollections();
        if (string == null) {
            return new ActionRequest(0);
        }
        if (!labels.contains(string)) {
            return new ActionRequest(-2);
        }
        return new ActionRequest(ActionRequest.getVal(string));
    }

    public ActionRequest() {
    }

    public ActionRequest(int n) {
        this.state = ActionRequest.existsState(n) ? n : -6;
    }

    public static void main(String[] stringArray) {
        System.out.println(" test ActionRequest.java");
        ActionRequest.checkCollections();
        Iterator<Integer> iterator = states.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            int n2 = iterator.next();
        }
    }
}

