/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand;

import de.uib.opsicommand.ConnectionState;
import de.uib.opsicommand.Executioner;
import de.uib.opsicommand.JSONObjectX;
import de.uib.opsicommand.JSONReMapper;
import de.uib.opsicommand.OpsiMethodCall;
import de.uib.utilities.logging.logging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JSONExecutioner
extends Executioner {
    protected ConnectionState conStat;

    @Override
    public abstract JSONObject retrieveJSONObject(OpsiMethodCall var1);

    public JSONObject retrieveJSONResult(OpsiMethodCall opsiMethodCall) {
        JSONObject jSONObject = this.retrieveJSONObject(opsiMethodCall);
        if (this.checkResponse(jSONObject)) {
            return jSONObject.optJSONObject("result");
        }
        return null;
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.conStat;
    }

    @Override
    public void setConnectionState(ConnectionState connectionState) {
        this.conStat = connectionState;
    }

    public boolean checkResponse(JSONObject jSONObject) {
        return JSONReMapper.checkResponse(jSONObject);
    }

    @Override
    public JSONObject jsonMap(Map map) {
        return new JSONObject(map);
    }

    @Override
    public Object getValueFromJSONObject(Object object, String string) {
        Object object2 = null;
        try {
            object2 = ((JSONObject)object).get(string);
        }
        catch (JSONException jSONException) {
            logging.error("json error on getting value,  " + jSONException.toString());
        }
        catch (Exception exception) {
            logging.error("error on getting value,  " + exception.toString());
        }
        return object2;
    }

    @Override
    public Object jsonArray(List list) {
        JSONArray jSONArray = null;
        jSONArray = list == null ? new JSONArray() : new JSONArray(list);
        logging.debug(this, "jsonArray " + jSONArray);
        return jSONArray;
    }

    @Override
    public boolean doCall(OpsiMethodCall opsiMethodCall) {
        JSONObject jSONObject = this.retrieveJSONObject(opsiMethodCall);
        return this.checkResponse(jSONObject);
    }

    @Override
    public List<List<String>> getListOfStringLists(OpsiMethodCall opsiMethodCall) {
        return JSONReMapper.getListOfStringLists(this.retrieveJSONObject(opsiMethodCall));
    }

    @Override
    public List getListResult(OpsiMethodCall opsiMethodCall) {
        return JSONReMapper.getListResult(this.retrieveJSONObject(opsiMethodCall));
    }

    @Override
    public List<String> getStringListResult(OpsiMethodCall opsiMethodCall) {
        return JSONReMapper.getStringListResult(this.retrieveJSONObject(opsiMethodCall));
    }

    @Override
    public Map getMapResult(OpsiMethodCall opsiMethodCall) {
        return JSONReMapper.getMapResult(this.retrieveJSONObject(opsiMethodCall));
    }

    public Map getMapOfLists(JSONObject jSONObject) {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        try {
            if (jSONObject != null) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashMap.put(string, JSONReMapper.getJsonList(jSONObject, string));
                }
            }
        }
        catch (Exception exception) {
            logging.error("Exception on getting Map " + exception.toString());
        }
        return hashMap;
    }

    private Map getMapOfLists(OpsiMethodCall opsiMethodCall, boolean bl) {
        Map<String, List> map = new HashMap();
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = this.retrieveJSONObject(opsiMethodCall);
            if (bl && !JSONReMapper.checkForNotValidOpsiMethod(jSONObject2)) {
                map = this.getMapOfLists(opsiMethodCall.activateExtendedRpcPath(), false);
            } else if (this.checkResponse(jSONObject2) && (jSONObject = jSONObject2.optJSONObject("result")) != null) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    map.put(string, JSONReMapper.getJsonList(jSONObject, string));
                }
            }
        }
        catch (Exception exception) {
            logging.error(this, "Exception on getting Map " + exception.toString());
        }
        return map;
    }

    @Override
    public Map getMapOfLists(OpsiMethodCall opsiMethodCall) {
        return this.getMapOfLists(opsiMethodCall, true);
    }

    @Override
    public Map getMapOfMaps(OpsiMethodCall opsiMethodCall) {
        HashMap hashMap = new HashMap();
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = this.retrieveJSONObject(opsiMethodCall);
            if (this.checkResponse(jSONObject2) && (jSONObject = jSONObject2.optJSONObject("result")) != null) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    JSONObject jSONObject3 = (JSONObject)jSONObject.get(string);
                    if (jSONObject3 != null) {
                        Iterator iterator2 = jSONObject3.keys();
                        while (iterator2.hasNext()) {
                            String string2 = (String)iterator2.next();
                            if (jSONObject3.isNull(string2)) continue;
                            hashMap2.put(string2, jSONObject3.get(string2));
                        }
                    }
                    hashMap.put(string, hashMap2);
                }
            }
        }
        catch (Exception exception) {
            logging.error(this, "Exception on getting Map " + exception.toString());
        }
        return hashMap;
    }

    @Override
    public Map<String, Object> getMap_Object(OpsiMethodCall opsiMethodCall) {
        return JSONReMapper.getMap_Object(this.retrieveJSONObject(opsiMethodCall));
    }

    @Override
    public Map<String, Map<String, Object>> getMap2_Object(OpsiMethodCall opsiMethodCall) {
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        HashMap hashMap2 = new HashMap();
        try {
            JSONObject jSONObject = this.retrieveJSONObject(opsiMethodCall);
            if (this.checkResponse(jSONObject)) {
                JSONObject jSONObject2 = jSONObject.optJSONObject("result");
                JSONObjectX jSONObjectX = new JSONObjectX(jSONObject2);
                if (!jSONObjectX.isMap()) {
                    logging.error(this, "map expected " + jSONObjectX);
                } else {
                    logging.debug(this, "map retrieved ");
                    Map<String, Object> map = jSONObjectX.getMap();
                    for (String string : map.keySet()) {
                        JSONObjectX jSONObjectX2 = new JSONObjectX((JSONObject)map.get(string));
                        if (!jSONObjectX2.isMap()) {
                            logging.error(this, "map expected in level 2 " + jSONObjectX2);
                            hashMap = hashMap2;
                            continue;
                        }
                        hashMap.put(string, jSONObjectX2.getMap());
                    }
                }
            }
        }
        catch (Exception exception) {
            logging.error("this, getMap2_Object : " + exception.toString());
        }
        return hashMap;
    }

    @Override
    public Map<String, Map<String, Map<String, Object>>> getMap3_Object(OpsiMethodCall opsiMethodCall) {
        return JSONReMapper.getMap3_Object(this.retrieveJSONObject(opsiMethodCall));
    }

    @Override
    public Map<String, Map<String, String>> getStringMappedObjectsByKey(OpsiMethodCall opsiMethodCall, String string) {
        return this.getStringMappedObjectsByKey(opsiMethodCall, string, null, null);
    }

    @Override
    public Map<String, Map<String, String>> getStringMappedObjectsByKey(OpsiMethodCall opsiMethodCall, String string, String[] stringArray, String[] stringArray2) {
        return this.getStringMappedObjectsByKey(opsiMethodCall, string, stringArray, stringArray2, null);
    }

    @Override
    public Map<String, Map<String, String>> getStringMappedObjectsByKey(OpsiMethodCall opsiMethodCall, String string, String[] stringArray, String[] stringArray2, Map<String, String> map) {
        TreeMap<String, Map<String, String>> treeMap = new TreeMap<String, Map<String, String>>();
        List list = null;
        try {
            JSONObject jSONObject = this.retrieveJSONObject(opsiMethodCall);
            if (this.checkResponse(jSONObject)) {
                list = JSONReMapper.getJsonList(jSONObject, "result");
            }
        }
        catch (Exception exception) {
            logging.error(this, "Exception on getting list for key \"result\" " + exception.toString());
        }
        if (list != null) {
            try {
                for (JSONObject jSONObject : list) {
                    String string2;
                    String string3;
                    String string4 = null;
                    if (jSONObject.get(string) == null) {
                        logging.error(this, "Missing key " + string + " in output list for " + opsiMethodCall);
                        continue;
                    }
                    string4 = jSONObject.get(string).toString();
                    if (map != null && map.get(string4) != null) {
                        string4 = map.get(string4);
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (stringArray == null) {
                        Iterator iterator = jSONObject.keys();
                        while (iterator.hasNext()) {
                            string3 = iterator.next().toString();
                            string2 = jSONObject.get(string3).toString();
                            hashMap.put(string3, string2);
                        }
                    } else if (stringArray2 == null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            string3 = stringArray[i];
                            string2 = jSONObject.get(string3).toString();
                            if (map != null && map.get(string2) != null) {
                                string2 = map.get(string2);
                            }
                            hashMap.put(string3, string2);
                        }
                    } else {
                        if (stringArray2.length != stringArray.length) {
                            logging.warning(this, "getStringMappedObjectsByKey targetVars not assignable");
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            string3 = stringArray[i];
                            string2 = jSONObject.get(string3).toString();
                            if (i >= stringArray2.length) continue;
                            string3 = stringArray2[i];
                            if (map != null && map.get(string2) != null) {
                                string2 = map.get(string2);
                            }
                            hashMap.put(string3, string2);
                        }
                    }
                    treeMap.put(string4, hashMap);
                }
            }
            catch (Exception exception) {
                logging.error(this, "Exception on building string maps  " + exception.toString());
            }
        }
        return treeMap;
    }

    @Override
    public Map getMapOfListsOfMaps(OpsiMethodCall opsiMethodCall) {
        HashMap hashMap = new HashMap();
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = this.retrieveJSONObject(opsiMethodCall);
            if (this.checkResponse(jSONObject2) && (jSONObject = jSONObject2.optJSONObject("result")) != null) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    JSONArray jSONArray = jSONObject.optJSONArray(string);
                    ArrayList arrayList = new ArrayList(jSONArray.length());
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        JSONObject jSONObject3 = (JSONObject)jSONArray.get(i);
                        if (jSONObject3 != null) {
                            Iterator iterator2 = jSONObject3.keys();
                            while (iterator2.hasNext()) {
                                String string2 = (String)iterator2.next();
                                if (jSONObject3.isNull(string2)) continue;
                                hashMap2.put(string2, jSONObject3.get(string2));
                            }
                        }
                        arrayList.add(hashMap2);
                    }
                    hashMap.put(string, arrayList);
                }
            }
        }
        catch (Exception exception) {
            logging.error(this, "Exception on getting Map " + exception.toString());
        }
        return hashMap;
    }

    @Override
    public List<Map<String, Object>> getListOfMaps(OpsiMethodCall opsiMethodCall) {
        return JSONReMapper.getListOfMaps(this.retrieveJSONObject(opsiMethodCall));
    }

    @Override
    public List<Map<String, String>> getListOfStringMaps(OpsiMethodCall opsiMethodCall) {
        return JSONReMapper.getListOfStringMaps(this.retrieveJSONObject(opsiMethodCall));
    }

    @Override
    public List getListOfMapsOfListsOfMaps(OpsiMethodCall opsiMethodCall) {
        ArrayList arrayList = null;
        try {
            JSONArray jSONArray;
            JSONObject jSONObject = this.retrieveJSONObject(opsiMethodCall);
            if (this.checkResponse(jSONObject) && (jSONArray = jSONObject.optJSONArray("result")) != null) {
                arrayList = new ArrayList(jSONArray.length());
                for (int i = 0; i < jSONArray.length(); ++i) {
                    HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
                    JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
                    if (jSONObject2 != null) {
                        Iterator iterator = jSONObject2.keys();
                        while (iterator.hasNext()) {
                            Object object;
                            Object object2;
                            Cloneable cloneable;
                            String string = (String)iterator.next();
                            try {
                                JSONArray jSONArray2 = jSONObject2.optJSONArray(string);
                                cloneable = new ArrayList(jSONArray2.length());
                                for (int j = 0; j < jSONArray2.length(); ++j) {
                                    object2 = new HashMap();
                                    object = (JSONObject)jSONArray2.get(j);
                                    if (object != null) {
                                        Iterator iterator2 = ((JSONObject)object).keys();
                                        while (iterator2.hasNext()) {
                                            String string2 = (String)iterator2.next();
                                            if (((JSONObject)object).isNull(string2)) continue;
                                            ((HashMap)object2).put(string2, ((JSONObject)object).get(string2));
                                        }
                                    }
                                    ((ArrayList)cloneable).add(object2);
                                }
                                hashMap.put(string, cloneable);
                            }
                            catch (Exception exception) {
                                cloneable = new HashMap();
                                JSONObject jSONObject3 = (JSONObject)jSONObject2.get(string);
                                if (jSONObject3 != null) {
                                    object2 = jSONObject3.keys();
                                    while (object2.hasNext()) {
                                        object = (String)object2.next();
                                        if (jSONObject3.isNull((String)object)) continue;
                                        ((HashMap)cloneable).put(object, jSONObject3.get((String)object));
                                    }
                                }
                                hashMap.put(string, cloneable);
                            }
                        }
                    }
                    arrayList.add(hashMap);
                }
            }
        }
        catch (Exception exception) {
            logging.error(this, "Exception on getting ListOfMapsOfListsOfMaps " + exception.toString());
        }
        return arrayList;
    }

    @Override
    public String getStringResult(OpsiMethodCall opsiMethodCall) {
        String string = null;
        Object var3_3 = null;
        JSONObject jSONObject = this.retrieveJSONObject(opsiMethodCall);
        if (this.checkResponse(jSONObject)) {
            try {
                string = (String)jSONObject.get("result");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public boolean getBooleanResult(OpsiMethodCall opsiMethodCall) {
        Boolean bl = null;
        Object var3_3 = null;
        JSONObject jSONObject = this.retrieveJSONObject(opsiMethodCall);
        if (!JSONReMapper.checkForNotValidOpsiMethod(jSONObject)) {
            bl = this.getBooleanResult(opsiMethodCall.activateExtendedRpcPath());
        } else if (this.checkResponse(jSONObject)) {
            try {
                bl = (Boolean)jSONObject.get("result");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public String getStringValueFromItem(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    @Override
    public Map getMapFromItem(Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (object == null) {
            return hashMap;
        }
        try {
            JSONObject jSONObject = null;
            boolean bl = true;
            if (object instanceof JSONObject) {
                jSONObject = (JSONObject)object;
            } else {
                try {
                    jSONObject = new JSONObject("" + object);
                }
                catch (Exception exception) {
                    logging.debugOut("JSONExecutioner.getMapFromItem", 3, " \"" + object + "\"  " + " cannot be interpreted as a JSON Object, " + exception);
                    bl = false;
                }
            }
            if (bl && jSONObject != null && jSONObject != JSONObject.NULL) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashMap.put(string, jSONObject.get(string));
                }
            }
            if (!bl || jSONObject == JSONObject.NULL) {
                if (object == JSONObject.NULL) {
                    logging.debugOut("JSONExecutioner.getMapFromItem", 3, " \"" + object + "\" is  JSONObject.NULL and cannot be cast to a JSON Object");
                } else {
                    logging.debugOut("JSONExecutioner.getMapFromItem", 3, " \"" + object + "\" has class " + object.getClass().getName() + " cannot be cast to a JSON Object");
                }
            }
        }
        catch (Exception exception) {
            logging.error(this, "Exception on getting map from item  " + object + " : " + exception.toString());
        }
        return hashMap;
    }

    @Override
    public List getListFromItem(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string == null || string.equals("null")) {
            return arrayList;
        }
        try {
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.get(i));
            }
        }
        catch (Exception exception) {
            logging.error(this, "Exception on getting list from item    " + string + " : " + exception.toString());
        }
        return arrayList;
    }
}

