/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.type;

import de.uib.configed.configed;
import de.uib.configed.gui.MainFrame;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.utilities.logging.logging;
import de.uib.utilities.selectionpanel.JTableSelectionPanel;
import java.util.HashMap;
import java.util.Map;

public class HostInfo {
    protected String clientInDepot;
    protected String clientDescription;
    protected String clientInventoryNumber;
    protected String clientOneTimePassword;
    protected String clientNotes;
    protected String clientMacAddress;
    protected String lastSeen;
    protected String created;
    protected String clientName;
    protected String hostKey;
    protected String clientIpAddress;
    protected Boolean clientUefiBoot;
    protected Boolean clientWanConfig;
    public static final String clientInDepotKEY = "depotId";
    public static final String clientDescriptionKEY = "description";
    public static final String clientInventoryNumberKEY = "inventoryNumber";
    public static final String clientOneTimePasswordKEY = "oneTimePassword";
    public static final String clientNotesKEY = "notes";
    public static final String clientMacAddressKEY = "hardwareAddress";
    public static final String lastSeenKEY = "lastSeen";
    public static final String createdKEY = "created";
    public static final String clientNameKEY = "id";
    public static final String hostKeyKEY = "opsiHostKey";
    public static final String clientIpAddressKEY = "ipAddress";
    public static final String clientUefiBootKEY = "uefiBoot";
    public static final String clientWanConfigKEY = "wanConfig";

    public HostInfo() {
        this.initialize();
    }

    public HostInfo(Map<String, Object> map) {
        this.produceFrom(map);
    }

    public Map<String, Object> getMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(clientInDepotKEY, this.clientInDepot);
        hashMap.put(clientDescriptionKEY, this.clientDescription);
        hashMap.put(clientInventoryNumberKEY, this.clientInventoryNumber);
        hashMap.put(clientOneTimePasswordKEY, this.clientOneTimePassword);
        hashMap.put(clientNotesKEY, this.clientNotes);
        hashMap.put(clientMacAddressKEY, this.clientMacAddress);
        hashMap.put(lastSeenKEY, this.lastSeen);
        hashMap.put(createdKEY, this.created);
        hashMap.put(clientNameKEY, this.clientName);
        hashMap.put(hostKeyKEY, this.hostKey);
        hashMap.put(clientIpAddressKEY, this.clientIpAddress);
        hashMap.put(clientUefiBootKEY, this.clientUefiBoot);
        hashMap.put(clientWanConfigKEY, this.clientWanConfig);
        logging.debug(this, "getMap clientName " + this.clientName);
        return hashMap;
    }

    public void put(String string, Object object) {
        switch (string) {
            case "depotId": {
                this.clientInDepot = "" + object;
                break;
            }
            case "description": {
                this.clientDescription = "" + object;
                break;
            }
            case "inventoryNumber": {
                this.clientInventoryNumber = "" + object;
                break;
            }
            case "notes": {
                this.clientNotes = "" + object;
                break;
            }
            case "oneTimePassword": {
                this.clientOneTimePassword = "" + object;
                break;
            }
            case "hardwareAddress": {
                this.clientMacAddress = "" + object;
                break;
            }
            case "opsiHostKey": {
                this.hostKey = "" + object;
                break;
            }
            case "created": {
                this.created = "" + object;
                break;
            }
            case "lastSeen": {
                this.lastSeen = "" + object;
                break;
            }
            case "uefiBoot": {
                this.clientUefiBoot = (Boolean)object;
                break;
            }
            case "wanConfig": {
                this.clientWanConfig = (Boolean)object;
                break;
            }
            default: {
                logging.warning(this, "key " + string + " not expected");
            }
        }
    }

    public String getInDepot() {
        return this.clientInDepot;
    }

    public void setInDepot(String string) {
        this.clientInDepot = string;
    }

    public String getDescription() {
        return this.clientDescription;
    }

    public String getInventoryNumber() {
        return this.clientInventoryNumber;
    }

    public String getOneTimePassword() {
        return this.clientOneTimePassword;
    }

    public String getNotes() {
        return this.clientNotes;
    }

    public String getMacAddress() {
        return this.clientMacAddress;
    }

    public String getLastSeen() {
        return this.lastSeen;
    }

    public String getCreated() {
        return this.created;
    }

    public String getName() {
        return this.clientName;
    }

    public String getHostKey() {
        return this.hostKey;
    }

    public String getIpAddress() {
        return this.clientIpAddress;
    }

    public Boolean getUefiBoot() {
        return this.clientUefiBoot;
    }

    public Boolean getWanConfig() {
        return this.clientWanConfig;
    }

    public void setUefiBoot(boolean bl) {
        this.clientUefiBoot = bl;
    }

    public void setWanConfig(boolean bl) {
        this.clientWanConfig = bl;
    }

    private String showValue(String string) {
        if (string == null || string.equals("null")) {
            return "";
        }
        return string;
    }

    private boolean showValue(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void produceFrom(Map<String, Object> map) {
        if (map == null) {
            this.initialize();
            return;
        }
        this.clientDescription = this.showValue(configed.encodeStringFromService((String)map.get(clientDescriptionKEY)));
        this.clientInventoryNumber = this.showValue(configed.encodeStringFromService((String)map.get(clientInventoryNumberKEY)));
        this.clientNotes = this.showValue(configed.encodeStringFromService((String)map.get(clientNotesKEY)));
        this.clientOneTimePassword = this.showValue(configed.encodeStringFromService((String)map.get(clientOneTimePasswordKEY)));
        this.clientMacAddress = this.showValue((String)map.get(clientMacAddressKEY));
        this.clientIpAddress = this.showValue((String)map.get(clientIpAddressKEY));
        this.hostKey = this.showValue((String)map.get(hostKeyKEY));
        this.clientName = this.showValue((String)map.get(clientNameKEY));
        this.created = this.showValue((String)map.get(createdKEY));
        this.lastSeen = this.showValue((String)map.get(lastSeenKEY));
        this.clientUefiBoot = this.showValue((Boolean)map.get(clientUefiBootKEY));
        this.clientWanConfig = this.showValue((Boolean)map.get(clientWanConfigKEY));
    }

    public void setMap(Map<String, Object> map) {
        logging.debug(this, "setMap " + map);
        this.initialize();
        if (map == null) {
            return;
        }
        this.clientUefiBoot = this.showValue((Boolean)map.get(clientUefiBootKEY));
        this.clientWanConfig = this.showValue((Boolean)map.get(clientWanConfigKEY));
        this.clientDescription = this.showValue("" + map.get(clientDescriptionKEY));
        this.clientInventoryNumber = this.showValue("" + map.get(clientInventoryNumberKEY));
        this.clientNotes = this.showValue("" + map.get(clientNotesKEY));
        this.clientOneTimePassword = this.showValue("" + map.get(clientOneTimePasswordKEY));
        this.clientMacAddress = this.showValue("" + map.get(clientMacAddressKEY));
        this.clientIpAddress = this.showValue("" + map.get(clientIpAddressKEY));
        this.hostKey = this.showValue("" + map.get(hostKeyKEY));
        this.clientName = this.showValue("" + map.get(clientNameKEY));
        this.created = this.showValue("" + map.get(createdKEY));
        this.lastSeen = this.showValue("" + map.get(lastSeenKEY));
    }

    private int findCol(JTableSelectionPanel jTableSelectionPanel, String string) {
        return jTableSelectionPanel.getTableModel().findColumn(configed.getResourceValue("ConfigedMain.pclistTableModel.clientDescription"));
    }

    private int findRow(JTableSelectionPanel jTableSelectionPanel, String string) {
        return jTableSelectionPanel.findModelRowFromValue(string, 0);
    }

    public void resetGui(MainFrame mainFrame) {
        mainFrame.setClientDescriptionText(this.clientDescription);
        mainFrame.setClientInventoryNumberText(this.clientInventoryNumber);
        mainFrame.setClientNotesText(this.clientNotes);
        mainFrame.setClientMacAddress(this.clientMacAddress);
        mainFrame.setClientOneTimePasswordText(this.clientOneTimePassword);
        mainFrame.setUefiBoot(this.clientUefiBoot);
        mainFrame.setWANConfig(this.clientWanConfig);
    }

    public void showAndSave(JTableSelectionPanel jTableSelectionPanel, MainFrame mainFrame, PersistenceController persistenceController, String string, Map<String, String> map) {
        logging.info(this, "showAndSave client, source " + string + ", " + map);
        int n = this.findRow(jTableSelectionPanel, string);
        if (map == null) {
            return;
        }
        if (map.get(clientDescriptionKEY) != null) {
            this.clientDescription = map.get(clientDescriptionKEY);
            int bl = this.findCol(jTableSelectionPanel, configed.getResourceValue("ConfigedMain.pclistTableModel.clientDescription"));
            jTableSelectionPanel.getTableModel().setValueAt(this.clientDescription, n, bl);
            mainFrame.setClientDescriptionText(this.clientDescription);
            persistenceController.setHostDescription(string, configed.encodeStringForService(this.clientDescription));
            persistenceController.getHostInfoCollections().updateLocalHostInfo(string, clientDescriptionKEY, this.clientDescription);
        }
        if (map.get(clientInventoryNumberKEY) != null) {
            this.clientInventoryNumber = map.get(clientInventoryNumberKEY);
            int n2 = this.findCol(jTableSelectionPanel, configed.getResourceValue("ConfigedMain.pclistTableModel.clientInventoryNumber"));
            jTableSelectionPanel.getTableModel().setValueAt(this.clientDescription, n, n2);
            mainFrame.setClientInventoryNumberText(this.clientInventoryNumber);
            persistenceController.setClientInventoryNumber(string, configed.encodeStringForService(this.clientInventoryNumber));
            persistenceController.getHostInfoCollections().updateLocalHostInfo(string, clientInventoryNumberKEY, this.clientInventoryNumber);
        }
        if (map.get(clientOneTimePasswordKEY) != null) {
            this.clientOneTimePassword = map.get(clientOneTimePasswordKEY);
            mainFrame.setClientOneTimePasswordText(this.clientOneTimePassword);
            persistenceController.setClientOneTimePassword(string, configed.encodeStringForService(this.clientOneTimePassword));
            persistenceController.getHostInfoCollections().updateLocalHostInfo(string, clientOneTimePasswordKEY, this.clientOneTimePassword);
        }
        if (map.get(clientNotesKEY) != null) {
            this.clientNotes = map.get(clientNotesKEY);
            mainFrame.setClientNotesText(this.clientNotes);
            persistenceController.setHostNotes(string, configed.encodeStringForService(this.clientNotes));
            persistenceController.getHostInfoCollections().updateLocalHostInfo(string, clientNotesKEY, this.clientNotes);
        }
        if (map.get(clientMacAddressKEY) != null && !map.get(clientMacAddressKEY).trim().equals("")) {
            this.clientMacAddress = map.get(clientMacAddressKEY).trim();
            mainFrame.setClientMacAddress(this.clientMacAddress);
            persistenceController.setMacAddress(string, this.clientMacAddress);
            persistenceController.getHostInfoCollections().updateLocalHostInfo(string, clientMacAddressKEY, this.clientMacAddress);
        }
        persistenceController.updateHosts();
        if (map.get(clientUefiBootKEY) != null) {
            boolean bl;
            boolean bl2 = false;
            if (map.get(clientUefiBootKEY).equals("true")) {
                bl = true;
            }
            persistenceController.configureUefiBoot(string, bl);
            persistenceController.getHostInfoCollections().updateLocalHostInfo(string, clientUefiBootKEY, bl);
        }
        if (map.get(clientWanConfigKEY) != null) {
            boolean bl;
            boolean bl3 = false;
            if (map.get(clientWanConfigKEY).equals("true")) {
                bl = true;
            }
            if (!persistenceController.setWANConfigs(string, bl)) {
                logging.error(this, "wan settings could not be set");
            }
            persistenceController.getHostInfoCollections().updateLocalHostInfo(string, clientWanConfigKEY, bl);
        }
    }

    public String toString() {
        String string = "(" + this.clientName + ";" + this.clientInDepot + ";" + this.clientDescription + ";" + this.clientInventoryNumber + ";" + this.clientOneTimePassword + ";" + this.clientNotes + ";" + this.clientMacAddress + ";" + this.clientIpAddress + ";" + this.lastSeen + ";" + this.created + ";" + this.clientUefiBoot + ";" + this.clientWanConfig + ")";
        return string;
    }

    public void initialize() {
        this.clientInDepot = "";
        this.clientDescription = "";
        this.clientInventoryNumber = "";
        this.clientOneTimePassword = "";
        this.clientNotes = "";
        this.clientMacAddress = "";
        this.clientIpAddress = "";
        this.lastSeen = "";
        this.created = "";
        this.clientUefiBoot = false;
        this.clientWanConfig = false;
    }
}

