/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.tree;

import java.awt.Image;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class IconNode
extends DefaultMutableTreeNode {
    private Icon closedIcon;
    private Icon disabledClosedIcon;
    private Icon enabledClosedIcon;
    private Icon leafIcon;
    private Icon disabledLeafIcon;
    private Icon enabledLeafIcon;
    private Icon nonSelectedLeafIcon;
    private Icon openIcon;
    private Icon disabledOpenIcon;
    private Icon enabledOpenIcon;
    private Icon emphasizedIcon;
    protected String toolTipText = null;
    protected boolean emphasized = false;
    private Map deviceInfo = null;

    public IconNode(Object object, boolean bl) {
        super(object, bl);
    }

    public IconNode(Object object) {
        this(object, true);
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setDeviceInfo(Map map) {
        this.deviceInfo = map;
    }

    public Map getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            if (this.closedIcon != null & this.disabledClosedIcon == null) {
                this.disabledClosedIcon = this.createDisabledIcon(this.enabledClosedIcon);
            }
            this.setDisabledLeafIcon();
            if (this.openIcon != null & this.disabledOpenIcon == null) {
                this.disabledOpenIcon = this.createDisabledIcon(this.enabledOpenIcon);
            }
            this.closedIcon = this.disabledClosedIcon;
            this.leafIcon = this.disabledLeafIcon;
            this.openIcon = this.disabledOpenIcon;
        } else {
            this.closedIcon = this.enabledClosedIcon;
            this.leafIcon = this.enabledLeafIcon;
            this.openIcon = this.enabledOpenIcon;
        }
    }

    private Icon createDisabledIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            Image image = GrayFilter.createDisabledImage(((ImageIcon)icon).getImage());
            return new ImageIcon(image);
        }
        return null;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setIcon(Icon icon) {
        this.setClosedIcon(icon);
        this.setLeafIcon(icon);
        this.setOpenIcon(icon);
        this.setNonSelectedLeafIcon(icon);
        this.setEmphasizedIcon(icon);
        this.setDisabledLeafIcon();
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
        this.enabledClosedIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setNonSelectedLeafIcon(Icon icon) {
        this.nonSelectedLeafIcon = icon;
    }

    public Icon getNonSelectedLeafIcon() {
        if (this.nonSelectedLeafIcon == null && this.leafIcon != null) {
            this.nonSelectedLeafIcon = this.createDisabledIcon(this.leafIcon);
        }
        return this.nonSelectedLeafIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
        this.enabledLeafIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
        this.enabledOpenIcon = icon;
    }

    public void setDisabledLeafIcon() {
        if (this.leafIcon != null) {
            this.disabledLeafIcon = this.createDisabledIcon(this.leafIcon);
        }
    }

    public void setEmphasizedIcon(Icon icon) {
        if (icon != null) {
            this.emphasizedIcon = icon;
        }
    }

    public Icon getEmphasizedIcon() {
        return this.emphasizedIcon;
    }

    public void setEmphasized(boolean bl) {
        this.emphasized = bl;
    }

    public boolean isEmphasized() {
        return this.emphasized;
    }
}

