/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.productpage;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.productpage.DefaultPanelEditProperties;
import de.uib.configed.guidata.RequirementsTableModel;
import de.uib.configed.type.OpsiPackage;
import de.uib.configed.type.OpsiProductInfo;
import de.uib.utilities.DataChangedObserver;
import de.uib.utilities.datapanel.EditMapPanelX;
import de.uib.utilities.logging.logging;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.jdesktop.swingx.JXPanel;

public class ProductInfoPane
extends JSplitPane
implements DataChangedObserver {
    private JXPanel productDescriptionsPanel;
    public JLabel jLabelPackageVersion;
    private JLabel jLabelProductAdvice;
    private JLabel jLabelProductDescription;
    protected JLabel jLabelProductID;
    protected JLabel jLabelProductVersion;
    protected JLabel jLabelLabelProductVersion;
    protected JLabel jLabelProductName;
    private JLabel jLabelProductDependencies;
    private DefaultPanelEditProperties panelEditProperties;
    private JScrollPane jScrollPaneProductAdvice;
    private JScrollPane jScrollPaneProductInfo;
    private JScrollPane dependenciesPanel;
    protected JTable dependenciesTable;
    protected RequirementsTableModel dependenciesTableModel;
    protected JTextArea jTextAreaProductAdvice;
    protected JTextArea jTextAreaProductInfo;
    private int minLabelVSize = 0;
    private int minTableVSize = 40;
    private int minGapVSize = 2;
    private int minVSize = 10;
    private int prefVSize = 20;
    private int vGapSize = 5;
    private int hGapSize = 2;
    private int minHSize = 50;
    private int prefHSize = 80;
    protected String productName = "";
    Map<String, Boolean> specificPropertiesExisting;
    protected ConfigedMain mainController;

    public ProductInfoPane(ConfigedMain configedMain, DefaultPanelEditProperties defaultPanelEditProperties) {
        super(0);
        this.mainController = configedMain;
        this.panelEditProperties = defaultPanelEditProperties;
        this.initComponents();
    }

    public ProductInfoPane(DefaultPanelEditProperties defaultPanelEditProperties) {
        this(null, defaultPanelEditProperties);
    }

    private void initComponents() {
        this.jLabelProductName = new JLabel();
        this.jLabelProductID = new JLabel();
        this.jLabelProductVersion = new JLabel();
        this.jLabelLabelProductVersion = new JLabel();
        this.jLabelProductDescription = new JLabel();
        this.jScrollPaneProductInfo = new JScrollPane();
        this.jTextAreaProductInfo = new JTextArea();
        this.jLabelProductAdvice = new JLabel();
        this.jScrollPaneProductAdvice = new JScrollPane();
        this.jTextAreaProductAdvice = new JTextArea();
        this.jLabelProductDependencies = new JLabel();
        this.dependenciesPanel = new JScrollPane();
        this.dependenciesTable = new JTable();
        this.jLabelProductID.setText(" ");
        this.jLabelProductID.setFont(Globals.defaultFontStandardBold);
        this.jLabelProductName.setText(" ");
        this.jLabelProductName.setFont(Globals.defaultFontBold);
        this.jLabelLabelProductVersion.setText("");
        this.jLabelLabelProductVersion.setFont(Globals.defaultFontBig);
        this.jLabelLabelProductVersion.setText(configed.getResourceValue("ProductInfoPane.jLabelProductVersion") + " ");
        this.jLabelProductVersion.setFont(Globals.defaultFontStandardBold);
        this.jLabelProductDescription.setFont(Globals.defaultFontStandardBold);
        this.jLabelProductDescription.setPreferredSize(new Dimension(this.prefHSize, 28));
        this.jLabelProductDescription.setText(configed.getResourceValue("ProductInfoPane.jLabelProductDescription"));
        this.jTextAreaProductInfo.setColumns(20);
        this.jTextAreaProductInfo.setRows(5);
        this.jTextAreaProductInfo.setEditable(false);
        this.jTextAreaProductInfo.setWrapStyleWord(true);
        this.jTextAreaProductInfo.setLineWrap(true);
        this.jTextAreaProductInfo.setFont(Globals.defaultFont);
        this.jTextAreaProductInfo.setBackground(Globals.backgroundLightGrey);
        this.jScrollPaneProductInfo.setViewportView(this.jTextAreaProductInfo);
        this.jScrollPaneProductInfo.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneProductInfo.setVerticalScrollBarPolicy(20);
        this.jLabelProductAdvice.setText(configed.getResourceValue("ProductInfoPane.jLabelProductAdvice"));
        this.jLabelProductAdvice.setFont(Globals.defaultFontStandardBold);
        this.jTextAreaProductAdvice.setColumns(20);
        this.jTextAreaProductAdvice.setRows(5);
        this.jTextAreaProductAdvice.setEditable(false);
        this.jTextAreaProductAdvice.setWrapStyleWord(true);
        this.jTextAreaProductAdvice.setLineWrap(true);
        this.jTextAreaProductAdvice.setFont(Globals.defaultFont);
        this.jTextAreaProductAdvice.setBackground(Globals.backgroundLightGrey);
        this.jScrollPaneProductAdvice.setViewportView(this.jTextAreaProductAdvice);
        this.jScrollPaneProductAdvice.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneProductAdvice.setVerticalScrollBarPolicy(20);
        this.jLabelProductDependencies.setText(configed.getResourceValue("ProductInfoPane.jLabelProductDependencies") + ": ");
        this.jLabelProductDependencies.setFont(Globals.defaultFontBig);
        this.dependenciesTable.setBackground(Globals.backgroundLightGrey);
        this.dependenciesPanel.setViewportView(this.dependenciesTable);
        this.dependenciesPanel.getViewport().setBackground(Globals.backgroundLightGrey);
        this.productDescriptionsPanel = new JXPanel();
        GroupLayout groupLayout = new GroupLayout(this.productDescriptionsPanel);
        this.productDescriptionsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelProductID, this.minHSize, this.prefHSize, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelLabelProductVersion, this.minHSize, -2, -2).addComponent(this.jLabelProductVersion, this.minHSize, this.prefHSize, Short.MAX_VALUE).addGap(5, 5, 5)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelProductName, this.minHSize, this.prefHSize, Short.MAX_VALUE).addGap(5, 5, 5)).addComponent(this.jScrollPaneProductInfo, this.minHSize, this.prefHSize, Short.MAX_VALUE).addComponent(this.jScrollPaneProductAdvice, this.minHSize, this.prefHSize, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelProductDependencies, this.minHSize, this.prefHSize, Short.MAX_VALUE).addGap(5, 5, 5)).addComponent(this.dependenciesPanel, this.minHSize, this.prefHSize, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelProductID, this.minLabelVSize, this.prefVSize, -2).addGap(this.minGapVSize, this.minGapVSize, this.minGapVSize).addComponent(this.jLabelProductName, this.minLabelVSize, 24, 24).addGap(this.minGapVSize, this.minGapVSize, this.minGapVSize).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelLabelProductVersion, this.minLabelVSize, 24, 24).addComponent(this.jLabelProductVersion, this.minLabelVSize, 24, 24)).addGap(this.vGapSize, this.vGapSize, this.vGapSize).addComponent(this.jScrollPaneProductInfo, this.minVSize, this.prefVSize, 4 * this.prefVSize).addGap(this.vGapSize, 2 * this.vGapSize, 2 * this.vGapSize).addComponent(this.jScrollPaneProductAdvice, this.minVSize, this.prefVSize, 4 * this.prefVSize).addGap(this.vGapSize, this.vGapSize, this.vGapSize).addComponent(this.jLabelProductDependencies, 24, 24, 24).addComponent(this.dependenciesPanel, 3 * this.minVSize, 3 * this.prefVSize, 10 * this.prefVSize).addGap(this.minGapVSize, this.vGapSize, this.vGapSize)));
        this.setTopComponent(this.productDescriptionsPanel);
        this.setTopComponent(this.productDescriptionsPanel);
        this.setBottomComponent(this.panelEditProperties);
        this.setDividerLocation(250);
    }

    protected String fillEmpty(String string) {
        if (string == null || string.equals("") || string.equals("-")) {
            return " ";
        }
        return string;
    }

    public JTable getDependenciesTable() {
        return this.dependenciesTable;
    }

    public void setAdvice(String string) {
        this.jTextAreaProductAdvice.setText(string);
    }

    public void setInfo(String string) {
        this.jTextAreaProductInfo.setText(string);
        this.jTextAreaProductInfo.setCaretPosition(0);
    }

    public void setId(String string) {
        this.jLabelProductID.setText(string);
        this.productName = string;
    }

    public void setProductVersion(String string) {
        this.jLabelProductVersion.setText(this.fillEmpty(string));
    }

    public void setID(String string) {
        this.jLabelProductID.setText(string + ":");
        this.productName = string;
    }

    @Override
    public void setName(String string) {
        this.jLabelProductName.setText(string);
    }

    public void setSpecificPropertiesExisting(Map<String, Boolean> map) {
        this.panelEditProperties.setSpecificPropertiesExisting(this.productName, map);
    }

    protected void setPropertyResetActivated(boolean bl) {
        this.panelEditProperties.setPropertyResetActivated(bl);
    }

    public void setGrey(boolean bl) {
        float f = 1.0f;
        if (bl) {
            f = 0.1f;
        }
        this.productDescriptionsPanel.setAlpha(f);
        this.panelEditProperties.setAlpha(f);
    }

    public void setEditValues(String string, String string2, String string3, String string4) {
        this.setGrey(false);
        this.setId(string);
        this.setProductVersion(string2 + "-" + string3);
        if (this.mainController != null) {
            String string5 = OpsiPackage.produceVersionInfo(string2, string3);
            OpsiProductInfo opsiProductInfo = this.mainController.getPersistenceController().getProduct2versionInfo2infos().get(string).get(string5);
            logging.info(this, "got product infos  productId, versionInfo:  " + string + ", " + string5 + ": " + opsiProductInfo);
            this.setName(opsiProductInfo.getProductName());
            this.setInfo(opsiProductInfo.getDescription());
            this.setAdvice(opsiProductInfo.getAdvice());
            if (this.dependenciesTableModel == null) {
                this.dependenciesTableModel = new RequirementsTableModel(this.mainController.getPersistenceController());
                this.dependenciesTable.setModel(this.dependenciesTableModel);
            }
            this.dependenciesTableModel.setActualProduct(string4, string);
        }
    }

    public void clearEditing() {
        this.setGrey(false);
        this.setId("");
        this.setProductVersion("");
        this.setName("");
        this.setInfo("");
        this.dependenciesTableModel = new RequirementsTableModel(this.mainController.getPersistenceController());
        this.dependenciesTable.setModel(this.dependenciesTableModel);
    }

    @Override
    public void dataHaveChanged(Object object) {
        if (object instanceof EditMapPanelX) {
            this.specificPropertiesExisting.put(this.productName, true);
            this.setPropertyResetActivated(true);
        }
    }
}

